/******************************************************************************
  Copyright (c) 2007-2025, Intel Corp.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of Intel Corporation nor the names of its contributors
      may be used to endorse or promote products derived from this software
      without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.
******************************************************************************/

#include "endian.h"



    static const TABLE_UNION TABLE_NAME[] = { 

	/* j0 class-to-action-mapping */
	/* 000 */ DATA_1x2( 0x00451408, 0x34924920 ),

	/* j1 class-to-action-mapping */
	/* 008 */ DATA_1x2( 0x00451408, 0x24100000 ),

	/* jn class-to-action-mapping */
	/* 016 */ DATA_1x2( 0x00451408, 0x16100000 ),

	/* Data for the above mappings */
	/* 024 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 032 */ DATA_1x2( 0x00000001, 0x00000000 ),

	/* y0 class-to-action-mapping */
	/* 040 */ DATA_1x2( 0x80e91408, 0x3efbe80e ),

	/* y1 class-to-action-mapping */
	/* 048 */ DATA_1x2( 0x00f11408, 0x2f7df00f ),

	/* yn class-to-action-mapping */
	/* 056 */ DATA_1x2( 0x80f91408, 0x1ffff80f ),

	/* Data for the above mappings */
	/* 064 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 072 */ DATA_1x2( 0x0000007e, 0x00000000 ),
	/* 080 */ DATA_1x2( 0x0000007f, 0x00000000 ),
	/* 088 */ DATA_1x2( 0x00000080, 0x00000000 ),
	/* 096 */ DATA_1x2( 0x00000081, 0x00000000 ),
	/* 104 */ DATA_1x2( 0x00000083, 0x00000000 ),
	/* 112 */ DATA_1x2( 0x00000084, 0x00000000 ),

	/* Interval polynomial coefficients for j0 */

	/* Data for interval 0 : [ 0.0, 3.83171 ) - zero = 2.40483 */
	/* 120 */ DATA_1x2( 0xaf6f08a7, 0x1ea75575 ),
	/* 128 */ DATA_1x2( 0x00c3f1ec, 0xf8000240 ),
	/* 136 */ DATA_2x2( 0xb8d9fde1, 0x99e8a974, 0x4e34dc88, 0x58c504bb ),
	/* 152 */ DATA_2x2( 0x012bbfbc, 0x02b78b0e, 0x7aa17fda, 0xbce49bbb ),
	/* degree = 30 - unpacked coefficients */
	/* 168 */ DATA_4( 0xb4ecc41a, 0x3546f7f4, 0x00000151, 0x00000000 ),
	/* 184 */ DATA_4( 0x6a5015a3, 0x69f30016, 0x00003c50, 0x00000000 ),
	/* 200 */ DATA_4( 0x4172846a, 0xb3fb7a1a, 0x000c6cb2, 0x00000000 ),
	/* 216 */ DATA_4( 0x0d7244dd, 0xed6c8106, 0x0237d083, 0x00000000 ),
	/* 232 */ DATA_4( 0xaa0c9e85, 0xa941bff5, 0x56f06fb0, 0x00000000 ),
	/* 248 */ DATA_4( 0xf67c84d6, 0x80598a29, 0x45df2082, 0x0000000b ),
	/* 264 */ DATA_4( 0x548d4308, 0x43a46efd, 0x2933550f, 0x00000138 ),
	/* 280 */ DATA_4( 0x0d3b713e, 0xaf5f9193, 0x352d8622, 0x00001baa ),
	/* 296 */ DATA_4( 0x0af06bd4, 0x41096fd7, 0x0201c12a, 0x0001f70b ),
	/* 312 */ DATA_4( 0x7af47b4e, 0xd62ff12f, 0x8c1a8179, 0x001bdc46 ),
	/* 328 */ DATA_4( 0xc13d5dc1, 0x674b1335, 0x4726a936, 0x012951bd ),
	/* 344 */ DATA_4( 0x3dde8670, 0xc085f1fd, 0x410c22d0, 0x08e67181 ),
	/* 360 */ DATA_4( 0x33953eef, 0xa00e6b64, 0x0fd65095, 0x2dda773e ),
	/* 376 */ DATA_4( 0x29b7dbfd, 0x11e20cef, 0x6895e7c1, 0x8fcc92c8 ),
	/* 392 */ DATA_4( 0x4fdb6def, 0x3179fb8f, 0xb46b8379, 0xe7d74321 ),
	/* 408 */ DATA_4( 0xf4911bd1, 0x1987ad75, 0xa8940359, 0x84e6d9b2 ),
	/* 424 */ DATA_1x2( 0x00000002, 0x00000000 ),
	/* 432 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 448 */ DATA_4( 0x15e5d73c, 0x004203d1, 0x00000864, 0x00000000 ),
	/* 464 */ DATA_4( 0xce73975b, 0x291d1bc4, 0x0001c4cb, 0x00000000 ),
	/* 480 */ DATA_4( 0x6f335599, 0x65c00689, 0x00565a90, 0x00000000 ),
	/* 496 */ DATA_4( 0x036e6529, 0xad21b3d6, 0x0e32d1c3, 0x00000000 ),
	/* 512 */ DATA_4( 0x95653040, 0xf0bdbef9, 0xfce24eb0, 0x00000001 ),
	/* 528 */ DATA_4( 0x35a86e72, 0x7ade3e27, 0xcfb9abcd, 0x0000003b ),
	/* 544 */ DATA_4( 0xb47c1ea7, 0xc56fd79f, 0x84abf576, 0x000005cd ),
	/* 560 */ DATA_4( 0x9be94275, 0xa87d35dd, 0x63bdc3c6, 0x0000748b ),
	/* 576 */ DATA_4( 0x152a7dd2, 0x8f592594, 0x3c92288b, 0x00073507 ),
	/* 592 */ DATA_4( 0x599cadce, 0x8268eac9, 0x2ca89e31, 0x00570b0e ),
	/* 608 */ DATA_4( 0xbb9d0b42, 0x9f7182fc, 0xcd841700, 0x02fff322 ),
	/* 624 */ DATA_4( 0xe675576a, 0x7f0be4d4, 0x228ab60b, 0x1232c77d ),
	/* 640 */ DATA_4( 0x43f3a0a3, 0xa2298a96, 0x1b311c20, 0x454e0ae8 ),
	/* 656 */ DATA_4( 0xc0b40139, 0x7a5518ae, 0xd20389a8, 0x8dd8e5f0 ),
	/* 672 */ DATA_4( 0xf8767e04, 0xf4ee9f16, 0x0a524e4a, 0x6e877ba8 ),
	/* 688 */ DATA_1x2( 0x00000002, 0x00000000 ),

	/* Data for interval 1 : [ 3.83171, 7.01559 ) - zero = 5.52008 */
	/* 696 */ DATA_1x2( 0x68e49fc9, 0x381febe7 ),
	/* 704 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 712 */ DATA_2x2( 0x617228ba, 0xb0a47ad9, 0x28b7da70, 0x82a66b05 ),
	/* 728 */ DATA_2x2( 0x5e2ea8a2, 0xebd9e402, 0x7bc5d903, 0x2a96c5c0 ),
	/* degree = 28 - unpacked coefficients */
	/* 744 */ DATA_4( 0x54f06c61, 0x00087bea, 0x00000000, 0x00000000 ),
	/* 760 */ DATA_4( 0xa149c8af, 0x06a87135, 0x00000000, 0x00000000 ),
	/* 776 */ DATA_4( 0xdd54985d, 0xc1d95c0c, 0x00000004, 0x00000000 ),
	/* 792 */ DATA_4( 0x7d35dc3b, 0x4ad80a92, 0x000002eb, 0x00000000 ),
	/* 808 */ DATA_4( 0xd7c4a07c, 0xae69f06e, 0x0001845c, 0x00000000 ),
	/* 824 */ DATA_4( 0x95c73782, 0xfb629a9a, 0x00a85f40, 0x00000000 ),
	/* 840 */ DATA_4( 0x8b41839f, 0xff483678, 0x3bcd15e8, 0x00000000 ),
	/* 856 */ DATA_4( 0x395366fc, 0x347a0697, 0x0477aeae, 0x00000011 ),
	/* 872 */ DATA_4( 0x26d73650, 0xed2a7958, 0xe671354b, 0x000003c5 ),
	/* 888 */ DATA_4( 0x5f23871f, 0x72b8c2f9, 0x96c9c970, 0x0000a0eb ),
	/* 904 */ DATA_4( 0xf6f80399, 0x3984be16, 0x99c6af7d, 0x00132e6d ),
	/* 920 */ DATA_4( 0xc1e200ff, 0x90c2d6d2, 0x1a430362, 0x01863f48 ),
	/* 936 */ DATA_4( 0x79702192, 0xdda120f7, 0x9a9778f1, 0x127e31fe ),
	/* 952 */ DATA_4( 0xd166b2e3, 0xecacb4ba, 0x07a30336, 0x6c85432d ),
	/* 968 */ DATA_4( 0xcad1979e, 0xe80871a7, 0x4bc11650, 0xae373050 ),
	/* 984 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 992 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 1008 */ DATA_4( 0x766e6b6b, 0x032cc3e5, 0x00000000, 0x00000000 ),
	/* 1024 */ DATA_4( 0xc2ec93f0, 0x732cc8a4, 0x00000002, 0x00000000 ),
	/* 1040 */ DATA_4( 0xf372338c, 0xb7cd43c5, 0x00000199, 0x00000000 ),
	/* 1056 */ DATA_4( 0x9828c6cc, 0xf203a6d9, 0x0000e38e, 0x00000000 ),
	/* 1072 */ DATA_4( 0xe43bf22d, 0x4e152963, 0x0069e8f3, 0x00000000 ),
	/* 1088 */ DATA_4( 0xb7c71631, 0xb781e2e3, 0x28967103, 0x00000000 ),
	/* 1104 */ DATA_4( 0xc9cef66d, 0xd7483294, 0x88d46bc0, 0x0000000c ),
	/* 1120 */ DATA_4( 0xbd0ab74c, 0xac52eb54, 0x31ffbd7b, 0x00000309 ),
	/* 1136 */ DATA_4( 0xe0cb560a, 0x446fde09, 0x19ecd072, 0x00008e82 ),
	/* 1152 */ DATA_4( 0x176ec446, 0x04cc168f, 0xe38435b9, 0x0012da37 ),
	/* 1168 */ DATA_4( 0x23699913, 0x03e24d7d, 0x48a06db6, 0x01ad77d7 ),
	/* 1184 */ DATA_4( 0xd2cc8185, 0x1666a048, 0x1956f759, 0x16f641f4 ),
	/* 1200 */ DATA_4( 0x25be7057, 0x26b48893, 0x12b5d615, 0x97bfff48 ),
	/* 1216 */ DATA_4( 0x34095ed6, 0x1940b659, 0x4247012c, 0xfc7b973d ),
	/* 1232 */ DATA_1x2( 0x000000-3, 0x00000000 ),

	/* Data for interval 2 : [ 7.01559, 10.17347 ) - zero = 8.65373 */
	/* 1240 */ DATA_1x2( 0xf7f0a502, 0x51634342 ),
	/* 1248 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 1256 */ DATA_2x2( 0x66f64eae, 0x8a75ab66, 0x3dad85c4, 0x68f8eb38 ),
	/* 1272 */ DATA_2x2( 0x2c9725ce, 0x28a2e786, 0x73fd635c, 0x3dd7456c ),
	/* degree = 28 - unpacked coefficients */
	/* 1288 */ DATA_4( 0xa2c9e0c5, 0x000887d2, 0x00000000, 0x00000000 ),
	/* 1304 */ DATA_4( 0xd8dbd769, 0x06e6bb5f, 0x00000000, 0x00000000 ),
	/* 1320 */ DATA_4( 0x1ce7447e, 0xef3ee15c, 0x00000004, 0x00000000 ),
	/* 1336 */ DATA_4( 0x33c26e4c, 0x06569f06, 0x00000307, 0x00000000 ),
	/* 1352 */ DATA_4( 0xe0c53bca, 0x634f8aa1, 0x00019288, 0x00000000 ),
	/* 1368 */ DATA_4( 0x1c0d7ce8, 0x7d2be021, 0x00ae4bae, 0x00000000 ),
	/* 1384 */ DATA_4( 0x4c3fd10e, 0x6aa0d38b, 0x3dc392c7, 0x00000000 ),
	/* 1400 */ DATA_4( 0xb6cfae78, 0xe7ab962b, 0x820d4a50, 0x00000011 ),
	/* 1416 */ DATA_4( 0x062fa660, 0x071ee77b, 0x5f7da380, 0x000003db ),
	/* 1432 */ DATA_4( 0x12b8a628, 0xf59a117d, 0x6590bd07, 0x0000a2c1 ),
	/* 1448 */ DATA_4( 0xbbf67aec, 0x697f1860, 0xc35f2086, 0x00130e8c ),
	/* 1464 */ DATA_4( 0x93df025a, 0x154fdd74, 0x550673ba, 0x017800bc ),
	/* 1480 */ DATA_4( 0x3725aacb, 0xe6fe2632, 0x85a6f01e, 0x10e0d603 ),
	/* 1496 */ DATA_4( 0x47ed8ae0, 0x68063312, 0x1924eeb2, 0x5a2e613b ),
	/* 1512 */ DATA_4( 0x210d6ed8, 0xf5d4ff2e, 0x3b969de8, 0x8afbcbbd ),
	/* 1528 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 1536 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 1552 */ DATA_4( 0x325be5b8, 0x02e9d02f, 0x00000000, 0x00000000 ),
	/* 1568 */ DATA_4( 0x2493323d, 0x3c99875e, 0x00000002, 0x00000000 ),
	/* 1584 */ DATA_4( 0x2bbcc3ce, 0xf0a73f7d, 0x00000172, 0x00000000 ),
	/* 1600 */ DATA_4( 0x95b4046d, 0x39657337, 0x0000cbf1, 0x00000000 ),
	/* 1616 */ DATA_4( 0x93340c1d, 0xfbe94c1d, 0x005dbfe4, 0x00000000 ),
	/* 1632 */ DATA_4( 0x7ad41bad, 0xd57bc3d3, 0x2360b2e6, 0x00000000 ),
	/* 1648 */ DATA_4( 0xa940e683, 0xfbadb170, 0xb6a55fd1, 0x0000000a ),
	/* 1664 */ DATA_4( 0x234df2ee, 0x10675131, 0x8461ce9e, 0x00000287 ),
	/* 1680 */ DATA_4( 0xcddf8e82, 0x4196ed3f, 0x867d776c, 0x000072b7 ),
	/* 1696 */ DATA_4( 0x398fd1ba, 0x1456e80d, 0x3cd09e2a, 0x000e76d2 ),
	/* 1712 */ DATA_4( 0x80538185, 0x51002dd5, 0x2f7d51c3, 0x01332484 ),
	/* 1728 */ DATA_4( 0x835add3e, 0xef0ba4a3, 0x3bad559e, 0x0ebcb029 ),
	/* 1744 */ DATA_4( 0x07123d30, 0x1409b54d, 0x36105ebd, 0x52398d80 ),
	/* 1760 */ DATA_4( 0x673281c1, 0x8da33215, 0xc1f0689b, 0x807bfe78 ),
	/* 1776 */ DATA_1x2( 0x000000-3, 0x00000000 ),

	/* Data for interval 3 : [ 10.17347, 13.32369 ) - zero = 11.79153 */
	/* 1784 */ DATA_1x2( 0x43968895, 0x6a96ebcc ),
	/* 1792 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 1800 */ DATA_2x2( 0x1395b144, 0xbcaa2004, 0x5b080576, 0x4fd5821d ),
	/* 1816 */ DATA_2x2( 0x8eb9a891, 0x0e820a87, 0x6269869c, 0xe09ab3f7 ),
	/* degree = 28 - unpacked coefficients */
	/* 1832 */ DATA_4( 0x692ac2ce, 0x001135bc, 0x00000000, 0x00000000 ),
	/* 1848 */ DATA_4( 0x16b511ad, 0x0e18b826, 0x00000000, 0x00000000 ),
	/* 1864 */ DATA_4( 0xf1dccf2b, 0x11abb6c9, 0x0000000a, 0x00000000 ),
	/* 1880 */ DATA_4( 0x722c87ca, 0x8fde2741, 0x0000062a, 0x00000000 ),
	/* 1896 */ DATA_4( 0x95ee34d5, 0x537a60c7, 0x000331c2, 0x00000000 ),
	/* 1912 */ DATA_4( 0x59daaa43, 0x0719d351, 0x0160ce09, 0x00000000 ),
	/* 1928 */ DATA_4( 0x31027961, 0x7e929531, 0x7c62a142, 0x00000000 ),
	/* 1944 */ DATA_4( 0xa49ae359, 0x8261336e, 0x01ac9c58, 0x00000023 ),
	/* 1960 */ DATA_4( 0x20f10e79, 0x9954c9ea, 0x31362635, 0x000007a2 ),
	/* 1976 */ DATA_4( 0x40f324ed, 0xeee00b84, 0x882e5df9, 0x00013d79 ),
	/* 1992 */ DATA_4( 0xe1f3f14c, 0xfd5207b0, 0xe92817d0, 0x002468da ),
	/* 2008 */ DATA_4( 0x5d8a02bb, 0x5443a7d0, 0x2ccad9f0, 0x02b9cfe9 ),
	/* 2024 */ DATA_4( 0x38edbf68, 0x4a89728c, 0x7d0a80b9, 0x1e2e16f9 ),
	/* 2040 */ DATA_4( 0x60d243a7, 0xfdd4b10b, 0xc97023d4, 0x9c68eec4 ),
	/* 2056 */ DATA_4( 0xf4ce0be3, 0x8d2bf186, 0x6173b692, 0xee09f335 ),
	/* 2072 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 2080 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 2096 */ DATA_4( 0x30cff436, 0x05550908, 0x00000000, 0x00000000 ),
	/* 2112 */ DATA_4( 0x7245c69a, 0x1072301c, 0x00000004, 0x00000000 ),
	/* 2128 */ DATA_4( 0x2c70f0b5, 0xbd16e934, 0x0000029b, 0x00000000 ),
	/* 2144 */ DATA_4( 0xb0007e70, 0x1d541bca, 0x00016b09, 0x00000000 ),
	/* 2160 */ DATA_4( 0x83853772, 0x067a15d0, 0x00a4a3d9, 0x00000000 ),
	/* 2176 */ DATA_4( 0xd6304474, 0x848be7ad, 0x3d1b8257, 0x00000000 ),
	/* 2192 */ DATA_4( 0xf9885151, 0x7e11f8b8, 0x2094137f, 0x00000012 ),
	/* 2208 */ DATA_4( 0xfbb3dfb1, 0x65322b11, 0x6203f078, 0x0000042b ),
	/* 2224 */ DATA_4( 0x87da87c8, 0xc48f9448, 0x0895ed93, 0x0000b6de ),
	/* 2240 */ DATA_4( 0x1f832d52, 0x897037d0, 0xe799b731, 0x001612f2 ),
	/* 2256 */ DATA_4( 0xeb5474c2, 0x5375f9ee, 0xa9c4ac05, 0x01bb178d ),
	/* 2272 */ DATA_4( 0x15cdaa3f, 0xd0349d3f, 0x2af20497, 0x13dfc378 ),
	/* 2288 */ DATA_4( 0xf7d45017, 0xff866bf7, 0x1bb7037f, 0x6957a6cd ),
	/* 2304 */ DATA_4( 0xc70cbd4f, 0x0058564d, 0x2c23197a, 0xa17f866e ),
	/* 2320 */ DATA_1x2( 0x000000-4, 0x00000000 ),

	/* Data for interval 4 : [ 13.32369, 16.47063 ) - zero = 14.93092 */
	/* 2328 */ DATA_1x2( 0x2846245a, 0x83c3d9b0 ),
	/* 2336 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 2344 */ DATA_2x2( 0x938e8cd0, 0xeee509f7, 0x2f664bcf, 0xd33ed936 ),
	/* 2360 */ DATA_2x2( 0xb9eef719, 0xef8e650a, 0x6c33424c, 0xd9a3f3f7 ),
	/* degree = 28 - unpacked coefficients */
	/* 2376 */ DATA_4( 0x0eed12e8, 0x0011495f, 0x00000000, 0x00000000 ),
	/* 2392 */ DATA_4( 0x5f58dfe3, 0x0e3d39f6, 0x00000000, 0x00000000 ),
	/* 2408 */ DATA_4( 0xf914a1f4, 0x2625d8fd, 0x0000000a, 0x00000000 ),
	/* 2424 */ DATA_4( 0xd9b71176, 0x633c9d59, 0x00000632, 0x00000000 ),
	/* 2440 */ DATA_4( 0x1e323dd0, 0x10adc894, 0x000332aa, 0x00000000 ),
	/* 2456 */ DATA_4( 0xca58e55c, 0xa194ed7b, 0x015f7175, 0x00000000 ),
	/* 2472 */ DATA_4( 0x3fb3b6dc, 0xca77f5d2, 0x7b1ba7ba, 0x00000000 ),
	/* 2488 */ DATA_4( 0x5b547edc, 0x6a4c1d37, 0x5b9f3c29, 0x00000022 ),
	/* 2504 */ DATA_4( 0xcae9b3b7, 0x2672707d, 0x49d502b2, 0x00000769 ),
	/* 2520 */ DATA_4( 0xa7d4f552, 0x487b6eed, 0x8dedaa0e, 0x00012ffb ),
	/* 2536 */ DATA_4( 0x289cad3e, 0x67da87af, 0x57a0d13e, 0x0022447c ),
	/* 2552 */ DATA_4( 0xd59d0d74, 0xcc73ae3f, 0xcc5e93c1, 0x0283e760 ),
	/* 2568 */ DATA_4( 0x9c68a765, 0xe4b2d7f1, 0x9bfb4135, 0x1b541f82 ),
	/* 2584 */ DATA_4( 0xf3e545dd, 0x806ab0ed, 0x4f88fa84, 0x8bbcc550 ),
	/* 2600 */ DATA_4( 0xe32e6238, 0xfbd9a444, 0xb3a7ffb7, 0xd380e87c ),
	/* 2616 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 2624 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 2640 */ DATA_4( 0x7d4524c3, 0x09b7c40c, 0x00000000, 0x00000000 ),
	/* 2656 */ DATA_4( 0x4490ab37, 0x593aef8d, 0x00000007, 0x00000000 ),
	/* 2672 */ DATA_4( 0x4d304201, 0xb0948047, 0x000004ab, 0x00000000 ),
	/* 2688 */ DATA_4( 0x0b8cff41, 0x4af8f786, 0x000282b2, 0x00000000 ),
	/* 2704 */ DATA_4( 0xe326a5fa, 0x6ff41fd5, 0x011f8d98, 0x00000000 ),
	/* 2720 */ DATA_4( 0xaaa649e7, 0x0f6cb869, 0x69046acc, 0x00000000 ),
	/* 2736 */ DATA_4( 0x912a300f, 0xfd98dcac, 0x8dc94e61, 0x0000001e ),
	/* 2752 */ DATA_4( 0xd8ae38ed, 0xf80f2486, 0x7bac961e, 0x000006dd ),
	/* 2768 */ DATA_4( 0xc1c4c3d8, 0x83bb4837, 0x7f1c46f8, 0x000124c4 ),
	/* 2784 */ DATA_4( 0x8123835b, 0xcc46777d, 0x2d1486fd, 0x002232c7 ),
	/* 2800 */ DATA_4( 0x066a4bd6, 0xa7c62e23, 0x22962917, 0x02964616 ),
	/* 2816 */ DATA_4( 0x94523d39, 0xf0acfb94, 0x9ffe342c, 0x1cc0bda1 ),
	/* 2832 */ DATA_4( 0x61840cd4, 0x97fca134, 0x3ee84b23, 0x9510a8a0 ),
	/* 2848 */ DATA_4( 0x7afc3616, 0xc09a8014, 0xf7c48d99, 0xe2a5c987 ),
	/* 2864 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 5 : [ 16.47063, 19.61586 ) - zero = 18.07106 */
	/* 2872 */ DATA_1x2( 0x0b651dbc, 0x9ced473a ),
	/* 2880 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 2888 */ DATA_2x2( 0x50cfadd3, 0x909189fc, 0x20260e28, 0x405dee17 ),
	/* 2904 */ DATA_2x2( 0x3577cb82, 0x7b253935, 0x5913ad9d, 0x80b675b4 ),
	/* degree = 28 - unpacked coefficients */
	/* 2920 */ DATA_4( 0x8d0c143d, 0x0011455b, 0x00000000, 0x00000000 ),
	/* 2936 */ DATA_4( 0x09a0fcd8, 0x0e423668, 0x00000000, 0x00000000 ),
	/* 2952 */ DATA_4( 0x2d763844, 0x22581eb2, 0x0000000a, 0x00000000 ),
	/* 2968 */ DATA_4( 0xceb605a4, 0x61df1d09, 0x0000062a, 0x00000000 ),
	/* 2984 */ DATA_4( 0xfd8b4bfe, 0xa2eabb17, 0x00032af0, 0x00000000 ),
	/* 3000 */ DATA_4( 0xa793a115, 0xc2ddbaf3, 0x015a3dd5, 0x00000000 ),
	/* 3016 */ DATA_4( 0x6ccb321e, 0x46e30c6a, 0x787b6875, 0x00000000 ),
	/* 3032 */ DATA_4( 0x2ac4947d, 0x85cf45c1, 0x5abec16a, 0x00000021 ),
	/* 3048 */ DATA_4( 0x2956f767, 0x8b1a75da, 0x2aac764c, 0x00000720 ),
	/* 3064 */ DATA_4( 0xb1ee3bb9, 0x37c19320, 0xc49d611c, 0x00012101 ),
	/* 3080 */ DATA_4( 0x52fdb1b0, 0x9c9f2246, 0xb93e5c36, 0x00202e2d ),
	/* 3096 */ DATA_4( 0xe8af5e08, 0xcf0c1493, 0xfb3f9353, 0x02555273 ),
	/* 3112 */ DATA_4( 0x854c8071, 0xa5745e85, 0x3eaa7c58, 0x19166c7d ),
	/* 3128 */ DATA_4( 0x2aa31c31, 0xbf0162f0, 0xbd677f3c, 0x7f5f0eb5 ),
	/* 3144 */ DATA_4( 0x5d69f477, 0x7cb51290, 0x4dbc10d2, 0xc03bfab6 ),
	/* 3160 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 3168 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 3184 */ DATA_4( 0xe5d30637, 0x08d38d06, 0x00000000, 0x00000000 ),
	/* 3200 */ DATA_4( 0x3d470851, 0x9f11180c, 0x00000006, 0x00000000 ),
	/* 3216 */ DATA_4( 0x2b6b1b85, 0x352e4f4f, 0x0000042b, 0x00000000 ),
	/* 3232 */ DATA_4( 0x24b5fe8d, 0x7440faca, 0x00023767, 0x00000000 ),
	/* 3248 */ DATA_4( 0xc3c10462, 0xfa81ff61, 0x00faaeae, 0x00000000 ),
	/* 3264 */ DATA_4( 0x5df9eb56, 0xe615c90c, 0x5a39d914, 0x00000000 ),
	/* 3280 */ DATA_4( 0x48ec0a67, 0x3ba6506c, 0xd02ffd59, 0x00000019 ),
	/* 3296 */ DATA_4( 0x51489b07, 0x218feac4, 0xac5eadc6, 0x000005b0 ),
	/* 3312 */ DATA_4( 0x72003633, 0xef9140bc, 0x45bd6dd2, 0x0000ed8f ),
	/* 3328 */ DATA_4( 0x99b53a90, 0xe04ffd16, 0xef409a9b, 0x001b227e ),
	/* 3344 */ DATA_4( 0x238bde8c, 0xf86c07bd, 0x1d8481f0, 0x020252e1 ),
	/* 3360 */ DATA_4( 0xb6f73e06, 0x3d2220a6, 0x78f5f653, 0x15f01524 ),
	/* 3376 */ DATA_4( 0xfc1553dc, 0x0f0ccfb3, 0x2717ad0e, 0x706d1f20 ),
	/* 3392 */ DATA_4( 0xcec30337, 0xfbb2c3fe, 0xaef550cb, 0xaa33f5a9 ),
	/* 3408 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 6 : [ 19.61586, 22.76008 ) - zero = 21.21164 */
	/* 3416 */ DATA_1x2( 0xa6c55ee4, 0xb614a71e ),
	/* 3424 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 3432 */ DATA_2x2( 0x9fbc911d, 0xa9b16e8b, 0x5a83e63e, 0x2dfa1c3b ),
	/* 3448 */ DATA_2x2( 0xacf69291, 0x06151fa5, 0x1822a5ed, 0x2a466f7b ),
	/* degree = 28 - unpacked coefficients */
	/* 3464 */ DATA_4( 0x1c5399e6, 0x00112b5e, 0x00000000, 0x00000000 ),
	/* 3480 */ DATA_4( 0x6d721fc1, 0x0e2e6428, 0x00000000, 0x00000000 ),
	/* 3496 */ DATA_4( 0x24ff5c09, 0x0c279420, 0x0000000a, 0x00000000 ),
	/* 3512 */ DATA_4( 0xa2be8cb7, 0xf2dd6fb7, 0x00000616, 0x00000000 ),
	/* 3528 */ DATA_4( 0x08f014e9, 0x5bf05004, 0x00031d5e, 0x00000000 ),
	/* 3544 */ DATA_4( 0x3559f06a, 0x018d6ee5, 0x0152a819, 0x00000000 ),
	/* 3560 */ DATA_4( 0x3eb5bffa, 0xd096ff1f, 0x751f2a67, 0x00000000 ),
	/* 3576 */ DATA_4( 0xe92da1ad, 0xc2177f07, 0x326c9b0c, 0x00000020 ),
	/* 3592 */ DATA_4( 0x7d615fc2, 0x4cd352f4, 0x14868c58, 0x000006d3 ),
	/* 3608 */ DATA_4( 0x22f6ea25, 0xa649d224, 0x2f0f2448, 0x00011278 ),
	/* 3624 */ DATA_4( 0x3d60d545, 0x9ace0d5b, 0x3dce335d, 0x001e4d89 ),
	/* 3640 */ DATA_4( 0x21fe61f0, 0x55eda4af, 0xdd61c9c4, 0x022e156b ),
	/* 3656 */ DATA_4( 0x749270d8, 0xe2ed3085, 0x05638e08, 0x174a948d ),
	/* 3672 */ DATA_4( 0xab5c626c, 0xd88ee3eb, 0xaec0af04, 0x75c1cf6b ),
	/* 3688 */ DATA_4( 0x01ec0013, 0x9a7b1358, 0xe82dda88, 0xb16c9d54 ),
	/* 3704 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 3712 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 3728 */ DATA_4( 0xd0cae758, 0x080089be, 0x00000000, 0x00000000 ),
	/* 3744 */ DATA_4( 0x802eb8ee, 0xf5128889, 0x00000005, 0x00000000 ),
	/* 3760 */ DATA_4( 0xb2c82ef6, 0xba002f9c, 0x000003b7, 0x00000000 ),
	/* 3776 */ DATA_4( 0x289ee582, 0xfa151d01, 0x0001f4fd, 0x00000000 ),
	/* 3792 */ DATA_4( 0x1a67a0cf, 0x3a61ae5e, 0x00dae175, 0x00000000 ),
	/* 3808 */ DATA_4( 0x090eddda, 0xf298777e, 0x4dcdc6c5, 0x00000000 ),
	/* 3824 */ DATA_4( 0x6cdc808b, 0x4a78a586, 0xf4ab616b, 0x00000015 ),
	/* 3840 */ DATA_4( 0x50cf647b, 0xe00b4220, 0xcb69ae7b, 0x000004c4 ),
	/* 3856 */ DATA_4( 0x6203523e, 0x7f45b1f7, 0xac217633, 0x0000c40e ),
	/* 3872 */ DATA_4( 0x448c61ee, 0x85c0134f, 0xa6ccb16e, 0x00160f73 ),
	/* 3888 */ DATA_4( 0xce490049, 0x8ea3f1ba, 0x8a20314e, 0x019c8e41 ),
	/* 3904 */ DATA_4( 0x0811109d, 0x05921420, 0xf13bbf5e, 0x11695765 ),
	/* 3920 */ DATA_4( 0x9ce2273d, 0x93bda541, 0xd61ccb4a, 0x58a04f1f ),
	/* 3936 */ DATA_4( 0xfddda11a, 0x8e11ac82, 0x494f8ca0, 0x85d4e744 ),
	/* 3952 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Interval polynomial coefficients for j1 */

	/* Data for interval 0 : [ 0.0, 1.84118 ) - zero = 0.0 */
	/* 3960 */ DATA_1x2( 0xf6451d02, 0x0ebabe8f ),
	/* 3968 */ DATA_1x2( 0x0003800e, 0xfc000128 ),
	/* 3976 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 3992 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* degree = 14 - unpacked coefficients */
	/* 4008 */ DATA_4( 0x7274f856, 0x000a533f, 0x00000000, 0x00000000 ),
	/* 4024 */ DATA_4( 0x9dde4409, 0x08b2268d, 0x00000000, 0x00000000 ),
	/* 4040 */ DATA_4( 0x0525cdbb, 0x2f3802d9, 0x00000006, 0x00000000 ),
	/* 4056 */ DATA_4( 0xd4c4b454, 0xc6f650d9, 0x000003c4, 0x00000000 ),
	/* 4072 */ DATA_4( 0xd2d7cb64, 0x97cde209, 0x0001f176, 0x00000000 ),
	/* 4088 */ DATA_4( 0x63d0f7d9, 0x3afdbdb7, 0x00d5c0f5, 0x00000000 ),
	/* 4104 */ DATA_4( 0x25bbdf8f, 0xbd72f64c, 0x4b25d636, 0x00000000 ),
	/* 4120 */ DATA_4( 0xae99b23e, 0x486992b6, 0x22a43f65, 0x00000015 ),
	/* 4136 */ DATA_4( 0xb513db85, 0xd71cb75c, 0x93edde27, 0x0000049f ),
	/* 4152 */ DATA_4( 0x5da7b117, 0x4ab6ccef, 0x45067289, 0x0000c22e ),
	/* 4168 */ DATA_4( 0x9a42b547, 0xc16c16b2, 0x16c16c16, 0x0016c16c ),
	/* 4184 */ DATA_4( 0x9d44ed8f, 0x1c71c71b, 0xc71c71c7, 0x01c71c71 ),
	/* 4200 */ DATA_4( 0x4f15e5b3, 0x55555555, 0x55555555, 0x15555555 ),
	/* 4216 */ DATA_4( 0xffed636d, 0xffffffff, 0xffffffff, 0x7fffffff ),
	/* 4232 */ DATA_4( 0xfffff6c5, 0xffffffff, 0xffffffff, 0xffffffff ),
	/* 4248 */ DATA_1x2( 0x00000000, 0x00000000 ),

	/* Data for interval 1 : [ 1.84118, 5.33144 ) - zero = 3.83171 */
	/* 4256 */ DATA_1x2( 0x0648ce57, 0x2aa6cb78 ),
	/* 4264 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 4272 */ DATA_2x2( 0x7b78453f, 0xf53aabad, 0xb5381235, 0xd54ac5c9 ),
	/* 4288 */ DATA_2x2( 0x622dca4e, 0x3a55c2a8, 0x44346fa2, 0xe4278496 ),
	/* degree = 29 - unpacked coefficients */
	/* 4304 */ DATA_4( 0xe1bf32c5, 0x000895b1, 0x00000000, 0x00000000 ),
	/* 4320 */ DATA_4( 0x625292af, 0x0707365b, 0x00000000, 0x00000000 ),
	/* 4336 */ DATA_4( 0xb7b93498, 0x026436dd, 0x00000005, 0x00000000 ),
	/* 4352 */ DATA_4( 0x23ef740f, 0xeb93a5e4, 0x0000030f, 0x00000000 ),
	/* 4368 */ DATA_4( 0xe4ca545c, 0x8202fa3c, 0x000195a6, 0x00000000 ),
	/* 4384 */ DATA_4( 0x32c05f7b, 0xee8610f1, 0x00af028b, 0x00000000 ),
	/* 4400 */ DATA_4( 0xda1f853d, 0x1f36f43c, 0x3dcfff23, 0x00000000 ),
	/* 4416 */ DATA_4( 0xb183b737, 0x2e174613, 0x7a40c942, 0x00000011 ),
	/* 4432 */ DATA_4( 0xf3f07cbc, 0xea4c2a81, 0xc46215eb, 0x000003d8 ),
	/* 4448 */ DATA_4( 0x41e6ec9d, 0x3f90914c, 0xd9157e1e, 0x0000a2b4 ),
	/* 4464 */ DATA_4( 0x82f3204c, 0x7fec47f9, 0xcd2e2c16, 0x00133825 ),
	/* 4480 */ DATA_4( 0xe99593f9, 0x0b3d1815, 0x30c41093, 0x0183a06e ),
	/* 4496 */ DATA_4( 0x32d13670, 0xba0ba9be, 0x959063fb, 0x124b3409 ),
	/* 4512 */ DATA_4( 0xaca3f8aa, 0x98269674, 0x84e41288, 0x6d627476 ),
	/* 4528 */ DATA_4( 0x569f41b9, 0x1eebc89a, 0x65fbf6d2, 0xce367ac1 ),
	/* 4544 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 4552 */ DATA_4( 0x7aeed606, 0x00010e2e, 0x00000000, 0x00000000 ),
	/* 4568 */ DATA_4( 0x28268f2e, 0x016bad81, 0x00000000, 0x00000000 ),
	/* 4584 */ DATA_4( 0x2590d4c2, 0x15ad64e0, 0x00000001, 0x00000000 ),
	/* 4600 */ DATA_4( 0x11361e73, 0xa0c59e76, 0x000000b5, 0x00000000 ),
	/* 4616 */ DATA_4( 0x7f01331c, 0x3118ccaf, 0x0000650e, 0x00000000 ),
	/* 4632 */ DATA_4( 0x5540e5b6, 0xb43e2e8e, 0x002f24b2, 0x00000000 ),
	/* 4648 */ DATA_4( 0xe41bf23b, 0xc4d84ddc, 0x121fb8bd, 0x00000000 ),
	/* 4664 */ DATA_4( 0xded7fc04, 0xc3270729, 0x9f2c7400, 0x00000005 ),
	/* 4680 */ DATA_4( 0x111f543a, 0xf4f195ee, 0xc84e47b6, 0x0000015e ),
	/* 4696 */ DATA_4( 0x0247a24b, 0xa7a7740d, 0x7a594415, 0x000040ee ),
	/* 4712 */ DATA_4( 0xea066fb5, 0x0c52e792, 0x919f48b6, 0x0008b834 ),
	/* 4728 */ DATA_4( 0x6bd6ea77, 0xe019711e, 0x64f92a46, 0x00cbccea ),
	/* 4744 */ DATA_4( 0x6e180b4a, 0xc81b0358, 0x9aa11218, 0x0b72616a ),
	/* 4760 */ DATA_4( 0x5515a539, 0xd0df03a7, 0xcc769b0c, 0x54dd5130 ),
	/* 4776 */ DATA_4( 0x35a96d03, 0xe5199aca, 0x8d681d28, 0xd7451cfa ),
	/* 4792 */ DATA_1x2( 0x000000-2, 0x00000000 ),

	/* Data for interval 2 : [ 5.33144, 8.53632 ) - zero = 7.01559 */
	/* 4800 */ DATA_1x2( 0x2e2283a7, 0x444a603c ),
	/* 4808 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 4816 */ DATA_2x2( 0xa3927f26, 0xe07faf9d, 0x3ec6c314, 0xec9316de ),
	/* 4832 */ DATA_2x2( 0x40943bc7, 0xb5c5891d, 0xc893257b, 0x21786cfa ),
	/* degree = 28 - unpacked coefficients */
	/* 4848 */ DATA_4( 0xb2996320, 0x0008c673, 0x00000000, 0x00000000 ),
	/* 4864 */ DATA_4( 0x028af300, 0x0704e60a, 0x00000000, 0x00000000 ),
	/* 4880 */ DATA_4( 0xb629a8f0, 0x01839349, 0x00000005, 0x00000000 ),
	/* 4896 */ DATA_4( 0xd2f6454c, 0x39767362, 0x00000310, 0x00000000 ),
	/* 4912 */ DATA_4( 0x43952016, 0xc7f39051, 0x00019633, 0x00000000 ),
	/* 4928 */ DATA_4( 0x31e9d670, 0x6fced2b6, 0x00af618c, 0x00000000 ),
	/* 4944 */ DATA_4( 0xefa1c6d2, 0x00e67ea5, 0x3df763ce, 0x00000000 ),
	/* 4960 */ DATA_4( 0x90f8a0ec, 0xf55e5511, 0x83edbb8e, 0x00000011 ),
	/* 4976 */ DATA_4( 0x14a7ba45, 0x8ad7eb29, 0x5d25d0a8, 0x000003d9 ),
	/* 4992 */ DATA_4( 0x718899d5, 0x2e5b3b7d, 0xcebf7585, 0x0000a231 ),
	/* 5008 */ DATA_4( 0x98e56e95, 0xca2fd265, 0x0ce97ab8, 0x0013026e ),
	/* 5024 */ DATA_4( 0x2e577860, 0x51d8f40a, 0x1f890510, 0x01796a75 ),
	/* 5040 */ DATA_4( 0x46ead8bd, 0x43f76b73, 0x6982170c, 0x113fbc7d ),
	/* 5056 */ DATA_4( 0x82cffc34, 0xd8715df6, 0xbb96c176, 0x60320ef7 ),
	/* 5072 */ DATA_4( 0x148f2b80, 0x45a067dc, 0x3a74535e, 0x99a8c59c ),
	/* 5088 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 5096 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 5112 */ DATA_4( 0x70293766, 0x02bedc72, 0x00000000, 0x00000000 ),
	/* 5128 */ DATA_4( 0x77cd718e, 0x1c568ca4, 0x00000002, 0x00000000 ),
	/* 5144 */ DATA_4( 0xd649af84, 0xe821a4c2, 0x0000015e, 0x00000000 ),
	/* 5160 */ DATA_4( 0x538cded8, 0x2fb78813, 0x0000c18a, 0x00000000 ),
	/* 5176 */ DATA_4( 0x4a8733d1, 0x54840931, 0x0059556a, 0x00000000 ),
	/* 5192 */ DATA_4( 0xb6cc3baf, 0xdf4461fe, 0x21e51b47, 0x00000000 ),
	/* 5208 */ DATA_4( 0xf99ba860, 0x671de8bd, 0x571f3f26, 0x0000000a ),
	/* 5224 */ DATA_4( 0xc72d68fc, 0x9a4dd0fe, 0x6d131ae7, 0x00000277 ),
	/* 5240 */ DATA_4( 0x34fa4a19, 0xd2026c32, 0x32d28cba, 0x0000718b ),
	/* 5256 */ DATA_4( 0xe8c86fac, 0x2af670a2, 0x6d749796, 0x000ea46e ),
	/* 5272 */ DATA_4( 0x2a615a6f, 0x82683803, 0x15aded38, 0x014255b0 ),
	/* 5288 */ DATA_4( 0xe172b372, 0x52a92590, 0xdbff911c, 0x107358bb ),
	/* 5304 */ DATA_4( 0xd45d1517, 0xac20ab22, 0x8f79093d, 0x6692ca4b ),
	/* 5320 */ DATA_4( 0x2b1d19e5, 0x4d629847, 0x1b15f93b, 0xaf386e30 ),
	/* 5336 */ DATA_1x2( 0x000000-3, 0x00000000 ),

	/* Data for interval 3 : [ 8.53632, 11.706 ) - zero = 10.17347 */
	/* 5344 */ DATA_1x2( 0xfb96b19a, 0x5da5e5e5 ),
	/* 5352 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 5360 */ DATA_2x2( 0xefe14a04, 0xa2c68685, 0x56c95918, 0xc214a2ac ),
	/* 5376 */ DATA_2x2( 0xaebd090b, 0x4fd742cd, 0x50ee46f4, 0x4135cd8b ),
	/* degree = 28 - unpacked coefficients */
	/* 5392 */ DATA_4( 0x43560a16, 0x00116111, 0x00000000, 0x00000000 ),
	/* 5408 */ DATA_4( 0x8d6e7ff9, 0x0e28d71a, 0x00000000, 0x00000000 ),
	/* 5424 */ DATA_4( 0x1fd60fb0, 0x1944b1cd, 0x0000000a, 0x00000000 ),
	/* 5440 */ DATA_4( 0xfd2817f0, 0xff549a13, 0x0000062c, 0x00000000 ),
	/* 5456 */ DATA_4( 0x8e554e6a, 0x243bc8ca, 0x000331f4, 0x00000000 ),
	/* 5472 */ DATA_4( 0xa7a35911, 0x3b435935, 0x01608046, 0x00000000 ),
	/* 5488 */ DATA_4( 0xb2d575a7, 0x172d8470, 0x7c304b91, 0x00000000 ),
	/* 5504 */ DATA_4( 0x4538ff96, 0xbbf56f8c, 0xf2fcbd59, 0x00000022 ),
	/* 5520 */ DATA_4( 0x6c77f70d, 0x6c0c0cb3, 0x13adac84, 0x000007a1 ),
	/* 5536 */ DATA_4( 0xbc8f2df3, 0xe6571026, 0xf248277e, 0x00013e3b ),
	/* 5552 */ DATA_4( 0xe6000535, 0xdc1ab054, 0x71665cb1, 0x0024b824 ),
	/* 5568 */ DATA_4( 0xc4510290, 0x165f52fd, 0xa8739631, 0x02c78a8e ),
	/* 5584 */ DATA_4( 0xf83deb3a, 0xf82027a5, 0x9b9e6e8e, 0x1f51c248 ),
	/* 5600 */ DATA_4( 0x7a1b5f25, 0x5d8aa6f5, 0xd33c46dc, 0xa5862eae ),
	/* 5616 */ DATA_4( 0xc56a89d3, 0x2a3a2541, 0x75e68905, 0xffb2a2a2 ),
	/* 5632 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 5640 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 5656 */ DATA_4( 0x7b71f4de, 0x0529a203, 0x00000000, 0x00000000 ),
	/* 5672 */ DATA_4( 0x8e8ea7f9, 0xf20254b4, 0x00000003, 0x00000000 ),
	/* 5688 */ DATA_4( 0xf0268408, 0x6e13adb8, 0x0000028a, 0x00000000 ),
	/* 5704 */ DATA_4( 0x09a28d07, 0xcb748998, 0x00016325, 0x00000000 ),
	/* 5720 */ DATA_4( 0x1a01046b, 0x9300691c, 0x00a1f1c5, 0x00000000 ),
	/* 5736 */ DATA_4( 0x280d0ba0, 0x20f867df, 0x3c8846ab, 0x00000000 ),
	/* 5752 */ DATA_4( 0x68804b22, 0x5a796ab3, 0x1fc0f126, 0x00000012 ),
	/* 5768 */ DATA_4( 0x24e0754b, 0x238dbf12, 0x92aed01c, 0x00000438 ),
	/* 5784 */ DATA_4( 0x18af24e2, 0x517b8fc6, 0xc539f3e0, 0x0000bc51 ),
	/* 5800 */ DATA_4( 0xf5f4fc4f, 0xc9942f00, 0x6b9aa950, 0x0017486f ),
	/* 5816 */ DATA_4( 0x25eadbde, 0x824e131d, 0xaf698669, 0x01e3725d ),
	/* 5832 */ DATA_4( 0x3b9ac88e, 0xf5f3e518, 0x0f770d3a, 0x16b4c9ca ),
	/* 5848 */ DATA_4( 0x0dd3bc06, 0x15ab5397, 0x34a25bec, 0x7e46a7b8 ),
	/* 5864 */ DATA_4( 0xd7e85f02, 0x5fe95e8a, 0x03c2d772, 0xc911ff96 ),
	/* 5880 */ DATA_1x2( 0x000000-4, 0x00000000 ),

	/* Data for interval 4 : [ 11.706, 14.86359 ) - zero = 13.32369 */
	/* 5888 */ DATA_1x2( 0x5eb16296, 0x76e8a128 ),
	/* 5896 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 5904 */ DATA_2x2( 0x872d112b, 0xd52dd798, 0x693473d0, 0xce7fd18e ),
	/* 5920 */ DATA_2x2( 0x50912578, 0xe2932ca9, 0x1500f714, 0x13c56553 ),
	/* degree = 28 - unpacked coefficients */
	/* 5936 */ DATA_4( 0x24141e60, 0x0011576c, 0x00000000, 0x00000000 ),
	/* 5952 */ DATA_4( 0x9fce6963, 0x0e3e19d7, 0x00000000, 0x00000000 ),
	/* 5968 */ DATA_4( 0xbbbe3f90, 0x250e8b92, 0x0000000a, 0x00000000 ),
	/* 5984 */ DATA_4( 0x9aaf1858, 0x073a1176, 0x00000631, 0x00000000 ),
	/* 6000 */ DATA_4( 0x8406680a, 0x93f5ebdc, 0x000331d3, 0x00000000 ),
	/* 6016 */ DATA_4( 0x1c1208ab, 0x27d1004d, 0x015f2aba, 0x00000000 ),
	/* 6032 */ DATA_4( 0xe054dea7, 0xc7440886, 0x7b1d26e8, 0x00000000 ),
	/* 6048 */ DATA_4( 0x0ee0f472, 0x8e7db392, 0x6b0b536e, 0x00000022 ),
	/* 6064 */ DATA_4( 0x504564c1, 0xae80890f, 0x3d5a0959, 0x00000772 ),
	/* 6080 */ DATA_4( 0xe46784f2, 0xb4410e3a, 0x1b4b2ff8, 0x000132db ),
	/* 6096 */ DATA_4( 0x60c6d638, 0x3a5e2222, 0xf02bbce8, 0x0022d57a ),
	/* 6112 */ DATA_4( 0xa65cca48, 0x8e909b90, 0xa0b5a167, 0x0294ce09 ),
	/* 6128 */ DATA_4( 0x0fa78633, 0xe04d41bf, 0xaf2d7701, 0x1c5bce33 ),
	/* 6144 */ DATA_4( 0xc4a56bee, 0xdb2da506, 0x8c0b557c, 0x928c2c00 ),
	/* 6160 */ DATA_4( 0x0c479df4, 0x8cda5c84, 0x9d3ec391, 0xdf999bc3 ),
	/* 6176 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 6184 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 6200 */ DATA_4( 0xb4e0d9ec, 0x04c8a7f3, 0x00000000, 0x00000000 ),
	/* 6216 */ DATA_4( 0xb20fbc2b, 0xa122395f, 0x00000003, 0x00000000 ),
	/* 6232 */ DATA_4( 0x4874b1ee, 0xf82ccf6f, 0x00000250, 0x00000000 ),
	/* 6248 */ DATA_4( 0x2e9b7020, 0x7c5d1f6d, 0x00014055, 0x00000000 ),
	/* 6264 */ DATA_4( 0xd3fb7405, 0xb4b83840, 0x00903828, 0x00000000 ),
	/* 6280 */ DATA_4( 0x778bdf8d, 0x94aafb5c, 0x35157568, 0x00000000 ),
	/* 6296 */ DATA_4( 0x459bc6f6, 0x06d87b38, 0x99175171, 0x0000000f ),
	/* 6312 */ DATA_4( 0x8c293689, 0x5c42bcdf, 0xa2670db5, 0x0000038c ),
	/* 6328 */ DATA_4( 0x5e5b84a7, 0x6d1a5ac0, 0x667bdfee, 0x000099d6 ),
	/* 6344 */ DATA_4( 0x43087301, 0x282dd3f1, 0x6f5d4346, 0x001257f1 ),
	/* 6360 */ DATA_4( 0xfe0cb47a, 0x6c3337df, 0xdfed6c89, 0x016c43ee ),
	/* 6376 */ DATA_4( 0x3c6331f6, 0x52dbcf35, 0x6e0038f8, 0x10413e30 ),
	/* 6392 */ DATA_4( 0x9cec873d, 0x1d71245a, 0xfdcb6041, 0x567ac582 ),
	/* 6408 */ DATA_4( 0x62e853eb, 0xfc768aaf, 0xd6e99542, 0x8641d16b ),
	/* 6424 */ DATA_1x2( 0x000000-4, 0x00000000 ),

	/* Data for interval 5 : [ 14.86359, 18.01553 ) - zero = 16.47063 */
	/* 6432 */ DATA_1x2( 0x732937bf, 0x901fcd12 ),
	/* 6440 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 6448 */ DATA_2x2( 0x2846245a, 0x83c3d9b0, 0x9d15e36c, 0xb2e2eea9 ),
	/* 6464 */ DATA_2x2( 0x8e18c4b4, 0x74bb9c5a, 0x0bf09e6d, 0x638b68b0 ),
	/* degree = 28 - unpacked coefficients */
	/* 6480 */ DATA_4( 0x699f1c25, 0x00114987, 0x00000000, 0x00000000 ),
	/* 6496 */ DATA_4( 0x84919282, 0x0e3fe2b0, 0x00000000, 0x00000000 ),
	/* 6512 */ DATA_4( 0x954aba5e, 0x20b0f0de, 0x0000000a, 0x00000000 ),
	/* 6528 */ DATA_4( 0x07333c87, 0xd3e37d1d, 0x00000629, 0x00000000 ),
	/* 6544 */ DATA_4( 0x91227503, 0x62f72919, 0x00032b2b, 0x00000000 ),
	/* 6560 */ DATA_4( 0xa396460a, 0x69525b60, 0x015ab8b8, 0x00000000 ),
	/* 6576 */ DATA_4( 0x50b5b4ee, 0x223143bf, 0x78db755c, 0x00000000 ),
	/* 6592 */ DATA_4( 0x893960af, 0x3813be3b, 0x8b0ee046, 0x00000021 ),
	/* 6608 */ DATA_4( 0xf1105086, 0x9080299f, 0x03415949, 0x00000731 ),
	/* 6624 */ DATA_4( 0xc3599740, 0x37e147ea, 0x8c4ce2b6, 0x00012510 ),
	/* 6640 */ DATA_4( 0xeec0cdae, 0x5e33891e, 0x5f7748a9, 0x0020d408 ),
	/* 6656 */ DATA_4( 0xe16d5569, 0xac65c1ce, 0xdd183e62, 0x02659601 ),
	/* 6672 */ DATA_4( 0x83b2cfbe, 0x61549fa4, 0x758fb140, 0x19f4be60 ),
	/* 6688 */ DATA_4( 0x946856c9, 0xc1b118bb, 0x81b3f9da, 0x84a31dde ),
	/* 6704 */ DATA_4( 0xf82e1a47, 0x550665d1, 0x047aa42d, 0xc92e37e5 ),
	/* 6720 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 6728 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 6744 */ DATA_4( 0x8460793a, 0x08cabcaf, 0x00000000, 0x00000000 ),
	/* 6760 */ DATA_4( 0xc9aee960, 0x9eab43df, 0x00000006, 0x00000000 ),
	/* 6776 */ DATA_4( 0xfa9002b3, 0xb6b611c0, 0x0000042f, 0x00000000 ),
	/* 6792 */ DATA_4( 0x05a318ce, 0xdc2e291b, 0x00023cd9, 0x00000000 ),
	/* 6808 */ DATA_4( 0x20acd4c7, 0xdcdb64b0, 0x00feb9bb, 0x00000000 ),
	/* 6824 */ DATA_4( 0xb11ff51b, 0xee296536, 0x5c667a02, 0x00000000 ),
	/* 6840 */ DATA_4( 0xc884f9e4, 0x2001852b, 0xafec4cd9, 0x0000001a ),
	/* 6856 */ DATA_4( 0xd6fe2f73, 0xb2bb3726, 0x5db8b5f8, 0x000005f3 ),
	/* 6872 */ DATA_4( 0x033a6961, 0x8dfe520a, 0x74d5a98a, 0x0000fbdc ),
	/* 6888 */ DATA_4( 0x09cb0424, 0x9513d718, 0x9e677730, 0x001d3a68 ),
	/* 6904 */ DATA_4( 0xf9d4b34a, 0x57f237fc, 0x186beafa, 0x0233b19d ),
	/* 6920 */ DATA_4( 0x7738db68, 0xe2fe72e6, 0xf9d1ba8e, 0x1877991a ),
	/* 6936 */ DATA_4( 0xb41ee7a7, 0xe00e6dda, 0x21da2adc, 0x7f680a63 ),
	/* 6952 */ DATA_4( 0xae2b8d88, 0xbef69239, 0x2cd87191, 0xc36e9970 ),
	/* 6968 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 6 : [ 18.01553, 21.16437 ) - zero = 19.61586 */
	/* 6976 */ DATA_1x2( 0x0d4fd3d5, 0xa950a125 ),
	/* 6984 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 6992 */ DATA_2x2( 0x0b651dbc, 0x9ced473a, 0x2f419e2c, 0xf9fcd02c ),
	/* 7008 */ DATA_2x2( 0x5d0db65f, 0x22f2a474, 0xa75cd4b5, 0xd358e537 ),
	/* degree = 28 - unpacked coefficients */
	/* 7024 */ DATA_4( 0x54604bc6, 0x00112e24, 0x00000000, 0x00000000 ),
	/* 7040 */ DATA_4( 0x8b335579, 0x0e2e0e30, 0x00000000, 0x00000000 ),
	/* 7056 */ DATA_4( 0x359525c0, 0x0d204929, 0x0000000a, 0x00000000 ),
	/* 7072 */ DATA_4( 0xbb293ddf, 0xbd07770f, 0x00000618, 0x00000000 ),
	/* 7088 */ DATA_4( 0x7884109b, 0x3f44b739, 0x00031f2e, 0x00000000 ),
	/* 7104 */ DATA_4( 0x6a269d0d, 0xca54653d, 0x0153f4e6, 0x00000000 ),
	/* 7120 */ DATA_4( 0xaf22bda7, 0xde1667e9, 0x75d1687d, 0x00000000 ),
	/* 7136 */ DATA_4( 0x67e245f7, 0xbe3807c7, 0x7a0b2430, 0x00000020 ),
	/* 7152 */ DATA_4( 0xd9655234, 0x86588458, 0x4d7e66a7, 0x000006e8 ),
	/* 7168 */ DATA_4( 0xaaba470c, 0x5da4d5df, 0x937595d9, 0x000116f3 ),
	/* 7184 */ DATA_4( 0x35c621bb, 0x4e07cefa, 0x591181a2, 0x001ef161 ),
	/* 7200 */ DATA_4( 0x75e8f8c8, 0xacc90dd8, 0x6d91b314, 0x023cba50 ),
	/* 7216 */ DATA_4( 0x1a3a1c66, 0xfc2c819b, 0x4ad309b2, 0x18050372 ),
	/* 7232 */ DATA_4( 0x47d99cf6, 0xf6c41090, 0xc3a6670c, 0x79f70239 ),
	/* 7248 */ DATA_4( 0xa772e007, 0x400aff09, 0x3ead525b, 0xb8628891 ),
	/* 7264 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 7272 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 7288 */ DATA_4( 0x76e30b40, 0x080a0672, 0x00000000, 0x00000000 ),
	/* 7304 */ DATA_4( 0x44d4cc7f, 0x01fea9e0, 0x00000006, 0x00000000 ),
	/* 7320 */ DATA_4( 0x384d9916, 0x24716060, 0x000003c4, 0x00000000 ),
	/* 7336 */ DATA_4( 0xca507188, 0xc1efe2ff, 0x0001fe39, 0x00000000 ),
	/* 7352 */ DATA_4( 0x5fa43e28, 0x99498d0b, 0x00e04e0b, 0x00000000 ),
	/* 7368 */ DATA_4( 0xa221feb4, 0x68f38623, 0x5050712d, 0x00000000 ),
	/* 7384 */ DATA_4( 0xc71e7364, 0xbe707244, 0xdb5e22d3, 0x00000016 ),
	/* 7400 */ DATA_4( 0xcdbcb2c8, 0x7c0eb1e4, 0x550f4b2f, 0x00000503 ),
	/* 7416 */ DATA_4( 0xa442aeb8, 0xd551ab7b, 0x4332db43, 0x0000d05e ),
	/* 7432 */ DATA_4( 0x7d5feb88, 0xae649cd3, 0x07f19f81, 0x0017b9bb ),
	/* 7448 */ DATA_4( 0xb30c8036, 0x4d9bdf57, 0x77bb162e, 0x01c129f0 ),
	/* 7464 */ DATA_4( 0xff1a96f6, 0x57da5d14, 0x1fcafb44, 0x132ee4ca ),
	/* 7480 */ DATA_4( 0xc19c893c, 0x7952da42, 0x16303817, 0x62b3716c ),
	/* 7496 */ DATA_4( 0xba66ba39, 0xba728367, 0xaac6d0da, 0x9665874b ),
	/* 7512 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 7 : [ 21.16437, 24.31133 ) - zero = 22.76008 */
	/* 7520 */ DATA_1x2( 0x70b1a769, 0xc27d98ef ),
	/* 7528 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 7536 */ DATA_2x2( 0xa6c55ee4, 0xb614a71e, 0x70ee52fe, 0x0cc50107 ),
	/* 7552 */ DATA_2x2( 0x4d4af06e, 0xf203b9e4, 0x417375bd, 0xd6da7984 ),
	/* degree = 28 - unpacked coefficients */
	/* 7568 */ DATA_4( 0x66ee4d3b, 0x00110453, 0x00000000, 0x00000000 ),
	/* 7584 */ DATA_4( 0x1d7cb048, 0x0e0b8de1, 0x00000000, 0x00000000 ),
	/* 7600 */ DATA_4( 0x4724ac98, 0xed53b778, 0x00000009, 0x00000000 ),
	/* 7616 */ DATA_4( 0x08922c9d, 0x2d78744e, 0x00000600, 0x00000000 ),
	/* 7632 */ DATA_4( 0x3593d7b2, 0x845cccaa, 0x00030f79, 0x00000000 ),
	/* 7648 */ DATA_4( 0x10332b83, 0x6d77eef2, 0x014bbe42, 0x00000000 ),
	/* 7664 */ DATA_4( 0xde7ae9da, 0x990cbbf8, 0x725dd492, 0x00000000 ),
	/* 7680 */ DATA_4( 0xdb86484d, 0x9f6fe7b2, 0x56a09da1, 0x0000001f ),
	/* 7696 */ DATA_4( 0xc593b8b5, 0xd607c201, 0x2f363f01, 0x0000069f ),
	/* 7712 */ DATA_4( 0x2a5f3e12, 0x54c035ad, 0x1b0a816e, 0x00010990 ),
	/* 7728 */ DATA_4( 0xffb42ebd, 0x5c230fe9, 0x7c248d45, 0x001d407f ),
	/* 7744 */ DATA_4( 0x551240ee, 0xb807115c, 0x682813be, 0x0219e4c8 ),
	/* 7760 */ DATA_4( 0x9ad41b60, 0xb5c378d9, 0x7a96e94f, 0x166f4ec2 ),
	/* 7776 */ DATA_4( 0x83e91784, 0x9d6bf5b3, 0xecbd007f, 0x71786b67 ),
	/* 7792 */ DATA_4( 0xc1668984, 0x0a97b7ca, 0xb8310cb7, 0xab32709d ),
	/* 7808 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 7816 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 7832 */ DATA_4( 0xf9f734ef, 0x0ea9c589, 0x00000000, 0x00000000 ),
	/* 7848 */ DATA_4( 0x2dd34c92, 0xe1719f95, 0x0000000a, 0x00000000 ),
	/* 7864 */ DATA_4( 0x82e584cf, 0x0c08a53e, 0x000006c4, 0x00000000 ),
	/* 7880 */ DATA_4( 0x6301c826, 0xfdf1b297, 0x00038c59, 0x00000000 ),
	/* 7896 */ DATA_4( 0xec051bfd, 0x623aba38, 0x018b5659, 0x00000000 ),
	/* 7912 */ DATA_4( 0x7f572818, 0xa6592e6c, 0x8bfe4edb, 0x00000000 ),
	/* 7928 */ DATA_4( 0x00e4a3d6, 0xc843ff1e, 0x5cd09366, 0x00000027 ),
	/* 7944 */ DATA_4( 0x99bae7eb, 0xfae1afbf, 0xb1617ea3, 0x00000885 ),
	/* 7960 */ DATA_4( 0x3045b339, 0x4cc00899, 0x6a58443f, 0x00015d85 ),
	/* 7976 */ DATA_4( 0x31e34e7e, 0x0c79001e, 0xb3becd2b, 0x00274679 ),
	/* 7992 */ DATA_4( 0x782d1a2d, 0x68041afb, 0x3caecdd0, 0x02de8daa ),
	/* 8008 */ DATA_4( 0xc673bea7, 0x3c3e38c3, 0x2652d493, 0x1f0de053 ),
	/* 8024 */ DATA_4( 0x2fc71dc1, 0xc035e379, 0xc72b4dec, 0x9e9b4fca ),
	/* 8040 */ DATA_4( 0x832058fc, 0xf184a9e8, 0x846e329a, 0xf0b2aaf0 ),
	/* 8056 */ DATA_1x2( 0x000000-6, 0x00000000 ),

	/* Interval polynomial coefficients for y0 */

	/* Data for interval 0 : [ 0.0, 8.6537e-1 ) - zero = 6.5743e-1 */
	/* 8064 */ DATA_1x2( 0xbd7794ff, 0x06ec4664 ),
	/* 8072 */ DATA_1x2( 0x00e2a9ec, 0x000001a0 ),
	/* 8080 */ DATA_2x2( 0x18d15319, 0xa84d599b, 0x956c7ef0, 0xf5d26a17 ),
	/* 8096 */ DATA_2x2( 0x38a765da, 0x0f4d6ad9, 0x24ebbc28, 0xb509582f ),
	/* degree = 20 - unpacked coefficients */
	/* 8112 */ DATA_4( 0xfadd5e68, 0x34b261da, 0x00000000, 0x00000000 ),
	/* 8128 */ DATA_4( 0xcb421740, 0xfd08be84, 0x0000007e, 0x00000000 ),
	/* 8144 */ DATA_4( 0xb9bbc764, 0xb7088f3d, 0x0000ac69, 0x00000000 ),
	/* 8160 */ DATA_4( 0x523fa607, 0x868490b9, 0x00baa849, 0x00000000 ),
	/* 8176 */ DATA_4( 0x7d0ba298, 0x20803702, 0x9c210b4d, 0x00000000 ),
	/* 8192 */ DATA_4( 0x0cd71b49, 0xd10d6e8c, 0x0f45e2e7, 0x00000061 ),
	/* 8208 */ DATA_4( 0xdaa306e3, 0xefbf5b64, 0x90468c00, 0x00002a8a ),
	/* 8224 */ DATA_4( 0xe3d146bf, 0xea40c815, 0x4efc3139, 0x000c2f40 ),
	/* 8240 */ DATA_4( 0xdc7c1c09, 0x2f3206e3, 0x04044e29, 0x02062a8a ),
	/* 8256 */ DATA_4( 0xc22f9740, 0x2869da7e, 0x70eed191, 0x283764ca ),
	/* 8272 */ DATA_4( 0x479b008d, 0x9aab0c6f, 0xea7aa207, 0xdcd36dff ),
	/* 8288 */ DATA_1x2( 0x000000-2, 0x00000000 ),
	/* 8296 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 8312 */ DATA_4( 0x3a937892, 0x6db202db, 0x00000008, 0x00000000 ),
	/* 8328 */ DATA_4( 0xa52209d4, 0x497337fe, 0x00000c72, 0x00000000 ),
	/* 8344 */ DATA_4( 0xa055030d, 0xffc5ee25, 0x000f2973, 0x00000000 ),
	/* 8360 */ DATA_4( 0x6f308b62, 0x109c1f7a, 0x0e7ee841, 0x00000000 ),
	/* 8376 */ DATA_4( 0x382478fa, 0x5e237453, 0x83a7a1d5, 0x0000000a ),
	/* 8392 */ DATA_4( 0xf035005f, 0x55cd99bc, 0xada4eb3a, 0x00000587 ),
	/* 8408 */ DATA_4( 0x3581f76c, 0x9ba4b011, 0xe45b59eb, 0x0001fab3 ),
	/* 8424 */ DATA_4( 0x9af8a68c, 0x2183d7bb, 0x34142fca, 0x00701e82 ),
	/* 8440 */ DATA_4( 0x63f1d2b1, 0x9d8ca03a, 0x3f28e750, 0x0d02692d ),
	/* 8456 */ DATA_4( 0xec83d1f0, 0x6c25b516, 0xfb40a95a, 0x8cb515d8 ),
	/* 8472 */ DATA_1x2( 0x000000-2, 0x00000000 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 1 : [ 8.6537e-1, 9.3381e-1 ) - zero = 8.9358e-1 */
	/* 8480 */ DATA_1x2( 0x752085e1, 0x07787135 ),
	/* 8488 */ DATA_1x2( 0x01c4c101, 0x00000170 ),
	/* 8496 */ DATA_2x2( 0xa0bf51ea, 0xe4c175c6, 0xf82ed3d0, 0x9d270347 ),
	/* 8512 */ DATA_2x2( 0x14fc41e1, 0xb291665e, 0x8c6e0e28, 0xaabfa36d ),
	/* degree = 19 - packed coefficients */
	/* 8528 */ DATA_4( 0x1e4214b3, 0x0537aa87, 0x15c17539, 0x88ed6fcb ),
	/* 8544 */ DATA_4( 0xe2c5a3b2, 0x191b7eea, 0x25224979, 0x913d0fd0 ),
	/* 8560 */ DATA_4( 0x3317fa13, 0xf4a92b10, 0x4d885043, 0x891a9bbb ),
	/* 8576 */ DATA_4( 0xd38fdae4, 0x309e8647, 0xd00c6830, 0x81a41864 ),
	/* 8592 */ DATA_4( 0x10524ffb, 0x31e3e738, 0x4498b8af, 0xf61b8e86 ),
	/* 8608 */ DATA_4( 0x09e6b64a, 0x0fa6b017, 0x83280dab, 0xea825b81 ),
	/* 8624 */ DATA_4( 0xfdf62123, 0x592b6710, 0x24921a46, 0xe0704b9c ),
	/* 8640 */ DATA_4( 0x5babf28a, 0xb98b5079, 0xe46747a9, 0xd7e18586 ),
	/* 8656 */ DATA_4( 0x1620f7d3, 0x219dc6e0, 0x999af224, 0xd0db65e5 ),
	/* 8672 */ DATA_4( 0xe80630c2, 0xa559f4fd, 0x2d691f25, 0xcb6f4dde ),
	/* 8688 */ DATA_4( 0x3793bdfb, 0xd2a23d2e, 0x27f4c2c9, 0xc7bf19b6 ),
	/* 8704 */ DATA_4( 0x13d3348a, 0xb8eec25d, 0xb057d8a9, 0xc6046825 ),
	/* 8720 */ DATA_4( 0x08c2fbbb, 0xcb5994b1, 0x841330c5, 0xc69ada40 ),
	/* 8736 */ DATA_4( 0x2339ad8a, 0x82fe76e2, 0x6931e755, 0xca125c98 ),
	/* 8752 */ DATA_4( 0x38c273b3, 0x18dc4cb1, 0xcfe5cc53, 0xd1cb5402 ),
	/* 8768 */ DATA_4( 0x4fccc2c2, 0x9b5288c3, 0x14b75d53, 0xe0340436 ),
	/* 8784 */ DATA_4( 0xc968e1b3, 0x8f61a201, 0x59c4079a, 0xe78c7352 ),
	/* 8800 */ DATA_4( 0xa60770b0, 0xb7f68598, 0x79f4b7ad, 0xe1d899c5 ),
	/* 8816 */ DATA_4( 0x5a7e79e9, 0x40deb8c7, 0x6b881051, 0xfbf1c523 ),
	/* 8832 */ DATA_4( 0x89479eaa, 0xa3645d0c, 0x25c44edd, 0xe121b8c2 ),

	/* Signs don't alternate */

	/* Data for interval 2 : [ 9.3381e-1, 2.19714 ) - zero = 1.56548 */
	/* 8848 */ DATA_1x2( 0xdff242e4, 0x1193bed4 ),
	/* 8856 */ DATA_1x2( 0x01a5c28b, 0x000001b0 ),
	/* 8864 */ DATA_2x2( 0xa896462c, 0xc8618052, 0x542d332c, 0x83cbfce9 ),
	/* 8880 */ DATA_2x2( 0x00000000, 0xd373bb36, 0x00000001, 0x00000000 ),
	/* degree = 23 - packed coefficients */
	/* 8896 */ DATA_4( 0xa9fc65d8, 0x1ae02e87, 0x111ba5f1, 0xf7edc0d8 ),
	/* 8912 */ DATA_4( 0xe1d174c3, 0x98b1d944, 0xec330367, 0xd15dad27 ),
	/* 8928 */ DATA_4( 0xaa9211d9, 0x82ec44c9, 0x5ca35aef, 0xfa470622 ),
	/* 8944 */ DATA_4( 0xbe680a02, 0xa61dbfd6, 0xc4f3e797, 0xc759aaa6 ),
	/* 8960 */ DATA_4( 0xf4b69bd8, 0x33b87cb8, 0xa16f9358, 0xd0ed77e8 ),
	/* 8976 */ DATA_4( 0x3d90fe03, 0xdd33eb29, 0x485fcd39, 0x9ba3f2eb ),
	/* 8992 */ DATA_4( 0xc8c9261b, 0x00553639, 0x9ba6ef47, 0x8e221063 ),
	/* 9008 */ DATA_4( 0x44aba002, 0xd613a63d, 0xb0900653, 0xc39504ec ),
	/* 9024 */ DATA_4( 0xb71ab3da, 0xe9b3a532, 0xe5cca40d, 0x99ed1a33 ),
	/* 9040 */ DATA_4( 0xc7497143, 0x45aa7126, 0xb607f9a3, 0xc0141f96 ),
	/* 9056 */ DATA_4( 0xe900bc1b, 0x40946ca1, 0x7d468a63, 0x80ca02c8 ),
	/* 9072 */ DATA_4( 0x7dd044c4, 0xef9058e0, 0x50785d47, 0x8da2da2a ),
	/* 9088 */ DATA_4( 0x02848a5a, 0xe0b41e9b, 0xaa29abad, 0xa02859dd ),
	/* 9104 */ DATA_4( 0xfa430a05, 0xf34a5a4c, 0xa9a715aa, 0x93c25dbd ),
	/* 9120 */ DATA_4( 0x197dcddd, 0x91c4eed8, 0xfc54e8b5, 0x8c627bab ),
	/* 9136 */ DATA_4( 0x5ce50fc4, 0x87df6378, 0x03bc3791, 0xc4980192 ),
	/* 9152 */ DATA_4( 0x547f815c, 0x03afe68f, 0x7e114aee, 0xa0b7f20c ),
	/* 9168 */ DATA_4( 0x1375e207, 0x9716cee6, 0x6421a012, 0x80ccd223 ),
	/* 9184 */ DATA_4( 0xc1c6d623, 0x9f3bab7a, 0xaa9a6c78, 0xd50d1914 ),
	/* 9200 */ DATA_4( 0xb363c481, 0x143a0ff9, 0xb3438a61, 0xa9477b4f ),
	/* 9216 */ DATA_4( 0x864893dc, 0x4f4c33d7, 0x8097349e, 0x832be6fe ),
	/* 9232 */ DATA_4( 0x2505e90c, 0xedb3d1ee, 0x6704df5d, 0xe4ff59b3 ),
	/* 9248 */ DATA_4( 0x9dea4097, 0x77ba767c, 0x50c1dc8f, 0xad1aa658 ),
	/* 9264 */ DATA_4( 0xca8a8c15, 0xe8d7c711, 0x951e906f, 0x8b8694a8 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 3 : [ 2.19714, 5.42968 ) - zero = 3.95768 */
	/* 9280 */ DATA_1x2( 0x0f605cef, 0x2b6ffc9d ),
	/* 9288 */ DATA_1x2( 0x01cc4207, 0x00000350 ),
	/* 9296 */ DATA_2x2( 0xc2b4de0f, 0xfd4a9a6c, 0x7b23405a, 0x95187fbc ),
	/* 9312 */ DATA_2x2( 0x7bce575f, 0x5cef3ad4, 0x801120e2, 0xf5906a19 ),
	/* degree = 49 - packed coefficients */
	/* 9328 */ DATA_4( 0x12c734cb, 0x00e20686, 0x4bf4c1ff, 0xbc225172 ),
	/* 9344 */ DATA_4( 0x0e30e8ab, 0x960cd407, 0x79b05ec8, 0xa197c489 ),
	/* 9360 */ DATA_4( 0xd9b34d68, 0x2cec6a85, 0xa2f62938, 0xe3ba1c6e ),
	/* 9376 */ DATA_4( 0x8de8a00e, 0x096f02f1, 0x8b7a8f9f, 0x878021a9 ),
	/* 9392 */ DATA_4( 0x177a48e9, 0xac891db6, 0x5dccc44e, 0xf3f47ff1 ),
	/* 9408 */ DATA_4( 0x1bb0aad1, 0x121747de, 0xe55f2148, 0xc6612700 ),
	/* 9424 */ DATA_4( 0x3dc035e6, 0x7e7966f4, 0xdcd30cd1, 0xbf68825a ),
	/* 9440 */ DATA_4( 0x4f067938, 0xd034dc01, 0xc7014382, 0xc0ab2bc3 ),
	/* 9456 */ DATA_4( 0xb9866c41, 0xc5215fb0, 0xa7787e92, 0xde68090a ),
	/* 9472 */ DATA_4( 0xd5014def, 0x89dc717f, 0x2584a763, 0xd7e9295b ),
	/* 9488 */ DATA_4( 0x3af31909, 0xca91e197, 0xf7933b2b, 0xd7018887 ),
	/* 9504 */ DATA_4( 0x9cb4e2f0, 0x747796e0, 0x73d5b0ed, 0xa4796862 ),
	/* 9520 */ DATA_4( 0x8963d96b, 0x8e845f6f, 0x247bd38f, 0xeb88b0ff ),
	/* 9536 */ DATA_4( 0x4fe56408, 0xc6b936f3, 0x58ea8219, 0xf98515e6 ),
	/* 9552 */ DATA_4( 0xfa3f7ccb, 0x0532f16b, 0xfb8a4e07, 0xe756a818 ),
	/* 9568 */ DATA_4( 0x77ac2e6a, 0x66b1a0e7, 0x8e65010c, 0xe27d3f6d ),
	/* 9584 */ DATA_4( 0x2baff42b, 0xe99d88a6, 0x1f854df9, 0xd72ccb59 ),
	/* 9600 */ DATA_4( 0xedf71f4a, 0xf0acb77a, 0x6deb02b8, 0xdd6ae0b2 ),
	/* 9616 */ DATA_4( 0xcc99e8cb, 0xb9432914, 0x2c7f5666, 0xe3997900 ),
	/* 9632 */ DATA_4( 0x213fb70a, 0x90b0de08, 0xd193bf81, 0xe7fd600e ),
	/* 9648 */ DATA_4( 0x6586bf2b, 0x3b6567b5, 0xf3493736, 0xecdedb89 ),
	/* 9664 */ DATA_4( 0x1ca927aa, 0xb32da36b, 0x53a6abe1, 0xf2508b39 ),
	/* 9680 */ DATA_4( 0x714714cb, 0x9de99455, 0x26d7b134, 0xf8222ac3 ),
	/* 9696 */ DATA_4( 0x60829fe8, 0x6f26e3ff, 0x436f6794, 0xfe609df9 ),
	/* 9712 */ DATA_4( 0x6d5dbe0b, 0x90759599, 0x112c0d84, 0x828e4c5e ),
	/* 9728 */ DATA_4( 0xa1707b2a, 0xf5ef3ece, 0xd9d3aff3, 0x8631d373 ),
	/* 9744 */ DATA_4( 0xdfb3e1eb, 0xd06796f4, 0x9b9aa4ab, 0x8a22c2f4 ),
	/* 9760 */ DATA_4( 0xe636b3ca, 0x3d7344be, 0x1ae6e22d, 0x8e6a63aa ),
	/* 9776 */ DATA_4( 0x96742e0b, 0x21f1c163, 0xafa687ba, 0x93137aee ),
	/* 9792 */ DATA_4( 0x0bb6898a, 0x1da873f8, 0x82e165ce, 0x982a9882 ),
	/* 9808 */ DATA_4( 0x631ea4cb, 0x2e7fd532, 0xabac3429, 0x9dbe8fdf ),
	/* 9824 */ DATA_4( 0x5c20e16a, 0x2f162c9d, 0x0b672a8b, 0xa3e0e226 ),
	/* 9840 */ DATA_4( 0x57ac4beb, 0x498edf6d, 0x79dde4cd, 0xaaa40638 ),
	/* 9856 */ DATA_4( 0x375a468a, 0x7d4acddb, 0xdbf5555c, 0xb21e3d24 ),
	/* 9872 */ DATA_4( 0x84238c0b, 0x8965a31c, 0xf8d2816b, 0xba9949b0 ),
	/* 9888 */ DATA_4( 0x689d84ca, 0x36c29d71, 0xa33df109, 0xc4572e41 ),
	/* 9904 */ DATA_4( 0x2b04b2cb, 0x69b9178a, 0xf477af89, 0xcca739b6 ),
	/* 9920 */ DATA_4( 0x6eb4edca, 0xab9da70f, 0x5149ee5b, 0xd2d0f9d1 ),
	/* 9936 */ DATA_4( 0xf218e849, 0x362cfb4f, 0xb3278774, 0xfb49c414 ),
	/* 9952 */ DATA_4( 0x0e8995ee, 0x0074e409, 0xa2d37f3e, 0xa2975004 ),
	/* 9968 */ DATA_4( 0x6508b287, 0x9bde515c, 0x0dfcb4ec, 0xbbb82c3a ),
	/* 9984 */ DATA_4( 0x78b33b67, 0x4b64be86, 0x44da6312, 0x9d90b420 ),
	/* 10000 */ DATA_4( 0xe16a3029, 0x7ec4e26b, 0x5331ed75, 0xa431b8f3 ),
	/* 10016 */ DATA_4( 0xfecb1c2a, 0x0be85b4c, 0x6e7e1f4a, 0xd5960ff6 ),
	/* 10032 */ DATA_4( 0xb7217fe6, 0x3b3676ef, 0xb3129c89, 0xccc13b28 ),
	/* 10048 */ DATA_4( 0xbea832cd, 0x24f55c28, 0x7c5206bf, 0x8f195e27 ),
	/* 10064 */ DATA_4( 0x3d2e3b89, 0x7e231635, 0xcc04b31b, 0xe08b7ee2 ),
	/* 10080 */ DATA_4( 0x1671ce0e, 0x27e96ad6, 0xa875e756, 0xefb6acdf ),
	/* 10096 */ DATA_4( 0x05d53fe8, 0x2522fb92, 0x1b3f74c4, 0xd04e4948 ),
	/* 10112 */ DATA_4( 0x2695920d, 0x013721b6, 0x095060d2, 0xce1a12b5 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 4 : [ 5.42968, 8.59601 ) - zero = 7.08605 */
	/* 10128 */ DATA_1x2( 0x85a6d0a3, 0x44c49eb9 ),
	/* 10136 */ DATA_1x2( 0x01c88185, 0x00000260 ),
	/* 10144 */ DATA_2x2( 0x39081734, 0xe2c0ee27, 0x49881acc, 0x45adb505 ),
	/* 10160 */ DATA_2x2( 0xd158a533, 0x2b9cf914, 0xe2c8d873, 0xd28d9fe4 ),
	/* degree = 34 - packed coefficients */
	/* 10176 */ DATA_4( 0xe62d1166, 0xe9b5afb1, 0xc1ab80fa, 0xb1d8622e ),
	/* 10192 */ DATA_4( 0xfd96d727, 0xcbd66ff7, 0xd7563a56, 0xcc4794ce ),
	/* 10208 */ DATA_4( 0x6f2ba354, 0x5b1b5ba7, 0xb90d076c, 0xa59af143 ),
	/* 10224 */ DATA_4( 0x90bd95f5, 0x822b5c34, 0x3e9a41d6, 0xe0f1a636 ),
	/* 10240 */ DATA_4( 0xd9b25ec4, 0xad3ef233, 0x55036f55, 0xe8757aa9 ),
	/* 10256 */ DATA_4( 0xe79f6c65, 0x98f5bf18, 0x9acc62c1, 0xc9ee29c0 ),
	/* 10272 */ DATA_4( 0xcacc9ec4, 0x7778e653, 0x52260f25, 0xb682e63f ),
	/* 10288 */ DATA_4( 0xd97c1615, 0x0580f8c2, 0xfc89f512, 0xa7edf4a6 ),
	/* 10304 */ DATA_4( 0x745cd954, 0x8955bc86, 0x07a04b02, 0x99f50980 ),
	/* 10320 */ DATA_4( 0xff387365, 0xa0c463ec, 0x831e4517, 0x8d2cd47f ),
	/* 10336 */ DATA_4( 0xabcc9516, 0x7ea4fc70, 0x924df11a, 0x81ae2ffe ),
	/* 10352 */ DATA_4( 0x51447b65, 0x0e105109, 0xc36b92ab, 0xede913c7 ),
	/* 10368 */ DATA_4( 0x8b605834, 0x3534cacd, 0xe7a7eb68, 0xd9d82b32 ),
	/* 10384 */ DATA_4( 0x838c24c5, 0x156ca949, 0x501fa1d4, 0xcd863fe1 ),
	/* 10400 */ DATA_4( 0x8a13a404, 0xe43bd8b9, 0x0d273a1b, 0xc6fa78ab ),
	/* 10416 */ DATA_4( 0x10bce6f7, 0xc2e72e6a, 0xfd1b4e6c, 0x9388b091 ),
	/* 10432 */ DATA_4( 0xc6d9c740, 0x8380f0e5, 0x4842e818, 0x9374967e ),
	/* 10448 */ DATA_4( 0x1d46f983, 0x8086cd00, 0xb1b21bbd, 0x95ead41d ),
	/* 10464 */ DATA_4( 0xd7213714, 0x498f95c5, 0x3d32decc, 0x9c67835a ),
	/* 10480 */ DATA_4( 0xa12ff360, 0x75ba96c8, 0xc35238d3, 0x99b2ead3 ),
	/* 10496 */ DATA_4( 0x3da76b55, 0x9a6f0e79, 0x2a8b2518, 0x833ce6ac ),
	/* 10512 */ DATA_4( 0xfc052ea3, 0xed3bce8d, 0xf1c9ac10, 0xb8a61495 ),
	/* 10528 */ DATA_4( 0x88283724, 0x7331bd67, 0x411ed6cc, 0xf8a72ac2 ),
	/* 10544 */ DATA_4( 0x3d223f60, 0xa74245c1, 0xb36392de, 0xfd36284a ),
	/* 10560 */ DATA_4( 0x70acb8e5, 0x88761104, 0xacd6cb24, 0xa2151e99 ),
	/* 10576 */ DATA_4( 0x787e2983, 0x088e3231, 0xd62242d3, 0x85140a6b ),
	/* 10592 */ DATA_4( 0x411ec486, 0x49b97b74, 0xf78a6d6b, 0x9a553ab9 ),
	/* 10608 */ DATA_4( 0xcbaaf082, 0x4aa4eb40, 0x97cb50ca, 0xb549139a ),
	/* 10624 */ DATA_4( 0x40850cc7, 0x0c760c79, 0x29192023, 0xc0bbf27f ),
	/* 10640 */ DATA_4( 0x94381193, 0x0ba54449, 0xc8e45927, 0x936eb8f1 ),
	/* 10656 */ DATA_4( 0x9df2b40a, 0xcf4c5f59, 0xef151b54, 0x8e9af42f ),
	/* 10672 */ DATA_4( 0x2bdddc22, 0x353487eb, 0xa93e59ab, 0xd978a54a ),
	/* 10688 */ DATA_4( 0xfee08c1d, 0x53687556, 0x5fa29292, 0xc4b4e326 ),
	/* 10704 */ DATA_4( 0xd7a79d33, 0x8cd90da7, 0xe26aba83, 0xad77b08f ),
	/* 10720 */ DATA_4( 0xab356498, 0x76f69065, 0x4bd2d4e5, 0x99a66503 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 5 : [ 8.59601, 11.74915 ) - zero = 10.22235 */
	/* 10736 */ DATA_1x2( 0x50c81810, 0x5dfe44e3 ),
	/* 10744 */ DATA_1x2( 0x01c74207, 0x00000210 ),
	/* 10752 */ DATA_2x2( 0x23eabc69, 0xa38eb9ad, 0x6d6f6ad3, 0x6c010dc7 ),
	/* 10768 */ DATA_2x2( 0x868c31a8, 0x5b28953d, 0x3fe525c4, 0x5866d012 ),
	/* degree = 29 - packed coefficients */
	/* 10784 */ DATA_4( 0xf04b9749, 0x7f1723a0, 0xbe88b75e, 0x913527f0 ),
	/* 10800 */ DATA_4( 0x1dca2308, 0x67f7cbff, 0x88897ab0, 0x954478e8 ),
	/* 10816 */ DATA_4( 0x7107af67, 0xc0f5a7c3, 0x8aece1d9, 0xdf33b559 ),
	/* 10832 */ DATA_4( 0x67675c4a, 0xc47cb783, 0x311d2d07, 0xe8d4f7cd ),
	/* 10848 */ DATA_4( 0x546ad820, 0x84b8229f, 0xc5fe5c72, 0xdd7b6cfb ),
	/* 10864 */ DATA_4( 0x97af3827, 0x1e17352b, 0xb05e3d57, 0x85055bee ),
	/* 10880 */ DATA_4( 0x2cb6c445, 0xf36e126b, 0x97f215ed, 0xc1c36410 ),
	/* 10896 */ DATA_4( 0x51a28926, 0xc0200368, 0x7c310ef4, 0xc9bf7454 ),
	/* 10912 */ DATA_4( 0xfd392dc4, 0xf701aa1e, 0xc085dd95, 0xbcb1d391 ),
	/* 10928 */ DATA_4( 0xc0202cc7, 0x9423c8c1, 0xe3a04530, 0xc9fdb7cb ),
	/* 10944 */ DATA_4( 0x4aa83185, 0x627d2b42, 0x9c6d50f0, 0xb0b5a6b0 ),
	/* 10960 */ DATA_4( 0x311a1026, 0x458f4bd5, 0xaf313709, 0xb009dd63 ),
	/* 10976 */ DATA_4( 0x34b441c6, 0x116bca81, 0x2bc7589d, 0x837248fa ),
	/* 10992 */ DATA_4( 0x7207cac7, 0xe06adb21, 0xdf3f5df1, 0xf86e2033 ),
	/* 11008 */ DATA_4( 0xaebe2865, 0xdaf21df9, 0x82121002, 0x9de4e65b ),
	/* 11024 */ DATA_4( 0x75c1ae08, 0xde278fd4, 0xdd4bfa07, 0x8c79815e ),
	/* 11040 */ DATA_4( 0x76ebfea6, 0x4381ed9c, 0x74ca7615, 0x9309b2ce ),
	/* 11056 */ DATA_4( 0x6df36e09, 0xd26f8c10, 0x2d52c320, 0xf64c0282 ),
	/* 11072 */ DATA_4( 0x75fc2ca5, 0x2f7a73be, 0xbd010033, 0xccec6217 ),
	/* 11088 */ DATA_4( 0x7697b36a, 0x05023f41, 0x18509b3f, 0xa1451d1f ),
	/* 11104 */ DATA_4( 0x67f23084, 0xb8f38e6e, 0xeda745d0, 0xc9f5cf8e ),
	/* 11120 */ DATA_4( 0x69353f8b, 0x83b3ecf7, 0x46c7e687, 0x95754f62 ),
	/* 11136 */ DATA_4( 0x09a0c8c7, 0x7bf6ba65, 0xa1c35037, 0x82029d5f ),
	/* 11152 */ DATA_4( 0xde1f10ac, 0x9fade65f, 0xf0f09c2a, 0xb57eeabd ),
	/* 11168 */ DATA_4( 0x21f3b0e6, 0xaf5ba739, 0x87261cc7, 0xbfc26be2 ),
	/* 11184 */ DATA_4( 0x7b8244ed, 0x292f724a, 0xdc893c43, 0xff11c8a7 ),
	/* 11200 */ DATA_4( 0xeaef55e7, 0x38f2fac1, 0xf4885d34, 0x8192f720 ),
	/* 11216 */ DATA_4( 0x6f861a72, 0x8b79e78b, 0xaab57ac6, 0xa7333d38 ),
	/* 11232 */ DATA_4( 0xc3001626, 0x375f45ba, 0xfabe28fd, 0xc81b228f ),
	/* 11248 */ DATA_4( 0x28d8398b, 0xe152e0e7, 0x95cf85c2, 0xffb1ae63 ),

	/* Data for interval 6 : [ 11.74915, 14.89744 ) - zero = 13.3611 */
	/* 11264 */ DATA_1x2( 0x7a122aa1, 0x772df623 ),
	/* 11272 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 11280 */ DATA_2x2( 0x0f3a4d04, 0xd5c70e25, 0xb652c246, 0x0fc42f21 ),
	/* 11296 */ DATA_2x2( 0xba42285f, 0x9474724d, 0x6247c42c, 0x1dc64858 ),
	/* degree = 28 - unpacked coefficients */
	/* 11312 */ DATA_4( 0x0275330c, 0x0011541d, 0x00000000, 0x00000000 ),
	/* 11328 */ DATA_4( 0x6f834cc4, 0x0e2ca943, 0x00000000, 0x00000000 ),
	/* 11344 */ DATA_4( 0x48bb90c5, 0x1fd5595b, 0x0000000a, 0x00000000 ),
	/* 11360 */ DATA_4( 0x5d653f22, 0xa74b46b0, 0x00000630, 0x00000000 ),
	/* 11376 */ DATA_4( 0x156f3ebe, 0x7681aebc, 0x0003337f, 0x00000000 ),
	/* 11392 */ DATA_4( 0xef83c69c, 0xbb605341, 0x0160b43c, 0x00000000 ),
	/* 11408 */ DATA_4( 0x52922886, 0xbe3b3a6f, 0x7bf62ad4, 0x00000000 ),
	/* 11424 */ DATA_4( 0x175910c2, 0xd0644623, 0xbe0f590f, 0x00000022 ),
	/* 11440 */ DATA_4( 0x2a7a7d0b, 0x8e201832, 0xd74d592d, 0x00000788 ),
	/* 11456 */ DATA_4( 0xaf801909, 0x09b5036e, 0xe6c75918, 0x0001371a ),
	/* 11472 */ DATA_4( 0x711436e7, 0x83b4849d, 0x624508f1, 0x00235a0e ),
	/* 11488 */ DATA_4( 0xf9b93bfd, 0x7d62eb57, 0xa8d9a906, 0x029e15ef ),
	/* 11504 */ DATA_4( 0x05f82619, 0xd33f5f2e, 0x34992cf5, 0x1caaa76e ),
	/* 11520 */ DATA_4( 0x2c56f255, 0x55d6e290, 0x459b3ca6, 0x936559c5 ),
	/* 11536 */ DATA_4( 0x96a35d96, 0xcc656551, 0xca003889, 0xdf99513a ),
	/* 11552 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 11560 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 11576 */ DATA_4( 0xc66b7685, 0x05143807, 0x00000000, 0x00000000 ),
	/* 11592 */ DATA_4( 0x6ba6df40, 0xde615463, 0x00000003, 0x00000000 ),
	/* 11608 */ DATA_4( 0x56914e07, 0x0e6457e2, 0x00000278, 0x00000000 ),
	/* 11624 */ DATA_4( 0x8f8f2510, 0x966e26e1, 0x000155c0, 0x00000000 ),
	/* 11640 */ DATA_4( 0x85dbcac7, 0x56416ebb, 0x0099eba5, 0x00000000 ),
	/* 11656 */ DATA_4( 0x2c338c99, 0x5a673169, 0x38a9d76b, 0x00000000 ),
	/* 11672 */ DATA_4( 0x0b3eb057, 0xa8ec6168, 0xa44f77f6, 0x00000010 ),
	/* 11688 */ DATA_4( 0x6ffd97d7, 0x5f60f96e, 0x11c4b38e, 0x000003c8 ),
	/* 11704 */ DATA_4( 0xa13a6fc7, 0xb89854d6, 0x03bd45f6, 0x0000a367 ),
	/* 11720 */ DATA_4( 0xfbc5a4a8, 0x33fcd1b4, 0xc8cb3c34, 0x00136021 ),
	/* 11736 */ DATA_4( 0x5901939c, 0xfbf0ff39, 0x094e219e, 0x017d1e28 ),
	/* 11752 */ DATA_4( 0xdb125cbd, 0xead57a20, 0x46d0306d, 0x10c5f18c ),
	/* 11768 */ DATA_4( 0xfd1b3cb2, 0x9a1103e1, 0x5975c9ab, 0x57c0f91c ),
	/* 11784 */ DATA_4( 0xd3a1f57e, 0x8c6d4236, 0x32909f86, 0x85e16c27 ),
	/* 11800 */ DATA_1x2( 0x000000-4, 0x00000000 ),

	/* Data for interval 7 : [ 14.89744, 18.0434 ) - zero = 16.50092 */
	/* 11808 */ DATA_1x2( 0xf8f1d4bc, 0x9058e34a ),
	/* 11816 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 11824 */ DATA_2x2( 0x0190a24b, 0x8401e3a0, 0xb3576c06, 0x446fa242 ),
	/* 11840 */ DATA_2x2( 0xdbd8b1c0, 0xc27dfa09, 0x01b999cd, 0x3118cab9 ),
	/* degree = 28 - unpacked coefficients */
	/* 11856 */ DATA_4( 0xa59bfc97, 0x00114a43, 0x00000000, 0x00000000 ),
	/* 11872 */ DATA_4( 0xc9399714, 0x0e433d90, 0x00000000, 0x00000000 ),
	/* 11888 */ DATA_4( 0x4df4b5bf, 0x26e62358, 0x0000000a, 0x00000000 ),
	/* 11904 */ DATA_4( 0x6065a09f, 0x13cf71d9, 0x00000630, 0x00000000 ),
	/* 11920 */ DATA_4( 0x42c712a6, 0x2ee58508, 0x00032fb2, 0x00000000 ),
	/* 11936 */ DATA_4( 0x688db073, 0xf6d29260, 0x015d3939, 0x00000000 ),
	/* 11952 */ DATA_4( 0x3f80f77f, 0x8cfa4824, 0x79ebb06e, 0x00000000 ),
	/* 11968 */ DATA_4( 0x003e7b79, 0x4fa28507, 0xe2cd9653, 0x00000021 ),
	/* 11984 */ DATA_4( 0xaa516888, 0x4670ff16, 0xd0f2ecb8, 0x00000745 ),
	/* 12000 */ DATA_4( 0x12eb2a7e, 0x5ead1183, 0x854ea8b0, 0x00012885 ),
	/* 12016 */ DATA_4( 0x594e6595, 0xd4c44b86, 0x2725ea9b, 0x002133ce ),
	/* 12032 */ DATA_4( 0x446ad289, 0xb97e87a9, 0xd802e5ef, 0x026ba2f9 ),
	/* 12048 */ DATA_4( 0xc4d73974, 0x54299e1e, 0x5f668434, 0x1a24a121 ),
	/* 12064 */ DATA_4( 0x43da8cd2, 0x85dad4aa, 0xceb51342, 0x85228901 ),
	/* 12080 */ DATA_4( 0x33b582b0, 0x3873c84e, 0x47714ab7, 0xc92e1acc ),
	/* 12096 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 12104 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 12120 */ DATA_4( 0x4256b70e, 0x0943b172, 0x00000000, 0x00000000 ),
	/* 12136 */ DATA_4( 0x2cd12ed9, 0xfa410e31, 0x00000006, 0x00000000 ),
	/* 12152 */ DATA_4( 0x602d522a, 0xe5fe82b7, 0x00000469, 0x00000000 ),
	/* 12168 */ DATA_4( 0x2cbb421c, 0x2b90dff1, 0x00025bf7, 0x00000000 ),
	/* 12184 */ DATA_4( 0xdcc718a6, 0x1951f8d1, 0x010c7ba1, 0x00000000 ),
	/* 12200 */ DATA_4( 0xd37666d9, 0x26ec2c4f, 0x6150f84b, 0x00000000 ),
	/* 12216 */ DATA_4( 0xe83469fe, 0x4e358d51, 0x10e67c00, 0x0000001c ),
	/* 12232 */ DATA_4( 0x04220178, 0x79903ce5, 0x1ca1d178, 0x0000063e ),
	/* 12248 */ DATA_4( 0xee6ac178, 0x1e8681f8, 0xc2985fd2, 0x00010730 ),
	/* 12264 */ DATA_4( 0x57a7fee4, 0xd246397c, 0x1e2e6565, 0x001e5de0 ),
	/* 12280 */ DATA_4( 0x44957221, 0x65b7a335, 0x622812bc, 0x02450752 ),
	/* 12296 */ DATA_4( 0x8778c506, 0x12ceedd1, 0x377fac86, 0x18f91421 ),
	/* 12312 */ DATA_4( 0x2fa7b210, 0x31acc39a, 0xdc948e6b, 0x809d9c67 ),
	/* 12328 */ DATA_4( 0x7061464a, 0xac7f4ee8, 0x3ac8efc4, 0xc312a49b ),
	/* 12344 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 8 : [ 18.0434, 21.18807 ) - zero = 19.64131 */
	/* 12352 */ DATA_1x2( 0x0c466a72, 0xa9812a49 ),
	/* 12360 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 12368 */ DATA_2x2( 0xff5eb4e8, 0x9d2166fa, 0xa2ad07a7, 0x0da55c08 ),
	/* 12384 */ DATA_2x2( 0xa238c80d, 0xf06937b4, 0xd1b3b4cd, 0xc5c8b4b8 ),
	/* degree = 28 - unpacked coefficients */
	/* 12400 */ DATA_4( 0x5e5e3591, 0x00113ae4, 0x00000000, 0x00000000 ),
	/* 12416 */ DATA_4( 0x85851058, 0x0e3affae, 0x00000000, 0x00000000 ),
	/* 12432 */ DATA_4( 0x821415c0, 0x193351be, 0x0000000a, 0x00000000 ),
	/* 12448 */ DATA_4( 0x8bbc780d, 0xd74a3ff1, 0x00000621, 0x00000000 ),
	/* 12464 */ DATA_4( 0x8cdc81c0, 0x035291ce, 0x000324bb, 0x00000000 ),
	/* 12480 */ DATA_4( 0x81533519, 0x7c0b29d5, 0x0156ab69, 0x00000000 ),
	/* 12496 */ DATA_4( 0x302cea60, 0xea2f4b75, 0x76dceb5f, 0x00000000 ),
	/* 12512 */ DATA_4( 0x94ea8b90, 0x245e77ad, 0xc926df2f, 0x00000020 ),
	/* 12528 */ DATA_4( 0x94f5ae75, 0x3017cca8, 0x9f065f12, 0x000006f9 ),
	/* 12544 */ DATA_4( 0x4d138db5, 0x5b6351ed, 0xc88b1876, 0x0001199e ),
	/* 12560 */ DATA_4( 0xcfb07c80, 0xf6e8e22d, 0x177306c9, 0x001f3671 ),
	/* 12576 */ DATA_4( 0x6c37598e, 0xbf0dc116, 0x65456d30, 0x0240db44 ),
	/* 12592 */ DATA_4( 0x34cccbae, 0x2f818e3d, 0xd6b0f657, 0x18247b02 ),
	/* 12608 */ DATA_4( 0x544acbc0, 0xfca6f21b, 0x85cd8303, 0x7a492e16 ),
	/* 12624 */ DATA_4( 0x7cadf8cc, 0xdea7e912, 0x55a3fa9f, 0xb8627b36 ),
	/* 12640 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 12648 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 12664 */ DATA_4( 0x0b90bddc, 0x0867bfe0, 0x00000000, 0x00000000 ),
	/* 12680 */ DATA_4( 0xc525832f, 0x47f13bf3, 0x00000006, 0x00000000 ),
	/* 12696 */ DATA_4( 0xda5bcb69, 0xca2451d8, 0x000003ef, 0x00000000 ),
	/* 12712 */ DATA_4( 0xf5f8761b, 0xb281e637, 0x00021513, 0x00000000 ),
	/* 12728 */ DATA_4( 0x636799c3, 0xf1ee8e7e, 0x00ea2837, 0x00000000 ),
	/* 12744 */ DATA_4( 0x9ba4c154, 0xe4642ae6, 0x53bb2fc2, 0x00000000 ),
	/* 12760 */ DATA_4( 0x0c79fd32, 0x222a23fc, 0xc83b5186, 0x00000017 ),
	/* 12776 */ DATA_4( 0x63f8fd1e, 0x2600940e, 0x7e82f5a6, 0x00000533 ),
	/* 12792 */ DATA_4( 0xd0694d15, 0xd9b9844d, 0xd424982f, 0x0000d758 ),
	/* 12808 */ DATA_4( 0x6859caf7, 0xfc0e9a31, 0x001006cc, 0x0018654b ),
	/* 12824 */ DATA_4( 0x6db213d6, 0x92cf0c33, 0xb8715104, 0x01caf84d ),
	/* 12840 */ DATA_4( 0x9cbc8b46, 0x7a2cd982, 0x38561d6b, 0x13761259 ),
	/* 12856 */ DATA_4( 0xc4957540, 0xcb417839, 0x648206eb, 0x635b0d93 ),
	/* 12872 */ DATA_4( 0xc9a92386, 0x64ed0631, 0x8f49b3c0, 0x96339883 ),
	/* 12888 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 9 : [ 21.18807, 24.33194 ) - zero = 22.78203 */
	/* 12896 */ DATA_1x2( 0xc10650a9, 0xc2a7d181 ),
	/* 12904 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 12912 */ DATA_2x2( 0xbd603b94, 0xb64197eb, 0x75071210, 0xea1019ea ),
	/* 12928 */ DATA_2x2( 0x3c8c5a3c, 0xb60c9276, 0x0cc55a85, 0xc9fb3195 ),
	/* degree = 28 - unpacked coefficients */
	/* 12944 */ DATA_4( 0x13a01e35, 0x00111750, 0x00000000, 0x00000000 ),
	/* 12960 */ DATA_4( 0x4351043c, 0x0e1d260c, 0x00000000, 0x00000000 ),
	/* 12976 */ DATA_4( 0x0bf426e2, 0xfbd7858f, 0x00000009, 0x00000000 ),
	/* 12992 */ DATA_4( 0xedb018a8, 0x277c65f1, 0x0000060a, 0x00000000 ),
	/* 13008 */ DATA_4( 0xd81bbae9, 0x38320b40, 0x0003151e, 0x00000000 ),
	/* 13024 */ DATA_4( 0xf34fdf4a, 0xaeea434a, 0x014e540f, 0x00000000 ),
	/* 13040 */ DATA_4( 0x7c0f196d, 0x314259ad, 0x734e1da2, 0x00000000 ),
	/* 13056 */ DATA_4( 0x68fc3219, 0x72319b74, 0x99da023c, 0x0000001f ),
	/* 13072 */ DATA_4( 0x56ec7a9a, 0x1ca155bd, 0x2639bda7, 0x000006ad ),
	/* 13088 */ DATA_4( 0xaeea3ecf, 0x735ce15c, 0xfae2ab33, 0x00010b9c ),
	/* 13104 */ DATA_4( 0x88832c1e, 0x9636f4bb, 0x8beb8fcb, 0x001d735e ),
	/* 13120 */ DATA_4( 0x486b02c0, 0xdb3bd553, 0x035eac17, 0x021cd5f4 ),
	/* 13136 */ DATA_4( 0x60cf9b52, 0xafaf47a3, 0x04788487, 0x16853b2d ),
	/* 13152 */ DATA_4( 0x2f5bef0a, 0x5882f8b4, 0x5c6d2a7c, 0x71b10572 ),
	/* 13168 */ DATA_4( 0x74496282, 0xdefc08eb, 0x1bebd601, 0xab3269be ),
	/* 13184 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 13192 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 13208 */ DATA_4( 0x95cb28ad, 0x0f3c2d06, 0x00000000, 0x00000000 ),
	/* 13224 */ DATA_4( 0x4fdf969d, 0x4d19c84c, 0x0000000b, 0x00000000 ),
	/* 13240 */ DATA_4( 0x963d3e58, 0x0e8aa079, 0x00000706, 0x00000000 ),
	/* 13256 */ DATA_4( 0x49ed0281, 0x64de4bb8, 0x0003ae38, 0x00000000 ),
	/* 13272 */ DATA_4( 0x1cff7c3d, 0xf8f55017, 0x01999b3c, 0x00000000 ),
	/* 13288 */ DATA_4( 0x40ac4399, 0x84e9012c, 0x90d081de, 0x00000000 ),
	/* 13304 */ DATA_4( 0xd70c61d7, 0x4c8f0c30, 0xa1702cb8, 0x00000028 ),
	/* 13320 */ DATA_4( 0xff79c3a4, 0x7db76d74, 0xab3a44a5, 0x000008c5 ),
	/* 13336 */ DATA_4( 0xe0781238, 0xab4a0de9, 0x87e67279, 0x00016680 ),
	/* 13352 */ DATA_4( 0x3a1dd70a, 0x36168518, 0xf95f812b, 0x00281cd4 ),
	/* 13368 */ DATA_4( 0x8f29bb10, 0x6abd5ae6, 0xf59beb15, 0x02ea8248 ),
	/* 13384 */ DATA_4( 0xcdff9869, 0xc56e7a98, 0x96fd4d9c, 0x1f632a93 ),
	/* 13400 */ DATA_4( 0x11e4bbbb, 0xbf948cfc, 0xa0faa841, 0x9f624e5c ),
	/* 13416 */ DATA_4( 0xcb36dbb5, 0x0882e860, 0x232cccbe, 0xf0774764 ),
	/* 13432 */ DATA_1x2( 0x000000-6, 0x00000000 ),

	/* Interval polynomial coefficients for y1 */

	/* Data for interval 0 : [ 0.0, 1.80747 ) - zero = 0.0 */
	/* 13440 */ DATA_1x2( 0x9186a95a, 0x0e75b0f5 ),
	/* 13448 */ DATA_1x2( 0x0023800e, 0xfc000128 ),
	/* 13456 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 13472 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* degree = 14 - unpacked coefficients */
	/* 13488 */ DATA_4( 0x1173ce5f, 0x002cb65c, 0x00000000, 0x00000000 ),
	/* 13504 */ DATA_4( 0x1fe9c971, 0x24e3af15, 0x00000000, 0x00000000 ),
	/* 13520 */ DATA_4( 0x40c39341, 0xa6bb75f8, 0x00000019, 0x00000000 ),
	/* 13536 */ DATA_4( 0xf6cf0412, 0x2fe18dd8, 0x00000f3f, 0x00000000 ),
	/* 13552 */ DATA_4( 0xc25a1029, 0x3000a345, 0x0007a566, 0x00000000 ),
	/* 13568 */ DATA_4( 0x386d7d03, 0x9e405c5a, 0x032f1750, 0x00000000 ),
	/* 13584 */ DATA_4( 0xbdcada96, 0x1549a815, 0x1474ade9, 0x00000001 ),
	/* 13600 */ DATA_4( 0xb25307e3, 0x705ee34f, 0x9386ba91, 0x0000004a ),
	/* 13616 */ DATA_4( 0xbede2ece, 0x52e515fd, 0x71a69033, 0x00000f86 ),
	/* 13632 */ DATA_4( 0x92a6a282, 0x08adf1db, 0x49bbdd46, 0x000265cb ),
	/* 13648 */ DATA_4( 0x94fa2347, 0x35143c0c, 0xb1ddbaaf, 0x00429e02 ),
	/* 13664 */ DATA_4( 0xf10cfc5e, 0xd0cafc35, 0xf37a5f38, 0x04b1f6ff ),
	/* 13680 */ DATA_4( 0x6e9dd15e, 0x69b3b02e, 0x297cb5a2, 0x306b72f1 ),
	/* 13696 */ DATA_4( 0x51b9cada, 0xfbd0672a, 0xada538fc, 0xde9cbae3 ),
	/* 13712 */ DATA_4( 0xb42ec6cd, 0xfd65ca99, 0xe5e4523a, 0xc8c330a1 ),
	/* 13728 */ DATA_1x2( 0x000000-1, 0x00000000 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 1 : [ 1.80747, 2.39169 ) - zero = 2.19714 */
	/* 13736 */ DATA_1x2( 0xc240b737, 0x13222cfa ),
	/* 13744 */ DATA_1x2( 0x01c74183, 0x00000210 ),
	/* 13752 */ DATA_2x2( 0xff921721, 0x8c9df6a6, 0x2017e155, 0x70d796f3 ),
	/* 13768 */ DATA_2x2( 0x9c331bc4, 0x4316cc40, 0xb248281a, 0x80b36143 ),
	/* degree = 29 - packed coefficients */
	/* 13784 */ DATA_4( 0x25257a39, 0x917e01d9, 0xcdeedeef, 0xa05ce020 ),
	/* 13800 */ DATA_4( 0x761f87a3, 0xb70644de, 0x23c952a0, 0xedd11cb2 ),
	/* 13816 */ DATA_4( 0x1dfcdd67, 0x8efc82ef, 0xde4d51d5, 0x98a428e7 ),
	/* 13832 */ DATA_4( 0xfe2f7224, 0x6ced97dc, 0x56a3fbef, 0xaa3ba2b3 ),
	/* 13848 */ DATA_4( 0xd26ca555, 0xad79090b, 0xe454b1e1, 0xca5edc98 ),
	/* 13864 */ DATA_4( 0x22aee504, 0x0a2f24f4, 0xe187b6e8, 0xe299a5e4 ),
	/* 13880 */ DATA_4( 0xe6eda913, 0xe11ed646, 0xeaefae98, 0xf7752b49 ),
	/* 13896 */ DATA_4( 0x2810a224, 0x6fd3de3e, 0x89198f46, 0x87e89bd5 ),
	/* 13912 */ DATA_4( 0xaeb0c6b5, 0x127fc5f6, 0x8b55141e, 0x95405869 ),
	/* 13928 */ DATA_4( 0x28821d74, 0x6f3b1ed3, 0x37246d63, 0xa3e071fc ),
	/* 13944 */ DATA_4( 0xf8392865, 0x64d5905e, 0xd0dee7e6, 0xb3ec51ed ),
	/* 13960 */ DATA_4( 0xf3e32514, 0xadaedeae, 0x047f20fa, 0xc5858486 ),
	/* 13976 */ DATA_4( 0x86c20bf5, 0x6a4f0d80, 0xcf5d2b7a, 0xd8d0b41b ),
	/* 13992 */ DATA_4( 0x17051c72, 0x09e10ca2, 0xacc4606e, 0xedf54232 ),
	/* 14008 */ DATA_4( 0x083e4cc5, 0x937f7d94, 0x56197415, 0x828e89a6 ),
	/* 14024 */ DATA_4( 0xdd804cf4, 0x0c9b29e6, 0x7bbda784, 0x8f3a160e ),
	/* 14040 */ DATA_4( 0x34b12cf5, 0xc31cee81, 0xa563fb48, 0x9d13f8fe ),
	/* 14056 */ DATA_4( 0x336a4134, 0xce57eb99, 0x5d89e98b, 0xac32e88f ),
	/* 14072 */ DATA_4( 0x8dd11465, 0xef4376a4, 0xf4bc15f2, 0xbcab569f ),
	/* 14088 */ DATA_4( 0xff1bb4a4, 0xda177711, 0x6766c6e0, 0xce8ba64e ),
	/* 14104 */ DATA_4( 0x4413e7a5, 0x7ee4e433, 0x56b83388, 0xe1fd71d8 ),
	/* 14120 */ DATA_4( 0x5dbf6832, 0xf463987d, 0x83b22c17, 0xf753dddc ),
	/* 14136 */ DATA_4( 0x4d9b77f5, 0x8583fde7, 0xad14dc82, 0x8596c3be ),
	/* 14152 */ DATA_4( 0x57a8de04, 0xad720f3b, 0x6039aa56, 0x8bd5a57d ),
	/* 14168 */ DATA_4( 0xda635265, 0x08f942a6, 0x22b08f90, 0xaa14ee2d ),
	/* 14184 */ DATA_4( 0xa9f63726, 0x3f4e8b6a, 0x8cb7e868, 0xf338e3e8 ),
	/* 14200 */ DATA_4( 0xb5077be1, 0xeb034423, 0x9485535d, 0x9d36f61b ),
	/* 14216 */ DATA_4( 0xdacb3195, 0x46183fb9, 0x991c2d4a, 0x86957a74 ),
	/* 14232 */ DATA_4( 0xfc584d81, 0xa51177eb, 0xbdc78b1c, 0xf2b7c110 ),
	/* 14248 */ DATA_4( 0x55611bb6, 0xc983b3fa, 0x780a56b6, 0x85524221 ),

	/* Signs don't alternate */

	/* Data for interval 2 : [ 2.39169, 3.68302 ) - zero = 3.03736 */
	/* 14264 */ DATA_1x2( 0xfba17502, 0x1d76d4af ),
	/* 14272 */ DATA_1x2( 0x01a5c208, 0x000001b0 ),
	/* 14280 */ DATA_2x2( 0xf788b0e9, 0xc26406aa, 0x622fdd56, 0x90555d9f ),
	/* 14296 */ DATA_2x2( 0x00000000, 0x82134d40, 0x00000002, 0x00000000 ),
	/* degree = 23 - packed coefficients */
	/* 14312 */ DATA_4( 0x917a3d2c, 0x9dd5a8d5, 0x72761e5a, 0xf0676a4d ),
	/* 14328 */ DATA_4( 0x0d9e34e3, 0x38b79c46, 0x5ea03b93, 0xb14b2b13 ),
	/* 14344 */ DATA_4( 0x9ac9f0ed, 0x394c2a6d, 0x8b817683, 0xf296d89e ),
	/* 14360 */ DATA_4( 0xe28b3ba2, 0x9130cb78, 0x66c00cf1, 0xa3ed55ea ),
	/* 14376 */ DATA_4( 0x76387d4e, 0x1a1e92df, 0x4d66015c, 0xca0ab522 ),
	/* 14392 */ DATA_4( 0x92783b01, 0xa8ed9805, 0xc1ccf159, 0xf816d132 ),
	/* 14408 */ DATA_4( 0x9c6c54cf, 0x8304dcdb, 0x66b5fb54, 0x89122edf ),
	/* 14424 */ DATA_4( 0xe2ffe202, 0x6c980fcb, 0xca10bc56, 0x96e6b4ba ),
	/* 14440 */ DATA_4( 0x6e565a4e, 0xa1079959, 0x66c51190, 0x93f47a93 ),
	/* 14456 */ DATA_4( 0x26ad0125, 0x33972be1, 0x9891895d, 0x8f69126c ),
	/* 14472 */ DATA_4( 0x364b788f, 0x7fd3bc43, 0x61ed1c7a, 0xf698da9a ),
	/* 14488 */ DATA_4( 0x8b3d2f02, 0x0e45f3c0, 0xe667c9ad, 0xcd01535c ),
	/* 14504 */ DATA_4( 0x9064f030, 0xd4c1d2fd, 0xb187e0db, 0x98950f4c ),
	/* 14520 */ DATA_4( 0xab6176c3, 0xf12b79f1, 0xeb624394, 0xd0d43fac ),
	/* 14536 */ DATA_4( 0x7ee4db51, 0x4911bc9a, 0x7ffdbd63, 0x84f48aaa ),
	/* 14552 */ DATA_4( 0x8819c164, 0x4f7f7186, 0x5755aa54, 0x8b3e7f8f ),
	/* 14568 */ DATA_4( 0xa41b4872, 0xb0d7e95d, 0xae2c4a81, 0x97311ee6 ),
	/* 14584 */ DATA_4( 0x9ee9a705, 0xc9cf689b, 0x252ffa1a, 0xce5bf11a ),
	/* 14600 */ DATA_4( 0x27d73035, 0xdc98e9d3, 0xba55acb6, 0xc76260d5 ),
	/* 14616 */ DATA_4( 0x155d5fc4, 0xdd983f3c, 0xeb4fe34a, 0xc27d7987 ),
	/* 14632 */ DATA_4( 0x9b9396f2, 0xb83293a8, 0x1ab3e966, 0xf891bbdf ),
	/* 14648 */ DATA_4( 0x17abe4a8, 0xaf610f60, 0xe3f08d28, 0x9d6fc9aa ),
	/* 14664 */ DATA_4( 0x9e7cdad1, 0xfc531427, 0x967daa50, 0xc5783842 ),
	/* 14680 */ DATA_4( 0x0da4a26f, 0x95ea1b52, 0xcf3aeb29, 0xa0db7f5c ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 3 : [ 3.68302, 6.9415 ) - zero = 5.42968 */
	/* 14696 */ DATA_1x2( 0xb10aa65e, 0x37883120 ),
	/* 14704 */ DATA_1x2( 0x01ca4207, 0x000002d0 ),
	/* 14712 */ DATA_2x2( 0x3d8173bf, 0xadbff274, 0xd17ddc11, 0xcf758451 ),
	/* 14728 */ DATA_2x2( 0x0aee5e6f, 0x9c67ee1a, 0x01b393eb, 0x645de766 ),
	/* degree = 41 - packed coefficients */
	/* 14744 */ DATA_4( 0x05840af3, 0x1c0a5ac2, 0xb90b9736, 0x97858a94 ),
	/* 14760 */ DATA_4( 0x906d4f62, 0xfbba7d45, 0x701a7a1e, 0xbd1bab74 ),
	/* 14776 */ DATA_4( 0xa2eab84c, 0xf01f5403, 0xbac5bf90, 0x8081acfa ),
	/* 14792 */ DATA_4( 0x5c1ebea8, 0x8cad4de3, 0x5a4cb958, 0xc8603ec7 ),
	/* 14808 */ DATA_4( 0x69d9016f, 0x4b95a429, 0x117a91b2, 0xae37c2ca ),
	/* 14824 */ DATA_4( 0xfdf318e8, 0x7f007b96, 0x04aceef6, 0xe32e232e ),
	/* 14840 */ DATA_4( 0xbdd8fd29, 0x5b147c84, 0x578f6c8b, 0xb3642eb2 ),
	/* 14856 */ DATA_4( 0x30bbe76a, 0x2040811a, 0xcc64389d, 0xc19074ea ),
	/* 14872 */ DATA_4( 0x52a443c9, 0x9fffe2c7, 0x10f03b1c, 0xf96bdec1 ),
	/* 14888 */ DATA_4( 0xd8e3270a, 0x161d5601, 0x9b5eceab, 0x9f4caefb ),
	/* 14904 */ DATA_4( 0x44c01c49, 0x28a1690c, 0x9a492614, 0xda95cb50 ),
	/* 14920 */ DATA_4( 0x8a762c6a, 0x2f7ad4c9, 0xf896665a, 0x95317241 ),
	/* 14936 */ DATA_4( 0xbacf94e9, 0xdc8daf02, 0xbad9dafd, 0xc9ff3364 ),
	/* 14952 */ DATA_4( 0x29f106ea, 0x572f60c5, 0x4ff4ed66, 0x88dda633 ),
	/* 14968 */ DATA_4( 0x1a761fab, 0x6d951352, 0x6d103d3b, 0xb992adc3 ),
	/* 14984 */ DATA_4( 0xcc0f58a8, 0xdb350052, 0xb21f38cd, 0xfb8cd77e ),
	/* 15000 */ DATA_4( 0x8cf3b86b, 0x167b220e, 0x3af19cb0, 0xaa74f983 ),
	/* 15016 */ DATA_4( 0x8772d428, 0x908c4f7d, 0xca4ee84f, 0xe6f86075 ),
	/* 15032 */ DATA_4( 0x9bdae3ab, 0x43babb18, 0xbfe7475c, 0x9c72f26f ),
	/* 15048 */ DATA_4( 0x7db59748, 0x932eae21, 0x75c3427d, 0xd3e3966d ),
	/* 15064 */ DATA_4( 0x4d33352b, 0x174fcd65, 0x5caec385, 0x8f71082b ),
	/* 15080 */ DATA_4( 0x225b15a8, 0x5bfc0aec, 0x70335919, 0xc221f89f ),
	/* 15096 */ DATA_4( 0x3c9f036b, 0x75d8c2be, 0x7d03397d, 0x8359c763 ),
	/* 15112 */ DATA_4( 0x71bf5b2a, 0x040d0989, 0x263b160f, 0xb1c06b5d ),
	/* 15128 */ DATA_4( 0xdf4a6c29, 0x3c94ec82, 0x7bd71fca, 0xef6c15bb ),
	/* 15144 */ DATA_4( 0x7b581d8a, 0xc386a620, 0x7e7d24a8, 0xa017eac7 ),
	/* 15160 */ DATA_4( 0x70403409, 0xc29bad57, 0xf44e401f, 0xe007beb5 ),
	/* 15176 */ DATA_4( 0xd0fc888a, 0x6d73d2b9, 0xa83492e5, 0xa4c044ad ),
	/* 15192 */ DATA_4( 0x77f8f3d1, 0x6d7d4fd8, 0x3ed49a08, 0x9c23b426 ),
	/* 15208 */ DATA_4( 0x3eed1480, 0x82c940c2, 0x91dd87cf, 0xa032e52f ),
	/* 15224 */ DATA_4( 0x4f1ef067, 0x62a8057c, 0xb47f2fb7, 0xd3f702d2 ),
	/* 15240 */ DATA_4( 0xae7cf38a, 0x0dae3364, 0x03e8e52b, 0xc058d560 ),
	/* 15256 */ DATA_4( 0x64b49084, 0xfd3278d3, 0x0a4c4473, 0xdb166810 ),
	/* 15272 */ DATA_4( 0x27352bcb, 0x112c41a9, 0x86799a8d, 0x92af367b ),
	/* 15288 */ DATA_4( 0x8def8047, 0xc7d750e1, 0xdbc79020, 0xc030c8a3 ),
	/* 15304 */ DATA_4( 0x281cccaa, 0x33210983, 0xb03fcae5, 0xc2dca075 ),
	/* 15320 */ DATA_4( 0x8aa61026, 0xeb3a9433, 0xc7a42370, 0x99be3f09 ),
	/* 15336 */ DATA_4( 0xc54fab4d, 0x31079c76, 0x91d67aa2, 0x8df36dcc ),
	/* 15352 */ DATA_4( 0xff8bb289, 0x1ac8e5b1, 0x611fd0ad, 0x885194f1 ),
	/* 15368 */ DATA_4( 0xbc2a270e, 0xaec78a68, 0xf1f13437, 0xd0aec96f ),
	/* 15384 */ DATA_4( 0x9e28dec8, 0x3e700049, 0x8e50f68f, 0x805cfc2b ),
	/* 15400 */ DATA_4( 0xff0af28d, 0x5abc76d2, 0x860ccc8e, 0xae3e2ab7 ),

	/* Signs don't alternate */

	/* Signs don't alternate */

	/* Data for interval 4 : [ 6.9415, 10.1234 ) - zero = 8.59601 */
	/* 15416 */ DATA_1x2( 0x7a31f98f, 0x50fcbb94 ),
	/* 15424 */ DATA_1x2( 0x01c80186, 0x00000240 ),
	/* 15432 */ DATA_2x2( 0x0b4da147, 0x89893d73, 0x0466df5b, 0x9cc068d9 ),
	/* 15448 */ DATA_2x2( 0xe77c24f7, 0x24d9f9eb, 0xe6f89e3c, 0xe987795e ),
	/* degree = 32 - packed coefficients */
	/* 15464 */ DATA_4( 0x566a4f86, 0x9494a0b9, 0x2e8eceee, 0xbe2a2da6 ),
	/* 15480 */ DATA_4( 0x58646c99, 0xdf521773, 0x2821af5c, 0x97952bb0 ),
	/* 15496 */ DATA_4( 0x416313a4, 0xa2ca4b52, 0xa072307f, 0xd60b9e07 ),
	/* 15512 */ DATA_4( 0xf4e2c977, 0x7b89e53d, 0xeaa41b19, 0x82498643 ),
	/* 15528 */ DATA_4( 0x72a92f16, 0xd951e797, 0xfb523860, 0x92fb187e ),
	/* 15544 */ DATA_4( 0x19b79177, 0x23948df0, 0x805568fb, 0x9b3c19de ),
	/* 15560 */ DATA_4( 0x87f03b76, 0xbad28004, 0x9a51850c, 0xa55052a7 ),
	/* 15576 */ DATA_4( 0xa7531e87, 0xa7e9dcb6, 0xa5548218, 0xb2a3fdc7 ),
	/* 15592 */ DATA_4( 0x674c1956, 0x30ccecf5, 0x95cd8f4e, 0xc320bb8e ),
	/* 15608 */ DATA_4( 0xdb34ad17, 0x1332708d, 0x6f350a6b, 0xc0bb8d97 ),
	/* 15624 */ DATA_4( 0xadc7d8d4, 0x37e26710, 0x2755f650, 0xa81eb4a7 ),
	/* 15640 */ DATA_4( 0x7f25edf5, 0xa06e1ea2, 0xfa1b3353, 0xa294c80c ),
	/* 15656 */ DATA_4( 0x35737778, 0x697ea148, 0xb4eba5ba, 0xa3ecdc6c ),
	/* 15672 */ DATA_4( 0x5df98230, 0x5821f945, 0x49d52bd1, 0xd1101481 ),
	/* 15688 */ DATA_4( 0x07872875, 0xd20d67db, 0x9fd1e1a1, 0x9e5ca022 ),
	/* 15704 */ DATA_4( 0x880780e5, 0x7e8e3cfe, 0x97436ab8, 0x89e60fb4 ),
	/* 15720 */ DATA_4( 0x854f6794, 0xb3b2471a, 0x5f550620, 0xfd655edd ),
	/* 15736 */ DATA_4( 0x510bcfc2, 0x9152f8aa, 0x5cde0dce, 0x98c32c76 ),
	/* 15752 */ DATA_4( 0xb436a857, 0x56548266, 0x656bca0c, 0x8b7bd740 ),
	/* 15768 */ DATA_4( 0x59c45dc5, 0x2e7ae5a1, 0xfc6be43b, 0x934345c1 ),
	/* 15784 */ DATA_4( 0xe2992636, 0xdf82c445, 0xf51a7cc0, 0xf6205b11 ),
	/* 15800 */ DATA_4( 0xb8037822, 0xd41d4e92, 0xee880b7c, 0xcf19427a ),
	/* 15816 */ DATA_4( 0x1e55e269, 0xb044dd42, 0xe1d4824f, 0xa0f3d491 ),
	/* 15832 */ DATA_4( 0x65324e43, 0xf144b965, 0xf09b365c, 0xd1c2775f ),
	/* 15848 */ DATA_4( 0xfcc12668, 0x57f98a2b, 0x5de36915, 0x95f6595b ),
	/* 15864 */ DATA_4( 0x63bea0e4, 0x8db1ad18, 0xca5c75ea, 0x8bb7395f ),
	/* 15880 */ DATA_4( 0x3f7ea51b, 0x4e87d9ed, 0x279aa6e0, 0xb7bdd588 ),
	/* 15896 */ DATA_4( 0x5aaec573, 0x02fd9a59, 0x9900fe07, 0xda86bf0e ),
	/* 15912 */ DATA_4( 0xe7c6cedc, 0x195afc1d, 0x0005dbe6, 0x83d33c6b ),
	/* 15928 */ DATA_4( 0xbe2ad214, 0x5695b8dc, 0x348c0088, 0x9e769517 ),
	/* 15944 */ DATA_4( 0xa50a67df, 0x2433690f, 0x4fe69d78, 0xb1caeff2 ),
	/* 15960 */ DATA_4( 0x79c1ccb5, 0xad53ed8a, 0x790d88a2, 0x8159c99e ),
	/* 15976 */ DATA_4( 0x58fde29a, 0xc672a53c, 0x755ae11d, 0x8afcc9fe ),

	/* Data for interval 5 : [ 10.1234, 13.28576 ) - zero = 11.74915 */
	/* 15992 */ DATA_1x2( 0x8f94af82, 0x6a493b92 ),
	/* 16000 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 16008 */ DATA_2x2( 0xa1903021, 0xbbfc89c6, 0xc1004d6a, 0xf8f0d9c0 ),
	/* 16024 */ DATA_2x2( 0x5b4665a6, 0xefebb2fc, 0x942a2274, 0x26c5b173 ),
	/* degree = 28 - unpacked coefficients */
	/* 16040 */ DATA_4( 0x8a58f565, 0x00098a14, 0x00000000, 0x00000000 ),
	/* 16056 */ DATA_4( 0x3fbbf1ad, 0x0eff7c8b, 0x00000000, 0x00000000 ),
	/* 16072 */ DATA_4( 0xfa2a46b6, 0x05757b01, 0x0000000a, 0x00000000 ),
	/* 16088 */ DATA_4( 0x7f4b89c1, 0x0fefd911, 0x00000634, 0x00000000 ),
	/* 16104 */ DATA_4( 0xcadfac8c, 0x39a9a31c, 0x00033240, 0x00000000 ),
	/* 16120 */ DATA_4( 0x1b9dad8e, 0x76d4d8f2, 0x0160519c, 0x00000000 ),
	/* 16136 */ DATA_4( 0x731774c8, 0x7a651cdf, 0x7bcfcabf, 0x00000000 ),
	/* 16152 */ DATA_4( 0x272b6d70, 0x93a81eda, 0xbcb815ee, 0x00000022 ),
	/* 16168 */ DATA_4( 0x5b54aa4a, 0xe8afeafd, 0xb3ddecd1, 0x0000078c ),
	/* 16184 */ DATA_4( 0xc476b6f2, 0xbbf9a0dc, 0x60a1bb74, 0x00013906 ),
	/* 16200 */ DATA_4( 0x4afbc8d2, 0x81b4888a, 0x4610c64f, 0x0023d0c8 ),
	/* 16216 */ DATA_4( 0x5260c3df, 0x21fa1315, 0x43546024, 0x02ae3029 ),
	/* 16232 */ DATA_4( 0x834d12f8, 0x5e242443, 0xb3db8602, 0x1dc4f991 ),
	/* 16248 */ DATA_4( 0xf3aa514f, 0x351eb626, 0x4725d3e3, 0x9b3ebeb0 ),
	/* 16264 */ DATA_4( 0x96f23cff, 0xeb38843e, 0x744fc6b2, 0xee0a750a ),
	/* 16280 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 16288 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 16304 */ DATA_4( 0x9a58f254, 0x063cbe14, 0x00000000, 0x00000000 ),
	/* 16320 */ DATA_4( 0xe78d276c, 0xa492857f, 0x00000003, 0x00000000 ),
	/* 16336 */ DATA_4( 0xbdfef632, 0xf67fac89, 0x00000272, 0x00000000 ),
	/* 16352 */ DATA_4( 0x66d14160, 0x66276166, 0x00015120, 0x00000000 ),
	/* 16368 */ DATA_4( 0x9419a313, 0xf3c15537, 0x00992418, 0x00000000 ),
	/* 16384 */ DATA_4( 0x10675c9b, 0xa0c8e4fc, 0x38c1da68, 0x00000000 ),
	/* 16400 */ DATA_4( 0xc0e8a6ee, 0x49181ad5, 0xd67f939f, 0x00000010 ),
	/* 16416 */ DATA_4( 0xc3ca4717, 0x3f5f07ea, 0xeb1aab47, 0x000003df ),
	/* 16432 */ DATA_4( 0x4c33dba2, 0x9cb2ecd8, 0x459f6897, 0x0000aa4f ),
	/* 16448 */ DATA_4( 0x3296502d, 0x7c6787f3, 0x2d41f690, 0x0014a7b8 ),
	/* 16464 */ DATA_4( 0x54f8d11c, 0x4350a3e3, 0xa42f226f, 0x01a2977f ),
	/* 16480 */ DATA_4( 0xbf00c583, 0x11ee4109, 0xd6e6bc7c, 0x1315ec04 ),
	/* 16496 */ DATA_4( 0x653d9d13, 0xb6bddef3, 0x1278d54e, 0x675bacaf ),
	/* 16512 */ DATA_4( 0xe9338813, 0x17a09cfb, 0xdafdea68, 0xa214ff7a ),
	/* 16528 */ DATA_1x2( 0x000000-4, 0x00000000 ),

	/* Data for interval 6 : [ 13.28576, 16.44006 ) - zero = 14.89744 */
	/* 16536 */ DATA_1x2( 0xed573107, 0x83853d21 ),
	/* 16544 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 16552 */ DATA_2x2( 0xf4245543, 0xee5bec46, 0x3f61c302, 0xedcb5e0e ),
	/* 16568 */ DATA_2x2( 0x3420c4fd, 0x91e6af09, 0x6ec372d4, 0xf81d7f5e ),
	/* degree = 28 - unpacked coefficients */
	/* 16584 */ DATA_4( 0x5fb8e9a7, 0x0011534b, 0x00000000, 0x00000000 ),
	/* 16600 */ DATA_4( 0x97ef219e, 0x0e414b8d, 0x00000000, 0x00000000 ),
	/* 16616 */ DATA_4( 0x1b1a2310, 0x24f732f2, 0x0000000a, 0x00000000 ),
	/* 16632 */ DATA_4( 0x9136f9cd, 0xc804f71f, 0x0000062e, 0x00000000 ),
	/* 16648 */ DATA_4( 0x14f1ca30, 0x2fa91613, 0x00032f43, 0x00000000 ),
	/* 16664 */ DATA_4( 0x0189ae5f, 0x29a89c5e, 0x015d4a3a, 0x00000000 ),
	/* 16680 */ DATA_4( 0xf639e132, 0x284e444f, 0x7a1c0973, 0x00000000 ),
	/* 16696 */ DATA_4( 0x9e62bc79, 0xe4459edf, 0x03863c3b, 0x00000022 ),
	/* 16712 */ DATA_4( 0x3dd8412e, 0xaef09a20, 0x2a878058, 0x00000753 ),
	/* 16728 */ DATA_4( 0x35bd0891, 0x4b9c08ff, 0x8c8f963a, 0x00012c1a ),
	/* 16744 */ DATA_4( 0x7202800d, 0x0d3e9908, 0x25b7a709, 0x0021d36c ),
	/* 16760 */ DATA_4( 0xf2522bc7, 0x541738ec, 0x788e5d44, 0x027c7319 ),
	/* 16776 */ DATA_4( 0x1a1c825a, 0x23af7c36, 0x40abf4a1, 0x1b176028 ),
	/* 16792 */ DATA_4( 0x240693de, 0xf1e6ce26, 0x855313a1, 0x8b18c8e1 ),
	/* 16808 */ DATA_4( 0x91ee01d3, 0xa12cd0fc, 0x426cc97b, 0xd38115f0 ),
	/* 16824 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 16832 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 16848 */ DATA_4( 0xe0b46919, 0x092d322b, 0x00000000, 0x00000000 ),
	/* 16864 */ DATA_4( 0x26823f67, 0xf022e50d, 0x00000006, 0x00000000 ),
	/* 16880 */ DATA_4( 0x9a4c1d2d, 0x3eb6f561, 0x00000468, 0x00000000 ),
	/* 16896 */ DATA_4( 0x83aedc6d, 0x1f343393, 0x00025e44, 0x00000000 ),
	/* 16912 */ DATA_4( 0x7ebe3d6a, 0xd489ae5b, 0x010f3be0, 0x00000000 ),
	/* 16928 */ DATA_4( 0x77feb3a1, 0x71c2f575, 0x63180884, 0x00000000 ),
	/* 16944 */ DATA_4( 0xe223c06f, 0x55edc72a, 0xdc25a81e, 0x0000001c ),
	/* 16960 */ DATA_4( 0xc96de80c, 0xec58108b, 0x7684cb94, 0x0000067f ),
	/* 16976 */ DATA_4( 0x661a0673, 0x2ffea6a0, 0x6aa9fde6, 0x0001161b ),
	/* 16992 */ DATA_4( 0x4f219573, 0xaa172a07, 0x79b2c655, 0x0020ad75 ),
	/* 17008 */ DATA_4( 0x3844c26b, 0x92d7030f, 0x3fe371c8, 0x027e6bb6 ),
	/* 17024 */ DATA_4( 0xc95084b6, 0x52b66aa2, 0x3c842a33, 0x1c0a9cee ),
	/* 17040 */ DATA_4( 0xe2a79643, 0xef92a063, 0x3eee5039, 0x93582294 ),
	/* 17056 */ DATA_4( 0x716fa749, 0x68ab38a2, 0x1884d2e6, 0xe3285b5c ),
	/* 17072 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 7 : [ 16.44006, 19.59024 ) - zero = 18.0434 */
	/* 17080 */ DATA_1x2( 0x8b9ad571, 0x9cb8d0ab ),
	/* 17088 */ DATA_1x2( 0x00c3b1ec, 0xfc000220 ),
	/* 17096 */ DATA_2x2( 0xf8f1d4bc, 0x9058e34a, 0x2443a2d1, 0x236756f0 ),
	/* 17112 */ DATA_2x2( 0x8f3ad612, 0x32dd6e92, 0xf4c0281d, 0x3b922267 ),
	/* degree = 28 - unpacked coefficients */
	/* 17128 */ DATA_4( 0x74a10d5b, 0x00113dae, 0x00000000, 0x00000000 ),
	/* 17144 */ DATA_4( 0xdaa5fe82, 0x0e3946cd, 0x00000000, 0x00000000 ),
	/* 17160 */ DATA_4( 0x75642af2, 0x18a4dbde, 0x0000000a, 0x00000000 ),
	/* 17176 */ DATA_4( 0xa7d90496, 0x605a2fdd, 0x00000622, 0x00000000 ),
	/* 17192 */ DATA_4( 0xdff9269b, 0xb4e93432, 0x000325bd, 0x00000000 ),
	/* 17208 */ DATA_4( 0x826267bc, 0x6a5ce3d0, 0x01579284, 0x00000000 ),
	/* 17224 */ DATA_4( 0x215223c7, 0x67b66af5, 0x77690479, 0x00000000 ),
	/* 17240 */ DATA_4( 0x276c13e3, 0x68c23c9a, 0x067d43f0, 0x00000021 ),
	/* 17256 */ DATA_4( 0x7da85935, 0x9f7c8601, 0x0e7cfeb1, 0x0000070d ),
	/* 17272 */ DATA_4( 0x710cbfea, 0x384a3383, 0x5332ab3e, 0x00011df6 ),
	/* 17288 */ DATA_4( 0x9db2109a, 0x3ffdebd0, 0x174f902a, 0x001fdd03 ),
	/* 17304 */ DATA_4( 0xd52846f1, 0x0ed8a9d8, 0x4e9871c0, 0x02505a4d ),
	/* 17320 */ DATA_4( 0x653b5652, 0x662c5a22, 0x94379c2c, 0x18efee40 ),
	/* 17336 */ DATA_4( 0x2edc41a7, 0x20cd4ea0, 0x0211fc99, 0x7ef9b7e1 ),
	/* 17352 */ DATA_4( 0x075f9077, 0x6d18ace5, 0x21173a7b, 0xc03c0e19 ),
	/* 17368 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 17376 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 17392 */ DATA_4( 0x1635a9f8, 0x0869363d, 0x00000000, 0x00000000 ),
	/* 17408 */ DATA_4( 0xc5a4a0e3, 0x4f1cd796, 0x00000006, 0x00000000 ),
	/* 17424 */ DATA_4( 0xe32960fd, 0xde053f56, 0x000003f8, 0x00000000 ),
	/* 17440 */ DATA_4( 0x3af4ef08, 0xc1d8a1fd, 0x00021cc4, 0x00000000 ),
	/* 17456 */ DATA_4( 0x48d0c108, 0x55f94f37, 0x00ef0e15, 0x00000000 ),
	/* 17472 */ DATA_4( 0xf788c940, 0x6c15801c, 0x56225997, 0x00000000 ),
	/* 17488 */ DATA_4( 0xf9f9c698, 0xc9e39245, 0xafb70fb3, 0x00000018 ),
	/* 17504 */ DATA_4( 0x86de2262, 0x7697aa0a, 0xe2b942bf, 0x00000574 ),
	/* 17520 */ DATA_4( 0xa5e84c82, 0x19ecedb1, 0x4e79b0d2, 0x0000e4b7 ),
	/* 17536 */ DATA_4( 0x51927135, 0x1f87a72b, 0x907fee59, 0x001a44a7 ),
	/* 17552 */ DATA_4( 0x945068b7, 0xce7c3038, 0xd9ad9589, 0x01f56c29 ),
	/* 17568 */ DATA_4( 0xd0ff9034, 0xec61e5a7, 0xf0e4ddfe, 0x159145b4 ),
	/* 17584 */ DATA_4( 0x47075ee6, 0xc4ab3a13, 0x49db8352, 0x6f8c6358 ),
	/* 17600 */ DATA_4( 0xe7d6a172, 0xf8df2055, 0xd004bc80, 0xaa76d34b ),
	/* 17616 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* Data for interval 8 : [ 19.59024, 22.73803 ) - zero = 21.18807 */
	/* 17624 */ DATA_1x2( 0xf43d16ea, 0xb5e77ebe ),
	/* 17632 */ DATA_1x2( 0x00c391ec, 0xfc000220 ),
	/* 17640 */ DATA_2x2( 0x0c466a72, 0xa9812a49, 0x51d726a5, 0x3628820a ),
	/* 17656 */ DATA_2x2( 0x221b8d37, 0xe0d692cf, 0x88cc8f1d, 0x34350638 ),
	/* degree = 28 - unpacked coefficients */
	/* 17672 */ DATA_4( 0x63f39a93, 0x00111af3, 0x00000000, 0x00000000 ),
	/* 17688 */ DATA_4( 0xbb3429f8, 0x0e1ea801, 0x00000000, 0x00000000 ),
	/* 17704 */ DATA_4( 0x04b3ab86, 0xfe8b98b5, 0x00000009, 0x00000000 ),
	/* 17720 */ DATA_4( 0x26ec0e41, 0x3bca31bc, 0x0000060d, 0x00000000 ),
	/* 17736 */ DATA_4( 0x7711ccec, 0xa77f978a, 0x000317b1, 0x00000000 ),
	/* 17752 */ DATA_4( 0x30af3a3a, 0x078a3dfe, 0x014ffb4f, 0x00000000 ),
	/* 17768 */ DATA_4( 0x1cd4f666, 0x64f250e7, 0x741fdb06, 0x00000000 ),
	/* 17784 */ DATA_4( 0x66836bcb, 0xb44052ef, 0xe92f0882, 0x0000001f ),
	/* 17800 */ DATA_4( 0x331db883, 0x78a48da1, 0x804748fd, 0x000006c3 ),
	/* 17816 */ DATA_4( 0x80d43831, 0xf78eea69, 0xcdd9b5f7, 0x00011021 ),
	/* 17832 */ DATA_4( 0x292e8de9, 0xcb2c5499, 0x5853a9fa, 0x001e1272 ),
	/* 17848 */ DATA_4( 0xfd023919, 0x749d983d, 0xb31a5dfa, 0x022a9da8 ),
	/* 17864 */ DATA_4( 0xd11889b5, 0x8d9db45e, 0xe248f873, 0x17307b03 ),
	/* 17880 */ DATA_4( 0x6f8ba0cf, 0x13075a06, 0xa9841d70, 0x757e15e8 ),
	/* 17896 */ DATA_4( 0x3088907c, 0x1fdf4186, 0xf42cdc5a, 0xb16ca6cb ),
	/* 17912 */ DATA_1x2( 0x000000-1, 0x00000000 ),
	/* 17920 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 17936 */ DATA_4( 0x6f09ee22, 0x07adc6d5, 0x00000000, 0x00000000 ),
	/* 17952 */ DATA_4( 0x84bc777c, 0xb7c3c359, 0x00000005, 0x00000000 ),
	/* 17968 */ DATA_4( 0xe1e6e14c, 0xcf0774ab, 0x00000391, 0x00000000 ),
	/* 17984 */ DATA_4( 0x71fcfcb2, 0xfac7b2c5, 0x0001e157, 0x00000000 ),
	/* 18000 */ DATA_4( 0xa7fa6ab4, 0x2093da0d, 0x00d2826b, 0x00000000 ),
	/* 18016 */ DATA_4( 0x373202a7, 0x1bcf2d57, 0x4af0926a, 0x00000000 ),
	/* 18032 */ DATA_4( 0xcd46b49b, 0xf482518d, 0x3126d86b, 0x00000015 ),
	/* 18048 */ DATA_4( 0x41504b73, 0x9a64ea0f, 0xb303e996, 0x0000049d ),
	/* 18064 */ DATA_4( 0xdcef836f, 0x9b6ffd49, 0x3d36135a, 0x0000be7d ),
	/* 18080 */ DATA_4( 0x978cffcc, 0x8fa786ea, 0x58dfc8aa, 0x001588c7 ),
	/* 18096 */ DATA_4( 0x63d8973a, 0xd9a07cab, 0x476e6154, 0x0194f64f ),
	/* 18112 */ DATA_4( 0x3232f779, 0x17ee4ae5, 0x83d0dc6f, 0x1132c0aa ),
	/* 18128 */ DATA_4( 0x73d9a13f, 0x380eb03f, 0xff95c949, 0x58206c2d ),
	/* 18144 */ DATA_4( 0x9ef315d0, 0xe26323ac, 0x3819dfdd, 0x85fb0a40 ),
	/* 18160 */ DATA_1x2( 0x000000-5, 0x00000000 ),

	/* P0 and Q0 rational coefficients */
	/* 18168 */ DATA_4( 0xd5fd0189, 0x24845e60, 0x2ab90762, 0x00000002 ),
	/* 18184 */ DATA_4( 0x6cf82ed5, 0x69da7dd4, 0x3367a857, 0x00000688 ),
	/* 18200 */ DATA_4( 0x1a1aaa30, 0x285efa6c, 0xdb68bd04, 0x0002d575 ),
	/* 18216 */ DATA_4( 0xabe9673c, 0x7c9ca6f2, 0xedf333e1, 0x0062161f ),
	/* 18232 */ DATA_4( 0xc004ab36, 0x8d607c41, 0xfc8cbbc6, 0x0578b4b3 ),
	/* 18248 */ DATA_4( 0xdd1349de, 0x766d2353, 0x881e720e, 0x24df4917 ),
	/* 18264 */ DATA_4( 0x4ed6cbe9, 0x1ce890ed, 0xf89ac066, 0x7cb293a8 ),
	/* 18280 */ DATA_4( 0x7496cdda, 0x429bf941, 0x395fb81f, 0xd4e5cf04 ),
	/* 18296 */ DATA_4( 0xc527822c, 0xef16949d, 0x69c06dd6, 0xabbdcea7 ),
	/* 18312 */ DATA_4( 0x17571c5d, 0x1f9678a0, 0xa86ca11a, 0x33108a67 ),
	/* 18328 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 18336 */ DATA_4( 0xc4998953, 0x94b85dca, 0x89543fd6, 0x00000001 ),
	/* 18352 */ DATA_4( 0x97892927, 0xd836fbf1, 0xc02f874a, 0x00000432 ),
	/* 18368 */ DATA_4( 0x39af3398, 0x53d82026, 0xf3a7a84d, 0x0001ca9c ),
	/* 18384 */ DATA_4( 0xf8fe517c, 0xb924915d, 0x0f9238b5, 0x003db2d6 ),
	/* 18400 */ DATA_4( 0x0c128142, 0xc45ec76e, 0x94ca2a96, 0x036f5af2 ),
	/* 18416 */ DATA_4( 0x2af3365e, 0x6c2a54cc, 0xb842a8d3, 0x1720a269 ),
	/* 18432 */ DATA_4( 0x08bbd0f2, 0xfe96e22a, 0x8b5fbb96, 0x4e2dd821 ),
	/* 18448 */ DATA_4( 0x7b6bb724, 0x728f632a, 0x869a3921, 0x85717f5b ),
	/* 18464 */ DATA_4( 0x0e712805, 0xc1e992e2, 0x0c610cc4, 0x6ba1bbe0 ),
	/* 18480 */ DATA_4( 0x00000000, 0x00000000, 0x00000000, 0x20000000 ),
	/* 18496 */ DATA_1x2( 0x00000003, 0x00000000 ),
	/* 18504 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 18520 */ DATA_4( 0xc2b76c55, 0x8fdf18f1, 0xc6851ffc, 0x00000062 ),
	/* 18536 */ DATA_4( 0x479b4a3b, 0xa1d1a956, 0xbf3c1364, 0x00004ef2 ),
	/* 18552 */ DATA_4( 0x7499d50a, 0xfbb958d7, 0xa5f6e977, 0x000fb12d ),
	/* 18568 */ DATA_4( 0xcd023186, 0x8fb2ae1d, 0xc43f1d30, 0x01350b07 ),
	/* 18584 */ DATA_4( 0x64846350, 0x2351a752, 0x39ca1fbb, 0x0b12326a ),
	/* 18600 */ DATA_4( 0xcebe63fd, 0x4a8c8e8b, 0x7e30a12e, 0x33ccddea ),
	/* 18616 */ DATA_4( 0xe90024f6, 0x6dddc8fc, 0xe6bdf4f6, 0x8074493a ),
	/* 18632 */ DATA_4( 0xf73f71f0, 0x92eb946b, 0x4d81038a, 0xa76ffb4a ),
	/* 18648 */ DATA_4( 0xef49a9ac, 0x1484cde3, 0xa6a973b2, 0x6a6052e8 ),
	/* 18664 */ DATA_4( 0x0bab8e2a, 0x0fcb3c50, 0xd436508d, 0x19884533 ),
	/* 18680 */ DATA_1x2( 0x000000-6, 0x00000000 ),
	/* 18688 */ DATA_4( 0x0f6fb339, 0x5386e849, 0x18b8b5cc, 0x00000000 ),
	/* 18704 */ DATA_4( 0xe5fd01c0, 0x295398b6, 0x376e7db5, 0x000000a4 ),
	/* 18720 */ DATA_4( 0xcb6191b4, 0x7761ff1d, 0x714e4fb1, 0x00006cbe ),
	/* 18736 */ DATA_4( 0x0bff9714, 0x9e2d903f, 0x31d5e1c9, 0x00147beb ),
	/* 18752 */ DATA_4( 0x06b612be, 0x017b16a9, 0xa54948fa, 0x018b1c98 ),
	/* 18768 */ DATA_4( 0x320ac1c3, 0x8f1db213, 0x6f081600, 0x0e054a12 ),
	/* 18784 */ DATA_4( 0x0e6b1d57, 0x7dd612d7, 0x21556d40, 0x41492e14 ),
	/* 18800 */ DATA_4( 0x641871c4, 0x0a2cedc2, 0xe524c6f1, 0xa17889fa ),
	/* 18816 */ DATA_4( 0xac26cd45, 0x05792c53, 0x940f42d3, 0xd227f803 ),
	/* 18832 */ DATA_4( 0xb593b781, 0x1bbcf56e, 0xa641c2ed, 0x8565680f ),
	/* 18848 */ DATA_4( 0x00000000, 0x00000000, 0x00000000, 0x20000000 ),
	/* 18864 */ DATA_1x2( 0x00000003, 0x00000000 ),

	/* P1 and Q1 rational coefficients */
	/* 18872 */ DATA_4( 0x6124c934, 0x0c94df75, 0x0477b8ad, 0x00000000 ),
	/* 18888 */ DATA_4( 0x5c1c7cfb, 0x6f221634, 0xfeeb8768, 0x00000063 ),
	/* 18904 */ DATA_4( 0x1fea3a86, 0x1afdad55, 0x146182f9, 0x00006333 ),
	/* 18920 */ DATA_4( 0x3b503423, 0xd6dba2c1, 0x12aa6ddb, 0x0016a254 ),
	/* 18936 */ DATA_4( 0x1bddef36, 0x3741691d, 0xd875832e, 0x01d8f4eb ),
	/* 18952 */ DATA_4( 0x980123ef, 0xb309a497, 0x5928cf64, 0x10c65b91 ),
	/* 18968 */ DATA_4( 0x41458f9d, 0xac680308, 0x846b22df, 0x48711db7 ),
	/* 18984 */ DATA_4( 0x4709730f, 0x6364d37c, 0x90bef869, 0x98181913 ),
	/* 19000 */ DATA_4( 0x479ce7cb, 0x6fb5fb92, 0x227c1490, 0x92ba42aa ),
	/* 19016 */ DATA_4( 0x17571c9b, 0x1f9678a0, 0xa86ca11a, 0x33108a67 ),
	/* 19032 */ DATA_1x2( 0x00000000, 0x00000000 ),
	/* 19040 */ DATA_2x2( 0x00000000, 0x00000000, 0x00000000, 0x00000000 ),
	/* 19056 */ DATA_4( 0x28606473, 0x06bde9f3, 0x07ba49f8, 0x00000072 ),
	/* 19072 */ DATA_4( 0xe4036818, 0xdc0c1f71, 0xcfab7a09, 0x00007951 ),
	/* 19088 */ DATA_4( 0xa6519781, 0x599f2140, 0x7edc3c15, 0x001c1bbc ),
	/* 19104 */ DATA_4( 0x6c308b42, 0xe655b7fb, 0x5aa15ffb, 0x024e5a85 ),
	/* 19120 */ DATA_4( 0x8c3187f6, 0xc94623d6, 0xee413de0, 0x14fba7b3 ),
	/* 19136 */ DATA_4( 0x4769ddb6, 0x7a3bf938, 0xeca39099, 0x5ab4a163 ),
	/* 19152 */ DATA_4( 0xc8802ba2, 0x439560c3, 0x31a601c9, 0xbe89a6b6 ),
	/* 19168 */ DATA_4( 0xe3ced76f, 0x4b56a004, 0x3408ff33, 0xb7ddcfdf ),
	/* 19184 */ DATA_4( 0x00000000, 0x00000000, 0x00000000, 0x40000000 ),
	/* 19200 */ DATA_1x2( 0x00000002, 0x00000000 ),
	/* 19208 */ DATA_4( 0x9e07f7c4, 0xc9d844e9, 0xa8bf68a1, 0x00000005 ),
	/* 19224 */ DATA_4( 0xffb1ebab, 0x8d2e9611, 0xb412fd22, 0x00000cd4 ),
	/* 19240 */ DATA_4( 0x6f3ecf01, 0x09261f4a, 0x78504c8d, 0x0004819e ),
	/* 19256 */ DATA_4( 0x2a7e31b4, 0x25788094, 0xe758dcd2, 0x00844665 ),
	/* 19272 */ DATA_4( 0x95778fe2, 0x0e42a847, 0x98fce419, 0x0672b65f ),
	/* 19288 */ DATA_4( 0xa4666c4f, 0x21d8d00b, 0x7f3ae939, 0x26c42828 ),
	/* 19304 */ DATA_4( 0xd9018b78, 0xa725c0f7, 0x267f06a9, 0x76ba6969 ),
	/* 19320 */ DATA_4( 0x2ff2631e, 0x87ef31d6, 0xe951f86c, 0xb9aa55fa ),
	/* 19336 */ DATA_4( 0x7382463f, 0x864712a3, 0x73aa8c90, 0x8a671207 ),
	/* 19352 */ DATA_4( 0x1181550a, 0x97b0da78, 0xbe5178d3, 0x264c67cd ),
	/* 19368 */ DATA_1x2( 0x000000-5, 0x00000000 ),
	/* 19376 */ DATA_4( 0x1b02459f, 0x344b9dad, 0x5ce17513, 0x00000006 ),
	/* 19392 */ DATA_4( 0x97dddcb5, 0xc8485968, 0x463b61e2, 0x00000b8a ),
	/* 19408 */ DATA_4( 0x689e7493, 0x7adacd18, 0xd285c8d0, 0x0003df10 ),
	/* 19424 */ DATA_4( 0x20653b56, 0x07aa7912, 0x257f8f8f, 0x006fead2 ),
	/* 19440 */ DATA_4( 0x0602aa96, 0xb42f04d8, 0x89041926, 0x056bd9db ),
	/* 19456 */ DATA_4( 0xb3b1aee3, 0x05c1147b, 0xd5ffdd63, 0x207ec9d4 ),
	/* 19472 */ DATA_4( 0xb0b73dc2, 0xa14075df, 0xb39b2ec1, 0x635df380 ),
	/* 19488 */ DATA_4( 0xcb21491e, 0x7ff55140, 0x838b8500, 0x9b412a58 ),
	/* 19504 */ DATA_4( 0x729028b9, 0xbcaa651d, 0x98d33570, 0x73acec9f ),
	/* 19520 */ DATA_4( 0x00000000, 0x00000000, 0x00000000, 0x20000000 ),
	/* 19536 */ DATA_1x2( 0x00000003, 0x00000000 ),
	/* 19544 */ DATA_1x2( 0xa6c55ee4, 0xb614a71e ),
	/* 19552 */ DATA_1x2( 0x00000078, 0x00000000 ),
	/* 19560 */ DATA_1x2( 0x000046f8, 0x00000000 ),
	/* 19568 */ DATA_1x2( 0x70b1a769, 0xc27d98ef ),
	/* 19576 */ DATA_1x2( 0x00000f78, 0x00000000 ),
	/* 19584 */ DATA_1x2( 0x000049b8, 0x00000000 ),
	/* 19592 */ DATA_1x2( 0xc10650a9, 0xc2a7d181 ),
	/* 19600 */ DATA_1x2( 0x00001f80, 0x00000000 ),
	/* 19608 */ DATA_1x2( 0x000046f8, 0x00000000 ),
	/* 19616 */ DATA_1x2( 0xf43d16ea, 0xb5e77ebe ),
	/* 19624 */ DATA_1x2( 0x00003480, 0x00000000 ),
	/* 19632 */ DATA_1x2( 0x000049b8, 0x00000000 ),

	/* 1/pi, 2/pi, 2*ln2/pi */
	/* 19640 */ POS, 0000, DATA_2x2( 0x4e441529, 0xa2f9836e, 0xf534ddc0, 0xfc2757d1 ),
	/* 19664 */ POS, 00-1, DATA_2x2( 0xf4b4ddd9, 0xe1ee4c7b, 0xabfde7bb, 0x6c10b05c ),
	};

#define	J0_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 0))
#define	J1_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 8))
#define	JN_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 16))
#define	Y0_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 40))
#define	Y1_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 48))
#define	YN_CLASS_TO_ACTION_MAP	((U_WORD const *) ((char *) TABLE_NAME + 56))
#define	P0_COEFFICIENTS		((FIXED_128 *) ((char *) TABLE_NAME + 18168))
#define	P0_DEGREE		9
#define	Q0_COEFFICIENTS		((FIXED_128 *) ((char *) TABLE_NAME + 18504))
#define	Q0_DEGREE		10
#define	P1_COEFFICIENTS		((FIXED_128 *) ((char *) TABLE_NAME + 18872))
#define	P1_DEGREE		9
#define	Q1_COEFFICIENTS		((FIXED_128 *) ((char *) TABLE_NAME + 19208))
#define	Q1_DEGREE		9
#define BESSEL_TABLE_DATA_MAP	(TABLE_DATA_MAP *)((char *) TABLE_NAME + 19544)
#define	UX_TWO_OVER_PI	((UX_FLOAT *) ((char *) TABLE_NAME + 19640))
#define	UX_TWO_LN2_OVER_PI	((UX_FLOAT *) ((char *) TABLE_NAME + 19664))
