; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X86 --check-prefix=X86-AVX
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=X86 --check-prefix=X86-AVX512VL
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X86 --check-prefix=X86-AVX512VLDQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512dq,+avx512vl | FileCheck %s --check-prefix=X64 --check-prefix=X64-AVX512VLDQ

define <2 x double> @fabs_v2f64(<2 x double> %p) {
; X86-AVX-LABEL: fabs_v2f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v2f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v2f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to2}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v2f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v2f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v2f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <2 x double> @llvm.fabs.v2f64(<2 x double> %p)
  ret <2 x double> %t
}
declare <2 x double> @llvm.fabs.v2f64(<2 x double> %p)

define <4 x float> @fabs_v4f32(<4 x float> %p) {
; X86-AVX-LABEL: fabs_v4f32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v4f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v4f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %xmm0, %xmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v4f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v4f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v4f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <4 x float> @llvm.fabs.v4f32(<4 x float> %p)
  ret <4 x float> %t
}
declare <4 x float> @llvm.fabs.v4f32(<4 x float> %p)

define <4 x double> @fabs_v4f64(<4 x double> %p) {
; X86-AVX-LABEL: fabs_v4f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v4f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v4f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to4}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v4f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v4f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v4f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <4 x double> @llvm.fabs.v4f64(<4 x double> %p)
  ret <4 x double> %t
}
declare <4 x double> @llvm.fabs.v4f64(<4 x double> %p)

define <8 x float> @fabs_v8f32(<8 x float> %p) {
; X86-AVX-LABEL: fabs_v8f32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}, %ymm0, %ymm0
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v8f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v8f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %ymm0, %ymm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v8f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v8f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v8f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm0, %ymm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <8 x float> @llvm.fabs.v8f32(<8 x float> %p)
  ret <8 x float> %t
}
declare <8 x float> @llvm.fabs.v8f32(<8 x float> %p)

define <8 x double> @fabs_v8f64(<8 x double> %p) {
; X86-AVX-LABEL: fabs_v8f64:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN]
; X86-AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X86-AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v8f64:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v8f64:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}{1to8}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v8f64:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN]
; X64-AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X64-AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v8f64:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v8f64:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <8 x double> @llvm.fabs.v8f64(<8 x double> %p)
  ret <8 x double> %t
}
declare <8 x double> @llvm.fabs.v8f64(<8 x double> %p)

define <16 x float> @fabs_v16f32(<16 x float> %p) {
; X86-AVX-LABEL: fabs_v16f32:
; X86-AVX:       # %bb.0:
; X86-AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X86-AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X86-AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X86-AVX-NEXT:    retl
;
; X86-AVX512VL-LABEL: fabs_v16f32:
; X86-AVX512VL:       # %bb.0:
; X86-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VL-NEXT:    retl
;
; X86-AVX512VLDQ-LABEL: fabs_v16f32:
; X86-AVX512VLDQ:       # %bb.0:
; X86-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}{1to16}, %zmm0, %zmm0
; X86-AVX512VLDQ-NEXT:    retl
;
; X64-AVX-LABEL: fabs_v16f32:
; X64-AVX:       # %bb.0:
; X64-AVX-NEXT:    vmovaps {{.*#+}} ymm2 = [NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN]
; X64-AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; X64-AVX-NEXT:    vandps %ymm2, %ymm1, %ymm1
; X64-AVX-NEXT:    retq
;
; X64-AVX512VL-LABEL: fabs_v16f32:
; X64-AVX512VL:       # %bb.0:
; X64-AVX512VL-NEXT:    vpandd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VL-NEXT:    retq
;
; X64-AVX512VLDQ-LABEL: fabs_v16f32:
; X64-AVX512VLDQ:       # %bb.0:
; X64-AVX512VLDQ-NEXT:    vandps {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %zmm0
; X64-AVX512VLDQ-NEXT:    retq
  %t = call <16 x float> @llvm.fabs.v16f32(<16 x float> %p)
  ret <16 x float> %t
}
declare <16 x float> @llvm.fabs.v16f32(<16 x float> %p)

; PR20354: when generating code for a vector fabs op,
; make sure that we're only turning off the sign bit of each float value.
; No constant pool loads or vector ops are needed for the fabs of a
; bitcasted integer constant; we should just return an integer constant
; that has the sign bits turned off.
;
; So instead of something like this:
;    movabsq (constant pool load of mask for sign bits)
;    vmovq   (move from integer register to vector/fp register)
;    vandps  (mask off sign bits)
;    vmovq   (move vector/fp register back to integer return register)
;
; We should generate:
;    mov     (put constant value in return register)

define i64 @fabs_v2f32_1() {
; X86-LABEL: fabs_v2f32_1:
; X86:       # %bb.0:
; X86-NEXT:    xorl %eax, %eax
; X86-NEXT:    movl $2147483647, %edx # imm = 0x7FFFFFFF
; X86-NEXT:    retl
;
; X64-LABEL: fabs_v2f32_1:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $9223372032559808512, %rax # imm = 0x7FFFFFFF00000000
; X64-NEXT:    retq
 %bitcast = bitcast i64 18446744069414584320 to <2 x float> ; 0xFFFF_FFFF_0000_0000
 %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %bitcast)
 %ret = bitcast <2 x float> %fabs to i64
 ret i64 %ret
}

define i64 @fabs_v2f32_2() {
; X86-LABEL: fabs_v2f32_2:
; X86:       # %bb.0:
; X86-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X86-NEXT:    xorl %edx, %edx
; X86-NEXT:    retl
;
; X64-LABEL: fabs_v2f32_2:
; X64:       # %bb.0:
; X64-NEXT:    movl $2147483647, %eax # imm = 0x7FFFFFFF
; X64-NEXT:    retq
 %bitcast = bitcast i64 4294967295 to <2 x float> ; 0x0000_0000_FFFF_FFFF
 %fabs = call <2 x float> @llvm.fabs.v2f32(<2 x float> %bitcast)
 %ret = bitcast <2 x float> %fabs to i64
 ret i64 %ret
}

declare <2 x float> @llvm.fabs.v2f32(<2 x float> %p)
