; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,FALLBACK0
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1,AVX1-ONLY,FALLBACK1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-SLOW,FALLBACK2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST,FALLBACK3
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX1,AVX2,AVX2-ONLY,AVX2-FAST-PERLANE,FALLBACK4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512F-ONLY-SLOW,FALLBACK5
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512F-ONLY-FAST,FALLBACK6
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-SLOW,AVX512DQ-SLOW,FALLBACK7
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512F,AVX512F-FAST,AVX512DQ-FAST,FALLBACK8
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512BW-ONLY-SLOW,FALLBACK9
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512BW-ONLY-FAST,FALLBACK10
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-SLOW,AVX512DQBW-SLOW,FALLBACK11
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2,AVX512,AVX512BW,AVX512BW-FAST,AVX512DQBW-FAST,FALLBACK12

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i32_stride3_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,1,1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm2[1,0]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[3,3,3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm0[0,2]
; SSE-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    movq %xmm3, 16(%rcx)
; SSE-NEXT:    movaps %xmm2, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf2:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm0 = ymm0[3,1,0,3,7,5,4,7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = ymm2[0,2,u,1,u,5,u,u]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3],ymm0[4],ymm1[5,6,7]
; AVX1-ONLY-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-ONLY-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %xmm0, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-LABEL: store_i32_stride3_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX2-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vmovaps {{.*#+}} ymm1 = <0,2,4,1,3,5,u,u>
; AVX2-NEXT:    vpermps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovlps %xmm1, 16(%rcx)
; AVX2-NEXT:    vmovaps %xmm0, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
  %in.vec0 = load <2 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <2 x i32> %in.vec0, <2 x i32> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i32> %in.vec2, <2 x i32> poison, <4 x i32> <i32 0, i32 1, i32 undef, i32 undef>
  %3 = shufflevector <4 x i32> %1, <4 x i32> %2, <6 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5>
  %interleaved.vec = shufflevector <6 x i32> %3, <6 x i32> poison, <6 x i32> <i32 0, i32 2, i32 4, i32 1, i32 3, i32 5>
  store <6 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm2[0,3]
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm3[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps %xmm4, (%rcx)
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf4:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm3
; AVX1-ONLY-NEXT:    vmovsldup {{.*#+}} ymm3 = ymm3[0,0,2,2,4,4,6,6]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,u,u,1,5,u,u,6]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3,4,5],ymm3[6],ymm2[7]
; AVX1-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX1-ONLY-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX1-ONLY-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride3_vf4:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-SLOW-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-SLOW-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX2-SLOW-NEXT:    vmovaps {{.*#+}} ymm3 = <0,4,u,1,5,u,2,6>
; AVX2-SLOW-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-SLOW-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX2-SLOW-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX2-SLOW-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride3_vf4:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FAST-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm1 = <u,3,7,u,u,u,u,u>
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm1, %ymm1
; AVX2-FAST-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} xmm1 = xmm2[0],xmm1[1,2],xmm2[3]
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm2 = <0,4,u,1,5,u,2,6>
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm2, %ymm0
; AVX2-FAST-NEXT:    vbroadcastsd (%rdx), %ymm2
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-NEXT:    vmovaps %xmm1, 32(%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride3_vf4:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rsi), %xmm1
; AVX2-FAST-PERLANE-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovaps {{.*#+}} ymm3 = <0,4,u,1,5,u,2,6>
; AVX2-FAST-PERLANE-NEXT:    vpermps %ymm2, %ymm3, %ymm2
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; AVX2-FAST-PERLANE-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2],xmm1[3]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %xmm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovaps (%rdi), %xmm0
; AVX512-NEXT:    vmovaps (%rdx), %xmm1
; AVX512-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vmovaps {{.*#+}} zmm1 = <0,4,8,1,5,9,2,6,10,3,7,11,u,u,u,u>
; AVX512-NEXT:    vpermps %zmm0, %zmm1, %zmm0
; AVX512-NEXT:    vextractf32x4 $2, %zmm0, 32(%rcx)
; AVX512-NEXT:    vmovaps %ymm0, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <4 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <4 x i32> %in.vec0, <4 x i32> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i32> %in.vec2, <4 x i32> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <8 x i32> %1, <8 x i32> %2, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i32> %3, <12 x i32> poison, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  store <12 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm5
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps 16(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm1, %xmm6
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; SSE-NEXT:    movaps %xmm1, %xmm7
; SSE-NEXT:    movaps %xmm1, %xmm8
; SSE-NEXT:    unpcklps {{.*#+}} xmm8 = xmm8[0],xmm5[0],xmm8[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm6[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm4[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,1],xmm7[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm3[1]
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    movaps %xmm0, %xmm9
; SSE-NEXT:    unpcklps {{.*#+}} xmm9 = xmm9[0],xmm3[0],xmm9[1],xmm3[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm3[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,2],xmm6[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm2[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,1],xmm7[2,0]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,2],xmm4[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0,1,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm2[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm9, (%rcx)
; SSE-NEXT:    movaps %xmm3, 16(%rcx)
; SSE-NEXT:    movaps %xmm8, 48(%rcx)
; SSE-NEXT:    movaps %xmm5, 64(%rcx)
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    movaps %xmm1, 80(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf8:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm4
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm3[1],xmm1[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm1[1,1],xmm5[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm3[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2],ymm1[3,4],ymm3[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm4[3,3],xmm2[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm2[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[1,1],xmm4[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3],ymm3[4],ymm2[5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm3 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm4 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1],ymm3[2],ymm4[3,4],ymm3[5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm3[1,2],ymm0[3],ymm3[4,5],ymm0[6],ymm3[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride3_vf8:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-SLOW-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm3 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-SLOW-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm5 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm4, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride3_vf8:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FAST-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FAST-NEXT:    vbroadcastf128 {{.*#+}} ymm3 = [1,0,2,2,1,0,2,2]
; AVX2-FAST-NEXT:    # ymm3 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermps %ymm1, %ymm3, %ymm3
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-FAST-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm4 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm2[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1,2],ymm4[3],ymm0[4,5],ymm4[6],ymm0[7]
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm4 = <5,u,u,6,u,u,7,u>
; AVX2-FAST-NEXT:    vpermps %ymm1, %ymm4, %ymm1
; AVX2-FAST-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4],ymm4[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride3_vf8:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm3 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0],ymm3[1],ymm4[2,3],ymm3[4],ymm4[5,6],ymm3[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm5 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm4, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm2 = [13,21,6,14,22,7,15,23]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = [0,8,16,1,9,17,2,10,18,3,11,19,4,12,20,5]
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rcx)
; AVX512-NEXT:    vmovdqa %ymm2, 64(%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <8 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <8 x i32> %in.vec0, <8 x i32> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i32> %in.vec2, <8 x i32> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <16 x i32> %1, <16 x i32> %2, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i32> %3, <24 x i32> poison, <24 x i32> <i32 0, i32 8, i32 16, i32 1, i32 9, i32 17, i32 2, i32 10, i32 18, i32 3, i32 11, i32 19, i32 4, i32 12, i32 20, i32 5, i32 13, i32 21, i32 6, i32 14, i32 22, i32 7, i32 15, i32 23>
  store <24 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps (%rdi), %xmm4
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm1
; SSE-NEXT:    movaps 48(%rdi), %xmm8
; SSE-NEXT:    movaps (%rsi), %xmm5
; SSE-NEXT:    movaps 16(%rsi), %xmm9
; SSE-NEXT:    movaps 32(%rsi), %xmm10
; SSE-NEXT:    movaps 48(%rsi), %xmm11
; SSE-NEXT:    movaps 16(%rdx), %xmm0
; SSE-NEXT:    movaps 32(%rdx), %xmm3
; SSE-NEXT:    movaps 48(%rdx), %xmm7
; SSE-NEXT:    movaps %xmm8, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; SSE-NEXT:    movaps %xmm8, %xmm13
; SSE-NEXT:    movaps %xmm8, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm11[0],xmm6[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[3,3],xmm11[3,3]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm7[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm13[2,0]
; SSE-NEXT:    movaps %xmm1, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm10[1]
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    unpcklps {{.*#+}} xmm14 = xmm14[0],xmm10[0],xmm14[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm10[3,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm3[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,1],xmm13[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm9[1]
; SSE-NEXT:    movaps %xmm2, %xmm13
; SSE-NEXT:    movaps %xmm2, %xmm15
; SSE-NEXT:    unpcklps {{.*#+}} xmm15 = xmm15[0],xmm9[0],xmm15[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm9[3,3]
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[1,1],xmm0[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,1],xmm13[2,0]
; SSE-NEXT:    movaps %xmm4, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm5[0],xmm13[1],xmm5[1]
; SSE-NEXT:    movaps %xmm4, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm5[3,3]
; SSE-NEXT:    movaps (%rdx), %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm0[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm12[0,2]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[0,3]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm3[2,0]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Folded Reload
; SSE-NEXT:    # xmm1 = xmm1[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,2],xmm7[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,2],xmm0[2,3]
; SSE-NEXT:    movaps %xmm13, (%rcx)
; SSE-NEXT:    movaps %xmm5, 16(%rcx)
; SSE-NEXT:    movaps %xmm15, 48(%rcx)
; SSE-NEXT:    movaps %xmm9, 64(%rcx)
; SSE-NEXT:    movaps %xmm14, 96(%rcx)
; SSE-NEXT:    movaps %xmm10, 112(%rcx)
; SSE-NEXT:    movaps %xmm6, 144(%rcx)
; SSE-NEXT:    movaps %xmm11, 160(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0,1,3]
; SSE-NEXT:    movaps %xmm4, 32(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0,1,3]
; SSE-NEXT:    movaps %xmm2, 80(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0,1,3]
; SSE-NEXT:    movaps %xmm1, 128(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0,1,3]
; SSE-NEXT:    movaps %xmm8, 176(%rcx)
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf16:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm1
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm6[1],xmm2[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm9 = xmm2[1,1],xmm9[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm2[2,0],xmm6[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm2, %ymm2
; AVX1-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm6[2],ymm2[3,4],ymm6[5],ymm2[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm9 = xmm6[3,3],xmm5[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[1,1],xmm6[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm9, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6],ymm6[7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm8[1],xmm4[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm6 = xmm4[1,1],xmm6[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm4[0],xmm8[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm4 = xmm4[2,0],xmm8[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm4, %ymm4
; AVX1-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm6[2],ymm4[3,4],ymm6[5],ymm4[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm6 = xmm7[3,3],xmm3[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm3[1,1],xmm7[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm3
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm1[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm6[1],ymm3[2,3],ymm6[4],ymm3[5,6],ymm6[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm6 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm7 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm6[1,2],ymm1[3],ymm6[4,5],ymm1[6],ymm6[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm6 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm7 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2],ymm7[3,4],ymm6[5],ymm7[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm6[1,2],ymm0[3],ymm6[4,5],ymm0[6],ymm6[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride3_vf16:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-SLOW-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-SLOW-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-SLOW-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-SLOW-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm2 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1],ymm7[2,3],ymm2[4],ymm7[5,6],ymm2[7]
; AVX2-SLOW-NEXT:    vbroadcastsd (%rdx), %ymm7
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm7[2],ymm2[3,4],ymm7[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd 56(%rdi), %ymm7
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm8 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm8 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 32(%rdx), %ymm9
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vbroadcastsd 24(%rdi), %ymm9
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4],ymm9[5],ymm10[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm10 = ymm6[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3],ymm10[4],ymm9[5,6],ymm10[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm5 = ymm6[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1,2],ymm5[3],ymm4[4,5],ymm5[6],ymm4[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm9, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm8, 96(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm7, 160(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride3_vf16:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovaps (%rsi), %ymm3
; AVX2-FAST-NEXT:    vmovaps 32(%rsi), %ymm4
; AVX2-FAST-NEXT:    vmovaps (%rdx), %ymm5
; AVX2-FAST-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm0 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm7 = ymm1[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1],ymm0[2],ymm7[3,4],ymm0[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm7 = ymm5[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0],ymm0[1,2],ymm7[3],ymm0[4,5],ymm7[6],ymm0[7]
; AVX2-FAST-NEXT:    vbroadcastf128 {{.*#+}} ymm7 = [1,0,2,2,1,0,2,2]
; AVX2-FAST-NEXT:    # ymm7 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermps %ymm3, %ymm7, %ymm8
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm8[1],ymm1[2,3],ymm8[4],ymm1[5,6],ymm8[7]
; AVX2-FAST-NEXT:    vbroadcastsd (%rdx), %ymm8
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm8[2],ymm1[3,4],ymm8[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm8 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm9 = ymm2[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0,1],ymm8[2],ymm9[3,4],ymm8[5],ymm9[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm9 = ymm6[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1,2],ymm9[3],ymm8[4,5],ymm9[6],ymm8[7]
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm9 = [5,6,5,6,5,6,7,7]
; AVX2-FAST-NEXT:    vpermps %ymm4, %ymm9, %ymm10
; AVX2-FAST-NEXT:    vbroadcastsd 56(%rdi), %ymm11
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm6 = ymm10[0],ymm6[1],ymm10[2,3],ymm6[4],ymm10[5,6],ymm6[7]
; AVX2-FAST-NEXT:    vpermps %ymm4, %ymm7, %ymm4
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3],ymm4[4],ymm2[5,6],ymm4[7]
; AVX2-FAST-NEXT:    vbroadcastsd 32(%rdx), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermps %ymm3, %ymm9, %ymm3
; AVX2-FAST-NEXT:    vbroadcastsd 24(%rdi), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm4[2],ymm3[3,4],ymm4[5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm5[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1],ymm3[2,3],ymm4[4],ymm3[5,6],ymm4[7]
; AVX2-FAST-NEXT:    vmovaps %ymm3, 64(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm2, 96(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm6, 160(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm8, 128(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm1, (%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride3_vf16:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rsi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rsi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm2 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm7 = ymm4[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm7[0],ymm2[1],ymm7[2,3],ymm2[4],ymm7[5,6],ymm2[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rdx), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm7[2],ymm2[3,4],ymm7[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 56(%rdi), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm8 = ymm3[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm8 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm0[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm9[0],ymm8[1],ymm9[2,3],ymm8[4],ymm9[5,6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 32(%rdx), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm9[2],ymm8[3,4],ymm9[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 24(%rdi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm10[0,1],ymm9[2],ymm10[3,4],ymm9[5],ymm10[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm10 = ymm6[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1],ymm9[2,3],ymm10[4],ymm9[5,6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm5 = ymm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0],ymm4[1,2],ymm5[3],ymm4[4,5],ymm5[6],ymm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm3 = ymm3[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm9, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm8, 96(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm7, 160(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm2, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <0,16,u,1,17,u,2,18,u,3,19,u,4,20,u,5>
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm4 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <5,u,22,6,u,23,7,u,24,8,u,25,9,u,26,10>
; AVX512-NEXT:    vpermi2d %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm5 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm3 = <u,11,27,u,12,28,u,13,29,u,14,30,u,15,31,u>
; AVX512-NEXT:    vpermi2d %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm0 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermi2d %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <16 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <16 x i32> %in.vec0, <16 x i32> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i32> %in.vec2, <16 x i32> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <32 x i32> %1, <32 x i32> %2, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i32> %3, <48 x i32> poison, <48 x i32> <i32 0, i32 16, i32 32, i32 1, i32 17, i32 33, i32 2, i32 18, i32 34, i32 3, i32 19, i32 35, i32 4, i32 20, i32 36, i32 5, i32 21, i32 37, i32 6, i32 22, i32 38, i32 7, i32 23, i32 39, i32 8, i32 24, i32 40, i32 9, i32 25, i32 41, i32 10, i32 26, i32 42, i32 11, i32 27, i32 43, i32 12, i32 28, i32 44, i32 13, i32 29, i32 45, i32 14, i32 30, i32 46, i32 15, i32 31, i32 47>
  store <48 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $152, %rsp
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm3
; SSE-NEXT:    movaps 48(%rdi), %xmm4
; SSE-NEXT:    movaps (%rsi), %xmm12
; SSE-NEXT:    movaps 16(%rsi), %xmm11
; SSE-NEXT:    movaps 32(%rsi), %xmm10
; SSE-NEXT:    movaps 48(%rsi), %xmm9
; SSE-NEXT:    movaps (%rdx), %xmm5
; SSE-NEXT:    movaps 16(%rdx), %xmm6
; SSE-NEXT:    movaps 32(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rdx), %xmm8
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm5[0,3]
; SSE-NEXT:    movaps %xmm5, %xmm14
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm12[0],xmm5[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm12[3,3]
; SSE-NEXT:    movaps %xmm1, %xmm15
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm14[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm13[0,2]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm6[0,3]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm11[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm6[1,1]
; SSE-NEXT:    movaps %xmm6, %xmm14
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm7[0,3]
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm10[0],xmm2[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm10[3,3]
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm8[0,3]
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm9[3,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm9
; SSE-NEXT:    movaps 64(%rdx), %xmm1
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,3]
; SSE-NEXT:    movaps 64(%rsi), %xmm12
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    unpcklps {{.*#+}} xmm13 = xmm13[0],xmm12[0],xmm13[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm12[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm1[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[0,3]
; SSE-NEXT:    movaps 80(%rsi), %xmm8
; SSE-NEXT:    movaps %xmm2, %xmm11
; SSE-NEXT:    unpcklps {{.*#+}} xmm11 = xmm11[0],xmm8[0],xmm11[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm8[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,2],xmm1[0,2]
; SSE-NEXT:    movaps 96(%rdi), %xmm0
; SSE-NEXT:    movaps 96(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 96(%rsi), %xmm6
; SSE-NEXT:    movaps %xmm0, %xmm7
; SSE-NEXT:    unpcklps {{.*#+}} xmm7 = xmm7[0],xmm6[0],xmm7[1],xmm6[1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm6[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,2],xmm3[0,2]
; SSE-NEXT:    movaps 112(%rdi), %xmm3
; SSE-NEXT:    movaps 112(%rdx), %xmm10
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm10[0,3]
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,0]
; SSE-NEXT:    movaps %xmm3, %xmm5
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm10[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm5[0,2]
; SSE-NEXT:    movaps %xmm15, %xmm5
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm5 # 16-byte Folded Reload
; SSE-NEXT:    # xmm5 = xmm5[1,2],mem[2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[1,2],xmm14[2,3]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rsp), %xmm15 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[1,2],mem[2,3]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    # xmm14 = xmm14[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Folded Reload
; SSE-NEXT:    # xmm0 = xmm0[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,2],xmm10[2,3]
; SSE-NEXT:    movaps %xmm1, 352(%rcx)
; SSE-NEXT:    movaps %xmm4, 336(%rcx)
; SSE-NEXT:    movaps %xmm6, 304(%rcx)
; SSE-NEXT:    movaps %xmm7, 288(%rcx)
; SSE-NEXT:    movaps %xmm8, 256(%rcx)
; SSE-NEXT:    movaps %xmm11, 240(%rcx)
; SSE-NEXT:    movaps %xmm12, 208(%rcx)
; SSE-NEXT:    movaps %xmm13, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0,1,3]
; SSE-NEXT:    movaps %xmm3, 368(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0,1,3]
; SSE-NEXT:    movaps %xmm2, 272(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0,1,3]
; SSE-NEXT:    movaps %xmm9, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm15[1,3]
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps %xmm5, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm5[1,3]
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    addq $152, %rsp
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf32:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm4
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vmovapd 64(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vmovapd 96(%rdx), %ymm0
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm7
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm10
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm9
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm8
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm11
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm5[1],xmm1[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm6 = xmm1[1,1],xmm6[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm5[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm5
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX1-ONLY-NEXT:    vmovaps 80(%rsi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm12 = xmm6[3,3],xmm5[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm5[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm5[1,1],xmm6[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm5, %ymm5
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm3[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm6 = ymm6[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm6[1],ymm5[2,3],ymm6[4],ymm5[5,6],ymm6[7]
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm13 = xmm12[1],xmm6[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm6[1,1],xmm13[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm6[0],xmm12[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm6 = xmm6[2,0],xmm12[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX1-ONLY-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm12[2],ymm6[3,4],ymm12[5],ymm6[6,7]
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm12[3,3],xmm9[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm12[1],xmm9[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm9 = xmm9[1,1],xmm12[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm9, %ymm9
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm12 = ymm12[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm12[1],ymm9[2,3],ymm12[4],ymm9[5,6],ymm12[7]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm11[1],xmm10[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm12 = xmm10[1,1],xmm12[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm10 = xmm10[0],xmm11[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm10 = xmm10[2,0],xmm11[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm12, %ymm10, %ymm10
; AVX1-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm11
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX1-ONLY-NEXT:    vmovaps 112(%rsi), %xmm11
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm12
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm12[3,3],xmm11[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm12 = xmm12[1],xmm11[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm11 = xmm11[1,1],xmm12[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm11, %ymm11
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm12 = ymm12[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm12[1],ymm11[2,3],ymm12[4],ymm11[5,6],ymm12[7]
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm12
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm13
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm13[1],xmm12[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm14 = xmm12[1,1],xmm14[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm12 = xmm12[0],xmm13[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm12 = xmm12[2,0],xmm13[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm14, %ymm12, %ymm12
; AVX1-ONLY-NEXT:    vbroadcastsd 96(%rdx), %ymm13
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1],ymm13[2],ymm12[3,4],ymm13[5],ymm12[6,7]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm13 = xmm8[3,3],xmm7[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm8[1],xmm7[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm7[1,1],xmm8[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm13, %ymm7, %ymm7
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm8 = ymm8[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm8[1],ymm7[2,3],ymm8[4],ymm7[5,6],ymm8[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm8[1,2],ymm4[3],ymm8[4,5],ymm4[6],ymm8[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm8[1,2],ymm3[3],ymm8[4,5],ymm3[6],ymm8[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm8[1,2],ymm2[3],ymm8[4,5],ymm2[6],ymm8[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm8 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm13[0,1],ymm8[2],ymm13[3,4],ymm8[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm8[1,2],ymm0[3],ymm8[4,5],ymm0[6],ymm8[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm12, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, (%rcx)
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride3_vf32:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $40, %rsp
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-SLOW-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-SLOW-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-SLOW-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-SLOW-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-SLOW-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-SLOW-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-SLOW-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm4 = ymm8[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2,3],ymm0[4],ymm4[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 88(%rdi), %ymm4
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm11 = ymm9[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2],ymm11[3,4],ymm4[5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm11[1],ymm4[2,3],ymm11[4],ymm4[5,6],ymm11[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm11 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm12 = ymm6[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2,3],ymm11[4],ymm12[5,6],ymm11[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 56(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm13 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm13 = ymm7[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm13[1],ymm12[2,3],ymm13[4],ymm12[5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm13 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm14 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3],ymm13[4],ymm14[5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 32(%rdx), %ymm14
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm14[2],ymm13[3,4],ymm14[5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 120(%rdi), %ymm14
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm15 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm3[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3],ymm15[4],ymm14[5,6],ymm15[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm15 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm15[1],ymm4[2,3],ymm15[4],ymm4[5,6],ymm15[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 96(%rdx), %ymm15
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm15[2],ymm4[3,4],ymm15[5],ymm4[6,7]
; AVX2-SLOW-NEXT:    vmovaps (%rsi), %ymm15
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm11 = ymm15[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 24(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-SLOW-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm13 = ymm12[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm13[1],ymm11[2,3],ymm13[4],ymm11[5,6],ymm13[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm13 = ymm15[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm13[2],ymm8[3,4],ymm13[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm8 = ymm12[0],ymm8[1,2],ymm12[3],ymm8[4,5],ymm12[6],ymm8[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm9[2],ymm6[3,4],ymm9[5],ymm6[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm10[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1,2],ymm9[3],ymm6[4,5],ymm9[6],ymm6[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm5 = ymm7[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0],ymm1[1,2],ymm5[3],ymm1[4,5],ymm5[6],ymm1[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm2 = ymm3[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7]
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm6, 224(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm8, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm11, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm4, 288(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm14, 352(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-SLOW-NEXT:    addq $40, %rsp
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride3_vf32:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovaps 32(%rdi), %ymm6
; AVX2-FAST-NEXT:    vmovaps 64(%rdi), %ymm11
; AVX2-FAST-NEXT:    vmovaps 96(%rdi), %ymm3
; AVX2-FAST-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FAST-NEXT:    vmovaps 32(%rsi), %ymm10
; AVX2-FAST-NEXT:    vmovaps 64(%rsi), %ymm13
; AVX2-FAST-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FAST-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-FAST-NEXT:    vmovaps 64(%rdx), %ymm14
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm0 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm5 = ymm4[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0,1],ymm0[2],ymm5[3,4],ymm0[5],ymm5[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm5 = ymm2[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm5[0],ymm0[1,2],ymm5[3],ymm0[4,5],ymm5[6],ymm0[7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vbroadcastf128 {{.*#+}} ymm8 = [1,0,2,2,1,0,2,2]
; AVX2-FAST-NEXT:    # ymm8 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermps %ymm1, %ymm8, %ymm5
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2,3],ymm5[4],ymm4[5,6],ymm5[7]
; AVX2-FAST-NEXT:    vbroadcastsd (%rdx), %ymm5
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0,1],ymm5[2],ymm4[3,4],ymm5[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm9 = [5,6,5,6,5,6,7,7]
; AVX2-FAST-NEXT:    vpermps %ymm13, %ymm9, %ymm5
; AVX2-FAST-NEXT:    vbroadcastsd 88(%rdi), %ymm7
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm7[2],ymm5[3,4],ymm7[5],ymm5[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm7 = ymm14[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm7[1],ymm5[2,3],ymm7[4],ymm5[5,6],ymm7[7]
; AVX2-FAST-NEXT:    vpermps %ymm13, %ymm8, %ymm7
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm15 = ymm11[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm15[0],ymm7[1],ymm15[2,3],ymm7[4],ymm15[5,6],ymm7[7]
; AVX2-FAST-NEXT:    vbroadcastsd 64(%rdx), %ymm15
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm15[2],ymm7[3,4],ymm15[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm13 = ymm13[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm13[2],ymm11[3,4],ymm13[5],ymm11[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm13 = ymm14[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm11 = ymm13[0],ymm11[1,2],ymm13[3],ymm11[4,5],ymm13[6],ymm11[7]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm13 = ymm10[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm14 = ymm6[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0,1],ymm13[2],ymm14[3,4],ymm13[5],ymm14[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm14 = ymm12[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1,2],ymm14[3],ymm13[4,5],ymm14[6],ymm13[7]
; AVX2-FAST-NEXT:    vpermps %ymm10, %ymm9, %ymm14
; AVX2-FAST-NEXT:    vbroadcastsd 56(%rdi), %ymm15
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-FAST-NEXT:    vmovaps 96(%rsi), %ymm15
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm12 = ymm14[0],ymm12[1],ymm14[2,3],ymm12[4],ymm14[5,6],ymm12[7]
; AVX2-FAST-NEXT:    vpermps %ymm10, %ymm8, %ymm10
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm10[1],ymm6[2,3],ymm10[4],ymm6[5,6],ymm10[7]
; AVX2-FAST-NEXT:    vbroadcastsd 32(%rdx), %ymm10
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm10[2],ymm6[3,4],ymm10[5],ymm6[6,7]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm10 = ymm15[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm14 = ymm3[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm10 = ymm14[0,1],ymm10[2],ymm14[3,4],ymm10[5],ymm14[6,7]
; AVX2-FAST-NEXT:    vmovaps 96(%rdx), %ymm14
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm0 = ymm14[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm10[1,2],ymm0[3],ymm10[4,5],ymm0[6],ymm10[7]
; AVX2-FAST-NEXT:    vpermps %ymm15, %ymm9, %ymm10
; AVX2-FAST-NEXT:    vbroadcastsd 120(%rdi), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm10[0,1],ymm4[2],ymm10[3,4],ymm4[5],ymm10[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm10 = ymm14[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm10[1],ymm4[2,3],ymm10[4],ymm4[5,6],ymm10[7]
; AVX2-FAST-NEXT:    vpermps %ymm15, %ymm8, %ymm8
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm8[1],ymm3[2,3],ymm8[4],ymm3[5,6],ymm8[7]
; AVX2-FAST-NEXT:    vbroadcastsd 96(%rdx), %ymm8
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm8[2],ymm3[3,4],ymm8[5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpermps %ymm1, %ymm9, %ymm1
; AVX2-FAST-NEXT:    vbroadcastsd 24(%rdi), %ymm8
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm8[2],ymm1[3,4],ymm8[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3],ymm2[4],ymm1[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovaps %ymm1, 64(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm3, 288(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm4, 352(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm6, 96(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm12, 160(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm13, 128(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm11, 224(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm7, 192(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm5, 256(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride3_vf32:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $40, %rsp
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdi), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rsi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm4 = ymm8[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm0[1],ymm4[2,3],ymm0[4],ymm4[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 88(%rdi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm11 = ymm9[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm11[0,1],ymm4[2],ymm11[3,4],ymm4[5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm4[0],ymm11[1],ymm4[2,3],ymm11[4],ymm4[5,6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm11 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm12 = ymm6[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1],ymm12[2,3],ymm11[4],ymm12[5,6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 64(%rdx), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 56(%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm13 = ymm5[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm13 = ymm7[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm12[0],ymm13[1],ymm12[2,3],ymm13[4],ymm12[5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm13 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm13 = ymm13[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm14 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm14[0],ymm13[1],ymm14[2,3],ymm13[4],ymm14[5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 32(%rdx), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm13[0,1],ymm14[2],ymm13[3,4],ymm14[5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 120(%rdi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm15 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0,1],ymm14[2],ymm15[3,4],ymm14[5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm3[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0],ymm15[1],ymm14[2,3],ymm15[4],ymm14[5,6],ymm15[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm15 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm15[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm4 = ymm0[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm15[1],ymm4[2,3],ymm15[4],ymm4[5,6],ymm15[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 96(%rdx), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm15[2],ymm4[3,4],ymm15[5],ymm4[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rsi), %ymm15
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm11 = ymm15[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm11 = ymm11[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 24(%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1],ymm12[2],ymm11[3,4],ymm12[5],ymm11[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdx), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm13 = ymm12[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm13[1],ymm11[2,3],ymm13[4],ymm11[5,6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm13 = ymm15[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1],ymm13[2],ymm8[3,4],ymm13[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm8 = ymm12[0],ymm8[1,2],ymm12[3],ymm8[4,5],ymm12[6],ymm8[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm9 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm9[2],ymm6[3,4],ymm9[5],ymm6[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm10[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0],ymm6[1,2],ymm9[3],ymm6[4,5],ymm9[6],ymm6[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm5 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm5[2],ymm1[3,4],ymm5[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm5 = ymm7[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm5[0],ymm1[1,2],ymm5[3],ymm1[4,5],ymm5[6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm2 = ymm2[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm2 = ymm3[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2],ymm2[3],ymm0[4,5],ymm2[6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm1, 128(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm6, 224(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm8, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm11, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm4, 288(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm14, 352(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    addq $40, %rsp
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm2
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm6 = <0,16,u,1,17,u,2,18,u,3,19,u,4,20,u,5>
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7
; AVX512-NEXT:    vpermt2d %zmm2, %zmm6, %zmm7
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm8 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermt2d %zmm4, %zmm8, %zmm7
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm9 = <u,11,27,u,12,28,u,13,29,u,14,30,u,15,31,u>
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm10
; AVX512-NEXT:    vpermt2d %zmm3, %zmm9, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm11 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm5, %zmm11, %zmm10
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <5,u,22,6,u,23,7,u,24,8,u,25,9,u,26,10>
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-NEXT:    vpermt2d %zmm1, %zmm12, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermt2d %zmm5, %zmm14, %zmm13
; AVX512-NEXT:    vpermt2d %zmm3, %zmm6, %zmm1
; AVX512-NEXT:    vpermt2d %zmm5, %zmm8, %zmm1
; AVX512-NEXT:    vpermi2d %zmm2, %zmm0, %zmm9
; AVX512-NEXT:    vpermt2d %zmm4, %zmm11, %zmm9
; AVX512-NEXT:    vpermt2d %zmm0, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm4, %zmm14, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm9, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <32 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <32 x i32> %in.vec0, <32 x i32> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i32> %in.vec2, <32 x i32> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <64 x i32> %1, <64 x i32> %2, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i32> %3, <96 x i32> poison, <96 x i32> <i32 0, i32 32, i32 64, i32 1, i32 33, i32 65, i32 2, i32 34, i32 66, i32 3, i32 35, i32 67, i32 4, i32 36, i32 68, i32 5, i32 37, i32 69, i32 6, i32 38, i32 70, i32 7, i32 39, i32 71, i32 8, i32 40, i32 72, i32 9, i32 41, i32 73, i32 10, i32 42, i32 74, i32 11, i32 43, i32 75, i32 12, i32 44, i32 76, i32 13, i32 45, i32 77, i32 14, i32 46, i32 78, i32 15, i32 47, i32 79, i32 16, i32 48, i32 80, i32 17, i32 49, i32 81, i32 18, i32 50, i32 82, i32 19, i32 51, i32 83, i32 20, i32 52, i32 84, i32 21, i32 53, i32 85, i32 22, i32 54, i32 86, i32 23, i32 55, i32 87, i32 24, i32 56, i32 88, i32 25, i32 57, i32 89, i32 26, i32 58, i32 90, i32 27, i32 59, i32 91, i32 28, i32 60, i32 92, i32 29, i32 61, i32 93, i32 30, i32 62, i32 94, i32 31, i32 63, i32 95>
  store <96 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i32_stride3_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %out.vec) nounwind {
; SSE-LABEL: store_i32_stride3_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $664, %rsp # imm = 0x298
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps 16(%rdi), %xmm2
; SSE-NEXT:    movaps 32(%rdi), %xmm3
; SSE-NEXT:    movaps 48(%rdi), %xmm4
; SSE-NEXT:    movaps (%rsi), %xmm12
; SSE-NEXT:    movaps 16(%rsi), %xmm11
; SSE-NEXT:    movaps 32(%rsi), %xmm10
; SSE-NEXT:    movaps 48(%rsi), %xmm9
; SSE-NEXT:    movaps (%rdx), %xmm5
; SSE-NEXT:    movaps 16(%rdx), %xmm6
; SSE-NEXT:    movaps 32(%rdx), %xmm7
; SSE-NEXT:    movaps 48(%rdx), %xmm8
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm5[0,3]
; SSE-NEXT:    movaps %xmm5, %xmm14
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm5
; SSE-NEXT:    unpcklps {{.*#+}} xmm5 = xmm5[0],xmm12[0],xmm5[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm1, %xmm13
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm12[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,3],xmm12[3,3]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[1,1],xmm14[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm12 = xmm12[0,2],xmm13[0,2]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm6[0,3]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm11[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm6[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm7[0,3]
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm10[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,3],xmm10[3,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[1,1],xmm7[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm8[0,3]
; SSE-NEXT:    movaps %xmm4, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm9[0],xmm1[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm9[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,3],xmm9[3,3]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[1,1],xmm8[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 64(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 80(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 96(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rdx), %xmm4
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm4[0,3]
; SSE-NEXT:    movaps 128(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    unpcklps {{.*#+}} xmm3 = xmm3[0],xmm1[0],xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm1[3,3]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm13
; SSE-NEXT:    movaps 144(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[0,3]
; SSE-NEXT:    movaps 144(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm13, %xmm2
; SSE-NEXT:    unpcklps {{.*#+}} xmm2 = xmm2[0],xmm1[0],xmm2[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm9
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[0,3]
; SSE-NEXT:    movaps 160(%rsi), %xmm15
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm15[0],xmm1[1],xmm15[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm15[1]
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[3,3],xmm15[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm15
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[0,3]
; SSE-NEXT:    movaps 176(%rsi), %xmm11
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm11[0],xmm1[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm11[1]
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[3,3],xmm11[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[0,2],xmm0[0,2]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm11
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[0,3]
; SSE-NEXT:    movaps 192(%rsi), %xmm14
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],xmm14[0],xmm1[1],xmm14[1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[3,3],xmm14[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm14 = xmm14[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 208(%rdi), %xmm8
; SSE-NEXT:    movaps 208(%rdx), %xmm2
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[0,3]
; SSE-NEXT:    movaps 208(%rsi), %xmm7
; SSE-NEXT:    movaps %xmm8, %xmm10
; SSE-NEXT:    unpcklps {{.*#+}} xmm10 = xmm10[0],xmm7[0],xmm10[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm10 = xmm10[0,1],xmm0[2,0]
; SSE-NEXT:    movaps %xmm8, %xmm0
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm7[1]
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[3,3],xmm7[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[1,1],xmm2[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,2],xmm0[0,2]
; SSE-NEXT:    movaps 224(%rdi), %xmm2
; SSE-NEXT:    movaps 224(%rdx), %xmm3
; SSE-NEXT:    movaps %xmm3, (%rsp) # 16-byte Spill
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm3[0,3]
; SSE-NEXT:    movaps 224(%rsi), %xmm5
; SSE-NEXT:    movaps %xmm2, %xmm6
; SSE-NEXT:    unpcklps {{.*#+}} xmm6 = xmm6[0],xmm5[0],xmm6[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm1[2,0]
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,3],xmm5[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[1,1],xmm3[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,2],xmm1[0,2]
; SSE-NEXT:    movaps 240(%rdi), %xmm0
; SSE-NEXT:    movaps 240(%rdx), %xmm12
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm12[0,3]
; SSE-NEXT:    movaps 240(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm4
; SSE-NEXT:    unpcklps {{.*#+}} xmm4 = xmm4[0],xmm1[0],xmm4[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm3[2,0]
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm1[1]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,3],xmm1[3,3]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm12[1,1]
; SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,2],xmm3[0,2]
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Reload
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm3 # 16-byte Folded Reload
; SSE-NEXT:    # xmm3 = xmm3[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm13 # 16-byte Folded Reload
; SSE-NEXT:    # xmm13 = xmm13[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm9 # 16-byte Folded Reload
; SSE-NEXT:    # xmm9 = xmm9[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm15 # 16-byte Folded Reload
; SSE-NEXT:    # xmm15 = xmm15[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Folded Reload
; SSE-NEXT:    # xmm11 = xmm11[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Folded Reload
; SSE-NEXT:    # xmm8 = xmm8[1,2],mem[2,3]
; SSE-NEXT:    shufps $233, (%rsp), %xmm2 # 16-byte Folded Reload
; SSE-NEXT:    # xmm2 = xmm2[1,2],mem[2,3]
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,2],xmm12[2,3]
; SSE-NEXT:    movaps %xmm1, 736(%rcx)
; SSE-NEXT:    movaps %xmm4, 720(%rcx)
; SSE-NEXT:    movaps %xmm5, 688(%rcx)
; SSE-NEXT:    movaps %xmm6, 672(%rcx)
; SSE-NEXT:    movaps %xmm7, 640(%rcx)
; SSE-NEXT:    movaps %xmm10, 624(%rcx)
; SSE-NEXT:    movaps %xmm14, 592(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 576(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 544(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 528(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 496(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 480(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 448(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 432(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 400(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 384(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 352(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 336(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 304(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 288(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 256(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 240(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 208(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 192(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 160(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 144(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 112(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 96(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 64(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 48(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, 16(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, (%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 752(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0,1,3]
; SSE-NEXT:    movaps %xmm2, 704(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0,1,3]
; SSE-NEXT:    movaps %xmm8, 656(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm11 = xmm11[2,0,1,3]
; SSE-NEXT:    movaps %xmm11, 608(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm15 = xmm15[2,0,1,3]
; SSE-NEXT:    movaps %xmm15, 560(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0,1,3]
; SSE-NEXT:    movaps %xmm9, 512(%rcx)
; SSE-NEXT:    shufps {{.*#+}} xmm13 = xmm13[2,0,1,3]
; SSE-NEXT:    movaps %xmm13, 464(%rcx)
; SSE-NEXT:    movaps %xmm3, %xmm0
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[1,3]
; SSE-NEXT:    movaps %xmm0, 416(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 368(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 320(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 272(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 224(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 176(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 128(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 80(%rcx)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0,1,3]
; SSE-NEXT:    movaps %xmm0, 32(%rcx)
; SSE-NEXT:    addq $664, %rsp # imm = 0x298
; SSE-NEXT:    retq
;
; AVX1-ONLY-LABEL: store_i32_stride3_vf64:
; AVX1-ONLY:       # %bb.0:
; AVX1-ONLY-NEXT:    subq $200, %rsp
; AVX1-ONLY-NEXT:    vmovapd (%rdx), %ymm8
; AVX1-ONLY-NEXT:    vmovapd 32(%rdx), %ymm9
; AVX1-ONLY-NEXT:    vmovapd 64(%rdx), %ymm11
; AVX1-ONLY-NEXT:    vmovapd 96(%rdx), %ymm12
; AVX1-ONLY-NEXT:    vmovaps (%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 16(%rsi), %xmm1
; AVX1-ONLY-NEXT:    vmovaps 32(%rsi), %xmm2
; AVX1-ONLY-NEXT:    vmovaps 48(%rsi), %xmm3
; AVX1-ONLY-NEXT:    vmovaps (%rdi), %xmm4
; AVX1-ONLY-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX1-ONLY-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm4[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm7 = xmm0[1,1],xmm7[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm4[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd (%rdx), %ymm4
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm4[2],ymm0[3,4],ymm4[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm5[3,3],xmm1[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm5[1],xmm1[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm8[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm6[1],xmm2[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm2[1,1],xmm0[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm1 = xmm2[0],xmm6[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[2,0],xmm6[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm0[3,3],xmm3[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm3[1,1],xmm0[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm9[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 64(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 80(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 80(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm11[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 96(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 112(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 112(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 128(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 144(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 144(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX1-ONLY-NEXT:    vmovapd 128(%rdx), %ymm6
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm6[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-ONLY-NEXT:    vmovaps 160(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[1,1],xmm2[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm14 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 176(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 176(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 160(%rdx), %ymm4
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm4[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm1 = ymm1[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm15 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX1-ONLY-NEXT:    vmovaps 192(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm0[1,1],xmm3[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 208(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 208(%rdi), %xmm1
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm3 = xmm1[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vmovapd 192(%rdx), %ymm2
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm2[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0],ymm3[1],ymm0[2,3],ymm3[4],ymm0[5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vmovaps 224(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 224(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm3[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm5 = xmm0[1,1],xmm5[0,2]
; AVX1-ONLY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[2,1]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX1-ONLY-NEXT:    vbroadcastsd 224(%rdx), %ymm3
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm5 = ymm0[0,1],ymm3[2],ymm0[3,4],ymm3[5],ymm0[6,7]
; AVX1-ONLY-NEXT:    vmovaps 240(%rsi), %xmm0
; AVX1-ONLY-NEXT:    vmovaps 240(%rdi), %xmm3
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm1 = xmm3[3,3],xmm0[3,3]
; AVX1-ONLY-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; AVX1-ONLY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[0,2]
; AVX1-ONLY-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX1-ONLY-NEXT:    vmovapd 224(%rdx), %ymm0
; AVX1-ONLY-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm0[2,3,2,3]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm3 = ymm3[0,0,3,3]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0],ymm3[1],ymm1[2,3],ymm3[4],ymm1[5,6],ymm3[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0],ymm1[1,2],ymm8[3],ymm1[4,5],ymm8[6],ymm1[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm1[1,2],ymm9[3],ymm1[4,5],ymm9[6],ymm1[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm1 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1],ymm1[2],ymm13[3,4],ymm1[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm11 = ymm11[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm1 = ymm11[0],ymm1[1,2],ymm11[3],ymm1[4,5],ymm11[6],ymm1[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm13[0,1],ymm11[2],ymm13[3,4],ymm11[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm11 = ymm12[0],ymm11[1,2],ymm12[3],ymm11[4,5],ymm12[6],ymm11[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm12[1,2],ymm6[3],ymm12[4,5],ymm6[6],ymm12[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm12[1,2],ymm4[3],ymm12[4,5],ymm4[6],ymm12[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm12[1,2],ymm2[3],ymm12[4,5],ymm2[6],ymm12[7]
; AVX1-ONLY-NEXT:    vpermilps {{.*#+}} ymm12 = mem[0,0,3,3,4,4,7,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm13 = mem[1,0,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm12 = ymm13[0,1],ymm12[2],ymm13[3,4],ymm12[5],ymm13[6,7]
; AVX1-ONLY-NEXT:    vpermilpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX1-ONLY-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm12[1,2],ymm0[3],ymm12[4,5],ymm0[6],ymm12[7]
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm2, 608(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm4, 512(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm6, 416(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm11, 320(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm1, 224(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm9, 128(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm8, 32(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm3, 736(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm5, 672(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm7, 640(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm10, 576(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm15, 544(%rcx)
; AVX1-ONLY-NEXT:    vmovaps %ymm14, 480(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX1-ONLY-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX1-ONLY-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX1-ONLY-NEXT:    vmovaps %ymm0, (%rcx)
; AVX1-ONLY-NEXT:    addq $200, %rsp
; AVX1-ONLY-NEXT:    vzeroupper
; AVX1-ONLY-NEXT:    retq
;
; AVX2-SLOW-LABEL: store_i32_stride3_vf64:
; AVX2-SLOW:       # %bb.0:
; AVX2-SLOW-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX2-SLOW-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 32(%rdi), %ymm14
; AVX2-SLOW-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-SLOW-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-SLOW-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 32(%rsi), %ymm4
; AVX2-SLOW-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 64(%rsi), %ymm8
; AVX2-SLOW-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-SLOW-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-SLOW-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-SLOW-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd (%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 24(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm14[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 56(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm7[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vbroadcastsd 88(%rdi), %ymm0
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm8[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 96(%rsi), %ymm13
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm13[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 128(%rdi), %ymm12
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm12[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 128(%rsi), %ymm10
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovaps 128(%rdx), %ymm9
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm9[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 160(%rdi), %ymm8
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm8[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 160(%rsi), %ymm7
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm7[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 184(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovaps 160(%rdx), %ymm6
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 216(%rdi), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovaps 192(%rdx), %ymm3
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-SLOW-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[0,0,2,1]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-SLOW-NEXT:    vbroadcastsd 224(%rdx), %ymm1
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm0 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-SLOW-NEXT:    vbroadcastsd 248(%rdi), %ymm11
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1],ymm11[2],ymm0[3,4],ymm11[5],ymm0[6,7]
; AVX2-SLOW-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm0[2,1,3,3]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm15[1],ymm11[2,3],ymm15[4],ymm11[5,6],ymm15[7]
; AVX2-SLOW-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4],ymm11[5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0],ymm11[1,2],ymm15[3],ymm11[4,5],ymm15[6],ymm11[7]
; AVX2-SLOW-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-SLOW-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm15 = ymm14[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4],ymm11[5],ymm15[6,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0],ymm11[1,2],ymm15[3],ymm11[4,5],ymm15[6],ymm11[7]
; AVX2-SLOW-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm14 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3],ymm14[4,5],ymm15[6],ymm14[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm15 = ymm13[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm13 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4],ymm15[5],ymm13[6,7]
; AVX2-SLOW-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-SLOW-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3],ymm13[4,5],ymm15[6],ymm13[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1],ymm10[2],ymm12[3,4],ymm10[5],ymm12[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2],ymm9[3],ymm10[4,5],ymm9[6],ymm10[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2],ymm3[3],ymm4[4,5],ymm3[6],ymm4[7]
; AVX2-SLOW-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7]
; AVX2-SLOW-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-SLOW-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7]
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm3, 608(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm6, 512(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm9, 416(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm13, 320(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm14, 224(%rcx)
; AVX2-SLOW-NEXT:    vmovaps %ymm11, 128(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-SLOW-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-SLOW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-SLOW-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-SLOW-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX2-SLOW-NEXT:    vzeroupper
; AVX2-SLOW-NEXT:    retq
;
; AVX2-FAST-LABEL: store_i32_stride3_vf64:
; AVX2-FAST:       # %bb.0:
; AVX2-FAST-NEXT:    subq $232, %rsp
; AVX2-FAST-NEXT:    vmovaps (%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovaps 32(%rdi), %ymm2
; AVX2-FAST-NEXT:    vmovaps 64(%rdi), %ymm9
; AVX2-FAST-NEXT:    vmovaps 96(%rdi), %ymm12
; AVX2-FAST-NEXT:    vmovaps (%rsi), %ymm8
; AVX2-FAST-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FAST-NEXT:    vmovaps 64(%rsi), %ymm0
; AVX2-FAST-NEXT:    vmovaps 96(%rsi), %ymm13
; AVX2-FAST-NEXT:    vmovaps (%rdx), %ymm10
; AVX2-FAST-NEXT:    vmovaps 32(%rdx), %ymm3
; AVX2-FAST-NEXT:    vmovaps 64(%rdx), %ymm1
; AVX2-FAST-NEXT:    vmovaps 96(%rdx), %ymm14
; AVX2-FAST-NEXT:    vbroadcastf128 {{.*#+}} ymm6 = [1,0,2,2,1,0,2,2]
; AVX2-FAST-NEXT:    # ymm6 = mem[0,1,0,1]
; AVX2-FAST-NEXT:    vpermps %ymm8, %ymm6, %ymm7
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm11 = ymm4[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm11[0],ymm7[1],ymm11[2,3],ymm7[4],ymm11[5,6],ymm7[7]
; AVX2-FAST-NEXT:    vbroadcastsd (%rdx), %ymm11
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm11[2],ymm7[3,4],ymm11[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm7 = ymm8[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm7[2],ymm4[3,4],ymm7[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm7 = ymm10[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm7[0],ymm4[1,2],ymm7[3],ymm4[4,5],ymm7[6],ymm4[7]
; AVX2-FAST-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vmovaps {{.*#+}} ymm7 = [5,6,5,6,5,6,7,7]
; AVX2-FAST-NEXT:    vpermps %ymm8, %ymm7, %ymm4
; AVX2-FAST-NEXT:    vbroadcastsd 24(%rdi), %ymm8
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm8[2],ymm4[3,4],ymm8[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm8 = ymm10[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0],ymm8[1],ymm4[2,3],ymm8[4],ymm4[5,6],ymm8[7]
; AVX2-FAST-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm5, %ymm6, %ymm4
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm8 = ymm2[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm8[0],ymm4[1],ymm8[2,3],ymm4[4],ymm8[5,6],ymm4[7]
; AVX2-FAST-NEXT:    vbroadcastsd 32(%rdx), %ymm8
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm8[2],ymm4[3,4],ymm8[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm4 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm3[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0],ymm2[1,2],ymm4[3],ymm2[4,5],ymm4[6],ymm2[7]
; AVX2-FAST-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm5, %ymm7, %ymm2
; AVX2-FAST-NEXT:    vbroadcastsd 56(%rdi), %ymm5
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm5[2],ymm2[3,4],ymm5[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3],ymm3[4],ymm2[5,6],ymm3[7]
; AVX2-FAST-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm6, %ymm2
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm9[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vbroadcastsd 64(%rdx), %ymm3
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm2 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm9[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2],ymm3[3,4],ymm2[5],ymm3[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm1[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1,2],ymm3[3],ymm2[4,5],ymm3[6],ymm2[7]
; AVX2-FAST-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vbroadcastsd 88(%rdi), %ymm2
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2],ymm0[3,4],ymm2[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm13, %ymm6, %ymm0
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm12[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm0 = ymm13[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm12[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm14[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1,2],ymm1[3],ymm0[4,5],ymm1[6],ymm0[7]
; AVX2-FAST-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-NEXT:    vpermps %ymm13, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vmovaps 128(%rdi), %ymm1
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm2 = ymm14[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm13 = ymm0[0],ymm2[1],ymm0[2,3],ymm2[4],ymm0[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vmovaps 128(%rsi), %ymm0
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm6, %ymm2
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm1[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3],ymm2[4],ymm3[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vbroadcastsd 128(%rdx), %ymm3
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm14 = ymm2[0,1],ymm3[2],ymm2[3,4],ymm3[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm2 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2],ymm1[3,4],ymm2[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm3 = ymm2[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm15 = ymm3[0],ymm1[1,2],ymm3[3],ymm1[4,5],ymm3[6],ymm1[7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm8 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-NEXT:    vmovaps 160(%rdi), %ymm1
; AVX2-FAST-NEXT:    vmovaps 160(%rsi), %ymm0
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm6, %ymm2
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm1[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0],ymm2[1],ymm4[2,3],ymm2[4],ymm4[5,6],ymm2[7]
; AVX2-FAST-NEXT:    vbroadcastsd 160(%rdx), %ymm4
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1],ymm4[2],ymm2[3,4],ymm4[5],ymm2[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[1,1,2,2]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm4 = ymm0[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm4[2],ymm1[3,4],ymm4[5],ymm1[6,7]
; AVX2-FAST-NEXT:    vmovaps 160(%rdx), %ymm4
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm5 = ymm4[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm1[1,2],ymm5[3],ymm1[4,5],ymm5[6],ymm1[7]
; AVX2-FAST-NEXT:    vpermps %ymm0, %ymm7, %ymm0
; AVX2-FAST-NEXT:    vbroadcastsd 184(%rdi), %ymm5
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm5[2],ymm0[3,4],ymm5[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm1 = ymm0[0],ymm4[1],ymm0[2,3],ymm4[4],ymm0[5,6],ymm4[7]
; AVX2-FAST-NEXT:    vmovaps 192(%rdi), %ymm4
; AVX2-FAST-NEXT:    vmovaps 192(%rsi), %ymm5
; AVX2-FAST-NEXT:    vpermps %ymm5, %ymm6, %ymm0
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm9 = ymm4[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0],ymm0[1],ymm9[2,3],ymm0[4],ymm9[5,6],ymm0[7]
; AVX2-FAST-NEXT:    vbroadcastsd 192(%rdx), %ymm9
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm9[2],ymm0[3,4],ymm9[5],ymm0[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm4 = ymm4[1,1,2,2]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm9 = ymm5[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm9[2],ymm4[3,4],ymm9[5],ymm4[6,7]
; AVX2-FAST-NEXT:    vmovaps 192(%rdx), %ymm9
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm10 = ymm9[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm4 = ymm10[0],ymm4[1,2],ymm10[3],ymm4[4,5],ymm10[6],ymm4[7]
; AVX2-FAST-NEXT:    vpermps %ymm5, %ymm7, %ymm5
; AVX2-FAST-NEXT:    vbroadcastsd 216(%rdi), %ymm10
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1],ymm10[2],ymm5[3,4],ymm10[5],ymm5[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0],ymm9[1],ymm5[2,3],ymm9[4],ymm5[5,6],ymm9[7]
; AVX2-FAST-NEXT:    vmovaps 224(%rsi), %ymm9
; AVX2-FAST-NEXT:    vpermps %ymm9, %ymm6, %ymm6
; AVX2-FAST-NEXT:    vmovaps 224(%rdi), %ymm10
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm11 = ymm10[0,0,2,1]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm6 = ymm11[0],ymm6[1],ymm11[2,3],ymm6[4],ymm11[5,6],ymm6[7]
; AVX2-FAST-NEXT:    vbroadcastsd 224(%rdx), %ymm11
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1],ymm11[2],ymm6[3,4],ymm11[5],ymm6[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm10 = ymm10[1,1,2,2]
; AVX2-FAST-NEXT:    vpermilps {{.*#+}} ymm11 = ymm9[0,0,3,3,4,4,7,7]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2],ymm10[3,4],ymm11[5],ymm10[6,7]
; AVX2-FAST-NEXT:    vmovaps 224(%rdx), %ymm11
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm12 = ymm11[1,1,2,2]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0],ymm10[1,2],ymm12[3],ymm10[4,5],ymm12[6],ymm10[7]
; AVX2-FAST-NEXT:    vpermps %ymm9, %ymm7, %ymm7
; AVX2-FAST-NEXT:    vbroadcastsd 248(%rdi), %ymm9
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2],ymm7[3,4],ymm9[5],ymm7[6,7]
; AVX2-FAST-NEXT:    vpermpd {{.*#+}} ymm9 = ymm11[2,1,3,3]
; AVX2-FAST-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0],ymm9[1],ymm7[2,3],ymm9[4],ymm7[5,6],ymm9[7]
; AVX2-FAST-NEXT:    vmovaps %ymm7, 736(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm10, 704(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm6, 672(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm5, 640(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm4, 608(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm1, 544(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm2, 512(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm3, 480(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm8, 448(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm15, 416(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm14, 384(%rcx)
; AVX2-FAST-NEXT:    vmovaps %ymm13, 352(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 320(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 224(%rcx)
; AVX2-FAST-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 128(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-NEXT:    addq $232, %rsp
; AVX2-FAST-NEXT:    vzeroupper
; AVX2-FAST-NEXT:    retq
;
; AVX2-FAST-PERLANE-LABEL: store_i32_stride3_vf64:
; AVX2-FAST-PERLANE:       # %bb.0:
; AVX2-FAST-PERLANE-NEXT:    subq $712, %rsp # imm = 0x2C8
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdi), %ymm14
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdi), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rsi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rsi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps (%rdx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 32(%rdx), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 64(%rdx), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd (%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 24(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm2[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm14[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 32(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 56(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm7[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 64(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 88(%rdi), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm8[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1],ymm0[2],ymm1[3,4],ymm0[5],ymm1[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 96(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rsi), %ymm13
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm13[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 120(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 96(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 128(%rdi), %ymm12
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm12[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 128(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 128(%rsi), %ymm10
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm10[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 152(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 128(%rdx), %ymm9
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm9[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 160(%rdi), %ymm8
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm8[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 160(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 160(%rsi), %ymm7
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm7[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 184(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 160(%rdx), %ymm6
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm6[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 192(%rdi), %ymm5
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm5[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 192(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, (%rsp) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 192(%rsi), %ymm4
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm4[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 216(%rdi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 192(%rdx), %ymm3
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm3[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1],ymm0[2,3],ymm1[4],ymm0[5,6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} xmm0 = mem[1,0,2,2]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,1,0,1]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm1 = ymm2[0,0,2,1]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0],ymm0[1],ymm1[2,3],ymm0[4],ymm1[5,6],ymm0[7]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 224(%rdx), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2],ymm0[3,4],ymm1[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm0 = ymm1[1,2,3,3,5,6,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[2,2,2,3]
; AVX2-FAST-PERLANE-NEXT:    vbroadcastsd 248(%rdi), %ymm11
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm0[0,1],ymm11[2],ymm0[3,4],ymm11[5],ymm0[6,7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm0[2,1,3,3]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0],ymm15[1],ymm11[2,3],ymm15[4],ymm11[5,6],ymm15[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4],ymm11[5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0],ymm11[1,2],ymm15[3],ymm11[4,5],ymm15[6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vmovups %ymm11, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FAST-PERLANE-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm11 = mem[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm15 = ymm14[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0,1],ymm11[2],ymm15[3,4],ymm11[5],ymm15[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm11 = ymm15[0],ymm11[1,2],ymm15[3],ymm11[4,5],ymm15[6],ymm11[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps $240, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm14 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm14 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1],ymm15[2],ymm14[3,4],ymm15[5],ymm14[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm14 = ymm15[0],ymm14[1,2],ymm15[3],ymm14[4,5],ymm15[6],ymm14[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm15 = ymm13[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm13 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm13 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1],ymm15[2],ymm13[3,4],ymm15[5],ymm13[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd $165, {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Folded Reload
; AVX2-FAST-PERLANE-NEXT:    # ymm15 = mem[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm13 = ymm15[0],ymm13[1,2],ymm15[3],ymm13[4,5],ymm15[6],ymm13[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm10 = ymm10[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm12 = ymm12[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm10 = ymm12[0,1],ymm10[2],ymm12[3,4],ymm10[5],ymm12[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm9 = ymm9[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0],ymm10[1,2],ymm9[3],ymm10[4,5],ymm9[6],ymm10[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm7 = ymm7[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm8 = ymm8[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm7 = ymm8[0,1],ymm7[2],ymm8[3,4],ymm7[5],ymm8[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm6 = ymm6[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0],ymm7[1,2],ymm6[3],ymm7[4,5],ymm6[6],ymm7[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm4 = ymm4[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm5 = ymm5[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm4 = ymm5[0,1],ymm4[2],ymm5[3,4],ymm4[5],ymm5[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0],ymm4[1,2],ymm3[3],ymm4[4,5],ymm3[6],ymm4[7]
; AVX2-FAST-PERLANE-NEXT:    vpermilps {{.*#+}} ymm1 = ymm1[0,0,3,3,4,4,7,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm2 = ymm2[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2],ymm2[3,4],ymm1[5],ymm2[6,7]
; AVX2-FAST-PERLANE-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[1,1,2,2]
; AVX2-FAST-PERLANE-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0],ymm1[1,2],ymm0[3],ymm1[4,5],ymm0[6],ymm1[7]
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 704(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm3, 608(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm6, 512(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm9, 416(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm13, 320(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm14, 224(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm11, 128(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 32(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 736(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 672(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 640(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups (%rsp), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 576(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 544(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 480(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 448(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 384(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 352(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 288(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 256(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 192(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 160(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 96(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, 64(%rcx)
; AVX2-FAST-PERLANE-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FAST-PERLANE-NEXT:    vmovaps %ymm0, (%rcx)
; AVX2-FAST-PERLANE-NEXT:    addq $712, %rsp # imm = 0x2C8
; AVX2-FAST-PERLANE-NEXT:    vzeroupper
; AVX2-FAST-PERLANE-NEXT:    retq
;
; AVX512-LABEL: store_i32_stride3_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm3
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm0
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm6
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm7
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm8
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm9
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm10
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm11
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm12 = <0,16,u,1,17,u,2,18,u,3,19,u,4,20,u,5>
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm13
; AVX512-NEXT:    vpermt2d %zmm4, %zmm12, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm14 = [0,1,16,3,4,17,6,7,18,9,10,19,12,13,20,15]
; AVX512-NEXT:    vpermt2d %zmm8, %zmm14, %zmm13
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm15 = <u,11,27,u,12,28,u,13,29,u,14,30,u,15,31,u>
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm16
; AVX512-NEXT:    vpermt2d %zmm7, %zmm15, %zmm16
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm17 = [26,1,2,27,4,5,28,7,8,29,10,11,30,13,14,31]
; AVX512-NEXT:    vpermt2d %zmm11, %zmm17, %zmm16
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm18 = <5,u,22,6,u,23,7,u,24,8,u,25,9,u,26,10>
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm19
; AVX512-NEXT:    vpermt2d %zmm0, %zmm18, %zmm19
; AVX512-NEXT:    vmovdqa64 {{.*#+}} zmm20 = [0,21,2,3,22,5,6,23,8,9,24,11,12,25,14,15]
; AVX512-NEXT:    vpermt2d %zmm11, %zmm20, %zmm19
; AVX512-NEXT:    vpermt2d %zmm7, %zmm12, %zmm0
; AVX512-NEXT:    vpermt2d %zmm11, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm7
; AVX512-NEXT:    vpermt2d %zmm6, %zmm15, %zmm7
; AVX512-NEXT:    vpermt2d %zmm10, %zmm17, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-NEXT:    vpermt2d %zmm1, %zmm18, %zmm11
; AVX512-NEXT:    vpermt2d %zmm10, %zmm20, %zmm11
; AVX512-NEXT:    vpermt2d %zmm6, %zmm12, %zmm1
; AVX512-NEXT:    vpermt2d %zmm10, %zmm14, %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm6
; AVX512-NEXT:    vpermt2d %zmm5, %zmm15, %zmm6
; AVX512-NEXT:    vpermt2d %zmm9, %zmm17, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm10
; AVX512-NEXT:    vpermt2d %zmm2, %zmm18, %zmm10
; AVX512-NEXT:    vpermt2d %zmm9, %zmm20, %zmm10
; AVX512-NEXT:    vpermt2d %zmm5, %zmm12, %zmm2
; AVX512-NEXT:    vpermt2d %zmm9, %zmm14, %zmm2
; AVX512-NEXT:    vpermi2d %zmm4, %zmm3, %zmm15
; AVX512-NEXT:    vpermt2d %zmm8, %zmm17, %zmm15
; AVX512-NEXT:    vpermt2d %zmm3, %zmm18, %zmm4
; AVX512-NEXT:    vpermt2d %zmm8, %zmm20, %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm4, 64(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm15, 128(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm10, 256(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm6, 320(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm1, 384(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm11, 448(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm7, 512(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm0, 576(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm19, 640(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm16, 704(%rcx)
; AVX512-NEXT:    vmovdqa64 %zmm13, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %in.vec0 = load <64 x i32>, ptr %in.vecptr0, align 64
  %in.vec1 = load <64 x i32>, ptr %in.vecptr1, align 64
  %in.vec2 = load <64 x i32>, ptr %in.vecptr2, align 64
  %1 = shufflevector <64 x i32> %in.vec0, <64 x i32> %in.vec1, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %2 = shufflevector <64 x i32> %in.vec2, <64 x i32> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %3 = shufflevector <128 x i32> %1, <128 x i32> %2, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i32> %3, <192 x i32> poison, <192 x i32> <i32 0, i32 64, i32 128, i32 1, i32 65, i32 129, i32 2, i32 66, i32 130, i32 3, i32 67, i32 131, i32 4, i32 68, i32 132, i32 5, i32 69, i32 133, i32 6, i32 70, i32 134, i32 7, i32 71, i32 135, i32 8, i32 72, i32 136, i32 9, i32 73, i32 137, i32 10, i32 74, i32 138, i32 11, i32 75, i32 139, i32 12, i32 76, i32 140, i32 13, i32 77, i32 141, i32 14, i32 78, i32 142, i32 15, i32 79, i32 143, i32 16, i32 80, i32 144, i32 17, i32 81, i32 145, i32 18, i32 82, i32 146, i32 19, i32 83, i32 147, i32 20, i32 84, i32 148, i32 21, i32 85, i32 149, i32 22, i32 86, i32 150, i32 23, i32 87, i32 151, i32 24, i32 88, i32 152, i32 25, i32 89, i32 153, i32 26, i32 90, i32 154, i32 27, i32 91, i32 155, i32 28, i32 92, i32 156, i32 29, i32 93, i32 157, i32 30, i32 94, i32 158, i32 31, i32 95, i32 159, i32 32, i32 96, i32 160, i32 33, i32 97, i32 161, i32 34, i32 98, i32 162, i32 35, i32 99, i32 163, i32 36, i32 100, i32 164, i32 37, i32 101, i32 165, i32 38, i32 102, i32 166, i32 39, i32 103, i32 167, i32 40, i32 104, i32 168, i32 41, i32 105, i32 169, i32 42, i32 106, i32 170, i32 43, i32 107, i32 171, i32 44, i32 108, i32 172, i32 45, i32 109, i32 173, i32 46, i32 110, i32 174, i32 47, i32 111, i32 175, i32 48, i32 112, i32 176, i32 49, i32 113, i32 177, i32 50, i32 114, i32 178, i32 51, i32 115, i32 179, i32 52, i32 116, i32 180, i32 53, i32 117, i32 181, i32 54, i32 118, i32 182, i32 55, i32 119, i32 183, i32 56, i32 120, i32 184, i32 57, i32 121, i32 185, i32 58, i32 122, i32 186, i32 59, i32 123, i32 187, i32 60, i32 124, i32 188, i32 61, i32 125, i32 189, i32 62, i32 126, i32 190, i32 63, i32 127, i32 191>
  store <192 x i32> %interleaved.vec, ptr %out.vec, align 64
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
; AVX1: {{.*}}
; AVX2-ONLY: {{.*}}
; AVX512BW: {{.*}}
; AVX512BW-FAST: {{.*}}
; AVX512BW-ONLY-FAST: {{.*}}
; AVX512BW-ONLY-SLOW: {{.*}}
; AVX512BW-SLOW: {{.*}}
; AVX512DQ-FAST: {{.*}}
; AVX512DQ-SLOW: {{.*}}
; AVX512DQBW-FAST: {{.*}}
; AVX512DQBW-SLOW: {{.*}}
; AVX512F: {{.*}}
; AVX512F-FAST: {{.*}}
; AVX512F-ONLY-FAST: {{.*}}
; AVX512F-ONLY-SLOW: {{.*}}
; AVX512F-SLOW: {{.*}}
; FALLBACK0: {{.*}}
; FALLBACK1: {{.*}}
; FALLBACK10: {{.*}}
; FALLBACK11: {{.*}}
; FALLBACK12: {{.*}}
; FALLBACK2: {{.*}}
; FALLBACK3: {{.*}}
; FALLBACK4: {{.*}}
; FALLBACK5: {{.*}}
; FALLBACK6: {{.*}}
; FALLBACK7: {{.*}}
; FALLBACK8: {{.*}}
; FALLBACK9: {{.*}}
