; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare i8 @llvm.abs.i8(i8, i1)
declare i32 @llvm.abs.i32(i32, i1)
declare <4 x i32> @llvm.abs.v4i32(<4 x i32>, i1)
declare <3 x i82> @llvm.abs.v3i82(<3 x i82>, i1)
declare void @llvm.assume(i1)

; abs preserves trailing zeros so the second and is unneeded
define i32 @abs_trailing_zeros(i32 %x) {
; CHECK-LABEL: @abs_trailing_zeros(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], -4
; CHECK-NEXT:    [[ABS:%.*]] = call i32 @llvm.abs.i32(i32 [[AND]], i1 false)
; CHECK-NEXT:    ret i32 [[ABS]]
;
  %and = and i32 %x, -4
  %abs = call i32 @llvm.abs.i32(i32 %and, i1 false)
  %and2 = and i32 %abs, -2
  ret i32 %and2
}

define <4 x i32> @abs_trailing_zeros_vec(<4 x i32> %x) {
; CHECK-LABEL: @abs_trailing_zeros_vec(
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[X:%.*]], <i32 -4, i32 -8, i32 -16, i32 -32>
; CHECK-NEXT:    [[ABS:%.*]] = call <4 x i32> @llvm.abs.v4i32(<4 x i32> [[AND]], i1 false)
; CHECK-NEXT:    ret <4 x i32> [[ABS]]
;
  %and = and <4 x i32> %x, <i32 -4, i32 -8, i32 -16, i32 -32>
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %and, i1 false)
  %and2 = and <4 x i32> %abs, <i32 -2, i32 -2, i32 -2, i32 -2>
  ret <4 x i32> %and2
}

; negative test, can't remove the second and based on trailing zeroes.
; FIXME: Could remove the first and using demanded bits.
define i32 @abs_trailing_zeros_negative(i32 %x) {
; CHECK-LABEL: @abs_trailing_zeros_negative(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], -2
; CHECK-NEXT:    [[ABS:%.*]] = call i32 @llvm.abs.i32(i32 [[AND]], i1 false)
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[ABS]], -4
; CHECK-NEXT:    ret i32 [[AND2]]
;
  %and = and i32 %x, -2
  %abs = call i32 @llvm.abs.i32(i32 %and, i1 false)
  %and2 = and i32 %abs, -4
  ret i32 %and2
}

define <4 x i32> @abs_trailing_zeros_negative_vec(<4 x i32> %x) {
; CHECK-LABEL: @abs_trailing_zeros_negative_vec(
; CHECK-NEXT:    [[AND:%.*]] = and <4 x i32> [[X:%.*]], <i32 -2, i32 -2, i32 -2, i32 -2>
; CHECK-NEXT:    [[ABS:%.*]] = call <4 x i32> @llvm.abs.v4i32(<4 x i32> [[AND]], i1 false)
; CHECK-NEXT:    [[AND2:%.*]] = and <4 x i32> [[ABS]], <i32 -4, i32 -4, i32 -4, i32 -4>
; CHECK-NEXT:    ret <4 x i32> [[AND2]]
;
  %and = and <4 x i32> %x, <i32 -2, i32 -2, i32 -2, i32 -2>
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %and, i1 false)
  %and2 = and <4 x i32> %abs, <i32 -4, i32 -4, i32 -4, i32 -4>
  ret <4 x i32> %and2
}

; Make sure we infer this add doesn't overflow. The input to the abs has 3
; sign bits, the abs reduces this to 2 sign bits.
define i32 @abs_signbits(i30 %x) {
; CHECK-LABEL: @abs_signbits(
; CHECK-NEXT:    [[TMP1:%.*]] = call i30 @llvm.abs.i30(i30 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[NARROW:%.*]] = add nuw i30 [[TMP1]], 1
; CHECK-NEXT:    [[ADD:%.*]] = zext i30 [[NARROW]] to i32
; CHECK-NEXT:    ret i32 [[ADD]]
;
  %ext = sext i30 %x to i32
  %abs = call i32 @llvm.abs.i32(i32 %ext, i1 false)
  %add = add i32 %abs, 1
  ret i32 %add
}

define <4 x i32> @abs_signbits_vec(<4 x i30> %x) {
; CHECK-LABEL: @abs_signbits_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i30> @llvm.abs.v4i30(<4 x i30> [[X:%.*]], i1 false)
; CHECK-NEXT:    [[NARROW:%.*]] = add nuw <4 x i30> [[TMP1]], <i30 1, i30 1, i30 1, i30 1>
; CHECK-NEXT:    [[ADD:%.*]] = zext <4 x i30> [[NARROW]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[ADD]]
;
  %ext = sext <4 x i30> %x to <4 x i32>
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %ext, i1 false)
  %add = add <4 x i32> %abs, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %add
}

define i32 @abs_of_neg(i32 %x) {
; CHECK-LABEL: @abs_of_neg(
; CHECK-NEXT:    [[B:%.*]] = call i32 @llvm.abs.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    ret i32 [[B]]
;
  %a = sub i32 0, %x
  %b = call i32 @llvm.abs.i32(i32 %a, i1 false)
  ret i32 %b
}

define <4 x i32> @abs_of_neg_vec(<4 x i32> %x) {
; CHECK-LABEL: @abs_of_neg_vec(
; CHECK-NEXT:    [[B:%.*]] = call <4 x i32> @llvm.abs.v4i32(<4 x i32> [[X:%.*]], i1 false)
; CHECK-NEXT:    ret <4 x i32> [[B]]
;
  %a = sub nsw <4 x i32> zeroinitializer, %x
  %b = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %a, i1 false)
  ret <4 x i32> %b
}

define i32 @abs_of_select_neg_true_val(i1 %b, i32 %x) {
; CHECK-LABEL: @abs_of_select_neg_true_val(
; CHECK-NEXT:    [[ABS:%.*]] = call i32 @llvm.abs.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    ret i32 [[ABS]]
;
  %neg = sub i32 0, %x
  %sel = select i1 %b, i32 %neg, i32 %x
  %abs = call i32 @llvm.abs.i32(i32 %sel, i1 true)
  ret i32 %abs
}

define <4 x i32> @abs_of_select_neg_false_val(<4 x i1> %b, <4 x i32> %x) {
; CHECK-LABEL: @abs_of_select_neg_false_val(
; CHECK-NEXT:    [[ABS:%.*]] = call <4 x i32> @llvm.abs.v4i32(<4 x i32> [[X:%.*]], i1 false)
; CHECK-NEXT:    ret <4 x i32> [[ABS]]
;
  %neg = sub <4 x i32> zeroinitializer, %x
  %sel = select <4 x i1> %b, <4 x i32> %x, <4 x i32> %neg
  %abs = call <4 x i32> @llvm.abs.v4i32(<4 x i32> %sel, i1 false)
  ret <4 x i32> %abs
}

define i32 @abs_dom_cond_nopoison(i32 %x) {
; CHECK-LABEL: @abs_dom_cond_nopoison(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i32 [[X]]
; CHECK:       false:
; CHECK-NEXT:    [[A2:%.*]] = sub i32 0, [[X]]
; CHECK-NEXT:    ret i32 [[A2]]
;
  %cmp = icmp sge i32 %x, 0
  br i1 %cmp, label %true, label %false

true:
  %a1 = call i32 @llvm.abs.i32(i32 %x, i1 false)
  ret i32 %a1

false:
  %a2 = call i32 @llvm.abs.i32(i32 %x, i1 false)
  ret i32 %a2
}

define i32 @abs_dom_cond_poison(i32 %x) {
; CHECK-LABEL: @abs_dom_cond_poison(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[TRUE:%.*]], label [[FALSE:%.*]]
; CHECK:       true:
; CHECK-NEXT:    ret i32 [[X]]
; CHECK:       false:
; CHECK-NEXT:    [[A2:%.*]] = sub nsw i32 0, [[X]]
; CHECK-NEXT:    ret i32 [[A2]]
;
  %cmp = icmp sge i32 %x, 0
  br i1 %cmp, label %true, label %false

true:
  %a1 = call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %a1

false:
  %a2 = call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %a2
}

; Abs argument non-neg based on known bits.

define i32 @zext_abs(i31 %x) {
; CHECK-LABEL: @zext_abs(
; CHECK-NEXT:    [[ZEXT:%.*]] = zext i31 [[X:%.*]] to i32
; CHECK-NEXT:    ret i32 [[ZEXT]]
;
  %zext = zext i31 %x to i32
  %abs = call i32 @llvm.abs.i32(i32 %zext, i1 false)
  ret i32 %abs
}

define <3 x i82> @lshr_abs(<3 x i82> %x) {
; CHECK-LABEL: @lshr_abs(
; CHECK-NEXT:    [[LSHR:%.*]] = lshr <3 x i82> [[X:%.*]], <i82 1, i82 1, i82 1>
; CHECK-NEXT:    ret <3 x i82> [[LSHR]]
;
  %lshr = lshr <3 x i82> %x, <i82 1, i82 1, i82 1>
  %abs = call <3 x i82> @llvm.abs.v3i82(<3 x i82> %lshr, i1 true)
  ret <3 x i82> %abs
}

define i32 @and_abs(i32 %x) {
; CHECK-LABEL: @and_abs(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 2147483644
; CHECK-NEXT:    ret i32 [[AND]]
;
  %and = and i32 %x, 2147483644
  %abs = call i32 @llvm.abs.i32(i32 %and, i1 true)
  ret i32 %abs
}

define <3 x i82> @select_abs(<3 x i1> %cond) {
; CHECK-LABEL: @select_abs(
; CHECK-NEXT:    [[SEL:%.*]] = select <3 x i1> [[COND:%.*]], <3 x i82> zeroinitializer, <3 x i82> <i82 2147483647, i82 42, i82 1>
; CHECK-NEXT:    ret <3 x i82> [[SEL]]
;
  %sel = select <3 x i1> %cond, <3 x i82> zeroinitializer, <3 x i82> <i82 2147483647, i82 42, i82 1>
  %abs = call <3 x i82> @llvm.abs.v3i82(<3 x i82> %sel, i1 false)
  ret <3 x i82> %abs
}

define i32 @assume_abs(i32 %x) {
; CHECK-LABEL: @assume_abs(
; CHECK-NEXT:    [[ASSUME:%.*]] = icmp sgt i32 [[X:%.*]], -1
; CHECK-NEXT:    call void @llvm.assume(i1 [[ASSUME]])
; CHECK-NEXT:    ret i32 [[X]]
;
  %assume = icmp sge i32 %x, 0
  call void @llvm.assume(i1 %assume)
  %abs = call i32 @llvm.abs.i32(i32 %x, i1 true)
  ret i32 %abs
}

; Abs argument negative based on known bits.

define i32 @abs_assume_neg(i32 %x) {
; CHECK-LABEL: @abs_assume_neg(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[X:%.*]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[ABS:%.*]] = sub i32 0, [[X]]
; CHECK-NEXT:    ret i32 [[ABS]]
;
  %cmp = icmp slt i32 %x, 0
  call void @llvm.assume(i1 %cmp)
  %abs = call i32 @llvm.abs.i32(i32 %x, i1 false)
  ret i32 %abs
}

define i32 @abs_known_neg(i16 %x) {
; CHECK-LABEL: @abs_known_neg(
; CHECK-NEXT:    [[EXT:%.*]] = zext i16 [[X:%.*]] to i32
; CHECK-NEXT:    [[NEG_NEG:%.*]] = add nuw nsw i32 [[EXT]], 1
; CHECK-NEXT:    ret i32 [[NEG_NEG]]
;
  %ext = zext i16 %x to i32
  %neg = sub nsw i32 -1, %ext
  %abs = call i32 @llvm.abs.i32(i32 %neg, i1 false)
  ret i32 %abs
}

define i1 @abs_eq_int_min_poison(i8 %x) {
; CHECK-LABEL: @abs_eq_int_min_poison(
; CHECK-NEXT:    ret i1 false
;
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 true)
  %cmp = icmp eq i8 %abs, -128
  ret i1 %cmp
}

define i1 @abs_ne_int_min_poison(i8 %x) {
; CHECK-LABEL: @abs_ne_int_min_poison(
; CHECK-NEXT:    ret i1 true
;
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 true)
  %cmp = icmp ne i8 %abs, -128
  ret i1 %cmp
}

define i1 @abs_eq_int_min_nopoison(i8 %x) {
; CHECK-LABEL: @abs_eq_int_min_nopoison(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], -128
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 false)
  %cmp = icmp eq i8 %abs, -128
  ret i1 %cmp
}

define i1 @abs_ne_int_min_nopoison(i8 %x) {
; CHECK-LABEL: @abs_ne_int_min_nopoison(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X:%.*]], -128
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %abs = call i8 @llvm.abs.i8(i8 %x, i1 false)
  %cmp = icmp ne i8 %abs, -128
  ret i1 %cmp
}

define i32 @abs_sext(i8 %x) {
; CHECK-LABEL: @abs_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.abs.i8(i8 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[A:%.*]] = zext i8 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[A]]
;
  %s = sext i8 %x to i32
  %a = call i32 @llvm.abs.i32(i32 %s, i1 0)
  ret i32 %a
}

define <3 x i82> @abs_nsw_sext(<3 x i7> %x) {
; CHECK-LABEL: @abs_nsw_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = call <3 x i7> @llvm.abs.v3i7(<3 x i7> [[X:%.*]], i1 false)
; CHECK-NEXT:    [[A:%.*]] = zext <3 x i7> [[TMP1]] to <3 x i82>
; CHECK-NEXT:    ret <3 x i82> [[A]]
;
  %s = sext <3 x i7> %x to <3 x i82>
  %a = call <3 x i82> @llvm.abs.v3i82(<3 x i82> %s, i1 1)
  ret <3 x i82> %a
}

define i32 @abs_sext_extra_use(i8 %x, ptr %p) {
; CHECK-LABEL: @abs_sext_extra_use(
; CHECK-NEXT:    [[S:%.*]] = sext i8 [[X:%.*]] to i32
; CHECK-NEXT:    store i32 [[S]], ptr [[P:%.*]], align 4
; CHECK-NEXT:    [[A:%.*]] = call i32 @llvm.abs.i32(i32 [[S]], i1 false)
; CHECK-NEXT:    ret i32 [[A]]
;
  %s = sext i8 %x to i32
  store i32 %s, ptr %p
  %a = call i32 @llvm.abs.i32(i32 %s, i1 0)
  ret i32 %a
}

; PR48816

define i8 @trunc_abs_sext(i8 %x) {
; CHECK-LABEL: @trunc_abs_sext(
; CHECK-NEXT:    [[TMP1:%.*]] = call i8 @llvm.abs.i8(i8 [[X:%.*]], i1 false)
; CHECK-NEXT:    ret i8 [[TMP1]]
;
  %s = sext i8 %x to i32
  %a = tail call i32 @llvm.abs.i32(i32 %s, i1 true)
  %t = trunc i32 %a to i8
  ret i8 %t
}

define <4 x i8> @trunc_abs_sext_vec(<4 x i8> %x) {
; CHECK-LABEL: @trunc_abs_sext_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i8> @llvm.abs.v4i8(<4 x i8> [[X:%.*]], i1 false)
; CHECK-NEXT:    ret <4 x i8> [[TMP1]]
;
  %s = sext <4 x i8> %x to <4 x i32>
  %a = tail call <4 x i32> @llvm.abs.v4i32(<4 x i32> %s, i1 true)
  %t = trunc <4 x i32> %a to <4 x i8>
  ret <4 x i8> %t
}

; abs() doesn't change the low bit.

define i32 @demand_low_bit(i32 %x) {
; CHECK-LABEL: @demand_low_bit(
; CHECK-NEXT:    [[R:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = call i32 @llvm.abs.i32(i32 %x, i1 false)
  %r = and i32 %a, 1
  ret i32 %r
}

; Int min behavior doesn't affect the transform.

define <3 x i82> @demand_low_bit_int_min_is_poison(<3 x i82> %x) {
; CHECK-LABEL: @demand_low_bit_int_min_is_poison(
; CHECK-NEXT:    [[R:%.*]] = shl <3 x i82> [[X:%.*]], <i82 81, i82 81, i82 81>
; CHECK-NEXT:    ret <3 x i82> [[R]]
;
  %a = call <3 x i82> @llvm.abs.v3i82(<3 x i82> %x, i1 true)
  %r = shl <3 x i82> %a, <i82 81, i82 81, i82 81>
  ret <3 x i82> %r
}

; Negative test - only low bit is allowed.

define i32 @demand_low_bits(i32 %x) {
; CHECK-LABEL: @demand_low_bits(
; CHECK-NEXT:    [[A:%.*]] = call i32 @llvm.abs.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[R:%.*]] = and i32 [[A]], 3
; CHECK-NEXT:    ret i32 [[R]]
;
  %a = call i32 @llvm.abs.i32(i32 %x, i1 false)
  %r = and i32 %a, 3
  ret i32 %r
}

define i32 @srem_by_2_int_min_is_poison(i32 %x) {
; CHECK-LABEL: @srem_by_2_int_min_is_poison(
; CHECK-NEXT:    [[R:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = srem i32 %x, 2
  %r = call i32 @llvm.abs.i32(i32 %s, i1 true)
  ret i32 %r
}

define <3 x i82> @srem_by_2(<3 x i82> %x, ptr %p) {
; CHECK-LABEL: @srem_by_2(
; CHECK-NEXT:    [[S:%.*]] = srem <3 x i82> [[X:%.*]], <i82 2, i82 2, i82 2>
; CHECK-NEXT:    store <3 x i82> [[S]], ptr [[P:%.*]], align 32
; CHECK-NEXT:    [[R:%.*]] = and <3 x i82> [[X]], <i82 1, i82 1, i82 1>
; CHECK-NEXT:    ret <3 x i82> [[R]]
;
  %s = srem <3 x i82> %x, <i82 2, i82 2, i82 2>
  store <3 x i82> %s, ptr %p
  %r = call <3 x i82> @llvm.abs.v3i82(<3 x i82> %s, i1 false)
  ret <3 x i82> %r
}

; TODO: A more general transform could sink the srem and turn it into urem.

define i32 @srem_by_3(i32 %x) {
; CHECK-LABEL: @srem_by_3(
; CHECK-NEXT:    [[S:%.*]] = srem i32 [[X:%.*]], 3
; CHECK-NEXT:    [[R:%.*]] = call i32 @llvm.abs.i32(i32 [[S]], i1 true)
; CHECK-NEXT:    ret i32 [[R]]
;
  %s = srem i32 %x, 3
  %r = call i32 @llvm.abs.i32(i32 %s, i1 true)
  ret i32 %r
}

; Test from https://github.com/llvm/llvm-project/issues/54132.
define i32 @sub_abs_gt(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_abs_gt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[X]], [[Y]]
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[R:%.*]] = phi i32 [ [[SUB]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp sgt i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub nsw i32 %x, %y
  %0 = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  br label %cond.end

cond.end:
  %r = phi i32 [ %0, %cond.true ], [ 0, %entry ]
  ret i32 %r
}

define i32 @sub_abs_lt(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_abs_lt(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[SUB_NEG:%.*]] = sub i32 [[Y]], [[X]]
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[R:%.*]] = phi i32 [ [[SUB_NEG]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp slt i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub nsw i32 %x, %y
  %0 = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  br label %cond.end

cond.end:
  %r = phi i32 [ %0, %cond.true ], [ 0, %entry ]
  ret i32 %r
}

define i32 @sub_abs_lt_min_not_poison(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_abs_lt_min_not_poison(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[SUB_NEG:%.*]] = sub i32 [[Y]], [[X]]
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[R:%.*]] = phi i32 [ [[SUB_NEG]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp slt i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub nsw i32 %x, %y
  %0 = call i32 @llvm.abs.i32(i32 %sub, i1 false)
  br label %cond.end

cond.end:
  %r = phi i32 [ %0, %cond.true ], [ 0, %entry ]
  ret i32 %r
}

define i32 @sub_abs_wrong_pred(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_abs_wrong_pred(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ugt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[SUB:%.*]] = sub nsw i32 [[X]], [[Y]]
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.abs.i32(i32 [[SUB]], i1 true)
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[R:%.*]] = phi i32 [ [[TMP0]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp ugt i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub nsw i32 %x, %y
  %0 = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  br label %cond.end

cond.end:
  %r = phi i32 [ %0, %cond.true ], [ 0, %entry ]
  ret i32 %r
}

define i32 @sub_abs_no_nsw(i32 %x, i32 %y) {
; CHECK-LABEL: @sub_abs_no_nsw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_END:%.*]]
; CHECK:       cond.true:
; CHECK-NEXT:    [[SUB:%.*]] = sub i32 [[X]], [[Y]]
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.abs.i32(i32 [[SUB]], i1 true)
; CHECK-NEXT:    br label [[COND_END]]
; CHECK:       cond.end:
; CHECK-NEXT:    [[R:%.*]] = phi i32 [ [[TMP0]], [[COND_TRUE]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[R]]
;
entry:
  %cmp = icmp sgt i32 %x, %y
  br i1 %cmp, label %cond.true, label %cond.end

cond.true:
  %sub = sub i32 %x, %y
  %0 = call i32 @llvm.abs.i32(i32 %sub, i1 true)
  br label %cond.end

cond.end:
  %r = phi i32 [ %0, %cond.true ], [ 0, %entry ]
  ret i32 %r
}
