'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAllocDeviceInfo __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocDeviceInfo \- Obtain an XkbDeviceInfoRec structure
.SH SYNOPSIS
.HP
.B XkbDeviceInfoPtr XkbAllocDeviceInfo
.BI "(\^unsigned int " "device_spec" "\^,"
.BI "unsigned int " "n_buttons" "\^,"
.BI "unsigned int " "sz_leds" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I device_spec
device ID with which structure will be used
.TP
.I n_buttons
number of button actions to allocate space for
.TP
.I sz_leds
number of LED feedbacks to allocate space for
.SH DESCRIPTION
.LP
.I XkbAllocDeviceInfo
allocates space for an XkbDeviceInfoRec structure and initializes that structure's
.I device_spec
field with the device ID specified by
.I device_spec.
If
.I n_buttons
is nonzero,
.I n_buttons
XkbActions are linked into the XkbDeviceInfoRec structure and initialized to zero. If
.I sz_leds
is nonzero,
.I sz_leds
XkbDeviceLedInfoRec structures are also allocated and linked into the XkbDeviceInfoRec structure. If
you request XkbDeviceLedInfoRec structures be allocated using this request, you must initialize them
explicitly, by using
.BR XkbAddDeviceLedInfo (__libmansuffix__).
.SH STRUCTURES
.LP
Information about X Input Extension devices is transferred between a client program and the Xkb
extension in an XkbDeviceInfoRec structure:
.nf

    typedef struct {
        char *               name;          /\&* name for device */
        Atom                 type;          /\&* name for class of devices */
        unsigned short       device_spec;   /\&* device of interest */
        Bool                 has_own_state; /\&* True=>this device has its own state */
        unsigned short       supported;     /\&* bits indicating supported capabilities */
        unsigned short       unsupported;   /\&* bits indicating unsupported capabilities */
        unsigned short       num_btns;      /\&* number of entries in btn_acts */
        XkbAction *          btn_acts;      /\&* button actions */
        unsigned short       sz_leds;       /\&* total number of entries in LEDs vector */
        unsigned short       num_leds;      /\&* number of valid entries in LEDs vector */
        unsigned short       dflt_kbd_fb;   /\&* input extension ID of default (core kbd) indicator */
        unsigned short       dflt_led_fb;   /\&* input extension ID of default indicator feedback */
        XkbDeviceLedInfoPtr  leds;          /\&* LED descriptions */
    } XkbDeviceInfoRec, *XkbDeviceInfoPtr;


    typedef struct {
        unsigned short      led_class;        /\&* class for this LED device*/
        unsigned short      led_id;           /\&* ID for this LED device */
        unsigned int        phys_indicators;  /\&* bits for which LEDs physically present */
        unsigned int        maps_present;     /\&* bits for which LEDs have maps in maps */
        unsigned int        names_present;    /\&* bits for which LEDs are in names */
        unsigned int        state;            /\&* 1 bit => corresponding LED is on */
        Atom                names[XkbNumIndicators];   /\&* names for LEDs */
        XkbIndicatorMapRec  maps;             /\&* indicator maps for each LED */
    } XkbDeviceLedInfoRec, *XkbDeviceLedInfoPtr;
.fi
.SH "SEE ALSO"
.BR XkbAddDeviceLedInfo (__libmansuffix__)
