// Copyright (c) 2021 Jamie Kyle.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-object.hasown
description: Properties - [[HasOwnProperty]] (literal inherited getter property)
author: Jamie Kyle
features: [Object.hasOwn]
---*/

var base = {
  get foo() {
    return 42;
  }
};
var o = Object.create(base);

assert.sameValue(Object.hasOwn(o, "foo"), false, 'Object.hasOwn(o, "foo")');

reportCompare(0, 0);
