#!/bin/sh
# file: scripts/fresh.sh

# ====================================================================
# symbols;
# --------------------------------------------------------------------

. ${SCRIPTS}/hardware.sh
. ${SCRIPTS}/firmware.sh

# ====================================================================
# confirm connection;
# --------------------------------------------------------------------

echo -n "Interface [${ETH}]: "; read  
if [ ! -z ${REPLY} ]; then
	ETH=${REPLY}
fi

# ====================================================================
# check connection;
# --------------------------------------------------------------------

int6kwait -xqsi ${ETH}
if [ ${?} != 0 ]; then
	echo "Device is not connected"
	exit 1
fi

# ====================================================================
# fetch device identity;
# --------------------------------------------------------------------

MAC=$(int6kid -i ${ETH} -A)
DAK=$(int6kid -i ${ETH} -D)
NMK=$(int6kid -i ${ETH} -M)

# ====================================================================
# confirm address;     
# --------------------------------------------------------------------

# echo -n "MAC Address [${MAC}]: "; read
# if [ ! -z ${REPLY} ]; then
# 	MAC="${REPLY}"                  
# fi

# ====================================================================
# edit PIB;  
# --------------------------------------------------------------------

modpib -M ${MAC} -D ${DAK} -N ${NMK} ${PIB}
if [ ${?} != 0 ]; then
	exit 1
fi

# ====================================================================
# erase NVRAM;        
# --------------------------------------------------------------------

int6kp -xi ${ETH} -D ${DAK} -X
if [ ${?} != 0 ]; then
	exit 1
fi

# ====================================================================
# start firmware; 
# --------------------------------------------------------------------

int6kf -xi ${ETH} -C ${CFG} -P ${PIB} -N ${NVM} 
if [ ${?} != 0 ]; then
	exit 1
fi

# ====================================================================
# define final firmware;
# --------------------------------------------------------------------

PIB=${FIRMWARE}/v3.3.0.pib
NVM=${FIRMWARE}/v3.3.0-0-5-B-FINAL.nvm

# ====================================================================
# download firmware then force flash device; 
# --------------------------------------------------------------------

int6k -xi ${ETH} -P ${PIB} -N ${NVM}  -FF
if [ ${?} != 0 ]; then
	exit 1
fi

# ====================================================================
# return success;
# --------------------------------------------------------------------

exit 0

