/*=========================================================================

  Program:   OpenIGTLLink Library -- Dummy position data
  Module:    $RCSfile: $
  Language:  C
  Date:      $Date: $
  Version:   $Revision: $

  Copyright (c) Insight Software Consortium. All rights reserved.

  This software is distributed WITHOUT ANY WARRANTY; without even
  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

#ifndef __IGTL_TEST_DATA_POSITION_FORMAT2_H
#define __IGTL_TEST_DATA_POSITION_FORMAT2_H

unsigned char test_position_messageFormat2[] = {

  /*-------- OpenIGTLink message header -------*/
  0x00, 0x02,                                     /* Version number */
  0x50, 0x4f, 0x53, 0x49, 0x54, 0x49, 0x4f, 0x4e,
  0x00, 0x00, 0x00, 0x00,                         /* POSITION */ 
  0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
  0x6d, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00,                         /* Device name */
  0x00, 0x00, 0x00, 0x00, 0x49, 0x96, 0x02, 0xd4, /* Time stamp */
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x61, /* Body size */
  0xc7, 0x11, 0x16, 0x42, 0x76, 0x81, 0xc1, 0xe2, /* CRC */
  
  /* Extended header
   0                 2                      4               8           12
   +-----------------+----------------------+---------------+-------------+
   | EXT_HEADER_SIZE | METADATA_HEADER_SIZE | METADATA_SIZE | MESSAGE_ID  |
   +-----------------+----------------------+---------------+-------------+*/
  0x00, 0x0c, 0x00, 0x12, 0x00, 0x00, 0x00, 0x27,
  0x00, 0x00, 0x00, 0x01,

  /*-------- POSITION message body -------*/
  
  0x42, 0x38, 0x36, 0x60, 0x41, 0x9b, 0xc4, 0x67, /* px, py */
  0x42, 0x38, 0x36, 0x60, 0x00, 0x00, 0x00, 0x00, /* pz, ox */
  0x3f, 0x13, 0xcd, 0x3a, 0x3f, 0x13, 0xcd, 0x3a, /* oy, oz */
  0x3e, 0xaa, 0xaa, 0xab,                         /* ow     */
  
  /*---------- TRAJECTORY Meta data body ------------*/
  0x00, 0x02,                                     /* Index Count */
  0x00, 0x11, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, /* first element Key size(2 Bytes), value coding(2 Bytes), value size(4 Bytes)*/
  0x00, 0x12, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02, /* second element Key size, value coding, value size*/
  
  0x46, 0x69, 0x72, 0x73, 0x74, 0x20, 0x70, 0x61, /* First Patient Age 22*/
  0x74, 0x69, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x67,
  0x65, 0x32,
  0x32, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, /* Second Patient Age 25*/
  0x70, 0x61, 0x74, 0x69, 0x65, 0x6e, 0x74, 0x20,
  0x61, 0x67, 0x65, 0x32, 0x35

};

#endif /* IGTL_TEST_DATA_POSITION_FORMAT2_H */



