// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SMULBB_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SMULBB_A32_H_

const byte kInstruction_smulbb_hi_r1_r9_r5[] = {
  0x89, 0x05, 0x61, 0x81 // smulbb hi r1 r9 r5
};
const byte kInstruction_smulbb_pl_r8_r6_r2[] = {
  0x86, 0x02, 0x68, 0x51 // smulbb pl r8 r6 r2
};
const byte kInstruction_smulbb_hi_r5_r8_r2[] = {
  0x88, 0x02, 0x65, 0x81 // smulbb hi r5 r8 r2
};
const byte kInstruction_smulbb_vc_r9_r2_r7[] = {
  0x82, 0x07, 0x69, 0x71 // smulbb vc r9 r2 r7
};
const byte kInstruction_smulbb_lt_r4_r6_r3[] = {
  0x86, 0x03, 0x64, 0xb1 // smulbb lt r4 r6 r3
};
const byte kInstruction_smulbb_le_r11_r6_r2[] = {
  0x86, 0x02, 0x6b, 0xd1 // smulbb le r11 r6 r2
};
const byte kInstruction_smulbb_cc_r8_r14_r4[] = {
  0x8e, 0x04, 0x68, 0x31 // smulbb cc r8 r14 r4
};
const byte kInstruction_smulbb_le_r5_r14_r6[] = {
  0x8e, 0x06, 0x65, 0xd1 // smulbb le r5 r14 r6
};
const byte kInstruction_smulbb_lt_r6_r1_r0[] = {
  0x81, 0x00, 0x66, 0xb1 // smulbb lt r6 r1 r0
};
const byte kInstruction_smulbb_lt_r5_r0_r9[] = {
  0x80, 0x09, 0x65, 0xb1 // smulbb lt r5 r0 r9
};
const byte kInstruction_smulbb_le_r8_r12_r7[] = {
  0x8c, 0x07, 0x68, 0xd1 // smulbb le r8 r12 r7
};
const byte kInstruction_smulbb_eq_r7_r14_r6[] = {
  0x8e, 0x06, 0x67, 0x01 // smulbb eq r7 r14 r6
};
const byte kInstruction_smulbb_cs_r7_r4_r6[] = {
  0x84, 0x06, 0x67, 0x21 // smulbb cs r7 r4 r6
};
const byte kInstruction_smulbb_gt_r9_r6_r9[] = {
  0x86, 0x09, 0x69, 0xc1 // smulbb gt r9 r6 r9
};
const byte kInstruction_smulbb_ne_r13_r9_r1[] = {
  0x89, 0x01, 0x6d, 0x11 // smulbb ne r13 r9 r1
};
const byte kInstruction_smulbb_ge_r13_r1_r13[] = {
  0x81, 0x0d, 0x6d, 0xa1 // smulbb ge r13 r1 r13
};
const byte kInstruction_smulbb_ls_r8_r10_r2[] = {
  0x8a, 0x02, 0x68, 0x91 // smulbb ls r8 r10 r2
};
const byte kInstruction_smulbb_hi_r0_r13_r5[] = {
  0x8d, 0x05, 0x60, 0x81 // smulbb hi r0 r13 r5
};
const byte kInstruction_smulbb_pl_r13_r7_r8[] = {
  0x87, 0x08, 0x6d, 0x51 // smulbb pl r13 r7 r8
};
const byte kInstruction_smulbb_ge_r4_r13_r11[] = {
  0x8d, 0x0b, 0x64, 0xa1 // smulbb ge r4 r13 r11
};
const byte kInstruction_smulbb_cs_r5_r10_r5[] = {
  0x8a, 0x05, 0x65, 0x21 // smulbb cs r5 r10 r5
};
const byte kInstruction_smulbb_cs_r5_r4_r3[] = {
  0x84, 0x03, 0x65, 0x21 // smulbb cs r5 r4 r3
};
const byte kInstruction_smulbb_ls_r6_r14_r8[] = {
  0x8e, 0x08, 0x66, 0x91 // smulbb ls r6 r14 r8
};
const byte kInstruction_smulbb_vs_r3_r8_r6[] = {
  0x88, 0x06, 0x63, 0x61 // smulbb vs r3 r8 r6
};
const byte kInstruction_smulbb_vc_r7_r12_r3[] = {
  0x8c, 0x03, 0x67, 0x71 // smulbb vc r7 r12 r3
};
const byte kInstruction_smulbb_ge_r1_r4_r1[] = {
  0x84, 0x01, 0x61, 0xa1 // smulbb ge r1 r4 r1
};
const byte kInstruction_smulbb_cc_r4_r7_r10[] = {
  0x87, 0x0a, 0x64, 0x31 // smulbb cc r4 r7 r10
};
const byte kInstruction_smulbb_cc_r2_r0_r13[] = {
  0x80, 0x0d, 0x62, 0x31 // smulbb cc r2 r0 r13
};
const byte kInstruction_smulbb_vs_r9_r6_r8[] = {
  0x86, 0x08, 0x69, 0x61 // smulbb vs r9 r6 r8
};
const byte kInstruction_smulbb_cs_r14_r11_r13[] = {
  0x8b, 0x0d, 0x6e, 0x21 // smulbb cs r14 r11 r13
};
const byte kInstruction_smulbb_pl_r5_r8_r4[] = {
  0x88, 0x04, 0x65, 0x51 // smulbb pl r5 r8 r4
};
const byte kInstruction_smulbb_pl_r2_r3_r7[] = {
  0x83, 0x07, 0x62, 0x51 // smulbb pl r2 r3 r7
};
const byte kInstruction_smulbb_cs_r7_r12_r14[] = {
  0x8c, 0x0e, 0x67, 0x21 // smulbb cs r7 r12 r14
};
const byte kInstruction_smulbb_hi_r6_r6_r1[] = {
  0x86, 0x01, 0x66, 0x81 // smulbb hi r6 r6 r1
};
const byte kInstruction_smulbb_cc_r6_r9_r6[] = {
  0x89, 0x06, 0x66, 0x31 // smulbb cc r6 r9 r6
};
const byte kInstruction_smulbb_ne_r12_r12_r0[] = {
  0x8c, 0x00, 0x6c, 0x11 // smulbb ne r12 r12 r0
};
const byte kInstruction_smulbb_cc_r9_r3_r8[] = {
  0x83, 0x08, 0x69, 0x31 // smulbb cc r9 r3 r8
};
const byte kInstruction_smulbb_mi_r13_r6_r1[] = {
  0x86, 0x01, 0x6d, 0x41 // smulbb mi r13 r6 r1
};
const byte kInstruction_smulbb_lt_r4_r8_r6[] = {
  0x88, 0x06, 0x64, 0xb1 // smulbb lt r4 r8 r6
};
const byte kInstruction_smulbb_hi_r11_r5_r9[] = {
  0x85, 0x09, 0x6b, 0x81 // smulbb hi r11 r5 r9
};
const byte kInstruction_smulbb_cc_r6_r10_r6[] = {
  0x8a, 0x06, 0x66, 0x31 // smulbb cc r6 r10 r6
};
const byte kInstruction_smulbb_eq_r10_r10_r5[] = {
  0x8a, 0x05, 0x6a, 0x01 // smulbb eq r10 r10 r5
};
const byte kInstruction_smulbb_al_r5_r4_r11[] = {
  0x84, 0x0b, 0x65, 0xe1 // smulbb al r5 r4 r11
};
const byte kInstruction_smulbb_pl_r11_r11_r2[] = {
  0x8b, 0x02, 0x6b, 0x51 // smulbb pl r11 r11 r2
};
const byte kInstruction_smulbb_ls_r6_r14_r12[] = {
  0x8e, 0x0c, 0x66, 0x91 // smulbb ls r6 r14 r12
};
const byte kInstruction_smulbb_vc_r7_r7_r2[] = {
  0x87, 0x02, 0x67, 0x71 // smulbb vc r7 r7 r2
};
const byte kInstruction_smulbb_eq_r10_r8_r4[] = {
  0x88, 0x04, 0x6a, 0x01 // smulbb eq r10 r8 r4
};
const byte kInstruction_smulbb_al_r14_r7_r2[] = {
  0x87, 0x02, 0x6e, 0xe1 // smulbb al r14 r7 r2
};
const byte kInstruction_smulbb_cs_r3_r11_r10[] = {
  0x8b, 0x0a, 0x63, 0x21 // smulbb cs r3 r11 r10
};
const byte kInstruction_smulbb_ls_r11_r4_r0[] = {
  0x84, 0x00, 0x6b, 0x91 // smulbb ls r11 r4 r0
};
const byte kInstruction_smulbb_hi_r11_r8_r9[] = {
  0x88, 0x09, 0x6b, 0x81 // smulbb hi r11 r8 r9
};
const byte kInstruction_smulbb_vs_r2_r14_r13[] = {
  0x8e, 0x0d, 0x62, 0x61 // smulbb vs r2 r14 r13
};
const byte kInstruction_smulbb_al_r1_r13_r9[] = {
  0x8d, 0x09, 0x61, 0xe1 // smulbb al r1 r13 r9
};
const byte kInstruction_smulbb_eq_r3_r9_r13[] = {
  0x89, 0x0d, 0x63, 0x01 // smulbb eq r3 r9 r13
};
const byte kInstruction_smulbb_ge_r10_r3_r13[] = {
  0x83, 0x0d, 0x6a, 0xa1 // smulbb ge r10 r3 r13
};
const byte kInstruction_smulbb_pl_r8_r5_r10[] = {
  0x85, 0x0a, 0x68, 0x51 // smulbb pl r8 r5 r10
};
const byte kInstruction_smulbb_vc_r8_r11_r6[] = {
  0x8b, 0x06, 0x68, 0x71 // smulbb vc r8 r11 r6
};
const byte kInstruction_smulbb_eq_r0_r0_r5[] = {
  0x80, 0x05, 0x60, 0x01 // smulbb eq r0 r0 r5
};
const byte kInstruction_smulbb_ne_r6_r5_r8[] = {
  0x85, 0x08, 0x66, 0x11 // smulbb ne r6 r5 r8
};
const byte kInstruction_smulbb_hi_r5_r13_r3[] = {
  0x8d, 0x03, 0x65, 0x81 // smulbb hi r5 r13 r3
};
const byte kInstruction_smulbb_ne_r11_r14_r14[] = {
  0x8e, 0x0e, 0x6b, 0x11 // smulbb ne r11 r14 r14
};
const byte kInstruction_smulbb_mi_r1_r0_r6[] = {
  0x80, 0x06, 0x61, 0x41 // smulbb mi r1 r0 r6
};
const byte kInstruction_smulbb_le_r14_r8_r2[] = {
  0x88, 0x02, 0x6e, 0xd1 // smulbb le r14 r8 r2
};
const byte kInstruction_smulbb_eq_r9_r6_r5[] = {
  0x86, 0x05, 0x69, 0x01 // smulbb eq r9 r6 r5
};
const byte kInstruction_smulbb_eq_r11_r0_r13[] = {
  0x80, 0x0d, 0x6b, 0x01 // smulbb eq r11 r0 r13
};
const byte kInstruction_smulbb_pl_r4_r5_r14[] = {
  0x85, 0x0e, 0x64, 0x51 // smulbb pl r4 r5 r14
};
const byte kInstruction_smulbb_cs_r13_r5_r13[] = {
  0x85, 0x0d, 0x6d, 0x21 // smulbb cs r13 r5 r13
};
const byte kInstruction_smulbb_mi_r0_r13_r8[] = {
  0x8d, 0x08, 0x60, 0x41 // smulbb mi r0 r13 r8
};
const byte kInstruction_smulbb_lt_r2_r13_r3[] = {
  0x8d, 0x03, 0x62, 0xb1 // smulbb lt r2 r13 r3
};
const byte kInstruction_smulbb_ls_r8_r1_r11[] = {
  0x81, 0x0b, 0x68, 0x91 // smulbb ls r8 r1 r11
};
const byte kInstruction_smulbb_vc_r14_r11_r8[] = {
  0x8b, 0x08, 0x6e, 0x71 // smulbb vc r14 r11 r8
};
const byte kInstruction_smulbb_lt_r4_r13_r12[] = {
  0x8d, 0x0c, 0x64, 0xb1 // smulbb lt r4 r13 r12
};
const byte kInstruction_smulbb_eq_r2_r1_r14[] = {
  0x81, 0x0e, 0x62, 0x01 // smulbb eq r2 r1 r14
};
const byte kInstruction_smulbb_eq_r9_r4_r14[] = {
  0x84, 0x0e, 0x69, 0x01 // smulbb eq r9 r4 r14
};
const byte kInstruction_smulbb_hi_r10_r6_r13[] = {
  0x86, 0x0d, 0x6a, 0x81 // smulbb hi r10 r6 r13
};
const byte kInstruction_smulbb_ge_r12_r9_r4[] = {
  0x89, 0x04, 0x6c, 0xa1 // smulbb ge r12 r9 r4
};
const byte kInstruction_smulbb_le_r9_r11_r14[] = {
  0x8b, 0x0e, 0x69, 0xd1 // smulbb le r9 r11 r14
};
const byte kInstruction_smulbb_ls_r0_r9_r5[] = {
  0x89, 0x05, 0x60, 0x91 // smulbb ls r0 r9 r5
};
const byte kInstruction_smulbb_mi_r2_r3_r8[] = {
  0x83, 0x08, 0x62, 0x41 // smulbb mi r2 r3 r8
};
const byte kInstruction_smulbb_ne_r14_r10_r14[] = {
  0x8a, 0x0e, 0x6e, 0x11 // smulbb ne r14 r10 r14
};
const byte kInstruction_smulbb_eq_r6_r2_r10[] = {
  0x82, 0x0a, 0x66, 0x01 // smulbb eq r6 r2 r10
};
const byte kInstruction_smulbb_lt_r11_r0_r12[] = {
  0x80, 0x0c, 0x6b, 0xb1 // smulbb lt r11 r0 r12
};
const byte kInstruction_smulbb_ne_r1_r12_r10[] = {
  0x8c, 0x0a, 0x61, 0x11 // smulbb ne r1 r12 r10
};
const byte kInstruction_smulbb_cc_r1_r0_r2[] = {
  0x80, 0x02, 0x61, 0x31 // smulbb cc r1 r0 r2
};
const byte kInstruction_smulbb_al_r5_r5_r7[] = {
  0x85, 0x07, 0x65, 0xe1 // smulbb al r5 r5 r7
};
const byte kInstruction_smulbb_hi_r7_r13_r1[] = {
  0x8d, 0x01, 0x67, 0x81 // smulbb hi r7 r13 r1
};
const byte kInstruction_smulbb_cs_r4_r4_r9[] = {
  0x84, 0x09, 0x64, 0x21 // smulbb cs r4 r4 r9
};
const byte kInstruction_smulbb_eq_r14_r4_r14[] = {
  0x84, 0x0e, 0x6e, 0x01 // smulbb eq r14 r4 r14
};
const byte kInstruction_smulbb_vs_r10_r5_r14[] = {
  0x85, 0x0e, 0x6a, 0x61 // smulbb vs r10 r5 r14
};
const byte kInstruction_smulbb_gt_r4_r3_r11[] = {
  0x83, 0x0b, 0x64, 0xc1 // smulbb gt r4 r3 r11
};
const byte kInstruction_smulbb_ne_r14_r10_r12[] = {
  0x8a, 0x0c, 0x6e, 0x11 // smulbb ne r14 r10 r12
};
const byte kInstruction_smulbb_vs_r2_r11_r0[] = {
  0x8b, 0x00, 0x62, 0x61 // smulbb vs r2 r11 r0
};
const byte kInstruction_smulbb_ge_r5_r12_r7[] = {
  0x8c, 0x07, 0x65, 0xa1 // smulbb ge r5 r12 r7
};
const byte kInstruction_smulbb_mi_r7_r14_r6[] = {
  0x8e, 0x06, 0x67, 0x41 // smulbb mi r7 r14 r6
};
const byte kInstruction_smulbb_gt_r8_r3_r8[] = {
  0x83, 0x08, 0x68, 0xc1 // smulbb gt r8 r3 r8
};
const byte kInstruction_smulbb_hi_r9_r14_r3[] = {
  0x8e, 0x03, 0x69, 0x81 // smulbb hi r9 r14 r3
};
const byte kInstruction_smulbb_vc_r2_r11_r2[] = {
  0x8b, 0x02, 0x62, 0x71 // smulbb vc r2 r11 r2
};
const byte kInstruction_smulbb_hi_r11_r7_r12[] = {
  0x87, 0x0c, 0x6b, 0x81 // smulbb hi r11 r7 r12
};
const byte kInstruction_smulbb_cs_r6_r4_r11[] = {
  0x84, 0x0b, 0x66, 0x21 // smulbb cs r6 r4 r11
};
const byte kInstruction_smulbb_cs_r12_r5_r9[] = {
  0x85, 0x09, 0x6c, 0x21 // smulbb cs r12 r5 r9
};
const byte kInstruction_smulbb_ls_r5_r10_r5[] = {
  0x8a, 0x05, 0x65, 0x91 // smulbb ls r5 r10 r5
};
const byte kInstruction_smulbb_ls_r0_r9_r13[] = {
  0x89, 0x0d, 0x60, 0x91 // smulbb ls r0 r9 r13
};
const byte kInstruction_smulbb_lt_r3_r3_r5[] = {
  0x83, 0x05, 0x63, 0xb1 // smulbb lt r3 r3 r5
};
const byte kInstruction_smulbb_mi_r0_r12_r8[] = {
  0x8c, 0x08, 0x60, 0x41 // smulbb mi r0 r12 r8
};
const byte kInstruction_smulbb_pl_r3_r12_r12[] = {
  0x8c, 0x0c, 0x63, 0x51 // smulbb pl r3 r12 r12
};
const byte kInstruction_smulbb_eq_r8_r12_r5[] = {
  0x8c, 0x05, 0x68, 0x01 // smulbb eq r8 r12 r5
};
const byte kInstruction_smulbb_cc_r7_r8_r1[] = {
  0x88, 0x01, 0x67, 0x31 // smulbb cc r7 r8 r1
};
const byte kInstruction_smulbb_hi_r2_r13_r10[] = {
  0x8d, 0x0a, 0x62, 0x81 // smulbb hi r2 r13 r10
};
const byte kInstruction_smulbb_al_r7_r10_r10[] = {
  0x8a, 0x0a, 0x67, 0xe1 // smulbb al r7 r10 r10
};
const byte kInstruction_smulbb_vc_r1_r12_r2[] = {
  0x8c, 0x02, 0x61, 0x71 // smulbb vc r1 r12 r2
};
const byte kInstruction_smulbb_cc_r8_r5_r8[] = {
  0x85, 0x08, 0x68, 0x31 // smulbb cc r8 r5 r8
};
const byte kInstruction_smulbb_ls_r3_r7_r9[] = {
  0x87, 0x09, 0x63, 0x91 // smulbb ls r3 r7 r9
};
const byte kInstruction_smulbb_al_r8_r10_r8[] = {
  0x8a, 0x08, 0x68, 0xe1 // smulbb al r8 r10 r8
};
const byte kInstruction_smulbb_lt_r4_r12_r10[] = {
  0x8c, 0x0a, 0x64, 0xb1 // smulbb lt r4 r12 r10
};
const byte kInstruction_smulbb_ge_r10_r5_r11[] = {
  0x85, 0x0b, 0x6a, 0xa1 // smulbb ge r10 r5 r11
};
const byte kInstruction_smulbb_ls_r3_r14_r4[] = {
  0x8e, 0x04, 0x63, 0x91 // smulbb ls r3 r14 r4
};
const byte kInstruction_smulbb_hi_r3_r6_r12[] = {
  0x86, 0x0c, 0x63, 0x81 // smulbb hi r3 r6 r12
};
const byte kInstruction_smulbb_hi_r6_r0_r4[] = {
  0x80, 0x04, 0x66, 0x81 // smulbb hi r6 r0 r4
};
const byte kInstruction_smulbb_al_r11_r6_r0[] = {
  0x86, 0x00, 0x6b, 0xe1 // smulbb al r11 r6 r0
};
const byte kInstruction_smulbb_mi_r3_r1_r9[] = {
  0x81, 0x09, 0x63, 0x41 // smulbb mi r3 r1 r9
};
const byte kInstruction_smulbb_mi_r12_r13_r0[] = {
  0x8d, 0x00, 0x6c, 0x41 // smulbb mi r12 r13 r0
};
const byte kInstruction_smulbb_le_r1_r2_r5[] = {
  0x82, 0x05, 0x61, 0xd1 // smulbb le r1 r2 r5
};
const byte kInstruction_smulbb_hi_r4_r3_r14[] = {
  0x83, 0x0e, 0x64, 0x81 // smulbb hi r4 r3 r14
};
const byte kInstruction_smulbb_eq_r6_r11_r11[] = {
  0x8b, 0x0b, 0x66, 0x01 // smulbb eq r6 r11 r11
};
const byte kInstruction_smulbb_cc_r14_r11_r14[] = {
  0x8b, 0x0e, 0x6e, 0x31 // smulbb cc r14 r11 r14
};
const byte kInstruction_smulbb_hi_r4_r10_r0[] = {
  0x8a, 0x00, 0x64, 0x81 // smulbb hi r4 r10 r0
};
const byte kInstruction_smulbb_cc_r7_r11_r1[] = {
  0x8b, 0x01, 0x67, 0x31 // smulbb cc r7 r11 r1
};
const byte kInstruction_smulbb_mi_r14_r6_r10[] = {
  0x86, 0x0a, 0x6e, 0x41 // smulbb mi r14 r6 r10
};
const byte kInstruction_smulbb_eq_r2_r0_r11[] = {
  0x80, 0x0b, 0x62, 0x01 // smulbb eq r2 r0 r11
};
const byte kInstruction_smulbb_mi_r13_r5_r12[] = {
  0x85, 0x0c, 0x6d, 0x41 // smulbb mi r13 r5 r12
};
const byte kInstruction_smulbb_eq_r2_r12_r5[] = {
  0x8c, 0x05, 0x62, 0x01 // smulbb eq r2 r12 r5
};
const byte kInstruction_smulbb_le_r12_r0_r2[] = {
  0x80, 0x02, 0x6c, 0xd1 // smulbb le r12 r0 r2
};
const byte kInstruction_smulbb_vc_r10_r10_r9[] = {
  0x8a, 0x09, 0x6a, 0x71 // smulbb vc r10 r10 r9
};
const byte kInstruction_smulbb_ls_r11_r11_r8[] = {
  0x8b, 0x08, 0x6b, 0x91 // smulbb ls r11 r11 r8
};
const byte kInstruction_smulbb_hi_r10_r11_r9[] = {
  0x8b, 0x09, 0x6a, 0x81 // smulbb hi r10 r11 r9
};
const byte kInstruction_smulbb_vs_r7_r12_r14[] = {
  0x8c, 0x0e, 0x67, 0x61 // smulbb vs r7 r12 r14
};
const byte kInstruction_smulbb_gt_r11_r14_r12[] = {
  0x8e, 0x0c, 0x6b, 0xc1 // smulbb gt r11 r14 r12
};
const byte kInstruction_smulbb_vs_r0_r12_r8[] = {
  0x8c, 0x08, 0x60, 0x61 // smulbb vs r0 r12 r8
};
const byte kInstruction_smulbb_al_r0_r5_r7[] = {
  0x85, 0x07, 0x60, 0xe1 // smulbb al r0 r5 r7
};
const byte kInstruction_smulbb_hi_r5_r13_r8[] = {
  0x8d, 0x08, 0x65, 0x81 // smulbb hi r5 r13 r8
};
const byte kInstruction_smulbb_le_r9_r9_r7[] = {
  0x89, 0x07, 0x69, 0xd1 // smulbb le r9 r9 r7
};
const byte kInstruction_smulbb_cc_r4_r9_r5[] = {
  0x89, 0x05, 0x64, 0x31 // smulbb cc r4 r9 r5
};
const byte kInstruction_smulbb_vs_r8_r1_r3[] = {
  0x81, 0x03, 0x68, 0x61 // smulbb vs r8 r1 r3
};
const byte kInstruction_smulbb_cc_r0_r10_r12[] = {
  0x8a, 0x0c, 0x60, 0x31 // smulbb cc r0 r10 r12
};
const byte kInstruction_smulbb_eq_r7_r14_r0[] = {
  0x8e, 0x00, 0x67, 0x01 // smulbb eq r7 r14 r0
};
const byte kInstruction_smulbb_vs_r12_r9_r11[] = {
  0x89, 0x0b, 0x6c, 0x61 // smulbb vs r12 r9 r11
};
const byte kInstruction_smulbb_gt_r5_r9_r11[] = {
  0x89, 0x0b, 0x65, 0xc1 // smulbb gt r5 r9 r11
};
const byte kInstruction_smulbb_cs_r14_r13_r7[] = {
  0x8d, 0x07, 0x6e, 0x21 // smulbb cs r14 r13 r7
};
const byte kInstruction_smulbb_mi_r11_r3_r10[] = {
  0x83, 0x0a, 0x6b, 0x41 // smulbb mi r11 r3 r10
};
const byte kInstruction_smulbb_hi_r11_r8_r12[] = {
  0x88, 0x0c, 0x6b, 0x81 // smulbb hi r11 r8 r12
};
const byte kInstruction_smulbb_cs_r3_r8_r13[] = {
  0x88, 0x0d, 0x63, 0x21 // smulbb cs r3 r8 r13
};
const byte kInstruction_smulbb_pl_r10_r12_r6[] = {
  0x8c, 0x06, 0x6a, 0x51 // smulbb pl r10 r12 r6
};
const byte kInstruction_smulbb_vc_r7_r3_r2[] = {
  0x83, 0x02, 0x67, 0x71 // smulbb vc r7 r3 r2
};
const byte kInstruction_smulbb_mi_r9_r0_r8[] = {
  0x80, 0x08, 0x69, 0x41 // smulbb mi r9 r0 r8
};
const byte kInstruction_smulbb_eq_r2_r13_r7[] = {
  0x8d, 0x07, 0x62, 0x01 // smulbb eq r2 r13 r7
};
const byte kInstruction_smulbb_ne_r2_r14_r0[] = {
  0x8e, 0x00, 0x62, 0x11 // smulbb ne r2 r14 r0
};
const byte kInstruction_smulbb_vs_r4_r10_r0[] = {
  0x8a, 0x00, 0x64, 0x61 // smulbb vs r4 r10 r0
};
const byte kInstruction_smulbb_ls_r0_r2_r2[] = {
  0x82, 0x02, 0x60, 0x91 // smulbb ls r0 r2 r2
};
const byte kInstruction_smulbb_cc_r1_r6_r0[] = {
  0x86, 0x00, 0x61, 0x31 // smulbb cc r1 r6 r0
};
const byte kInstruction_smulbb_lt_r12_r0_r8[] = {
  0x80, 0x08, 0x6c, 0xb1 // smulbb lt r12 r0 r8
};
const byte kInstruction_smulbb_cc_r9_r3_r14[] = {
  0x83, 0x0e, 0x69, 0x31 // smulbb cc r9 r3 r14
};
const byte kInstruction_smulbb_vs_r7_r9_r1[] = {
  0x89, 0x01, 0x67, 0x61 // smulbb vs r7 r9 r1
};
const byte kInstruction_smulbb_eq_r11_r9_r14[] = {
  0x89, 0x0e, 0x6b, 0x01 // smulbb eq r11 r9 r14
};
const byte kInstruction_smulbb_pl_r6_r10_r4[] = {
  0x8a, 0x04, 0x66, 0x51 // smulbb pl r6 r10 r4
};
const byte kInstruction_smulbb_ne_r8_r5_r6[] = {
  0x85, 0x06, 0x68, 0x11 // smulbb ne r8 r5 r6
};
const byte kInstruction_smulbb_cs_r0_r6_r2[] = {
  0x86, 0x02, 0x60, 0x21 // smulbb cs r0 r6 r2
};
const byte kInstruction_smulbb_eq_r11_r12_r4[] = {
  0x8c, 0x04, 0x6b, 0x01 // smulbb eq r11 r12 r4
};
const byte kInstruction_smulbb_lt_r14_r3_r14[] = {
  0x83, 0x0e, 0x6e, 0xb1 // smulbb lt r14 r3 r14
};
const byte kInstruction_smulbb_le_r7_r12_r14[] = {
  0x8c, 0x0e, 0x67, 0xd1 // smulbb le r7 r12 r14
};
const byte kInstruction_smulbb_hi_r2_r9_r9[] = {
  0x89, 0x09, 0x62, 0x81 // smulbb hi r2 r9 r9
};
const byte kInstruction_smulbb_ne_r8_r1_r0[] = {
  0x81, 0x00, 0x68, 0x11 // smulbb ne r8 r1 r0
};
const byte kInstruction_smulbb_cc_r5_r11_r2[] = {
  0x8b, 0x02, 0x65, 0x31 // smulbb cc r5 r11 r2
};
const byte kInstruction_smulbb_hi_r0_r1_r2[] = {
  0x81, 0x02, 0x60, 0x81 // smulbb hi r0 r1 r2
};
const byte kInstruction_smulbb_al_r4_r9_r4[] = {
  0x89, 0x04, 0x64, 0xe1 // smulbb al r4 r9 r4
};
const byte kInstruction_smulbb_cs_r12_r7_r14[] = {
  0x87, 0x0e, 0x6c, 0x21 // smulbb cs r12 r7 r14
};
const byte kInstruction_smulbb_cc_r4_r12_r10[] = {
  0x8c, 0x0a, 0x64, 0x31 // smulbb cc r4 r12 r10
};
const byte kInstruction_smulbb_al_r3_r5_r10[] = {
  0x85, 0x0a, 0x63, 0xe1 // smulbb al r3 r5 r10
};
const byte kInstruction_smulbb_mi_r5_r3_r7[] = {
  0x83, 0x07, 0x65, 0x41 // smulbb mi r5 r3 r7
};
const byte kInstruction_smulbb_ls_r10_r6_r2[] = {
  0x86, 0x02, 0x6a, 0x91 // smulbb ls r10 r6 r2
};
const byte kInstruction_smulbb_mi_r0_r12_r11[] = {
  0x8c, 0x0b, 0x60, 0x41 // smulbb mi r0 r12 r11
};
const byte kInstruction_smulbb_vc_r12_r5_r6[] = {
  0x85, 0x06, 0x6c, 0x71 // smulbb vc r12 r5 r6
};
const byte kInstruction_smulbb_cs_r3_r9_r4[] = {
  0x89, 0x04, 0x63, 0x21 // smulbb cs r3 r9 r4
};
const byte kInstruction_smulbb_ls_r4_r9_r11[] = {
  0x89, 0x0b, 0x64, 0x91 // smulbb ls r4 r9 r11
};
const byte kInstruction_smulbb_le_r14_r8_r13[] = {
  0x88, 0x0d, 0x6e, 0xd1 // smulbb le r14 r8 r13
};
const byte kInstruction_smulbb_gt_r4_r10_r8[] = {
  0x8a, 0x08, 0x64, 0xc1 // smulbb gt r4 r10 r8
};
const byte kInstruction_smulbb_al_r6_r9_r9[] = {
  0x89, 0x09, 0x66, 0xe1 // smulbb al r6 r9 r9
};
const byte kInstruction_smulbb_ne_r8_r5_r12[] = {
  0x85, 0x0c, 0x68, 0x11 // smulbb ne r8 r5 r12
};
const byte kInstruction_smulbb_ne_r0_r4_r8[] = {
  0x84, 0x08, 0x60, 0x11 // smulbb ne r0 r4 r8
};
const byte kInstruction_smulbb_mi_r7_r13_r3[] = {
  0x8d, 0x03, 0x67, 0x41 // smulbb mi r7 r13 r3
};
const byte kInstruction_smulbb_cc_r11_r7_r0[] = {
  0x87, 0x00, 0x6b, 0x31 // smulbb cc r11 r7 r0
};
const byte kInstruction_smulbb_hi_r1_r0_r12[] = {
  0x80, 0x0c, 0x61, 0x81 // smulbb hi r1 r0 r12
};
const byte kInstruction_smulbb_lt_r8_r9_r3[] = {
  0x89, 0x03, 0x68, 0xb1 // smulbb lt r8 r9 r3
};
const byte kInstruction_smulbb_al_r0_r2_r1[] = {
  0x82, 0x01, 0x60, 0xe1 // smulbb al r0 r2 r1
};
const byte kInstruction_smulbb_vs_r4_r3_r14[] = {
  0x83, 0x0e, 0x64, 0x61 // smulbb vs r4 r3 r14
};
const byte kInstruction_smulbb_ge_r2_r11_r1[] = {
  0x8b, 0x01, 0x62, 0xa1 // smulbb ge r2 r11 r1
};
const byte kInstruction_smulbb_lt_r12_r9_r6[] = {
  0x89, 0x06, 0x6c, 0xb1 // smulbb lt r12 r9 r6
};
const byte kInstruction_smulbb_ls_r8_r2_r7[] = {
  0x82, 0x07, 0x68, 0x91 // smulbb ls r8 r2 r7
};
const byte kInstruction_smulbb_le_r8_r13_r3[] = {
  0x8d, 0x03, 0x68, 0xd1 // smulbb le r8 r13 r3
};
const byte kInstruction_smulbb_eq_r11_r13_r14[] = {
  0x8d, 0x0e, 0x6b, 0x01 // smulbb eq r11 r13 r14
};
const byte kInstruction_smulbb_lt_r1_r6_r13[] = {
  0x86, 0x0d, 0x61, 0xb1 // smulbb lt r1 r6 r13
};
const byte kInstruction_smulbb_cs_r3_r8_r11[] = {
  0x88, 0x0b, 0x63, 0x21 // smulbb cs r3 r8 r11
};
const byte kInstruction_smulbb_pl_r12_r5_r4[] = {
  0x85, 0x04, 0x6c, 0x51 // smulbb pl r12 r5 r4
};
const byte kInstruction_smulbb_eq_r8_r7_r2[] = {
  0x87, 0x02, 0x68, 0x01 // smulbb eq r8 r7 r2
};
const byte kInstruction_smulbb_ls_r2_r12_r2[] = {
  0x8c, 0x02, 0x62, 0x91 // smulbb ls r2 r12 r2
};
const byte kInstruction_smulbb_le_r14_r2_r3[] = {
  0x82, 0x03, 0x6e, 0xd1 // smulbb le r14 r2 r3
};
const byte kInstruction_smulbb_ge_r10_r11_r6[] = {
  0x8b, 0x06, 0x6a, 0xa1 // smulbb ge r10 r11 r6
};
const byte kInstruction_smulbb_hi_r0_r2_r2[] = {
  0x82, 0x02, 0x60, 0x81 // smulbb hi r0 r2 r2
};
const byte kInstruction_smulbb_ge_r2_r0_r2[] = {
  0x80, 0x02, 0x62, 0xa1 // smulbb ge r2 r0 r2
};
const byte kInstruction_smulbb_vs_r11_r14_r0[] = {
  0x8e, 0x00, 0x6b, 0x61 // smulbb vs r11 r14 r0
};
const byte kInstruction_smulbb_lt_r2_r0_r1[] = {
  0x80, 0x01, 0x62, 0xb1 // smulbb lt r2 r0 r1
};
const byte kInstruction_smulbb_cs_r2_r5_r11[] = {
  0x85, 0x0b, 0x62, 0x21 // smulbb cs r2 r5 r11
};
const byte kInstruction_smulbb_ls_r7_r14_r5[] = {
  0x8e, 0x05, 0x67, 0x91 // smulbb ls r7 r14 r5
};
const byte kInstruction_smulbb_pl_r0_r0_r3[] = {
  0x80, 0x03, 0x60, 0x51 // smulbb pl r0 r0 r3
};
const byte kInstruction_smulbb_ge_r6_r8_r8[] = {
  0x88, 0x08, 0x66, 0xa1 // smulbb ge r6 r8 r8
};
const byte kInstruction_smulbb_le_r11_r1_r10[] = {
  0x81, 0x0a, 0x6b, 0xd1 // smulbb le r11 r1 r10
};
const byte kInstruction_smulbb_vs_r5_r2_r7[] = {
  0x82, 0x07, 0x65, 0x61 // smulbb vs r5 r2 r7
};
const byte kInstruction_smulbb_ne_r4_r4_r8[] = {
  0x84, 0x08, 0x64, 0x11 // smulbb ne r4 r4 r8
};
const byte kInstruction_smulbb_cc_r9_r14_r13[] = {
  0x8e, 0x0d, 0x69, 0x31 // smulbb cc r9 r14 r13
};
const byte kInstruction_smulbb_hi_r14_r6_r3[] = {
  0x86, 0x03, 0x6e, 0x81 // smulbb hi r14 r6 r3
};
const byte kInstruction_smulbb_al_r0_r8_r0[] = {
  0x88, 0x00, 0x60, 0xe1 // smulbb al r0 r8 r0
};
const byte kInstruction_smulbb_lt_r6_r11_r1[] = {
  0x8b, 0x01, 0x66, 0xb1 // smulbb lt r6 r11 r1
};
const byte kInstruction_smulbb_ge_r7_r6_r12[] = {
  0x86, 0x0c, 0x67, 0xa1 // smulbb ge r7 r6 r12
};
const byte kInstruction_smulbb_cs_r4_r6_r14[] = {
  0x86, 0x0e, 0x64, 0x21 // smulbb cs r4 r6 r14
};
const byte kInstruction_smulbb_cs_r7_r6_r7[] = {
  0x86, 0x07, 0x67, 0x21 // smulbb cs r7 r6 r7
};
const byte kInstruction_smulbb_cs_r3_r7_r10[] = {
  0x87, 0x0a, 0x63, 0x21 // smulbb cs r3 r7 r10
};
const byte kInstruction_smulbb_ne_r0_r2_r1[] = {
  0x82, 0x01, 0x60, 0x11 // smulbb ne r0 r2 r1
};
const byte kInstruction_smulbb_vs_r9_r10_r13[] = {
  0x8a, 0x0d, 0x69, 0x61 // smulbb vs r9 r10 r13
};
const byte kInstruction_smulbb_vc_r11_r14_r12[] = {
  0x8e, 0x0c, 0x6b, 0x71 // smulbb vc r11 r14 r12
};
const byte kInstruction_smulbb_ge_r14_r8_r7[] = {
  0x88, 0x07, 0x6e, 0xa1 // smulbb ge r14 r8 r7
};
const byte kInstruction_smulbb_lt_r13_r0_r11[] = {
  0x80, 0x0b, 0x6d, 0xb1 // smulbb lt r13 r0 r11
};
const byte kInstruction_smulbb_lt_r14_r13_r4[] = {
  0x8d, 0x04, 0x6e, 0xb1 // smulbb lt r14 r13 r4
};
const byte kInstruction_smulbb_al_r1_r10_r9[] = {
  0x8a, 0x09, 0x61, 0xe1 // smulbb al r1 r10 r9
};
const byte kInstruction_smulbb_ge_r11_r14_r11[] = {
  0x8e, 0x0b, 0x6b, 0xa1 // smulbb ge r11 r14 r11
};
const byte kInstruction_smulbb_cs_r11_r4_r11[] = {
  0x84, 0x0b, 0x6b, 0x21 // smulbb cs r11 r4 r11
};
const byte kInstruction_smulbb_ge_r0_r14_r7[] = {
  0x8e, 0x07, 0x60, 0xa1 // smulbb ge r0 r14 r7
};
const byte kInstruction_smulbb_mi_r1_r2_r9[] = {
  0x82, 0x09, 0x61, 0x41 // smulbb mi r1 r2 r9
};
const byte kInstruction_smulbb_eq_r5_r12_r3[] = {
  0x8c, 0x03, 0x65, 0x01 // smulbb eq r5 r12 r3
};
const byte kInstruction_smulbb_ge_r1_r5_r12[] = {
  0x85, 0x0c, 0x61, 0xa1 // smulbb ge r1 r5 r12
};
const byte kInstruction_smulbb_lt_r10_r11_r4[] = {
  0x8b, 0x04, 0x6a, 0xb1 // smulbb lt r10 r11 r4
};
const byte kInstruction_smulbb_le_r1_r1_r5[] = {
  0x81, 0x05, 0x61, 0xd1 // smulbb le r1 r1 r5
};
const byte kInstruction_smulbb_al_r9_r1_r8[] = {
  0x81, 0x08, 0x69, 0xe1 // smulbb al r9 r1 r8
};
const byte kInstruction_smulbb_ne_r6_r8_r4[] = {
  0x88, 0x04, 0x66, 0x11 // smulbb ne r6 r8 r4
};
const byte kInstruction_smulbb_ge_r12_r2_r9[] = {
  0x82, 0x09, 0x6c, 0xa1 // smulbb ge r12 r2 r9
};
const byte kInstruction_smulbb_pl_r4_r3_r10[] = {
  0x83, 0x0a, 0x64, 0x51 // smulbb pl r4 r3 r10
};
const byte kInstruction_smulbb_eq_r14_r4_r11[] = {
  0x84, 0x0b, 0x6e, 0x01 // smulbb eq r14 r4 r11
};
const byte kInstruction_smulbb_cc_r9_r7_r6[] = {
  0x87, 0x06, 0x69, 0x31 // smulbb cc r9 r7 r6
};
const byte kInstruction_smulbb_ge_r12_r4_r5[] = {
  0x84, 0x05, 0x6c, 0xa1 // smulbb ge r12 r4 r5
};
const byte kInstruction_smulbb_hi_r2_r3_r4[] = {
  0x83, 0x04, 0x62, 0x81 // smulbb hi r2 r3 r4
};
const byte kInstruction_smulbb_cs_r0_r3_r1[] = {
  0x83, 0x01, 0x60, 0x21 // smulbb cs r0 r3 r1
};
const byte kInstruction_smulbb_hi_r6_r2_r8[] = {
  0x82, 0x08, 0x66, 0x81 // smulbb hi r6 r2 r8
};
const byte kInstruction_smulbb_cc_r3_r14_r13[] = {
  0x8e, 0x0d, 0x63, 0x31 // smulbb cc r3 r14 r13
};
const byte kInstruction_smulbb_gt_r11_r4_r7[] = {
  0x84, 0x07, 0x6b, 0xc1 // smulbb gt r11 r4 r7
};
const byte kInstruction_smulbb_hi_r5_r0_r12[] = {
  0x80, 0x0c, 0x65, 0x81 // smulbb hi r5 r0 r12
};
const byte kInstruction_smulbb_gt_r0_r14_r14[] = {
  0x8e, 0x0e, 0x60, 0xc1 // smulbb gt r0 r14 r14
};
const byte kInstruction_smulbb_hi_r9_r0_r10[] = {
  0x80, 0x0a, 0x69, 0x81 // smulbb hi r9 r0 r10
};
const byte kInstruction_smulbb_vc_r7_r11_r8[] = {
  0x8b, 0x08, 0x67, 0x71 // smulbb vc r7 r11 r8
};
const byte kInstruction_smulbb_pl_r11_r9_r6[] = {
  0x89, 0x06, 0x6b, 0x51 // smulbb pl r11 r9 r6
};
const byte kInstruction_smulbb_al_r3_r3_r7[] = {
  0x83, 0x07, 0x63, 0xe1 // smulbb al r3 r3 r7
};
const byte kInstruction_smulbb_mi_r5_r7_r9[] = {
  0x87, 0x09, 0x65, 0x41 // smulbb mi r5 r7 r9
};
const byte kInstruction_smulbb_cc_r11_r2_r4[] = {
  0x82, 0x04, 0x6b, 0x31 // smulbb cc r11 r2 r4
};
const byte kInstruction_smulbb_cc_r9_r13_r10[] = {
  0x8d, 0x0a, 0x69, 0x31 // smulbb cc r9 r13 r10
};
const byte kInstruction_smulbb_al_r5_r2_r6[] = {
  0x82, 0x06, 0x65, 0xe1 // smulbb al r5 r2 r6
};
const byte kInstruction_smulbb_ge_r9_r4_r6[] = {
  0x84, 0x06, 0x69, 0xa1 // smulbb ge r9 r4 r6
};
const byte kInstruction_smulbb_ls_r3_r3_r4[] = {
  0x83, 0x04, 0x63, 0x91 // smulbb ls r3 r3 r4
};
const byte kInstruction_smulbb_ge_r14_r1_r8[] = {
  0x81, 0x08, 0x6e, 0xa1 // smulbb ge r14 r1 r8
};
const byte kInstruction_smulbb_ls_r7_r12_r7[] = {
  0x8c, 0x07, 0x67, 0x91 // smulbb ls r7 r12 r7
};
const byte kInstruction_smulbb_al_r11_r10_r5[] = {
  0x8a, 0x05, 0x6b, 0xe1 // smulbb al r11 r10 r5
};
const byte kInstruction_smulbb_al_r7_r4_r6[] = {
  0x84, 0x06, 0x67, 0xe1 // smulbb al r7 r4 r6
};
const byte kInstruction_smulbb_vs_r12_r4_r10[] = {
  0x84, 0x0a, 0x6c, 0x61 // smulbb vs r12 r4 r10
};
const byte kInstruction_smulbb_eq_r4_r4_r4[] = {
  0x84, 0x04, 0x64, 0x01 // smulbb eq r4 r4 r4
};
const byte kInstruction_smulbb_vs_r6_r6_r12[] = {
  0x86, 0x0c, 0x66, 0x61 // smulbb vs r6 r6 r12
};
const byte kInstruction_smulbb_pl_r9_r3_r5[] = {
  0x83, 0x05, 0x69, 0x51 // smulbb pl r9 r3 r5
};
const byte kInstruction_smulbb_eq_r6_r5_r13[] = {
  0x85, 0x0d, 0x66, 0x01 // smulbb eq r6 r5 r13
};
const byte kInstruction_smulbb_cc_r8_r2_r12[] = {
  0x82, 0x0c, 0x68, 0x31 // smulbb cc r8 r2 r12
};
const byte kInstruction_smulbb_le_r4_r2_r0[] = {
  0x82, 0x00, 0x64, 0xd1 // smulbb le r4 r2 r0
};
const byte kInstruction_smulbb_lt_r7_r9_r8[] = {
  0x89, 0x08, 0x67, 0xb1 // smulbb lt r7 r9 r8
};
const byte kInstruction_smulbb_le_r4_r7_r11[] = {
  0x87, 0x0b, 0x64, 0xd1 // smulbb le r4 r7 r11
};
const byte kInstruction_smulbb_eq_r5_r7_r5[] = {
  0x87, 0x05, 0x65, 0x01 // smulbb eq r5 r7 r5
};
const byte kInstruction_smulbb_vc_r10_r7_r12[] = {
  0x87, 0x0c, 0x6a, 0x71 // smulbb vc r10 r7 r12
};
const byte kInstruction_smulbb_eq_r7_r10_r6[] = {
  0x8a, 0x06, 0x67, 0x01 // smulbb eq r7 r10 r6
};
const byte kInstruction_smulbb_pl_r1_r12_r2[] = {
  0x8c, 0x02, 0x61, 0x51 // smulbb pl r1 r12 r2
};
const byte kInstruction_smulbb_le_r14_r6_r6[] = {
  0x86, 0x06, 0x6e, 0xd1 // smulbb le r14 r6 r6
};
const byte kInstruction_smulbb_ne_r3_r8_r8[] = {
  0x88, 0x08, 0x63, 0x11 // smulbb ne r3 r8 r8
};
const byte kInstruction_smulbb_eq_r4_r12_r8[] = {
  0x8c, 0x08, 0x64, 0x01 // smulbb eq r4 r12 r8
};
const byte kInstruction_smulbb_ge_r11_r2_r3[] = {
  0x82, 0x03, 0x6b, 0xa1 // smulbb ge r11 r2 r3
};
const byte kInstruction_smulbb_hi_r12_r6_r11[] = {
  0x86, 0x0b, 0x6c, 0x81 // smulbb hi r12 r6 r11
};
const byte kInstruction_smulbb_cs_r4_r5_r10[] = {
  0x85, 0x0a, 0x64, 0x21 // smulbb cs r4 r5 r10
};
const byte kInstruction_smulbb_ge_r10_r2_r10[] = {
  0x82, 0x0a, 0x6a, 0xa1 // smulbb ge r10 r2 r10
};
const byte kInstruction_smulbb_ge_r5_r14_r6[] = {
  0x8e, 0x06, 0x65, 0xa1 // smulbb ge r5 r14 r6
};
const byte kInstruction_smulbb_gt_r13_r7_r5[] = {
  0x87, 0x05, 0x6d, 0xc1 // smulbb gt r13 r7 r5
};
const byte kInstruction_smulbb_ge_r13_r4_r12[] = {
  0x84, 0x0c, 0x6d, 0xa1 // smulbb ge r13 r4 r12
};
const byte kInstruction_smulbb_lt_r8_r10_r14[] = {
  0x8a, 0x0e, 0x68, 0xb1 // smulbb lt r8 r10 r14
};
const byte kInstruction_smulbb_le_r4_r3_r13[] = {
  0x83, 0x0d, 0x64, 0xd1 // smulbb le r4 r3 r13
};
const byte kInstruction_smulbb_pl_r0_r9_r0[] = {
  0x89, 0x00, 0x60, 0x51 // smulbb pl r0 r9 r0
};
const byte kInstruction_smulbb_eq_r2_r3_r1[] = {
  0x83, 0x01, 0x62, 0x01 // smulbb eq r2 r3 r1
};
const byte kInstruction_smulbb_vc_r0_r0_r3[] = {
  0x80, 0x03, 0x60, 0x71 // smulbb vc r0 r0 r3
};
const byte kInstruction_smulbb_mi_r10_r8_r11[] = {
  0x88, 0x0b, 0x6a, 0x41 // smulbb mi r10 r8 r11
};
const byte kInstruction_smulbb_mi_r5_r14_r14[] = {
  0x8e, 0x0e, 0x65, 0x41 // smulbb mi r5 r14 r14
};
const byte kInstruction_smulbb_gt_r5_r11_r2[] = {
  0x8b, 0x02, 0x65, 0xc1 // smulbb gt r5 r11 r2
};
const byte kInstruction_smulbb_al_r4_r7_r11[] = {
  0x87, 0x0b, 0x64, 0xe1 // smulbb al r4 r7 r11
};
const TestResult kReferencesmulbb[] = {
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r1_r9_r5),
    kInstruction_smulbb_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r8_r6_r2),
    kInstruction_smulbb_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r5_r8_r2),
    kInstruction_smulbb_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r9_r2_r7),
    kInstruction_smulbb_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r4_r6_r3),
    kInstruction_smulbb_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r11_r6_r2),
    kInstruction_smulbb_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r8_r14_r4),
    kInstruction_smulbb_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r5_r14_r6),
    kInstruction_smulbb_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r6_r1_r0),
    kInstruction_smulbb_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r5_r0_r9),
    kInstruction_smulbb_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r8_r12_r7),
    kInstruction_smulbb_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r7_r14_r6),
    kInstruction_smulbb_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r7_r4_r6),
    kInstruction_smulbb_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r9_r6_r9),
    kInstruction_smulbb_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r13_r9_r1),
    kInstruction_smulbb_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r13_r1_r13),
    kInstruction_smulbb_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r8_r10_r2),
    kInstruction_smulbb_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r0_r13_r5),
    kInstruction_smulbb_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r13_r7_r8),
    kInstruction_smulbb_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r4_r13_r11),
    kInstruction_smulbb_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r5_r10_r5),
    kInstruction_smulbb_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r5_r4_r3),
    kInstruction_smulbb_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r6_r14_r8),
    kInstruction_smulbb_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r3_r8_r6),
    kInstruction_smulbb_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r7_r12_r3),
    kInstruction_smulbb_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r1_r4_r1),
    kInstruction_smulbb_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r4_r7_r10),
    kInstruction_smulbb_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r2_r0_r13),
    kInstruction_smulbb_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r9_r6_r8),
    kInstruction_smulbb_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r14_r11_r13),
    kInstruction_smulbb_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r5_r8_r4),
    kInstruction_smulbb_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r2_r3_r7),
    kInstruction_smulbb_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r7_r12_r14),
    kInstruction_smulbb_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r6_r6_r1),
    kInstruction_smulbb_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r6_r9_r6),
    kInstruction_smulbb_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r12_r12_r0),
    kInstruction_smulbb_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r9_r3_r8),
    kInstruction_smulbb_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r13_r6_r1),
    kInstruction_smulbb_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r4_r8_r6),
    kInstruction_smulbb_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r11_r5_r9),
    kInstruction_smulbb_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r6_r10_r6),
    kInstruction_smulbb_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r10_r10_r5),
    kInstruction_smulbb_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r5_r4_r11),
    kInstruction_smulbb_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r11_r11_r2),
    kInstruction_smulbb_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r6_r14_r12),
    kInstruction_smulbb_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r7_r7_r2),
    kInstruction_smulbb_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r10_r8_r4),
    kInstruction_smulbb_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r14_r7_r2),
    kInstruction_smulbb_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r3_r11_r10),
    kInstruction_smulbb_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r11_r4_r0),
    kInstruction_smulbb_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r11_r8_r9),
    kInstruction_smulbb_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r2_r14_r13),
    kInstruction_smulbb_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r1_r13_r9),
    kInstruction_smulbb_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r3_r9_r13),
    kInstruction_smulbb_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r10_r3_r13),
    kInstruction_smulbb_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r8_r5_r10),
    kInstruction_smulbb_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r8_r11_r6),
    kInstruction_smulbb_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r0_r0_r5),
    kInstruction_smulbb_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r6_r5_r8),
    kInstruction_smulbb_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r5_r13_r3),
    kInstruction_smulbb_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r11_r14_r14),
    kInstruction_smulbb_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r1_r0_r6),
    kInstruction_smulbb_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r14_r8_r2),
    kInstruction_smulbb_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r9_r6_r5),
    kInstruction_smulbb_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r11_r0_r13),
    kInstruction_smulbb_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r4_r5_r14),
    kInstruction_smulbb_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r13_r5_r13),
    kInstruction_smulbb_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r0_r13_r8),
    kInstruction_smulbb_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r2_r13_r3),
    kInstruction_smulbb_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r8_r1_r11),
    kInstruction_smulbb_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r14_r11_r8),
    kInstruction_smulbb_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r4_r13_r12),
    kInstruction_smulbb_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r2_r1_r14),
    kInstruction_smulbb_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r9_r4_r14),
    kInstruction_smulbb_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r10_r6_r13),
    kInstruction_smulbb_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r12_r9_r4),
    kInstruction_smulbb_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r9_r11_r14),
    kInstruction_smulbb_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r0_r9_r5),
    kInstruction_smulbb_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r2_r3_r8),
    kInstruction_smulbb_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r14_r10_r14),
    kInstruction_smulbb_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r6_r2_r10),
    kInstruction_smulbb_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r11_r0_r12),
    kInstruction_smulbb_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r1_r12_r10),
    kInstruction_smulbb_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r1_r0_r2),
    kInstruction_smulbb_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r5_r5_r7),
    kInstruction_smulbb_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r7_r13_r1),
    kInstruction_smulbb_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r4_r4_r9),
    kInstruction_smulbb_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r14_r4_r14),
    kInstruction_smulbb_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r10_r5_r14),
    kInstruction_smulbb_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r4_r3_r11),
    kInstruction_smulbb_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r14_r10_r12),
    kInstruction_smulbb_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r2_r11_r0),
    kInstruction_smulbb_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r5_r12_r7),
    kInstruction_smulbb_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r7_r14_r6),
    kInstruction_smulbb_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r8_r3_r8),
    kInstruction_smulbb_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r9_r14_r3),
    kInstruction_smulbb_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r2_r11_r2),
    kInstruction_smulbb_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r11_r7_r12),
    kInstruction_smulbb_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r6_r4_r11),
    kInstruction_smulbb_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r12_r5_r9),
    kInstruction_smulbb_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r5_r10_r5),
    kInstruction_smulbb_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r0_r9_r13),
    kInstruction_smulbb_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r3_r3_r5),
    kInstruction_smulbb_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r0_r12_r8),
    kInstruction_smulbb_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r3_r12_r12),
    kInstruction_smulbb_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r8_r12_r5),
    kInstruction_smulbb_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r7_r8_r1),
    kInstruction_smulbb_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r2_r13_r10),
    kInstruction_smulbb_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r7_r10_r10),
    kInstruction_smulbb_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r1_r12_r2),
    kInstruction_smulbb_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r8_r5_r8),
    kInstruction_smulbb_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r3_r7_r9),
    kInstruction_smulbb_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r8_r10_r8),
    kInstruction_smulbb_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r4_r12_r10),
    kInstruction_smulbb_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r10_r5_r11),
    kInstruction_smulbb_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r3_r14_r4),
    kInstruction_smulbb_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r3_r6_r12),
    kInstruction_smulbb_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r6_r0_r4),
    kInstruction_smulbb_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r11_r6_r0),
    kInstruction_smulbb_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r3_r1_r9),
    kInstruction_smulbb_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r12_r13_r0),
    kInstruction_smulbb_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r1_r2_r5),
    kInstruction_smulbb_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r4_r3_r14),
    kInstruction_smulbb_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r6_r11_r11),
    kInstruction_smulbb_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r14_r11_r14),
    kInstruction_smulbb_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r4_r10_r0),
    kInstruction_smulbb_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r7_r11_r1),
    kInstruction_smulbb_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r14_r6_r10),
    kInstruction_smulbb_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r2_r0_r11),
    kInstruction_smulbb_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r13_r5_r12),
    kInstruction_smulbb_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r2_r12_r5),
    kInstruction_smulbb_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r12_r0_r2),
    kInstruction_smulbb_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r10_r10_r9),
    kInstruction_smulbb_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r11_r11_r8),
    kInstruction_smulbb_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r10_r11_r9),
    kInstruction_smulbb_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r7_r12_r14),
    kInstruction_smulbb_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r11_r14_r12),
    kInstruction_smulbb_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r0_r12_r8),
    kInstruction_smulbb_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r0_r5_r7),
    kInstruction_smulbb_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r5_r13_r8),
    kInstruction_smulbb_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r9_r9_r7),
    kInstruction_smulbb_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r4_r9_r5),
    kInstruction_smulbb_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r8_r1_r3),
    kInstruction_smulbb_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r0_r10_r12),
    kInstruction_smulbb_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r7_r14_r0),
    kInstruction_smulbb_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r12_r9_r11),
    kInstruction_smulbb_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r5_r9_r11),
    kInstruction_smulbb_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r14_r13_r7),
    kInstruction_smulbb_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r11_r3_r10),
    kInstruction_smulbb_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r11_r8_r12),
    kInstruction_smulbb_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r3_r8_r13),
    kInstruction_smulbb_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r10_r12_r6),
    kInstruction_smulbb_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r7_r3_r2),
    kInstruction_smulbb_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r9_r0_r8),
    kInstruction_smulbb_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r2_r13_r7),
    kInstruction_smulbb_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r2_r14_r0),
    kInstruction_smulbb_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r4_r10_r0),
    kInstruction_smulbb_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r0_r2_r2),
    kInstruction_smulbb_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r1_r6_r0),
    kInstruction_smulbb_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r12_r0_r8),
    kInstruction_smulbb_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r9_r3_r14),
    kInstruction_smulbb_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r7_r9_r1),
    kInstruction_smulbb_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r11_r9_r14),
    kInstruction_smulbb_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r6_r10_r4),
    kInstruction_smulbb_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r8_r5_r6),
    kInstruction_smulbb_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r0_r6_r2),
    kInstruction_smulbb_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r11_r12_r4),
    kInstruction_smulbb_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r14_r3_r14),
    kInstruction_smulbb_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r7_r12_r14),
    kInstruction_smulbb_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r2_r9_r9),
    kInstruction_smulbb_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r8_r1_r0),
    kInstruction_smulbb_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r5_r11_r2),
    kInstruction_smulbb_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r0_r1_r2),
    kInstruction_smulbb_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r4_r9_r4),
    kInstruction_smulbb_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r12_r7_r14),
    kInstruction_smulbb_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r4_r12_r10),
    kInstruction_smulbb_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r3_r5_r10),
    kInstruction_smulbb_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r5_r3_r7),
    kInstruction_smulbb_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r10_r6_r2),
    kInstruction_smulbb_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r0_r12_r11),
    kInstruction_smulbb_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r12_r5_r6),
    kInstruction_smulbb_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r3_r9_r4),
    kInstruction_smulbb_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r4_r9_r11),
    kInstruction_smulbb_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r14_r8_r13),
    kInstruction_smulbb_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r4_r10_r8),
    kInstruction_smulbb_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r6_r9_r9),
    kInstruction_smulbb_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r8_r5_r12),
    kInstruction_smulbb_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r0_r4_r8),
    kInstruction_smulbb_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r7_r13_r3),
    kInstruction_smulbb_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r11_r7_r0),
    kInstruction_smulbb_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r1_r0_r12),
    kInstruction_smulbb_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r8_r9_r3),
    kInstruction_smulbb_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r0_r2_r1),
    kInstruction_smulbb_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r4_r3_r14),
    kInstruction_smulbb_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r2_r11_r1),
    kInstruction_smulbb_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r12_r9_r6),
    kInstruction_smulbb_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r8_r2_r7),
    kInstruction_smulbb_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r8_r13_r3),
    kInstruction_smulbb_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r11_r13_r14),
    kInstruction_smulbb_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r1_r6_r13),
    kInstruction_smulbb_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r3_r8_r11),
    kInstruction_smulbb_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r12_r5_r4),
    kInstruction_smulbb_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r8_r7_r2),
    kInstruction_smulbb_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r2_r12_r2),
    kInstruction_smulbb_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r14_r2_r3),
    kInstruction_smulbb_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r10_r11_r6),
    kInstruction_smulbb_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r0_r2_r2),
    kInstruction_smulbb_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r2_r0_r2),
    kInstruction_smulbb_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r11_r14_r0),
    kInstruction_smulbb_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r2_r0_r1),
    kInstruction_smulbb_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r2_r5_r11),
    kInstruction_smulbb_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r7_r14_r5),
    kInstruction_smulbb_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r0_r0_r3),
    kInstruction_smulbb_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r6_r8_r8),
    kInstruction_smulbb_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r11_r1_r10),
    kInstruction_smulbb_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r5_r2_r7),
    kInstruction_smulbb_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r4_r4_r8),
    kInstruction_smulbb_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r9_r14_r13),
    kInstruction_smulbb_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r14_r6_r3),
    kInstruction_smulbb_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r0_r8_r0),
    kInstruction_smulbb_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r6_r11_r1),
    kInstruction_smulbb_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r7_r6_r12),
    kInstruction_smulbb_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r4_r6_r14),
    kInstruction_smulbb_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r7_r6_r7),
    kInstruction_smulbb_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r3_r7_r10),
    kInstruction_smulbb_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r0_r2_r1),
    kInstruction_smulbb_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r9_r10_r13),
    kInstruction_smulbb_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r11_r14_r12),
    kInstruction_smulbb_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r14_r8_r7),
    kInstruction_smulbb_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r13_r0_r11),
    kInstruction_smulbb_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r14_r13_r4),
    kInstruction_smulbb_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r1_r10_r9),
    kInstruction_smulbb_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r11_r14_r11),
    kInstruction_smulbb_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r11_r4_r11),
    kInstruction_smulbb_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r0_r14_r7),
    kInstruction_smulbb_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r1_r2_r9),
    kInstruction_smulbb_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r5_r12_r3),
    kInstruction_smulbb_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r1_r5_r12),
    kInstruction_smulbb_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r10_r11_r4),
    kInstruction_smulbb_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r1_r1_r5),
    kInstruction_smulbb_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r9_r1_r8),
    kInstruction_smulbb_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r6_r8_r4),
    kInstruction_smulbb_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r12_r2_r9),
    kInstruction_smulbb_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r4_r3_r10),
    kInstruction_smulbb_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r14_r4_r11),
    kInstruction_smulbb_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r9_r7_r6),
    kInstruction_smulbb_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r12_r4_r5),
    kInstruction_smulbb_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r2_r3_r4),
    kInstruction_smulbb_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r0_r3_r1),
    kInstruction_smulbb_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r6_r2_r8),
    kInstruction_smulbb_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r3_r14_r13),
    kInstruction_smulbb_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r11_r4_r7),
    kInstruction_smulbb_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r5_r0_r12),
    kInstruction_smulbb_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r0_r14_r14),
    kInstruction_smulbb_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r9_r0_r10),
    kInstruction_smulbb_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r7_r11_r8),
    kInstruction_smulbb_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r11_r9_r6),
    kInstruction_smulbb_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r3_r3_r7),
    kInstruction_smulbb_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r5_r7_r9),
    kInstruction_smulbb_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r11_r2_r4),
    kInstruction_smulbb_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r9_r13_r10),
    kInstruction_smulbb_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r5_r2_r6),
    kInstruction_smulbb_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r9_r4_r6),
    kInstruction_smulbb_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r3_r3_r4),
    kInstruction_smulbb_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r14_r1_r8),
    kInstruction_smulbb_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ls_r7_r12_r7),
    kInstruction_smulbb_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r11_r10_r5),
    kInstruction_smulbb_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r7_r4_r6),
    kInstruction_smulbb_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r12_r4_r10),
    kInstruction_smulbb_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r4_r4_r4),
    kInstruction_smulbb_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vs_r6_r6_r12),
    kInstruction_smulbb_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r9_r3_r5),
    kInstruction_smulbb_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r6_r5_r13),
    kInstruction_smulbb_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cc_r8_r2_r12),
    kInstruction_smulbb_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r4_r2_r0),
    kInstruction_smulbb_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r7_r9_r8),
    kInstruction_smulbb_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r4_r7_r11),
    kInstruction_smulbb_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r5_r7_r5),
    kInstruction_smulbb_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r10_r7_r12),
    kInstruction_smulbb_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r7_r10_r6),
    kInstruction_smulbb_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r1_r12_r2),
    kInstruction_smulbb_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r14_r6_r6),
    kInstruction_smulbb_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ne_r3_r8_r8),
    kInstruction_smulbb_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r4_r12_r8),
    kInstruction_smulbb_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r11_r2_r3),
    kInstruction_smulbb_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_hi_r12_r6_r11),
    kInstruction_smulbb_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_cs_r4_r5_r10),
    kInstruction_smulbb_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r10_r2_r10),
    kInstruction_smulbb_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r5_r14_r6),
    kInstruction_smulbb_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r13_r7_r5),
    kInstruction_smulbb_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_ge_r13_r4_r12),
    kInstruction_smulbb_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_lt_r8_r10_r14),
    kInstruction_smulbb_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_le_r4_r3_r13),
    kInstruction_smulbb_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_pl_r0_r9_r0),
    kInstruction_smulbb_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_eq_r2_r3_r1),
    kInstruction_smulbb_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_vc_r0_r0_r3),
    kInstruction_smulbb_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r10_r8_r11),
    kInstruction_smulbb_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_mi_r5_r14_r14),
    kInstruction_smulbb_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_gt_r5_r11_r2),
    kInstruction_smulbb_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_smulbb_al_r4_r7_r11),
    kInstruction_smulbb_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SMULBB_A32_H_
