/****************************************
 * ArtemisCCDAPI.h
 *
 * This file is autogenerated.
 * ...and modified by BM 20070811
 ****************************************/
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#if defined(_WXMSW_)

#include <comdef.h>

//////////////////////////////////////////////////////////////////////////
//
// Interface functions for Artemis CCD Camera Library
//

#include "ArtTypes.h"

// interface functions

// Return API version. XYY X=major, YY=minor
extern  int ArtemisAPIVersion();

// ** Deprecated - use ArtemisDeviceName instead
// Get USB Identifier of Nth FTDI device. Return false if no such device.
// pName must be at least 40 chars long.
extern  bool ArtemisFTName(int Device, char *pName);

// ** Deprecated - use ArtemisDeviceSerial instead
// Get USB Serial number of Nth FTDI device. Return false if no such device.
// pName must be at least 40 chars long.
extern  bool ArtemisFTSerial(int Device, char *pName);

// ** Deprecated - use ArtemisDeviceIsCamera instead
// Return true if Nth FTDI device exists and is a camera.
extern  bool ArtemisIsCamera(int Device);

// Get USB Identifier of Nth USB device. Return false if no such device.
// pName must be at least 40 chars long.
extern  bool ArtemisDeviceName(int Device, char *pName);

// Get USB Serial number of Nth USB device. Return false if no such device.
// pName must be at least 40 chars long.
extern  bool ArtemisDeviceSerial(int Device, char *pName);

// Return true if Nth USB device exists and is a camera.
extern  bool ArtemisDeviceIsCamera(int Device);

// Disconnect from given device.
// Returns true if disconnected as requested
extern  bool ArtemisDisconnect(ArtemisHandle hCam);

// Connect to given device. If Device=-1, connect to first available
// Returns handle if connected as requested, else NULL
extern  ArtemisHandle ArtemisConnect(int Device);

// Disconnect all connected devices
extern  bool ArtemisDisconnectAll();

// Returns TRUE if currently connected to a device
extern  bool ArtemisIsConnected(ArtemisHandle hCam);

// Fills in pProp with camera properties
extern  int ArtemisProperties(ArtemisHandle hCam, struct ARTEMISPROPERTIES *pProp);

// Displays the Artemis setup dialog, if any
extern  int ArtemisSetupDialog();

// Abort exposure, if one is in progress
extern  int ArtemisAbortExposure(ArtemisHandle hCam);

// Set the start x,y coords for imaging subframe.
// X,Y in unbinned coordinates
extern  int ArtemisSubframePos(ArtemisHandle hCam, int x, int y);

// Set the width and height of imaging subframe
// W,H in unbinned coordinates
extern  int ArtemisSubframeSize(ArtemisHandle hCam, int w, int h);

// set the pos and size of imaging subframe inunbinned coords
extern  int ArtemisSubframe(ArtemisHandle hCam, int x, int y, int w, int h);

// Get the pos and size of imaging subframe
extern  int ArtemisGetSubframe(ArtemisHandle hCam, int *x, int *y, int *w, int *h);

// Set the x,y binning factors
extern  int ArtemisBin(ArtemisHandle hCam, int x, int y);

// Get the x,y binning factors
extern  int ArtemisGetBin(ArtemisHandle hCam, int *x, int *y);

// Set the Precharge mode
extern  int ArtemisPrechargeMode(ArtemisHandle hCam, int mode);

// Clear the VRegs
extern  int ArtemisClearVRegs(ArtemisHandle hCam);

// Set the FIFO usage flag
extern  int ArtemisFIFO(ArtemisHandle hCam, bool bEnable);

// Start an exposure
extern  int ArtemisStartExposure(ArtemisHandle hCam, float Seconds);

// Prematurely end an exposure, collecting image data.
extern  int ArtemisStopExposure(ArtemisHandle hCam);

// Retrieve the downloaded image as a 2D array of type VARIANT
extern  int ArtemisGetImageArray(ArtemisHandle hCam, VARIANT *pImageArray);

// Retrieve image dimensions and binning factors.
// x,y are actual CCD locations. w,h are pixel dimensions of image
extern  int ArtemisGetImageData(ArtemisHandle hCam, int *x, int *y, int *w, int *h, int *binx, int *biny);

// Upload a compressed object file to the Artemis PIC
extern  int ArtemisReflash(ArtemisHandle hCam ,char *objfile);

// Return true if amp switched off during exposures
extern  bool ArtemisGetAmplifierSwitched(ArtemisHandle hCam);

// Set whether amp is switched off during exposures
extern  int ArtemisSetAmplifierSwitched(ArtemisHandle hCam, bool bSwitched);

// Return duration of last exposure, in seconds
extern  float ArtemisLastExposureDuration(ArtemisHandle hCam);

// Return time remaining in current exposure, in seconds
extern  float ArtemisExposureTimeRemaining(ArtemisHandle hCam);

// Return ptr to static buffer containing time of start of last exposure
extern  char* ArtemisLastStartTime(ArtemisHandle hCam);

// Return true if an image is ready to be retrieved
extern  bool ArtemisImageReady(ArtemisHandle hCam);

// Switch off all guide relays
extern  int ArtemisStopGuiding(ArtemisHandle hCam);

// Activate a guide relay for a short interval
extern  int ArtemisPulseGuide(ArtemisHandle hCam, int axis, int milli);

// Activate a guide relay
extern  int ArtemisGuide(ArtemisHandle hCam, int axis);

// Set download thread to high or normal priority
extern  int ArtemisHighPriority(ArtemisHandle hCam, bool bHigh);

// Retrieve the current camera state
extern  int ArtemisCameraState(ArtemisHandle hCam);

// Percentage downloaded
extern  int ArtemisDownloadPercent(ArtemisHandle hCam);

// Return pointer to internal image buffer (actually unsigned shorts)
extern  void* ArtemisImageBuffer(ArtemisHandle hCam);

// Set the CCD amplifier on or off
extern  int ArtemisAmplifier(ArtemisHandle hCam, bool bOn);

// Set the webcam Long Exposure control
extern  int ArtemisWebcamLE(ArtemisHandle hCam, bool bHigh);

// Reset the camera PIC
extern  int ArtemisReset(ArtemisHandle hCam);

// Get current image processing options
extern  int ArtemisGetProcessing(ArtemisHandle hCam);

// Set current image processing options
extern  int ArtemisSetProcessing(ArtemisHandle hCam, int options);

// Set External Trigger mode. True=wait for trigger.
extern  int ArtemisTriggeredExposure(ArtemisHandle hCam, bool bAwaitTrigger);

// Send a packet of data to a peripheral, and receive a reply.
// pSendData points to an 8 byte array which is sent to the peripheral.
// pRecvData points to an 8 byte array which is filled with the peripheral's response.
// Returns ARTEMIS_OK if the peripheral responds, in which case pRecvData contains its reply.
// Returns ARTEMIS_NO_RESPONSE if the peripheral doesn't respond.
// If the peripheral does not respond, pRecvData is not guaranteed to be preserved.
// pSendData and pRecvData may be the same but must not be NULL.
extern  int ArtemisPeripheral(ArtemisHandle hCam, int PeripheralID, unsigned char *pSendData, unsigned char *pRecvData);

extern  int ArtemisTemperatureSensorInfo(ArtemisHandle hCam, int sensor, int* temperature);

extern  int ArtemisCoolingInfo(ArtemisHandle hCam, int* flags, int* level, int* minlvl, int* maxlvl, int* setpoint);

extern  int ArtemisSetCooling(ArtemisHandle hCam, int setpoint);

extern  int ArtemisCoolerWarmUp(ArtemisHandle hCam);

extern  int ArtemisReconnectUSB(ArtemisHandle hCam);

/////////////////////////////////////////////////
// Diagnostic Functions

// Ping the camera, return the result. -1 on error.
extern  int ArtemisDiagnosticPing(ArtemisHandle hCam, int send);

// Ping the FIFO, return the result. -1 on error.
extern  int ArtemisDiagnosticPingFIFO(ArtemisHandle hCam, int send);

// Set the CCD clocks running (firmware doesn't return!)
extern  int ArtemisDiagnosticRunCCD(ArtemisHandle hCam);

// Measure the precharge level
extern  int ArtemisDiagnosticPrecharge(ArtemisHandle hCam);

// Connects to kernel only, safe to use before firmware
// has been uploaded.
// Returns handle if connected as requested
extern  ArtemisHandle ArtemisDiagnosticConnect(int Device);

// Miscellaneous commands to set voltages etc.
// Not to be called if the CCD is installed!
extern  int ArtemisDiagnosticCommand(ArtemisHandle hCam, int cmd);

// Return the last FT USB error condition seen
// Calling this function clears the internal error state
extern  int ArtemisDiagnosticUSBError(ArtemisHandle hCam);

/////////////////////////////////////////////////
// Access LE/Guide ports from 3rd-party software
// msg is the command to execute
// unit is the camera number
// returns:
//  0  OK
//  1  camera busy
//  2  no camera active
//  3  invalid command
extern  int ArtemisSendMessage(int msg, int unit);

/////////////////////////////////////////////////
// Access peripherals from 3rd-party software
// peripheral is the peripheral's device ID
// send and recv are 8-byte buffers for message-passing
// unit is the camera number
// returns:
//  0  OK
//  1  camera busy
//  2  no camera active
//  3  invalid command
//  4  no response fropm peripheral
extern  int ArtemisSendPeripheralMessage(int peripheral, char *send, char *recv, int unit);

/////////////////////////////////////////////////
// Get camera description, for 3rd-party software
// recv is a 40-byte buffer for the data
// info tells which data to return:
//  0  camera description from firmware
//  1  FTDI device name
//  2  FTDI device serial number
// unit is the camera number
// returns:
//  0  OK
//  1  camera busy
//  2  no camera active
extern  int ArtemisGetDescription(char *recv, int info, int unit);


/////////////////////////////////////////////////
// Check camera licensing info.
// returns:
// true if camera is licensed, or if no licence required.
// false if camera licence is invalid.
extern  bool ArtemisIsLicensed(ArtemisHandle hCam);

/////////////////////////////////////////////////
// Get camera's input voltage.
// returns:
// vInput=input voltage
// Error code on error
extern  int ArtemisDiagnosticInputVoltage(ArtemisHandle hCam, float* vInput);

/////////////////////////////////////////////////
// Get camera's ClkSub and Amp voltages.
// returns:
// vClkSub=Clk Sub voltage
// vAmp=Amp voltage
// Error code on error
extern  int ArtemisDiagnosticClkSubAmpVoltage(ArtemisHandle hCam, float* vClkSub, float* vAmp);


// Try to load the Artemis DLL.
// Returns true if loaded ok.
extern bool ArtemisLoadDLL(char *FileName);

// Unload the Artemis DLL.
extern void ArtemisUnLoadDLL();

#endif // _WXMSW_
