.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
splitflap \- a simulation of a split-flap electromechanical display.
.SH SYNOPSIS
.B splitflap
[\-\-display \fIhost:display.screen\fP]
[\-\-visual \fIvisual\fP]
[\-\-window]
[\-\-root]
[\-\-window\-id \fInumber\fP]
[\-\-delay \fImicroseconds\fP]
[\-\-speed \fIfloat\fP]
[\-\-width \fIcolumns\fP]
[\-\-height \fIrows\fP]
[\-\-mode text | clock12 | clock24]
[\-\-no-wander]
[\-\-spin \fIaxes\fP]
[\-\-no\-spin]
[\-\-front] [\-\-no-front]
[\-\-wireframe]
[\-\-fps]
.SH DESCRIPTION
Simulates a split-flap display, an old style of electromechanical sign as
seen in airports and train stations, and commonly used in alarm clocks in
the 1960s and 1970s.  
.SH OPTIONS
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 20000 (0.02 seconds).
.TP 8
.B \-\-speed \fInumber\fP
Animation speed.  2.0 means twice as fast, 0.5 means half as fast.
.TP 8
.B \-\-width \fInumber\fP
Columns of the display.  Default: 22.
.TP 8
.B \-\-height \fInumber\fP
Rows of the display. Default: 8.
.TP 8
.B \-\-mode clock12
Display a 12-hour clock.
.TP 8
.B \-\-mode clock24
Display a 24-hour clock.
.TP 8
.B \-\-front | \-\-no-front
When spinning, never spin all the way around or upside down:
always face mostly forward so that the text is easily readable.
This is the default.
.TP 8
.B \-\-no\-front
Allow spins to go all the way around or upside down.
.TP 8
.B \-\-wander | \-\-no-wander
Whether the object should wander around the screen.
.TP 8
.B \-\-spin
Which axes around which the text should spin.  The default is "XYZ",
meaning rotate it freely in space.  "\fB\-\-spin Z\fP" would rotate the
text in the plane of the screen while not rotating it into or out
of the screen; etc.
.TP 8
.B \-\-wireframe | \-\-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-\-fps | \-\-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2015 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
