// SPDX-FileCopyrightText: Copyright 2024 yuzu Emulator Project
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include "core/hle/service/cmif_types.h"
#include "core/hle/service/service.h"

namespace Service::NS {

class IVulnerabilityManagerInterface final
    : public ServiceFramework<IVulnerabilityManagerInterface> {
public:
    explicit IVulnerabilityManagerInterface(Core::System& system_);
    ~IVulnerabilityManagerInterface() override;

private:
    Result NeedsUpdateVulnerability(Out<bool> out_needs_update_vulnerability);
};

} // namespace Service::NS
