/*
 * Copyright (c) 2021, 2023-2024 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#include "arm_gemm.hpp"
#include <cstddef>
#include <cstdint>

#if defined(__aarch64__)

namespace arm_conv {
namespace depthwise {

void a64_u8q_packed_to_nhwc_5x5_s1_with_multiplier_output4x2_dot_depthfirst_impl(
  const uint8_t *const *const inptrs,
  uint8_t *const *const outptrs,
  const void *params,
  unsigned int n_output_channels,
  const arm_gemm::Requantize32& qp
)
{
  __asm__ __volatile__(
    "ldr q22, [%x[params], #0x0]\n"
    "ldr q8, [%x[params], #0x10]\n"
    "movi v23.16b, #0x1\n"
    "movi v19.4s, #0x0\n"
    "ldr q9, [%x[params], #0x20]\n"
    "ldr q10, [%x[params], #0x30]\n"
    "movi v13.4s, #0x0\n"
    "movi v15.4s, #0x0\n"
    "ldr q11, [%x[params], #0x40]\n"
    "ldr x20, [%x[inptrs], #0x18]\n"
    "movi v31.4s, #0x0\n"
    "movi v28.4s, #0x0\n"
    "ldr x24, [%x[inptrs], #0x20]\n"
    "ldr x23, [%x[inptrs], #0x10]\n"
    "movi v29.4s, #0x0\n"
    "movi v25.4s, #0x1\n"
    "ldr x22, [%x[inptrs], #0x8]\n"
    "ldr x21, [%x[inptrs], #0x28]\n"
    "movi v21.4s, #0x0\n"
    "movi v16.4s, #0x0\n"
    "ld1 { v3.16b }, [x20]\n"
    "ldr x20, [%x[inptrs], #0x30]\n"
    "movi v26.4s, #0x0\n"
    "movi v27.4s, #0x0\n"
    "ld1 { v4.16b }, [x24]\n"
    "ld1 { v2.16b }, [x23]\n"
    "movi v30.4s, #0x0\n"
    "movi v20.4s, #0x0\n"
    "ld1 { v1.16b }, [x22]\n"
    "ld1 { v5.16b }, [x21]\n"
    "movi v17.4s, #0x0\n"
    "movi v18.4s, #0x0\n"
    "ld1 { v6.16b }, [x20]\n"
    "mov v7.16b, v3.16b\n"
    "ldr x22, [%x[inptrs], #0x38]\n"
    "movi v24.4s, #0x0\n"
    "mov v0.16b, v4.16b\n"
    "ldr x21, [%x[inptrs], #0x0]\n"
    "mov v14.16b, v2.16b\n"
    "add x20, %x[qp], %[offsetof_Requantize32_b_offset]\n"
    "ld1r { v12.4s }, [x20]\n"
    "ext v7.16b, v7.16b, v7.16b, #0x1\n"
    "add x20, %x[qp], %[offsetof_Requantize32_c_offset]\n"
    "add x11, %x[qp], %[offsetof_Requantize32_minval]\n"
    "ext v0.16b, v0.16b, v0.16b, #0x1\n"
    "ext v14.16b, v14.16b, v14.16b, #0x1\n"
    "add x10, %x[qp], %[offsetof_Requantize32_maxval]\n"
    "cmp %x[n_channels], #0x4\n"
    "mov x9, #0x0\n"
    "mov x28, #0x0\n"
    "ldp x27, x26, [%x[outptrs], #0x0]\n"
    "ldp x25, x24, [%x[outptrs], #0x10]\n"
    "zip1 v3.2d, v3.2d, v7.2d\n"
    "ld1 { v7.16b }, [x22]\n"
    "neg v12.4s, v12.4s\n"
    "ldp x23, x22, [%x[outptrs], #0x20]\n"
    "zip1 v4.2d, v4.2d, v0.2d\n"
    "ld1 { v0.16b }, [x21]\n"
    "zip1 v2.2d, v2.2d, v14.2d\n"
    "ld1r { v14.4s }, [x20]\n"
    "ldp x21, x20, [%x[outptrs], #0x30]\n"
    "add %x[params], %x[params], #0x50\n"
    ".inst 0x6f83e2f3  // udot v19.4s, v23.16b, v3.4b[0]\n"
    ".inst 0x6f83eaed  // udot v13.4s, v23.16b, v3.4b[2]\n"
    ".inst 0x6f84e2ef  // udot v15.4s, v23.16b, v4.4b[0]\n"
    ".inst 0x6f84eaff  // udot v31.4s, v23.16b, v4.4b[2]\n"
    ".inst 0x6f82e2fc  // udot v28.4s, v23.16b, v2.4b[0]\n"
    ".inst 0x6f82eafd  // udot v29.4s, v23.16b, v2.4b[2]\n"
    ".inst 0x6fa3e333  // udot v19.4s, v25.16b, v3.4b[1]\n"
    ".inst 0x6fa3eb2d  // udot v13.4s, v25.16b, v3.4b[3]\n"
    ".inst 0x6fa4e32f  // udot v15.4s, v25.16b, v4.4b[1]\n"
    ".inst 0x6fa4eb3f  // udot v31.4s, v25.16b, v4.4b[3]\n"
    ".inst 0x6fa2e33c  // udot v28.4s, v25.16b, v2.4b[1]\n"
    ".inst 0x6fa2eb3d  // udot v29.4s, v25.16b, v2.4b[3]\n"
    "add v19.4s, v19.4s, v15.4s\n"
    "ld1r { v15.4s }, [x11]\n"
    "add v31.4s, v13.4s, v31.4s\n"
    "mov v13.16b, v1.16b\n"
    "ext v13.16b, v13.16b, v13.16b, #0x1\n"
    "add v28.4s, v28.4s, v19.4s\n"
    "add v29.4s, v29.4s, v31.4s\n"
    "zip1 v1.2d, v1.2d, v13.2d\n"
    "mov v13.16b, v5.16b\n"
    "ext v13.16b, v13.16b, v13.16b, #0x1\n"
    ".inst 0x6f81e2f5  // udot v21.4s, v23.16b, v1.4b[0]\n"
    ".inst 0x6f81eaf0  // udot v16.4s, v23.16b, v1.4b[2]\n"
    "zip1 v5.2d, v5.2d, v13.2d\n"
    "mov v13.16b, v6.16b\n"
    "ext v13.16b, v13.16b, v13.16b, #0x1\n"
    ".inst 0x6f85e2fa  // udot v26.4s, v23.16b, v5.4b[0]\n"
    ".inst 0x6f85eafb  // udot v27.4s, v23.16b, v5.4b[2]\n"
    ".inst 0x6fa1e335  // udot v21.4s, v25.16b, v1.4b[1]\n"
    "zip1 v6.2d, v6.2d, v13.2d\n"
    "mov v13.16b, v7.16b\n"
    ".inst 0x6fa1eb30  // udot v16.4s, v25.16b, v1.4b[3]\n"
    "ext v13.16b, v13.16b, v13.16b, #0x1\n"
    ".inst 0x6f86e2fe  // udot v30.4s, v23.16b, v6.4b[0]\n"
    ".inst 0x6f86eaf4  // udot v20.4s, v23.16b, v6.4b[2]\n"
    ".inst 0x6fa5e33a  // udot v26.4s, v25.16b, v5.4b[1]\n"
    ".inst 0x6fa5eb3b  // udot v27.4s, v25.16b, v5.4b[3]\n"
    "add v21.4s, v21.4s, v28.4s\n"
    "zip1 v7.2d, v7.2d, v13.2d\n"
    "ld1r { v13.4s }, [x10]\n"
    "add v16.4s, v16.4s, v29.4s\n"
    ".inst 0x6fa6e33e  // udot v30.4s, v25.16b, v6.4b[1]\n"
    ".inst 0x6fa6eb34  // udot v20.4s, v25.16b, v6.4b[3]\n"
    ".inst 0x6f87e2f1  // udot v17.4s, v23.16b, v7.4b[0]\n"
    ".inst 0x6f87eaf2  // udot v18.4s, v23.16b, v7.4b[2]\n"
    "add v30.4s, v26.4s, v30.4s\n"
    "add v26.4s, v26.4s, v21.4s\n"
    ".inst 0x6fa7e331  // udot v17.4s, v25.16b, v7.4b[1]\n"
    "add v20.4s, v27.4s, v20.4s\n"
    "add v27.4s, v27.4s, v16.4s\n"
    "add v28.4s, v30.4s, v28.4s\n"
    ".inst 0x6fa7eb32  // udot v18.4s, v25.16b, v7.4b[3]\n"
    "mul v26.4s, v26.4s, v12.4s\n"
    "add v19.4s, v17.4s, v19.4s\n"
    "mov v17.16b, v0.16b\n"
    "add v29.4s, v20.4s, v29.4s\n"
    "mul v27.4s, v27.4s, v12.4s\n"
    "mul v28.4s, v28.4s, v12.4s\n"
    "ext v17.16b, v17.16b, v17.16b, #0x1\n"
    "add v31.4s, v18.4s, v31.4s\n"
    "movi v18.4s, #0x0\n"
    "add v30.4s, v30.4s, v19.4s\n"
    "mul v29.4s, v29.4s, v12.4s\n"
    "zip1 v0.2d, v0.2d, v17.2d\n"
    "add v31.4s, v20.4s, v31.4s\n"
    "mul v30.4s, v30.4s, v12.4s\n"
    ".inst 0x6f80e2f8  // udot v24.4s, v23.16b, v0.4b[0]\n"
    ".inst 0x6f80eaf2  // udot v18.4s, v23.16b, v0.4b[2]\n"
    "mul v31.4s, v31.4s, v12.4s\n"
    "zip1 v17.4s, v28.4s, v30.4s\n"
    "add v28.4s, v28.4s, v22.4s\n"
    "add v30.4s, v30.4s, v22.4s\n"
    ".inst 0x6fa0e338  // udot v24.4s, v25.16b, v0.4b[1]\n"
    "zip1 v19.4s, v29.4s, v31.4s\n"
    "add v29.4s, v29.4s, v22.4s\n"
    ".inst 0x6fa0eb32  // udot v18.4s, v25.16b, v0.4b[3]\n"
    "add v31.4s, v31.4s, v22.4s\n"
    "add v24.4s, v21.4s, v24.4s\n"
    "zip1 v23.4s, v17.4s, v19.4s\n"
    "add v25.4s, v16.4s, v18.4s\n"
    "mul v24.4s, v24.4s, v12.4s\n"
    "mul v25.4s, v25.4s, v12.4s\n"
    "zip1 v17.4s, v24.4s, v26.4s\n"
    "add v26.4s, v26.4s, v22.4s\n"
    "zip1 v16.4s, v25.4s, v27.4s\n"
    "add v27.4s, v27.4s, v22.4s\n"
    "add v24.4s, v24.4s, v22.4s\n"
    "add v25.4s, v25.4s, v22.4s\n"
    "zip1 v22.4s, v17.4s, v16.4s\n"
    "ble 2f\n"
    "1:"  // Loop
    "ldr q12, [%x[params], #0x60]\n"
    "ldr q21, [%x[params], #0x70]\n"
    ".inst 0x6f80e118  // udot v24.4s, v8.16b, v0.4b[0]\n"
    ".inst 0x6f80e919  // udot v25.4s, v8.16b, v0.4b[2]\n"
    "ldr q20, [%x[params], #0x80]\n"
    ".inst 0x6f81e11a  // udot v26.4s, v8.16b, v1.4b[0]\n"
    ".inst 0x6f81e91b  // udot v27.4s, v8.16b, v1.4b[2]\n"
    "sub %x[n_channels], %x[n_channels], #0x4\n"
    ".inst 0x6f82e11c  // udot v28.4s, v8.16b, v2.4b[0]\n"
    ".inst 0x6f82e91d  // udot v29.4s, v8.16b, v2.4b[2]\n"
    "cmp %x[n_channels], #0x4\n"
    "add x9, x9, #0x10\n"
    ".inst 0x6f83e11e  // udot v30.4s, v8.16b, v3.4b[0]\n"
    ".inst 0x6f83e91f  // udot v31.4s, v8.16b, v3.4b[2]\n"
    "ldr q17, [%x[params], #0x0]\n"
    ".inst 0x6fa0e138  // udot v24.4s, v9.16b, v0.4b[1]\n"
    ".inst 0x6fa0e939  // udot v25.4s, v9.16b, v0.4b[3]\n"
    ".inst 0x6fa1e13a  // udot v26.4s, v9.16b, v1.4b[1]\n"
    ".inst 0x6fa1e93b  // udot v27.4s, v9.16b, v1.4b[3]\n"
    ".inst 0x6fa2e13c  // udot v28.4s, v9.16b, v2.4b[1]\n"
    ".inst 0x6fa2e93d  // udot v29.4s, v9.16b, v2.4b[3]\n"
    ".inst 0x6fa3e13e  // udot v30.4s, v9.16b, v3.4b[1]\n"
    ".inst 0x6fa3e93f  // udot v31.4s, v9.16b, v3.4b[3]\n"
    "ldr q16, [%x[params], #0x10]\n"
    ".inst 0x6f81e158  // udot v24.4s, v10.16b, v1.4b[0]\n"
    ".inst 0x6f81e959  // udot v25.4s, v10.16b, v1.4b[2]\n"
    ".inst 0x6f82e15a  // udot v26.4s, v10.16b, v2.4b[0]\n"
    ".inst 0x6f82e95b  // udot v27.4s, v10.16b, v2.4b[2]\n"
    ".inst 0x6f83e15c  // udot v28.4s, v10.16b, v3.4b[0]\n"
    ".inst 0x6f83e95d  // udot v29.4s, v10.16b, v3.4b[2]\n"
    ".inst 0x6f84e15e  // udot v30.4s, v10.16b, v4.4b[0]\n"
    ".inst 0x6f84e95f  // udot v31.4s, v10.16b, v4.4b[2]\n"
    "ldr q19, [%x[params], #0x20]\n"
    ".inst 0x6fa1e178  // udot v24.4s, v11.16b, v1.4b[1]\n"
    ".inst 0x6fa1e979  // udot v25.4s, v11.16b, v1.4b[3]\n"
    ".inst 0x6fa2e17a  // udot v26.4s, v11.16b, v2.4b[1]\n"
    ".inst 0x6fa2e97b  // udot v27.4s, v11.16b, v2.4b[3]\n"
    ".inst 0x6fa3e17c  // udot v28.4s, v11.16b, v3.4b[1]\n"
    ".inst 0x6fa3e97d  // udot v29.4s, v11.16b, v3.4b[3]\n"
    ".inst 0x6fa4e17e  // udot v30.4s, v11.16b, v4.4b[1]\n"
    ".inst 0x6fa4e97f  // udot v31.4s, v11.16b, v4.4b[3]\n"
    "ldr q18, [%x[params], #0x30]\n"
    ".inst 0x6f82e238  // udot v24.4s, v17.16b, v2.4b[0]\n"
    ".inst 0x6f82ea39  // udot v25.4s, v17.16b, v2.4b[2]\n"
    ".inst 0x6f83e23a  // udot v26.4s, v17.16b, v3.4b[0]\n"
    ".inst 0x6f83ea3b  // udot v27.4s, v17.16b, v3.4b[2]\n"
    ".inst 0x6f84e23c  // udot v28.4s, v17.16b, v4.4b[0]\n"
    ".inst 0x6f84ea3d  // udot v29.4s, v17.16b, v4.4b[2]\n"
    ".inst 0x6f85e23e  // udot v30.4s, v17.16b, v5.4b[0]\n"
    ".inst 0x6f85ea3f  // udot v31.4s, v17.16b, v5.4b[2]\n"
    "ldr q17, [%x[params], #0x40]\n"
    ".inst 0x6fa2e218  // udot v24.4s, v16.16b, v2.4b[1]\n"
    ".inst 0x6fa2ea19  // udot v25.4s, v16.16b, v2.4b[3]\n"
    ".inst 0x6fa3e21a  // udot v26.4s, v16.16b, v3.4b[1]\n"
    ".inst 0x6fa3ea1b  // udot v27.4s, v16.16b, v3.4b[3]\n"
    ".inst 0x6fa4e21c  // udot v28.4s, v16.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea1d  // udot v29.4s, v16.16b, v4.4b[3]\n"
    ".inst 0x6fa5e21e  // udot v30.4s, v16.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea1f  // udot v31.4s, v16.16b, v5.4b[3]\n"
    "ldr q16, [%x[params], #0x50]\n"
    ".inst 0x6f83e278  // udot v24.4s, v19.16b, v3.4b[0]\n"
    ".inst 0x6f83ea79  // udot v25.4s, v19.16b, v3.4b[2]\n"
    ".inst 0x6f84e27a  // udot v26.4s, v19.16b, v4.4b[0]\n"
    ".inst 0x6f84ea7b  // udot v27.4s, v19.16b, v4.4b[2]\n"
    ".inst 0x6f85e27c  // udot v28.4s, v19.16b, v5.4b[0]\n"
    ".inst 0x6f85ea7d  // udot v29.4s, v19.16b, v5.4b[2]\n"
    ".inst 0x6f86e27e  // udot v30.4s, v19.16b, v6.4b[0]\n"
    ".inst 0x6f86ea7f  // udot v31.4s, v19.16b, v6.4b[2]\n"
    "ldr q10, [%x[params], #0xb0]\n"
    ".inst 0x6fa3e258  // udot v24.4s, v18.16b, v3.4b[1]\n"
    ".inst 0x6fa3ea59  // udot v25.4s, v18.16b, v3.4b[3]\n"
    ".inst 0x6fa4e25a  // udot v26.4s, v18.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea5b  // udot v27.4s, v18.16b, v4.4b[3]\n"
    ".inst 0x6fa5e25c  // udot v28.4s, v18.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea5d  // udot v29.4s, v18.16b, v5.4b[3]\n"
    ".inst 0x6fa6e25e  // udot v30.4s, v18.16b, v6.4b[1]\n"
    ".inst 0x6fa6ea5f  // udot v31.4s, v18.16b, v6.4b[3]\n"
    "ldr q11, [%x[params], #0xc0]\n"
    ".inst 0x6f84e238  // udot v24.4s, v17.16b, v4.4b[0]\n"
    ".inst 0x6f84ea39  // udot v25.4s, v17.16b, v4.4b[2]\n"
    ".inst 0x6f85e23a  // udot v26.4s, v17.16b, v5.4b[0]\n"
    ".inst 0x6f85ea3b  // udot v27.4s, v17.16b, v5.4b[2]\n"
    ".inst 0x6f86e23c  // udot v28.4s, v17.16b, v6.4b[0]\n"
    ".inst 0x6f86ea3d  // udot v29.4s, v17.16b, v6.4b[2]\n"
    ".inst 0x6f87e23e  // udot v30.4s, v17.16b, v7.4b[0]\n"
    ".inst 0x6f87ea3f  // udot v31.4s, v17.16b, v7.4b[2]\n"
    "ldr q8, [%x[params], #0x90]\n"
    ".inst 0x6fa4e218  // udot v24.4s, v16.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea19  // udot v25.4s, v16.16b, v4.4b[3]\n"
    ".inst 0x6fa5e21a  // udot v26.4s, v16.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea1b  // udot v27.4s, v16.16b, v5.4b[3]\n"
    ".inst 0x6fa6e21c  // udot v28.4s, v16.16b, v6.4b[1]\n"
    ".inst 0x6fa6ea1d  // udot v29.4s, v16.16b, v6.4b[3]\n"
    ".inst 0x6fa7e21e  // udot v30.4s, v16.16b, v7.4b[1]\n"
    ".inst 0x6fa7ea1f  // udot v31.4s, v16.16b, v7.4b[3]\n"
    "ldr q9, [%x[params], #0xa0]\n"
    "add %x[params], %x[params], #0xd0\n"
    "sqrdmulh v24.4s, v24.4s, v12.4s\n"
    "sqrdmulh v25.4s, v25.4s, v12.4s\n"
    "sqrdmulh v26.4s, v26.4s, v12.4s\n"
    "sqrdmulh v27.4s, v27.4s, v12.4s\n"
    "sqrdmulh v28.4s, v28.4s, v12.4s\n"
    "sqrdmulh v29.4s, v29.4s, v12.4s\n"
    "and v19.16b, v24.16b, v21.16b\n"
    "and v18.16b, v25.16b, v21.16b\n"
    "and v17.16b, v26.16b, v21.16b\n"
    "and v16.16b, v27.16b, v21.16b\n"
    "sqrdmulh v30.4s, v30.4s, v12.4s\n"
    "sqrdmulh v31.4s, v31.4s, v12.4s\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v24.4s, v24.4s, v19.4s\n"
    "and v19.16b, v28.16b, v21.16b\n"
    "sqadd v25.4s, v25.4s, v18.4s\n"
    "and v18.16b, v29.16b, v21.16b\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "sqadd v27.4s, v27.4s, v16.4s\n"
    "and v17.16b, v30.16b, v21.16b\n"
    "and v16.16b, v31.16b, v21.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "srshl v24.4s, v24.4s, v21.4s\n"
    "srshl v25.4s, v25.4s, v21.4s\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v28.4s, v28.4s, v19.4s\n"
    "sqadd v29.4s, v29.4s, v18.4s\n"
    "srshl v26.4s, v26.4s, v21.4s\n"
    "srshl v27.4s, v27.4s, v21.4s\n"
    "sqadd v30.4s, v30.4s, v17.4s\n"
    "sqadd v31.4s, v31.4s, v16.4s\n"
    "srshl v28.4s, v28.4s, v21.4s\n"
    "srshl v29.4s, v29.4s, v21.4s\n"
    "add v24.4s, v24.4s, v14.4s\n"
    "add v25.4s, v25.4s, v14.4s\n"
    "srshl v30.4s, v30.4s, v21.4s\n"
    "srshl v31.4s, v31.4s, v21.4s\n"
    "add v26.4s, v26.4s, v14.4s\n"
    "add v27.4s, v27.4s, v14.4s\n"
    "add v28.4s, v28.4s, v14.4s\n"
    "add v29.4s, v29.4s, v14.4s\n"
    "add v30.4s, v30.4s, v14.4s\n"
    "add v31.4s, v31.4s, v14.4s\n"
    "smin v24.4s, v24.4s, v13.4s\n"
    "smin v25.4s, v25.4s, v13.4s\n"
    "smin v26.4s, v26.4s, v13.4s\n"
    "smin v27.4s, v27.4s, v13.4s\n"
    "smin v28.4s, v28.4s, v13.4s\n"
    "smin v29.4s, v29.4s, v13.4s\n"
    "smin v30.4s, v30.4s, v13.4s\n"
    "smin v31.4s, v31.4s, v13.4s\n"
    "smax v24.4s, v24.4s, v15.4s\n"
    "smax v25.4s, v25.4s, v15.4s\n"
    "smax v26.4s, v26.4s, v15.4s\n"
    "smax v27.4s, v27.4s, v15.4s\n"
    "smax v28.4s, v28.4s, v15.4s\n"
    "smax v29.4s, v29.4s, v15.4s\n"
    "smax v30.4s, v30.4s, v15.4s\n"
    "smax v31.4s, v31.4s, v15.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "str s24, [x27, x28]\n"
    "str s25, [x26, x28]\n"
    "dup v24.4s, v22.s[0]\n"
    "dup v25.4s, v22.s[1]\n"
    "str s26, [x25, x28]\n"
    "dup v26.4s, v22.s[2]\n"
    "str s27, [x24, x28]\n"
    "dup v27.4s, v22.s[3]\n"
    "add v24.4s, v24.4s, v20.4s\n"
    "str s28, [x23, x28]\n"
    "dup v28.4s, v23.s[0]\n"
    "add v25.4s, v25.4s, v20.4s\n"
    "str s29, [x22, x28]\n"
    "dup v29.4s, v23.s[1]\n"
    "add v26.4s, v26.4s, v20.4s\n"
    "str s30, [x21, x28]\n"
    "dup v30.4s, v23.s[2]\n"
    "add v27.4s, v27.4s, v20.4s\n"
    "str s31, [x20, x28]\n"
    "dup v31.4s, v23.s[3]\n"
    "add x28, x28, #0x4\n"
    "add v28.4s, v28.4s, v20.4s\n"
    "add v29.4s, v29.4s, v20.4s\n"
    "add v30.4s, v30.4s, v20.4s\n"
    "add v31.4s, v31.4s, v20.4s\n"
    "bgt 1b\n"
    "2:"  // Tail
    "ldr q21, [%x[params], #0x60]\n"
    "ldr q20, [%x[params], #0x70]\n"
    ".inst 0x6f80e118  // udot v24.4s, v8.16b, v0.4b[0]\n"
    ".inst 0x6f80e919  // udot v25.4s, v8.16b, v0.4b[2]\n"
    ".inst 0x6f81e11a  // udot v26.4s, v8.16b, v1.4b[0]\n"
    ".inst 0x6f81e91b  // udot v27.4s, v8.16b, v1.4b[2]\n"
    "cmp %x[n_channels], #0x4\n"
    "add x27, x27, x28\n"
    ".inst 0x6f82e11c  // udot v28.4s, v8.16b, v2.4b[0]\n"
    ".inst 0x6f82e91d  // udot v29.4s, v8.16b, v2.4b[2]\n"
    "add x26, x26, x28\n"
    "add x25, x25, x28\n"
    ".inst 0x6f83e11e  // udot v30.4s, v8.16b, v3.4b[0]\n"
    ".inst 0x6f83e91f  // udot v31.4s, v8.16b, v3.4b[2]\n"
    "ldr q17, [%x[params], #0x0]\n"
    "add x24, x24, x28\n"
    ".inst 0x6fa0e138  // udot v24.4s, v9.16b, v0.4b[1]\n"
    ".inst 0x6fa0e939  // udot v25.4s, v9.16b, v0.4b[3]\n"
    "add x23, x23, x28\n"
    "add x22, x22, x28\n"
    ".inst 0x6fa1e13a  // udot v26.4s, v9.16b, v1.4b[1]\n"
    ".inst 0x6fa1e93b  // udot v27.4s, v9.16b, v1.4b[3]\n"
    "add x21, x21, x28\n"
    "add x20, x20, x28\n"
    ".inst 0x6fa2e13c  // udot v28.4s, v9.16b, v2.4b[1]\n"
    ".inst 0x6fa2e93d  // udot v29.4s, v9.16b, v2.4b[3]\n"
    ".inst 0x6fa3e13e  // udot v30.4s, v9.16b, v3.4b[1]\n"
    ".inst 0x6fa3e93f  // udot v31.4s, v9.16b, v3.4b[3]\n"
    "ldr q16, [%x[params], #0x10]\n"
    ".inst 0x6f81e158  // udot v24.4s, v10.16b, v1.4b[0]\n"
    ".inst 0x6f81e959  // udot v25.4s, v10.16b, v1.4b[2]\n"
    ".inst 0x6f82e15a  // udot v26.4s, v10.16b, v2.4b[0]\n"
    ".inst 0x6f82e95b  // udot v27.4s, v10.16b, v2.4b[2]\n"
    ".inst 0x6f83e15c  // udot v28.4s, v10.16b, v3.4b[0]\n"
    ".inst 0x6f83e95d  // udot v29.4s, v10.16b, v3.4b[2]\n"
    ".inst 0x6f84e15e  // udot v30.4s, v10.16b, v4.4b[0]\n"
    ".inst 0x6f84e95f  // udot v31.4s, v10.16b, v4.4b[2]\n"
    "ldr q19, [%x[params], #0x20]\n"
    ".inst 0x6fa1e178  // udot v24.4s, v11.16b, v1.4b[1]\n"
    ".inst 0x6fa1e979  // udot v25.4s, v11.16b, v1.4b[3]\n"
    ".inst 0x6fa2e17a  // udot v26.4s, v11.16b, v2.4b[1]\n"
    ".inst 0x6fa2e97b  // udot v27.4s, v11.16b, v2.4b[3]\n"
    ".inst 0x6fa3e17c  // udot v28.4s, v11.16b, v3.4b[1]\n"
    ".inst 0x6fa3e97d  // udot v29.4s, v11.16b, v3.4b[3]\n"
    ".inst 0x6fa4e17e  // udot v30.4s, v11.16b, v4.4b[1]\n"
    ".inst 0x6fa4e97f  // udot v31.4s, v11.16b, v4.4b[3]\n"
    "ldr q18, [%x[params], #0x30]\n"
    ".inst 0x6f82e238  // udot v24.4s, v17.16b, v2.4b[0]\n"
    ".inst 0x6f82ea39  // udot v25.4s, v17.16b, v2.4b[2]\n"
    ".inst 0x6f83e23a  // udot v26.4s, v17.16b, v3.4b[0]\n"
    ".inst 0x6f83ea3b  // udot v27.4s, v17.16b, v3.4b[2]\n"
    ".inst 0x6f84e23c  // udot v28.4s, v17.16b, v4.4b[0]\n"
    ".inst 0x6f84ea3d  // udot v29.4s, v17.16b, v4.4b[2]\n"
    ".inst 0x6f85e23e  // udot v30.4s, v17.16b, v5.4b[0]\n"
    ".inst 0x6f85ea3f  // udot v31.4s, v17.16b, v5.4b[2]\n"
    "ldr q17, [%x[params], #0x40]\n"
    ".inst 0x6fa2e218  // udot v24.4s, v16.16b, v2.4b[1]\n"
    ".inst 0x6fa2ea19  // udot v25.4s, v16.16b, v2.4b[3]\n"
    ".inst 0x6fa3e21a  // udot v26.4s, v16.16b, v3.4b[1]\n"
    ".inst 0x6fa3ea1b  // udot v27.4s, v16.16b, v3.4b[3]\n"
    ".inst 0x6fa4e21c  // udot v28.4s, v16.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea1d  // udot v29.4s, v16.16b, v4.4b[3]\n"
    ".inst 0x6fa5e21e  // udot v30.4s, v16.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea1f  // udot v31.4s, v16.16b, v5.4b[3]\n"
    "ldr q16, [%x[params], #0x50]\n"
    "add %x[params], %x[params], #0x80\n"
    ".inst 0x6f83e278  // udot v24.4s, v19.16b, v3.4b[0]\n"
    ".inst 0x6f83ea79  // udot v25.4s, v19.16b, v3.4b[2]\n"
    ".inst 0x6f84e27a  // udot v26.4s, v19.16b, v4.4b[0]\n"
    ".inst 0x6f84ea7b  // udot v27.4s, v19.16b, v4.4b[2]\n"
    ".inst 0x6f85e27c  // udot v28.4s, v19.16b, v5.4b[0]\n"
    ".inst 0x6f85ea7d  // udot v29.4s, v19.16b, v5.4b[2]\n"
    ".inst 0x6f86e27e  // udot v30.4s, v19.16b, v6.4b[0]\n"
    ".inst 0x6f86ea7f  // udot v31.4s, v19.16b, v6.4b[2]\n"
    ".inst 0x6fa3e258  // udot v24.4s, v18.16b, v3.4b[1]\n"
    ".inst 0x6fa3ea59  // udot v25.4s, v18.16b, v3.4b[3]\n"
    ".inst 0x6fa4e25a  // udot v26.4s, v18.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea5b  // udot v27.4s, v18.16b, v4.4b[3]\n"
    ".inst 0x6fa5e25c  // udot v28.4s, v18.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea5d  // udot v29.4s, v18.16b, v5.4b[3]\n"
    ".inst 0x6fa6e25e  // udot v30.4s, v18.16b, v6.4b[1]\n"
    ".inst 0x6fa6ea5f  // udot v31.4s, v18.16b, v6.4b[3]\n"
    ".inst 0x6f84e238  // udot v24.4s, v17.16b, v4.4b[0]\n"
    ".inst 0x6f84ea39  // udot v25.4s, v17.16b, v4.4b[2]\n"
    ".inst 0x6f85e23a  // udot v26.4s, v17.16b, v5.4b[0]\n"
    ".inst 0x6f85ea3b  // udot v27.4s, v17.16b, v5.4b[2]\n"
    ".inst 0x6f86e23c  // udot v28.4s, v17.16b, v6.4b[0]\n"
    ".inst 0x6f86ea3d  // udot v29.4s, v17.16b, v6.4b[2]\n"
    ".inst 0x6f87e23e  // udot v30.4s, v17.16b, v7.4b[0]\n"
    ".inst 0x6f87ea3f  // udot v31.4s, v17.16b, v7.4b[2]\n"
    ".inst 0x6fa4e218  // udot v24.4s, v16.16b, v4.4b[1]\n"
    ".inst 0x6fa4ea19  // udot v25.4s, v16.16b, v4.4b[3]\n"
    ".inst 0x6fa5e21a  // udot v26.4s, v16.16b, v5.4b[1]\n"
    ".inst 0x6fa5ea1b  // udot v27.4s, v16.16b, v5.4b[3]\n"
    ".inst 0x6fa6e21c  // udot v28.4s, v16.16b, v6.4b[1]\n"
    ".inst 0x6fa6ea1d  // udot v29.4s, v16.16b, v6.4b[3]\n"
    ".inst 0x6fa7e21e  // udot v30.4s, v16.16b, v7.4b[1]\n"
    ".inst 0x6fa7ea1f  // udot v31.4s, v16.16b, v7.4b[3]\n"
    "sqrdmulh v24.4s, v24.4s, v21.4s\n"
    "sqrdmulh v25.4s, v25.4s, v21.4s\n"
    "sqrdmulh v26.4s, v26.4s, v21.4s\n"
    "sqrdmulh v27.4s, v27.4s, v21.4s\n"
    "and v19.16b, v24.16b, v20.16b\n"
    "sqrdmulh v28.4s, v28.4s, v21.4s\n"
    "sqrdmulh v29.4s, v29.4s, v21.4s\n"
    "and v18.16b, v25.16b, v20.16b\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "and v16.16b, v27.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sqrdmulh v30.4s, v30.4s, v21.4s\n"
    "sqrdmulh v31.4s, v31.4s, v21.4s\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v24.4s, v24.4s, v19.4s\n"
    "and v19.16b, v28.16b, v20.16b\n"
    "sqadd v25.4s, v25.4s, v18.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "and v18.16b, v29.16b, v20.16b\n"
    "sqadd v27.4s, v27.4s, v16.4s\n"
    "and v17.16b, v30.16b, v20.16b\n"
    "and v16.16b, v31.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "srshl v24.4s, v24.4s, v20.4s\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "srshl v25.4s, v25.4s, v20.4s\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v28.4s, v28.4s, v19.4s\n"
    "sqadd v29.4s, v29.4s, v18.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "sqadd v30.4s, v30.4s, v17.4s\n"
    "srshl v27.4s, v27.4s, v20.4s\n"
    "sqadd v31.4s, v31.4s, v16.4s\n"
    "srshl v28.4s, v28.4s, v20.4s\n"
    "srshl v29.4s, v29.4s, v20.4s\n"
    "add v24.4s, v24.4s, v14.4s\n"
    "srshl v30.4s, v30.4s, v20.4s\n"
    "add v25.4s, v25.4s, v14.4s\n"
    "srshl v31.4s, v31.4s, v20.4s\n"
    "add v26.4s, v26.4s, v14.4s\n"
    "add v27.4s, v27.4s, v14.4s\n"
    "add v28.4s, v28.4s, v14.4s\n"
    "add v29.4s, v29.4s, v14.4s\n"
    "add v30.4s, v30.4s, v14.4s\n"
    "add v31.4s, v31.4s, v14.4s\n"
    "smin v24.4s, v24.4s, v13.4s\n"
    "smin v25.4s, v25.4s, v13.4s\n"
    "smin v26.4s, v26.4s, v13.4s\n"
    "smin v27.4s, v27.4s, v13.4s\n"
    "smin v28.4s, v28.4s, v13.4s\n"
    "smin v29.4s, v29.4s, v13.4s\n"
    "smin v30.4s, v30.4s, v13.4s\n"
    "smin v31.4s, v31.4s, v13.4s\n"
    "smax v24.4s, v24.4s, v15.4s\n"
    "smax v25.4s, v25.4s, v15.4s\n"
    "smax v26.4s, v26.4s, v15.4s\n"
    "smax v27.4s, v27.4s, v15.4s\n"
    "smax v28.4s, v28.4s, v15.4s\n"
    "smax v29.4s, v29.4s, v15.4s\n"
    "smax v30.4s, v30.4s, v15.4s\n"
    "smax v31.4s, v31.4s, v15.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "blt 3f\n"
    "str s24, [x27, #0x0]\n"
    "str s25, [x26, #0x0]\n"
    "str s26, [x25, #0x0]\n"
    "str s27, [x24, #0x0]\n"
    "str s28, [x23, #0x0]\n"
    "str s29, [x22, #0x0]\n"
    "str s30, [x21, #0x0]\n"
    "str s31, [x20, #0x0]\n"
    "b 4f\n"
    "3:"  // Tail: Oddments
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[0], [x27], #0x1\n"
    "st1 { v25.b }[0], [x26], #0x1\n"
    "st1 { v26.b }[0], [x25], #0x1\n"
    "st1 { v27.b }[0], [x24], #0x1\n"
    "st1 { v28.b }[0], [x23], #0x1\n"
    "st1 { v29.b }[0], [x22], #0x1\n"
    "st1 { v30.b }[0], [x21], #0x1\n"
    "st1 { v31.b }[0], [x20], #0x1\n"
    "beq 4f\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[1], [x27], #0x1\n"
    "st1 { v25.b }[1], [x26], #0x1\n"
    "st1 { v26.b }[1], [x25], #0x1\n"
    "st1 { v27.b }[1], [x24], #0x1\n"
    "st1 { v28.b }[1], [x23], #0x1\n"
    "st1 { v29.b }[1], [x22], #0x1\n"
    "st1 { v30.b }[1], [x21], #0x1\n"
    "st1 { v31.b }[1], [x20], #0x1\n"
    "beq 4f\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[2], [x27], #0x1\n"
    "st1 { v25.b }[2], [x26], #0x1\n"
    "st1 { v26.b }[2], [x25], #0x1\n"
    "st1 { v27.b }[2], [x24], #0x1\n"
    "st1 { v28.b }[2], [x23], #0x1\n"
    "st1 { v29.b }[2], [x22], #0x1\n"
    "st1 { v30.b }[2], [x21], #0x1\n"
    "st1 { v31.b }[2], [x20], #0x1\n"
    "beq 4f\n"
    "st1 { v24.b }[3], [x27], #0x1\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v25.b }[3], [x26], #0x1\n"
    "st1 { v26.b }[3], [x25], #0x1\n"
    "st1 { v27.b }[3], [x24], #0x1\n"
    "st1 { v28.b }[3], [x23], #0x1\n"
    "st1 { v29.b }[3], [x22], #0x1\n"
    "st1 { v30.b }[3], [x21], #0x1\n"
    "st1 { v31.b }[3], [x20], #0x1\n"
    "4:"  // Tail: End
    : [n_channels] "+&r" (n_output_channels), [params] "+&r" (params)
    : [inptrs] "r" (inptrs), [offsetof_Requantize32_b_offset] "I" (offsetof(arm_gemm::Requantize32, b_offset)), [offsetof_Requantize32_c_offset] "I" (offsetof(arm_gemm::Requantize32, c_offset)), [offsetof_Requantize32_maxval] "I" (offsetof(arm_gemm::Requantize32, maxval)), [offsetof_Requantize32_minval] "I" (offsetof(arm_gemm::Requantize32, minval)), [outptrs] "r" (outptrs), [qp] "r" (&qp)
    : "cc", "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "x9", "x10", "x11", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(__aarch64__)
