{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetDropOffRate: Single;
    procedure SetDropOffRate(const Value: Single);
    function GetCutOffAngle: Single;
    procedure SetCutOffAngle(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdDirection: TSFVec3f;
    { Internal wrapper for property @link(Direction). This wrapper API may change, we advise to access simpler @link(Direction) instead. }
    public property FdDirection: TSFVec3f read FFdDirection;
    {  }
    property Direction: TVector3 read GetDirection write SetDirection;

    strict private FFdDropOffRate: TSFFloat;
    { Internal wrapper for property @link(DropOffRate). This wrapper API may change, we advise to access simpler @link(DropOffRate) instead. }
    public property FdDropOffRate: TSFFloat read FFdDropOffRate;
    {  }
    property DropOffRate: Single read GetDropOffRate write SetDropOffRate;

    strict private FFdCutOffAngle: TSFFloat;
    { Internal wrapper for property @link(CutOffAngle). This wrapper API may change, we advise to access simpler @link(CutOffAngle) instead. }
    public property FdCutOffAngle: TSFFloat read FFdCutOffAngle;
    {  }
    property CutOffAngle: Single read GetCutOffAngle write SetCutOffAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TSpotLightNode_1 ----------------------------------------------- }

function TSpotLightNode_1.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TSpotLightNode_1.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

function TSpotLightNode_1.GetDropOffRate: Single;
begin
  Result := FdDropOffRate.Value;
end;

procedure TSpotLightNode_1.SetDropOffRate(const Value: Single);
begin
  FdDropOffRate.Send(Value);
end;

function TSpotLightNode_1.GetCutOffAngle: Single;
begin
  Result := FdCutOffAngle.Value;
end;

procedure TSpotLightNode_1.SetCutOffAngle(const Value: Single);
begin
  FdCutOffAngle.Send(Value);
end;

class function TSpotLightNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TSpotLightNode_1.ClassX3DType: String;
begin
  Result := 'SpotLight';
end;

procedure TSpotLightNode_1.CreateNode;
begin
  inherited;

  FFdDirection := TSFVec3f.Create(Self, True, 'direction', Vector3(0, 0, -1));
   FdDirection.ChangeAlways := chLightLocationDirection;
  AddField(FFdDirection);

  FFdDropOffRate := TSFFloat.Create(Self, True, 'dropOffRate', 0);
   FdDropOffRate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDropOffRate);

  FFdCutOffAngle := TSFFloat.Create(Self, True, 'cutOffAngle', Pi/4);
   FdCutOffAngle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCutOffAngle);
end;

{$endif read_implementation}
