"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuContent = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const menu_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Menu/menu"));
const react_styles_1 = require("@patternfly/react-styles");
const MenuContext_1 = require("./MenuContext");
const c_menu__content_Height_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/c_menu__content_Height'));
const c_menu__content_MaxHeight_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/c_menu__content_MaxHeight'));
exports.MenuContent = (0, react_1.forwardRef)((props, ref) => {
    const { getHeight, children, menuHeight, maxMenuHeight } = props, rest = tslib_1.__rest(props, ["getHeight", "children", "menuHeight", "maxMenuHeight"]);
    const menuContentRef = (0, react_1.createRef)();
    const refCallback = (el, menuId, onGetMenuHeight) => {
        if (el) {
            let clientHeight = el.clientHeight;
            // if this menu is a submenu, we need to account for the root menu list's padding and root menu content's border.
            let rootMenuList = null;
            let parentEl = el.closest(`.${menu_1.default.menuList}`);
            while (parentEl !== null && parentEl.nodeType === 1) {
                if (parentEl.classList.contains(menu_1.default.menuList)) {
                    rootMenuList = parentEl;
                }
                parentEl = parentEl.parentElement;
            }
            if (rootMenuList) {
                const rootMenuListStyles = getComputedStyle(rootMenuList);
                const rootMenuListPaddingOffset = parseFloat(rootMenuListStyles.getPropertyValue('padding-top').replace(/px/g, '')) +
                    parseFloat(rootMenuListStyles.getPropertyValue('padding-bottom').replace(/px/g, '')) +
                    parseFloat(getComputedStyle(rootMenuList.parentElement).getPropertyValue('border-bottom-width').replace(/px/g, ''));
                clientHeight = clientHeight + rootMenuListPaddingOffset;
            }
            onGetMenuHeight && onGetMenuHeight(menuId, clientHeight);
            getHeight && getHeight(clientHeight.toString());
        }
        return ref || menuContentRef;
    };
    return ((0, jsx_runtime_1.jsx)(MenuContext_1.MenuContext.Consumer, { children: ({ menuId, onGetMenuHeight }) => ((0, jsx_runtime_1.jsx)("div", Object.assign({}, rest, { className: (0, react_styles_1.css)(menu_1.default.menuContent, props.className), ref: (el) => {
                refCallback(el, menuId, onGetMenuHeight);
            }, style: Object.assign(Object.assign({}, (menuHeight && { [c_menu__content_Height_1.default.name]: menuHeight })), (maxMenuHeight && { [c_menu__content_MaxHeight_1.default.name]: maxMenuHeight })), children: children }))) }));
});
exports.MenuContent.displayName = 'MenuContent';
//# sourceMappingURL=MenuContent.js.map