/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpresource_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_RESOURCE_PDB_H__
#define __GIMP_RESOURCE_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


G_GNUC_INTERNAL GimpResource* _gimp_resource_get_by_name        (const gchar   *type_name,
                                                                 const gchar   *resource_name);
G_GNUC_INTERNAL GimpResource* _gimp_resource_get_by_identifiers (const gchar   *type_name,
                                                                 const gchar   *resource_name,
                                                                 const gchar   *collection,
                                                                 gboolean       is_internal);
gboolean                      gimp_resource_id_is_valid         (gint           resource_id);
gboolean                      gimp_resource_id_is_brush         (gint           resource_id);
gboolean                      gimp_resource_id_is_pattern       (gint           resource_id);
gboolean                      gimp_resource_id_is_gradient      (gint           resource_id);
gboolean                      gimp_resource_id_is_palette       (gint           resource_id);
gboolean                      gimp_resource_id_is_font          (gint           resource_id);
gchar*                        gimp_resource_get_name            (GimpResource  *resource);
G_GNUC_INTERNAL gboolean      _gimp_resource_get_identifiers    (GimpResource  *resource,
                                                                 gchar        **name,
                                                                 gchar        **collection_id);
gboolean                      gimp_resource_is_editable         (GimpResource  *resource);
GimpResource*                 gimp_resource_duplicate           (GimpResource  *resource);
gboolean                      gimp_resource_rename              (GimpResource  *resource,
                                                                 const gchar   *new_name);
gboolean                      gimp_resource_delete              (GimpResource  *resource);


G_END_DECLS

#endif /* __GIMP_RESOURCE_PDB_H__ */
