// Code generated by smithy-go-codegen DO NOT EDIT.

package gamesparks

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/gamesparks/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deploys a snapshot to the stage and creates a new game runtime. After you call
// this operation, you can check the deployment status by using GetStageDeployment.
// If there are any players connected to the previous game runtime, then both
// runtimes persist. Existing connections to the previous runtime are maintained.
// When players disconnect and reconnect, they connect to the new runtime. After
// there are no connections to the previous game runtime, it is deleted.
func (c *Client) StartStageDeployment(ctx context.Context, params *StartStageDeploymentInput, optFns ...func(*Options)) (*StartStageDeploymentOutput, error) {
	if params == nil {
		params = &StartStageDeploymentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartStageDeployment", params, optFns, c.addOperationStartStageDeploymentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartStageDeploymentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartStageDeploymentInput struct {

	// The name of the game.
	//
	// This member is required.
	GameName *string

	// The identifier of the snapshot to deploy.
	//
	// This member is required.
	SnapshotId *string

	// The name of the stage to deploy the snapshot onto.
	//
	// This member is required.
	StageName *string

	// A client-defined token. With an active client token in the request, this action
	// is idempotent.
	ClientToken *string

	noSmithyDocumentSerde
}

type StartStageDeploymentOutput struct {

	// Properties that describe the stage deployment.
	StageDeployment *types.StageDeploymentDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartStageDeploymentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartStageDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartStageDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartStageDeploymentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartStageDeployment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartStageDeployment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "gamesparks",
		OperationName: "StartStageDeployment",
	}
}
