// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the metrics for the metric attribution.
func (c *Client) ListMetricAttributionMetrics(ctx context.Context, params *ListMetricAttributionMetricsInput, optFns ...func(*Options)) (*ListMetricAttributionMetricsOutput, error) {
	if params == nil {
		params = &ListMetricAttributionMetricsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMetricAttributionMetrics", params, optFns, c.addOperationListMetricAttributionMetricsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMetricAttributionMetricsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMetricAttributionMetricsInput struct {

	// The maximum number of metrics to return in one page of results.
	MaxResults *int32

	// The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes
	// for.
	MetricAttributionArn *string

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMetricAttributionMetricsOutput struct {

	// The metrics for the specified metric attribution.
	Metrics []types.MetricAttribute

	// Specify the pagination token from a previous
	// ListMetricAttributionMetricsResponse request to retrieve the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMetricAttributionMetricsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMetricAttributionMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMetricAttributionMetrics{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMetricAttributionMetrics"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMetricAttributionMetrics(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMetricAttributionMetricsPaginatorOptions is the paginator options for
// ListMetricAttributionMetrics
type ListMetricAttributionMetricsPaginatorOptions struct {
	// The maximum number of metrics to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMetricAttributionMetricsPaginator is a paginator for
// ListMetricAttributionMetrics
type ListMetricAttributionMetricsPaginator struct {
	options   ListMetricAttributionMetricsPaginatorOptions
	client    ListMetricAttributionMetricsAPIClient
	params    *ListMetricAttributionMetricsInput
	nextToken *string
	firstPage bool
}

// NewListMetricAttributionMetricsPaginator returns a new
// ListMetricAttributionMetricsPaginator
func NewListMetricAttributionMetricsPaginator(client ListMetricAttributionMetricsAPIClient, params *ListMetricAttributionMetricsInput, optFns ...func(*ListMetricAttributionMetricsPaginatorOptions)) *ListMetricAttributionMetricsPaginator {
	if params == nil {
		params = &ListMetricAttributionMetricsInput{}
	}

	options := ListMetricAttributionMetricsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMetricAttributionMetricsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMetricAttributionMetricsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMetricAttributionMetrics page.
func (p *ListMetricAttributionMetricsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMetricAttributionMetricsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMetricAttributionMetrics(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMetricAttributionMetricsAPIClient is a client that implements the
// ListMetricAttributionMetrics operation.
type ListMetricAttributionMetricsAPIClient interface {
	ListMetricAttributionMetrics(context.Context, *ListMetricAttributionMetricsInput, ...func(*Options)) (*ListMetricAttributionMetricsOutput, error)
}

var _ ListMetricAttributionMetricsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMetricAttributionMetrics(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMetricAttributionMetrics",
	}
}
