package operationalinsights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// BillingType enumerates the values for billing type.
type BillingType string

const (
	// BillingTypeCluster ...
	BillingTypeCluster BillingType = "Cluster"
	// BillingTypeWorkspaces ...
	BillingTypeWorkspaces BillingType = "Workspaces"
)

// PossibleBillingTypeValues returns an array of possible values for the BillingType const type.
func PossibleBillingTypeValues() []BillingType {
	return []BillingType{BillingTypeCluster, BillingTypeWorkspaces}
}

// ClusterEntityStatus enumerates the values for cluster entity status.
type ClusterEntityStatus string

const (
	// Canceled ...
	Canceled ClusterEntityStatus = "Canceled"
	// Creating ...
	Creating ClusterEntityStatus = "Creating"
	// Deleting ...
	Deleting ClusterEntityStatus = "Deleting"
	// Failed ...
	Failed ClusterEntityStatus = "Failed"
	// ProvisioningAccount ...
	ProvisioningAccount ClusterEntityStatus = "ProvisioningAccount"
	// Succeeded ...
	Succeeded ClusterEntityStatus = "Succeeded"
	// Updating ...
	Updating ClusterEntityStatus = "Updating"
)

// PossibleClusterEntityStatusValues returns an array of possible values for the ClusterEntityStatus const type.
func PossibleClusterEntityStatusValues() []ClusterEntityStatus {
	return []ClusterEntityStatus{Canceled, Creating, Deleting, Failed, ProvisioningAccount, Succeeded, Updating}
}

// ClusterSkuNameEnum enumerates the values for cluster sku name enum.
type ClusterSkuNameEnum string

const (
	// CapacityReservation ...
	CapacityReservation ClusterSkuNameEnum = "CapacityReservation"
)

// PossibleClusterSkuNameEnumValues returns an array of possible values for the ClusterSkuNameEnum const type.
func PossibleClusterSkuNameEnumValues() []ClusterSkuNameEnum {
	return []ClusterSkuNameEnum{CapacityReservation}
}

// DataIngestionStatus enumerates the values for data ingestion status.
type DataIngestionStatus string

const (
	// ApproachingQuota 80% of daily cap quota reached.
	ApproachingQuota DataIngestionStatus = "ApproachingQuota"
	// ForceOff Ingestion stopped following service setting change.
	ForceOff DataIngestionStatus = "ForceOff"
	// ForceOn Ingestion started following service setting change.
	ForceOn DataIngestionStatus = "ForceOn"
	// OverQuota Reached daily cap quota, ingestion stopped.
	OverQuota DataIngestionStatus = "OverQuota"
	// RespectQuota Ingestion enabled following daily cap quota reset, or subscription enablement.
	RespectQuota DataIngestionStatus = "RespectQuota"
	// SubscriptionSuspended Ingestion stopped following suspended subscription.
	SubscriptionSuspended DataIngestionStatus = "SubscriptionSuspended"
)

// PossibleDataIngestionStatusValues returns an array of possible values for the DataIngestionStatus const type.
func PossibleDataIngestionStatusValues() []DataIngestionStatus {
	return []DataIngestionStatus{ApproachingQuota, ForceOff, ForceOn, OverQuota, RespectQuota, SubscriptionSuspended}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// None ...
	None IdentityType = "None"
	// SystemAssigned ...
	SystemAssigned IdentityType = "SystemAssigned"
	// UserAssigned ...
	UserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{None, SystemAssigned, UserAssigned}
}

// PublicNetworkAccessType enumerates the values for public network access type.
type PublicNetworkAccessType string

const (
	// Disabled Disables public connectivity to Log Analytics through public DNS.
	Disabled PublicNetworkAccessType = "Disabled"
	// Enabled Enables connectivity to Log Analytics through public DNS.
	Enabled PublicNetworkAccessType = "Enabled"
)

// PossiblePublicNetworkAccessTypeValues returns an array of possible values for the PublicNetworkAccessType const type.
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return []PublicNetworkAccessType{Disabled, Enabled}
}

// WorkspaceEntityStatus enumerates the values for workspace entity status.
type WorkspaceEntityStatus string

const (
	// WorkspaceEntityStatusCanceled ...
	WorkspaceEntityStatusCanceled WorkspaceEntityStatus = "Canceled"
	// WorkspaceEntityStatusCreating ...
	WorkspaceEntityStatusCreating WorkspaceEntityStatus = "Creating"
	// WorkspaceEntityStatusDeleting ...
	WorkspaceEntityStatusDeleting WorkspaceEntityStatus = "Deleting"
	// WorkspaceEntityStatusFailed ...
	WorkspaceEntityStatusFailed WorkspaceEntityStatus = "Failed"
	// WorkspaceEntityStatusProvisioningAccount ...
	WorkspaceEntityStatusProvisioningAccount WorkspaceEntityStatus = "ProvisioningAccount"
	// WorkspaceEntityStatusSucceeded ...
	WorkspaceEntityStatusSucceeded WorkspaceEntityStatus = "Succeeded"
	// WorkspaceEntityStatusUpdating ...
	WorkspaceEntityStatusUpdating WorkspaceEntityStatus = "Updating"
)

// PossibleWorkspaceEntityStatusValues returns an array of possible values for the WorkspaceEntityStatus const type.
func PossibleWorkspaceEntityStatusValues() []WorkspaceEntityStatus {
	return []WorkspaceEntityStatus{WorkspaceEntityStatusCanceled, WorkspaceEntityStatusCreating, WorkspaceEntityStatusDeleting, WorkspaceEntityStatusFailed, WorkspaceEntityStatusProvisioningAccount, WorkspaceEntityStatusSucceeded, WorkspaceEntityStatusUpdating}
}

// WorkspaceSkuNameEnum enumerates the values for workspace sku name enum.
type WorkspaceSkuNameEnum string

const (
	// WorkspaceSkuNameEnumCapacityReservation ...
	WorkspaceSkuNameEnumCapacityReservation WorkspaceSkuNameEnum = "CapacityReservation"
	// WorkspaceSkuNameEnumFree ...
	WorkspaceSkuNameEnumFree WorkspaceSkuNameEnum = "Free"
	// WorkspaceSkuNameEnumLACluster ...
	WorkspaceSkuNameEnumLACluster WorkspaceSkuNameEnum = "LACluster"
	// WorkspaceSkuNameEnumPerGB2018 ...
	WorkspaceSkuNameEnumPerGB2018 WorkspaceSkuNameEnum = "PerGB2018"
	// WorkspaceSkuNameEnumPerNode ...
	WorkspaceSkuNameEnumPerNode WorkspaceSkuNameEnum = "PerNode"
	// WorkspaceSkuNameEnumPremium ...
	WorkspaceSkuNameEnumPremium WorkspaceSkuNameEnum = "Premium"
	// WorkspaceSkuNameEnumStandalone ...
	WorkspaceSkuNameEnumStandalone WorkspaceSkuNameEnum = "Standalone"
	// WorkspaceSkuNameEnumStandard ...
	WorkspaceSkuNameEnumStandard WorkspaceSkuNameEnum = "Standard"
)

// PossibleWorkspaceSkuNameEnumValues returns an array of possible values for the WorkspaceSkuNameEnum const type.
func PossibleWorkspaceSkuNameEnumValues() []WorkspaceSkuNameEnum {
	return []WorkspaceSkuNameEnum{WorkspaceSkuNameEnumCapacityReservation, WorkspaceSkuNameEnumFree, WorkspaceSkuNameEnumLACluster, WorkspaceSkuNameEnumPerGB2018, WorkspaceSkuNameEnumPerNode, WorkspaceSkuNameEnumPremium, WorkspaceSkuNameEnumStandalone, WorkspaceSkuNameEnumStandard}
}
