package storagesync

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/storagesync/mgmt/2019-06-01/storagesync"

// APIError error type
type APIError struct {
	// Code - Error code of the given entry.
	Code *string `json:"code,omitempty"`
	// Message - Error message of the given entry.
	Message *string `json:"message,omitempty"`
	// Target - Target of the given error entry.
	Target *string `json:"target,omitempty"`
	// Details - Error details of the given entry.
	Details *ErrorDetails `json:"details,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BackupRequest backup request
type BackupRequest struct {
	// AzureFileShare - Azure File Share.
	AzureFileShare *string `json:"azureFileShare,omitempty"`
}

// CheckNameAvailabilityParameters parameters for a check name availability request.
type CheckNameAvailabilityParameters struct {
	// Name - The name to check for availability
	Name *string `json:"name,omitempty"`
	// Type - The resource type. Must be set to Microsoft.StorageSync/storageSyncServices
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; Gets the reason that a Storage Sync Service name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'Invalid', 'AlreadyExists'
	Reason NameAvailabilityReason `json:"reason,omitempty"`
	// Message - READ-ONLY; Gets an error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudEndpoint cloud Endpoint object.
type CloudEndpoint struct {
	autorest.Response `json:"-"`
	// CloudEndpointProperties - Cloud Endpoint properties.
	*CloudEndpointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudEndpoint.
func (ce CloudEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CloudEndpointProperties != nil {
		objectMap["properties"] = ce.CloudEndpointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudEndpoint struct.
func (ce *CloudEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudEndpointProperties CloudEndpointProperties
				err = json.Unmarshal(*v, &cloudEndpointProperties)
				if err != nil {
					return err
				}
				ce.CloudEndpointProperties = &cloudEndpointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		}
	}

	return nil
}

// CloudEndpointArray array of CloudEndpoint
type CloudEndpointArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of CloudEndpoint.
	Value *[]CloudEndpoint `json:"value,omitempty"`
}

// CloudEndpointCreateParameters the parameters used when creating a cloud endpoint.
type CloudEndpointCreateParameters struct {
	// CloudEndpointCreateParametersProperties - The parameters used to create the cloud endpoint.
	*CloudEndpointCreateParametersProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudEndpointCreateParameters.
func (cecp CloudEndpointCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cecp.CloudEndpointCreateParametersProperties != nil {
		objectMap["properties"] = cecp.CloudEndpointCreateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CloudEndpointCreateParameters struct.
func (cecp *CloudEndpointCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cloudEndpointCreateParametersProperties CloudEndpointCreateParametersProperties
				err = json.Unmarshal(*v, &cloudEndpointCreateParametersProperties)
				if err != nil {
					return err
				}
				cecp.CloudEndpointCreateParametersProperties = &cloudEndpointCreateParametersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cecp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cecp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cecp.Type = &typeVar
			}
		}
	}

	return nil
}

// CloudEndpointCreateParametersProperties cloudEndpoint Properties object.
type CloudEndpointCreateParametersProperties struct {
	// StorageAccountResourceID - Storage Account Resource Id
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// AzureFileShareName - Azure file share name
	AzureFileShareName *string `json:"azureFileShareName,omitempty"`
	// StorageAccountTenantID - Storage Account Tenant Id
	StorageAccountTenantID *string `json:"storageAccountTenantId,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// CloudEndpointProperties cloudEndpoint Properties object.
type CloudEndpointProperties struct {
	// StorageAccountResourceID - Storage Account Resource Id
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
	// AzureFileShareName - Azure file share name
	AzureFileShareName *string `json:"azureFileShareName,omitempty"`
	// StorageAccountTenantID - Storage Account Tenant Id
	StorageAccountTenantID *string `json:"storageAccountTenantId,omitempty"`
	// PartnershipID - Partnership Id
	PartnershipID *string `json:"partnershipId,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupEnabled - READ-ONLY; Backup Enabled
	BackupEnabled *string `json:"backupEnabled,omitempty"`
	// ProvisioningState - CloudEndpoint Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// LastWorkflowID - CloudEndpoint lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty"`
	// LastOperationName - Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudEndpointProperties.
func (cep CloudEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cep.StorageAccountResourceID != nil {
		objectMap["storageAccountResourceId"] = cep.StorageAccountResourceID
	}
	if cep.AzureFileShareName != nil {
		objectMap["azureFileShareName"] = cep.AzureFileShareName
	}
	if cep.StorageAccountTenantID != nil {
		objectMap["storageAccountTenantId"] = cep.StorageAccountTenantID
	}
	if cep.PartnershipID != nil {
		objectMap["partnershipId"] = cep.PartnershipID
	}
	if cep.FriendlyName != nil {
		objectMap["friendlyName"] = cep.FriendlyName
	}
	if cep.ProvisioningState != nil {
		objectMap["provisioningState"] = cep.ProvisioningState
	}
	if cep.LastWorkflowID != nil {
		objectMap["lastWorkflowId"] = cep.LastWorkflowID
	}
	if cep.LastOperationName != nil {
		objectMap["lastOperationName"] = cep.LastOperationName
	}
	return json.Marshal(objectMap)
}

// CloudEndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudEndpointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (CloudEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsCreateFuture.Result.
func (future *CloudEndpointsCreateFuture) result(client CloudEndpointsClient) (ce CloudEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ce.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ce.Response.Response, err = future.GetResult(sender); err == nil && ce.Response.Response.StatusCode != http.StatusNoContent {
		ce, err = client.CreateResponder(ce.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsCreateFuture", "Result", ce.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CloudEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsDeleteFuture.Result.
func (future *CloudEndpointsDeleteFuture) result(client CloudEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudEndpointsPostBackupFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudEndpointsPostBackupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (PostBackupResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsPostBackupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsPostBackupFuture.Result.
func (future *CloudEndpointsPostBackupFuture) result(client CloudEndpointsClient) (pbr PostBackupResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsPostBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pbr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsPostBackupFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pbr.Response.Response, err = future.GetResult(sender); err == nil && pbr.Response.Response.StatusCode != http.StatusNoContent {
		pbr, err = client.PostBackupResponder(pbr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsPostBackupFuture", "Result", pbr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CloudEndpointsPostRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudEndpointsPostRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsPostRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsPostRestoreFuture.Result.
func (future *CloudEndpointsPostRestoreFuture) result(client CloudEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsPostRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsPostRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudEndpointsPreBackupFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CloudEndpointsPreBackupFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsPreBackupFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsPreBackupFuture.Result.
func (future *CloudEndpointsPreBackupFuture) result(client CloudEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsPreBackupFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsPreBackupFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudEndpointsPreRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudEndpointsPreRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsPreRestoreFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsPreRestoreFuture.Result.
func (future *CloudEndpointsPreRestoreFuture) result(client CloudEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsPreRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsPreRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CloudEndpointsTriggerChangeDetectionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type CloudEndpointsTriggerChangeDetectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CloudEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CloudEndpointsTriggerChangeDetectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CloudEndpointsTriggerChangeDetectionFuture.Result.
func (future *CloudEndpointsTriggerChangeDetectionFuture) result(client CloudEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.CloudEndpointsTriggerChangeDetectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.CloudEndpointsTriggerChangeDetectionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Error error type
type Error struct {
	// Error - Error details of the given entry.
	Error *APIError `json:"error,omitempty"`
	// Innererror - Error details of the given entry.
	Innererror *APIError `json:"innererror,omitempty"`
}

// ErrorDetails error Details object.
type ErrorDetails struct {
	// Code - Error code of the given entry.
	Code *string `json:"code,omitempty"`
	// Message - Error message of the given entry.
	Message *string `json:"message,omitempty"`
	// Target - Target of the given entry.
	Target *string `json:"target,omitempty"`
}

// OperationDisplayInfo the operation supported by storage sync.
type OperationDisplayInfo struct {
	// Description - The description of the operation.
	Description *string `json:"description,omitempty"`
	// Operation - The action that users can perform, based on their permission level.
	Operation *string `json:"operation,omitempty"`
	// Provider - Service provider: Microsoft StorageSync.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationDisplayResource operation Display Resource object.
type OperationDisplayResource struct {
	// Provider - Operation Display Resource Provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Operation Display Resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation Display Resource Operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation Display Resource Description.
	Description *string `json:"description,omitempty"`
}

// OperationEntity the operation supported by storage sync.
type OperationEntity struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The operation supported by storage sync.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// Origin - The origin.
	Origin *string `json:"origin,omitempty"`
}

// OperationEntityListResult the list of storage sync operations.
type OperationEntityListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of operations.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - The list of operations.
	Value *[]OperationEntity `json:"value,omitempty"`
}

// OperationEntityListResultIterator provides access to a complete listing of OperationEntity values.
type OperationEntityListResultIterator struct {
	i    int
	page OperationEntityListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationEntityListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationEntityListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationEntityListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationEntityListResultIterator) Response() OperationEntityListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationEntityListResultIterator) Value() OperationEntity {
	if !iter.page.NotDone() {
		return OperationEntity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationEntityListResultIterator type.
func NewOperationEntityListResultIterator(page OperationEntityListResultPage) OperationEntityListResultIterator {
	return OperationEntityListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oelr OperationEntityListResult) IsEmpty() bool {
	return oelr.Value == nil || len(*oelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oelr OperationEntityListResult) hasNextLink() bool {
	return oelr.NextLink != nil && len(*oelr.NextLink) != 0
}

// operationEntityListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oelr OperationEntityListResult) operationEntityListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !oelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oelr.NextLink)))
}

// OperationEntityListResultPage contains a page of OperationEntity values.
type OperationEntityListResultPage struct {
	fn   func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)
	oelr OperationEntityListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationEntityListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationEntityListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oelr)
		if err != nil {
			return err
		}
		page.oelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationEntityListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationEntityListResultPage) NotDone() bool {
	return !page.oelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationEntityListResultPage) Response() OperationEntityListResult {
	return page.oelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationEntityListResultPage) Values() []OperationEntity {
	if page.oelr.IsEmpty() {
		return nil
	}
	return *page.oelr.Value
}

// Creates a new instance of the OperationEntityListResultPage type.
func NewOperationEntityListResultPage(cur OperationEntityListResult, getNextPage func(context.Context, OperationEntityListResult) (OperationEntityListResult, error)) OperationEntityListResultPage {
	return OperationEntityListResultPage{
		fn:   getNextPage,
		oelr: cur,
	}
}

// OperationStatus operation status object
type OperationStatus struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; Operation Id
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Operation status
	Status *string `json:"status,omitempty"`
	// StartTime - READ-ONLY; Start time of the operation
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time of the operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - READ-ONLY; Error details.
	Error *APIError `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatus.
func (osVar OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PostBackupResponse post Backup Response
type PostBackupResponse struct {
	autorest.Response `json:"-"`
	// PostBackupResponseProperties - Post Backup Response Properties
	*PostBackupResponseProperties `json:"backupMetadata,omitempty"`
}

// MarshalJSON is the custom marshaler for PostBackupResponse.
func (pbr PostBackupResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pbr.PostBackupResponseProperties != nil {
		objectMap["backupMetadata"] = pbr.PostBackupResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PostBackupResponse struct.
func (pbr *PostBackupResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "backupMetadata":
			if v != nil {
				var postBackupResponseProperties PostBackupResponseProperties
				err = json.Unmarshal(*v, &postBackupResponseProperties)
				if err != nil {
					return err
				}
				pbr.PostBackupResponseProperties = &postBackupResponseProperties
			}
		}
	}

	return nil
}

// PostBackupResponseProperties post Backup Response Properties object.
type PostBackupResponseProperties struct {
	// CloudEndpointName - READ-ONLY; cloud endpoint Name.
	CloudEndpointName *string `json:"cloudEndpointName,omitempty"`
}

// MarshalJSON is the custom marshaler for PostBackupResponseProperties.
func (pbrp PostBackupResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PostRestoreRequest post Restore Request
type PostRestoreRequest struct {
	// Partition - Post Restore partition.
	Partition *string `json:"partition,omitempty"`
	// ReplicaGroup - Post Restore replica group.
	ReplicaGroup *string `json:"replicaGroup,omitempty"`
	// RequestID - Post Restore request id.
	RequestID *string `json:"requestId,omitempty"`
	// AzureFileShareURI - Post Restore Azure file share uri.
	AzureFileShareURI *string `json:"azureFileShareUri,omitempty"`
	// Status - Post Restore Azure status.
	Status *string `json:"status,omitempty"`
	// SourceAzureFileShareURI - Post Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string `json:"sourceAzureFileShareUri,omitempty"`
	// FailedFileList - Post Restore Azure failed file list.
	FailedFileList *string `json:"failedFileList,omitempty"`
	// RestoreFileSpec - Post Restore restore file spec array.
	RestoreFileSpec *[]RestoreFileSpec `json:"restoreFileSpec,omitempty"`
}

// PreRestoreRequest pre Restore request object.
type PreRestoreRequest struct {
	// Partition - Pre Restore partition.
	Partition *string `json:"partition,omitempty"`
	// ReplicaGroup - Pre Restore replica group.
	ReplicaGroup *string `json:"replicaGroup,omitempty"`
	// RequestID - Pre Restore request id.
	RequestID *string `json:"requestId,omitempty"`
	// AzureFileShareURI - Pre Restore Azure file share uri.
	AzureFileShareURI *string `json:"azureFileShareUri,omitempty"`
	// Status - Pre Restore Azure status.
	Status *string `json:"status,omitempty"`
	// SourceAzureFileShareURI - Pre Restore Azure source azure file share uri.
	SourceAzureFileShareURI *string `json:"sourceAzureFileShareUri,omitempty"`
	// BackupMetadataPropertyBag - Pre Restore backup metadata property bag.
	BackupMetadataPropertyBag *string `json:"backupMetadataPropertyBag,omitempty"`
	// RestoreFileSpec - Pre Restore restore file spec array.
	RestoreFileSpec *[]RestoreFileSpec `json:"restoreFileSpec,omitempty"`
	// PauseWaitForSyncDrainTimePeriodInSeconds - Pre Restore pause wait for sync drain time period in seconds.
	PauseWaitForSyncDrainTimePeriodInSeconds *int32 `json:"pauseWaitForSyncDrainTimePeriodInSeconds,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RecallActionParameters the parameters used when calling recall action on server endpoint.
type RecallActionParameters struct {
	// Pattern - Pattern of the files.
	Pattern *string `json:"pattern,omitempty"`
	// RecallPath - Recall path.
	RecallPath *string `json:"recallPath,omitempty"`
}

// RegisteredServer registered Server resource.
type RegisteredServer struct {
	autorest.Response `json:"-"`
	// RegisteredServerProperties - RegisteredServer properties.
	*RegisteredServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegisteredServer.
func (rs RegisteredServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rs.RegisteredServerProperties != nil {
		objectMap["properties"] = rs.RegisteredServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegisteredServer struct.
func (rs *RegisteredServer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registeredServerProperties RegisteredServerProperties
				err = json.Unmarshal(*v, &registeredServerProperties)
				if err != nil {
					return err
				}
				rs.RegisteredServerProperties = &registeredServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rs.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rs.Type = &typeVar
			}
		}
	}

	return nil
}

// RegisteredServerArray array of RegisteredServer
type RegisteredServerArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of Registered Server.
	Value *[]RegisteredServer `json:"value,omitempty"`
}

// RegisteredServerCreateParameters the parameters used when creating a registered server.
type RegisteredServerCreateParameters struct {
	// RegisteredServerCreateParametersProperties - The parameters used to create the registered server.
	*RegisteredServerCreateParametersProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RegisteredServerCreateParameters.
func (rscp RegisteredServerCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rscp.RegisteredServerCreateParametersProperties != nil {
		objectMap["properties"] = rscp.RegisteredServerCreateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegisteredServerCreateParameters struct.
func (rscp *RegisteredServerCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var registeredServerCreateParametersProperties RegisteredServerCreateParametersProperties
				err = json.Unmarshal(*v, &registeredServerCreateParametersProperties)
				if err != nil {
					return err
				}
				rscp.RegisteredServerCreateParametersProperties = &registeredServerCreateParametersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rscp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rscp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rscp.Type = &typeVar
			}
		}
	}

	return nil
}

// RegisteredServerCreateParametersProperties ...
type RegisteredServerCreateParametersProperties struct {
	// ServerCertificate - Registered Server Certificate
	ServerCertificate *string `json:"serverCertificate,omitempty"`
	// AgentVersion - Registered Server Agent Version
	AgentVersion *string `json:"agentVersion,omitempty"`
	// ServerOSVersion - Registered Server OS Version
	ServerOSVersion *string `json:"serverOSVersion,omitempty"`
	// LastHeartBeat - Registered Server last heart beat
	LastHeartBeat *string `json:"lastHeartBeat,omitempty"`
	// ServerRole - Registered Server serverRole
	ServerRole *string `json:"serverRole,omitempty"`
	// ClusterID - Registered Server clusterId
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterName - Registered Server clusterName
	ClusterName *string `json:"clusterName,omitempty"`
	// ServerID - Registered Server serverId
	ServerID *string `json:"serverId,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// RegisteredServerProperties registeredServer Properties object.
type RegisteredServerProperties struct {
	// ServerCertificate - Registered Server Certificate
	ServerCertificate *string `json:"serverCertificate,omitempty"`
	// AgentVersion - Registered Server Agent Version
	AgentVersion *string `json:"agentVersion,omitempty"`
	// ServerOSVersion - Registered Server OS Version
	ServerOSVersion *string `json:"serverOSVersion,omitempty"`
	// ServerManagementErrorCode - Registered Server Management Error Code
	ServerManagementErrorCode *int32 `json:"serverManagementErrorCode,omitempty"`
	// LastHeartBeat - Registered Server last heart beat
	LastHeartBeat *string `json:"lastHeartBeat,omitempty"`
	// ProvisioningState - Registered Server Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ServerRole - Registered Server serverRole
	ServerRole *string `json:"serverRole,omitempty"`
	// ClusterID - Registered Server clusterId
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterName - Registered Server clusterName
	ClusterName *string `json:"clusterName,omitempty"`
	// ServerID - Registered Server serverId
	ServerID *string `json:"serverId,omitempty"`
	// StorageSyncServiceUID - Registered Server storageSyncServiceUid
	StorageSyncServiceUID *string `json:"storageSyncServiceUid,omitempty"`
	// LastWorkflowID - Registered Server lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty"`
	// LastOperationName - Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty"`
	// DiscoveryEndpointURI - Resource discoveryEndpointUri
	DiscoveryEndpointURI *string `json:"discoveryEndpointUri,omitempty"`
	// ResourceLocation - Resource Location
	ResourceLocation *string `json:"resourceLocation,omitempty"`
	// ServiceLocation - Service Location
	ServiceLocation *string `json:"serviceLocation,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ManagementEndpointURI - Management Endpoint Uri
	ManagementEndpointURI *string `json:"managementEndpointUri,omitempty"`
	// MonitoringConfiguration - Monitoring Configuration
	MonitoringConfiguration *string `json:"monitoringConfiguration,omitempty"`
}

// RegisteredServersCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegisteredServersCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegisteredServersClient) (RegisteredServer, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegisteredServersCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegisteredServersCreateFuture.Result.
func (future *RegisteredServersCreateFuture) result(client RegisteredServersClient) (rs RegisteredServer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.RegisteredServersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		rs.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.RegisteredServersCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rs.Response.Response, err = future.GetResult(sender); err == nil && rs.Response.Response.StatusCode != http.StatusNoContent {
		rs, err = client.CreateResponder(rs.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagesync.RegisteredServersCreateFuture", "Result", rs.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegisteredServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegisteredServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegisteredServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegisteredServersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegisteredServersDeleteFuture.Result.
func (future *RegisteredServersDeleteFuture) result(client RegisteredServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.RegisteredServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.RegisteredServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegisteredServersTriggerRolloverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RegisteredServersTriggerRolloverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegisteredServersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegisteredServersTriggerRolloverFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegisteredServersTriggerRolloverFuture.Result.
func (future *RegisteredServersTriggerRolloverFuture) result(client RegisteredServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.RegisteredServersTriggerRolloverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.RegisteredServersTriggerRolloverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourcesMoveInfo resource Move Info.
type ResourcesMoveInfo struct {
	// TargetResourceGroup - Target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
	// Resources - Collection of Resources.
	Resources *[]string `json:"resources,omitempty"`
}

// RestoreFileSpec restore file spec.
type RestoreFileSpec struct {
	// Path - Restore file spec path
	Path *string `json:"path,omitempty"`
	// Isdir - Restore file spec isdir
	Isdir *bool `json:"isdir,omitempty"`
}

// ServerEndpoint server Endpoint object.
type ServerEndpoint struct {
	autorest.Response `json:"-"`
	// ServerEndpointProperties - Server Endpoint properties.
	*ServerEndpointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpoint.
func (se ServerEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.ServerEndpointProperties != nil {
		objectMap["properties"] = se.ServerEndpointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerEndpoint struct.
func (se *ServerEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverEndpointProperties ServerEndpointProperties
				err = json.Unmarshal(*v, &serverEndpointProperties)
				if err != nil {
					return err
				}
				se.ServerEndpointProperties = &serverEndpointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				se.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				se.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				se.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerEndpointArray array of ServerEndpoint
type ServerEndpointArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of ServerEndpoint.
	Value *[]ServerEndpoint `json:"value,omitempty"`
}

// ServerEndpointCloudTieringStatus server endpoint cloud tiering status object.
type ServerEndpointCloudTieringStatus struct {
	// Health - READ-ONLY; Cloud tiering health state. Possible values include: 'HealthHealthy', 'HealthError'
	Health Health `json:"health,omitempty"`
	// LastUpdatedTimestamp - READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *date.Time `json:"lastUpdatedTimestamp,omitempty"`
	// LastCloudTieringResult - READ-ONLY; Last cloud tiering result (HResult)
	LastCloudTieringResult *int32 `json:"lastCloudTieringResult,omitempty"`
	// LastSuccessTimestamp - READ-ONLY; Last cloud tiering success timestamp
	LastSuccessTimestamp *date.Time `json:"lastSuccessTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointCloudTieringStatus.
func (sects ServerEndpointCloudTieringStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointCreateParameters the parameters used when creating a server endpoint.
type ServerEndpointCreateParameters struct {
	// ServerEndpointCreateParametersProperties - The parameters used to create the server endpoint.
	*ServerEndpointCreateParametersProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointCreateParameters.
func (secp ServerEndpointCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if secp.ServerEndpointCreateParametersProperties != nil {
		objectMap["properties"] = secp.ServerEndpointCreateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerEndpointCreateParameters struct.
func (secp *ServerEndpointCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverEndpointCreateParametersProperties ServerEndpointCreateParametersProperties
				err = json.Unmarshal(*v, &serverEndpointCreateParametersProperties)
				if err != nil {
					return err
				}
				secp.ServerEndpointCreateParametersProperties = &serverEndpointCreateParametersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				secp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				secp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				secp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerEndpointCreateParametersProperties serverEndpoint Properties object.
type ServerEndpointCreateParametersProperties struct {
	// ServerLocalPath - Server Local path.
	ServerLocalPath *string `json:"serverLocalPath,omitempty"`
	// CloudTiering - Cloud Tiering. Possible values include: 'On', 'Off'
	CloudTiering CloudTiering `json:"cloudTiering,omitempty"`
	// VolumeFreeSpacePercent - Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`
	// TierFilesOlderThanDays - Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerResourceID - Server Resource Id.
	ServerResourceID *string `json:"serverResourceId,omitempty"`
	// OfflineDataTransfer - Offline data transfer. Possible values include: 'OfflineDataTransferOn', 'OfflineDataTransferOff'
	OfflineDataTransfer OfflineDataTransfer `json:"offlineDataTransfer,omitempty"`
	// OfflineDataTransferShareName - Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`
}

// ServerEndpointFilesNotSyncingError files not syncing error object
type ServerEndpointFilesNotSyncingError struct {
	// ErrorCode - READ-ONLY; Error code (HResult)
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// PersistentCount - READ-ONLY; Count of persistent files not syncing with the specified error code
	PersistentCount *int64 `json:"persistentCount,omitempty"`
	// TransientCount - READ-ONLY; Count of transient files not syncing with the specified error code
	TransientCount *int64 `json:"transientCount,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointFilesNotSyncingError.
func (sefnse ServerEndpointFilesNotSyncingError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointProperties serverEndpoint Properties object.
type ServerEndpointProperties struct {
	// ServerLocalPath - Server Local path.
	ServerLocalPath *string `json:"serverLocalPath,omitempty"`
	// CloudTiering - Cloud Tiering. Possible values include: 'CloudTiering2On', 'CloudTiering2Off'
	CloudTiering CloudTiering2 `json:"cloudTiering,omitempty"`
	// VolumeFreeSpacePercent - Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`
	// TierFilesOlderThanDays - Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`
	// FriendlyName - Friendly Name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ServerResourceID - Server Resource Id.
	ServerResourceID *string `json:"serverResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; ServerEndpoint Provisioning State
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// LastWorkflowID - READ-ONLY; ServerEndpoint lastWorkflowId
	LastWorkflowID *string `json:"lastWorkflowId,omitempty"`
	// LastOperationName - READ-ONLY; Resource Last Operation Name
	LastOperationName *string `json:"lastOperationName,omitempty"`
	// SyncStatus - READ-ONLY; Server Endpoint sync status
	SyncStatus *ServerEndpointSyncStatus `json:"syncStatus,omitempty"`
	// OfflineDataTransfer - Offline data transfer. Possible values include: 'OfflineDataTransfer2On', 'OfflineDataTransfer2Off'
	OfflineDataTransfer OfflineDataTransfer2 `json:"offlineDataTransfer,omitempty"`
	// OfflineDataTransferStorageAccountResourceID - READ-ONLY; Offline data transfer storage account resource ID
	OfflineDataTransferStorageAccountResourceID *string `json:"offlineDataTransferStorageAccountResourceId,omitempty"`
	// OfflineDataTransferStorageAccountTenantID - READ-ONLY; Offline data transfer storage account tenant ID
	OfflineDataTransferStorageAccountTenantID *string `json:"offlineDataTransferStorageAccountTenantId,omitempty"`
	// OfflineDataTransferShareName - Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`
	// CloudTieringStatus - READ-ONLY; Cloud tiering status. Only populated if cloud tiering is enabled.
	CloudTieringStatus *ServerEndpointCloudTieringStatus `json:"cloudTieringStatus,omitempty"`
	// RecallStatus - READ-ONLY; Recall status. Only populated if cloud tiering is enabled.
	RecallStatus *ServerEndpointRecallStatus `json:"recallStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointProperties.
func (sep ServerEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sep.ServerLocalPath != nil {
		objectMap["serverLocalPath"] = sep.ServerLocalPath
	}
	if sep.CloudTiering != "" {
		objectMap["cloudTiering"] = sep.CloudTiering
	}
	if sep.VolumeFreeSpacePercent != nil {
		objectMap["volumeFreeSpacePercent"] = sep.VolumeFreeSpacePercent
	}
	if sep.TierFilesOlderThanDays != nil {
		objectMap["tierFilesOlderThanDays"] = sep.TierFilesOlderThanDays
	}
	if sep.FriendlyName != nil {
		objectMap["friendlyName"] = sep.FriendlyName
	}
	if sep.ServerResourceID != nil {
		objectMap["serverResourceId"] = sep.ServerResourceID
	}
	if sep.OfflineDataTransfer != "" {
		objectMap["offlineDataTransfer"] = sep.OfflineDataTransfer
	}
	if sep.OfflineDataTransferShareName != nil {
		objectMap["offlineDataTransferShareName"] = sep.OfflineDataTransferShareName
	}
	return json.Marshal(objectMap)
}

// ServerEndpointRecallError server endpoint recall error object
type ServerEndpointRecallError struct {
	// ErrorCode - READ-ONLY; Error code (HResult)
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// Count - READ-ONLY; Count of occurences of the error
	Count *int64 `json:"count,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointRecallError.
func (sere ServerEndpointRecallError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointRecallStatus server endpoint recall status object.
type ServerEndpointRecallStatus struct {
	// LastUpdatedTimestamp - READ-ONLY; Last updated timestamp
	LastUpdatedTimestamp *date.Time `json:"lastUpdatedTimestamp,omitempty"`
	// TotalRecallErrorsCount - READ-ONLY; Total count of recall errors.
	TotalRecallErrorsCount *int64 `json:"totalRecallErrorsCount,omitempty"`
	// RecallErrors - READ-ONLY; Array of recall errors
	RecallErrors *[]ServerEndpointRecallError `json:"recallErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointRecallStatus.
func (sers ServerEndpointRecallStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerEndpointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerEndpointsClient) (ServerEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerEndpointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerEndpointsCreateFuture.Result.
func (future *ServerEndpointsCreateFuture) result(client ServerEndpointsClient) (se ServerEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		se.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.ServerEndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if se.Response.Response, err = future.GetResult(sender); err == nil && se.Response.Response.StatusCode != http.StatusNoContent {
		se, err = client.CreateResponder(se.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsCreateFuture", "Result", se.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerEndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerEndpointsDeleteFuture.Result.
func (future *ServerEndpointsDeleteFuture) result(client ServerEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.ServerEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerEndpointsRecallActionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerEndpointsRecallActionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerEndpointsRecallActionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerEndpointsRecallActionFuture.Result.
func (future *ServerEndpointsRecallActionFuture) result(client ServerEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsRecallActionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.ServerEndpointsRecallActionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerEndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerEndpointsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerEndpointsClient) (ServerEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ServerEndpointsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ServerEndpointsUpdateFuture.Result.
func (future *ServerEndpointsUpdateFuture) result(client ServerEndpointsClient) (se ServerEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		se.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("storagesync.ServerEndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if se.Response.Response, err = future.GetResult(sender); err == nil && se.Response.Response.StatusCode != http.StatusNoContent {
		se, err = client.UpdateResponder(se.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "storagesync.ServerEndpointsUpdateFuture", "Result", se.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerEndpointSyncActivityStatus sync Session status object.
type ServerEndpointSyncActivityStatus struct {
	// Timestamp - READ-ONLY; Timestamp when properties were updated
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// PerItemErrorCount - READ-ONLY; Per item error count
	PerItemErrorCount *int64 `json:"perItemErrorCount,omitempty"`
	// AppliedItemCount - READ-ONLY; Applied item count.
	AppliedItemCount *int64 `json:"appliedItemCount,omitempty"`
	// TotalItemCount - READ-ONLY; Total item count (if available)
	TotalItemCount *int64 `json:"totalItemCount,omitempty"`
	// AppliedBytes - READ-ONLY; Applied bytes
	AppliedBytes *int64 `json:"appliedBytes,omitempty"`
	// TotalBytes - READ-ONLY; Total bytes (if available)
	TotalBytes *int64 `json:"totalBytes,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointSyncActivityStatus.
func (sesas ServerEndpointSyncActivityStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointSyncSessionStatus sync Session status object.
type ServerEndpointSyncSessionStatus struct {
	// LastSyncResult - READ-ONLY; Last sync result (HResult)
	LastSyncResult *int32 `json:"lastSyncResult,omitempty"`
	// LastSyncTimestamp - READ-ONLY; Last sync timestamp
	LastSyncTimestamp *date.Time `json:"lastSyncTimestamp,omitempty"`
	// LastSyncSuccessTimestamp - READ-ONLY; Last sync success timestamp
	LastSyncSuccessTimestamp *date.Time `json:"lastSyncSuccessTimestamp,omitempty"`
	// LastSyncPerItemErrorCount - READ-ONLY; Last sync per item error count.
	LastSyncPerItemErrorCount *int64 `json:"lastSyncPerItemErrorCount,omitempty"`
	// PersistentFilesNotSyncingCount - READ-ONLY; Count of persistent files not syncing.
	PersistentFilesNotSyncingCount *int64 `json:"persistentFilesNotSyncingCount,omitempty"`
	// TransientFilesNotSyncingCount - READ-ONLY; Count of transient files not syncing.
	TransientFilesNotSyncingCount *int64 `json:"transientFilesNotSyncingCount,omitempty"`
	// FilesNotSyncingErrors - READ-ONLY; Array of per-item errors coming from the last sync session.
	FilesNotSyncingErrors *[]ServerEndpointFilesNotSyncingError `json:"filesNotSyncingErrors,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointSyncSessionStatus.
func (sesss ServerEndpointSyncSessionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointSyncStatus server Endpoint sync status
type ServerEndpointSyncStatus struct {
	// DownloadHealth - READ-ONLY; Download Health Status. Possible values include: 'DownloadHealthHealthy', 'DownloadHealthError', 'DownloadHealthSyncBlockedForRestore', 'DownloadHealthSyncBlockedForChangeDetectionPostRestore', 'DownloadHealthNoActivity'
	DownloadHealth DownloadHealth `json:"downloadHealth,omitempty"`
	// UploadHealth - READ-ONLY; Upload Health Status. Possible values include: 'UploadHealthHealthy', 'UploadHealthError', 'UploadHealthSyncBlockedForRestore', 'UploadHealthSyncBlockedForChangeDetectionPostRestore', 'UploadHealthNoActivity'
	UploadHealth UploadHealth `json:"uploadHealth,omitempty"`
	// CombinedHealth - READ-ONLY; Combined Health Status. Possible values include: 'CombinedHealthHealthy', 'CombinedHealthError', 'CombinedHealthSyncBlockedForRestore', 'CombinedHealthSyncBlockedForChangeDetectionPostRestore', 'CombinedHealthNoActivity'
	CombinedHealth CombinedHealth `json:"combinedHealth,omitempty"`
	// SyncActivity - READ-ONLY; Sync activity. Possible values include: 'Upload', 'Download', 'UploadAndDownload'
	SyncActivity SyncActivity `json:"syncActivity,omitempty"`
	// TotalPersistentFilesNotSyncingCount - READ-ONLY; Total count of persistent files not syncing (combined upload + download).
	TotalPersistentFilesNotSyncingCount *int64 `json:"totalPersistentFilesNotSyncingCount,omitempty"`
	// LastUpdatedTimestamp - READ-ONLY; Last Updated Timestamp
	LastUpdatedTimestamp *date.Time `json:"lastUpdatedTimestamp,omitempty"`
	// UploadStatus - READ-ONLY; Upload Status
	UploadStatus *ServerEndpointSyncSessionStatus `json:"uploadStatus,omitempty"`
	// DownloadStatus - READ-ONLY; Download Status
	DownloadStatus *ServerEndpointSyncSessionStatus `json:"downloadStatus,omitempty"`
	// UploadActivity - READ-ONLY; Upload sync activity
	UploadActivity *ServerEndpointSyncActivityStatus `json:"uploadActivity,omitempty"`
	// DownloadActivity - READ-ONLY; Download sync activity
	DownloadActivity *ServerEndpointSyncActivityStatus `json:"downloadActivity,omitempty"`
	// OfflineDataTransferStatus - READ-ONLY; Offline Data Transfer State. Possible values include: 'InProgress', 'Stopping', 'NotRunning', 'Complete'
	OfflineDataTransferStatus OfflineDataTransferStatus `json:"offlineDataTransferStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointSyncStatus.
func (sess ServerEndpointSyncStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServerEndpointUpdateParameters parameters for updating an Server Endpoint.
type ServerEndpointUpdateParameters struct {
	// ServerEndpointUpdateProperties - The properties of the server endpoint.
	*ServerEndpointUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerEndpointUpdateParameters.
func (seup ServerEndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if seup.ServerEndpointUpdateProperties != nil {
		objectMap["properties"] = seup.ServerEndpointUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerEndpointUpdateParameters struct.
func (seup *ServerEndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverEndpointUpdateProperties ServerEndpointUpdateProperties
				err = json.Unmarshal(*v, &serverEndpointUpdateProperties)
				if err != nil {
					return err
				}
				seup.ServerEndpointUpdateProperties = &serverEndpointUpdateProperties
			}
		}
	}

	return nil
}

// ServerEndpointUpdateProperties serverEndpoint Update Properties object.
type ServerEndpointUpdateProperties struct {
	// CloudTiering - Cloud Tiering. Possible values include: 'CloudTiering1On', 'CloudTiering1Off'
	CloudTiering CloudTiering1 `json:"cloudTiering,omitempty"`
	// VolumeFreeSpacePercent - Level of free space to be maintained by Cloud Tiering if it is enabled.
	VolumeFreeSpacePercent *int32 `json:"volumeFreeSpacePercent,omitempty"`
	// TierFilesOlderThanDays - Tier files older than days.
	TierFilesOlderThanDays *int32 `json:"tierFilesOlderThanDays,omitempty"`
	// OfflineDataTransfer - Offline data transfer. Possible values include: 'OfflineDataTransfer1On', 'OfflineDataTransfer1Off'
	OfflineDataTransfer OfflineDataTransfer1 `json:"offlineDataTransfer,omitempty"`
	// OfflineDataTransferShareName - Offline data transfer share name
	OfflineDataTransferShareName *string `json:"offlineDataTransferShareName,omitempty"`
}

// Service storage Sync Service object.
type Service struct {
	autorest.Response `json:"-"`
	// ServiceProperties - Storage Sync Service properties.
	*ServiceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceArray array of StorageSyncServices
type ServiceArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of StorageSyncServices.
	Value *[]Service `json:"value,omitempty"`
}

// ServiceCreateParameters the parameters used when creating a storage sync service.
type ServiceCreateParameters struct {
	// Location - Required. Gets or sets the location of the resource. This will be one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.). The geo region of a resource cannot be changed once it is created, but if an identical geo region is specified on update, the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - Gets or sets a list of key value pairs that describe the resource. These tags can be used for viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no greater than 128 characters and a value with a length no greater than 256 characters.
	Tags       map[string]*string `json:"tags"`
	Properties interface{}        `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceCreateParameters.
func (scp ServiceCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.Location != nil {
		objectMap["location"] = scp.Location
	}
	if scp.Tags != nil {
		objectMap["tags"] = scp.Tags
	}
	if scp.Properties != nil {
		objectMap["properties"] = scp.Properties
	}
	return json.Marshal(objectMap)
}

// ServiceProperties storage Sync Service Properties object.
type ServiceProperties struct {
	// StorageSyncServiceStatus - READ-ONLY; Storage Sync service status.
	StorageSyncServiceStatus *int32 `json:"storageSyncServiceStatus,omitempty"`
	// StorageSyncServiceUID - READ-ONLY; Storage Sync service Uid
	StorageSyncServiceUID *string `json:"storageSyncServiceUid,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ServiceUpdateParameters parameters for updating an Storage sync service.
type ServiceUpdateParameters struct {
	// Tags - The user-specified tags associated with the storage sync service.
	Tags map[string]*string `json:"tags"`
	// Properties - The properties of the storage sync service.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceUpdateParameters.
func (sup ServiceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sup.Tags != nil {
		objectMap["tags"] = sup.Tags
	}
	if sup.Properties != nil {
		objectMap["properties"] = sup.Properties
	}
	return json.Marshal(objectMap)
}

// SubscriptionState subscription State object.
type SubscriptionState struct {
	// State - State of Azure Subscription. Possible values include: 'Registered', 'Unregistered', 'Warned', 'Suspended', 'Deleted'
	State Reason `json:"state,omitempty"`
	// Istransitioning - READ-ONLY; Is Transitioning
	Istransitioning *bool `json:"istransitioning,omitempty"`
	// Properties - Subscription state properties.
	Properties interface{} `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionState.
func (ss SubscriptionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.State != "" {
		objectMap["state"] = ss.State
	}
	if ss.Properties != nil {
		objectMap["properties"] = ss.Properties
	}
	return json.Marshal(objectMap)
}

// SyncGroup sync Group object.
type SyncGroup struct {
	autorest.Response `json:"-"`
	// SyncGroupProperties - SyncGroup properties.
	*SyncGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroup.
func (sg SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SyncGroupProperties != nil {
		objectMap["properties"] = sg.SyncGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncGroup struct.
func (sg *SyncGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncGroupProperties SyncGroupProperties
				err = json.Unmarshal(*v, &syncGroupProperties)
				if err != nil {
					return err
				}
				sg.SyncGroupProperties = &syncGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncGroupArray array of SyncGroup
type SyncGroupArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of SyncGroup.
	Value *[]SyncGroup `json:"value,omitempty"`
}

// SyncGroupCreateParameters the parameters used when creating a sync group.
type SyncGroupCreateParameters struct {
	// Properties - The parameters used to create the sync group
	Properties interface{} `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroupCreateParameters.
func (sgcp SyncGroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgcp.Properties != nil {
		objectMap["properties"] = sgcp.Properties
	}
	return json.Marshal(objectMap)
}

// SyncGroupProperties syncGroup Properties object.
type SyncGroupProperties struct {
	// UniqueID - READ-ONLY; Unique Id
	UniqueID *string `json:"uniqueId,omitempty"`
	// SyncGroupStatus - READ-ONLY; Sync group status
	SyncGroupStatus *string `json:"syncGroupStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroupProperties.
func (sgp SyncGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TriggerChangeDetectionParameters the parameters used when calling trigger change detection action on
// cloud endpoint.
type TriggerChangeDetectionParameters struct {
	// DirectoryPath - Relative path to a directory Azure File share for which change detection is to be performed.
	DirectoryPath *string `json:"directoryPath,omitempty"`
	// ChangeDetectionMode - Change Detection Mode. Applies to a directory specified in directoryPath parameter. Possible values include: 'Default', 'Recursive'
	ChangeDetectionMode ChangeDetectionMode `json:"changeDetectionMode,omitempty"`
	// Paths - Array of relative paths on the Azure File share to be included in the change detection. Can be files and directories.
	Paths *[]string `json:"paths,omitempty"`
}

// TriggerRolloverRequest trigger Rollover Request.
type TriggerRolloverRequest struct {
	// ServerCertificate - Certificate Data
	ServerCertificate *string `json:"serverCertificate,omitempty"`
}

// Workflow workflow resource.
type Workflow struct {
	autorest.Response `json:"-"`
	// WorkflowProperties - Workflow properties.
	*WorkflowProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Workflow.
func (w Workflow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkflowProperties != nil {
		objectMap["properties"] = w.WorkflowProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workflow struct.
func (w *Workflow) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workflowProperties WorkflowProperties
				err = json.Unmarshal(*v, &workflowProperties)
				if err != nil {
					return err
				}
				w.WorkflowProperties = &workflowProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		}
	}

	return nil
}

// WorkflowArray array of Workflow
type WorkflowArray struct {
	autorest.Response `json:"-"`
	// Value - Collection of workflow items.
	Value *[]Workflow `json:"value,omitempty"`
}

// WorkflowProperties workflow Properties object.
type WorkflowProperties struct {
	// LastStepName - last step name
	LastStepName *string `json:"lastStepName,omitempty"`
	// Status - workflow status. Possible values include: 'Active', 'Expired', 'Succeeded', 'Aborted', 'Failed'
	Status Status `json:"status,omitempty"`
	// Operation - operation direction. Possible values include: 'Do', 'Undo', 'Cancel'
	Operation Operation `json:"operation,omitempty"`
	// Steps - workflow steps
	Steps *string `json:"steps,omitempty"`
	// LastOperationID - workflow last operation identifier.
	LastOperationID *string `json:"lastOperationId,omitempty"`
}
