//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/common/aws/v3/credential_provider.proto

package awsv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on AwsCredentialProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *AwsCredentialProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AwsCredentialProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AwsCredentialProviderMultiError, or nil if none found.
func (m *AwsCredentialProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *AwsCredentialProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAssumeRoleWithWebIdentity()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AwsCredentialProviderValidationError{
					field:  "AssumeRoleWithWebIdentity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AwsCredentialProviderValidationError{
					field:  "AssumeRoleWithWebIdentity",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAssumeRoleWithWebIdentity()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AwsCredentialProviderValidationError{
				field:  "AssumeRoleWithWebIdentity",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetInlineCredential()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AwsCredentialProviderValidationError{
					field:  "InlineCredential",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AwsCredentialProviderValidationError{
					field:  "InlineCredential",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetInlineCredential()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AwsCredentialProviderValidationError{
				field:  "InlineCredential",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AwsCredentialProviderMultiError(errors)
	}

	return nil
}

// AwsCredentialProviderMultiError is an error wrapping multiple validation
// errors returned by AwsCredentialProvider.ValidateAll() if the designated
// constraints aren't met.
type AwsCredentialProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AwsCredentialProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AwsCredentialProviderMultiError) AllErrors() []error { return m }

// AwsCredentialProviderValidationError is the validation error returned by
// AwsCredentialProvider.Validate if the designated constraints aren't met.
type AwsCredentialProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AwsCredentialProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AwsCredentialProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AwsCredentialProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AwsCredentialProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AwsCredentialProviderValidationError) ErrorName() string {
	return "AwsCredentialProviderValidationError"
}

// Error satisfies the builtin error interface
func (e AwsCredentialProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAwsCredentialProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AwsCredentialProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AwsCredentialProviderValidationError{}

// Validate checks the field values on InlineCredentialProvider with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *InlineCredentialProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on InlineCredentialProvider with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// InlineCredentialProviderMultiError, or nil if none found.
func (m *InlineCredentialProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *InlineCredentialProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetAccessKeyId()) < 1 {
		err := InlineCredentialProviderValidationError{
			field:  "AccessKeyId",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetSecretAccessKey()) < 1 {
		err := InlineCredentialProviderValidationError{
			field:  "SecretAccessKey",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for SessionToken

	if len(errors) > 0 {
		return InlineCredentialProviderMultiError(errors)
	}

	return nil
}

// InlineCredentialProviderMultiError is an error wrapping multiple validation
// errors returned by InlineCredentialProvider.ValidateAll() if the designated
// constraints aren't met.
type InlineCredentialProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m InlineCredentialProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m InlineCredentialProviderMultiError) AllErrors() []error { return m }

// InlineCredentialProviderValidationError is the validation error returned by
// InlineCredentialProvider.Validate if the designated constraints aren't met.
type InlineCredentialProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e InlineCredentialProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e InlineCredentialProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e InlineCredentialProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e InlineCredentialProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e InlineCredentialProviderValidationError) ErrorName() string {
	return "InlineCredentialProviderValidationError"
}

// Error satisfies the builtin error interface
func (e InlineCredentialProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sInlineCredentialProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = InlineCredentialProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = InlineCredentialProviderValidationError{}

// Validate checks the field values on
// AssumeRoleWithWebIdentityCredentialProvider with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *AssumeRoleWithWebIdentityCredentialProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// AssumeRoleWithWebIdentityCredentialProvider with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// AssumeRoleWithWebIdentityCredentialProviderMultiError, or nil if none found.
func (m *AssumeRoleWithWebIdentityCredentialProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *AssumeRoleWithWebIdentityCredentialProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetRoleArn()) < 1 {
		err := AssumeRoleWithWebIdentityCredentialProviderValidationError{
			field:  "RoleArn",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetWebIdentityToken()) < 1 {
		err := AssumeRoleWithWebIdentityCredentialProviderValidationError{
			field:  "WebIdentityToken",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AssumeRoleWithWebIdentityCredentialProviderMultiError(errors)
	}

	return nil
}

// AssumeRoleWithWebIdentityCredentialProviderMultiError is an error wrapping
// multiple validation errors returned by
// AssumeRoleWithWebIdentityCredentialProvider.ValidateAll() if the designated
// constraints aren't met.
type AssumeRoleWithWebIdentityCredentialProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AssumeRoleWithWebIdentityCredentialProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AssumeRoleWithWebIdentityCredentialProviderMultiError) AllErrors() []error { return m }

// AssumeRoleWithWebIdentityCredentialProviderValidationError is the validation
// error returned by AssumeRoleWithWebIdentityCredentialProvider.Validate if
// the designated constraints aren't met.
type AssumeRoleWithWebIdentityCredentialProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) ErrorName() string {
	return "AssumeRoleWithWebIdentityCredentialProviderValidationError"
}

// Error satisfies the builtin error interface
func (e AssumeRoleWithWebIdentityCredentialProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAssumeRoleWithWebIdentityCredentialProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AssumeRoleWithWebIdentityCredentialProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AssumeRoleWithWebIdentityCredentialProviderValidationError{}
