/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// Userset struct for Userset
type Userset struct {
	// A DirectUserset is a sentinel message for referencing the direct members specified by an object/relation mapping.
	This            *map[string]interface{} `json:"this,omitempty"yaml:"this,omitempty"`
	ComputedUserset *ObjectRelation         `json:"computedUserset,omitempty"yaml:"computedUserset,omitempty"`
	TupleToUserset  *TupleToUserset         `json:"tupleToUserset,omitempty"yaml:"tupleToUserset,omitempty"`
	Union           *Usersets               `json:"union,omitempty"yaml:"union,omitempty"`
	Intersection    *Usersets               `json:"intersection,omitempty"yaml:"intersection,omitempty"`
	Difference      *Difference             `json:"difference,omitempty"yaml:"difference,omitempty"`
}

// NewUserset instantiates a new Userset object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUserset() *Userset {
	this := Userset{}
	return &this
}

// NewUsersetWithDefaults instantiates a new Userset object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUsersetWithDefaults() *Userset {
	this := Userset{}
	return &this
}

// GetThis returns the This field value if set, zero value otherwise.
func (o *Userset) GetThis() map[string]interface{} {
	if o == nil || o.This == nil {
		var ret map[string]interface{}
		return ret
	}
	return *o.This
}

// GetThisOk returns a tuple with the This field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetThisOk() (*map[string]interface{}, bool) {
	if o == nil || o.This == nil {
		return nil, false
	}
	return o.This, true
}

// HasThis returns a boolean if a field has been set.
func (o *Userset) HasThis() bool {
	if o != nil && o.This != nil {
		return true
	}

	return false
}

// SetThis gets a reference to the given map[string]interface{} and assigns it to the This field.
func (o *Userset) SetThis(v map[string]interface{}) {
	o.This = &v
}

// GetComputedUserset returns the ComputedUserset field value if set, zero value otherwise.
func (o *Userset) GetComputedUserset() ObjectRelation {
	if o == nil || o.ComputedUserset == nil {
		var ret ObjectRelation
		return ret
	}
	return *o.ComputedUserset
}

// GetComputedUsersetOk returns a tuple with the ComputedUserset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetComputedUsersetOk() (*ObjectRelation, bool) {
	if o == nil || o.ComputedUserset == nil {
		return nil, false
	}
	return o.ComputedUserset, true
}

// HasComputedUserset returns a boolean if a field has been set.
func (o *Userset) HasComputedUserset() bool {
	if o != nil && o.ComputedUserset != nil {
		return true
	}

	return false
}

// SetComputedUserset gets a reference to the given ObjectRelation and assigns it to the ComputedUserset field.
func (o *Userset) SetComputedUserset(v ObjectRelation) {
	o.ComputedUserset = &v
}

// GetTupleToUserset returns the TupleToUserset field value if set, zero value otherwise.
func (o *Userset) GetTupleToUserset() TupleToUserset {
	if o == nil || o.TupleToUserset == nil {
		var ret TupleToUserset
		return ret
	}
	return *o.TupleToUserset
}

// GetTupleToUsersetOk returns a tuple with the TupleToUserset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetTupleToUsersetOk() (*TupleToUserset, bool) {
	if o == nil || o.TupleToUserset == nil {
		return nil, false
	}
	return o.TupleToUserset, true
}

// HasTupleToUserset returns a boolean if a field has been set.
func (o *Userset) HasTupleToUserset() bool {
	if o != nil && o.TupleToUserset != nil {
		return true
	}

	return false
}

// SetTupleToUserset gets a reference to the given TupleToUserset and assigns it to the TupleToUserset field.
func (o *Userset) SetTupleToUserset(v TupleToUserset) {
	o.TupleToUserset = &v
}

// GetUnion returns the Union field value if set, zero value otherwise.
func (o *Userset) GetUnion() Usersets {
	if o == nil || o.Union == nil {
		var ret Usersets
		return ret
	}
	return *o.Union
}

// GetUnionOk returns a tuple with the Union field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetUnionOk() (*Usersets, bool) {
	if o == nil || o.Union == nil {
		return nil, false
	}
	return o.Union, true
}

// HasUnion returns a boolean if a field has been set.
func (o *Userset) HasUnion() bool {
	if o != nil && o.Union != nil {
		return true
	}

	return false
}

// SetUnion gets a reference to the given Usersets and assigns it to the Union field.
func (o *Userset) SetUnion(v Usersets) {
	o.Union = &v
}

// GetIntersection returns the Intersection field value if set, zero value otherwise.
func (o *Userset) GetIntersection() Usersets {
	if o == nil || o.Intersection == nil {
		var ret Usersets
		return ret
	}
	return *o.Intersection
}

// GetIntersectionOk returns a tuple with the Intersection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetIntersectionOk() (*Usersets, bool) {
	if o == nil || o.Intersection == nil {
		return nil, false
	}
	return o.Intersection, true
}

// HasIntersection returns a boolean if a field has been set.
func (o *Userset) HasIntersection() bool {
	if o != nil && o.Intersection != nil {
		return true
	}

	return false
}

// SetIntersection gets a reference to the given Usersets and assigns it to the Intersection field.
func (o *Userset) SetIntersection(v Usersets) {
	o.Intersection = &v
}

// GetDifference returns the Difference field value if set, zero value otherwise.
func (o *Userset) GetDifference() Difference {
	if o == nil || o.Difference == nil {
		var ret Difference
		return ret
	}
	return *o.Difference
}

// GetDifferenceOk returns a tuple with the Difference field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Userset) GetDifferenceOk() (*Difference, bool) {
	if o == nil || o.Difference == nil {
		return nil, false
	}
	return o.Difference, true
}

// HasDifference returns a boolean if a field has been set.
func (o *Userset) HasDifference() bool {
	if o != nil && o.Difference != nil {
		return true
	}

	return false
}

// SetDifference gets a reference to the given Difference and assigns it to the Difference field.
func (o *Userset) SetDifference(v Difference) {
	o.Difference = &v
}

func (o Userset) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.This != nil {
		toSerialize["this"] = o.This
	}
	if o.ComputedUserset != nil {
		toSerialize["computedUserset"] = o.ComputedUserset
	}
	if o.TupleToUserset != nil {
		toSerialize["tupleToUserset"] = o.TupleToUserset
	}
	if o.Union != nil {
		toSerialize["union"] = o.Union
	}
	if o.Intersection != nil {
		toSerialize["intersection"] = o.Intersection
	}
	if o.Difference != nil {
		toSerialize["difference"] = o.Difference
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableUserset struct {
	value *Userset
	isSet bool
}

func (v NullableUserset) Get() *Userset {
	return v.value
}

func (v *NullableUserset) Set(val *Userset) {
	v.value = val
	v.isSet = true
}

func (v NullableUserset) IsSet() bool {
	return v.isSet
}

func (v *NullableUserset) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUserset(val *Userset) *NullableUserset {
	return &NullableUserset{value: val, isSet: true}
}

func (v NullableUserset) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUserset) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
