// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/ad_group_simulation.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group simulation. Supported combinations of advertising
// channel type, simulation type and simulation modification method is
// detailed below respectively.
//
// 1. SEARCH - CPC_BID - DEFAULT
// 2. SEARCH - CPC_BID - UNIFORM
// 3. SEARCH - TARGET_CPA - UNIFORM
// 4. DISPLAY - CPC_BID - DEFAULT
// 5. DISPLAY - CPC_BID - UNIFORM
// 6. DISPLAY - TARGET_CPA - UNIFORM
// 7. VIDEO - CPV_BID - DEFAULT
// 8. VIDEO - CPV_BID - UNIFORM
type AdGroupSimulation struct {
	// Output only. The resource name of the ad group simulation.
	// Ad group simulation resource names have the form:
	//
	// `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. Ad group id of the simulation.
	AdGroupId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=ad_group_id,json=adGroupId,proto3" json:"ad_group_id,omitempty"`
	// Output only. The field that the simulation modifies.
	Type enums.SimulationTypeEnum_SimulationType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.SimulationTypeEnum_SimulationType" json:"type,omitempty"`
	// Output only. How the simulation modifies the field.
	ModificationMethod enums.SimulationModificationMethodEnum_SimulationModificationMethod `protobuf:"varint,4,opt,name=modification_method,json=modificationMethod,proto3,enum=google.ads.googleads.v1.enums.SimulationModificationMethodEnum_SimulationModificationMethod" json:"modification_method,omitempty"`
	// Output only. First day on which the simulation is based, in YYYY-MM-DD format.
	StartDate *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Output only. Last day on which the simulation is based, in YYYY-MM-DD format
	EndDate *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// List of simulation points.
	//
	// Types that are valid to be assigned to PointList:
	//	*AdGroupSimulation_CpcBidPointList
	//	*AdGroupSimulation_CpvBidPointList
	//	*AdGroupSimulation_TargetCpaPointList
	PointList            isAdGroupSimulation_PointList `protobuf_oneof:"point_list"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdGroupSimulation) Reset()         { *m = AdGroupSimulation{} }
func (m *AdGroupSimulation) String() string { return proto.CompactTextString(m) }
func (*AdGroupSimulation) ProtoMessage()    {}
func (*AdGroupSimulation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c8573d5f5d3a023, []int{0}
}

func (m *AdGroupSimulation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupSimulation.Unmarshal(m, b)
}
func (m *AdGroupSimulation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupSimulation.Marshal(b, m, deterministic)
}
func (m *AdGroupSimulation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupSimulation.Merge(m, src)
}
func (m *AdGroupSimulation) XXX_Size() int {
	return xxx_messageInfo_AdGroupSimulation.Size(m)
}
func (m *AdGroupSimulation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupSimulation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupSimulation proto.InternalMessageInfo

func (m *AdGroupSimulation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupSimulation) GetAdGroupId() *wrappers.Int64Value {
	if m != nil {
		return m.AdGroupId
	}
	return nil
}

func (m *AdGroupSimulation) GetType() enums.SimulationTypeEnum_SimulationType {
	if m != nil {
		return m.Type
	}
	return enums.SimulationTypeEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetModificationMethod() enums.SimulationModificationMethodEnum_SimulationModificationMethod {
	if m != nil {
		return m.ModificationMethod
	}
	return enums.SimulationModificationMethodEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *AdGroupSimulation) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

type isAdGroupSimulation_PointList interface {
	isAdGroupSimulation_PointList()
}

type AdGroupSimulation_CpcBidPointList struct {
	CpcBidPointList *common.CpcBidSimulationPointList `protobuf:"bytes,8,opt,name=cpc_bid_point_list,json=cpcBidPointList,proto3,oneof"`
}

type AdGroupSimulation_CpvBidPointList struct {
	CpvBidPointList *common.CpvBidSimulationPointList `protobuf:"bytes,10,opt,name=cpv_bid_point_list,json=cpvBidPointList,proto3,oneof"`
}

type AdGroupSimulation_TargetCpaPointList struct {
	TargetCpaPointList *common.TargetCpaSimulationPointList `protobuf:"bytes,9,opt,name=target_cpa_point_list,json=targetCpaPointList,proto3,oneof"`
}

func (*AdGroupSimulation_CpcBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_CpvBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_TargetCpaPointList) isAdGroupSimulation_PointList() {}

func (m *AdGroupSimulation) GetPointList() isAdGroupSimulation_PointList {
	if m != nil {
		return m.PointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpcBidPointList() *common.CpcBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpcBidPointList); ok {
		return x.CpcBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpvBidPointList() *common.CpvBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpvBidPointList); ok {
		return x.CpvBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetTargetCpaPointList() *common.TargetCpaSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_TargetCpaPointList); ok {
		return x.TargetCpaPointList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupSimulation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupSimulation_CpcBidPointList)(nil),
		(*AdGroupSimulation_CpvBidPointList)(nil),
		(*AdGroupSimulation_TargetCpaPointList)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupSimulation)(nil), "google.ads.googleads.v1.resources.AdGroupSimulation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/ad_group_simulation.proto", fileDescriptor_8c8573d5f5d3a023)
}

var fileDescriptor_8c8573d5f5d3a023 = []byte{
	// 664 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x5d, 0x6b, 0x13, 0x4b,
	0x18, 0x3e, 0x49, 0x7a, 0xfa, 0x31, 0xed, 0x39, 0x87, 0xb3, 0xa2, 0xc4, 0x5a, 0xb4, 0x15, 0x0a,
	0x45, 0x64, 0x86, 0xb4, 0x22, 0xb8, 0xad, 0xd0, 0xdd, 0x2a, 0xb5, 0x62, 0xa5, 0xa4, 0x25, 0xa2,
	0x04, 0x96, 0xc9, 0xce, 0x74, 0x3b, 0x98, 0xf9, 0x60, 0x67, 0x76, 0xa5, 0x94, 0x5e, 0xf9, 0x0f,
	0xfc, 0x09, 0x5e, 0xfa, 0x53, 0xfc, 0x15, 0xbd, 0xee, 0xa5, 0x97, 0x5e, 0x49, 0x66, 0x3f, 0x12,
	0x93, 0xa6, 0x8d, 0x77, 0xef, 0xee, 0xfb, 0x7c, 0xbc, 0xef, 0xb3, 0xb3, 0x03, 0x36, 0x23, 0x29,
	0xa3, 0x2e, 0x45, 0x98, 0x68, 0x94, 0x95, 0xbd, 0x2a, 0x6d, 0xa0, 0x98, 0x6a, 0x99, 0xc4, 0x21,
	0xd5, 0x08, 0x93, 0x20, 0x8a, 0x65, 0xa2, 0x02, 0xcd, 0x78, 0xd2, 0xc5, 0x86, 0x49, 0x01, 0x55,
	0x2c, 0x8d, 0x74, 0x56, 0x32, 0x06, 0xc4, 0x44, 0xc3, 0x92, 0x0c, 0xd3, 0x06, 0x2c, 0xc9, 0x8b,
	0x68, 0x9c, 0x7e, 0x28, 0x39, 0x97, 0x02, 0x0d, 0x6b, 0x2e, 0xfa, 0xe3, 0x08, 0x54, 0x24, 0x5c,
	0x0f, 0xe0, 0x03, 0x2e, 0x09, 0x3b, 0x66, 0x61, 0xfe, 0x40, 0xcd, 0x89, 0x24, 0xb9, 0xc6, 0xc6,
	0xc4, 0x1a, 0xe6, 0x54, 0xd1, 0x9c, 0xf4, 0xa0, 0x20, 0x29, 0x86, 0x8e, 0x19, 0xed, 0x92, 0xa0,
	0x43, 0x4f, 0x70, 0xca, 0x64, 0x9c, 0x03, 0xee, 0x0e, 0x00, 0x8a, 0x05, 0xf3, 0xd6, 0xfd, 0xbc,
	0x65, 0x9f, 0x3a, 0xc9, 0x31, 0xfa, 0x14, 0x63, 0xa5, 0x68, 0xac, 0xf3, 0xfe, 0xd2, 0x00, 0x15,
	0x0b, 0x21, 0x8d, 0x75, 0xcf, 0xbb, 0x0f, 0x7f, 0xcc, 0x80, 0xff, 0x3d, 0xb2, 0xdb, 0xcb, 0xf8,
	0xb0, 0x1c, 0xcd, 0x79, 0x07, 0xfe, 0x29, 0x5c, 0x02, 0x81, 0x39, 0xad, 0x57, 0x96, 0x2b, 0x6b,
	0x73, 0xfe, 0xfa, 0x85, 0x57, 0xfb, 0xe9, 0x3d, 0x06, 0x8f, 0xfa, 0x81, 0xe7, 0x95, 0x62, 0x1a,
	0x86, 0x92, 0xa3, 0x11, 0xa9, 0xe6, 0x42, 0x21, 0xf4, 0x16, 0x73, 0xea, 0x6c, 0x83, 0xf9, 0xf2,
	0x93, 0x32, 0x52, 0xaf, 0x2e, 0x57, 0xd6, 0xe6, 0xd7, 0xef, 0xe5, 0x2a, 0xb0, 0x58, 0x01, 0xee,
	0x09, 0xf3, 0xf4, 0x49, 0x0b, 0x77, 0x13, 0xea, 0xd7, 0x2e, 0xbc, 0x5a, 0x73, 0x0e, 0x67, 0xba,
	0x7b, 0xc4, 0x79, 0x0f, 0xa6, 0x7a, 0xc1, 0xd5, 0x6b, 0xcb, 0x95, 0xb5, 0x7f, 0xd7, 0xb7, 0xe1,
	0xb8, 0x63, 0x60, 0xe3, 0x86, 0xfd, 0x41, 0x8e, 0x4e, 0x15, 0x7d, 0x29, 0x12, 0x3e, 0xf4, 0x2a,
	0xd3, 0xb7, 0x92, 0xce, 0x97, 0x0a, 0xb8, 0x75, 0xc5, 0x87, 0xad, 0x4f, 0x59, 0xab, 0xf6, 0xc4,
	0x56, 0xfb, 0x03, 0x1a, 0xfb, 0x56, 0x62, 0xc8, 0x78, 0x14, 0x90, 0x8d, 0xe1, 0xf0, 0x91, 0x86,
	0xb3, 0x0d, 0x80, 0x36, 0x38, 0x36, 0x01, 0xc1, 0x86, 0xd6, 0xff, 0xb6, 0x81, 0x2d, 0x8d, 0x04,
	0x76, 0x68, 0x62, 0x26, 0xa2, 0xc1, 0xc4, 0x2c, 0xe9, 0x05, 0x36, 0xd4, 0xd9, 0x02, 0xb3, 0x54,
	0x90, 0x8c, 0x3f, 0x3d, 0x29, 0x7f, 0x86, 0x0a, 0x62, 0xd9, 0x1c, 0x38, 0xa1, 0x0a, 0x83, 0x0e,
	0x23, 0x81, 0x92, 0x4c, 0x98, 0xa0, 0xcb, 0xb4, 0xa9, 0xcf, 0x5a, 0x9d, 0x67, 0x63, 0x23, 0xc9,
	0xfe, 0x30, 0xb8, 0xa3, 0x42, 0x9f, 0x91, 0xfe, 0xe2, 0x07, 0x3d, 0x85, 0x37, 0x4c, 0x1b, 0x6b,
	0xf2, 0xea, 0xaf, 0xe6, 0x7f, 0xa1, 0x45, 0x94, 0xef, 0x33, 0xbb, 0x74, 0xd8, 0x0e, 0x4c, 0x6a,
	0x97, 0xde, 0x68, 0x97, 0xfe, 0x66, 0x97, 0x82, 0xdb, 0x06, 0xc7, 0x11, 0x35, 0x41, 0xa8, 0xf0,
	0xa0, 0xe3, 0x9c, 0x75, 0xdc, 0xba, 0xc9, 0xf1, 0xc8, 0x92, 0x77, 0x14, 0xbe, 0xc6, 0xd4, 0x31,
	0x05, 0xa8, 0x6c, 0xb9, 0xe2, 0xd2, 0xfb, 0xf8, 0x27, 0xbf, 0x91, 0xf3, 0x3c, 0x4c, 0xb4, 0x91,
	0x9c, 0xc6, 0x1a, 0x9d, 0x15, 0xe5, 0x39, 0xc2, 0xc3, 0x38, 0x8d, 0xce, 0xae, 0xb8, 0x32, 0xcf,
	0xfd, 0x05, 0x00, 0xfa, 0xcb, 0xf9, 0x9f, 0xab, 0x60, 0x35, 0x94, 0x1c, 0xde, 0x78, 0x85, 0xfa,
	0x77, 0x46, 0x26, 0x39, 0xe8, 0x1d, 0x99, 0x83, 0xca, 0x87, 0xd7, 0x39, 0x39, 0x92, 0x5d, 0x2c,
	0x22, 0x28, 0xe3, 0x08, 0x45, 0x54, 0xd8, 0x03, 0x85, 0xfa, 0xdb, 0x5c, 0x73, 0xb7, 0x6f, 0x96,
	0xd5, 0xd7, 0x6a, 0x6d, 0xd7, 0xf3, 0xbe, 0x55, 0x57, 0x76, 0x33, 0x49, 0x8f, 0x68, 0x98, 0x95,
	0xbd, 0xaa, 0xd5, 0x80, 0xcd, 0x02, 0xf9, 0xbd, 0xc0, 0xb4, 0x3d, 0xa2, 0xdb, 0x25, 0xa6, 0xdd,
	0x6a, 0xb4, 0x4b, 0xcc, 0x65, 0x75, 0x35, 0x6b, 0xb8, 0xae, 0x47, 0xb4, 0xeb, 0x96, 0x28, 0xd7,
	0x6d, 0x35, 0x5c, 0xb7, 0xc4, 0x75, 0xa6, 0xed, 0xb0, 0x1b, 0xbf, 0x02, 0x00, 0x00, 0xff, 0xff,
	0x0f, 0x56, 0xa6, 0x71, 0x87, 0x06, 0x00, 0x00,
}
