// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/label_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [LabelService.GetLabel][google.ads.googleads.v3.services.LabelService.GetLabel].
type GetLabelRequest struct {
	// Required. The resource name of the label to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetLabelRequest) Reset()         { *m = GetLabelRequest{} }
func (m *GetLabelRequest) String() string { return proto.CompactTextString(m) }
func (*GetLabelRequest) ProtoMessage()    {}
func (*GetLabelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a44839ef2e1ad921, []int{0}
}

func (m *GetLabelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetLabelRequest.Unmarshal(m, b)
}
func (m *GetLabelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetLabelRequest.Marshal(b, m, deterministic)
}
func (m *GetLabelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetLabelRequest.Merge(m, src)
}
func (m *GetLabelRequest) XXX_Size() int {
	return xxx_messageInfo_GetLabelRequest.Size(m)
}
func (m *GetLabelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetLabelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetLabelRequest proto.InternalMessageInfo

func (m *GetLabelRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [LabelService.MutateLabels][google.ads.googleads.v3.services.LabelService.MutateLabels].
type MutateLabelsRequest struct {
	// Required. ID of the customer whose labels are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on labels.
	Operations []*LabelOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateLabelsRequest) Reset()         { *m = MutateLabelsRequest{} }
func (m *MutateLabelsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateLabelsRequest) ProtoMessage()    {}
func (*MutateLabelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a44839ef2e1ad921, []int{1}
}

func (m *MutateLabelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelsRequest.Unmarshal(m, b)
}
func (m *MutateLabelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelsRequest.Marshal(b, m, deterministic)
}
func (m *MutateLabelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelsRequest.Merge(m, src)
}
func (m *MutateLabelsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateLabelsRequest.Size(m)
}
func (m *MutateLabelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelsRequest proto.InternalMessageInfo

func (m *MutateLabelsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateLabelsRequest) GetOperations() []*LabelOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateLabelsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateLabelsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove, update) on a label.
type LabelOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*LabelOperation_Create
	//	*LabelOperation_Update
	//	*LabelOperation_Remove
	Operation            isLabelOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LabelOperation) Reset()         { *m = LabelOperation{} }
func (m *LabelOperation) String() string { return proto.CompactTextString(m) }
func (*LabelOperation) ProtoMessage()    {}
func (*LabelOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_a44839ef2e1ad921, []int{2}
}

func (m *LabelOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelOperation.Unmarshal(m, b)
}
func (m *LabelOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelOperation.Marshal(b, m, deterministic)
}
func (m *LabelOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelOperation.Merge(m, src)
}
func (m *LabelOperation) XXX_Size() int {
	return xxx_messageInfo_LabelOperation.Size(m)
}
func (m *LabelOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelOperation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelOperation proto.InternalMessageInfo

func (m *LabelOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isLabelOperation_Operation interface {
	isLabelOperation_Operation()
}

type LabelOperation_Create struct {
	Create *resources.Label `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type LabelOperation_Update struct {
	Update *resources.Label `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type LabelOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*LabelOperation_Create) isLabelOperation_Operation() {}

func (*LabelOperation_Update) isLabelOperation_Operation() {}

func (*LabelOperation_Remove) isLabelOperation_Operation() {}

func (m *LabelOperation) GetOperation() isLabelOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *LabelOperation) GetCreate() *resources.Label {
	if x, ok := m.GetOperation().(*LabelOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *LabelOperation) GetUpdate() *resources.Label {
	if x, ok := m.GetOperation().(*LabelOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *LabelOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*LabelOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*LabelOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*LabelOperation_Create)(nil),
		(*LabelOperation_Update)(nil),
		(*LabelOperation_Remove)(nil),
	}
}

// Response message for a labels mutate.
type MutateLabelsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateLabelResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MutateLabelsResponse) Reset()         { *m = MutateLabelsResponse{} }
func (m *MutateLabelsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateLabelsResponse) ProtoMessage()    {}
func (*MutateLabelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a44839ef2e1ad921, []int{3}
}

func (m *MutateLabelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelsResponse.Unmarshal(m, b)
}
func (m *MutateLabelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelsResponse.Marshal(b, m, deterministic)
}
func (m *MutateLabelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelsResponse.Merge(m, src)
}
func (m *MutateLabelsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateLabelsResponse.Size(m)
}
func (m *MutateLabelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelsResponse proto.InternalMessageInfo

func (m *MutateLabelsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateLabelsResponse) GetResults() []*MutateLabelResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for a label mutate.
type MutateLabelResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateLabelResult) Reset()         { *m = MutateLabelResult{} }
func (m *MutateLabelResult) String() string { return proto.CompactTextString(m) }
func (*MutateLabelResult) ProtoMessage()    {}
func (*MutateLabelResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a44839ef2e1ad921, []int{4}
}

func (m *MutateLabelResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateLabelResult.Unmarshal(m, b)
}
func (m *MutateLabelResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateLabelResult.Marshal(b, m, deterministic)
}
func (m *MutateLabelResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateLabelResult.Merge(m, src)
}
func (m *MutateLabelResult) XXX_Size() int {
	return xxx_messageInfo_MutateLabelResult.Size(m)
}
func (m *MutateLabelResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateLabelResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateLabelResult proto.InternalMessageInfo

func (m *MutateLabelResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetLabelRequest)(nil), "google.ads.googleads.v3.services.GetLabelRequest")
	proto.RegisterType((*MutateLabelsRequest)(nil), "google.ads.googleads.v3.services.MutateLabelsRequest")
	proto.RegisterType((*LabelOperation)(nil), "google.ads.googleads.v3.services.LabelOperation")
	proto.RegisterType((*MutateLabelsResponse)(nil), "google.ads.googleads.v3.services.MutateLabelsResponse")
	proto.RegisterType((*MutateLabelResult)(nil), "google.ads.googleads.v3.services.MutateLabelResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/label_service.proto", fileDescriptor_a44839ef2e1ad921)
}

var fileDescriptor_a44839ef2e1ad921 = []byte{
	// 771 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0xbe, 0x76, 0xae, 0x7a, 0xdb, 0x49, 0xda, 0xaa, 0xd3, 0xfb, 0x93, 0x1b, 0x10, 0x44, 0xa6,
	0x82, 0x28, 0x80, 0x5d, 0x12, 0x40, 0xc8, 0x55, 0x25, 0x1c, 0x89, 0xb6, 0x08, 0x4a, 0x2b, 0x57,
	0x74, 0x81, 0x22, 0xa2, 0x89, 0x3d, 0x0d, 0x56, 0x6d, 0x8f, 0x99, 0xb1, 0x23, 0x55, 0x55, 0x37,
	0xbc, 0x02, 0x6f, 0xc0, 0x0a, 0x90, 0x78, 0x91, 0x2e, 0xd8, 0xb0, 0xeb, 0xaa, 0x0b, 0x56, 0x3c,
	0x01, 0x42, 0x2c, 0x90, 0x3d, 0x33, 0x89, 0x53, 0x88, 0x42, 0x77, 0xc7, 0x73, 0xbe, 0xef, 0x3b,
	0x67, 0xce, 0xcf, 0x18, 0xdc, 0xee, 0x11, 0xd2, 0xf3, 0xb1, 0x81, 0x5c, 0x66, 0x70, 0x33, 0xb5,
	0xfa, 0x4d, 0x83, 0x61, 0xda, 0xf7, 0x1c, 0xcc, 0x0c, 0x1f, 0x75, 0xb1, 0xdf, 0x11, 0x9f, 0x7a,
	0x44, 0x49, 0x4c, 0x60, 0x95, 0x43, 0x75, 0xe4, 0x32, 0x7d, 0xc0, 0xd2, 0xfb, 0x4d, 0x5d, 0xb2,
	0x2a, 0x37, 0xc7, 0xe9, 0x52, 0xcc, 0x48, 0x42, 0x07, 0xc2, 0x5c, 0xb0, 0x72, 0x51, 0xc2, 0x23,
	0xcf, 0x40, 0x61, 0x48, 0x62, 0x14, 0x7b, 0x24, 0x64, 0xc2, 0xfb, 0x5f, 0xce, 0xeb, 0xf8, 0x1e,
	0x0e, 0x63, 0xe1, 0xb8, 0x9c, 0x73, 0xec, 0x79, 0xd8, 0x77, 0x3b, 0x5d, 0xfc, 0x02, 0xf5, 0x3d,
	0x42, 0x05, 0xe0, 0xff, 0x1c, 0x40, 0x46, 0x16, 0x2e, 0x71, 0x07, 0x23, 0xfb, 0xea, 0x26, 0x7b,
	0x42, 0x20, 0x40, 0x6c, 0xff, 0x4c, 0x58, 0x1a, 0x39, 0x06, 0x8b, 0x51, 0x9c, 0x88, 0x7c, 0xb4,
	0xe7, 0x60, 0x7e, 0x1d, 0xc7, 0x8f, 0xd3, 0xfc, 0x6d, 0xfc, 0x32, 0xc1, 0x2c, 0x86, 0x8f, 0xc0,
	0xac, 0xd4, 0xef, 0x84, 0x28, 0xc0, 0x65, 0xa5, 0xaa, 0xd4, 0x66, 0x5a, 0x57, 0x4f, 0x2d, 0xf5,
	0x9b, 0x55, 0x05, 0x97, 0x86, 0x55, 0x12, 0x56, 0xe4, 0x31, 0xdd, 0x21, 0x81, 0xc1, 0x55, 0x4a,
	0x92, 0xfc, 0x04, 0x05, 0x58, 0x3b, 0x55, 0xc0, 0xe2, 0x66, 0x12, 0xa3, 0x18, 0x67, 0x5e, 0x26,
	0x83, 0x2c, 0x81, 0xa2, 0x93, 0xb0, 0x98, 0x04, 0x98, 0x76, 0x3c, 0x57, 0x84, 0x28, 0x9c, 0x5a,
	0xaa, 0x0d, 0xe4, 0xf9, 0x43, 0x17, 0x3e, 0x05, 0x80, 0x44, 0x98, 0xf2, 0x0a, 0x96, 0xd5, 0x6a,
	0xa1, 0x56, 0x6c, 0x2c, 0xeb, 0x93, 0x3a, 0xa6, 0x67, 0xa1, 0xb6, 0x24, 0x51, 0xc8, 0x0e, 0x85,
	0xe0, 0x35, 0x30, 0x1f, 0x21, 0x1a, 0x7b, 0xc8, 0xef, 0xec, 0x21, 0xcf, 0x4f, 0x28, 0x2e, 0x17,
	0xaa, 0x4a, 0x6d, 0xda, 0x9e, 0x13, 0xc7, 0x6b, 0xfc, 0x14, 0x5e, 0x01, 0xb3, 0x7d, 0xe4, 0x7b,
	0x2e, 0x8a, 0x71, 0x87, 0x84, 0xfe, 0x41, 0xf9, 0xcf, 0x0c, 0x56, 0x92, 0x87, 0x5b, 0xa1, 0x7f,
	0xa0, 0x7d, 0x57, 0xc0, 0xdc, 0x68, 0x44, 0xb8, 0x02, 0x8a, 0x49, 0x94, 0xb1, 0xd2, 0x1e, 0x64,
	0xac, 0x62, 0xa3, 0x22, 0x13, 0x97, 0x6d, 0xd2, 0xd7, 0xd2, 0x36, 0x6d, 0x22, 0xb6, 0x6f, 0x03,
	0x0e, 0x4f, 0x6d, 0xd8, 0x02, 0x53, 0x0e, 0xc5, 0x28, 0xe6, 0x85, 0x2f, 0x36, 0x6a, 0x63, 0x2f,
	0x3c, 0x18, 0x40, 0x7e, 0xe3, 0x8d, 0x3f, 0x6c, 0xc1, 0x4c, 0x35, 0xb8, 0x62, 0x59, 0x3d, 0xbf,
	0x06, 0x67, 0xc2, 0x32, 0x98, 0xa2, 0x38, 0x20, 0x7d, 0x5e, 0x9c, 0x99, 0xd4, 0xc3, 0xbf, 0x5b,
	0x45, 0x30, 0x33, 0xa8, 0xa6, 0xf6, 0x41, 0x01, 0x7f, 0x8f, 0x76, 0x98, 0x45, 0x24, 0x64, 0x18,
	0xae, 0x81, 0x7f, 0xce, 0x54, 0xb9, 0x83, 0x29, 0x25, 0x34, 0x93, 0x2b, 0x36, 0xa0, 0x4c, 0x89,
	0x46, 0x8e, 0xbe, 0x93, 0xcd, 0xa4, 0xbd, 0x38, 0x5a, 0xff, 0x07, 0x29, 0x1c, 0x6e, 0x82, 0xbf,
	0x28, 0x66, 0x89, 0x1f, 0xcb, 0x09, 0x68, 0x4e, 0x9e, 0x80, 0x5c, 0x42, 0x76, 0xc6, 0xb5, 0xa5,
	0x86, 0x76, 0x0f, 0x2c, 0xfc, 0xe4, 0x4d, 0x1b, 0xfd, 0x8b, 0x99, 0x1f, 0x9d, 0xe5, 0xc6, 0xdb,
	0x02, 0x28, 0x65, 0xa4, 0x1d, 0x1e, 0x06, 0xbe, 0x53, 0xc0, 0xb4, 0xdc, 0x1e, 0x78, 0x6b, 0x72,
	0x56, 0x67, 0x36, 0xad, 0xf2, 0xdb, 0x5d, 0xd1, 0xee, 0x9f, 0x58, 0xa3, 0x09, 0xbe, 0xfa, 0xf4,
	0xf9, 0xb5, 0x5a, 0x87, 0xb5, 0xf4, 0x1d, 0x3a, 0x1c, 0xf1, 0xac, 0xca, 0xfd, 0x61, 0x46, 0x9d,
	0x3f, 0x4c, 0xcc, 0xa8, 0x1f, 0xc1, 0x8f, 0x0a, 0x28, 0xe5, 0xdb, 0x04, 0xef, 0x9c, 0xab, 0x8a,
	0x72, 0x71, 0x2b, 0x77, 0xcf, 0x4b, 0xe3, 0xd3, 0xa0, 0x6d, 0x9d, 0x58, 0xff, 0xe6, 0x36, 0xfe,
	0xc6, 0x70, 0x1d, 0xb3, 0xab, 0x2c, 0x6b, 0xd7, 0xd3, 0xab, 0x0c, 0x73, 0x3f, 0xcc, 0x81, 0x57,
	0xeb, 0x47, 0xe2, 0x26, 0x66, 0x90, 0x69, 0x9b, 0x4a, 0xbd, 0x72, 0xe1, 0xd8, 0x2a, 0x8f, 0x7b,
	0x8a, 0x5a, 0x5f, 0x15, 0xb0, 0xe4, 0x90, 0x60, 0x62, 0xae, 0xad, 0x85, 0x7c, 0x43, 0xb7, 0xd3,
	0xc5, 0xdc, 0x56, 0x9e, 0x6d, 0x08, 0x5a, 0x8f, 0xf8, 0x28, 0xec, 0xe9, 0x84, 0xf6, 0x8c, 0x1e,
	0x0e, 0xb3, 0xb5, 0x35, 0x86, 0x81, 0xc6, 0xff, 0x68, 0x56, 0xa4, 0xf1, 0x46, 0x2d, 0xac, 0x5b,
	0xd6, 0x7b, 0xb5, 0xba, 0xce, 0x05, 0x2d, 0x97, 0xe9, 0xdc, 0x4c, 0xad, 0xdd, 0xa6, 0x2e, 0x02,
	0xb3, 0x63, 0x09, 0x69, 0x5b, 0x2e, 0x6b, 0x0f, 0x20, 0xed, 0xdd, 0x66, 0x5b, 0x42, 0xbe, 0xa8,
	0x4b, 0xfc, 0xdc, 0x34, 0x2d, 0x97, 0x99, 0xe6, 0x00, 0x64, 0x9a, 0xbb, 0x4d, 0xd3, 0x94, 0xb0,
	0xee, 0x54, 0x96, 0x67, 0xf3, 0x47, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb9, 0xe3, 0x64, 0xfd, 0x0f,
	0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LabelServiceClient is the client API for LabelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LabelServiceClient interface {
	// Returns the requested label in full detail.
	GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*resources.Label, error)
	// Creates, updates, or removes labels. Operation statuses are returned.
	MutateLabels(ctx context.Context, in *MutateLabelsRequest, opts ...grpc.CallOption) (*MutateLabelsResponse, error)
}

type labelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLabelServiceClient(cc grpc.ClientConnInterface) LabelServiceClient {
	return &labelServiceClient{cc}
}

func (c *labelServiceClient) GetLabel(ctx context.Context, in *GetLabelRequest, opts ...grpc.CallOption) (*resources.Label, error) {
	out := new(resources.Label)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.LabelService/GetLabel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *labelServiceClient) MutateLabels(ctx context.Context, in *MutateLabelsRequest, opts ...grpc.CallOption) (*MutateLabelsResponse, error) {
	out := new(MutateLabelsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.LabelService/MutateLabels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LabelServiceServer is the server API for LabelService service.
type LabelServiceServer interface {
	// Returns the requested label in full detail.
	GetLabel(context.Context, *GetLabelRequest) (*resources.Label, error)
	// Creates, updates, or removes labels. Operation statuses are returned.
	MutateLabels(context.Context, *MutateLabelsRequest) (*MutateLabelsResponse, error)
}

// UnimplementedLabelServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLabelServiceServer struct {
}

func (*UnimplementedLabelServiceServer) GetLabel(ctx context.Context, req *GetLabelRequest) (*resources.Label, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLabel not implemented")
}
func (*UnimplementedLabelServiceServer) MutateLabels(ctx context.Context, req *MutateLabelsRequest) (*MutateLabelsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateLabels not implemented")
}

func RegisterLabelServiceServer(s *grpc.Server, srv LabelServiceServer) {
	s.RegisterService(&_LabelService_serviceDesc, srv)
}

func _LabelService_GetLabel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLabelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LabelServiceServer).GetLabel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.LabelService/GetLabel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LabelServiceServer).GetLabel(ctx, req.(*GetLabelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LabelService_MutateLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LabelServiceServer).MutateLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.LabelService/MutateLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LabelServiceServer).MutateLabels(ctx, req.(*MutateLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LabelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.LabelService",
	HandlerType: (*LabelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLabel",
			Handler:    _LabelService_GetLabel_Handler,
		},
		{
			MethodName: "MutateLabels",
			Handler:    _LabelService_MutateLabels_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/label_service.proto",
}
