General Information
===================

GTK is a multi-platform toolkit for creating graphical user interfaces.
Offering a complete set of widgets, GTK is suitable for projects ranging
from small one-off projects to complete application suites.

GTK is free software and part of the GNU Project. However, the licensing
terms for GTK, the GNU LGPL, allow it to be used by all developers,
including those developing proprietary software, without any license fees or
royalties.

The official download locations are:

- http://download.gnome.org/sources/gtk+

The official web site is:

- http://www.gtk.org/

Installation
============

See the file [`INSTALL.md`](./INSTALL.md)


How to report bugs
==================

Bugs should be reported to the [GTK issue
tracker](https://gitlab.gnome.org/GNOME/gtk/issues). You will need to create
an account for yourself.

In the bug report please include:

* Information about your system. For instance:

   - What operating system and version
   - For Linux, what version of the C library

  And anything else you think is relevant.

* How to reproduce the bug.

  If you can reproduce it with one of the test programs that are built
  in the tests/ subdirectory, that will be most convenient.  Otherwise,
  please include a short test program that exhibits the behavior.
  As a last resort, you can also provide a pointer to a larger piece
  of software that can be downloaded.

* If the bug was a crash, the exact text that was printed out
  when the crash occurred.

* Further information such as stack traces may be useful, but
  is not necessary.


Bug fixes and improvements
==========================

Changes should be submitted as merge request to the GTK project. If a merge
request fixes an issue, the description should mention the issue number.

Release notes
=============

Release notes for releases of GTK 3.x are part of the migration
guide in the GTK documentation. See

- https://developer-old.gnome.org/gtk3/3.24/gtk-migrating-3-x-to-y.html
