/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *                 Jehan <jehan@girinstud.io>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsSBCharSetProber.h"

/********* Language model for: Esperanto *********/

/**
 * Generated by BuildLangModel.py
 * On: 2016-05-04 10:45:46.721306
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static unsigned char Latin3CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 17, 10,  2, 18, 15, 20,  3, 11,  9,  6, 13,  4,  1, /* 4X */
   14, 34,  5,  8,  7, 12, 16, 26, 32, 25, 21,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 17, 10,  2, 18, 15, 20,  3, 11,  9,  6, 13,  4,  1, /* 6X */
   14, 34,  5,  8,  7, 12, 16, 26, 32, 25, 21,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 55,SYM,SYM,SYM,ILL, 30,SYM,SYM, 56, 53, 57, 28,SYM,ILL, 43, /* AX */
  SYM, 58,SYM,SYM,SYM,SYM, 30,SYM,SYM, 59, 53, 60, 28,SYM,ILL, 43, /* BX */
   48, 29, 45,ILL, 39, 61, 24, 42, 46, 31, 47, 50, 54, 37, 44, 51, /* CX */
  ILL, 40, 62, 33, 49, 52, 35,SYM, 22, 63, 38, 64, 36, 23, 27, 41, /* DX */
   48, 29, 45,ILL, 39, 65, 24, 42, 46, 31, 47, 50, 54, 37, 44, 51, /* EX */
  ILL, 40, 66, 33, 49, 52, 35,SYM, 22, 67, 38, 68, 36, 23, 27,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 966
 * First 512 sequences: 0.9949447894488864
 * Next 512 sequences (512-1024): 0.005055210551113598
 * Rest: -2.2551405187698492e-17
 * Negative sequences: TODO
 */
static char EsperantoLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,2,3,0,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,2,3,2,2,0,3,2,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,0,0,2,3,2,2,0,2,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,0,0,2,3,2,0,0,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,3,3,0,2,2,2,2,2,0,3,0,
  3,3,3,3,2,3,3,3,3,2,3,2,3,3,3,3,3,2,2,2,3,3,2,0,2,3,3,0,2,2,0,
  3,3,3,3,3,3,3,3,2,2,2,0,3,3,3,0,2,2,2,3,2,2,2,0,2,2,0,2,0,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,3,2,2,3,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,2,3,3,0,2,0,0,2,3,0,2,0,3,0,
  3,3,3,3,2,3,3,3,3,2,2,2,3,2,3,0,0,2,2,2,3,2,0,0,2,2,0,2,0,3,0,
  3,3,3,3,3,3,3,2,3,2,3,2,3,3,2,2,3,2,2,2,3,0,0,0,0,3,2,2,0,3,0,
  3,3,3,3,2,3,2,2,2,2,3,3,3,0,2,2,0,2,2,2,2,2,0,0,0,2,0,0,0,3,0,
  3,3,3,3,2,3,3,3,3,3,2,0,3,2,2,2,2,3,2,3,3,3,0,0,0,2,0,0,0,2,2,
  3,3,3,3,2,3,3,3,2,2,2,2,3,3,2,3,2,2,3,2,2,0,0,0,0,2,2,0,0,2,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,2,2,2,0,2,2,2,0,0,0,3,0,3,0,2,0,
  3,3,3,3,3,3,3,3,2,0,0,2,3,3,2,2,0,2,2,2,2,0,0,0,0,2,2,0,0,3,0,
  3,3,3,3,3,2,3,3,3,2,2,2,3,2,2,2,2,2,2,3,0,3,2,0,0,3,2,0,0,2,0,
  3,3,3,3,0,0,3,2,0,2,2,2,3,2,2,3,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,
  3,2,3,3,2,3,3,3,3,3,3,2,2,2,2,3,2,0,2,2,0,3,0,0,2,0,0,2,0,0,0,
  3,3,3,3,0,2,2,0,0,2,2,2,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,2,3,2,3,2,2,2,2,2,2,2,0,2,2,0,0,0,0,2,2,0,0,2,0,
  3,3,3,3,3,2,2,2,3,0,0,0,0,2,0,2,0,2,0,0,2,2,0,0,0,2,3,0,0,0,0,
  3,3,3,3,2,2,3,3,0,2,2,0,3,2,2,0,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
  3,3,2,2,0,2,0,0,0,2,2,0,3,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,3,3,3,3,3,2,3,0,0,2,2,2,2,3,0,2,2,3,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,2,0,2,2,2,2,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
};


SequenceModel Latin3_EsperantoModel =
{
  Latin3CharToOrderMap,
  EsperantoLangModel,
  31,
  (float)0.9949447894488864,
  PR_FALSE,
  "ISO-8859-3"
};
