/*
 * The internal definitions
 *
 * Copyright (C) 2008-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBOLECF_INTERNAL_DEFINITIONS_H )
#define _LIBOLECF_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

/* Define HAVE_LOCAL_LIBOLECF for local use of libolecf
 */
#if !defined( HAVE_LOCAL_LIBOLECF )
#include <libolecf/definitions.h>

/* The definitions in <libolecf/definitions.h> are copied here
 * for local use of libolecf
 */
#else
#define LIBOLECF_VERSION						20240427

/* The version string
 */
#define LIBOLECF_VERSION_STRING						"20240427"

/* The file access flags
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
#define LIBOLECF_ACCESS_FLAG_READ					0x01
/* Reserved: not supported yet */
#define LIBOLECF_ACCESS_FLAG_WRITE					0x02

/* The file access macros
 */
#define LIBOLECF_OPEN_READ						( LIBOLECF_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBOLECF_OPEN_WRITE						( LIBOLECF_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBOLECF_OPEN_READ_WRITE					( LIBOLECF_ACCESS_FLAG_READ | LIBOLECF_ACCESS_FLAG_WRITE )

/* The item separator
 */
#define LIBOLECF_SEPARATOR						'\\'

/* The endian definitions
 */
#define LIBOLECF_ENDIAN_BIG						_BYTE_STREAM_ENDIAN_BIG
#define LIBOLECF_ENDIAN_LITTLE						_BYTE_STREAM_ENDIAN_LITTLE

/* The item type definitions
 */
enum LIBOLECF_ITEM_TYPES
{
	LIBOLECF_ITEM_TYPE_EMPTY					= 0x00,
	LIBOLECF_ITEM_TYPE_STORAGE					= 0x01,
	LIBOLECF_ITEM_TYPE_STREAM					= 0x02,
	LIBOLECF_ITEM_TYPE_LOCK_BYTES					= 0x03,
	LIBOLECF_ITEM_TYPE_PROPERTY					= 0x04,
	LIBOLECF_ITEM_TYPE_ROOT_STORAGE					= 0x05
};

/* The summary information property identifiers (PIDs)
 * Class identifier: f29f85e0-4ff9-1068-ab91-08002b27b3d9
 */
enum LIBOLECF_SUMMARY_INFORMATION_PROPERTY_IDENTIFIERS
{
	LIBOLECF_SUMMARY_INFORMATION_PID_CODEPAGE			= 0x00000001UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_TITLE				= 0x00000002UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_SUBJECT			= 0x00000003UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_AUTHOR				= 0x00000004UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_KEYWORDS			= 0x00000005UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_COMMENTS			= 0x00000006UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_TEMPLATE			= 0x00000007UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_LAST_SAVED_BY			= 0x00000008UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_REVISION_NUMBER		= 0x00000009UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_EDITING_TIME			= 0x0000000aUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_LAST_PRINTED_TIME		= 0x0000000bUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_CREATION_TIME			= 0x0000000cUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_LAST_WRITTEN_TIME		= 0x0000000dUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_NUMBER_OF_PAGES		= 0x0000000eUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_NUMBER_OF_WORDS		= 0x0000000fUL,
	LIBOLECF_SUMMARY_INFORMATION_PID_NUMBER_OF_CHARACTERS		= 0x00000010UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_THUMBNAIL			= 0x00000011UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_APPLICATION_NAME		= 0x00000012UL,
	LIBOLECF_SUMMARY_INFORMATION_PID_SECURITY			= 0x00000013UL
};

/* The document summary information property identifiers
 * Class identifier: d5cdd502-2e9c-101b-9397-08002b2cf9ae
 */
enum LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PROPERTY_IDENTIFIERS
{
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_CODEPAGE		= 0x00000001UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_CATEGORY		= 0x00000002UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_PRESENTATION_TARGET	= 0x00000003UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_BYTE_COUNT		= 0x00000004UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_LINE_COUNT		= 0x00000005UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_PARAGRAPH_COUNT	= 0x00000006UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_SLIDE_COUNT		= 0x00000007UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_NOTE_COUNT		= 0x00000008UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_HIDDEN_SLIDE_COUNT	= 0x00000009UL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_MMCLIP_COUNT		= 0x0000000aUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_SCALE			= 0x0000000bUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_HEADING_PAIRS		= 0x0000000cUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_DOCUMENT_PARTS	= 0x0000000dUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_MANAGER		= 0x0000000eUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_COMPANY		= 0x0000000fUL,
	LIBOLECF_DOCUMENT_SUMMARY_INFORMATION_PID_LINKS_DIRTY		= 0x00000010UL
};

#endif /* !defined( HAVE_LOCAL_LIBOLECF ) */

#define LIBOLECF_SECTOR_IDENTIFIER_MSAT					0xfffffffcUL
#define LIBOLECF_SECTOR_IDENTIFIER_SAT					0xfffffffdUL
#define LIBOLECF_SECTOR_IDENTIFIER_END_OF_CHAIN				0xfffffffeUL
#define LIBOLECF_SECTOR_IDENTIFIER_UNUSED				0xffffffffUL

/* The directory node color definitions
 */
enum LIBOLECF_DIRECTORY_NODE_COLORS
{
	LIBOLECF_DIRECTORY_NODE_COLOR_RED				= 0x00,
	LIBOLECF_DIRECTORY_NODE_COLOR_BLACK				= 0x01
};

#define LIBOLECF_MAXIMUM_ALLOCATION_TABLE_RECURSION_DEPTH		256
#define LIBOLECF_MAXIMUM_DIRECTORY_ENTRIES_RECURSION_DEPTH		1024

#endif /* !defined( _LIBOLECF_INTERNAL_DEFINITIONS_H ) */

