/*
  This file was generated automatically with scripts/maple2c.py.
  Do not edit this file directly as it can be overwritten!!

  This Source Code Form is subject to the terms of the Mozilla Public
  License, v. 2.0. If a copy of the MPL was not distributed with this
  file, You can obtain one at http://mozilla.org/MPL/2.0/.

  Maple version     : Maple 2022 (X86 64 LINUX)
  Maple source      : ./maple/mgga_exc/mgga_x_rtpss.mpl
  Type of functional: mgga_exc
*/

#define maple2c_order 4
#define MAPLE2C_FLAGS (XC_FLAGS_I_HAVE_EXC | XC_FLAGS_I_HAVE_VXC | XC_FLAGS_I_HAVE_FXC | XC_FLAGS_I_HAVE_KXC | XC_FLAGS_I_HAVE_LXC)


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t50, t51, t54;
  double t56, t59, t63, t64, t65, t66, t69, t70;
  double t71, t76, t77, t80, t82, t83, t84, t85;
  double t86, t88, t89, t92, t93, t96, t97, t98;
  double t101, t102, t105, t106, t107, t108, t109, t110;
  double t111, t115, t116, t120, t121, t122, t125, t128;
  double t132, tzk0;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = sigma[0] * sigma[0];
  t22 = params->c * t21;
  t23 = rho[0] * rho[0];
  t24 = 0.1e1 / t23;
  t25 = tau[0] * tau[0];
  t26 = 0.1e1 / t25;
  t27 = t24 * t26;
  t28 = t21 * t24;
  t29 = t28 * t26;
  t31 = 0.1e1 + t29 / 0.64e2;
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t27 * t33;
  t38 = M_CBRT6;
  t39 = (0.1e2 / 0.81e2 + t22 * t34 / 0.64e2) * t38;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t44 = t39 * t43;
  t45 = M_CBRT2;
  t46 = t45 * t45;
  t47 = sigma[0] * t46;
  t48 = t19 * t19;
  t50 = 0.1e1 / t48 / t23;
  t51 = t47 * t50;
  t54 = tau[0] * t46;
  t56 = 0.1e1 / t48 / rho[0];
  t59 = t54 * t56 - t51 / 0.8e1;
  t63 = 0.5e1 / 0.9e1 * t59 * t38 * t43 - 0.1e1;
  t64 = params->b * t59;
  t65 = t38 * t43;
  t66 = t65 * t63;
  t69 = 0.5e1 * t64 * t66 + 0.9e1;
  t70 = sqrt(t69);
  t71 = 0.1e1 / t70;
  t76 = 0.27e2 / 0.2e2 * t63 * t71 + t65 * t51 / 0.36e2;
  t77 = t76 * t76;
  t80 = t38 * t38;
  t82 = 0.1e1 / t41 / t40;
  t83 = t80 * t82;
  t84 = t21 * t45;
  t85 = t23 * t23;
  t86 = t85 * rho[0];
  t88 = 0.1e1 / t19 / t86;
  t89 = t84 * t88;
  t92 = 0.1e3 * t83 * t89 + 0.162e3 * t29;
  t93 = sqrt(t92);
  t96 = 0.1e1 / params->kappa;
  t97 = t96 * t80;
  t98 = t97 * t82;
  t101 = sqrt(params->e);
  t102 = t101 * t21;
  t105 = params->e * params->mu;
  t106 = t40 * t40;
  t107 = 0.1e1 / t106;
  t108 = t21 * sigma[0];
  t109 = t107 * t108;
  t110 = t85 * t85;
  t111 = 0.1e1 / t110;
  t115 = t44 * t51 / 0.24e2 + 0.146e3 / 0.2025e4 * t77 - 0.73e2 / 0.972e5 * t76 * t93 + 0.25e2 / 0.472392e6 * t98 * t89 + t102 * t27 / 0.72e3 + t105 * t109 * t111 / 0.576e3;
  t116 = t101 * t38;
  t120 = 0.1e1 + t116 * t43 * t51 / 0.24e2;
  t121 = t120 * t120;
  t122 = 0.1e1 / t121;
  t125 = exp(-t115 * t122 * t96);
  t128 = 0.1e1 + params->kappa * (0.1e1 - t125);
  t132 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t128);
  tzk0 = 0.2e1 * t132;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t50, t51, t54;
  double t56, t59, t63, t64, t65, t66, t69, t70;
  double t71, t76, t77, t80, t82, t83, t84, t85;
  double t86, t88, t89, t92, t93, t96, t97, t98;
  double t101, t102, t105, t106, t107, t108, t109, t110;
  double t111, t115, t116, t120, t121, t122, t125, t128;
  double t132, tzk0;

  double t133, t134, t138, t139, t140, t141, t142, t143;
  double t146, t147, t148, t149, t150, t153, t154, t158;
  double t159, t163, t164, t170, t171, t172, t176, t177;
  double t181, t184, t187, t189, t194, t195, t196, t199;
  double t201, t202, t205, t212, t213, t217, t220, t221;
  double t223, t224, t227, t228, t233, tvrho0, t236, t239;
  double t240, t241, t242, t246, t247, t250, t251, t254;
  double t255, t256, t258, t259, t260, t262, t263, t265;
  double t267, t270, t272, t277, t280, t281, t284, t289;
  double t292, t296, t301, t302, t306, tvsigma0, tvlapl0, t308;
  double t309, t310, t311, t314, t315, t317, t321, t322;
  double t325, t328, t334, t337, t342, t347, t349, t353;
  double tvtau0;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = sigma[0] * sigma[0];
  t22 = params->c * t21;
  t23 = rho[0] * rho[0];
  t24 = 0.1e1 / t23;
  t25 = tau[0] * tau[0];
  t26 = 0.1e1 / t25;
  t27 = t24 * t26;
  t28 = t21 * t24;
  t29 = t28 * t26;
  t31 = 0.1e1 + t29 / 0.64e2;
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t27 * t33;
  t38 = M_CBRT6;
  t39 = (0.1e2 / 0.81e2 + t22 * t34 / 0.64e2) * t38;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t44 = t39 * t43;
  t45 = M_CBRT2;
  t46 = t45 * t45;
  t47 = sigma[0] * t46;
  t48 = t19 * t19;
  t50 = 0.1e1 / t48 / t23;
  t51 = t47 * t50;
  t54 = tau[0] * t46;
  t56 = 0.1e1 / t48 / rho[0];
  t59 = t54 * t56 - t51 / 0.8e1;
  t63 = 0.5e1 / 0.9e1 * t59 * t38 * t43 - 0.1e1;
  t64 = params->b * t59;
  t65 = t38 * t43;
  t66 = t65 * t63;
  t69 = 0.5e1 * t64 * t66 + 0.9e1;
  t70 = sqrt(t69);
  t71 = 0.1e1 / t70;
  t76 = 0.27e2 / 0.2e2 * t63 * t71 + t65 * t51 / 0.36e2;
  t77 = t76 * t76;
  t80 = t38 * t38;
  t82 = 0.1e1 / t41 / t40;
  t83 = t80 * t82;
  t84 = t21 * t45;
  t85 = t23 * t23;
  t86 = t85 * rho[0];
  t88 = 0.1e1 / t19 / t86;
  t89 = t84 * t88;
  t92 = 0.1e3 * t83 * t89 + 0.162e3 * t29;
  t93 = sqrt(t92);
  t96 = 0.1e1 / params->kappa;
  t97 = t96 * t80;
  t98 = t97 * t82;
  t101 = sqrt(params->e);
  t102 = t101 * t21;
  t105 = params->e * params->mu;
  t106 = t40 * t40;
  t107 = 0.1e1 / t106;
  t108 = t21 * sigma[0];
  t109 = t107 * t108;
  t110 = t85 * t85;
  t111 = 0.1e1 / t110;
  t115 = t44 * t51 / 0.24e2 + 0.146e3 / 0.2025e4 * t77 - 0.73e2 / 0.972e5 * t76 * t93 + 0.25e2 / 0.472392e6 * t98 * t89 + t102 * t27 / 0.72e3 + t105 * t109 * t111 / 0.576e3;
  t116 = t101 * t38;
  t120 = 0.1e1 + t116 * t43 * t51 / 0.24e2;
  t121 = t120 * t120;
  t122 = 0.1e1 / t121;
  t125 = exp(-t115 * t122 * t96);
  t128 = 0.1e1 + params->kappa * (0.1e1 - t125);
  t132 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t128);
  tzk0 = 0.2e1 * t132;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t133 = 0.1e1 / t48;
  t134 = t18 * t133;
  t138 = t7 * t18;
  t139 = t19 * params->kappa;
  t140 = t23 * rho[0];
  t141 = 0.1e1 / t140;
  t142 = t141 * t26;
  t143 = t142 * t33;
  t146 = t21 * t21;
  t147 = params->c * t146;
  t148 = 0.1e1 / t86;
  t149 = t25 * t25;
  t150 = 0.1e1 / t149;
  t153 = 0.1e1 / t32 / t31;
  t154 = t148 * t150 * t153;
  t158 = (-t22 * t143 / 0.32e2 + t147 * t154 / 0.1024e4) * t38;
  t159 = t158 * t43;
  t163 = 0.1e1 / t48 / t140;
  t164 = t47 * t163;
  t170 = -0.5e1 / 0.3e1 * t54 * t50 + t164 / 0.3e1;
  t171 = t170 * t38;
  t172 = t43 * t71;
  t176 = 0.1e1 / t70 / t69;
  t177 = t63 * t176;
  t181 = t83 * t170;
  t184 = 0.5e1 * params->b * t170 * t66 + 0.25e2 / 0.9e1 * t64 * t181;
  t187 = t65 * t164;
  t189 = 0.3e1 / 0.4e1 * t171 * t172 - 0.27e2 / 0.4e2 * t177 * t184 - 0.2e1 / 0.27e2 * t187;
  t194 = 0.1e1 / t93;
  t195 = t76 * t194;
  t196 = t21 * t141;
  t199 = t85 * t23;
  t201 = 0.1e1 / t19 / t199;
  t202 = t84 * t201;
  t205 = -0.324e3 * t196 * t26 - 0.16e4 / 0.3e1 * t83 * t202;
  t212 = t110 * rho[0];
  t213 = 0.1e1 / t212;
  t217 = t159 * t51 / 0.24e2 - t44 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t76 * t189 - 0.73e2 / 0.972e5 * t189 * t93 - 0.73e2 / 0.1944e6 * t195 * t205 - 0.5e2 / 0.177147e6 * t98 * t202 - t102 * t142 / 0.36e3 - t105 * t109 * t213 / 0.72e2;
  t220 = t121 * t120;
  t221 = 0.1e1 / t220;
  t223 = t96 * t101;
  t224 = t115 * t221 * t223;
  t227 = -t217 * t122 * t96 - 0.2e1 / 0.9e1 * t224 * t187;
  t228 = t227 * t125;
  t233 = my_piecewise3(t3, 0, -t7 * t134 * t128 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t228);
  tvrho0 = 0.2e1 * rho[0] * t233 + 0.2e1 * t132;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t236 = params->c * sigma[0];
  t239 = params->c * t108;
  t240 = 0.1e1 / t85;
  t241 = t240 * t150;
  t242 = t241 * t153;
  t246 = (t236 * t34 / 0.32e2 - t239 * t242 / 0.1024e4) * t38;
  t247 = t246 * t43;
  t250 = t43 * t46;
  t251 = t250 * t50;
  t254 = t46 * t50;
  t255 = t65 * t71;
  t256 = t254 * t255;
  t258 = params->b * t46;
  t259 = t258 * t50;
  t260 = t259 * t66;
  t262 = t64 * t80;
  t263 = t82 * t46;
  t265 = t262 * t263 * t50;
  t267 = -0.5e1 / 0.8e1 * t260 - 0.25e2 / 0.72e2 * t265;
  t270 = t254 * t65;
  t272 = -0.3e1 / 0.32e2 * t256 - 0.27e2 / 0.4e2 * t177 * t267 + t270 / 0.36e2;
  t277 = sigma[0] * t24;
  t280 = sigma[0] * t45;
  t281 = t280 * t88;
  t284 = 0.324e3 * t277 * t26 + 0.2e3 * t83 * t281;
  t289 = t101 * sigma[0];
  t292 = t107 * t21;
  t296 = t247 * t51 / 0.24e2 + t39 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t272 - 0.73e2 / 0.972e5 * t272 * t93 - 0.73e2 / 0.1944e6 * t195 * t284 + 0.25e2 / 0.236196e6 * t98 * t281 + t289 * t27 / 0.36e3 + t105 * t292 * t111 / 0.192e3;
  t301 = -t296 * t122 * t96 + t224 * t270 / 0.12e2;
  t302 = t301 * t125;
  t306 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t302);
  tvsigma0 = 0.2e1 * rho[0] * t306;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t25 * tau[0];
  t309 = 0.1e1 / t308;
  t310 = t24 * t309;
  t311 = t310 * t33;
  t314 = t149 * tau[0];
  t315 = 0.1e1 / t314;
  t317 = t240 * t315 * t153;
  t321 = (-t22 * t311 / 0.32e2 + t147 * t317 / 0.1024e4) * t38;
  t322 = t321 * t43;
  t325 = t46 * t56;
  t328 = t258 * t56;
  t334 = 0.5e1 * t328 * t66 + 0.25e2 / 0.9e1 * t262 * t263 * t56;
  t337 = 0.3e1 / 0.4e1 * t325 * t255 - 0.27e2 / 0.4e2 * t177 * t334;
  t342 = t28 * t309;
  t347 = t322 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t337 - 0.73e2 / 0.972e5 * t337 * t93 + 0.73e2 / 0.6e3 * t195 * t342 - t102 * t310 / 0.36e3;
  t349 = t122 * t125;
  t353 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t347 * t349);
  tvtau0 = 0.2e1 * rho[0] * t353;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t50, t51, t54;
  double t56, t59, t63, t64, t65, t66, t69, t70;
  double t71, t76, t77, t80, t82, t83, t84, t85;
  double t86, t88, t89, t92, t93, t96, t97, t98;
  double t101, t102, t105, t106, t107, t108, t109, t110;
  double t111, t115, t116, t120, t121, t122, t125, t128;
  double t132, tzk0;

  double t133, t134, t138, t139, t140, t141, t142, t143;
  double t146, t147, t148, t149, t150, t153, t154, t158;
  double t159, t163, t164, t170, t171, t172, t176, t177;
  double t181, t184, t187, t189, t194, t195, t196, t199;
  double t201, t202, t205, t212, t213, t217, t220, t221;
  double t223, t224, t227, t228, t233, tvrho0, t236, t239;
  double t240, t241, t242, t246, t247, t250, t251, t254;
  double t255, t256, t258, t259, t260, t262, t263, t265;
  double t267, t270, t272, t277, t280, t281, t284, t289;
  double t292, t296, t301, t302, t306, tvsigma0, tvlapl0, t308;
  double t309, t310, t311, t314, t315, t317, t321, t322;
  double t325, t328, t334, t337, t342, t347, t349, t353;
  double tvtau0;

  double t356, t360, t364, t365, t368, t370, t373, t374;
  double t375, t376, t378, t379, t380, t384, t385, t391;
  double t392, t395, t400, t401, t404, t405, t408, t410;
  double t411, t412, t415, t418, t422, t425, t428, t430;
  double t435, t439, t440, t441, t444, t447, t449, t450;
  double t451, t453, t460, t461, t465, t469, t472, t473;
  double t475, t476, t481, t482, t486, t487, t492, tv2rho20;
  double t502, t503, t504, t506, t510, t511, t518, t523;
  double t524, t526, t527, t529, t532, t535, t536, t538;
  double t541, t543, t546, t548, t553, t558, t561, t564;
  double t565, t567, t577, t581, t590, t591, t595, t596;
  double t597, t601, tv2rhosigma0, tv2rholapl0, t608, t609, t613, t617;
  double t619, t623, t624, t632, t635, t638, t645, t648;
  double t653, t658, t659, t662, t667, t673, t674, t676;
  double t680, t681, t684, t685, t689, tv2rhotau0, t692, t693;
  double t698, t699, t703, t704, t709, t711, t713, t716;
  double t717, t718, t719, t721, t728, t733, t736, t740;
  double t743, t747, t754, t755, t758, t759, t764, tv2sigma20;
  double tv2sigmalapl0, t771, t775, t776, t785, t787, t791, t792;
  double t793, t794, t796, t805, t808, t813, t819, t820;
  double t825, t826, t829, t833, tv2sigmatau0, tv2lapl20, tv2lapltau0, t835;
  double t836, t839, t840, t843, t844, t846, t850, t851;
  double t854, t858, t861, t862, t865, t872, t873, t876;
  double t881, t885, t886, t887, t888, t892, tv2tau20;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = sigma[0] * sigma[0];
  t22 = params->c * t21;
  t23 = rho[0] * rho[0];
  t24 = 0.1e1 / t23;
  t25 = tau[0] * tau[0];
  t26 = 0.1e1 / t25;
  t27 = t24 * t26;
  t28 = t21 * t24;
  t29 = t28 * t26;
  t31 = 0.1e1 + t29 / 0.64e2;
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t27 * t33;
  t38 = M_CBRT6;
  t39 = (0.1e2 / 0.81e2 + t22 * t34 / 0.64e2) * t38;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t44 = t39 * t43;
  t45 = M_CBRT2;
  t46 = t45 * t45;
  t47 = sigma[0] * t46;
  t48 = t19 * t19;
  t50 = 0.1e1 / t48 / t23;
  t51 = t47 * t50;
  t54 = tau[0] * t46;
  t56 = 0.1e1 / t48 / rho[0];
  t59 = t54 * t56 - t51 / 0.8e1;
  t63 = 0.5e1 / 0.9e1 * t59 * t38 * t43 - 0.1e1;
  t64 = params->b * t59;
  t65 = t38 * t43;
  t66 = t65 * t63;
  t69 = 0.5e1 * t64 * t66 + 0.9e1;
  t70 = sqrt(t69);
  t71 = 0.1e1 / t70;
  t76 = 0.27e2 / 0.2e2 * t63 * t71 + t65 * t51 / 0.36e2;
  t77 = t76 * t76;
  t80 = t38 * t38;
  t82 = 0.1e1 / t41 / t40;
  t83 = t80 * t82;
  t84 = t21 * t45;
  t85 = t23 * t23;
  t86 = t85 * rho[0];
  t88 = 0.1e1 / t19 / t86;
  t89 = t84 * t88;
  t92 = 0.1e3 * t83 * t89 + 0.162e3 * t29;
  t93 = sqrt(t92);
  t96 = 0.1e1 / params->kappa;
  t97 = t96 * t80;
  t98 = t97 * t82;
  t101 = sqrt(params->e);
  t102 = t101 * t21;
  t105 = params->e * params->mu;
  t106 = t40 * t40;
  t107 = 0.1e1 / t106;
  t108 = t21 * sigma[0];
  t109 = t107 * t108;
  t110 = t85 * t85;
  t111 = 0.1e1 / t110;
  t115 = t44 * t51 / 0.24e2 + 0.146e3 / 0.2025e4 * t77 - 0.73e2 / 0.972e5 * t76 * t93 + 0.25e2 / 0.472392e6 * t98 * t89 + t102 * t27 / 0.72e3 + t105 * t109 * t111 / 0.576e3;
  t116 = t101 * t38;
  t120 = 0.1e1 + t116 * t43 * t51 / 0.24e2;
  t121 = t120 * t120;
  t122 = 0.1e1 / t121;
  t125 = exp(-t115 * t122 * t96);
  t128 = 0.1e1 + params->kappa * (0.1e1 - t125);
  t132 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t128);
  tzk0 = 0.2e1 * t132;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t133 = 0.1e1 / t48;
  t134 = t18 * t133;
  t138 = t7 * t18;
  t139 = t19 * params->kappa;
  t140 = t23 * rho[0];
  t141 = 0.1e1 / t140;
  t142 = t141 * t26;
  t143 = t142 * t33;
  t146 = t21 * t21;
  t147 = params->c * t146;
  t148 = 0.1e1 / t86;
  t149 = t25 * t25;
  t150 = 0.1e1 / t149;
  t153 = 0.1e1 / t32 / t31;
  t154 = t148 * t150 * t153;
  t158 = (-t22 * t143 / 0.32e2 + t147 * t154 / 0.1024e4) * t38;
  t159 = t158 * t43;
  t163 = 0.1e1 / t48 / t140;
  t164 = t47 * t163;
  t170 = -0.5e1 / 0.3e1 * t54 * t50 + t164 / 0.3e1;
  t171 = t170 * t38;
  t172 = t43 * t71;
  t176 = 0.1e1 / t70 / t69;
  t177 = t63 * t176;
  t181 = t83 * t170;
  t184 = 0.5e1 * params->b * t170 * t66 + 0.25e2 / 0.9e1 * t64 * t181;
  t187 = t65 * t164;
  t189 = 0.3e1 / 0.4e1 * t171 * t172 - 0.27e2 / 0.4e2 * t177 * t184 - 0.2e1 / 0.27e2 * t187;
  t194 = 0.1e1 / t93;
  t195 = t76 * t194;
  t196 = t21 * t141;
  t199 = t85 * t23;
  t201 = 0.1e1 / t19 / t199;
  t202 = t84 * t201;
  t205 = -0.324e3 * t196 * t26 - 0.16e4 / 0.3e1 * t83 * t202;
  t212 = t110 * rho[0];
  t213 = 0.1e1 / t212;
  t217 = t159 * t51 / 0.24e2 - t44 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t76 * t189 - 0.73e2 / 0.972e5 * t189 * t93 - 0.73e2 / 0.1944e6 * t195 * t205 - 0.5e2 / 0.177147e6 * t98 * t202 - t102 * t142 / 0.36e3 - t105 * t109 * t213 / 0.72e2;
  t220 = t121 * t120;
  t221 = 0.1e1 / t220;
  t223 = t96 * t101;
  t224 = t115 * t221 * t223;
  t227 = -t217 * t122 * t96 - 0.2e1 / 0.9e1 * t224 * t187;
  t228 = t227 * t125;
  t233 = my_piecewise3(t3, 0, -t7 * t134 * t128 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t228);
  tvrho0 = 0.2e1 * rho[0] * t233 + 0.2e1 * t132;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t236 = params->c * sigma[0];
  t239 = params->c * t108;
  t240 = 0.1e1 / t85;
  t241 = t240 * t150;
  t242 = t241 * t153;
  t246 = (t236 * t34 / 0.32e2 - t239 * t242 / 0.1024e4) * t38;
  t247 = t246 * t43;
  t250 = t43 * t46;
  t251 = t250 * t50;
  t254 = t46 * t50;
  t255 = t65 * t71;
  t256 = t254 * t255;
  t258 = params->b * t46;
  t259 = t258 * t50;
  t260 = t259 * t66;
  t262 = t64 * t80;
  t263 = t82 * t46;
  t265 = t262 * t263 * t50;
  t267 = -0.5e1 / 0.8e1 * t260 - 0.25e2 / 0.72e2 * t265;
  t270 = t254 * t65;
  t272 = -0.3e1 / 0.32e2 * t256 - 0.27e2 / 0.4e2 * t177 * t267 + t270 / 0.36e2;
  t277 = sigma[0] * t24;
  t280 = sigma[0] * t45;
  t281 = t280 * t88;
  t284 = 0.324e3 * t277 * t26 + 0.2e3 * t83 * t281;
  t289 = t101 * sigma[0];
  t292 = t107 * t21;
  t296 = t247 * t51 / 0.24e2 + t39 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t272 - 0.73e2 / 0.972e5 * t272 * t93 - 0.73e2 / 0.1944e6 * t195 * t284 + 0.25e2 / 0.236196e6 * t98 * t281 + t289 * t27 / 0.36e3 + t105 * t292 * t111 / 0.192e3;
  t301 = -t296 * t122 * t96 + t224 * t270 / 0.12e2;
  t302 = t301 * t125;
  t306 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t302);
  tvsigma0 = 0.2e1 * rho[0] * t306;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t25 * tau[0];
  t309 = 0.1e1 / t308;
  t310 = t24 * t309;
  t311 = t310 * t33;
  t314 = t149 * tau[0];
  t315 = 0.1e1 / t314;
  t317 = t240 * t315 * t153;
  t321 = (-t22 * t311 / 0.32e2 + t147 * t317 / 0.1024e4) * t38;
  t322 = t321 * t43;
  t325 = t46 * t56;
  t328 = t258 * t56;
  t334 = 0.5e1 * t328 * t66 + 0.25e2 / 0.9e1 * t262 * t263 * t56;
  t337 = 0.3e1 / 0.4e1 * t325 * t255 - 0.27e2 / 0.4e2 * t177 * t334;
  t342 = t28 * t309;
  t347 = t322 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t337 - 0.73e2 / 0.972e5 * t337 * t93 + 0.73e2 / 0.6e3 * t195 * t342 - t102 * t310 / 0.36e3;
  t349 = t122 * t125;
  t353 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t347 * t349);
  tvtau0 = 0.2e1 * rho[0] * t353;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t356 = t18 * t56;
  t360 = t133 * params->kappa;
  t364 = t240 * t26;
  t365 = t364 * t33;
  t368 = 0.1e1 / t199;
  t370 = t368 * t150 * t153;
  t373 = t146 * t21;
  t374 = params->c * t373;
  t375 = t149 * t25;
  t376 = 0.1e1 / t375;
  t378 = t32 * t32;
  t379 = 0.1e1 / t378;
  t380 = t111 * t376 * t379;
  t384 = (0.3e1 / 0.32e2 * t22 * t365 - 0.7e1 / 0.1024e4 * t147 * t370 + 0.3e1 / 0.32768e5 * t374 * t380) * t38;
  t385 = t384 * t43;
  t391 = 0.1e1 / t48 / t85;
  t392 = t47 * t391;
  t395 = t189 * t189;
  t400 = 0.4e2 / 0.9e1 * t54 * t163 - 0.11e2 / 0.9e1 * t392;
  t401 = t400 * t38;
  t404 = t43 * t176;
  t405 = t404 * t184;
  t408 = t69 * t69;
  t410 = 0.1e1 / t70 / t408;
  t411 = t63 * t410;
  t412 = t184 * t184;
  t415 = params->b * t400;
  t418 = t170 * t170;
  t422 = t83 * t400;
  t425 = 0.5e1 * t415 * t66 + 0.5e2 / 0.9e1 * params->b * t418 * t83 + 0.25e2 / 0.9e1 * t64 * t422;
  t428 = t65 * t392;
  t430 = 0.3e1 / 0.4e1 * t401 * t172 - 0.3e1 / 0.4e1 * t171 * t405 + 0.81e2 / 0.8e2 * t411 * t412 - 0.27e2 / 0.4e2 * t177 * t425 + 0.22e2 / 0.81e2 * t428;
  t435 = t189 * t194;
  t439 = 0.1e1 / t93 / t92;
  t440 = t76 * t439;
  t441 = t205 * t205;
  t444 = t21 * t240;
  t447 = t85 * t140;
  t449 = 0.1e1 / t19 / t447;
  t450 = t84 * t449;
  t451 = t83 * t450;
  t453 = 0.972e3 * t444 * t26 + 0.304e5 / 0.9e1 * t451;
  t460 = t110 * t23;
  t461 = 0.1e1 / t460;
  t465 = t385 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t159 * t164 + 0.11e2 / 0.27e2 * t44 * t392 + 0.292e3 / 0.2025e4 * t395 + 0.292e3 / 0.2025e4 * t76 * t430 - 0.73e2 / 0.972e5 * t430 * t93 - 0.73e2 / 0.972e5 * t435 * t205 + 0.73e2 / 0.3888e6 * t440 * t441 - 0.73e2 / 0.1944e6 * t195 * t453 + 0.95e3 / 0.531441e6 * t98 * t450 + t102 * t364 / 0.12e3 + t105 * t109 * t461 / 0.8e1;
  t469 = t217 * t221 * t223;
  t472 = t121 * t121;
  t473 = 0.1e1 / t472;
  t475 = t96 * params->e;
  t476 = t115 * t473 * t475;
  t481 = -t465 * t122 * t96 - 0.4e1 / 0.9e1 * t469 * t187 - 0.4e1 / 0.27e2 * t476 * t451 + 0.22e2 / 0.27e2 * t224 * t428;
  t482 = t481 * t125;
  t486 = t227 * t227;
  t487 = t486 * t125;
  t492 = my_piecewise3(t3, 0, t7 * t356 * t128 / 0.12e2 + t138 * t360 * t228 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t482 + 0.3e1 / 0.8e1 * t138 * t139 * t487);
  tv2rho20 = 0.2e1 * rho[0] * t492 + 0.4e1 * t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t502 = t146 * sigma[0];
  t503 = params->c * t502;
  t504 = 0.1e1 / t447;
  t506 = t504 * t376 * t379;
  t510 = (-t236 * t143 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t154 - 0.3e1 / 0.32768e5 * t503 * t506) * t38;
  t511 = t510 * t43;
  t518 = t250 * t163;
  t523 = t46 * t163;
  t524 = t523 * t255;
  t526 = t254 * t38;
  t527 = t526 * t405;
  t529 = t404 * t267;
  t532 = t267 * t184;
  t535 = t258 * t163;
  t536 = t535 * t66;
  t538 = t259 * t181;
  t541 = t262 * t263 * t163;
  t543 = 0.5e1 / 0.3e1 * t536 - 0.25e2 / 0.36e2 * t538 + 0.25e2 / 0.27e2 * t541;
  t546 = t523 * t65;
  t548 = t524 / 0.4e1 + 0.3e1 / 0.64e2 * t527 - 0.3e1 / 0.8e1 * t171 * t529 + 0.81e2 / 0.8e2 * t411 * t532 - 0.27e2 / 0.4e2 * t177 * t543 - 0.2e1 / 0.27e2 * t546;
  t553 = t272 * t194;
  t558 = t284 * t205;
  t561 = sigma[0] * t141;
  t564 = t280 * t201;
  t565 = t83 * t564;
  t567 = -0.648e3 * t561 * t26 - 0.32e4 / 0.3e1 * t565;
  t577 = t511 * t51 / 0.24e2 - t247 * t164 / 0.9e1 + t158 * t251 / 0.24e2 - t39 * t518 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t272 + 0.292e3 / 0.2025e4 * t76 * t548 - 0.73e2 / 0.972e5 * t548 * t93 - 0.73e2 / 0.1944e6 * t553 * t205 - 0.73e2 / 0.1944e6 * t435 * t284 + 0.73e2 / 0.3888e6 * t440 * t558 - 0.73e2 / 0.1944e6 * t195 * t567 - 0.1e3 / 0.177147e6 * t98 * t564 - t289 * t142 / 0.18e3 - t105 * t292 * t213 / 0.24e2;
  t581 = t296 * t221 * t223;
  t590 = -t577 * t122 * t96 - 0.2e1 / 0.9e1 * t581 * t187 + t469 * t270 / 0.12e2 + t476 * t565 / 0.18e2 - 0.2e1 / 0.9e1 * t224 * t546;
  t591 = t590 * t125;
  t595 = t7 * t20;
  t596 = params->kappa * t301;
  t597 = t596 * t228;
  t601 = my_piecewise3(t3, 0, t138 * t360 * t302 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t591 + 0.3e1 / 0.8e1 * t595 * t597);
  tv2rhosigma0 = 0.2e1 * rho[0] * t601 + 0.2e1 * t306;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t608 = t141 * t309;
  t609 = t608 * t33;
  t613 = t148 * t315 * t153;
  t617 = 0.1e1 / t149 / t308;
  t619 = t504 * t617 * t379;
  t623 = (t22 * t609 / 0.16e2 - 0.3e1 / 0.512e3 * t147 * t613 + 0.3e1 / 0.32768e5 * t374 * t619) * t38;
  t624 = t623 * t43;
  t632 = t325 * t38;
  t635 = t404 * t334;
  t638 = t334 * t184;
  t645 = -0.25e2 / 0.3e1 * t260 + 0.5e2 / 0.9e1 * t328 * t181 - 0.125e3 / 0.27e2 * t265;
  t648 = -0.5e1 / 0.4e1 * t256 - 0.3e1 / 0.8e1 * t632 * t405 - 0.3e1 / 0.8e1 * t171 * t635 + 0.81e2 / 0.8e2 * t411 * t638 - 0.27e2 / 0.4e2 * t177 * t645;
  t653 = t337 * t194;
  t658 = t440 * t21;
  t659 = t310 * t205;
  t662 = t196 * t309;
  t667 = t624 * t51 / 0.24e2 - t322 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t337 + 0.292e3 / 0.2025e4 * t76 * t648 - 0.73e2 / 0.972e5 * t648 * t93 - 0.73e2 / 0.1944e6 * t653 * t205 + 0.73e2 / 0.6e3 * t435 * t342 - 0.73e2 / 0.12e4 * t658 * t659 - 0.73e2 / 0.3e3 * t195 * t662 + t102 * t608 / 0.18e3;
  t673 = 0.1e1 / t19 / t140;
  t674 = t673 * t347;
  t676 = t138 * t674 * t221;
  t680 = t43 * sigma[0] * t46;
  t681 = t125 * t101 * t38 * t680;
  t684 = t347 * t122;
  t685 = t684 * t228;
  t689 = my_piecewise3(t3, 0, -t138 * t133 * t347 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t667 * t349 - t676 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t685);
  tv2rhotau0 = 0.2e1 * rho[0] * t689 + 0.2e1 * t353;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t692 = params->c * t24;
  t693 = t26 * t33;
  t698 = t368 * t376;
  t699 = t698 * t379;
  t703 = (t692 * t693 / 0.32e2 - 0.5e1 / 0.1024e4 * t22 * t242 + 0.3e1 / 0.32768e5 * t147 * t699) * t38;
  t704 = t703 * t43;
  t709 = t272 * t272;
  t711 = t526 * t529;
  t713 = t267 * t267;
  t716 = t177 * params->b;
  t717 = t45 * t88;
  t718 = t83 * t717;
  t719 = t716 * t718;
  t721 = 0.3e1 / 0.32e2 * t711 + 0.81e2 / 0.8e2 * t411 * t713 - 0.15e2 / 0.128e3 * t719;
  t728 = t284 * t284;
  t733 = 0.324e3 * t27 + 0.2e3 * t718;
  t736 = t82 * t45;
  t740 = t101 * t24;
  t743 = t107 * sigma[0];
  t747 = t704 * t51 / 0.24e2 + t246 * t251 / 0.12e2 + 0.292e3 / 0.2025e4 * t709 + 0.292e3 / 0.2025e4 * t76 * t721 - 0.73e2 / 0.972e5 * t721 * t93 - 0.73e2 / 0.972e5 * t553 * t284 + 0.73e2 / 0.3888e6 * t440 * t728 - 0.73e2 / 0.1944e6 * t195 * t733 + 0.25e2 / 0.236196e6 * t97 * t736 * t88 + t740 * t26 / 0.36e3 + t105 * t743 * t111 / 0.96e2;
  t754 = -t747 * t122 * t96 + t581 * t270 / 0.6e1 - t476 * t718 / 0.48e2;
  t755 = t754 * t125;
  t758 = t301 * t301;
  t759 = t758 * t125;
  t764 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t755 + 0.3e1 / 0.8e1 * t138 * t139 * t759);
  tv2sigma20 = 0.2e1 * rho[0] * t764;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t771 = t368 * t617 * t379;
  t775 = (-t236 * t311 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t317 - 0.3e1 / 0.32768e5 * t503 * t771) * t38;
  t776 = t775 * t43;
  t785 = t526 * t635;
  t787 = t334 * t267;
  t791 = 0.1e1 / t19 / t85;
  t792 = t45 * t791;
  t793 = t792 * t83;
  t794 = t716 * t793;
  t796 = -0.3e1 / 0.8e1 * t632 * t529 + 0.3e1 / 0.64e2 * t785 + 0.81e2 / 0.8e2 * t411 * t787 + 0.15e2 / 0.16e2 * t794;
  t805 = t310 * t284;
  t808 = t277 * t309;
  t813 = t776 * t51 / 0.24e2 + t321 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t272 * t337 + 0.292e3 / 0.2025e4 * t76 * t796 - 0.73e2 / 0.972e5 * t796 * t93 - 0.73e2 / 0.1944e6 * t653 * t284 + 0.73e2 / 0.6e3 * t553 * t342 - 0.73e2 / 0.12e4 * t658 * t805 + 0.73e2 / 0.3e3 * t195 * t808 - t289 * t310 / 0.18e3;
  t819 = 0.1e1 / t19 / t23;
  t820 = t18 * t819;
  t825 = t65 * t46;
  t826 = t221 * t125 * t101 * t825;
  t829 = t684 * t302;
  t833 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t813 * t349 + t7 * t820 * t347 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t829);
  tv2sigmatau0 = 0.2e1 * rho[0] * t833;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t835 = t24 * t150;
  t836 = t835 * t33;
  t839 = t240 * t376;
  t840 = t839 * t153;
  t843 = t149 * t149;
  t844 = 0.1e1 / t843;
  t846 = t368 * t844 * t379;
  t850 = (0.3e1 / 0.32e2 * t22 * t836 - 0.7e1 / 0.1024e4 * t147 * t840 + 0.3e1 / 0.32768e5 * t374 * t846) * t38;
  t851 = t850 * t43;
  t854 = t337 * t337;
  t858 = t334 * t334;
  t861 = t45 * t673;
  t862 = t861 * t83;
  t865 = -0.3e1 / 0.4e1 * t632 * t635 + 0.81e2 / 0.8e2 * t411 * t858 - 0.15e2 / 0.2e1 * t716 * t862;
  t872 = t146 * t240;
  t873 = t872 * t376;
  t876 = t28 * t150;
  t881 = t851 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t854 + 0.292e3 / 0.2025e4 * t76 * t865 - 0.73e2 / 0.972e5 * t865 * t93 + 0.73e2 / 0.3e3 * t653 * t342 + 0.1971e4 / 0.1e3 * t440 * t873 - 0.73e2 / 0.2e3 * t195 * t876 + t102 * t835 / 0.12e3;
  t885 = t347 * t347;
  t886 = t885 * t473;
  t887 = t96 * t125;
  t888 = t886 * t887;
  t892 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t881 * t349 + 0.3e1 / 0.8e1 * t595 * t888);
  tv2tau20 = 0.2e1 * rho[0] * t892;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t50, t51, t54;
  double t56, t59, t63, t64, t65, t66, t69, t70;
  double t71, t76, t77, t80, t82, t83, t84, t85;
  double t86, t88, t89, t92, t93, t96, t97, t98;
  double t101, t102, t105, t106, t107, t108, t109, t110;
  double t111, t115, t116, t120, t121, t122, t125, t128;
  double t132, tzk0;

  double t133, t134, t138, t139, t140, t141, t142, t143;
  double t146, t147, t148, t149, t150, t153, t154, t158;
  double t159, t163, t164, t170, t171, t172, t176, t177;
  double t181, t184, t187, t189, t194, t195, t196, t199;
  double t201, t202, t205, t212, t213, t217, t220, t221;
  double t223, t224, t227, t228, t233, tvrho0, t236, t239;
  double t240, t241, t242, t246, t247, t250, t251, t254;
  double t255, t256, t258, t259, t260, t262, t263, t265;
  double t267, t270, t272, t277, t280, t281, t284, t289;
  double t292, t296, t301, t302, t306, tvsigma0, tvlapl0, t308;
  double t309, t310, t311, t314, t315, t317, t321, t322;
  double t325, t328, t334, t337, t342, t347, t349, t353;
  double tvtau0;

  double t356, t360, t364, t365, t368, t370, t373, t374;
  double t375, t376, t378, t379, t380, t384, t385, t391;
  double t392, t395, t400, t401, t404, t405, t408, t410;
  double t411, t412, t415, t418, t422, t425, t428, t430;
  double t435, t439, t440, t441, t444, t447, t449, t450;
  double t451, t453, t460, t461, t465, t469, t472, t473;
  double t475, t476, t481, t482, t486, t487, t492, tv2rho20;
  double t502, t503, t504, t506, t510, t511, t518, t523;
  double t524, t526, t527, t529, t532, t535, t536, t538;
  double t541, t543, t546, t548, t553, t558, t561, t564;
  double t565, t567, t577, t581, t590, t591, t595, t596;
  double t597, t601, tv2rhosigma0, tv2rholapl0, t608, t609, t613, t617;
  double t619, t623, t624, t632, t635, t638, t645, t648;
  double t653, t658, t659, t662, t667, t673, t674, t676;
  double t680, t681, t684, t685, t689, tv2rhotau0, t692, t693;
  double t698, t699, t703, t704, t709, t711, t713, t716;
  double t717, t718, t719, t721, t728, t733, t736, t740;
  double t743, t747, t754, t755, t758, t759, t764, tv2sigma20;
  double tv2sigmalapl0, t771, t775, t776, t785, t787, t791, t792;
  double t793, t794, t796, t805, t808, t813, t819, t820;
  double t825, t826, t829, t833, tv2sigmatau0, tv2lapl20, tv2lapltau0, t835;
  double t836, t839, t840, t843, t844, t846, t850, t851;
  double t854, t858, t861, t862, t865, t872, t873, t876;
  double t881, t885, t886, t887, t888, t892, tv2tau20;

  double t899, t909, t910, t914, t918, t921, t922, t923;
  double t924, t927, t928, t932, t933, t941, t942, t950;
  double t951, t956, t957, t960, t965, t966, t967, t970;
  double t973, t978, t981, t984, t986, t991, t994, t999;
  double t1001, t1002, t1003, t1006, t1009, t1013, t1014, t1015;
  double t1017, t1027, t1031, t1035, t1041, t1043, t1044, t1045;
  double t1047, t1054, t1055, t1059, t1060, t1064, t1069, tv3rho30;
  double t1079, t1086, t1087, t1089, t1090, t1092, t1094, t1098;
  double t1099, t1100, t1103, t1106, t1109, t1112, t1115, t1116;
  double t1118, t1120, t1123, t1125, t1128, t1130, t1135, t1144;
  double t1147, t1148, t1150, t1157, t1167, t1169, t1173, t1174;
  double t1179, t1182, t1187, t1190, t1195, t1203, t1204, t1208;
  double t1212, t1224, t1231, t1232, t1236, t1237, t1240, t1243;
  double t1247, tv3rho2sigma0, tv3rho2lapl0, t1261, t1266, t1267, t1271, t1275;
  double t1279, t1281, t1285, t1286, t1305, t1306, t1309, t1312;
  double t1315, t1318, t1326, t1329, t1334, t1337, t1344, t1349;
  double t1350, t1353, t1356, t1359, t1364, t1371, t1374, t1375;
  double t1380, t1382, t1385, t1388, t1389, t1390, t1393, t1396;
  double t1399, t1400, tv3rho2tau0, t1406, t1409, t1410, t1411, t1417;
  double t1421, t1422, t1435, t1437, t1438, t1440, t1442, t1445;
  double t1448, t1451, t1452, t1453, t1454, t1455, t1457, t1458;
  double t1459, t1461, t1464, t1465, t1467, t1472, t1484, t1487;
  double t1492, t1497, t1503, t1509, t1510, t1514, t1526, t1531;
  double t1532, t1536, t1537, t1543, t1546, t1547, t1551, tv3rhosigma20;
  double tv3rhosigmalapl0, t1565, t1569, t1570, t1590, t1592, t1593, t1595;
  double t1597, t1603, t1606, t1609, t1610, t1612, t1614, t1617;
  double t1622, t1629, t1634, t1641, t1644, t1647, t1652, t1655;
  double t1660, t1661, t1668, t1671, t1672, t1675, t1686, t1688;
  double t1691, t1693, t1694, t1699, t1702, t1703, t1706, t1710;
  double t1711, t1714, t1715, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1722, t1723;
  double t1726, t1727, t1731, t1735, t1737, t1741, t1742, t1756;
  double t1759, t1762, t1765, t1768, t1773, t1778, t1783, t1790;
  double t1791, t1794, t1795, t1800, t1803, t1808, t1813, t1815;
  double t1818, t1819, t1824, t1825, t1826, t1829, t1831, t1832;
  double t1833, t1837, t1838, t1842, tv3rhotau20, t1845, t1846, t1851;
  double t1852, t1856, t1857, t1864, t1866, t1867, t1868, t1870;
  double t1873, t1874, t1875, t1877, t1888, t1891, t1896, t1903;
  double t1906, t1907, t1911, t1914, t1915, t1920, tv3sigma30, tv3sigma2lapl0;
  double t1922, t1930, t1934, t1935, t1946, t1947, t1949, t1950;
  double t1952, t1955, t1957, t1959, t1960, t1961, t1963, t1980;
  double t1985, t1992, t2001, t2004, t2009, t2010, t2013, t2016;
  double t2019, t2023, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t2032, t2036, t2037;
  double t2048, t2049, t2051, t2053, t2056, t2061, t2076, t2079;
  double t2080, t2085, t2088, t2093, t2102, t2105, t2106, t2111;
  double t2112, t2116, t2117, t2121, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t2123, t2124, t2127, t2128, t2131, t2132, t2136, t2138;
  double t2142, t2143, t2150, t2153, t2158, t2169, t2170, t2173;
  double t2176, t2181, t2186, t2188, t2189, t2192, t2194, t2195;
  double t2196, t2197, t2198, t2199, t2203, tv3tau30;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = sigma[0] * sigma[0];
  t22 = params->c * t21;
  t23 = rho[0] * rho[0];
  t24 = 0.1e1 / t23;
  t25 = tau[0] * tau[0];
  t26 = 0.1e1 / t25;
  t27 = t24 * t26;
  t28 = t21 * t24;
  t29 = t28 * t26;
  t31 = 0.1e1 + t29 / 0.64e2;
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t27 * t33;
  t38 = M_CBRT6;
  t39 = (0.1e2 / 0.81e2 + t22 * t34 / 0.64e2) * t38;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t44 = t39 * t43;
  t45 = M_CBRT2;
  t46 = t45 * t45;
  t47 = sigma[0] * t46;
  t48 = t19 * t19;
  t50 = 0.1e1 / t48 / t23;
  t51 = t47 * t50;
  t54 = tau[0] * t46;
  t56 = 0.1e1 / t48 / rho[0];
  t59 = t54 * t56 - t51 / 0.8e1;
  t63 = 0.5e1 / 0.9e1 * t59 * t38 * t43 - 0.1e1;
  t64 = params->b * t59;
  t65 = t38 * t43;
  t66 = t65 * t63;
  t69 = 0.5e1 * t64 * t66 + 0.9e1;
  t70 = sqrt(t69);
  t71 = 0.1e1 / t70;
  t76 = 0.27e2 / 0.2e2 * t63 * t71 + t65 * t51 / 0.36e2;
  t77 = t76 * t76;
  t80 = t38 * t38;
  t82 = 0.1e1 / t41 / t40;
  t83 = t80 * t82;
  t84 = t21 * t45;
  t85 = t23 * t23;
  t86 = t85 * rho[0];
  t88 = 0.1e1 / t19 / t86;
  t89 = t84 * t88;
  t92 = 0.1e3 * t83 * t89 + 0.162e3 * t29;
  t93 = sqrt(t92);
  t96 = 0.1e1 / params->kappa;
  t97 = t96 * t80;
  t98 = t97 * t82;
  t101 = sqrt(params->e);
  t102 = t101 * t21;
  t105 = params->e * params->mu;
  t106 = t40 * t40;
  t107 = 0.1e1 / t106;
  t108 = t21 * sigma[0];
  t109 = t107 * t108;
  t110 = t85 * t85;
  t111 = 0.1e1 / t110;
  t115 = t44 * t51 / 0.24e2 + 0.146e3 / 0.2025e4 * t77 - 0.73e2 / 0.972e5 * t76 * t93 + 0.25e2 / 0.472392e6 * t98 * t89 + t102 * t27 / 0.72e3 + t105 * t109 * t111 / 0.576e3;
  t116 = t101 * t38;
  t120 = 0.1e1 + t116 * t43 * t51 / 0.24e2;
  t121 = t120 * t120;
  t122 = 0.1e1 / t121;
  t125 = exp(-t115 * t122 * t96);
  t128 = 0.1e1 + params->kappa * (0.1e1 - t125);
  t132 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t128);
  tzk0 = 0.2e1 * t132;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t133 = 0.1e1 / t48;
  t134 = t18 * t133;
  t138 = t7 * t18;
  t139 = t19 * params->kappa;
  t140 = t23 * rho[0];
  t141 = 0.1e1 / t140;
  t142 = t141 * t26;
  t143 = t142 * t33;
  t146 = t21 * t21;
  t147 = params->c * t146;
  t148 = 0.1e1 / t86;
  t149 = t25 * t25;
  t150 = 0.1e1 / t149;
  t153 = 0.1e1 / t32 / t31;
  t154 = t148 * t150 * t153;
  t158 = (-t22 * t143 / 0.32e2 + t147 * t154 / 0.1024e4) * t38;
  t159 = t158 * t43;
  t163 = 0.1e1 / t48 / t140;
  t164 = t47 * t163;
  t170 = -0.5e1 / 0.3e1 * t54 * t50 + t164 / 0.3e1;
  t171 = t170 * t38;
  t172 = t43 * t71;
  t176 = 0.1e1 / t70 / t69;
  t177 = t63 * t176;
  t181 = t83 * t170;
  t184 = 0.5e1 * params->b * t170 * t66 + 0.25e2 / 0.9e1 * t64 * t181;
  t187 = t65 * t164;
  t189 = 0.3e1 / 0.4e1 * t171 * t172 - 0.27e2 / 0.4e2 * t177 * t184 - 0.2e1 / 0.27e2 * t187;
  t194 = 0.1e1 / t93;
  t195 = t76 * t194;
  t196 = t21 * t141;
  t199 = t85 * t23;
  t201 = 0.1e1 / t19 / t199;
  t202 = t84 * t201;
  t205 = -0.324e3 * t196 * t26 - 0.16e4 / 0.3e1 * t83 * t202;
  t212 = t110 * rho[0];
  t213 = 0.1e1 / t212;
  t217 = t159 * t51 / 0.24e2 - t44 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t76 * t189 - 0.73e2 / 0.972e5 * t189 * t93 - 0.73e2 / 0.1944e6 * t195 * t205 - 0.5e2 / 0.177147e6 * t98 * t202 - t102 * t142 / 0.36e3 - t105 * t109 * t213 / 0.72e2;
  t220 = t121 * t120;
  t221 = 0.1e1 / t220;
  t223 = t96 * t101;
  t224 = t115 * t221 * t223;
  t227 = -t217 * t122 * t96 - 0.2e1 / 0.9e1 * t224 * t187;
  t228 = t227 * t125;
  t233 = my_piecewise3(t3, 0, -t7 * t134 * t128 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t228);
  tvrho0 = 0.2e1 * rho[0] * t233 + 0.2e1 * t132;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t236 = params->c * sigma[0];
  t239 = params->c * t108;
  t240 = 0.1e1 / t85;
  t241 = t240 * t150;
  t242 = t241 * t153;
  t246 = (t236 * t34 / 0.32e2 - t239 * t242 / 0.1024e4) * t38;
  t247 = t246 * t43;
  t250 = t43 * t46;
  t251 = t250 * t50;
  t254 = t46 * t50;
  t255 = t65 * t71;
  t256 = t254 * t255;
  t258 = params->b * t46;
  t259 = t258 * t50;
  t260 = t259 * t66;
  t262 = t64 * t80;
  t263 = t82 * t46;
  t265 = t262 * t263 * t50;
  t267 = -0.5e1 / 0.8e1 * t260 - 0.25e2 / 0.72e2 * t265;
  t270 = t254 * t65;
  t272 = -0.3e1 / 0.32e2 * t256 - 0.27e2 / 0.4e2 * t177 * t267 + t270 / 0.36e2;
  t277 = sigma[0] * t24;
  t280 = sigma[0] * t45;
  t281 = t280 * t88;
  t284 = 0.324e3 * t277 * t26 + 0.2e3 * t83 * t281;
  t289 = t101 * sigma[0];
  t292 = t107 * t21;
  t296 = t247 * t51 / 0.24e2 + t39 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t272 - 0.73e2 / 0.972e5 * t272 * t93 - 0.73e2 / 0.1944e6 * t195 * t284 + 0.25e2 / 0.236196e6 * t98 * t281 + t289 * t27 / 0.36e3 + t105 * t292 * t111 / 0.192e3;
  t301 = -t296 * t122 * t96 + t224 * t270 / 0.12e2;
  t302 = t301 * t125;
  t306 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t302);
  tvsigma0 = 0.2e1 * rho[0] * t306;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t25 * tau[0];
  t309 = 0.1e1 / t308;
  t310 = t24 * t309;
  t311 = t310 * t33;
  t314 = t149 * tau[0];
  t315 = 0.1e1 / t314;
  t317 = t240 * t315 * t153;
  t321 = (-t22 * t311 / 0.32e2 + t147 * t317 / 0.1024e4) * t38;
  t322 = t321 * t43;
  t325 = t46 * t56;
  t328 = t258 * t56;
  t334 = 0.5e1 * t328 * t66 + 0.25e2 / 0.9e1 * t262 * t263 * t56;
  t337 = 0.3e1 / 0.4e1 * t325 * t255 - 0.27e2 / 0.4e2 * t177 * t334;
  t342 = t28 * t309;
  t347 = t322 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t337 - 0.73e2 / 0.972e5 * t337 * t93 + 0.73e2 / 0.6e3 * t195 * t342 - t102 * t310 / 0.36e3;
  t349 = t122 * t125;
  t353 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t347 * t349);
  tvtau0 = 0.2e1 * rho[0] * t353;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t356 = t18 * t56;
  t360 = t133 * params->kappa;
  t364 = t240 * t26;
  t365 = t364 * t33;
  t368 = 0.1e1 / t199;
  t370 = t368 * t150 * t153;
  t373 = t146 * t21;
  t374 = params->c * t373;
  t375 = t149 * t25;
  t376 = 0.1e1 / t375;
  t378 = t32 * t32;
  t379 = 0.1e1 / t378;
  t380 = t111 * t376 * t379;
  t384 = (0.3e1 / 0.32e2 * t22 * t365 - 0.7e1 / 0.1024e4 * t147 * t370 + 0.3e1 / 0.32768e5 * t374 * t380) * t38;
  t385 = t384 * t43;
  t391 = 0.1e1 / t48 / t85;
  t392 = t47 * t391;
  t395 = t189 * t189;
  t400 = 0.4e2 / 0.9e1 * t54 * t163 - 0.11e2 / 0.9e1 * t392;
  t401 = t400 * t38;
  t404 = t43 * t176;
  t405 = t404 * t184;
  t408 = t69 * t69;
  t410 = 0.1e1 / t70 / t408;
  t411 = t63 * t410;
  t412 = t184 * t184;
  t415 = params->b * t400;
  t418 = t170 * t170;
  t422 = t83 * t400;
  t425 = 0.5e1 * t415 * t66 + 0.5e2 / 0.9e1 * params->b * t418 * t83 + 0.25e2 / 0.9e1 * t64 * t422;
  t428 = t65 * t392;
  t430 = 0.3e1 / 0.4e1 * t401 * t172 - 0.3e1 / 0.4e1 * t171 * t405 + 0.81e2 / 0.8e2 * t411 * t412 - 0.27e2 / 0.4e2 * t177 * t425 + 0.22e2 / 0.81e2 * t428;
  t435 = t189 * t194;
  t439 = 0.1e1 / t93 / t92;
  t440 = t76 * t439;
  t441 = t205 * t205;
  t444 = t21 * t240;
  t447 = t85 * t140;
  t449 = 0.1e1 / t19 / t447;
  t450 = t84 * t449;
  t451 = t83 * t450;
  t453 = 0.972e3 * t444 * t26 + 0.304e5 / 0.9e1 * t451;
  t460 = t110 * t23;
  t461 = 0.1e1 / t460;
  t465 = t385 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t159 * t164 + 0.11e2 / 0.27e2 * t44 * t392 + 0.292e3 / 0.2025e4 * t395 + 0.292e3 / 0.2025e4 * t76 * t430 - 0.73e2 / 0.972e5 * t430 * t93 - 0.73e2 / 0.972e5 * t435 * t205 + 0.73e2 / 0.3888e6 * t440 * t441 - 0.73e2 / 0.1944e6 * t195 * t453 + 0.95e3 / 0.531441e6 * t98 * t450 + t102 * t364 / 0.12e3 + t105 * t109 * t461 / 0.8e1;
  t469 = t217 * t221 * t223;
  t472 = t121 * t121;
  t473 = 0.1e1 / t472;
  t475 = t96 * params->e;
  t476 = t115 * t473 * t475;
  t481 = -t465 * t122 * t96 - 0.4e1 / 0.9e1 * t469 * t187 - 0.4e1 / 0.27e2 * t476 * t451 + 0.22e2 / 0.27e2 * t224 * t428;
  t482 = t481 * t125;
  t486 = t227 * t227;
  t487 = t486 * t125;
  t492 = my_piecewise3(t3, 0, t7 * t356 * t128 / 0.12e2 + t138 * t360 * t228 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t482 + 0.3e1 / 0.8e1 * t138 * t139 * t487);
  tv2rho20 = 0.2e1 * rho[0] * t492 + 0.4e1 * t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t502 = t146 * sigma[0];
  t503 = params->c * t502;
  t504 = 0.1e1 / t447;
  t506 = t504 * t376 * t379;
  t510 = (-t236 * t143 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t154 - 0.3e1 / 0.32768e5 * t503 * t506) * t38;
  t511 = t510 * t43;
  t518 = t250 * t163;
  t523 = t46 * t163;
  t524 = t523 * t255;
  t526 = t254 * t38;
  t527 = t526 * t405;
  t529 = t404 * t267;
  t532 = t267 * t184;
  t535 = t258 * t163;
  t536 = t535 * t66;
  t538 = t259 * t181;
  t541 = t262 * t263 * t163;
  t543 = 0.5e1 / 0.3e1 * t536 - 0.25e2 / 0.36e2 * t538 + 0.25e2 / 0.27e2 * t541;
  t546 = t523 * t65;
  t548 = t524 / 0.4e1 + 0.3e1 / 0.64e2 * t527 - 0.3e1 / 0.8e1 * t171 * t529 + 0.81e2 / 0.8e2 * t411 * t532 - 0.27e2 / 0.4e2 * t177 * t543 - 0.2e1 / 0.27e2 * t546;
  t553 = t272 * t194;
  t558 = t284 * t205;
  t561 = sigma[0] * t141;
  t564 = t280 * t201;
  t565 = t83 * t564;
  t567 = -0.648e3 * t561 * t26 - 0.32e4 / 0.3e1 * t565;
  t577 = t511 * t51 / 0.24e2 - t247 * t164 / 0.9e1 + t158 * t251 / 0.24e2 - t39 * t518 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t272 + 0.292e3 / 0.2025e4 * t76 * t548 - 0.73e2 / 0.972e5 * t548 * t93 - 0.73e2 / 0.1944e6 * t553 * t205 - 0.73e2 / 0.1944e6 * t435 * t284 + 0.73e2 / 0.3888e6 * t440 * t558 - 0.73e2 / 0.1944e6 * t195 * t567 - 0.1e3 / 0.177147e6 * t98 * t564 - t289 * t142 / 0.18e3 - t105 * t292 * t213 / 0.24e2;
  t581 = t296 * t221 * t223;
  t590 = -t577 * t122 * t96 - 0.2e1 / 0.9e1 * t581 * t187 + t469 * t270 / 0.12e2 + t476 * t565 / 0.18e2 - 0.2e1 / 0.9e1 * t224 * t546;
  t591 = t590 * t125;
  t595 = t7 * t20;
  t596 = params->kappa * t301;
  t597 = t596 * t228;
  t601 = my_piecewise3(t3, 0, t138 * t360 * t302 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t591 + 0.3e1 / 0.8e1 * t595 * t597);
  tv2rhosigma0 = 0.2e1 * rho[0] * t601 + 0.2e1 * t306;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t608 = t141 * t309;
  t609 = t608 * t33;
  t613 = t148 * t315 * t153;
  t617 = 0.1e1 / t149 / t308;
  t619 = t504 * t617 * t379;
  t623 = (t22 * t609 / 0.16e2 - 0.3e1 / 0.512e3 * t147 * t613 + 0.3e1 / 0.32768e5 * t374 * t619) * t38;
  t624 = t623 * t43;
  t632 = t325 * t38;
  t635 = t404 * t334;
  t638 = t334 * t184;
  t645 = -0.25e2 / 0.3e1 * t260 + 0.5e2 / 0.9e1 * t328 * t181 - 0.125e3 / 0.27e2 * t265;
  t648 = -0.5e1 / 0.4e1 * t256 - 0.3e1 / 0.8e1 * t632 * t405 - 0.3e1 / 0.8e1 * t171 * t635 + 0.81e2 / 0.8e2 * t411 * t638 - 0.27e2 / 0.4e2 * t177 * t645;
  t653 = t337 * t194;
  t658 = t440 * t21;
  t659 = t310 * t205;
  t662 = t196 * t309;
  t667 = t624 * t51 / 0.24e2 - t322 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t337 + 0.292e3 / 0.2025e4 * t76 * t648 - 0.73e2 / 0.972e5 * t648 * t93 - 0.73e2 / 0.1944e6 * t653 * t205 + 0.73e2 / 0.6e3 * t435 * t342 - 0.73e2 / 0.12e4 * t658 * t659 - 0.73e2 / 0.3e3 * t195 * t662 + t102 * t608 / 0.18e3;
  t673 = 0.1e1 / t19 / t140;
  t674 = t673 * t347;
  t676 = t138 * t674 * t221;
  t680 = t43 * sigma[0] * t46;
  t681 = t125 * t101 * t38 * t680;
  t684 = t347 * t122;
  t685 = t684 * t228;
  t689 = my_piecewise3(t3, 0, -t138 * t133 * t347 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t667 * t349 - t676 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t685);
  tv2rhotau0 = 0.2e1 * rho[0] * t689 + 0.2e1 * t353;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t692 = params->c * t24;
  t693 = t26 * t33;
  t698 = t368 * t376;
  t699 = t698 * t379;
  t703 = (t692 * t693 / 0.32e2 - 0.5e1 / 0.1024e4 * t22 * t242 + 0.3e1 / 0.32768e5 * t147 * t699) * t38;
  t704 = t703 * t43;
  t709 = t272 * t272;
  t711 = t526 * t529;
  t713 = t267 * t267;
  t716 = t177 * params->b;
  t717 = t45 * t88;
  t718 = t83 * t717;
  t719 = t716 * t718;
  t721 = 0.3e1 / 0.32e2 * t711 + 0.81e2 / 0.8e2 * t411 * t713 - 0.15e2 / 0.128e3 * t719;
  t728 = t284 * t284;
  t733 = 0.324e3 * t27 + 0.2e3 * t718;
  t736 = t82 * t45;
  t740 = t101 * t24;
  t743 = t107 * sigma[0];
  t747 = t704 * t51 / 0.24e2 + t246 * t251 / 0.12e2 + 0.292e3 / 0.2025e4 * t709 + 0.292e3 / 0.2025e4 * t76 * t721 - 0.73e2 / 0.972e5 * t721 * t93 - 0.73e2 / 0.972e5 * t553 * t284 + 0.73e2 / 0.3888e6 * t440 * t728 - 0.73e2 / 0.1944e6 * t195 * t733 + 0.25e2 / 0.236196e6 * t97 * t736 * t88 + t740 * t26 / 0.36e3 + t105 * t743 * t111 / 0.96e2;
  t754 = -t747 * t122 * t96 + t581 * t270 / 0.6e1 - t476 * t718 / 0.48e2;
  t755 = t754 * t125;
  t758 = t301 * t301;
  t759 = t758 * t125;
  t764 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t755 + 0.3e1 / 0.8e1 * t138 * t139 * t759);
  tv2sigma20 = 0.2e1 * rho[0] * t764;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t771 = t368 * t617 * t379;
  t775 = (-t236 * t311 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t317 - 0.3e1 / 0.32768e5 * t503 * t771) * t38;
  t776 = t775 * t43;
  t785 = t526 * t635;
  t787 = t334 * t267;
  t791 = 0.1e1 / t19 / t85;
  t792 = t45 * t791;
  t793 = t792 * t83;
  t794 = t716 * t793;
  t796 = -0.3e1 / 0.8e1 * t632 * t529 + 0.3e1 / 0.64e2 * t785 + 0.81e2 / 0.8e2 * t411 * t787 + 0.15e2 / 0.16e2 * t794;
  t805 = t310 * t284;
  t808 = t277 * t309;
  t813 = t776 * t51 / 0.24e2 + t321 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t272 * t337 + 0.292e3 / 0.2025e4 * t76 * t796 - 0.73e2 / 0.972e5 * t796 * t93 - 0.73e2 / 0.1944e6 * t653 * t284 + 0.73e2 / 0.6e3 * t553 * t342 - 0.73e2 / 0.12e4 * t658 * t805 + 0.73e2 / 0.3e3 * t195 * t808 - t289 * t310 / 0.18e3;
  t819 = 0.1e1 / t19 / t23;
  t820 = t18 * t819;
  t825 = t65 * t46;
  t826 = t221 * t125 * t101 * t825;
  t829 = t684 * t302;
  t833 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t813 * t349 + t7 * t820 * t347 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t829);
  tv2sigmatau0 = 0.2e1 * rho[0] * t833;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t835 = t24 * t150;
  t836 = t835 * t33;
  t839 = t240 * t376;
  t840 = t839 * t153;
  t843 = t149 * t149;
  t844 = 0.1e1 / t843;
  t846 = t368 * t844 * t379;
  t850 = (0.3e1 / 0.32e2 * t22 * t836 - 0.7e1 / 0.1024e4 * t147 * t840 + 0.3e1 / 0.32768e5 * t374 * t846) * t38;
  t851 = t850 * t43;
  t854 = t337 * t337;
  t858 = t334 * t334;
  t861 = t45 * t673;
  t862 = t861 * t83;
  t865 = -0.3e1 / 0.4e1 * t632 * t635 + 0.81e2 / 0.8e2 * t411 * t858 - 0.15e2 / 0.2e1 * t716 * t862;
  t872 = t146 * t240;
  t873 = t872 * t376;
  t876 = t28 * t150;
  t881 = t851 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t854 + 0.292e3 / 0.2025e4 * t76 * t865 - 0.73e2 / 0.972e5 * t865 * t93 + 0.73e2 / 0.3e3 * t653 * t342 + 0.1971e4 / 0.1e3 * t440 * t873 - 0.73e2 / 0.2e3 * t195 * t876 + t102 * t835 / 0.12e3;
  t885 = t347 * t347;
  t886 = t885 * t473;
  t887 = t96 * t125;
  t888 = t886 * t887;
  t892 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t881 * t349 + 0.3e1 / 0.8e1 * t595 * t888);
  tv2tau20 = 0.2e1 * rho[0] * t892;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t899 = t56 * params->kappa;
  t909 = t148 * t26;
  t910 = t909 * t33;
  t914 = t504 * t150 * t153;
  t918 = t213 * t376 * t379;
  t921 = t146 * t146;
  t922 = params->c * t921;
  t923 = t110 * t140;
  t924 = 0.1e1 / t923;
  t927 = 0.1e1 / t378 / t31;
  t928 = t924 * t844 * t927;
  t932 = (-0.3e1 / 0.8e1 * t22 * t910 + 0.3e1 / 0.64e2 * t147 * t914 - 0.45e2 / 0.32768e5 * t374 * t918 + 0.3e1 / 0.262144e6 * t922 * t928) * t38;
  t933 = t932 * t43;
  t941 = 0.1e1 / t48 / t86;
  t942 = t47 * t941;
  t950 = -0.44e3 / 0.27e2 * t54 * t391 + 0.154e3 / 0.27e2 * t942;
  t951 = t950 * t38;
  t956 = t43 * t410;
  t957 = t956 * t412;
  t960 = t404 * t425;
  t965 = 0.1e1 / t70 / t408 / t69;
  t966 = t63 * t965;
  t967 = t412 * t184;
  t970 = t184 * t425;
  t973 = params->b * t950;
  t978 = t83 * t950;
  t981 = 0.5e1 * t973 * t66 + 0.5e2 / 0.3e1 * t415 * t181 + 0.25e2 / 0.9e1 * t64 * t978;
  t984 = t65 * t942;
  t986 = 0.3e1 / 0.4e1 * t951 * t172 - 0.9e1 / 0.8e1 * t401 * t405 + 0.27e2 / 0.16e2 * t171 * t957 - 0.9e1 / 0.8e1 * t171 * t960 - 0.81e2 / 0.32e2 * t966 * t967 + 0.243e3 / 0.8e2 * t411 * t970 - 0.27e2 / 0.4e2 * t177 * t981 - 0.308e3 / 0.243e3 * t984;
  t991 = t430 * t194;
  t994 = t189 * t439;
  t999 = t92 * t92;
  t1001 = 0.1e1 / t93 / t999;
  t1002 = t76 * t1001;
  t1003 = t441 * t205;
  t1006 = t205 * t453;
  t1009 = t21 * t148;
  t1013 = 0.1e1 / t19 / t110;
  t1014 = t84 * t1013;
  t1015 = t83 * t1014;
  t1017 = -0.3888e4 * t1009 * t26 - 0.6688e6 / 0.27e2 * t1015;
  t1027 = t933 * t51 / 0.24e2 - t385 * t164 / 0.3e1 + 0.11e2 / 0.9e1 * t159 * t392 - 0.154e3 / 0.81e2 * t44 * t942 + 0.292e3 / 0.675e3 * t189 * t430 + 0.292e3 / 0.2025e4 * t76 * t986 - 0.73e2 / 0.972e5 * t986 * t93 - 0.73e2 / 0.648e5 * t991 * t205 + 0.73e2 / 0.1296e6 * t994 * t441 - 0.73e2 / 0.648e5 * t435 * t453 - 0.73e2 / 0.2592e6 * t1002 * t1003 + 0.73e2 / 0.1296e6 * t440 * t1006 - 0.73e2 / 0.1944e6 * t195 * t1017 - 0.209e5 / 0.1594323e7 * t98 * t1014 - t102 * t909 / 0.3e2 - 0.5e1 / 0.4e1 * t105 * t109 * t924;
  t1031 = t465 * t221 * t223;
  t1035 = t217 * t473 * t475;
  t1041 = 0.1e1 / t472 / t120;
  t1043 = t115 * t1041 * t96;
  t1044 = t101 * params->e;
  t1045 = t1044 * t107;
  t1047 = t1045 * t108 * t924;
  t1054 = -t1027 * t122 * t96 - 0.2e1 / 0.3e1 * t1031 * t187 - 0.4e1 / 0.9e1 * t1035 * t451 + 0.22e2 / 0.9e1 * t469 * t428 - 0.64e2 / 0.81e2 * t1043 * t1047 + 0.44e2 / 0.27e2 * t476 * t1015 - 0.308e3 / 0.81e2 * t224 * t984;
  t1055 = t1054 * t125;
  t1059 = params->kappa * t481;
  t1060 = t1059 * t228;
  t1064 = t486 * t227 * t125;
  t1069 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t18 * t50 * t128 - t138 * t899 * t228 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t360 * t482 + 0.3e1 / 0.8e1 * t138 * t360 * t487 + 0.3e1 / 0.8e1 * t138 * t139 * t1055 + 0.9e1 / 0.8e1 * t595 * t1060 + 0.3e1 / 0.8e1 * t138 * t139 * t1064);
  tv3rho30 = 0.2e1 * rho[0] * t1069 + 0.6e1 * t492;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1079 = t7 * t134;
  t1086 = t46 * t391;
  t1087 = t1086 * t255;
  t1089 = t523 * t38;
  t1090 = t1089 * t405;
  t1092 = t526 * t957;
  t1094 = t526 * t960;
  t1098 = t171 * t43;
  t1099 = t410 * t267;
  t1100 = t1099 * t184;
  t1103 = t404 * t543;
  t1106 = t267 * t412;
  t1109 = t543 * t184;
  t1112 = t267 * t425;
  t1115 = t258 * t391;
  t1116 = t1115 * t66;
  t1118 = t535 * t181;
  t1120 = t259 * t422;
  t1123 = t262 * t263 * t391;
  t1125 = -0.55e2 / 0.9e1 * t1116 + 0.1e3 / 0.27e2 * t1118 - 0.25e2 / 0.36e2 * t1120 - 0.275e3 / 0.81e2 * t1123;
  t1128 = t1086 * t65;
  t1130 = -0.11e2 / 0.12e2 * t1087 - t1090 / 0.4e1 - 0.9e1 / 0.128e3 * t1092 + 0.3e1 / 0.64e2 * t1094 - 0.3e1 / 0.8e1 * t401 * t529 + 0.9e1 / 0.8e1 * t1098 * t1100 - 0.3e1 / 0.4e1 * t171 * t1103 - 0.81e2 / 0.32e2 * t966 * t1106 + 0.81e2 / 0.4e2 * t411 * t1109 + 0.81e2 / 0.8e2 * t411 * t1112 - 0.27e2 / 0.4e2 * t177 * t1125 + 0.22e2 / 0.81e2 * t1128;
  t1135 = t548 * t194;
  t1144 = sigma[0] * t240;
  t1147 = t280 * t449;
  t1148 = t83 * t1147;
  t1150 = 0.1944e4 * t1144 * t26 + 0.608e5 / 0.9e1 * t1148;
  t1157 = 0.292e3 / 0.2025e4 * t430 * t272 + 0.584e3 / 0.2025e4 * t189 * t548 + 0.292e3 / 0.2025e4 * t76 * t1130 - 0.73e2 / 0.972e5 * t1130 * t93 - 0.73e2 / 0.972e5 * t1135 * t205 - 0.73e2 / 0.1944e6 * t553 * t453 - 0.73e2 / 0.1944e6 * t991 * t284 - 0.73e2 / 0.972e5 * t435 * t567 - 0.73e2 / 0.1944e6 * t195 * t1150 - 0.2e1 / 0.9e1 * t511 * t164 + 0.11e2 / 0.27e2 * t247 * t392;
  t1167 = params->c * t146 * t108;
  t1169 = t461 * t844 * t927;
  t1173 = (0.3e1 / 0.16e2 * t236 * t365 - 0.17e2 / 0.512e3 * t239 * t370 + 0.39e2 / 0.32768e5 * t503 * t380 - 0.3e1 / 0.262144e6 * t1167 * t1169) * t38;
  t1174 = t1173 * t43;
  t1179 = t250 * t391;
  t1182 = t272 * t439;
  t1187 = t567 * t205;
  t1190 = t284 * t453;
  t1195 = t284 * t441;
  t1203 = 0.19e4 / 0.531441e6 * t98 * t1147 + t1174 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t158 * t518 + 0.11e2 / 0.27e2 * t39 * t1179 + 0.73e2 / 0.3888e6 * t1182 * t441 + 0.73e2 / 0.1944e6 * t994 * t558 + 0.73e2 / 0.1944e6 * t440 * t1187 + 0.73e2 / 0.3888e6 * t440 * t1190 + t289 * t364 / 0.6e2 - 0.73e2 / 0.2592e6 * t1002 * t1195 + 0.3e1 / 0.8e1 * t105 * t292 * t461 + t384 * t251 / 0.24e2;
  t1204 = t1157 + t1203;
  t1208 = t577 * t221 * t223;
  t1212 = t296 * t473 * t475;
  t1224 = t1045 * t461 * t21;
  t1231 = -t1204 * t122 * t96 - 0.4e1 / 0.9e1 * t1208 * t187 - 0.4e1 / 0.27e2 * t1212 * t451 + 0.22e2 / 0.27e2 * t581 * t428 + t1031 * t270 / 0.12e2 + t1035 * t565 / 0.9e1 - 0.4e1 / 0.9e1 * t469 * t546 + 0.8e1 / 0.27e2 * t1043 * t1224 - t476 * t1148 / 0.2e1 + 0.22e2 / 0.27e2 * t224 * t1128;
  t1232 = t1231 * t125;
  t1236 = params->kappa * t590;
  t1237 = t1236 * t228;
  t1240 = t596 * t482;
  t1243 = t596 * t487;
  t1247 = my_piecewise3(t3, 0, -t138 * t899 * t302 / 0.12e2 + t138 * t360 * t591 / 0.4e1 + t1079 * t597 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t1232 + 0.3e1 / 0.4e1 * t595 * t1237 + 0.3e1 / 0.8e1 * t595 * t1240 + 0.3e1 / 0.8e1 * t595 * t1243);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1247 + 0.4e1 * t601;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1261 = t138 * t791 * t347 * t221;
  t1266 = t240 * t309;
  t1267 = t1266 * t33;
  t1271 = t368 * t315 * t153;
  t1275 = t111 * t617 * t379;
  t1279 = 0.1e1 / t843 / tau[0];
  t1281 = t461 * t1279 * t927;
  t1285 = (-0.3e1 / 0.16e2 * t22 * t1267 + 0.17e2 / 0.512e3 * t147 * t1271 - 0.39e2 / 0.32768e5 * t374 * t1275 + 0.3e1 / 0.262144e6 * t922 * t1281) * t38;
  t1286 = t1285 * t43;
  t1305 = t410 * t334;
  t1306 = t1305 * t184;
  t1309 = t404 * t645;
  t1312 = t334 * t412;
  t1315 = t645 * t184;
  t1318 = t334 * t425;
  t1326 = 0.2e3 / 0.9e1 * t536 - 0.5e3 / 0.27e2 * t538 + 0.5e2 / 0.9e1 * t328 * t422 + 0.1e4 / 0.81e2 * t541;
  t1329 = 0.1e2 / 0.3e1 * t524 + 0.5e1 / 0.4e1 * t527 + 0.9e1 / 0.16e2 * t632 * t957 - 0.3e1 / 0.8e1 * t632 * t960 - 0.3e1 / 0.8e1 * t401 * t635 + 0.9e1 / 0.8e1 * t1098 * t1306 - 0.3e1 / 0.4e1 * t171 * t1309 - 0.81e2 / 0.32e2 * t966 * t1312 + 0.81e2 / 0.4e2 * t411 * t1315 + 0.81e2 / 0.8e2 * t411 * t1318 - 0.27e2 / 0.4e2 * t177 * t1326;
  t1334 = t648 * t194;
  t1337 = t337 * t439;
  t1344 = t994 * t21;
  t1349 = t1002 * t21;
  t1350 = t310 * t441;
  t1353 = t608 * t205;
  t1356 = t310 * t453;
  t1359 = t444 * t309;
  t1364 = t1286 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t624 * t164 + 0.11e2 / 0.27e2 * t322 * t392 + 0.292e3 / 0.2025e4 * t430 * t337 + 0.584e3 / 0.2025e4 * t189 * t648 + 0.292e3 / 0.2025e4 * t76 * t1329 - 0.73e2 / 0.972e5 * t1329 * t93 - 0.73e2 / 0.972e5 * t1334 * t205 + 0.73e2 / 0.3888e6 * t1337 * t441 - 0.73e2 / 0.1944e6 * t653 * t453 + 0.73e2 / 0.6e3 * t991 * t342 - 0.73e2 / 0.6e3 * t1344 * t659 - 0.73e2 / 0.15e3 * t435 * t662 + 0.73e2 / 0.8e3 * t1349 * t1350 + 0.73e2 / 0.3e3 * t658 * t1353 - 0.73e2 / 0.12e4 * t658 * t1356 + 0.73e2 / 0.1e3 * t195 * t1359 - t102 * t1266 / 0.6e2;
  t1371 = t138 * t673 * t667 * t221;
  t1374 = t667 * t122;
  t1375 = t1374 * t228;
  t1380 = t138 * t504 * t347 * t473;
  t1382 = t125 * params->e * t80;
  t1385 = t1382 * t82 * t21 * t45;
  t1388 = t228 * t101;
  t1389 = t65 * t47;
  t1390 = t1388 * t1389;
  t1393 = t684 * t482;
  t1396 = t684 * t487;
  t1399 = t138 * t56 * t347 * t349 / 0.12e2 - t138 * t133 * t667 * t349 / 0.4e1 + t1261 * t681 / 0.4e1 - t1079 * t685 / 0.4e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1364 * t349 - t1371 * t681 / 0.6e1 - 0.3e1 / 0.4e1 * t595 * t1375 - t1380 * t1385 / 0.18e2 - t676 * t1390 / 0.6e1 - 0.3e1 / 0.8e1 * t595 * t1393 - 0.3e1 / 0.8e1 * t595 * t1396;
  t1400 = my_piecewise3(t3, 0, t1399);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1400 + 0.4e1 * t689;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1406 = params->c * t141;
  t1409 = params->c * t148;
  t1410 = t150 * t153;
  t1411 = t1410 * t21;
  t1417 = t213 * t844 * t927;
  t1421 = (-t1406 * t693 / 0.16e2 + 0.11e2 / 0.512e3 * t1409 * t1411 - 0.33e2 / 0.32768e5 * t147 * t506 + 0.3e1 / 0.262144e6 * t374 * t1417) * t38;
  t1422 = t1421 * t43;
  t1435 = t1089 * t529;
  t1437 = t956 * t532;
  t1438 = t526 * t1437;
  t1440 = t526 * t1103;
  t1442 = t956 * t713;
  t1445 = t713 * t184;
  t1448 = t267 * t543;
  t1451 = t170 * t107;
  t1452 = t1451 * t176;
  t1453 = params->b * t45;
  t1454 = t1453 * t88;
  t1455 = t1452 * t1454;
  t1457 = t411 * t1453;
  t1458 = t88 * t80;
  t1459 = t82 * t184;
  t1461 = t1457 * t1458 * t1459;
  t1464 = t83 * t45 * t201;
  t1465 = t716 * t1464;
  t1467 = -t1435 / 0.4e1 - 0.9e1 / 0.64e2 * t1438 + 0.3e1 / 0.32e2 * t1440 + 0.9e1 / 0.16e2 * t171 * t1442 - 0.81e2 / 0.32e2 * t966 * t1445 + 0.81e2 / 0.4e2 * t411 * t1448 - 0.25e2 / 0.64e2 * t1455 + 0.45e2 / 0.256e3 * t1461 + 0.5e1 / 0.8e1 * t1465;
  t1472 = t721 * t194;
  t1484 = t728 * t205;
  t1487 = t284 * t567;
  t1492 = t733 * t205;
  t1497 = -0.648e3 * t142 - 0.32e4 / 0.3e1 * t1464;
  t1503 = t101 * t141;
  t1509 = 0.73e2 / 0.1944e6 * t1182 * t558 - 0.73e2 / 0.972e5 * t553 * t567 + 0.73e2 / 0.3888e6 * t994 * t728 - 0.73e2 / 0.2592e6 * t1002 * t1484 + 0.73e2 / 0.1944e6 * t440 * t1487 - 0.73e2 / 0.1944e6 * t435 * t733 + 0.73e2 / 0.3888e6 * t440 * t1492 - 0.73e2 / 0.1944e6 * t195 * t1497 - 0.1e3 / 0.177147e6 * t97 * t736 * t201 - t1503 * t26 / 0.18e3 - t105 * t743 * t213 / 0.12e2;
  t1510 = t1422 * t51 / 0.24e2 - t704 * t164 / 0.9e1 + t510 * t251 / 0.12e2 - 0.2e1 / 0.9e1 * t246 * t518 + 0.584e3 / 0.2025e4 * t272 * t548 + 0.292e3 / 0.2025e4 * t189 * t721 + 0.292e3 / 0.2025e4 * t76 * t1467 - 0.73e2 / 0.972e5 * t1467 * t93 - 0.73e2 / 0.1944e6 * t1472 * t205 - 0.73e2 / 0.972e5 * t1135 * t284 + t1509;
  t1514 = t747 * t221 * t223;
  t1526 = t1045 * t213 * sigma[0];
  t1531 = -t1510 * t122 * t96 - 0.2e1 / 0.9e1 * t1514 * t187 + t1208 * t270 / 0.6e1 + t1212 * t565 / 0.9e1 - 0.4e1 / 0.9e1 * t581 * t546 - t1035 * t718 / 0.48e2 - t1043 * t1526 / 0.9e1 + t476 * t1464 / 0.9e1;
  t1532 = t1531 * t125;
  t1536 = params->kappa * t754;
  t1537 = t1536 * t228;
  t1543 = t596 * t591;
  t1546 = params->kappa * t758;
  t1547 = t1546 * t228;
  t1551 = my_piecewise3(t3, 0, t138 * t360 * t755 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t1532 + 0.3e1 / 0.8e1 * t595 * t1537 + t138 * t360 * t759 / 0.8e1 + 0.3e1 / 0.4e1 * t595 * t1543 + 0.3e1 / 0.8e1 * t595 * t1547);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1551 + 0.2e1 * t764;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1565 = t213 * t1279 * t927;
  t1569 = (t236 * t609 / 0.8e1 - 0.7e1 / 0.256e3 * t239 * t613 + 0.9e1 / 0.8192e4 * t503 * t619 - 0.3e1 / 0.262144e6 * t1167 * t1565) * t38;
  t1570 = t1569 * t43;
  t1590 = t1089 * t635;
  t1592 = t956 * t638;
  t1593 = t526 * t1592;
  t1595 = t526 * t1309;
  t1597 = t1305 * t267;
  t1603 = t645 * t267;
  t1606 = t334 * t543;
  t1609 = t1453 * t791;
  t1610 = t1452 * t1609;
  t1612 = t791 * t80;
  t1614 = t1457 * t1612 * t1459;
  t1617 = 0.5e1 / 0.8e1 * t711 + 0.9e1 / 0.16e2 * t632 * t1437 - 0.3e1 / 0.8e1 * t632 * t1103 - t1590 / 0.8e1 - 0.9e1 / 0.128e3 * t1593 + 0.3e1 / 0.64e2 * t1595 + 0.9e1 / 0.16e2 * t1098 * t1597 - 0.81e2 / 0.32e2 * t966 * t787 * t184 + 0.81e2 / 0.8e2 * t411 * t1603 + 0.81e2 / 0.8e2 * t411 * t1606 + 0.25e2 / 0.8e1 * t1610 - 0.45e2 / 0.32e2 * t1614 - 0.65e2 / 0.16e2 * t719;
  t1622 = t796 * t194;
  t1629 = t1570 * t51 / 0.24e2 - t776 * t164 / 0.9e1 + t623 * t251 / 0.24e2 - t321 * t518 / 0.9e1 + 0.292e3 / 0.2025e4 * t548 * t337 + 0.292e3 / 0.2025e4 * t272 * t648 + 0.292e3 / 0.2025e4 * t189 * t796 + 0.292e3 / 0.2025e4 * t76 * t1617 - 0.73e2 / 0.972e5 * t1617 * t93 - 0.73e2 / 0.1944e6 * t1622 * t205 - 0.73e2 / 0.1944e6 * t1334 * t284 + 0.73e2 / 0.3888e6 * t1337 * t558;
  t1634 = t1182 * t21;
  t1641 = t310 * t558;
  t1644 = t608 * t284;
  t1647 = t310 * t567;
  t1652 = t440 * sigma[0];
  t1655 = t561 * t309;
  t1660 = -0.73e2 / 0.1944e6 * t653 * t567 + 0.73e2 / 0.6e3 * t1135 * t342 - 0.73e2 / 0.12e4 * t1634 * t659 - 0.73e2 / 0.3e3 * t553 * t662 - 0.73e2 / 0.12e4 * t1344 * t805 + 0.73e2 / 0.8e3 * t1349 * t1641 + 0.73e2 / 0.6e3 * t658 * t1644 - 0.73e2 / 0.12e4 * t658 * t1647 + 0.73e2 / 0.3e3 * t435 * t808 - 0.73e2 / 0.6e3 * t1652 * t659 - 0.73e2 / 0.15e3 * t195 * t1655 + t289 * t608 / 0.9e2;
  t1661 = t1629 + t1660;
  t1668 = t138 * t673 * t813 * t221;
  t1671 = t813 * t122;
  t1672 = t1671 * t228;
  t1675 = t18 * t673;
  t1686 = t138 * t368 * t347 * t473;
  t1688 = t1382 * t736 * sigma[0];
  t1691 = t819 * t347;
  t1693 = t138 * t1691 * t221;
  t1694 = t1388 * t825;
  t1699 = t1374 * t302;
  t1702 = t302 * t101;
  t1703 = t1702 * t1389;
  t1706 = t684 * t591;
  t1710 = t301 * t227 * t125;
  t1711 = t684 * t1710;
  t1714 = -t138 * t133 * t813 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1661 * t349 - t1668 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1672 - 0.7e1 / 0.96e2 * t7 * t1675 * t347 * t826 + t7 * t820 * t667 * t826 / 0.32e2 + t1686 * t1688 / 0.48e2 + t1693 * t1694 / 0.32e2 - t1079 * t829 / 0.8e1 - 0.3e1 / 0.8e1 * t595 * t1699 - t676 * t1703 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1706 - 0.3e1 / 0.8e1 * t595 * t1711;
  t1715 = my_piecewise3(t3, 0, t1714);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1715 + 0.2e1 * t833;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1722 = t141 * t150;
  t1723 = t1722 * t33;
  t1726 = t148 * t376;
  t1727 = t1726 * t153;
  t1731 = t504 * t844 * t379;
  t1735 = 0.1e1 / t843 / t25;
  t1737 = t213 * t1735 * t927;
  t1741 = (-0.3e1 / 0.16e2 * t22 * t1723 + 0.17e2 / 0.512e3 * t147 * t1727 - 0.39e2 / 0.32768e5 * t374 * t1731 + 0.3e1 / 0.262144e6 * t922 * t1737) * t38;
  t1742 = t1741 * t43;
  t1756 = t956 * t858;
  t1759 = t858 * t184;
  t1762 = t334 * t645;
  t1765 = t1453 * t673;
  t1768 = t673 * t80;
  t1773 = 0.5e1 / 0.4e1 * t785 + 0.9e1 / 0.8e1 * t632 * t1592 - 0.3e1 / 0.4e1 * t632 * t1309 + 0.9e1 / 0.16e2 * t171 * t1756 - 0.81e2 / 0.32e2 * t966 * t1759 + 0.81e2 / 0.4e2 * t411 * t1762 - 0.25e2 * t1452 * t1765 + 0.45e2 / 0.4e1 * t1457 * t1768 * t1459 + 0.25e2 * t794;
  t1778 = t865 * t194;
  t1783 = t1337 * t21;
  t1790 = t1002 * t146;
  t1791 = t839 * t205;
  t1794 = t146 * t148;
  t1795 = t1794 * t376;
  t1800 = t835 * t205;
  t1803 = t196 * t150;
  t1808 = t1742 * t51 / 0.24e2 - t851 * t164 / 0.9e1 + 0.584e3 / 0.2025e4 * t337 * t648 + 0.292e3 / 0.2025e4 * t189 * t865 + 0.292e3 / 0.2025e4 * t76 * t1773 - 0.73e2 / 0.972e5 * t1773 * t93 - 0.73e2 / 0.1944e6 * t1778 * t205 + 0.73e2 / 0.3e3 * t1334 * t342 - 0.73e2 / 0.6e3 * t1783 * t659 - 0.73e2 / 0.15e3 * t653 * t662 + 0.1971e4 / 0.1e3 * t994 * t873 - 0.5913e4 / 0.2e3 * t1790 * t1791 - 0.1971e4 / 0.25e2 * t440 * t1795 - 0.73e2 / 0.2e3 * t435 * t876 + 0.73e2 / 0.4e3 * t658 * t1800 + 0.73e2 / 0.1e3 * t195 * t1803 - t102 * t1722 / 0.6e2;
  t1813 = t673 * t881;
  t1815 = t138 * t1813 * t221;
  t1818 = t881 * t122;
  t1819 = t1818 * t228;
  t1824 = t347 * t473;
  t1825 = t887 * t667;
  t1826 = t1824 * t1825;
  t1829 = t673 * t885;
  t1831 = t138 * t1829 * t1041;
  t1832 = t887 * t101;
  t1833 = t1832 * t1389;
  t1837 = t96 * t227 * t125;
  t1838 = t886 * t1837;
  t1842 = my_piecewise3(t3, 0, -t138 * t133 * t881 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1808 * t349 - t1815 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1819 + t1079 * t888 / 0.8e1 + 0.3e1 / 0.4e1 * t595 * t1826 + t1831 * t1833 / 0.6e1 + 0.3e1 / 0.8e1 * t595 * t1838);
  tv3rhotau20 = 0.2e1 * rho[0] * t1842 + 0.2e1 * t892;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1845 = params->c * t240;
  t1846 = t1410 * sigma[0];
  t1851 = t111 * t844;
  t1852 = t1851 * t927;
  t1856 = (-0.3e1 / 0.256e3 * t1845 * t1846 + 0.27e2 / 0.32768e5 * t239 * t699 - 0.3e1 / 0.262144e6 * t503 * t1852) * t38;
  t1857 = t1856 * t43;
  t1864 = t526 * t1442;
  t1866 = t111 * t107;
  t1867 = t176 * params->b;
  t1868 = t1866 * t1867;
  t1870 = t713 * t267;
  t1873 = t267 * params->b;
  t1874 = t411 * t1873;
  t1875 = t1874 * t718;
  t1877 = -0.27e2 / 0.128e3 * t1864 + 0.75e2 / 0.256e3 * t1868 - 0.81e2 / 0.32e2 * t966 * t1870 + 0.135e3 / 0.256e3 * t1875;
  t1888 = t728 * t284;
  t1891 = t284 * t733;
  t1896 = t1857 * t51 / 0.24e2 + t703 * t251 / 0.8e1 + 0.292e3 / 0.675e3 * t272 * t721 + 0.292e3 / 0.2025e4 * t76 * t1877 - 0.73e2 / 0.972e5 * t1877 * t93 - 0.73e2 / 0.648e5 * t1472 * t284 + 0.73e2 / 0.1296e6 * t1182 * t728 - 0.73e2 / 0.648e5 * t553 * t733 - 0.73e2 / 0.2592e6 * t1002 * t1888 + 0.73e2 / 0.1296e6 * t440 * t1891 + t105 * t1866 / 0.96e2;
  t1903 = t1045 * t111;
  t1906 = -t1896 * t122 * t96 + t1514 * t270 / 0.4e1 - t1212 * t718 / 0.16e2 + t1043 * t1903 / 0.24e2;
  t1907 = t1906 * t125;
  t1911 = t1536 * t302;
  t1914 = t758 * t301;
  t1915 = t1914 * t125;
  t1920 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t1907 + 0.9e1 / 0.8e1 * t595 * t1911 + 0.3e1 / 0.8e1 * t138 * t139 * t1915);
  tv3sigma30 = 0.2e1 * rho[0] * t1920;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1922 = t309 * t33;
  t1930 = t111 * t1279 * t927;
  t1934 = (-t692 * t1922 / 0.16e2 + 0.11e2 / 0.512e3 * t22 * t317 - 0.33e2 / 0.32768e5 * t147 * t771 + 0.3e1 / 0.262144e6 * t374 * t1930) * t38;
  t1935 = t1934 * t43;
  t1946 = t504 * t107;
  t1947 = t1946 * t1867;
  t1949 = t956 * t787;
  t1950 = t526 * t1949;
  t1952 = t334 * t713;
  t1955 = t82 * t267;
  t1957 = t1457 * t1612 * t1955;
  t1959 = t334 * params->b;
  t1960 = t411 * t1959;
  t1961 = t1960 * t718;
  t1963 = 0.9e1 / 0.16e2 * t632 * t1442 - 0.75e2 / 0.32e2 * t1947 - 0.9e1 / 0.64e2 * t1950 - 0.81e2 / 0.32e2 * t966 * t1952 - 0.45e2 / 0.16e2 * t1957 + 0.45e2 / 0.256e3 * t1961;
  t1980 = t310 * t728;
  t1985 = t310 * t733;
  t1992 = t1935 * t51 / 0.24e2 + t775 * t251 / 0.12e2 + 0.292e3 / 0.2025e4 * t721 * t337 + 0.584e3 / 0.2025e4 * t272 * t796 + 0.292e3 / 0.2025e4 * t76 * t1963 - 0.73e2 / 0.972e5 * t1963 * t93 - 0.73e2 / 0.972e5 * t1622 * t284 + 0.73e2 / 0.3888e6 * t1337 * t728 - 0.73e2 / 0.1944e6 * t653 * t733 + 0.73e2 / 0.6e3 * t1472 * t342 - 0.73e2 / 0.6e3 * t1634 * t805 + 0.73e2 / 0.15e3 * t553 * t808 + 0.73e2 / 0.8e3 * t1349 * t1980 - 0.73e2 / 0.3e3 * t1652 * t805 - 0.73e2 / 0.12e4 * t658 * t1985 + 0.73e2 / 0.3e3 * t195 * t310 - t740 * t309 / 0.18e3;
  t2001 = t1671 * t302;
  t2004 = t18 * t148;
  t2009 = t83 * t45;
  t2010 = t473 * t125 * params->e * t2009;
  t2013 = t1702 * t825;
  t2016 = t684 * t755;
  t2019 = t684 * t759;
  t2023 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t1992 * t349 + t7 * t820 * t813 * t826 / 0.16e2 - 0.3e1 / 0.4e1 * t595 * t2001 - t7 * t2004 * t347 * t2010 / 0.128e3 + t1693 * t2013 / 0.16e2 - 0.3e1 / 0.8e1 * t595 * t2016 - 0.3e1 / 0.8e1 * t595 * t2019);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t2023;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t2032 = t111 * t1735 * t927;
  t2036 = (0.3e1 / 0.16e2 * t236 * t836 - 0.17e2 / 0.512e3 * t239 * t840 + 0.39e2 / 0.32768e5 * t503 * t846 - 0.3e1 / 0.262144e6 * t1167 * t2032) * t38;
  t2037 = t2036 * t43;
  t2048 = t368 * t107;
  t2049 = t2048 * t1867;
  t2051 = t526 * t1756;
  t2053 = t858 * t267;
  t2056 = t1960 * t793;
  t2061 = 0.9e1 / 0.8e1 * t632 * t1949 + 0.75e2 / 0.4e1 * t2049 - 0.9e1 / 0.128e3 * t2051 - 0.81e2 / 0.32e2 * t966 * t2053 - 0.45e2 / 0.16e2 * t2056 + 0.45e2 / 0.4e1 * t1457 * t1768 * t1955;
  t2076 = t839 * t284;
  t2079 = t108 * t240;
  t2080 = t2079 * t376;
  t2085 = t835 * t284;
  t2088 = t277 * t150;
  t2093 = t2037 * t51 / 0.24e2 + t850 * t251 / 0.24e2 + 0.584e3 / 0.2025e4 * t337 * t796 + 0.292e3 / 0.2025e4 * t272 * t865 + 0.292e3 / 0.2025e4 * t76 * t2061 - 0.73e2 / 0.972e5 * t2061 * t93 - 0.73e2 / 0.1944e6 * t1778 * t284 + 0.73e2 / 0.3e3 * t1622 * t342 - 0.73e2 / 0.6e3 * t1783 * t805 + 0.73e2 / 0.15e3 * t653 * t808 + 0.1971e4 / 0.1e3 * t1182 * t873 - 0.5913e4 / 0.2e3 * t1790 * t2076 + 0.1971e4 / 0.25e2 * t440 * t2080 - 0.73e2 / 0.2e3 * t553 * t876 + 0.73e2 / 0.4e3 * t658 * t2085 - 0.73e2 / 0.1e3 * t195 * t2088 + t289 * t835 / 0.6e2;
  t2102 = t1818 * t302;
  t2105 = t887 * t813;
  t2106 = t1824 * t2105;
  t2111 = t138 * t819 * t885 * t1041;
  t2112 = t1832 * t825;
  t2116 = t96 * t301 * t125;
  t2117 = t886 * t2116;
  t2121 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t2093 * t349 + t7 * t820 * t881 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t2102 + 0.3e1 / 0.4e1 * t595 * t2106 - t2111 * t2112 / 0.16e2 + 0.3e1 / 0.8e1 * t595 * t2117);
  tv3sigmatau20 = 0.2e1 * rho[0] * t2121;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t2123 = t24 * t315;
  t2124 = t2123 * t33;
  t2127 = t240 * t617;
  t2128 = t2127 * t153;
  t2131 = t368 * t1279;
  t2132 = t2131 * t379;
  t2136 = 0.1e1 / t843 / t308;
  t2138 = t111 * t2136 * t927;
  t2142 = (-0.3e1 / 0.8e1 * t22 * t2124 + 0.3e1 / 0.64e2 * t147 * t2128 - 0.45e2 / 0.32768e5 * t374 * t2132 + 0.3e1 / 0.262144e6 * t922 * t2138) * t38;
  t2143 = t2142 * t43;
  t2150 = t148 * t107;
  t2153 = t858 * t334;
  t2158 = 0.27e2 / 0.16e2 * t632 * t1756 - 0.15e3 * t2150 * t1867 - 0.81e2 / 0.32e2 * t966 * t2153 + 0.135e3 / 0.4e1 * t1960 * t862;
  t2169 = t373 * t368;
  t2170 = t2169 * t1279;
  t2173 = t872 * t617;
  t2176 = t28 * t315;
  t2181 = t2143 * t51 / 0.24e2 + 0.292e3 / 0.675e3 * t337 * t865 + 0.292e3 / 0.2025e4 * t76 * t2158 - 0.73e2 / 0.972e5 * t2158 * t93 + 0.73e2 / 0.2e3 * t1778 * t342 + 0.5913e4 / 0.1e3 * t1337 * t873 - 0.219e3 / 0.2e3 * t653 * t876 + 0.478953e6 / 0.5e2 * t1002 * t2170 - 0.17739e5 / 0.1e3 * t440 * t2173 + 0.73e2 / 0.5e2 * t195 * t2176 - t102 * t2123 / 0.3e2;
  t2186 = t881 * t473;
  t2188 = t347 * t96 * t125;
  t2189 = t2186 * t2188;
  t2192 = t885 * t347;
  t2194 = 0.1e1 / t472 / t121;
  t2195 = t2192 * t2194;
  t2196 = params->kappa * params->kappa;
  t2197 = 0.1e1 / t2196;
  t2198 = t2197 * t125;
  t2199 = t2195 * t2198;
  t2203 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t2181 * t349 + 0.9e1 / 0.8e1 * t595 * t2189 - 0.3e1 / 0.8e1 * t595 * t2199);
  tv3tau30 = 0.2e1 * rho[0] * t2203;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_unpol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t3, t4, t5, t7, t8, t9, t11, t12;
  double t14, t16, t18, t19, t20, t21, t22, t23;
  double t24, t25, t26, t27, t28, t29, t31, t32;
  double t33, t34, t38, t39, t40, t41, t42, t43;
  double t44, t45, t46, t47, t48, t50, t51, t54;
  double t56, t59, t63, t64, t65, t66, t69, t70;
  double t71, t76, t77, t80, t82, t83, t84, t85;
  double t86, t88, t89, t92, t93, t96, t97, t98;
  double t101, t102, t105, t106, t107, t108, t109, t110;
  double t111, t115, t116, t120, t121, t122, t125, t128;
  double t132, tzk0;

  double t133, t134, t138, t139, t140, t141, t142, t143;
  double t146, t147, t148, t149, t150, t153, t154, t158;
  double t159, t163, t164, t170, t171, t172, t176, t177;
  double t181, t184, t187, t189, t194, t195, t196, t199;
  double t201, t202, t205, t212, t213, t217, t220, t221;
  double t223, t224, t227, t228, t233, tvrho0, t236, t239;
  double t240, t241, t242, t246, t247, t250, t251, t254;
  double t255, t256, t258, t259, t260, t262, t263, t265;
  double t267, t270, t272, t277, t280, t281, t284, t289;
  double t292, t296, t301, t302, t306, tvsigma0, tvlapl0, t308;
  double t309, t310, t311, t314, t315, t317, t321, t322;
  double t325, t328, t334, t337, t342, t347, t349, t353;
  double tvtau0;

  double t356, t360, t364, t365, t368, t370, t373, t374;
  double t375, t376, t378, t379, t380, t384, t385, t391;
  double t392, t395, t400, t401, t404, t405, t408, t410;
  double t411, t412, t415, t418, t422, t425, t428, t430;
  double t435, t439, t440, t441, t444, t447, t449, t450;
  double t451, t453, t460, t461, t465, t469, t472, t473;
  double t475, t476, t481, t482, t486, t487, t492, tv2rho20;
  double t502, t503, t504, t506, t510, t511, t518, t523;
  double t524, t526, t527, t529, t532, t535, t536, t538;
  double t541, t543, t546, t548, t553, t558, t561, t564;
  double t565, t567, t577, t581, t590, t591, t595, t596;
  double t597, t601, tv2rhosigma0, tv2rholapl0, t608, t609, t613, t617;
  double t619, t623, t624, t632, t635, t638, t645, t648;
  double t653, t658, t659, t662, t667, t673, t674, t676;
  double t680, t681, t684, t685, t689, tv2rhotau0, t692, t693;
  double t698, t699, t703, t704, t709, t711, t713, t716;
  double t717, t718, t719, t721, t728, t733, t736, t740;
  double t743, t747, t754, t755, t758, t759, t764, tv2sigma20;
  double tv2sigmalapl0, t771, t775, t776, t785, t787, t791, t792;
  double t793, t794, t796, t805, t808, t813, t819, t820;
  double t825, t826, t829, t833, tv2sigmatau0, tv2lapl20, tv2lapltau0, t835;
  double t836, t839, t840, t843, t844, t846, t850, t851;
  double t854, t858, t861, t862, t865, t872, t873, t876;
  double t881, t885, t886, t887, t888, t892, tv2tau20;

  double t899, t909, t910, t914, t918, t921, t922, t923;
  double t924, t927, t928, t932, t933, t941, t942, t950;
  double t951, t956, t957, t960, t965, t966, t967, t970;
  double t973, t978, t981, t984, t986, t991, t994, t999;
  double t1001, t1002, t1003, t1006, t1009, t1013, t1014, t1015;
  double t1017, t1027, t1031, t1035, t1041, t1043, t1044, t1045;
  double t1047, t1054, t1055, t1059, t1060, t1064, t1069, tv3rho30;
  double t1079, t1086, t1087, t1089, t1090, t1092, t1094, t1098;
  double t1099, t1100, t1103, t1106, t1109, t1112, t1115, t1116;
  double t1118, t1120, t1123, t1125, t1128, t1130, t1135, t1144;
  double t1147, t1148, t1150, t1157, t1167, t1169, t1173, t1174;
  double t1179, t1182, t1187, t1190, t1195, t1203, t1204, t1208;
  double t1212, t1224, t1231, t1232, t1236, t1237, t1240, t1243;
  double t1247, tv3rho2sigma0, tv3rho2lapl0, t1261, t1266, t1267, t1271, t1275;
  double t1279, t1281, t1285, t1286, t1305, t1306, t1309, t1312;
  double t1315, t1318, t1326, t1329, t1334, t1337, t1344, t1349;
  double t1350, t1353, t1356, t1359, t1364, t1371, t1374, t1375;
  double t1380, t1382, t1385, t1388, t1389, t1390, t1393, t1396;
  double t1399, t1400, tv3rho2tau0, t1406, t1409, t1410, t1411, t1417;
  double t1421, t1422, t1435, t1437, t1438, t1440, t1442, t1445;
  double t1448, t1451, t1452, t1453, t1454, t1455, t1457, t1458;
  double t1459, t1461, t1464, t1465, t1467, t1472, t1484, t1487;
  double t1492, t1497, t1503, t1509, t1510, t1514, t1526, t1531;
  double t1532, t1536, t1537, t1543, t1546, t1547, t1551, tv3rhosigma20;
  double tv3rhosigmalapl0, t1565, t1569, t1570, t1590, t1592, t1593, t1595;
  double t1597, t1603, t1606, t1609, t1610, t1612, t1614, t1617;
  double t1622, t1629, t1634, t1641, t1644, t1647, t1652, t1655;
  double t1660, t1661, t1668, t1671, t1672, t1675, t1686, t1688;
  double t1691, t1693, t1694, t1699, t1702, t1703, t1706, t1710;
  double t1711, t1714, t1715, tv3rhosigmatau0, tv3rholapl20, tv3rholapltau0, t1722, t1723;
  double t1726, t1727, t1731, t1735, t1737, t1741, t1742, t1756;
  double t1759, t1762, t1765, t1768, t1773, t1778, t1783, t1790;
  double t1791, t1794, t1795, t1800, t1803, t1808, t1813, t1815;
  double t1818, t1819, t1824, t1825, t1826, t1829, t1831, t1832;
  double t1833, t1837, t1838, t1842, tv3rhotau20, t1845, t1846, t1851;
  double t1852, t1856, t1857, t1864, t1866, t1867, t1868, t1870;
  double t1873, t1874, t1875, t1877, t1888, t1891, t1896, t1903;
  double t1906, t1907, t1911, t1914, t1915, t1920, tv3sigma30, tv3sigma2lapl0;
  double t1922, t1930, t1934, t1935, t1946, t1947, t1949, t1950;
  double t1952, t1955, t1957, t1959, t1960, t1961, t1963, t1980;
  double t1985, t1992, t2001, t2004, t2009, t2010, t2013, t2016;
  double t2019, t2023, tv3sigma2tau0, tv3sigmalapl20, tv3sigmalapltau0, t2032, t2036, t2037;
  double t2048, t2049, t2051, t2053, t2056, t2061, t2076, t2079;
  double t2080, t2085, t2088, t2093, t2102, t2105, t2106, t2111;
  double t2112, t2116, t2117, t2121, tv3sigmatau20, tv3lapl30, tv3lapl2tau0, tv3lapltau20;
  double t2123, t2124, t2127, t2128, t2131, t2132, t2136, t2138;
  double t2142, t2143, t2150, t2153, t2158, t2169, t2170, t2173;
  double t2176, t2181, t2186, t2188, t2189, t2192, t2194, t2195;
  double t2196, t2197, t2198, t2199, t2203, tv3tau30;

  double t2210, t2230, t2233, t2245, t2246, t2252, t2253, t2257;
  double t2266, t2273, t2274, t2276, t2286, t2287, t2294, t2297;
  double t2300, t2301, t2307, t2318, t2328, t2330, t2335, t2345;
  double t2352, t2359, t2362, t2370, t2371, t2377, t2388, t2393;
  double t2397, t2403, t2410, t2411, t2412, t2414, t2429, t2438;
  double t2446, t2451, t2452, tv4rho40, t2471, t2472, t2478, t2487;
  double t2490, t2500, t2526, t2533, t2534, t2544, t2556, t2557;
  double t2558, t2570, t2578, t2601, t2615, t2640, t2645, t2650;
  double t2676, t2680, t2693, t2708, t2731, t2734, t2735, tv4rho3sigma0;
  double tv4rho3lapl0, t2739, t2743, t2744, t2748, t2789, t2794, t2807;
  double t2828, t2848, t2849, t2871, t2876, t2886, t2894, t2897;
  double t2904, t2941, t2944, t2947, t2959, t2961, t2964, t2965;
  double t2973, t2997, t2999, tv4rho3tau0, t3017, t3031, t3046, t3048;
  double t3062, t3082, t3086, t3128, t3134, t3148, t3153, t3156;
  double t3159, t3167, t3170, t3176, t3177, t3185, t3186, t3193;
  double t3200, t3205, t3209, t3243, t3248, t3265, t3270, t3283;
  double t3284, tv4rho2sigma20, tv4rho2sigmalapl0, t3294, t3300, t3304, t3356, t3373;
  double t3376, t3398, t3410, t3417, t3422, t3430, t3435, t3442;
  double t3445, t3448, t3470, t3507, t3508, t3511, t3536, t3553;
  double t3574, t3590, t3629, t3637, t3639, tv4rho2sigmatau0, tv4rho2lapl20, tv4rho2lapltau0;
  double t3664, t3676, t3684, t3705, t3706, t3714, t3722, t3739;
  double t3740, t3748, t3763, t3775, t3780, t3792, t3797, t3802;
  double t3812, t3825, t3844, t3857, t3869, t3870, t3890, t3892;
  double t3896, t3902, t3904, tv4rho2tau20, t3933, t3940, t3978, t3981;
  double t3987, t3990, t4003, t4004, t4013, t4018, t4025, t4030;
  double t4056, t4061, t4087, tv4rhosigma30, tv4rhosigma2lapl0, t4093, t4110, t4137;
  double t4140, t4143, t4166, t4189, t4196, t4213, t4216, t4236;
  double t4241, t4248, t4252, t4257, t4258, t4279, t4299, t4311;
  double t4319, t4324, t4343, t4386, t4390, t4396, t4398, tv4rhosigma2tau0;
  double tv4rhosigmalapl20, tv4rhosigmalapltau0, t4437, t4446, t4460, t4463, t4499, t4500;
  double t4527, t4569, t4588, t4593, t4596, t4599, t4602, t4628;
  double t4629, t4640, t4642, t4655, t4687, t4689, tv4rhosigmatau20, tv4rholapl30;
  double tv4rholapl2tau0, tv4rholapltau20, t4727, t4730, t4737, t4740, t4757, t4767;
  double t4788, t4806, t4811, t4814, t4825, t4843, t4849, t4856;
  double t4859, t4868, t4869, tv4rhotau30, t4889, t4895, t4898, t4905;
  double t4906, t4910, t4914, t4929, t4935, t4938, t4960, t4968;
  double t4974, tv4sigma40, tv4sigma3lapl0, t5009, t5012, t5018, t5022, t5031;
  double t5040, t5079, t5111, t5120, t5121, tv4sigma3tau0, tv4sigma2lapl20, tv4sigma2lapltau0;
  double t5135, t5146, t5156, t5168, t5184, t5239, t5264, t5299;
  double t5300, tv4sigma2tau20, tv4sigmalapl30, tv4sigmalapl2tau0, tv4sigmalapltau20, t5334, t5370, t5401;
  double t5445, tv4sigmatau30, tv4lapl40, tv4lapl3tau0, tv4lapl2tau20, tv4lapltau30, t5447, t5455;
  double t5464, t5494, t5523, t5532, t5543, t5544, t5554, tv4tau40;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t3 = rho[0] / 0.2e1 <= p->dens_threshold;
  t4 = M_CBRT3;
  t5 = M_CBRTPI;
  t7 = t4 / t5;
  t8 = 0.1e1 <= p->zeta_threshold;
  t9 = p->zeta_threshold - 0.1e1;
  t11 = my_piecewise5(t8, t9, t8, -t9, 0);
  t12 = 0.1e1 + t11;
  t14 = POW_1_3(p->zeta_threshold);
  t16 = POW_1_3(t12);
  t18 = my_piecewise3(t12 <= p->zeta_threshold, t14 * p->zeta_threshold, t16 * t12);
  t19 = POW_1_3(rho[0]);
  t20 = t18 * t19;
  t21 = sigma[0] * sigma[0];
  t22 = params->c * t21;
  t23 = rho[0] * rho[0];
  t24 = 0.1e1 / t23;
  t25 = tau[0] * tau[0];
  t26 = 0.1e1 / t25;
  t27 = t24 * t26;
  t28 = t21 * t24;
  t29 = t28 * t26;
  t31 = 0.1e1 + t29 / 0.64e2;
  t32 = t31 * t31;
  t33 = 0.1e1 / t32;
  t34 = t27 * t33;
  t38 = M_CBRT6;
  t39 = (0.1e2 / 0.81e2 + t22 * t34 / 0.64e2) * t38;
  t40 = M_PI * M_PI;
  t41 = POW_1_3(t40);
  t42 = t41 * t41;
  t43 = 0.1e1 / t42;
  t44 = t39 * t43;
  t45 = M_CBRT2;
  t46 = t45 * t45;
  t47 = sigma[0] * t46;
  t48 = t19 * t19;
  t50 = 0.1e1 / t48 / t23;
  t51 = t47 * t50;
  t54 = tau[0] * t46;
  t56 = 0.1e1 / t48 / rho[0];
  t59 = t54 * t56 - t51 / 0.8e1;
  t63 = 0.5e1 / 0.9e1 * t59 * t38 * t43 - 0.1e1;
  t64 = params->b * t59;
  t65 = t38 * t43;
  t66 = t65 * t63;
  t69 = 0.5e1 * t64 * t66 + 0.9e1;
  t70 = sqrt(t69);
  t71 = 0.1e1 / t70;
  t76 = 0.27e2 / 0.2e2 * t63 * t71 + t65 * t51 / 0.36e2;
  t77 = t76 * t76;
  t80 = t38 * t38;
  t82 = 0.1e1 / t41 / t40;
  t83 = t80 * t82;
  t84 = t21 * t45;
  t85 = t23 * t23;
  t86 = t85 * rho[0];
  t88 = 0.1e1 / t19 / t86;
  t89 = t84 * t88;
  t92 = 0.1e3 * t83 * t89 + 0.162e3 * t29;
  t93 = sqrt(t92);
  t96 = 0.1e1 / params->kappa;
  t97 = t96 * t80;
  t98 = t97 * t82;
  t101 = sqrt(params->e);
  t102 = t101 * t21;
  t105 = params->e * params->mu;
  t106 = t40 * t40;
  t107 = 0.1e1 / t106;
  t108 = t21 * sigma[0];
  t109 = t107 * t108;
  t110 = t85 * t85;
  t111 = 0.1e1 / t110;
  t115 = t44 * t51 / 0.24e2 + 0.146e3 / 0.2025e4 * t77 - 0.73e2 / 0.972e5 * t76 * t93 + 0.25e2 / 0.472392e6 * t98 * t89 + t102 * t27 / 0.72e3 + t105 * t109 * t111 / 0.576e3;
  t116 = t101 * t38;
  t120 = 0.1e1 + t116 * t43 * t51 / 0.24e2;
  t121 = t120 * t120;
  t122 = 0.1e1 / t121;
  t125 = exp(-t115 * t122 * t96);
  t128 = 0.1e1 + params->kappa * (0.1e1 - t125);
  t132 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t7 * t20 * t128);
  tzk0 = 0.2e1 * t132;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t133 = 0.1e1 / t48;
  t134 = t18 * t133;
  t138 = t7 * t18;
  t139 = t19 * params->kappa;
  t140 = t23 * rho[0];
  t141 = 0.1e1 / t140;
  t142 = t141 * t26;
  t143 = t142 * t33;
  t146 = t21 * t21;
  t147 = params->c * t146;
  t148 = 0.1e1 / t86;
  t149 = t25 * t25;
  t150 = 0.1e1 / t149;
  t153 = 0.1e1 / t32 / t31;
  t154 = t148 * t150 * t153;
  t158 = (-t22 * t143 / 0.32e2 + t147 * t154 / 0.1024e4) * t38;
  t159 = t158 * t43;
  t163 = 0.1e1 / t48 / t140;
  t164 = t47 * t163;
  t170 = -0.5e1 / 0.3e1 * t54 * t50 + t164 / 0.3e1;
  t171 = t170 * t38;
  t172 = t43 * t71;
  t176 = 0.1e1 / t70 / t69;
  t177 = t63 * t176;
  t181 = t83 * t170;
  t184 = 0.5e1 * params->b * t170 * t66 + 0.25e2 / 0.9e1 * t64 * t181;
  t187 = t65 * t164;
  t189 = 0.3e1 / 0.4e1 * t171 * t172 - 0.27e2 / 0.4e2 * t177 * t184 - 0.2e1 / 0.27e2 * t187;
  t194 = 0.1e1 / t93;
  t195 = t76 * t194;
  t196 = t21 * t141;
  t199 = t85 * t23;
  t201 = 0.1e1 / t19 / t199;
  t202 = t84 * t201;
  t205 = -0.324e3 * t196 * t26 - 0.16e4 / 0.3e1 * t83 * t202;
  t212 = t110 * rho[0];
  t213 = 0.1e1 / t212;
  t217 = t159 * t51 / 0.24e2 - t44 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t76 * t189 - 0.73e2 / 0.972e5 * t189 * t93 - 0.73e2 / 0.1944e6 * t195 * t205 - 0.5e2 / 0.177147e6 * t98 * t202 - t102 * t142 / 0.36e3 - t105 * t109 * t213 / 0.72e2;
  t220 = t121 * t120;
  t221 = 0.1e1 / t220;
  t223 = t96 * t101;
  t224 = t115 * t221 * t223;
  t227 = -t217 * t122 * t96 - 0.2e1 / 0.9e1 * t224 * t187;
  t228 = t227 * t125;
  t233 = my_piecewise3(t3, 0, -t7 * t134 * t128 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t228);
  tvrho0 = 0.2e1 * rho[0] * t233 + 0.2e1 * t132;

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t236 = params->c * sigma[0];
  t239 = params->c * t108;
  t240 = 0.1e1 / t85;
  t241 = t240 * t150;
  t242 = t241 * t153;
  t246 = (t236 * t34 / 0.32e2 - t239 * t242 / 0.1024e4) * t38;
  t247 = t246 * t43;
  t250 = t43 * t46;
  t251 = t250 * t50;
  t254 = t46 * t50;
  t255 = t65 * t71;
  t256 = t254 * t255;
  t258 = params->b * t46;
  t259 = t258 * t50;
  t260 = t259 * t66;
  t262 = t64 * t80;
  t263 = t82 * t46;
  t265 = t262 * t263 * t50;
  t267 = -0.5e1 / 0.8e1 * t260 - 0.25e2 / 0.72e2 * t265;
  t270 = t254 * t65;
  t272 = -0.3e1 / 0.32e2 * t256 - 0.27e2 / 0.4e2 * t177 * t267 + t270 / 0.36e2;
  t277 = sigma[0] * t24;
  t280 = sigma[0] * t45;
  t281 = t280 * t88;
  t284 = 0.324e3 * t277 * t26 + 0.2e3 * t83 * t281;
  t289 = t101 * sigma[0];
  t292 = t107 * t21;
  t296 = t247 * t51 / 0.24e2 + t39 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t272 - 0.73e2 / 0.972e5 * t272 * t93 - 0.73e2 / 0.1944e6 * t195 * t284 + 0.25e2 / 0.236196e6 * t98 * t281 + t289 * t27 / 0.36e3 + t105 * t292 * t111 / 0.192e3;
  t301 = -t296 * t122 * t96 + t224 * t270 / 0.12e2;
  t302 = t301 * t125;
  t306 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t302);
  tvsigma0 = 0.2e1 * rho[0] * t306;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  t308 = t25 * tau[0];
  t309 = 0.1e1 / t308;
  t310 = t24 * t309;
  t311 = t310 * t33;
  t314 = t149 * tau[0];
  t315 = 0.1e1 / t314;
  t317 = t240 * t315 * t153;
  t321 = (-t22 * t311 / 0.32e2 + t147 * t317 / 0.1024e4) * t38;
  t322 = t321 * t43;
  t325 = t46 * t56;
  t328 = t258 * t56;
  t334 = 0.5e1 * t328 * t66 + 0.25e2 / 0.9e1 * t262 * t263 * t56;
  t337 = 0.3e1 / 0.4e1 * t325 * t255 - 0.27e2 / 0.4e2 * t177 * t334;
  t342 = t28 * t309;
  t347 = t322 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t337 - 0.73e2 / 0.972e5 * t337 * t93 + 0.73e2 / 0.6e3 * t195 * t342 - t102 * t310 / 0.36e3;
  t349 = t122 * t125;
  t353 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t347 * t349);
  tvtau0 = 0.2e1 * rho[0] * t353;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t356 = t18 * t56;
  t360 = t133 * params->kappa;
  t364 = t240 * t26;
  t365 = t364 * t33;
  t368 = 0.1e1 / t199;
  t370 = t368 * t150 * t153;
  t373 = t146 * t21;
  t374 = params->c * t373;
  t375 = t149 * t25;
  t376 = 0.1e1 / t375;
  t378 = t32 * t32;
  t379 = 0.1e1 / t378;
  t380 = t111 * t376 * t379;
  t384 = (0.3e1 / 0.32e2 * t22 * t365 - 0.7e1 / 0.1024e4 * t147 * t370 + 0.3e1 / 0.32768e5 * t374 * t380) * t38;
  t385 = t384 * t43;
  t391 = 0.1e1 / t48 / t85;
  t392 = t47 * t391;
  t395 = t189 * t189;
  t400 = 0.4e2 / 0.9e1 * t54 * t163 - 0.11e2 / 0.9e1 * t392;
  t401 = t400 * t38;
  t404 = t43 * t176;
  t405 = t404 * t184;
  t408 = t69 * t69;
  t410 = 0.1e1 / t70 / t408;
  t411 = t63 * t410;
  t412 = t184 * t184;
  t415 = params->b * t400;
  t418 = t170 * t170;
  t422 = t83 * t400;
  t425 = 0.5e1 * t415 * t66 + 0.5e2 / 0.9e1 * params->b * t418 * t83 + 0.25e2 / 0.9e1 * t64 * t422;
  t428 = t65 * t392;
  t430 = 0.3e1 / 0.4e1 * t401 * t172 - 0.3e1 / 0.4e1 * t171 * t405 + 0.81e2 / 0.8e2 * t411 * t412 - 0.27e2 / 0.4e2 * t177 * t425 + 0.22e2 / 0.81e2 * t428;
  t435 = t189 * t194;
  t439 = 0.1e1 / t93 / t92;
  t440 = t76 * t439;
  t441 = t205 * t205;
  t444 = t21 * t240;
  t447 = t85 * t140;
  t449 = 0.1e1 / t19 / t447;
  t450 = t84 * t449;
  t451 = t83 * t450;
  t453 = 0.972e3 * t444 * t26 + 0.304e5 / 0.9e1 * t451;
  t460 = t110 * t23;
  t461 = 0.1e1 / t460;
  t465 = t385 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t159 * t164 + 0.11e2 / 0.27e2 * t44 * t392 + 0.292e3 / 0.2025e4 * t395 + 0.292e3 / 0.2025e4 * t76 * t430 - 0.73e2 / 0.972e5 * t430 * t93 - 0.73e2 / 0.972e5 * t435 * t205 + 0.73e2 / 0.3888e6 * t440 * t441 - 0.73e2 / 0.1944e6 * t195 * t453 + 0.95e3 / 0.531441e6 * t98 * t450 + t102 * t364 / 0.12e3 + t105 * t109 * t461 / 0.8e1;
  t469 = t217 * t221 * t223;
  t472 = t121 * t121;
  t473 = 0.1e1 / t472;
  t475 = t96 * params->e;
  t476 = t115 * t473 * t475;
  t481 = -t465 * t122 * t96 - 0.4e1 / 0.9e1 * t469 * t187 - 0.4e1 / 0.27e2 * t476 * t451 + 0.22e2 / 0.27e2 * t224 * t428;
  t482 = t481 * t125;
  t486 = t227 * t227;
  t487 = t486 * t125;
  t492 = my_piecewise3(t3, 0, t7 * t356 * t128 / 0.12e2 + t138 * t360 * t228 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t482 + 0.3e1 / 0.8e1 * t138 * t139 * t487);
  tv2rho20 = 0.2e1 * rho[0] * t492 + 0.4e1 * t233;

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t502 = t146 * sigma[0];
  t503 = params->c * t502;
  t504 = 0.1e1 / t447;
  t506 = t504 * t376 * t379;
  t510 = (-t236 * t143 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t154 - 0.3e1 / 0.32768e5 * t503 * t506) * t38;
  t511 = t510 * t43;
  t518 = t250 * t163;
  t523 = t46 * t163;
  t524 = t523 * t255;
  t526 = t254 * t38;
  t527 = t526 * t405;
  t529 = t404 * t267;
  t532 = t267 * t184;
  t535 = t258 * t163;
  t536 = t535 * t66;
  t538 = t259 * t181;
  t541 = t262 * t263 * t163;
  t543 = 0.5e1 / 0.3e1 * t536 - 0.25e2 / 0.36e2 * t538 + 0.25e2 / 0.27e2 * t541;
  t546 = t523 * t65;
  t548 = t524 / 0.4e1 + 0.3e1 / 0.64e2 * t527 - 0.3e1 / 0.8e1 * t171 * t529 + 0.81e2 / 0.8e2 * t411 * t532 - 0.27e2 / 0.4e2 * t177 * t543 - 0.2e1 / 0.27e2 * t546;
  t553 = t272 * t194;
  t558 = t284 * t205;
  t561 = sigma[0] * t141;
  t564 = t280 * t201;
  t565 = t83 * t564;
  t567 = -0.648e3 * t561 * t26 - 0.32e4 / 0.3e1 * t565;
  t577 = t511 * t51 / 0.24e2 - t247 * t164 / 0.9e1 + t158 * t251 / 0.24e2 - t39 * t518 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t272 + 0.292e3 / 0.2025e4 * t76 * t548 - 0.73e2 / 0.972e5 * t548 * t93 - 0.73e2 / 0.1944e6 * t553 * t205 - 0.73e2 / 0.1944e6 * t435 * t284 + 0.73e2 / 0.3888e6 * t440 * t558 - 0.73e2 / 0.1944e6 * t195 * t567 - 0.1e3 / 0.177147e6 * t98 * t564 - t289 * t142 / 0.18e3 - t105 * t292 * t213 / 0.24e2;
  t581 = t296 * t221 * t223;
  t590 = -t577 * t122 * t96 - 0.2e1 / 0.9e1 * t581 * t187 + t469 * t270 / 0.12e2 + t476 * t565 / 0.18e2 - 0.2e1 / 0.9e1 * t224 * t546;
  t591 = t590 * t125;
  t595 = t7 * t20;
  t596 = params->kappa * t301;
  t597 = t596 * t228;
  t601 = my_piecewise3(t3, 0, t138 * t360 * t302 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t591 + 0.3e1 / 0.8e1 * t595 * t597);
  tv2rhosigma0 = 0.2e1 * rho[0] * t601 + 0.2e1 * t306;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  t608 = t141 * t309;
  t609 = t608 * t33;
  t613 = t148 * t315 * t153;
  t617 = 0.1e1 / t149 / t308;
  t619 = t504 * t617 * t379;
  t623 = (t22 * t609 / 0.16e2 - 0.3e1 / 0.512e3 * t147 * t613 + 0.3e1 / 0.32768e5 * t374 * t619) * t38;
  t624 = t623 * t43;
  t632 = t325 * t38;
  t635 = t404 * t334;
  t638 = t334 * t184;
  t645 = -0.25e2 / 0.3e1 * t260 + 0.5e2 / 0.9e1 * t328 * t181 - 0.125e3 / 0.27e2 * t265;
  t648 = -0.5e1 / 0.4e1 * t256 - 0.3e1 / 0.8e1 * t632 * t405 - 0.3e1 / 0.8e1 * t171 * t635 + 0.81e2 / 0.8e2 * t411 * t638 - 0.27e2 / 0.4e2 * t177 * t645;
  t653 = t337 * t194;
  t658 = t440 * t21;
  t659 = t310 * t205;
  t662 = t196 * t309;
  t667 = t624 * t51 / 0.24e2 - t322 * t164 / 0.9e1 + 0.292e3 / 0.2025e4 * t189 * t337 + 0.292e3 / 0.2025e4 * t76 * t648 - 0.73e2 / 0.972e5 * t648 * t93 - 0.73e2 / 0.1944e6 * t653 * t205 + 0.73e2 / 0.6e3 * t435 * t342 - 0.73e2 / 0.12e4 * t658 * t659 - 0.73e2 / 0.3e3 * t195 * t662 + t102 * t608 / 0.18e3;
  t673 = 0.1e1 / t19 / t140;
  t674 = t673 * t347;
  t676 = t138 * t674 * t221;
  t680 = t43 * sigma[0] * t46;
  t681 = t125 * t101 * t38 * t680;
  t684 = t347 * t122;
  t685 = t684 * t228;
  t689 = my_piecewise3(t3, 0, -t138 * t133 * t347 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t667 * t349 - t676 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t685);
  tv2rhotau0 = 0.2e1 * rho[0] * t689 + 0.2e1 * t353;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t692 = params->c * t24;
  t693 = t26 * t33;
  t698 = t368 * t376;
  t699 = t698 * t379;
  t703 = (t692 * t693 / 0.32e2 - 0.5e1 / 0.1024e4 * t22 * t242 + 0.3e1 / 0.32768e5 * t147 * t699) * t38;
  t704 = t703 * t43;
  t709 = t272 * t272;
  t711 = t526 * t529;
  t713 = t267 * t267;
  t716 = t177 * params->b;
  t717 = t45 * t88;
  t718 = t83 * t717;
  t719 = t716 * t718;
  t721 = 0.3e1 / 0.32e2 * t711 + 0.81e2 / 0.8e2 * t411 * t713 - 0.15e2 / 0.128e3 * t719;
  t728 = t284 * t284;
  t733 = 0.324e3 * t27 + 0.2e3 * t718;
  t736 = t82 * t45;
  t740 = t101 * t24;
  t743 = t107 * sigma[0];
  t747 = t704 * t51 / 0.24e2 + t246 * t251 / 0.12e2 + 0.292e3 / 0.2025e4 * t709 + 0.292e3 / 0.2025e4 * t76 * t721 - 0.73e2 / 0.972e5 * t721 * t93 - 0.73e2 / 0.972e5 * t553 * t284 + 0.73e2 / 0.3888e6 * t440 * t728 - 0.73e2 / 0.1944e6 * t195 * t733 + 0.25e2 / 0.236196e6 * t97 * t736 * t88 + t740 * t26 / 0.36e3 + t105 * t743 * t111 / 0.96e2;
  t754 = -t747 * t122 * t96 + t581 * t270 / 0.6e1 - t476 * t718 / 0.48e2;
  t755 = t754 * t125;
  t758 = t301 * t301;
  t759 = t758 * t125;
  t764 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t755 + 0.3e1 / 0.8e1 * t138 * t139 * t759);
  tv2sigma20 = 0.2e1 * rho[0] * t764;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  t771 = t368 * t617 * t379;
  t775 = (-t236 * t311 / 0.16e2 + 0.3e1 / 0.512e3 * t239 * t317 - 0.3e1 / 0.32768e5 * t503 * t771) * t38;
  t776 = t775 * t43;
  t785 = t526 * t635;
  t787 = t334 * t267;
  t791 = 0.1e1 / t19 / t85;
  t792 = t45 * t791;
  t793 = t792 * t83;
  t794 = t716 * t793;
  t796 = -0.3e1 / 0.8e1 * t632 * t529 + 0.3e1 / 0.64e2 * t785 + 0.81e2 / 0.8e2 * t411 * t787 + 0.15e2 / 0.16e2 * t794;
  t805 = t310 * t284;
  t808 = t277 * t309;
  t813 = t776 * t51 / 0.24e2 + t321 * t251 / 0.24e2 + 0.292e3 / 0.2025e4 * t272 * t337 + 0.292e3 / 0.2025e4 * t76 * t796 - 0.73e2 / 0.972e5 * t796 * t93 - 0.73e2 / 0.1944e6 * t653 * t284 + 0.73e2 / 0.6e3 * t553 * t342 - 0.73e2 / 0.12e4 * t658 * t805 + 0.73e2 / 0.3e3 * t195 * t808 - t289 * t310 / 0.18e3;
  t819 = 0.1e1 / t19 / t23;
  t820 = t18 * t819;
  t825 = t65 * t46;
  t826 = t221 * t125 * t101 * t825;
  t829 = t684 * t302;
  t833 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t813 * t349 + t7 * t820 * t347 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t829);
  tv2sigmatau0 = 0.2e1 * rho[0] * t833;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  t835 = t24 * t150;
  t836 = t835 * t33;
  t839 = t240 * t376;
  t840 = t839 * t153;
  t843 = t149 * t149;
  t844 = 0.1e1 / t843;
  t846 = t368 * t844 * t379;
  t850 = (0.3e1 / 0.32e2 * t22 * t836 - 0.7e1 / 0.1024e4 * t147 * t840 + 0.3e1 / 0.32768e5 * t374 * t846) * t38;
  t851 = t850 * t43;
  t854 = t337 * t337;
  t858 = t334 * t334;
  t861 = t45 * t673;
  t862 = t861 * t83;
  t865 = -0.3e1 / 0.4e1 * t632 * t635 + 0.81e2 / 0.8e2 * t411 * t858 - 0.15e2 / 0.2e1 * t716 * t862;
  t872 = t146 * t240;
  t873 = t872 * t376;
  t876 = t28 * t150;
  t881 = t851 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t854 + 0.292e3 / 0.2025e4 * t76 * t865 - 0.73e2 / 0.972e5 * t865 * t93 + 0.73e2 / 0.3e3 * t653 * t342 + 0.1971e4 / 0.1e3 * t440 * t873 - 0.73e2 / 0.2e3 * t195 * t876 + t102 * t835 / 0.12e3;
  t885 = t347 * t347;
  t886 = t885 * t473;
  t887 = t96 * t125;
  t888 = t886 * t887;
  t892 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t881 * t349 + 0.3e1 / 0.8e1 * t595 * t888);
  tv2tau20 = 0.2e1 * rho[0] * t892;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  t899 = t56 * params->kappa;
  t909 = t148 * t26;
  t910 = t909 * t33;
  t914 = t504 * t150 * t153;
  t918 = t213 * t376 * t379;
  t921 = t146 * t146;
  t922 = params->c * t921;
  t923 = t110 * t140;
  t924 = 0.1e1 / t923;
  t927 = 0.1e1 / t378 / t31;
  t928 = t924 * t844 * t927;
  t932 = (-0.3e1 / 0.8e1 * t22 * t910 + 0.3e1 / 0.64e2 * t147 * t914 - 0.45e2 / 0.32768e5 * t374 * t918 + 0.3e1 / 0.262144e6 * t922 * t928) * t38;
  t933 = t932 * t43;
  t941 = 0.1e1 / t48 / t86;
  t942 = t47 * t941;
  t950 = -0.44e3 / 0.27e2 * t54 * t391 + 0.154e3 / 0.27e2 * t942;
  t951 = t950 * t38;
  t956 = t43 * t410;
  t957 = t956 * t412;
  t960 = t404 * t425;
  t965 = 0.1e1 / t70 / t408 / t69;
  t966 = t63 * t965;
  t967 = t412 * t184;
  t970 = t184 * t425;
  t973 = params->b * t950;
  t978 = t83 * t950;
  t981 = 0.5e1 * t973 * t66 + 0.5e2 / 0.3e1 * t415 * t181 + 0.25e2 / 0.9e1 * t64 * t978;
  t984 = t65 * t942;
  t986 = 0.3e1 / 0.4e1 * t951 * t172 - 0.9e1 / 0.8e1 * t401 * t405 + 0.27e2 / 0.16e2 * t171 * t957 - 0.9e1 / 0.8e1 * t171 * t960 - 0.81e2 / 0.32e2 * t966 * t967 + 0.243e3 / 0.8e2 * t411 * t970 - 0.27e2 / 0.4e2 * t177 * t981 - 0.308e3 / 0.243e3 * t984;
  t991 = t430 * t194;
  t994 = t189 * t439;
  t999 = t92 * t92;
  t1001 = 0.1e1 / t93 / t999;
  t1002 = t76 * t1001;
  t1003 = t441 * t205;
  t1006 = t205 * t453;
  t1009 = t21 * t148;
  t1013 = 0.1e1 / t19 / t110;
  t1014 = t84 * t1013;
  t1015 = t83 * t1014;
  t1017 = -0.3888e4 * t1009 * t26 - 0.6688e6 / 0.27e2 * t1015;
  t1027 = t933 * t51 / 0.24e2 - t385 * t164 / 0.3e1 + 0.11e2 / 0.9e1 * t159 * t392 - 0.154e3 / 0.81e2 * t44 * t942 + 0.292e3 / 0.675e3 * t189 * t430 + 0.292e3 / 0.2025e4 * t76 * t986 - 0.73e2 / 0.972e5 * t986 * t93 - 0.73e2 / 0.648e5 * t991 * t205 + 0.73e2 / 0.1296e6 * t994 * t441 - 0.73e2 / 0.648e5 * t435 * t453 - 0.73e2 / 0.2592e6 * t1002 * t1003 + 0.73e2 / 0.1296e6 * t440 * t1006 - 0.73e2 / 0.1944e6 * t195 * t1017 - 0.209e5 / 0.1594323e7 * t98 * t1014 - t102 * t909 / 0.3e2 - 0.5e1 / 0.4e1 * t105 * t109 * t924;
  t1031 = t465 * t221 * t223;
  t1035 = t217 * t473 * t475;
  t1041 = 0.1e1 / t472 / t120;
  t1043 = t115 * t1041 * t96;
  t1044 = t101 * params->e;
  t1045 = t1044 * t107;
  t1047 = t1045 * t108 * t924;
  t1054 = -t1027 * t122 * t96 - 0.2e1 / 0.3e1 * t1031 * t187 - 0.4e1 / 0.9e1 * t1035 * t451 + 0.22e2 / 0.9e1 * t469 * t428 - 0.64e2 / 0.81e2 * t1043 * t1047 + 0.44e2 / 0.27e2 * t476 * t1015 - 0.308e3 / 0.81e2 * t224 * t984;
  t1055 = t1054 * t125;
  t1059 = params->kappa * t481;
  t1060 = t1059 * t228;
  t1064 = t486 * t227 * t125;
  t1069 = my_piecewise3(t3, 0, -0.5e1 / 0.36e2 * t7 * t18 * t50 * t128 - t138 * t899 * t228 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t360 * t482 + 0.3e1 / 0.8e1 * t138 * t360 * t487 + 0.3e1 / 0.8e1 * t138 * t139 * t1055 + 0.9e1 / 0.8e1 * t595 * t1060 + 0.3e1 / 0.8e1 * t138 * t139 * t1064);
  tv3rho30 = 0.2e1 * rho[0] * t1069 + 0.6e1 * t492;

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t1079 = t7 * t134;
  t1086 = t46 * t391;
  t1087 = t1086 * t255;
  t1089 = t523 * t38;
  t1090 = t1089 * t405;
  t1092 = t526 * t957;
  t1094 = t526 * t960;
  t1098 = t171 * t43;
  t1099 = t410 * t267;
  t1100 = t1099 * t184;
  t1103 = t404 * t543;
  t1106 = t267 * t412;
  t1109 = t543 * t184;
  t1112 = t267 * t425;
  t1115 = t258 * t391;
  t1116 = t1115 * t66;
  t1118 = t535 * t181;
  t1120 = t259 * t422;
  t1123 = t262 * t263 * t391;
  t1125 = -0.55e2 / 0.9e1 * t1116 + 0.1e3 / 0.27e2 * t1118 - 0.25e2 / 0.36e2 * t1120 - 0.275e3 / 0.81e2 * t1123;
  t1128 = t1086 * t65;
  t1130 = -0.11e2 / 0.12e2 * t1087 - t1090 / 0.4e1 - 0.9e1 / 0.128e3 * t1092 + 0.3e1 / 0.64e2 * t1094 - 0.3e1 / 0.8e1 * t401 * t529 + 0.9e1 / 0.8e1 * t1098 * t1100 - 0.3e1 / 0.4e1 * t171 * t1103 - 0.81e2 / 0.32e2 * t966 * t1106 + 0.81e2 / 0.4e2 * t411 * t1109 + 0.81e2 / 0.8e2 * t411 * t1112 - 0.27e2 / 0.4e2 * t177 * t1125 + 0.22e2 / 0.81e2 * t1128;
  t1135 = t548 * t194;
  t1144 = sigma[0] * t240;
  t1147 = t280 * t449;
  t1148 = t83 * t1147;
  t1150 = 0.1944e4 * t1144 * t26 + 0.608e5 / 0.9e1 * t1148;
  t1157 = 0.292e3 / 0.2025e4 * t430 * t272 + 0.584e3 / 0.2025e4 * t189 * t548 + 0.292e3 / 0.2025e4 * t76 * t1130 - 0.73e2 / 0.972e5 * t1130 * t93 - 0.73e2 / 0.972e5 * t1135 * t205 - 0.73e2 / 0.1944e6 * t553 * t453 - 0.73e2 / 0.1944e6 * t991 * t284 - 0.73e2 / 0.972e5 * t435 * t567 - 0.73e2 / 0.1944e6 * t195 * t1150 - 0.2e1 / 0.9e1 * t511 * t164 + 0.11e2 / 0.27e2 * t247 * t392;
  t1167 = params->c * t146 * t108;
  t1169 = t461 * t844 * t927;
  t1173 = (0.3e1 / 0.16e2 * t236 * t365 - 0.17e2 / 0.512e3 * t239 * t370 + 0.39e2 / 0.32768e5 * t503 * t380 - 0.3e1 / 0.262144e6 * t1167 * t1169) * t38;
  t1174 = t1173 * t43;
  t1179 = t250 * t391;
  t1182 = t272 * t439;
  t1187 = t567 * t205;
  t1190 = t284 * t453;
  t1195 = t284 * t441;
  t1203 = 0.19e4 / 0.531441e6 * t98 * t1147 + t1174 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t158 * t518 + 0.11e2 / 0.27e2 * t39 * t1179 + 0.73e2 / 0.3888e6 * t1182 * t441 + 0.73e2 / 0.1944e6 * t994 * t558 + 0.73e2 / 0.1944e6 * t440 * t1187 + 0.73e2 / 0.3888e6 * t440 * t1190 + t289 * t364 / 0.6e2 - 0.73e2 / 0.2592e6 * t1002 * t1195 + 0.3e1 / 0.8e1 * t105 * t292 * t461 + t384 * t251 / 0.24e2;
  t1204 = t1157 + t1203;
  t1208 = t577 * t221 * t223;
  t1212 = t296 * t473 * t475;
  t1224 = t1045 * t461 * t21;
  t1231 = -t1204 * t122 * t96 - 0.4e1 / 0.9e1 * t1208 * t187 - 0.4e1 / 0.27e2 * t1212 * t451 + 0.22e2 / 0.27e2 * t581 * t428 + t1031 * t270 / 0.12e2 + t1035 * t565 / 0.9e1 - 0.4e1 / 0.9e1 * t469 * t546 + 0.8e1 / 0.27e2 * t1043 * t1224 - t476 * t1148 / 0.2e1 + 0.22e2 / 0.27e2 * t224 * t1128;
  t1232 = t1231 * t125;
  t1236 = params->kappa * t590;
  t1237 = t1236 * t228;
  t1240 = t596 * t482;
  t1243 = t596 * t487;
  t1247 = my_piecewise3(t3, 0, -t138 * t899 * t302 / 0.12e2 + t138 * t360 * t591 / 0.4e1 + t1079 * t597 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t1232 + 0.3e1 / 0.4e1 * t595 * t1237 + 0.3e1 / 0.8e1 * t595 * t1240 + 0.3e1 / 0.8e1 * t595 * t1243);
  tv3rho2sigma0 = 0.2e1 * rho[0] * t1247 + 0.4e1 * t601;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  t1261 = t138 * t791 * t347 * t221;
  t1266 = t240 * t309;
  t1267 = t1266 * t33;
  t1271 = t368 * t315 * t153;
  t1275 = t111 * t617 * t379;
  t1279 = 0.1e1 / t843 / tau[0];
  t1281 = t461 * t1279 * t927;
  t1285 = (-0.3e1 / 0.16e2 * t22 * t1267 + 0.17e2 / 0.512e3 * t147 * t1271 - 0.39e2 / 0.32768e5 * t374 * t1275 + 0.3e1 / 0.262144e6 * t922 * t1281) * t38;
  t1286 = t1285 * t43;
  t1305 = t410 * t334;
  t1306 = t1305 * t184;
  t1309 = t404 * t645;
  t1312 = t334 * t412;
  t1315 = t645 * t184;
  t1318 = t334 * t425;
  t1326 = 0.2e3 / 0.9e1 * t536 - 0.5e3 / 0.27e2 * t538 + 0.5e2 / 0.9e1 * t328 * t422 + 0.1e4 / 0.81e2 * t541;
  t1329 = 0.1e2 / 0.3e1 * t524 + 0.5e1 / 0.4e1 * t527 + 0.9e1 / 0.16e2 * t632 * t957 - 0.3e1 / 0.8e1 * t632 * t960 - 0.3e1 / 0.8e1 * t401 * t635 + 0.9e1 / 0.8e1 * t1098 * t1306 - 0.3e1 / 0.4e1 * t171 * t1309 - 0.81e2 / 0.32e2 * t966 * t1312 + 0.81e2 / 0.4e2 * t411 * t1315 + 0.81e2 / 0.8e2 * t411 * t1318 - 0.27e2 / 0.4e2 * t177 * t1326;
  t1334 = t648 * t194;
  t1337 = t337 * t439;
  t1344 = t994 * t21;
  t1349 = t1002 * t21;
  t1350 = t310 * t441;
  t1353 = t608 * t205;
  t1356 = t310 * t453;
  t1359 = t444 * t309;
  t1364 = t1286 * t51 / 0.24e2 - 0.2e1 / 0.9e1 * t624 * t164 + 0.11e2 / 0.27e2 * t322 * t392 + 0.292e3 / 0.2025e4 * t430 * t337 + 0.584e3 / 0.2025e4 * t189 * t648 + 0.292e3 / 0.2025e4 * t76 * t1329 - 0.73e2 / 0.972e5 * t1329 * t93 - 0.73e2 / 0.972e5 * t1334 * t205 + 0.73e2 / 0.3888e6 * t1337 * t441 - 0.73e2 / 0.1944e6 * t653 * t453 + 0.73e2 / 0.6e3 * t991 * t342 - 0.73e2 / 0.6e3 * t1344 * t659 - 0.73e2 / 0.15e3 * t435 * t662 + 0.73e2 / 0.8e3 * t1349 * t1350 + 0.73e2 / 0.3e3 * t658 * t1353 - 0.73e2 / 0.12e4 * t658 * t1356 + 0.73e2 / 0.1e3 * t195 * t1359 - t102 * t1266 / 0.6e2;
  t1371 = t138 * t673 * t667 * t221;
  t1374 = t667 * t122;
  t1375 = t1374 * t228;
  t1380 = t138 * t504 * t347 * t473;
  t1382 = t125 * params->e * t80;
  t1385 = t1382 * t82 * t21 * t45;
  t1388 = t228 * t101;
  t1389 = t65 * t47;
  t1390 = t1388 * t1389;
  t1393 = t684 * t482;
  t1396 = t684 * t487;
  t1399 = t138 * t56 * t347 * t349 / 0.12e2 - t138 * t133 * t667 * t349 / 0.4e1 + t1261 * t681 / 0.4e1 - t1079 * t685 / 0.4e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1364 * t349 - t1371 * t681 / 0.6e1 - 0.3e1 / 0.4e1 * t595 * t1375 - t1380 * t1385 / 0.18e2 - t676 * t1390 / 0.6e1 - 0.3e1 / 0.8e1 * t595 * t1393 - 0.3e1 / 0.8e1 * t595 * t1396;
  t1400 = my_piecewise3(t3, 0, t1399);
  tv3rho2tau0 = 0.2e1 * rho[0] * t1400 + 0.4e1 * t689;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t1406 = params->c * t141;
  t1409 = params->c * t148;
  t1410 = t150 * t153;
  t1411 = t1410 * t21;
  t1417 = t213 * t844 * t927;
  t1421 = (-t1406 * t693 / 0.16e2 + 0.11e2 / 0.512e3 * t1409 * t1411 - 0.33e2 / 0.32768e5 * t147 * t506 + 0.3e1 / 0.262144e6 * t374 * t1417) * t38;
  t1422 = t1421 * t43;
  t1435 = t1089 * t529;
  t1437 = t956 * t532;
  t1438 = t526 * t1437;
  t1440 = t526 * t1103;
  t1442 = t956 * t713;
  t1445 = t713 * t184;
  t1448 = t267 * t543;
  t1451 = t170 * t107;
  t1452 = t1451 * t176;
  t1453 = params->b * t45;
  t1454 = t1453 * t88;
  t1455 = t1452 * t1454;
  t1457 = t411 * t1453;
  t1458 = t88 * t80;
  t1459 = t82 * t184;
  t1461 = t1457 * t1458 * t1459;
  t1464 = t83 * t45 * t201;
  t1465 = t716 * t1464;
  t1467 = -t1435 / 0.4e1 - 0.9e1 / 0.64e2 * t1438 + 0.3e1 / 0.32e2 * t1440 + 0.9e1 / 0.16e2 * t171 * t1442 - 0.81e2 / 0.32e2 * t966 * t1445 + 0.81e2 / 0.4e2 * t411 * t1448 - 0.25e2 / 0.64e2 * t1455 + 0.45e2 / 0.256e3 * t1461 + 0.5e1 / 0.8e1 * t1465;
  t1472 = t721 * t194;
  t1484 = t728 * t205;
  t1487 = t284 * t567;
  t1492 = t733 * t205;
  t1497 = -0.648e3 * t142 - 0.32e4 / 0.3e1 * t1464;
  t1503 = t101 * t141;
  t1509 = 0.73e2 / 0.1944e6 * t1182 * t558 - 0.73e2 / 0.972e5 * t553 * t567 + 0.73e2 / 0.3888e6 * t994 * t728 - 0.73e2 / 0.2592e6 * t1002 * t1484 + 0.73e2 / 0.1944e6 * t440 * t1487 - 0.73e2 / 0.1944e6 * t435 * t733 + 0.73e2 / 0.3888e6 * t440 * t1492 - 0.73e2 / 0.1944e6 * t195 * t1497 - 0.1e3 / 0.177147e6 * t97 * t736 * t201 - t1503 * t26 / 0.18e3 - t105 * t743 * t213 / 0.12e2;
  t1510 = t1422 * t51 / 0.24e2 - t704 * t164 / 0.9e1 + t510 * t251 / 0.12e2 - 0.2e1 / 0.9e1 * t246 * t518 + 0.584e3 / 0.2025e4 * t272 * t548 + 0.292e3 / 0.2025e4 * t189 * t721 + 0.292e3 / 0.2025e4 * t76 * t1467 - 0.73e2 / 0.972e5 * t1467 * t93 - 0.73e2 / 0.1944e6 * t1472 * t205 - 0.73e2 / 0.972e5 * t1135 * t284 + t1509;
  t1514 = t747 * t221 * t223;
  t1526 = t1045 * t213 * sigma[0];
  t1531 = -t1510 * t122 * t96 - 0.2e1 / 0.9e1 * t1514 * t187 + t1208 * t270 / 0.6e1 + t1212 * t565 / 0.9e1 - 0.4e1 / 0.9e1 * t581 * t546 - t1035 * t718 / 0.48e2 - t1043 * t1526 / 0.9e1 + t476 * t1464 / 0.9e1;
  t1532 = t1531 * t125;
  t1536 = params->kappa * t754;
  t1537 = t1536 * t228;
  t1543 = t596 * t591;
  t1546 = params->kappa * t758;
  t1547 = t1546 * t228;
  t1551 = my_piecewise3(t3, 0, t138 * t360 * t755 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t1532 + 0.3e1 / 0.8e1 * t595 * t1537 + t138 * t360 * t759 / 0.8e1 + 0.3e1 / 0.4e1 * t595 * t1543 + 0.3e1 / 0.8e1 * t595 * t1547);
  tv3rhosigma20 = 0.2e1 * rho[0] * t1551 + 0.2e1 * t764;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  t1565 = t213 * t1279 * t927;
  t1569 = (t236 * t609 / 0.8e1 - 0.7e1 / 0.256e3 * t239 * t613 + 0.9e1 / 0.8192e4 * t503 * t619 - 0.3e1 / 0.262144e6 * t1167 * t1565) * t38;
  t1570 = t1569 * t43;
  t1590 = t1089 * t635;
  t1592 = t956 * t638;
  t1593 = t526 * t1592;
  t1595 = t526 * t1309;
  t1597 = t1305 * t267;
  t1603 = t645 * t267;
  t1606 = t334 * t543;
  t1609 = t1453 * t791;
  t1610 = t1452 * t1609;
  t1612 = t791 * t80;
  t1614 = t1457 * t1612 * t1459;
  t1617 = 0.5e1 / 0.8e1 * t711 + 0.9e1 / 0.16e2 * t632 * t1437 - 0.3e1 / 0.8e1 * t632 * t1103 - t1590 / 0.8e1 - 0.9e1 / 0.128e3 * t1593 + 0.3e1 / 0.64e2 * t1595 + 0.9e1 / 0.16e2 * t1098 * t1597 - 0.81e2 / 0.32e2 * t966 * t787 * t184 + 0.81e2 / 0.8e2 * t411 * t1603 + 0.81e2 / 0.8e2 * t411 * t1606 + 0.25e2 / 0.8e1 * t1610 - 0.45e2 / 0.32e2 * t1614 - 0.65e2 / 0.16e2 * t719;
  t1622 = t796 * t194;
  t1629 = t1570 * t51 / 0.24e2 - t776 * t164 / 0.9e1 + t623 * t251 / 0.24e2 - t321 * t518 / 0.9e1 + 0.292e3 / 0.2025e4 * t548 * t337 + 0.292e3 / 0.2025e4 * t272 * t648 + 0.292e3 / 0.2025e4 * t189 * t796 + 0.292e3 / 0.2025e4 * t76 * t1617 - 0.73e2 / 0.972e5 * t1617 * t93 - 0.73e2 / 0.1944e6 * t1622 * t205 - 0.73e2 / 0.1944e6 * t1334 * t284 + 0.73e2 / 0.3888e6 * t1337 * t558;
  t1634 = t1182 * t21;
  t1641 = t310 * t558;
  t1644 = t608 * t284;
  t1647 = t310 * t567;
  t1652 = t440 * sigma[0];
  t1655 = t561 * t309;
  t1660 = -0.73e2 / 0.1944e6 * t653 * t567 + 0.73e2 / 0.6e3 * t1135 * t342 - 0.73e2 / 0.12e4 * t1634 * t659 - 0.73e2 / 0.3e3 * t553 * t662 - 0.73e2 / 0.12e4 * t1344 * t805 + 0.73e2 / 0.8e3 * t1349 * t1641 + 0.73e2 / 0.6e3 * t658 * t1644 - 0.73e2 / 0.12e4 * t658 * t1647 + 0.73e2 / 0.3e3 * t435 * t808 - 0.73e2 / 0.6e3 * t1652 * t659 - 0.73e2 / 0.15e3 * t195 * t1655 + t289 * t608 / 0.9e2;
  t1661 = t1629 + t1660;
  t1668 = t138 * t673 * t813 * t221;
  t1671 = t813 * t122;
  t1672 = t1671 * t228;
  t1675 = t18 * t673;
  t1686 = t138 * t368 * t347 * t473;
  t1688 = t1382 * t736 * sigma[0];
  t1691 = t819 * t347;
  t1693 = t138 * t1691 * t221;
  t1694 = t1388 * t825;
  t1699 = t1374 * t302;
  t1702 = t302 * t101;
  t1703 = t1702 * t1389;
  t1706 = t684 * t591;
  t1710 = t301 * t227 * t125;
  t1711 = t684 * t1710;
  t1714 = -t138 * t133 * t813 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1661 * t349 - t1668 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1672 - 0.7e1 / 0.96e2 * t7 * t1675 * t347 * t826 + t7 * t820 * t667 * t826 / 0.32e2 + t1686 * t1688 / 0.48e2 + t1693 * t1694 / 0.32e2 - t1079 * t829 / 0.8e1 - 0.3e1 / 0.8e1 * t595 * t1699 - t676 * t1703 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1706 - 0.3e1 / 0.8e1 * t595 * t1711;
  t1715 = my_piecewise3(t3, 0, t1714);
  tv3rhosigmatau0 = 0.2e1 * rho[0] * t1715 + 0.2e1 * t833;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  t1722 = t141 * t150;
  t1723 = t1722 * t33;
  t1726 = t148 * t376;
  t1727 = t1726 * t153;
  t1731 = t504 * t844 * t379;
  t1735 = 0.1e1 / t843 / t25;
  t1737 = t213 * t1735 * t927;
  t1741 = (-0.3e1 / 0.16e2 * t22 * t1723 + 0.17e2 / 0.512e3 * t147 * t1727 - 0.39e2 / 0.32768e5 * t374 * t1731 + 0.3e1 / 0.262144e6 * t922 * t1737) * t38;
  t1742 = t1741 * t43;
  t1756 = t956 * t858;
  t1759 = t858 * t184;
  t1762 = t334 * t645;
  t1765 = t1453 * t673;
  t1768 = t673 * t80;
  t1773 = 0.5e1 / 0.4e1 * t785 + 0.9e1 / 0.8e1 * t632 * t1592 - 0.3e1 / 0.4e1 * t632 * t1309 + 0.9e1 / 0.16e2 * t171 * t1756 - 0.81e2 / 0.32e2 * t966 * t1759 + 0.81e2 / 0.4e2 * t411 * t1762 - 0.25e2 * t1452 * t1765 + 0.45e2 / 0.4e1 * t1457 * t1768 * t1459 + 0.25e2 * t794;
  t1778 = t865 * t194;
  t1783 = t1337 * t21;
  t1790 = t1002 * t146;
  t1791 = t839 * t205;
  t1794 = t146 * t148;
  t1795 = t1794 * t376;
  t1800 = t835 * t205;
  t1803 = t196 * t150;
  t1808 = t1742 * t51 / 0.24e2 - t851 * t164 / 0.9e1 + 0.584e3 / 0.2025e4 * t337 * t648 + 0.292e3 / 0.2025e4 * t189 * t865 + 0.292e3 / 0.2025e4 * t76 * t1773 - 0.73e2 / 0.972e5 * t1773 * t93 - 0.73e2 / 0.1944e6 * t1778 * t205 + 0.73e2 / 0.3e3 * t1334 * t342 - 0.73e2 / 0.6e3 * t1783 * t659 - 0.73e2 / 0.15e3 * t653 * t662 + 0.1971e4 / 0.1e3 * t994 * t873 - 0.5913e4 / 0.2e3 * t1790 * t1791 - 0.1971e4 / 0.25e2 * t440 * t1795 - 0.73e2 / 0.2e3 * t435 * t876 + 0.73e2 / 0.4e3 * t658 * t1800 + 0.73e2 / 0.1e3 * t195 * t1803 - t102 * t1722 / 0.6e2;
  t1813 = t673 * t881;
  t1815 = t138 * t1813 * t221;
  t1818 = t881 * t122;
  t1819 = t1818 * t228;
  t1824 = t347 * t473;
  t1825 = t887 * t667;
  t1826 = t1824 * t1825;
  t1829 = t673 * t885;
  t1831 = t138 * t1829 * t1041;
  t1832 = t887 * t101;
  t1833 = t1832 * t1389;
  t1837 = t96 * t227 * t125;
  t1838 = t886 * t1837;
  t1842 = my_piecewise3(t3, 0, -t138 * t133 * t881 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * t1808 * t349 - t1815 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1819 + t1079 * t888 / 0.8e1 + 0.3e1 / 0.4e1 * t595 * t1826 + t1831 * t1833 / 0.6e1 + 0.3e1 / 0.8e1 * t595 * t1838);
  tv3rhotau20 = 0.2e1 * rho[0] * t1842 + 0.2e1 * t892;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  t1845 = params->c * t240;
  t1846 = t1410 * sigma[0];
  t1851 = t111 * t844;
  t1852 = t1851 * t927;
  t1856 = (-0.3e1 / 0.256e3 * t1845 * t1846 + 0.27e2 / 0.32768e5 * t239 * t699 - 0.3e1 / 0.262144e6 * t503 * t1852) * t38;
  t1857 = t1856 * t43;
  t1864 = t526 * t1442;
  t1866 = t111 * t107;
  t1867 = t176 * params->b;
  t1868 = t1866 * t1867;
  t1870 = t713 * t267;
  t1873 = t267 * params->b;
  t1874 = t411 * t1873;
  t1875 = t1874 * t718;
  t1877 = -0.27e2 / 0.128e3 * t1864 + 0.75e2 / 0.256e3 * t1868 - 0.81e2 / 0.32e2 * t966 * t1870 + 0.135e3 / 0.256e3 * t1875;
  t1888 = t728 * t284;
  t1891 = t284 * t733;
  t1896 = t1857 * t51 / 0.24e2 + t703 * t251 / 0.8e1 + 0.292e3 / 0.675e3 * t272 * t721 + 0.292e3 / 0.2025e4 * t76 * t1877 - 0.73e2 / 0.972e5 * t1877 * t93 - 0.73e2 / 0.648e5 * t1472 * t284 + 0.73e2 / 0.1296e6 * t1182 * t728 - 0.73e2 / 0.648e5 * t553 * t733 - 0.73e2 / 0.2592e6 * t1002 * t1888 + 0.73e2 / 0.1296e6 * t440 * t1891 + t105 * t1866 / 0.96e2;
  t1903 = t1045 * t111;
  t1906 = -t1896 * t122 * t96 + t1514 * t270 / 0.4e1 - t1212 * t718 / 0.16e2 + t1043 * t1903 / 0.24e2;
  t1907 = t1906 * t125;
  t1911 = t1536 * t302;
  t1914 = t758 * t301;
  t1915 = t1914 * t125;
  t1920 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * t1907 + 0.9e1 / 0.8e1 * t595 * t1911 + 0.3e1 / 0.8e1 * t138 * t139 * t1915);
  tv3sigma30 = 0.2e1 * rho[0] * t1920;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  t1922 = t309 * t33;
  t1930 = t111 * t1279 * t927;
  t1934 = (-t692 * t1922 / 0.16e2 + 0.11e2 / 0.512e3 * t22 * t317 - 0.33e2 / 0.32768e5 * t147 * t771 + 0.3e1 / 0.262144e6 * t374 * t1930) * t38;
  t1935 = t1934 * t43;
  t1946 = t504 * t107;
  t1947 = t1946 * t1867;
  t1949 = t956 * t787;
  t1950 = t526 * t1949;
  t1952 = t334 * t713;
  t1955 = t82 * t267;
  t1957 = t1457 * t1612 * t1955;
  t1959 = t334 * params->b;
  t1960 = t411 * t1959;
  t1961 = t1960 * t718;
  t1963 = 0.9e1 / 0.16e2 * t632 * t1442 - 0.75e2 / 0.32e2 * t1947 - 0.9e1 / 0.64e2 * t1950 - 0.81e2 / 0.32e2 * t966 * t1952 - 0.45e2 / 0.16e2 * t1957 + 0.45e2 / 0.256e3 * t1961;
  t1980 = t310 * t728;
  t1985 = t310 * t733;
  t1992 = t1935 * t51 / 0.24e2 + t775 * t251 / 0.12e2 + 0.292e3 / 0.2025e4 * t721 * t337 + 0.584e3 / 0.2025e4 * t272 * t796 + 0.292e3 / 0.2025e4 * t76 * t1963 - 0.73e2 / 0.972e5 * t1963 * t93 - 0.73e2 / 0.972e5 * t1622 * t284 + 0.73e2 / 0.3888e6 * t1337 * t728 - 0.73e2 / 0.1944e6 * t653 * t733 + 0.73e2 / 0.6e3 * t1472 * t342 - 0.73e2 / 0.6e3 * t1634 * t805 + 0.73e2 / 0.15e3 * t553 * t808 + 0.73e2 / 0.8e3 * t1349 * t1980 - 0.73e2 / 0.3e3 * t1652 * t805 - 0.73e2 / 0.12e4 * t658 * t1985 + 0.73e2 / 0.3e3 * t195 * t310 - t740 * t309 / 0.18e3;
  t2001 = t1671 * t302;
  t2004 = t18 * t148;
  t2009 = t83 * t45;
  t2010 = t473 * t125 * params->e * t2009;
  t2013 = t1702 * t825;
  t2016 = t684 * t755;
  t2019 = t684 * t759;
  t2023 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t1992 * t349 + t7 * t820 * t813 * t826 / 0.16e2 - 0.3e1 / 0.4e1 * t595 * t2001 - t7 * t2004 * t347 * t2010 / 0.128e3 + t1693 * t2013 / 0.16e2 - 0.3e1 / 0.8e1 * t595 * t2016 - 0.3e1 / 0.8e1 * t595 * t2019);
  tv3sigma2tau0 = 0.2e1 * rho[0] * t2023;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  t2032 = t111 * t1735 * t927;
  t2036 = (0.3e1 / 0.16e2 * t236 * t836 - 0.17e2 / 0.512e3 * t239 * t840 + 0.39e2 / 0.32768e5 * t503 * t846 - 0.3e1 / 0.262144e6 * t1167 * t2032) * t38;
  t2037 = t2036 * t43;
  t2048 = t368 * t107;
  t2049 = t2048 * t1867;
  t2051 = t526 * t1756;
  t2053 = t858 * t267;
  t2056 = t1960 * t793;
  t2061 = 0.9e1 / 0.8e1 * t632 * t1949 + 0.75e2 / 0.4e1 * t2049 - 0.9e1 / 0.128e3 * t2051 - 0.81e2 / 0.32e2 * t966 * t2053 - 0.45e2 / 0.16e2 * t2056 + 0.45e2 / 0.4e1 * t1457 * t1768 * t1955;
  t2076 = t839 * t284;
  t2079 = t108 * t240;
  t2080 = t2079 * t376;
  t2085 = t835 * t284;
  t2088 = t277 * t150;
  t2093 = t2037 * t51 / 0.24e2 + t850 * t251 / 0.24e2 + 0.584e3 / 0.2025e4 * t337 * t796 + 0.292e3 / 0.2025e4 * t272 * t865 + 0.292e3 / 0.2025e4 * t76 * t2061 - 0.73e2 / 0.972e5 * t2061 * t93 - 0.73e2 / 0.1944e6 * t1778 * t284 + 0.73e2 / 0.3e3 * t1622 * t342 - 0.73e2 / 0.6e3 * t1783 * t805 + 0.73e2 / 0.15e3 * t653 * t808 + 0.1971e4 / 0.1e3 * t1182 * t873 - 0.5913e4 / 0.2e3 * t1790 * t2076 + 0.1971e4 / 0.25e2 * t440 * t2080 - 0.73e2 / 0.2e3 * t553 * t876 + 0.73e2 / 0.4e3 * t658 * t2085 - 0.73e2 / 0.1e3 * t195 * t2088 + t289 * t835 / 0.6e2;
  t2102 = t1818 * t302;
  t2105 = t887 * t813;
  t2106 = t1824 * t2105;
  t2111 = t138 * t819 * t885 * t1041;
  t2112 = t1832 * t825;
  t2116 = t96 * t301 * t125;
  t2117 = t886 * t2116;
  t2121 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t2093 * t349 + t7 * t820 * t881 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t2102 + 0.3e1 / 0.4e1 * t595 * t2106 - t2111 * t2112 / 0.16e2 + 0.3e1 / 0.8e1 * t595 * t2117);
  tv3sigmatau20 = 0.2e1 * rho[0] * t2121;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  t2123 = t24 * t315;
  t2124 = t2123 * t33;
  t2127 = t240 * t617;
  t2128 = t2127 * t153;
  t2131 = t368 * t1279;
  t2132 = t2131 * t379;
  t2136 = 0.1e1 / t843 / t308;
  t2138 = t111 * t2136 * t927;
  t2142 = (-0.3e1 / 0.8e1 * t22 * t2124 + 0.3e1 / 0.64e2 * t147 * t2128 - 0.45e2 / 0.32768e5 * t374 * t2132 + 0.3e1 / 0.262144e6 * t922 * t2138) * t38;
  t2143 = t2142 * t43;
  t2150 = t148 * t107;
  t2153 = t858 * t334;
  t2158 = 0.27e2 / 0.16e2 * t632 * t1756 - 0.15e3 * t2150 * t1867 - 0.81e2 / 0.32e2 * t966 * t2153 + 0.135e3 / 0.4e1 * t1960 * t862;
  t2169 = t373 * t368;
  t2170 = t2169 * t1279;
  t2173 = t872 * t617;
  t2176 = t28 * t315;
  t2181 = t2143 * t51 / 0.24e2 + 0.292e3 / 0.675e3 * t337 * t865 + 0.292e3 / 0.2025e4 * t76 * t2158 - 0.73e2 / 0.972e5 * t2158 * t93 + 0.73e2 / 0.2e3 * t1778 * t342 + 0.5913e4 / 0.1e3 * t1337 * t873 - 0.219e3 / 0.2e3 * t653 * t876 + 0.478953e6 / 0.5e2 * t1002 * t2170 - 0.17739e5 / 0.1e3 * t440 * t2173 + 0.73e2 / 0.5e2 * t195 * t2176 - t102 * t2123 / 0.3e2;
  t2186 = t881 * t473;
  t2188 = t347 * t96 * t125;
  t2189 = t2186 * t2188;
  t2192 = t885 * t347;
  t2194 = 0.1e1 / t472 / t121;
  t2195 = t2192 * t2194;
  t2196 = params->kappa * params->kappa;
  t2197 = 0.1e1 / t2196;
  t2198 = t2197 * t125;
  t2199 = t2195 * t2198;
  t2203 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t2181 * t349 + 0.9e1 / 0.8e1 * t595 * t2189 - 0.3e1 / 0.8e1 * t595 * t2199);
  tv3tau30 = 0.2e1 * rho[0] * t2203;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  t2210 = t50 * params->kappa;
  t2230 = t84 / t19 / t212;
  t2233 = t368 * t26;
  t2245 = t110 * t85;
  t2246 = 0.1e1 / t2245;
  t2252 = params->c * t921 * t21;
  t2253 = t110 * t199;
  t2257 = 0.1e1 / t378 / t32;
  t2266 = t430 * t430;
  t2273 = 0.1e1 / t48 / t199;
  t2274 = t47 * t2273;
  t2276 = 0.616e4 / 0.81e2 * t54 * t941 - 0.2618e4 / 0.81e2 * t2274;
  t2286 = t43 * t965;
  t2287 = t2286 * t967;
  t2294 = t404 * t981;
  t2297 = t408 * t408;
  t2300 = t63 / t70 / t2297;
  t2301 = t412 * t412;
  t2307 = t425 * t425;
  t2318 = t400 * t400;
  t2328 = t65 * t2274;
  t2330 = 0.3e1 / 0.4e1 * t2276 * t38 * t172 - 0.3e1 / 0.2e1 * t951 * t405 + 0.27e2 / 0.8e1 * t401 * t957 - 0.9e1 / 0.4e1 * t401 * t960 - 0.45e2 / 0.8e1 * t171 * t2287 + 0.27e2 / 0.4e1 * t1098 * t410 * t184 * t425 - 0.3e1 / 0.2e1 * t171 * t2294 + 0.567e3 / 0.64e2 * t2300 * t2301 - 0.243e3 / 0.16e2 * t966 * t412 * t425 + 0.243e3 / 0.8e2 * t411 * t2307 + 0.81e2 / 0.2e2 * t411 * t184 * t981 - 0.27e2 / 0.4e2 * t177 * (0.5e1 * params->b * t2276 * t66 + 0.2e3 / 0.9e1 * t973 * t181 + 0.5e2 / 0.3e1 * params->b * t2318 * t83 + 0.25e2 / 0.9e1 * t64 * t83 * t2276) + 0.5236e4 / 0.729e3 * t2328;
  t2335 = t986 * t194;
  t2345 = t83 * t2230;
  t2352 = 0.5225e6 / 0.4782969e7 * t98 * t2230 + (0.15e2 / 0.8e1 * t22 * t2233 * t33 - 0.45e2 / 0.128e3 * t147 * t111 * t150 * t153 + 0.549e3 / 0.32768e5 * t374 * t461 * t376 * t379 - 0.39e2 / 0.131072e6 * t922 * t2246 * t844 * t927 + 0.15e2 / 0.8388608e7 * t2252 / t2253 * t1735 * t2257) * t38 * t43 * t51 / 0.24e2 + 0.292e3 / 0.675e3 * t2266 + 0.1168e4 / 0.2025e4 * t189 * t986 + 0.292e3 / 0.2025e4 * t76 * t2330 - 0.73e2 / 0.972e5 * t2330 * t93 - 0.73e2 / 0.486e5 * t2335 * t205 - 0.73e2 / 0.324e5 * t991 * t453 - 0.73e2 / 0.486e5 * t435 * t1017 - 0.73e2 / 0.1944e6 * t195 * (0.1944e5 * t21 * t368 * t26 + 0.1672e8 / 0.81e2 * t2345) - 0.4e1 / 0.9e1 * t933 * t164;
  t2359 = t430 * t439;
  t2362 = t189 * t1001;
  t2370 = t76 / t93 / t999 / t92;
  t2371 = t441 * t441;
  t2377 = t453 * t453;
  t2388 = 0.22e2 / 0.9e1 * t385 * t392 - 0.616e3 / 0.81e2 * t159 * t942 + 0.2618e4 / 0.243e3 * t44 * t2274 + 0.73e2 / 0.648e5 * t2359 * t441 - 0.73e2 / 0.648e5 * t2362 * t1003 + 0.73e2 / 0.324e5 * t994 * t1006 + 0.73e2 / 0.10368e6 * t2370 * t2371 - 0.73e2 / 0.432e5 * t1002 * t441 * t453 + 0.73e2 / 0.1296e6 * t440 * t2377 + 0.73e2 / 0.972e5 * t440 * t205 * t1017 + t102 * t2233 / 0.6e1 + 0.55e2 / 0.4e1 * t105 * t109 * t2246;
  t2393 = t1027 * t221 * t223;
  t2397 = t465 * t473 * t475;
  t2403 = t217 * t1041 * t96;
  t2410 = t115 * t2194;
  t2411 = params->e * params->e;
  t2412 = t96 * t2411;
  t2414 = t2410 * t2412 * t107;
  t2429 = -(t2352 + t2388) * t122 * t96 - 0.8e1 / 0.9e1 * t2393 * t187 - 0.8e1 / 0.9e1 * t2397 * t451 + 0.44e2 / 0.9e1 * t1031 * t428 - 0.256e3 / 0.81e2 * t2403 * t1047 + 0.176e3 / 0.27e2 * t1035 * t1015 - 0.1232e4 / 0.81e2 * t469 * t984 - 0.32e3 / 0.729e3 * t2414 * t146 / t48 / t2253 * t825 + 0.1408e4 / 0.81e2 * t1043 * t1045 * t108 * t2246 - 0.3916e4 / 0.243e3 * t476 * t2345 + 0.5236e4 / 0.243e3 * t224 * t2328;
  t2438 = t481 * t481;
  t2446 = t486 * t486;
  t2451 = 0.1e2 / 0.27e2 * t7 * t18 * t163 * t128 + 0.5e1 / 0.9e1 * t138 * t2210 * t228 - t138 * t899 * t482 / 0.2e1 - t138 * t899 * t487 / 0.2e1 + t138 * t360 * t1055 / 0.2e1 + 0.3e1 / 0.2e1 * t1079 * t1060 + t138 * t360 * t1064 / 0.2e1 + 0.3e1 / 0.8e1 * t138 * t139 * t2429 * t125 + 0.3e1 / 0.2e1 * t595 * params->kappa * t1054 * t228 + 0.9e1 / 0.8e1 * t138 * t139 * t2438 * t125 + 0.9e1 / 0.4e1 * t595 * t1059 * t487 + 0.3e1 / 0.8e1 * t138 * t139 * t2446 * t125;
  t2452 = my_piecewise3(t3, 0, t2451);
  tv4rho40 = 0.2e1 * rho[0] * t2452 + 0.8e1 * t1069;

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t2471 = t46 * t941;
  t2472 = t2471 * t65;
  t2478 = t404 * t1125;
  t2487 = t401 * t43;
  t2490 = -0.243e3 / 0.32e2 * t966 * t543 * t412 + 0.243e3 / 0.8e2 * t411 * t1125 * t184 + 0.243e3 / 0.8e2 * t411 * t543 * t425 + 0.81e2 / 0.8e2 * t411 * t267 * t981 - 0.308e3 / 0.243e3 * t2472 - 0.3e1 / 0.8e1 * t951 * t529 - 0.9e1 / 0.8e1 * t401 * t1103 - 0.9e1 / 0.8e1 * t171 * t2478 + 0.567e3 / 0.64e2 * t2300 * t267 * t967 - 0.243e3 / 0.32e2 * t966 * t532 * t425 + 0.27e2 / 0.16e2 * t2487 * t1100;
  t2500 = t1086 * t38;
  t2526 = t956 * t970;
  t2533 = 0.27e2 / 0.8e1 * t1098 * t410 * t543 * t184 + 0.27e2 / 0.16e2 * t1098 * t1099 * t425 + 0.77e2 / 0.18e2 * t2471 * t255 + 0.11e2 / 0.8e1 * t2500 * t405 - 0.3e1 / 0.8e1 * t1089 * t960 + 0.3e1 / 0.64e2 * t526 * t2294 - 0.27e2 / 0.4e2 * t177 * (0.77e3 / 0.27e2 * t258 * t941 * t66 - 0.55e3 / 0.27e2 * t1115 * t181 + 0.5e2 / 0.9e1 * t535 * t422 - 0.25e2 / 0.36e2 * t259 * t978 + 0.385e4 / 0.243e3 * t262 * t263 * t941) + 0.9e1 / 0.16e2 * t1089 * t957 + 0.45e2 / 0.256e3 * t526 * t2287 - 0.27e2 / 0.128e3 * t526 * t2526 - 0.135e3 / 0.32e2 * t1098 * t965 * t267 * t412;
  t2534 = t2490 + t2533;
  t2544 = t280 * t1013;
  t2556 = params->c * t921 * sigma[0];
  t2557 = t110 * t86;
  t2558 = 0.1e1 / t2557;
  t2570 = t548 * t439;
  t2578 = t83 * t2544;
  t2601 = -0.73e2 / 0.972e5 * t2534 * t93 - t384 * t518 / 0.3e1 - 0.73e2 / 0.864e5 * t1002 * t1190 * t205 - t1174 * t164 / 0.3e1 - 0.418e5 / 0.1594323e7 * t98 * t2544 + (-0.3e1 / 0.4e1 * t236 * t910 + 0.27e2 / 0.128e3 * t239 * t914 - 0.207e3 / 0.16384e5 * t503 * t918 + 0.69e2 / 0.262144e6 * t1167 * t928 - 0.15e2 / 0.8388608e7 * t2556 * t2558 * t1735 * t2257) * t38 * t43 * t51 / 0.24e2 + 0.292e3 / 0.2025e4 * t76 * t2534 + 0.73e2 / 0.1296e6 * t2570 * t441 - 0.73e2 / 0.648e5 * t435 * t1150 - 0.73e2 / 0.1944e6 * t195 * (-0.7776e4 * sigma[0] * t148 * t26 - 0.13376e7 / 0.27e2 * t2578) - 0.73e2 / 0.1944e6 * t2335 * t284 - 0.73e2 / 0.648e5 * t991 * t567 - 0.73e2 / 0.1944e6 * t553 * t1017 + 0.73e2 / 0.1296e6 * t994 * t1190 + 0.73e2 / 0.1296e6 * t440 * t567 * t453 + 0.73e2 / 0.3888e6 * t440 * t284 * t1017 - t289 * t909 / 0.15e2 + 0.73e2 / 0.1296e6 * t2359 * t558;
  t2615 = t272 * t1001;
  t2640 = t1130 * t194;
  t2645 = 0.73e2 / 0.648e5 * t994 * t1187 + 0.73e2 / 0.1296e6 * t440 * t1150 * t205 + 0.292e3 / 0.675e3 * t189 * t1130 + 0.73e2 / 0.1296e6 * t1182 * t1006 - 0.154e3 / 0.81e2 * t247 * t942 + 0.11e2 / 0.9e1 * t511 * t392 - 0.73e2 / 0.2592e6 * t2615 * t1003 - 0.73e2 / 0.864e5 * t2362 * t1195 - 0.73e2 / 0.864e5 * t1002 * t567 * t441 + 0.73e2 / 0.10368e6 * t2370 * t284 * t1003 - 0.15e2 / 0.4e1 * t105 * t292 * t924 + t932 * t251 / 0.24e2 + 0.11e2 / 0.9e1 * t158 * t1179 - 0.154e3 / 0.81e2 * t39 * t250 * t941 + 0.292e3 / 0.675e3 * t430 * t548 + 0.292e3 / 0.2025e4 * t986 * t272 - 0.73e2 / 0.648e5 * t2640 * t205 - 0.73e2 / 0.648e5 * t1135 * t453;
  t2650 = t296 * t1041 * t96;
  t2676 = t1204 * t221 * t223;
  t2680 = t577 * t473 * t475;
  t2693 = -(t2601 + t2645) * t122 * t96 - 0.64e2 / 0.81e2 * t2650 * t1047 + 0.8e1 / 0.9e1 * t2403 * t1224 + 0.4e2 / 0.243e3 * t2414 / t48 / t2557 * t108 * t825 + 0.341e3 / 0.81e2 * t476 * t2578 + 0.44e2 / 0.27e2 * t1212 * t1015 - 0.308e3 / 0.81e2 * t581 * t984 - 0.3e1 / 0.2e1 * t1035 * t1148 + 0.22e2 / 0.9e1 * t1208 * t428 + 0.22e2 / 0.9e1 * t469 * t1128 - 0.308e3 / 0.81e2 * t224 * t2472 - 0.2e1 / 0.3e1 * t2676 * t187 - 0.4e1 / 0.9e1 * t2680 * t451 - 0.2e1 / 0.3e1 * t1031 * t546 + t2397 * t565 / 0.6e1 + t2393 * t270 / 0.12e2 - 0.152e3 / 0.27e2 * t1043 * t1045 * t924 * t21;
  t2708 = t481 * t227 * t125;
  t2731 = t7 * t356;
  t2734 = 0.3e1 / 0.8e1 * t595 * t596 * t1055 + 0.3e1 / 0.8e1 * t138 * t139 * t2693 * t125 - t138 * t899 * t591 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t360 * t1232 + 0.9e1 / 0.8e1 * t595 * t1236 * t487 + 0.9e1 / 0.8e1 * t595 * t596 * t2708 + 0.3e1 / 0.8e1 * t595 * t596 * t1064 + 0.3e1 / 0.8e1 * t1079 * t1243 + 0.9e1 / 0.8e1 * t595 * params->kappa * t1231 * t228 + 0.9e1 / 0.8e1 * t595 * t1236 * t482 + 0.3e1 / 0.4e1 * t1079 * t1237 + 0.3e1 / 0.8e1 * t1079 * t1240 + 0.5e1 / 0.36e2 * t138 * t2210 * t302 - t2731 * t597 / 0.4e1;
  t2735 = my_piecewise3(t3, 0, t2734);
  tv4rho3sigma0 = 0.2e1 * rho[0] * t2735 + 0.6e1 * t1247;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  t2739 = t487 * t101;
  t2743 = t228 * params->e;
  t2744 = t83 * t84;
  t2748 = t482 * t101;
  t2789 = -t676 * t2739 * t1389 / 0.4e1 - t1380 * t2743 * t2744 / 0.6e1 - t676 * t2748 * t1389 / 0.4e1 - t1371 * t1390 / 0.2e1 + 0.3e1 / 0.4e1 * t1261 * t1390 + t138 * t56 * t667 * t349 / 0.4e1 + 0.5e1 / 0.9e1 * t138 * t111 * t347 * t473 * t1385 - t138 * t673 * t1364 * t221 * t681 / 0.4e1 - t138 * t504 * t667 * t473 * t1385 / 0.6e1 - 0.115e3 / 0.108e3 * t138 * t88 * t347 * t221 * t681 + 0.3e1 / 0.4e1 * t138 * t791 * t667 * t221 * t681 - 0.5e1 / 0.36e2 * t138 * t50 * t347 * t349;
  t2794 = t404 * t1326;
  t2807 = t410 * t645;
  t2828 = t965 * t334;
  t2848 = -0.45e2 / 0.32e2 * t632 * t2287 + 0.27e2 / 0.16e2 * t632 * t2526 - 0.135e3 / 0.32e2 * t1098 * t2828 * t412 - 0.243e3 / 0.32e2 * t966 * t645 * t412 + 0.243e3 / 0.8e2 * t411 * t1326 * t184 + 0.243e3 / 0.8e2 * t411 * t645 * t425 + 0.81e2 / 0.8e2 * t411 * t334 * t981 - 0.45e2 / 0.16e2 * t1092 - 0.11e3 / 0.9e1 * t1087 - 0.5e1 * t1090 + 0.15e2 / 0.8e1 * t1094;
  t2849 = -0.3e1 / 0.8e1 * t951 * t635 - 0.9e1 / 0.8e1 * t401 * t1309 - 0.9e1 / 0.8e1 * t171 * t2794 + 0.567e3 / 0.64e2 * t2300 * t334 * t967 - 0.243e3 / 0.32e2 * t966 * t638 * t425 - 0.3e1 / 0.8e1 * t632 * t2294 + 0.27e2 / 0.16e2 * t2487 * t1306 + 0.27e2 / 0.8e1 * t1098 * t2807 * t184 + 0.27e2 / 0.16e2 * t1098 * t1305 * t425 - 0.27e2 / 0.4e2 * t177 * (-0.22e4 / 0.27e2 * t1116 + 0.2e4 / 0.27e2 * t1118 - 0.25e3 / 0.9e1 * t1120 + 0.5e2 / 0.9e1 * t328 * t978 - 0.11e5 / 0.243e3 * t1123) + t2848;
  t2871 = t2362 * t21;
  t2876 = t2370 * t21;
  t2886 = 0.292e3 / 0.2025e4 * t76 * t2849 + 0.292e3 / 0.675e3 * t189 * t1329 + 0.292e3 / 0.675e3 * t430 * t648 - 0.73e2 / 0.1e3 * t991 * t662 + 0.219e3 / 0.1e3 * t435 * t1359 + 0.73e2 / 0.6e3 * t2335 * t342 - 0.73e2 / 0.25e2 * t195 * t1009 * t309 + 0.292e3 / 0.2025e4 * t986 * t337 + 0.11e2 / 0.9e1 * t624 * t392 - 0.154e3 / 0.81e2 * t322 * t942 + 0.219e3 / 0.8e3 * t2871 * t1350 + 0.73e2 / 0.1e3 * t1344 * t1353 - 0.73e2 / 0.32e3 * t2876 * t310 * t1003 - 0.219e3 / 0.4e3 * t1349 * t608 * t441 - 0.219e3 / 0.2e3 * t658 * t1266 * t205;
  t2894 = t148 * t309;
  t2897 = t1329 * t194;
  t2904 = t2359 * t21;
  t2941 = t648 * t439;
  t2944 = t337 * t1001;
  t2947 = -t1286 * t164 / 0.3e1 + 0.219e3 / 0.8e3 * t1349 * t310 * t1006 + 0.73e2 / 0.1296e6 * t1337 * t1006 + t102 * t2894 / 0.15e2 - 0.73e2 / 0.648e5 * t2897 * t205 - 0.73e2 / 0.648e5 * t1334 * t453 - 0.73e2 / 0.972e5 * t2849 * t93 - 0.73e2 / 0.4e3 * t2904 * t659 - 0.73e2 / 0.4e3 * t1344 * t1356 + 0.73e2 / 0.2e3 * t658 * t608 * t453 - 0.73e2 / 0.12e4 * t658 * t310 * t1017 + (0.3e1 / 0.4e1 * t22 * t2894 * t33 - 0.27e2 / 0.128e3 * t147 * t504 * t315 * t153 + 0.207e3 / 0.16384e5 * t374 * t213 * t617 * t379 - 0.69e2 / 0.262144e6 * t922 * t924 * t1279 * t927 + 0.15e2 / 0.8388608e7 * t2252 * t2558 * t2136 * t2257) * t38 * t43 * t51 / 0.24e2 - 0.73e2 / 0.1944e6 * t653 * t1017 + 0.73e2 / 0.1296e6 * t2941 * t441 - 0.73e2 / 0.2592e6 * t2944 * t1003;
  t2959 = t4 / t5 / t106;
  t2961 = 0.1e1 / t48 / t460;
  t2964 = t347 * t1041;
  t2965 = t125 * t1044;
  t2973 = t1364 * t122;
  t2997 = -0.3e1 / 0.8e1 * t138 * t19 * (t2886 + t2947) * t349 - 0.3e1 / 0.8e1 * t138 * t133 * t1364 * t349 - 0.8e1 / 0.27e2 * t2959 * t18 * t2961 * t2964 * t2965 * t108 - 0.9e1 / 0.8e1 * t595 * t684 * t2708 - 0.9e1 / 0.8e1 * t595 * t2973 * t228 - 0.9e1 / 0.8e1 * t595 * t1374 * t482 - 0.3e1 / 0.8e1 * t595 * t684 * t1055 + t2731 * t685 / 0.4e1 - 0.3e1 / 0.4e1 * t1079 * t1375 - 0.3e1 / 0.8e1 * t1079 * t1393 - 0.9e1 / 0.8e1 * t595 * t1374 * t487 - 0.3e1 / 0.8e1 * t595 * t684 * t1064 - 0.3e1 / 0.8e1 * t1079 * t1396;
  t2999 = my_piecewise3(t3, 0, t2789 + t2997);
  tv4rho3tau0 = 0.2e1 * rho[0] * t2999 + 0.6e1 * t1400;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t3017 = t83 * t45 * t449;
  t3031 = t721 * t439;
  t3046 = t548 * t548;
  t3048 = t1467 * t194;
  t3062 = -0.73e2 / 0.1944e6 * t991 * t733 - 0.73e2 / 0.972e5 * t435 * t1497 - 0.73e2 / 0.1944e6 * t195 * (0.1944e4 * t364 + 0.608e5 / 0.9e1 * t3017) + t101 * t240 * t26 / 0.6e2 + 0.73e2 / 0.3888e6 * t2359 * t728 - 0.73e2 / 0.486e5 * t1135 * t567 - 0.73e2 / 0.972e5 * t553 * t1150 + 0.73e2 / 0.3888e6 * t3031 * t441 - 0.73e2 / 0.2592e6 * t1002 * t733 * t441 + 0.73e2 / 0.972e5 * t2570 * t558 - 0.73e2 / 0.1296e6 * t2615 * t1195 + 0.73e2 / 0.10368e6 * t2370 * t728 * t441 - 0.73e2 / 0.972e5 * t2640 * t284 + 0.584e3 / 0.2025e4 * t3046 - 0.73e2 / 0.972e5 * t3048 * t205 - 0.73e2 / 0.1944e6 * t1472 * t453 + 0.11e2 / 0.27e2 * t704 * t392 - 0.2e1 / 0.9e1 * t1422 * t164 + 0.73e2 / 0.1944e6 * t440 * t284 * t1150 + 0.73e2 / 0.1944e6 * t994 * t1492;
  t3082 = params->c * t368;
  t3086 = t376 * t379;
  t3128 = t400 * t107 * t176;
  t3134 = t543 * t543;
  t3148 = -t1089 * t1103 / 0.2e1 + 0.3e1 / 0.32e2 * t526 * t2478 - 0.45e2 / 0.16e2 * t1098 * t965 * t713 * t184 + 0.9e1 / 0.4e1 * t1098 * t1099 * t543 - 0.25e2 / 0.64e2 * t3128 * t1454 - 0.81e2 / 0.32e2 * t966 * t713 * t425 + 0.81e2 / 0.4e2 * t411 * t3134 + 0.81e2 / 0.4e2 * t411 * t267 * t1125 + 0.9e1 / 0.16e2 * t401 * t1442 + 0.567e3 / 0.64e2 * t2300 * t713 * t412 - 0.81e2 / 0.8e1 * t966 * t532 * t543;
  t3153 = t956 * t1109;
  t3156 = t956 * t1112;
  t3159 = t1451 * t410;
  t3167 = t2286 * t1106;
  t3170 = t82 * t425;
  t3176 = t966 * t1453;
  t3177 = t82 * t412;
  t3185 = 0.11e2 / 0.12e2 * t2500 * t529 + 0.3e1 / 0.4e1 * t1089 * t1437 - 0.9e1 / 0.32e2 * t526 * t3153 - 0.9e1 / 0.64e2 * t526 * t3156 + 0.75e2 / 0.64e2 * t3159 * t1453 * t88 * t184 + 0.25e2 / 0.6e1 * t1452 * t1453 * t201 + 0.45e2 / 0.128e3 * t526 * t3167 + 0.45e2 / 0.256e3 * t1457 * t1458 * t3170 - 0.95e2 / 0.24e2 * t716 * t3017 - 0.225e3 / 0.512e3 * t3176 * t1458 * t3177 - 0.15e2 / 0.8e1 * t1457 * t201 * t80 * t1459;
  t3186 = t3148 + t3185;
  t3193 = t567 * t567;
  t3200 = 0.73e2 / 0.1944e6 * t440 * t1497 * t205 + 0.73e2 / 0.3888e6 * t440 * t733 * t453 - 0.73e2 / 0.1296e6 * t2362 * t1484 + 0.73e2 / 0.972e5 * t994 * t1487 - 0.73e2 / 0.2592e6 * t1002 * t728 * t453 + 0.73e2 / 0.972e5 * t1182 * t1187 + 0.73e2 / 0.1944e6 * t1182 * t1190 + (0.3e1 / 0.16e2 * t1845 * t693 - 0.57e2 / 0.512e3 * t3082 * t1411 + 0.297e3 / 0.32768e5 * params->c * t111 * t3086 * t146 - 0.15e2 / 0.65536e5 * t374 * t1169 + 0.15e2 / 0.8388608e7 * t922 * t2246 * t1735 * t2257) * t38 * t43 * t51 / 0.24e2 - 0.73e2 / 0.648e5 * t1002 * t558 * t567 + 0.19e4 / 0.531441e6 * t97 * t736 * t449 + 0.3e1 / 0.4e1 * t105 * t743 * t461 + t1173 * t251 / 0.12e2 - 0.4e1 / 0.9e1 * t510 * t518 + 0.22e2 / 0.27e2 * t246 * t1179 - 0.73e2 / 0.972e5 * t3186 * t93 + 0.584e3 / 0.2025e4 * t272 * t1130 + 0.292e3 / 0.2025e4 * t430 * t721 + 0.73e2 / 0.1944e6 * t440 * t3193 + 0.584e3 / 0.2025e4 * t189 * t1467 + 0.292e3 / 0.2025e4 * t76 * t3186;
  t3205 = t1510 * t221 * t223;
  t3209 = t747 * t473 * t475;
  t3243 = -(t3062 + t3200) * t122 * t96 - 0.4e1 / 0.9e1 * t3205 * t187 - 0.4e1 / 0.27e2 * t3209 * t451 + 0.22e2 / 0.27e2 * t1514 * t428 + t2676 * t270 / 0.6e1 + 0.2e1 / 0.9e1 * t2680 * t565 - 0.8e1 / 0.9e1 * t1208 * t546 + 0.16e2 / 0.27e2 * t2650 * t1224 - t1212 * t1148 + 0.44e2 / 0.27e2 * t581 * t1128 - t2397 * t718 / 0.48e2 - 0.2e1 / 0.9e1 * t2403 * t1526 + 0.2e1 / 0.9e1 * t1035 * t1464 - 0.5e1 / 0.81e2 * t2414 / t48 / t2245 * t21 * t825 + 0.43e2 / 0.27e2 * t1043 * t1045 * t461 * sigma[0] - 0.19e2 / 0.27e2 * t476 * t3017;
  t3248 = params->kappa * t1531;
  t3265 = t590 * t590;
  t3270 = t228 * t590;
  t3283 = -t138 * t899 * t755 / 0.12e2 + t138 * t360 * t1532 / 0.4e1 + t1079 * t1537 / 0.4e1 + 0.3e1 / 0.8e1 * t138 * t139 * t3243 * t125 + 0.3e1 / 0.4e1 * t595 * t3248 * t228 + 0.3e1 / 0.8e1 * t595 * t1536 * t482 + 0.3e1 / 0.8e1 * t595 * t1536 * t487 - t138 * t899 * t759 / 0.12e2 + t1079 * t1543 / 0.2e1 + t1079 * t1547 / 0.4e1 + 0.3e1 / 0.4e1 * t138 * t139 * t3265 * t125 + 0.3e1 / 0.2e1 * t595 * t596 * t3270 + 0.3e1 / 0.4e1 * t595 * t596 * t1232 + 0.3e1 / 0.8e1 * t595 * t1546 * t482 + 0.3e1 / 0.8e1 * t595 * t1546 * t487;
  t3284 = my_piecewise3(t3, 0, t3283);
  tv4rho2sigma20 = 0.2e1 * rho[0] * t3284 + 0.4e1 * t1551;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  t3294 = t591 * t101;
  t3300 = t302 * params->e;
  t3304 = t83 * t280;
  t3356 = t1285 * t251 / 0.24e2 - 0.73e2 / 0.32e3 * t2876 * t310 * t1195 - 0.73e2 / 0.2e3 * t1349 * t608 * t558 + 0.73e2 / 0.4e3 * t2871 * t1641 + 0.73e2 / 0.6e3 * t2640 * t342 + 0.73e2 / 0.4e3 * t1349 * t310 * t1187 + 0.73e2 / 0.8e3 * t1349 * t310 * t1190 - 0.73e2 / 0.75e2 * t435 * t1655 + 0.73e2 / 0.5e2 * t195 * t1144 * t309 - 0.2e1 / 0.9e1 * t623 * t518 + 0.11e2 / 0.27e2 * t321 * t1179 - 0.2e1 / 0.9e1 * t1570 * t164;
  t3373 = t1617 * t194;
  t3376 = t2570 * t21;
  t3398 = 0.11e2 / 0.27e2 * t776 * t392 - 0.73e2 / 0.972e5 * t1334 * t567 - 0.73e2 / 0.1944e6 * t653 * t1150 - 0.73e2 / 0.1944e6 * t2897 * t284 + 0.73e2 / 0.3e3 * t991 * t808 - 0.73e2 / 0.15e3 * t1135 * t662 + 0.73e2 / 0.1e3 * t553 * t1359 - 0.73e2 / 0.1944e6 * t1622 * t453 - 0.73e2 / 0.972e5 * t3373 * t205 - 0.73e2 / 0.6e3 * t3376 * t659 + (-0.3e1 / 0.8e1 * t236 * t1267 + 0.37e2 / 0.256e3 * t239 * t1271 - 0.21e2 / 0.2048e4 * t503 * t1275 + 0.63e2 / 0.262144e6 * t1167 * t1281 - 0.15e2 / 0.8388608e7 * t2556 * t2246 * t2136 * t2257) * t38 * t43 * t51 / 0.24e2 - 0.73e2 / 0.6e3 * t1652 * t1356;
  t3410 = t994 * sigma[0];
  t3417 = t1002 * sigma[0];
  t3422 = t2615 * t21;
  t3430 = -0.73e2 / 0.12e4 * t2904 * t805 - 0.73e2 / 0.6e3 * t1344 * t1647 + 0.73e2 / 0.3e3 * t658 * t608 * t567 - 0.73e2 / 0.12e4 * t658 * t310 * t1150 - 0.73e2 / 0.3e3 * t3410 * t659 - 0.73e2 / 0.12e4 * t1634 * t1356 + 0.73e2 / 0.3e3 * t1344 * t1644 + 0.73e2 / 0.4e3 * t3417 * t1350 + 0.73e2 / 0.15e3 * t1652 * t1353 + 0.73e2 / 0.8e3 * t3422 * t1350 + 0.73e2 / 0.3e3 * t1634 * t1353 - 0.73e2 / 0.2e3 * t658 * t1266 * t284;
  t3435 = t2286 * t1312;
  t3442 = t956 * t1315;
  t3445 = t956 * t1318;
  t3448 = t2828 * t532;
  t3470 = 0.9e1 / 0.8e1 * t632 * t3153 + 0.9e1 / 0.16e2 * t632 * t3156 + 0.45e2 / 0.256e3 * t526 * t3435 - 0.45e2 / 0.32e2 * t632 * t3167 + 0.3e1 / 0.8e1 * t1089 * t1592 - 0.9e1 / 0.64e2 * t526 * t3442 - 0.9e1 / 0.128e3 * t526 * t3445 - 0.45e2 / 0.16e2 * t1098 * t3448 - 0.75e2 / 0.8e1 * t3159 * t1453 * t791 * t184 - 0.81e2 / 0.16e2 * t966 * t1603 * t184 - 0.81e2 / 0.16e2 * t966 * t1606 * t184 - 0.81e2 / 0.32e2 * t966 * t787 * t425 + 0.567e3 / 0.64e2 * t2300 * t787 * t412 - 0.5e1 / 0.3e1 * t1435 + 0.5e1 / 0.4e1 * t1440 - 0.325e3 / 0.12e2 * t1455;
  t3507 = 0.81e2 / 0.8e2 * t411 * t334 * t1125 + 0.81e2 / 0.8e2 * t411 * t1326 * t267 + 0.81e2 / 0.4e2 * t411 * t645 * t543 - 0.15e2 / 0.8e1 * t1438 + 0.65e2 / 0.3e1 * t1465 + 0.9e1 / 0.8e1 * t1098 * t2807 * t267 + 0.9e1 / 0.8e1 * t1098 * t1305 * t543 + 0.25e2 / 0.8e1 * t3128 * t1609 - 0.3e1 / 0.8e1 * t632 * t2478 - t1089 * t1309 / 0.4e1 + 0.3e1 / 0.64e2 * t526 * t2794 + 0.9e1 / 0.16e2 * t2487 * t1597 + 0.11e2 / 0.24e2 * t2500 * t635 - 0.45e2 / 0.32e2 * t1457 * t1612 * t3170 + 0.225e3 / 0.64e2 * t3176 * t1612 * t3177 + 0.195e3 / 0.16e2 * t1461;
  t3508 = t3470 + t3507;
  t3511 = t796 * t439;
  t3536 = 0.292e3 / 0.2025e4 * t76 * t3508 + 0.73e2 / 0.3888e6 * t3511 * t441 - 0.73e2 / 0.972e5 * t3508 * t93 + 0.292e3 / 0.2025e4 * t1130 * t337 + 0.584e3 / 0.2025e4 * t548 * t648 + 0.292e3 / 0.2025e4 * t272 * t1329 + 0.292e3 / 0.2025e4 * t430 * t796 - t289 * t1266 / 0.3e2 + 0.73e2 / 0.1944e6 * t2941 * t558 + 0.73e2 / 0.1944e6 * t1337 * t1187 + 0.73e2 / 0.3888e6 * t1337 * t1190 - 0.73e2 / 0.2592e6 * t2944 * t1195 + 0.584e3 / 0.2025e4 * t189 * t1617;
  t3553 = t138 * t819 * t667 * t221;
  t3574 = -t138 * t133 * t1661 * t349 / 0.4e1 - t1371 * t1703 / 0.6e1 - t676 * t3294 * t1389 / 0.6e1 - t1668 * t1390 / 0.6e1 - t1380 * t3300 * t2744 / 0.18e2 + t1686 * t2743 * t3304 / 0.24e2 + t1261 * t1703 / 0.4e1 - 0.7e1 / 0.48e2 * t7 * t1675 * t667 * t826 + t7 * t820 * t1364 * t826 / 0.32e2 + 0.35e2 / 0.144e3 * t7 * t18 * t791 * t347 * t826 + t138 * t56 * t813 * t349 / 0.12e2 - 0.3e1 / 0.8e1 * t138 * t19 * (t3356 + t3398 + t3430 + t3536) * t349 + t1693 * t2739 * t825 / 0.32e2 + t138 * t368 * t667 * t473 * t1688 / 0.24e2 + t3553 * t1694 / 0.16e2 + t1693 * t2748 * t825 / 0.32e2 + t138 * t791 * t813 * t221 * t681 / 0.4e1 - t138 * t673 * t1661 * t221 * t681 / 0.6e1 - t138 * t504 * t813 * t473 * t1385 / 0.18e2;
  t3590 = 0.1e1 / t48 / t212;
  t3629 = t1661 * t122;
  t3637 = -0.25e2 / 0.144e3 * t1380 * t1688 - 0.7e1 / 0.48e2 * t676 * t1694 - 0.3e1 / 0.8e1 * t595 * t684 * t301 * t481 * t125 - 0.3e1 / 0.8e1 * t595 * t684 * t301 * t486 * t125 + t2959 * t18 * t3590 * t2964 * t2965 * t21 / 0.9e1 - t1079 * t1711 / 0.4e1 - 0.3e1 / 0.4e1 * t595 * t1374 * t1710 - 0.3e1 / 0.4e1 * t595 * t684 * t3270 - t138 * t674 * t221 * t301 * t1390 / 0.6e1 - 0.3e1 / 0.8e1 * t595 * t1671 * t487 + t2731 * t829 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t1671 * t482 - t1079 * t1672 / 0.4e1 - 0.3e1 / 0.8e1 * t595 * t2973 * t302 - 0.3e1 / 0.4e1 * t595 * t1374 * t591 - 0.3e1 / 0.8e1 * t595 * t684 * t1232 - 0.3e1 / 0.4e1 * t595 * t3629 * t228 - t1079 * t1699 / 0.4e1 - t1079 * t1706 / 0.4e1;
  t3639 = my_piecewise3(t3, 0, t3574 + t3637);
  tv4rho2sigmatau0 = 0.2e1 * rho[0] * t3639 + 0.4e1 * t1715;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  t3664 = t965 * t858;
  t3676 = t645 * t645;
  t3684 = 0.9e1 / 0.4e1 * t632 * t3442 + 0.9e1 / 0.8e1 * t632 * t3445 + 0.75e2 * t3159 * t1453 * t673 * t184 - 0.3e1 / 0.4e1 * t632 * t2794 - 0.45e2 / 0.16e2 * t1098 * t3664 * t184 + 0.9e1 / 0.4e1 * t1098 * t1305 * t645 - 0.25e2 * t3128 * t1765 - 0.81e2 / 0.32e2 * t966 * t858 * t425 + 0.81e2 / 0.4e2 * t411 * t3676 + 0.81e2 / 0.4e2 * t411 * t334 * t1326 + 0.9e1 / 0.16e2 * t401 * t1756;
  t3705 = 0.567e3 / 0.64e2 * t2300 * t858 * t412 - 0.81e2 / 0.8e1 * t966 * t638 * t645 + 0.45e2 / 0.4e1 * t1457 * t1768 * t3170 - 0.45e2 / 0.16e2 * t632 * t3435 - 0.225e3 / 0.8e1 * t3176 * t1768 * t3177 - 0.75e2 * t1614 + 0.5e1 / 0.2e1 * t1595 + 0.5e3 / 0.3e1 * t1610 - 0.15e2 / 0.4e1 * t1593 - 0.1e2 / 0.3e1 * t1590 - 0.325e3 / 0.3e1 * t719;
  t3706 = t3684 + t3705;
  t3714 = t2944 * t21;
  t3722 = t2370 * t146;
  t3739 = 0.73e2 / 0.3e3 * t2897 * t342 - 0.3942e4 / 0.25e2 * t994 * t1795 - 0.73e2 / 0.75e2 * t1334 * t662 + 0.73e2 / 0.5e2 * t653 * t1359 - 0.219e3 / 0.1e3 * t195 * t444 * t150 - 0.73e2 / 0.972e5 * t3706 * t93 + 0.73e2 / 0.2e3 * t1344 * t1800 + 0.73e2 / 0.4e3 * t658 * t835 * t453 + 0.73e2 / 0.4e3 * t3714 * t1350 + 0.73e2 / 0.15e3 * t1783 * t1353 - 0.5913e4 / 0.2e3 * t1790 * t839 * t453 + 0.5913e4 / 0.8e2 * t3722 * t839 * t441 + 0.5913e4 / 0.25e2 * t1790 * t1726 * t205 - 0.219e3 / 0.8e3 * t1349 * t835 * t441 - 0.73e2 / 0.1e3 * t658 * t1722 * t205 - 0.2e1 / 0.9e1 * t1742 * t164 + 0.11e2 / 0.27e2 * t851 * t392;
  t3740 = t648 * t648;
  t3748 = t865 * t439;
  t3763 = t2362 * t146;
  t3775 = t461 * t1735;
  t3780 = 0.1e1 / t843 / t149;
  t3792 = t2941 * t21;
  t3797 = t1773 * t194;
  t3802 = 0.584e3 / 0.2025e4 * t3740 + 0.1971e4 / 0.5e1 * t440 * t146 * t368 * t376 + 0.73e2 / 0.5e2 * t435 * t1803 + 0.73e2 / 0.3888e6 * t3748 * t441 + 0.1971e4 / 0.1e3 * t2359 * t873 - 0.73e2 / 0.2e3 * t991 * t876 + 0.292e3 / 0.2025e4 * t76 * t3706 + 0.584e3 / 0.2025e4 * t189 * t1773 + 0.292e3 / 0.2025e4 * t430 * t865 + 0.584e3 / 0.2025e4 * t337 * t1329 - 0.5913e4 / 0.1e3 * t3763 * t1791 + (0.9e1 / 0.16e2 * t22 * t241 * t33 - 0.91e2 / 0.512e3 * t147 * t698 * t153 + 0.375e3 / 0.32768e5 * t374 * t1851 * t379 - 0.33e2 / 0.131072e6 * t922 * t3775 * t927 + 0.15e2 / 0.8388608e7 * t2252 * t2246 * t3780 * t2257) * t38 * t43 * t51 / 0.24e2 - 0.73e2 / 0.6e3 * t1783 * t1356 - 0.73e2 / 0.3e3 * t3792 * t659 + t102 * t241 / 0.2e2 - 0.73e2 / 0.972e5 * t3797 * t205 - 0.73e2 / 0.1944e6 * t1778 * t453;
  t3812 = t1808 * t122;
  t3825 = t667 * t667;
  t3844 = -0.3e1 / 0.8e1 * t138 * t19 * (t3739 + t3802) * t349 - t138 * t133 * t1808 * t349 / 0.4e1 - 0.3e1 / 0.4e1 * t595 * t3812 * t228 - 0.3e1 / 0.8e1 * t595 * t1818 * t482 + t138 * t56 * t881 * t349 / 0.12e2 - t1079 * t1819 / 0.4e1 + 0.3e1 / 0.4e1 * t595 * t3825 * t473 * t887 + 0.3e1 / 0.4e1 * t595 * t1824 * t887 * t1364 + 0.3e1 / 0.8e1 * t595 * t886 * t96 * t481 * t125 - 0.3e1 / 0.8e1 * t595 * t1818 * t487 - t2731 * t888 / 0.12e2;
  t3857 = t887 * params->e;
  t3869 = t7 * t20 * t347;
  t3870 = t473 * t96;
  t3890 = t1041 * t96;
  t3892 = t138 * t1829 * t3890;
  t3896 = t138 * t674 * t3890;
  t3902 = t1079 * t1826 / 0.2e1 + t1079 * t1838 / 0.4e1 - t138 * t791 * t885 * t1041 * t1833 / 0.2e1 + 0.5e1 / 0.27e2 * t138 * t504 * t885 * t2194 * t3857 * t2744 - t1815 * t1390 / 0.6e1 + 0.3e1 / 0.8e1 * t595 * t886 * t96 * t486 * t125 + 0.3e1 / 0.2e1 * t3869 * t3870 * t228 * t667 + t138 * t791 * t881 * t221 * t681 / 0.4e1 - t138 * t673 * t1808 * t221 * t681 / 0.6e1 - t138 * t504 * t881 * t473 * t1385 / 0.18e2 + t3892 * t1390 / 0.3e1 + 0.2e1 / 0.3e1 * t3896 * t125 * t667 * t101 * t1389;
  t3904 = my_piecewise3(t3, 0, t3844 + t3902);
  tv4rho2tau20 = 0.2e1 * rho[0] * t3904 + 0.4e1 * t1842;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  t3933 = t107 * t213;
  t3940 = -t703 * t518 / 0.3e1 + t1421 * t251 / 0.8e1 - 0.73e2 / 0.864e5 * t1002 * t1891 * t205 + 0.292e3 / 0.2025e4 * t189 * t1877 + 0.292e3 / 0.675e3 * t272 * t1467 + 0.292e3 / 0.675e3 * t548 * t721 - t1857 * t164 / 0.9e1 + 0.73e2 / 0.1296e6 * t994 * t1891 + 0.73e2 / 0.1296e6 * t440 * t567 * t733 + 0.73e2 / 0.1296e6 * t440 * t284 * t1497 - t105 * t3933 / 0.12e2 + 0.73e2 / 0.648e5 * t1182 * t1487 + 0.73e2 / 0.1296e6 * t1182 * t1492;
  t3978 = t2286 * t1445;
  t3981 = t956 * t1448;
  t3987 = t410 * params->b * t184;
  t3990 = t2286 * t1870;
  t4003 = t83 * t184;
  t4004 = t717 * t4003;
  t4013 = 0.9e1 / 0.16e2 * t1089 * t1442 + 0.135e3 / 0.256e3 * t526 * t3978 - 0.27e2 / 0.64e2 * t526 * t3981 - 0.75e2 / 0.32e2 * t3933 * t1867 - 0.225e3 / 0.512e3 * t1866 * t3987 - 0.45e2 / 0.32e2 * t171 * t3990 + 0.567e3 / 0.64e2 * t2300 * t1870 * t184 - 0.243e3 / 0.32e2 * t966 * t713 * t543 + 0.225e3 / 0.128e3 * t3159 * t1873 * t717 - 0.675e3 / 0.512e3 * t966 * t1873 * t4004 + 0.135e3 / 0.256e3 * t411 * t543 * params->b * t718 - 0.45e2 / 0.16e2 * t1874 * t1464;
  t4018 = t1877 * t194;
  t4025 = 0.73e2 / 0.10368e6 * t2370 * t1888 * t205 - 0.73e2 / 0.864e5 * t1002 * t728 * t567 + (0.3e1 / 0.64e2 * t1409 * t1846 - 0.99e2 / 0.16384e5 * params->c * t504 * t3086 * t108 + 0.51e2 / 0.262144e6 * t503 * t1417 - 0.15e2 / 0.8388608e7 * t1167 * t924 * t1735 * t2257) * t38 * t43 * t51 / 0.24e2 + 0.73e2 / 0.1296e6 * t3031 * t558 - 0.73e2 / 0.864e5 * t2615 * t1484 - 0.73e2 / 0.2592e6 * t2362 * t1888 - 0.73e2 / 0.648e5 * t553 * t1497 - 0.73e2 / 0.648e5 * t1135 * t733 + 0.73e2 / 0.1296e6 * t2570 * t728 + 0.292e3 / 0.2025e4 * t76 * t4013 - 0.73e2 / 0.972e5 * t4013 * t93 - 0.73e2 / 0.1944e6 * t4018 * t205 - 0.73e2 / 0.648e5 * t3048 * t284 - 0.73e2 / 0.648e5 * t1472 * t567;
  t4030 = t1896 * t221 * t223;
  t4056 = -(t3940 + t4025) * t122 * t96 - 0.2e1 / 0.9e1 * t4030 * t187 + t3205 * t270 / 0.4e1 + t3209 * t565 / 0.6e1 - 0.2e1 / 0.3e1 * t1514 * t546 - t2680 * t718 / 0.16e2 - t2650 * t1526 / 0.3e1 + t1212 * t1464 / 0.3e1 + t2403 * t1903 / 0.24e2 + 0.5e1 / 0.216e3 * t2414 / t48 / t923 * t38 * t680 - t1043 * t1045 * t213 / 0.3e1;
  t4061 = params->kappa * t1906;
  t4087 = my_piecewise3(t3, 0, t138 * t360 * t1907 / 0.8e1 + 0.3e1 / 0.8e1 * t138 * t139 * t4056 * t125 + 0.3e1 / 0.8e1 * t595 * t4061 * t228 + 0.3e1 / 0.8e1 * t1079 * t1911 + 0.9e1 / 0.8e1 * t595 * t3248 * t302 + 0.9e1 / 0.8e1 * t595 * t1536 * t591 + 0.9e1 / 0.8e1 * t595 * t1536 * t1710 + t138 * t360 * t1915 / 0.8e1 + 0.9e1 / 0.8e1 * t595 * t1546 * t591 + 0.3e1 / 0.8e1 * t595 * params->kappa * t1914 * t228);
  tv4rhosigma30 = 0.2e1 * rho[0] * t4087 + 0.2e1 * t1920;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  t4093 = t116 * t250;
  t4110 = t315 * t153;
  t4137 = 0.73e2 / 0.1944e6 * t3511 * t558 - 0.73e2 / 0.2592e6 * t2944 * t1484 - t1935 * t164 / 0.9e1 + 0.73e2 / 0.4e3 * t3422 * t1641 - 0.73e2 / 0.12e4 * t658 * t310 * t1497 + (t1406 * t1922 / 0.8e1 - 0.23e2 / 0.256e3 * t1409 * t4110 * t21 + 0.33e2 / 0.4096e4 * t147 * t619 - 0.57e2 / 0.262144e6 * t374 * t1565 + 0.15e2 / 0.8388608e7 * t922 * t924 * t2136 * t2257) * t38 * t43 * t51 / 0.24e2 + 0.73e2 / 0.8e3 * t2871 * t1980 - 0.73e2 / 0.3e3 * t3410 * t805 - 0.73e2 / 0.3e3 * t1652 * t1647 - 0.73e2 / 0.12e4 * t1344 * t1985 - 0.73e2 / 0.6e3 * t3376 * t805;
  t4140 = t1182 * sigma[0];
  t4143 = t3031 * t21;
  t4166 = -0.73e2 / 0.6e3 * t1634 * t1647 - 0.73e2 / 0.3e3 * t4140 * t659 - 0.73e2 / 0.12e4 * t4143 * t659 + 0.73e2 / 0.3e3 * t1634 * t1644 - 0.73e2 / 0.4e3 * t1349 * t608 * t728 + 0.73e2 / 0.15e3 * t1652 * t1644 + 0.73e2 / 0.6e3 * t658 * t608 * t733 - 0.73e2 / 0.15e3 * t195 * t608 + 0.73e2 / 0.1944e6 * t1337 * t1487 + 0.73e2 / 0.3888e6 * t1337 * t1492 + 0.73e2 / 0.3e3 * t435 * t310 - 0.73e2 / 0.1944e6 * t1334 * t733;
  t4189 = t1963 * t194;
  t4196 = -0.73e2 / 0.1944e6 * t653 * t1497 + t1503 * t309 / 0.9e2 + 0.73e2 / 0.3888e6 * t2941 * t728 - 0.73e2 / 0.972e5 * t1622 * t567 - 0.73e2 / 0.32e3 * t2876 * t310 * t1484 + 0.73e2 / 0.4e3 * t1349 * t310 * t1487 + 0.73e2 / 0.2e3 * t3417 * t1641 + 0.73e2 / 0.8e3 * t1349 * t310 * t1492 - 0.73e2 / 0.972e5 * t3373 * t284 - 0.73e2 / 0.1944e6 * t4189 * t205 + t1569 * t251 / 0.12e2 + 0.73e2 / 0.6e3 * t3048 * t342;
  t4213 = t956 * t1603;
  t4216 = t956 * t1606;
  t4236 = t1955 * t184;
  t4241 = t82 * t543;
  t4248 = t966 * t1959;
  t4252 = t411 * t645 * params->b;
  t4257 = 0.567e3 / 0.64e2 * t2300 * t1952 * t184 - 0.81e2 / 0.32e2 * t966 * t645 * t713 - 0.81e2 / 0.16e2 * t966 * t787 * t543 - 0.75e2 / 0.8e1 * t3159 * t1453 * t791 * t267 + 0.225e3 / 0.32e2 * t3176 * t1612 * t4236 + 0.195e3 / 0.16e2 * t1875 - 0.45e2 / 0.16e2 * t1457 * t1612 * t4241 + 0.75e2 / 0.128e3 * t3159 * t1959 * t717 - 0.225e3 / 0.512e3 * t4248 * t4004 + 0.45e2 / 0.256e3 * t4252 * t718 - 0.15e2 / 0.16e2 * t1960 * t1464;
  t4258 = -0.15e2 / 0.16e2 * t1864 - 0.45e2 / 0.32e2 * t632 * t3978 + 0.9e1 / 0.8e1 * t632 * t3981 + 0.525e3 / 0.32e2 * t1868 + 0.225e3 / 0.64e2 * t1946 * t3987 + 0.3e1 / 0.8e1 * t1089 * t1949 + 0.45e2 / 0.128e3 * t270 * t3448 - 0.9e1 / 0.64e2 * t526 * t4213 - 0.9e1 / 0.64e2 * t526 * t4216 - 0.45e2 / 0.32e2 * t1098 * t2828 * t713 + t4257;
  t4279 = 0.73e2 / 0.15e3 * t1135 * t808 - 0.73e2 / 0.6e3 * t440 * t659 - 0.73e2 / 0.972e5 * t4258 * t93 + 0.292e3 / 0.2025e4 * t76 * t4258 - 0.73e2 / 0.75e2 * t553 * t1655 - 0.73e2 / 0.3e3 * t1472 * t662 - 0.2e1 / 0.9e1 * t775 * t518 + 0.292e3 / 0.2025e4 * t189 * t1963 + 0.584e3 / 0.2025e4 * t272 * t1617 + 0.584e3 / 0.2025e4 * t548 * t796 + 0.292e3 / 0.2025e4 * t721 * t648 + 0.292e3 / 0.2025e4 * t1467 * t337;
  t4299 = 0.1e1 / t48 / t110;
  t4311 = t1992 * t122;
  t4319 = t138 * t819 * t813 * t221;
  t4324 = t138 * t148 * t347 * t473;
  t4343 = t1686 * t3300 * t3304 / 0.24e2 + t1693 * t1710 * t4093 / 0.16e2 - 0.3e1 / 0.8e1 * t138 * t19 * (t4137 + t4166 + t4196 + t4279) * t349 - 0.3e1 / 0.4e1 * t595 * t684 * t302 * t590 - 0.3e1 / 0.8e1 * t595 * t684 * t758 * t227 * t125 - 0.3e1 / 0.4e1 * t595 * t1671 * t1710 - t2959 * t18 * t4299 * t2964 * t2965 * sigma[0] / 0.24e2 - 0.3e1 / 0.8e1 * t595 * t684 * t754 * t227 * t125 - 0.3e1 / 0.8e1 * t595 * t4311 * t228 - 0.7e1 / 0.48e2 * t676 * t2013 + t4319 * t1694 / 0.16e2 - t4324 * t2743 * t2009 / 0.128e3 + t3553 * t2013 / 0.16e2 + t1693 * t3294 * t825 / 0.16e2 - t138 * t673 * t1992 * t221 * t681 / 0.12e2 + t138 * t368 * t813 * t473 * t1688 / 0.24e2;
  t4386 = t755 * t101;
  t4390 = t759 * t101;
  t4396 = -0.3e1 / 0.8e1 * t595 * t684 * t1532 - 0.3e1 / 0.8e1 * t595 * t1374 * t759 - 0.3e1 / 0.4e1 * t595 * t3629 * t302 - 0.3e1 / 0.4e1 * t595 * t1671 * t591 - 0.3e1 / 0.8e1 * t595 * t1374 * t755 - t1079 * t2019 / 0.8e1 - t1079 * t2001 / 0.4e1 - t1079 * t2016 / 0.8e1 - t138 * t133 * t1992 * t349 / 0.8e1 + t7 * t820 * t1661 * t826 / 0.16e2 - t7 * t2004 * t667 * t2010 / 0.128e3 + 0.5e1 / 0.128e3 * t7 * t18 * t368 * t347 * t2010 - 0.7e1 / 0.48e2 * t7 * t1675 * t813 * t826 - t676 * t4386 * t1389 / 0.12e2 - t676 * t4390 * t1389 / 0.12e2 - t1668 * t1703 / 0.6e1;
  t4398 = my_piecewise3(t3, 0, t4343 + t4396);
  tv4rhosigma2tau0 = 0.2e1 * rho[0] * t4398 + 0.2e1 * t2023;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  t4437 = t3511 * t21;
  t4446 = 0.1971e4 / 0.25e2 * t994 * t2080 - 0.73e2 / 0.2e3 * t1135 * t876 - 0.73e2 / 0.1e3 * t435 * t2088 - 0.73e2 / 0.1944e6 * t3797 * t284 - 0.73e2 / 0.1944e6 * t1778 * t567 - 0.73e2 / 0.6e3 * t3792 * t805 + 0.73e2 / 0.2e3 * t1652 * t1800 - 0.73e2 / 0.6e3 * t4437 * t659 + 0.1971e4 / 0.1e3 * t2570 * t873 + 0.73e2 / 0.3e3 * t3373 * t342 + 0.73e2 / 0.15e3 * t1334 * t808;
  t4460 = t2286 * t1759;
  t4463 = t956 * t1762;
  t4499 = 0.567e3 / 0.64e2 * t2300 * t2053 * t184 - 0.81e2 / 0.16e2 * t966 * t787 * t645 - 0.81e2 / 0.32e2 * t966 * t858 * t543 - 0.75e2 / 0.8e1 * t3159 * t1959 * t792 + 0.225e3 / 0.32e2 * t4248 * t792 * t4003 - 0.45e2 / 0.16e2 * t4252 * t793 + 0.195e3 / 0.16e2 * t1961 + 0.75e2 / 0.2e1 * t3159 * t1453 * t673 * t267 - 0.225e3 / 0.8e1 * t3176 * t1768 * t4236 - 0.75e2 / 0.2e1 * t1957 + 0.45e2 / 0.4e1 * t1457 * t1768 * t4241;
  t4500 = -0.15e2 / 0.8e1 * t1950 - 0.45e2 / 0.16e2 * t325 * t65 * t3448 + 0.9e1 / 0.8e1 * t632 * t4213 + 0.9e1 / 0.8e1 * t632 * t4216 - 0.225e3 / 0.2e1 * t1947 - 0.225e3 / 0.8e1 * t2048 * t3987 + 0.3e1 / 0.16e2 * t1089 * t1756 + 0.45e2 / 0.256e3 * t526 * t4460 - 0.9e1 / 0.64e2 * t526 * t4463 - 0.45e2 / 0.32e2 * t1098 * t3664 * t267 + t4499;
  t4527 = 0.292e3 / 0.2025e4 * t76 * t4500 + 0.73e2 / 0.4e3 * t1634 * t1800 + 0.292e3 / 0.2025e4 * t272 * t1773 + 0.292e3 / 0.2025e4 * t189 * t2061 + 0.584e3 / 0.2025e4 * t337 * t1617 + 0.292e3 / 0.2025e4 * t548 * t865 - 0.73e2 / 0.972e5 * t4500 * t93 + t1741 * t251 / 0.24e2 - 0.73e2 / 0.2e3 * t658 * t1722 * t284 + 0.73e2 / 0.4e3 * t1344 * t2085 + 0.73e2 / 0.4e3 * t658 * t835 * t567 + 0.73e2 / 0.3e3 * t1783 * t1644;
  t4569 = 0.5913e4 / 0.5e2 * t1790 * t1726 * t284 + 0.584e3 / 0.2025e4 * t648 * t796 + 0.73e2 / 0.4e3 * t3714 * t1641 + 0.5913e4 / 0.8e2 * t3722 * t839 * t558 - 0.219e3 / 0.8e3 * t1349 * t835 * t558 + (-0.3e1 / 0.8e1 * t236 * t1723 + 0.37e2 / 0.256e3 * t239 * t1727 - 0.21e2 / 0.2048e4 * t503 * t1731 + 0.63e2 / 0.262144e6 * t1167 * t1737 - 0.15e2 / 0.8388608e7 * t2556 * t924 * t3780 * t2257) * t38 * t43 * t51 / 0.24e2 - t2037 * t164 / 0.9e1 + 0.73e2 / 0.3888e6 * t3748 * t558 - t289 * t1722 / 0.3e2 - 0.73e2 / 0.75e2 * t653 * t1655 - 0.1971e4 / 0.25e2 * t1182 * t1795;
  t4588 = t1002 * t108;
  t4593 = t1337 * sigma[0];
  t4596 = t2615 * t146;
  t4599 = t2061 * t194;
  t4602 = -0.7884e4 / 0.25e2 * t440 * t108 * t148 * t376 - 0.73e2 / 0.15e3 * t1622 * t662 + 0.73e2 / 0.1e3 * t553 * t1803 + 0.73e2 / 0.5e2 * t195 * t561 * t150 - t850 * t518 / 0.9e1 - 0.5913e4 / 0.2e3 * t3763 * t2076 - 0.5913e4 / 0.2e3 * t1790 * t839 * t567 - 0.5913e4 / 0.5e2 * t4588 * t1791 - 0.73e2 / 0.6e3 * t1783 * t1647 - 0.73e2 / 0.3e3 * t4593 * t659 - 0.5913e4 / 0.2e3 * t4596 * t1791 - 0.73e2 / 0.1944e6 * t4599 * t205;
  t4628 = -t1079 * t2102 / 0.8e1 + t1079 * t2106 / 0.4e1 + t1079 * t2117 / 0.8e1 - 0.3e1 / 0.8e1 * t595 * t1818 * t1710 + 0.3e1 / 0.4e1 * t595 * t667 * t473 * t2105 + 0.3e1 / 0.4e1 * t595 * t1824 * t887 * t1661 + 0.3e1 / 0.8e1 * t595 * t886 * t96 * t590 * t125 - 0.3e1 / 0.8e1 * t138 * t19 * (t4446 + t4527 + t4569 + t4602) * t349 + 0.3e1 / 0.4e1 * t3869 * t3870 * t302 * t667 + 0.3e1 / 0.8e1 * t7 * t20 * t885 * t3870 * t1710 + 0.3e1 / 0.4e1 * t3869 * t3870 * t228 * t813 - 0.3e1 / 0.8e1 * t595 * t3812 * t302 - 0.3e1 / 0.8e1 * t595 * t1818 * t591;
  t4629 = t2093 * t122;
  t4640 = t819 * t881;
  t4642 = t138 * t4640 * t221;
  t4655 = t138 * t1691 * t1041;
  t4687 = -0.3e1 / 0.8e1 * t595 * t4629 * t228 + 0.7e1 / 0.48e2 * t1831 * t2112 + t138 * t368 * t881 * t473 * t1688 / 0.48e2 + t4642 * t1694 / 0.32e2 - t138 * t673 * t2093 * t221 * t681 / 0.12e2 - t138 * t133 * t2093 * t349 / 0.8e1 - t4655 * t1832 * t65 * t46 * t667 / 0.8e1 - 0.5e1 / 0.72e2 * t138 * t368 * t885 * t2194 * t3857 * t3304 - t2111 * t1837 * t4093 / 0.16e2 + t3892 * t1703 / 0.6e1 + t3896 * t125 * t813 * t101 * t1389 / 0.3e1 + t7 * t820 * t1808 * t826 / 0.32e2 - 0.7e1 / 0.96e2 * t7 * t1675 * t881 * t826 - t1815 * t1703 / 0.12e2;
  t4689 = my_piecewise3(t3, 0, t4628 + t4687);
  tv4rhosigmatau20 = 0.2e1 * rho[0] * t4689 + 0.2e1 * t2121;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  t4727 = -0.17739e5 / 0.1e3 * t994 * t2173 + 0.73e2 / 0.5e2 * t435 * t2176 + 0.73e2 / 0.2e3 * t3797 * t342 + 0.5913e4 / 0.1e3 * t2941 * t873 - 0.219e3 / 0.2e3 * t1334 * t876 + 0.478953e6 / 0.5e2 * t2362 * t2170 - 0.73e2 / 0.1e3 * t1778 * t662 - 0.5913e4 / 0.25e2 * t1337 * t1795 + 0.219e3 / 0.1e3 * t653 * t1803 - 0.1436859e7 / 0.25e2 * t1002 * t373 * t504 * t1279 + 0.17739e5 / 0.25e2 * t440 * t1794 * t617 - 0.73e2 / 0.25e2 * t195 * t196 * t315 - 0.73e2 / 0.1e3 * t658 * t2123 * t205;
  t4730 = t2370 * t373;
  t4737 = t2944 * t146;
  t4740 = t141 * t315;
  t4757 = 0.1e1 / t843 / t314;
  t4767 = t3748 * t21;
  t4788 = t2286 * t2153;
  t4806 = -0.45e2 / 0.16e2 * t2051 - 0.135e3 / 0.32e2 * t632 * t4460 + 0.27e2 / 0.8e1 * t632 * t4463 + 0.75e3 * t2049 + 0.225e3 * t2150 * t3987 - 0.45e2 / 0.32e2 * t171 * t4788 + 0.567e3 / 0.64e2 * t2300 * t2153 * t184 - 0.243e3 / 0.32e2 * t966 * t858 * t645 + 0.225e3 / 0.2e1 * t3159 * t1959 * t861 - 0.675e3 / 0.8e1 * t4248 * t861 * t4003 + 0.135e3 / 0.4e1 * t4252 * t862 - 0.225e3 / 0.2e1 * t2056;
  t4811 = t2158 * t194;
  t4814 = 0.219e3 / 0.4e3 * t1783 * t1800 - 0.478953e6 / 0.2e2 * t4730 * t2131 * t205 + 0.53217e5 / 0.2e3 * t1790 * t2127 * t205 - 0.17739e5 / 0.2e3 * t4737 * t1791 + (0.3e1 / 0.4e1 * t22 * t4740 * t33 - 0.27e2 / 0.128e3 * t147 * t148 * t617 * t153 + 0.207e3 / 0.16384e5 * t374 * t504 * t1279 * t379 - 0.69e2 / 0.262144e6 * t922 * t213 * t2136 * t927 + 0.15e2 / 0.8388608e7 * t2252 * t924 * t4757 * t2257) * t38 * t43 * t51 / 0.24e2 - 0.73e2 / 0.4e3 * t4767 * t659 - t2143 * t164 / 0.9e1 + t102 * t4740 / 0.15e2 + 0.292e3 / 0.675e3 * t648 * t865 + 0.292e3 / 0.675e3 * t337 * t1773 + 0.292e3 / 0.2025e4 * t189 * t2158 + 0.292e3 / 0.2025e4 * t76 * t4806 - 0.73e2 / 0.972e5 * t4806 * t93 - 0.73e2 / 0.1944e6 * t4811 * t205;
  t4825 = t2181 * t122;
  t4843 = t7 * t20 * t881;
  t4849 = t885 * t2194;
  t4856 = 0.1e1 / t472 / t220;
  t4859 = t2198 * t101;
  t4868 = -t138 * t133 * t2181 * t349 / 0.8e1 - 0.3e1 / 0.8e1 * t138 * t19 * (t4727 + t4814) * t349 - t138 * t673 * t2181 * t221 * t681 / 0.12e2 - 0.3e1 / 0.8e1 * t595 * t4825 * t228 + 0.3e1 / 0.8e1 * t1079 * t2189 + 0.9e1 / 0.8e1 * t595 * t1808 * t473 * t2188 + t138 * t1813 * t2964 * t1833 / 0.2e1 + 0.9e1 / 0.8e1 * t595 * t2186 * t1825 + 0.9e1 / 0.8e1 * t4843 * t1824 * t1837 - t1079 * t2199 / 0.8e1 - 0.9e1 / 0.8e1 * t595 * t4849 * t2198 * t667 - t138 * t673 * t2192 * t4856 * t4859 * t1389 / 0.4e1 - 0.3e1 / 0.8e1 * t595 * t2195 * t2197 * t227 * t125;
  t4869 = my_piecewise3(t3, 0, t4868);
  tv4rhotau30 = 0.2e1 * rho[0] * t4869 + 0.2e1 * t2203;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  t4889 = t721 * t721;
  t4895 = t1099 * params->b;
  t4898 = t713 * t713;
  t4905 = params->b * params->b;
  t4906 = t411 * t4905;
  t4910 = t38 / t42 / t106;
  t4914 = 0.45e2 / 0.64e2 * t526 * t3990 - 0.225e3 / 0.128e3 * t1866 * t4895 + 0.567e3 / 0.64e2 * t2300 * t4898 - 0.675e3 / 0.256e3 * t966 * t713 * params->b * t718 + 0.1125e4 / 0.2048e4 * t4906 * t46 * t2961 * t4910;
  t4929 = t728 * t728;
  t4935 = t733 * t733;
  t4938 = (0.117e3 / 0.32768e5 * t3082 * t3086 * t21 - 0.3e1 / 0.256e3 * t1845 * t1410 - 0.21e2 / 0.131072e6 * t147 * t1852 + 0.15e2 / 0.8388608e7 * t374 * t3775 * t2257) * t38 * t43 * t51 / 0.24e2 + t1856 * t251 / 0.6e1 + 0.292e3 / 0.675e3 * t4889 + 0.1168e4 / 0.2025e4 * t272 * t1877 + 0.292e3 / 0.2025e4 * t76 * t4914 - 0.73e2 / 0.972e5 * t4914 * t93 - 0.73e2 / 0.486e5 * t4018 * t284 + 0.73e2 / 0.648e5 * t3031 * t728 - 0.73e2 / 0.324e5 * t1472 * t733 - 0.73e2 / 0.648e5 * t2615 * t1888 + 0.73e2 / 0.324e5 * t1182 * t1891 + 0.73e2 / 0.10368e6 * t2370 * t4929 - 0.73e2 / 0.432e5 * t1002 * t728 * t733 + 0.73e2 / 0.1296e6 * t440 * t4935;
  t4960 = t754 * t754;
  t4968 = t758 * t758;
  t4974 = my_piecewise3(t3, 0, 0.3e1 / 0.8e1 * t138 * t139 * (-t4938 * t122 * t96 + t4030 * t270 / 0.3e1 - t3209 * t718 / 0.8e1 + t2650 * t1903 / 0.6e1 - 0.5e1 / 0.576e3 * t2410 * t2412 * t107 * t2961 * t825) * t125 + 0.3e1 / 0.2e1 * t595 * t4061 * t302 + 0.9e1 / 0.8e1 * t138 * t139 * t4960 * t125 + 0.9e1 / 0.4e1 * t595 * t1536 * t759 + 0.3e1 / 0.8e1 * t138 * t139 * t4968 * t125);
  tv4sigma40 = 0.2e1 * rho[0] * t4974;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  t5009 = t2286 * t1952;
  t5012 = t1305 * params->b;
  t5018 = t82 * t713;
  t5022 = t966 * t787;
  t5031 = -0.45e2 / 0.32e2 * t632 * t3990 + 0.675e3 / 0.64e2 * t1946 * t4895 + 0.135e3 / 0.256e3 * t526 * t5009 - 0.225e3 / 0.512e3 * t1866 * t5012 + 0.567e3 / 0.64e2 * t2300 * t334 * t1870 + 0.675e3 / 0.64e2 * t3176 * t1612 * t5018 - 0.675e3 / 0.512e3 * t5022 * t1453 * t1458 * t82 - 0.1125e4 / 0.256e3 * t4906 * t46 * t3590 * t4910;
  t5040 = 0.219e3 / 0.8e3 * t3422 * t1980 - 0.73e2 / 0.1e3 * t4140 * t805 - 0.73e2 / 0.32e3 * t2876 * t310 * t1888 + 0.219e3 / 0.4e3 * t3417 * t1980 + 0.219e3 / 0.8e3 * t1349 * t310 * t1891 + 0.292e3 / 0.2025e4 * t1877 * t337 + 0.292e3 / 0.675e3 * t721 * t796 + 0.292e3 / 0.675e3 * t272 * t1963 + 0.292e3 / 0.2025e4 * t76 * t5031 - 0.73e2 / 0.972e5 * t5031 * t93 + 0.73e2 / 0.6e3 * t4018 * t342 + 0.73e2 / 0.1e3 * t553 * t310;
  t5079 = -0.73e2 / 0.648e5 * t4189 * t284 - 0.73e2 / 0.648e5 * t1622 * t733 - 0.73e2 / 0.4e3 * t4143 * t805 + 0.73e2 / 0.1e3 * t1472 * t808 - 0.73e2 / 0.4e3 * t1634 * t1985 - 0.73e2 / 0.2e3 * t440 * t805 - 0.73e2 / 0.2e3 * t1652 * t1985 + (0.3e1 / 0.64e2 * t1845 * t4110 * sigma[0] - 0.99e2 / 0.16384e5 * t239 * t771 + 0.51e2 / 0.262144e6 * t503 * t1930 - 0.15e2 / 0.8388608e7 * t1167 * t461 * t2136 * t2257) * t38 * t43 * t51 / 0.24e2 + t1934 * t251 / 0.8e1 + 0.73e2 / 0.1296e6 * t3511 * t728 - 0.73e2 / 0.2592e6 * t2944 * t1888 + 0.73e2 / 0.1296e6 * t1337 * t1891;
  t5111 = 0.1e1 / t48 / t447;
  t5120 = 0.3e1 / 0.32e2 * t7 * t820 * t1992 * t826 - 0.3e1 / 0.128e3 * t7 * t2004 * t813 * t2010 + 0.3e1 / 0.32e2 * t1693 * t4390 * t825 - 0.3e1 / 0.8e1 * t138 * t19 * (t5040 + t5079) * t349 - 0.3e1 / 0.8e1 * t595 * t684 * t1915 - 0.9e1 / 0.8e1 * t595 * t1671 * t759 - 0.9e1 / 0.8e1 * t595 * t684 * t754 * t301 * t125 + 0.3e1 / 0.32e2 * t1693 * t4386 * t825 + 0.3e1 / 0.16e2 * t4319 * t2013 - 0.3e1 / 0.128e3 * t4324 * t3300 * t2009 - 0.9e1 / 0.8e1 * t595 * t4311 * t302 - 0.9e1 / 0.8e1 * t595 * t1671 * t755 + t2959 * t18 * t5111 * t2964 * t2965 / 0.64e2 - 0.3e1 / 0.8e1 * t595 * t684 * t1907;
  t5121 = my_piecewise3(t3, 0, t5120);
  tv4sigma3tau0 = 0.2e1 * rho[0] * t5121;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  t5135 = t2286 * t2053;
  t5146 = t966 * t858 * params->b;
  t5156 = -0.45e2 / 0.16e2 * t632 * t5009 - 0.225e3 / 0.4e1 * t2048 * t4895 + 0.225e3 / 0.32e2 * t1946 * t5012 + 0.45e2 / 0.128e3 * t526 * t5135 + 0.567e3 / 0.64e2 * t2300 * t858 * t713 + 0.225e3 / 0.16e2 * t5022 * t1453 * t1612 * t82 - 0.225e3 / 0.512e3 * t5146 * t718 + 0.1125e4 / 0.32e2 * t4906 * t46 * t4299 * t4910 - 0.225e3 / 0.8e1 * t3176 * t1768 * t5018;
  t5168 = t796 * t796;
  t5184 = 0.73e2 / 0.15e3 * t653 * t310 - 0.73e2 / 0.1e3 * t195 * t835 - 0.73e2 / 0.972e5 * t4599 * t284 - 0.73e2 / 0.972e5 * t5156 * t93 + 0.292e3 / 0.2025e4 * t76 * t5156 - 0.5913e4 / 0.1e3 * t4596 * t2076 - 0.5913e4 / 0.2e3 * t1790 * t839 * t733 + 0.73e2 / 0.2e3 * t1634 * t2085 + 0.584e3 / 0.2025e4 * t5168 - 0.73e2 / 0.3e3 * t4437 * t805 - 0.73e2 / 0.6e3 * t1783 * t1985 + 0.584e3 / 0.2025e4 * t272 * t2061 + 0.584e3 / 0.2025e4 * t337 * t1963 + 0.292e3 / 0.2025e4 * t721 * t865 + 0.73e2 / 0.3e3 * t4189 * t342 + 0.1971e4 / 0.1e3 * t3031 * t873;
  t5239 = -0.73e2 / 0.2e3 * t1472 * t876 + t2036 * t251 / 0.12e2 + 0.5913e4 / 0.25e2 * t440 * t444 * t376 - 0.73e2 / 0.5e2 * t553 * t2088 + 0.73e2 / 0.75e2 * t1622 * t808 + 0.3942e4 / 0.25e2 * t1182 * t2080 - 0.73e2 / 0.1944e6 * t1778 * t733 + 0.73e2 / 0.3888e6 * t3748 * t728 + t740 * t150 / 0.6e2 + 0.73e2 / 0.4e3 * t658 * t835 * t733 + 0.5913e4 / 0.8e2 * t3722 * t839 * t728 - 0.5913e4 / 0.25e2 * t4588 * t2076 - 0.219e3 / 0.8e3 * t1349 * t835 * t728 + 0.73e2 / 0.1e3 * t1652 * t2085 + 0.73e2 / 0.4e3 * t3714 * t1980 - 0.73e2 / 0.15e3 * t4593 * t805 + (0.3e1 / 0.16e2 * t692 * t150 * t33 - 0.57e2 / 0.512e3 * t22 * t840 + 0.297e3 / 0.32768e5 * t147 * t846 - 0.15e2 / 0.65536e5 * t374 * t2032 + 0.15e2 / 0.8388608e7 * t922 * t461 * t3780 * t2257) * t38 * t43 * t51 / 0.24e2;
  t5264 = t813 * t813;
  t5299 = -0.3e1 / 0.8e1 * t138 * t19 * (t5184 + t5239) * t349 + t7 * t820 * t2093 * t826 / 0.16e2 - 0.3e1 / 0.4e1 * t595 * t4629 * t302 - t7 * t2004 * t881 * t2010 / 0.128e3 + t4642 * t2013 / 0.16e2 - 0.3e1 / 0.8e1 * t595 * t1818 * t755 - 0.3e1 / 0.8e1 * t595 * t1818 * t759 + 0.3e1 / 0.4e1 * t595 * t5264 * t473 * t887 - t4655 * t2105 * t4093 / 0.4e1 + 0.3e1 / 0.2e1 * t3869 * t3870 * t302 * t813 + 0.3e1 / 0.4e1 * t595 * t1824 * t887 * t1992 + 0.5e1 / 0.192e3 * t138 * t148 * t885 * t2194 * t3857 * t2009 - t2111 * t2116 * t4093 / 0.8e1 + 0.3e1 / 0.8e1 * t595 * t886 * t96 * t754 * t125 + 0.3e1 / 0.8e1 * t595 * t886 * t96 * t758 * t125;
  t5300 = my_piecewise3(t3, 0, t5299);
  tv4sigma2tau20 = 0.2e1 * rho[0] * t5300;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  t5334 = 0.219e3 / 0.4e3 * t1783 * t2085 - 0.478953e6 / 0.2e2 * t4730 * t2131 * t284 + 0.53217e5 / 0.2e3 * t1790 * t2127 * t284 - 0.17739e5 / 0.2e3 * t4737 * t2076 - 0.73e2 / 0.4e3 * t4767 * t805 - 0.73e2 / 0.1944e6 * t4811 * t284 - t289 * t2123 / 0.15e2 + 0.1436859e7 / 0.25e2 * t1002 * t502 * t368 * t1279 - 0.17739e5 / 0.25e2 * t440 * t2079 * t617 + 0.73e2 / 0.25e2 * t195 * t277 * t315 + t2142 * t251 / 0.24e2 + 0.73e2 / 0.1e3 * t1778 * t808 + 0.5913e4 / 0.25e2 * t1337 * t2080;
  t5370 = -0.135e3 / 0.32e2 * t632 * t5135 - 0.675e3 / 0.8e1 * t2048 * t5012 + 0.225e3 * t2150 * t4895 + 0.45e2 / 0.256e3 * t526 * t4788 + 0.567e3 / 0.64e2 * t2300 * t2153 * t267 + 0.675e3 / 0.64e2 * t5146 * t793 - 0.675e3 / 0.8e1 * t4248 * t861 * t83 * t267 - 0.1125e4 / 0.4e1 * t4906 * t46 * t5111 * t4910;
  t5401 = -0.219e3 / 0.1e3 * t653 * t2088 + 0.478953e6 / 0.5e2 * t2615 * t2170 - 0.17739e5 / 0.1e3 * t1182 * t2173 + 0.73e2 / 0.5e2 * t553 * t2176 + 0.73e2 / 0.2e3 * t4599 * t342 + 0.5913e4 / 0.1e3 * t3511 * t873 - 0.219e3 / 0.2e3 * t1622 * t876 - 0.73e2 / 0.972e5 * t5370 * t93 + 0.292e3 / 0.2025e4 * t76 * t5370 + 0.292e3 / 0.2025e4 * t272 * t2158 + 0.292e3 / 0.675e3 * t337 * t2061 + 0.292e3 / 0.675e3 * t796 * t865 - 0.73e2 / 0.1e3 * t658 * t2123 * t284 + (-0.3e1 / 0.4e1 * t236 * t2124 + 0.27e2 / 0.128e3 * t239 * t2128 - 0.207e3 / 0.16384e5 * t503 * t2132 + 0.69e2 / 0.262144e6 * t1167 * t2138 - 0.15e2 / 0.8388608e7 * t2556 * t461 * t4757 * t2257) * t38 * t43 * t51 / 0.24e2;
  t5445 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * (t5334 + t5401) * t349 + t7 * t820 * t2181 * t826 / 0.32e2 - 0.3e1 / 0.8e1 * t595 * t4825 * t302 + 0.9e1 / 0.8e1 * t595 * t2093 * t473 * t2188 - 0.3e1 / 0.16e2 * t138 * t4640 * t1041 * t2188 * t4093 + 0.9e1 / 0.8e1 * t595 * t2186 * t2105 + 0.9e1 / 0.8e1 * t4843 * t1824 * t2116 - 0.9e1 / 0.8e1 * t595 * t4849 * t2198 * t813 + 0.3e1 / 0.32e2 * t138 * t819 * t2192 * t4856 * t4859 * t825 - 0.3e1 / 0.8e1 * t595 * t2195 * t2197 * t301 * t125);
  tv4sigmatau30 = 0.2e1 * rho[0] * t5445;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  t5447 = t865 * t865;
  t5455 = t858 * t858;
  t5464 = -0.45e2 / 0.8e1 * t632 * t4788 + 0.9e3 * t2150 * t5012 + 0.567e3 / 0.64e2 * t2300 * t5455 - 0.675e3 / 0.4e1 * t5146 * t862 + 0.225e4 * t4906 * t46 * t2273 * t4910;
  t5494 = t24 * t376;
  t5523 = 0.292e3 / 0.675e3 * t5447 + 0.1168e4 / 0.2025e4 * t337 * t2158 + 0.292e3 / 0.2025e4 * t76 * t5464 - 0.73e2 / 0.972e5 * t5464 * t93 + 0.73e2 / 0.15e3 * t4811 * t342 + 0.5913e4 / 0.5e2 * t3748 * t873 + 0.957906e6 / 0.25e2 * t2944 * t2170 + 0.38795193e8 / 0.5e1 * t2370 * t921 * t111 * t3780 - 0.4310577e7 / 0.25e2 * t1002 * t2169 * t1735 + 0.5913e4 / 0.4e1 * t440 * t872 * t844 - 0.73e2 / 0.1e2 * t195 * t28 * t376 - 0.219e3 / 0.1e3 * t1778 * t876 - 0.17739e5 / 0.25e2 * t1337 * t2173 + 0.146e3 / 0.25e2 * t653 * t2176 + (0.15e2 / 0.8e1 * t22 * t5494 * t33 - 0.45e2 / 0.128e3 * t147 * t240 * t844 * t153 + 0.549e3 / 0.32768e5 * t374 * t368 * t1735 * t379 - 0.39e2 / 0.131072e6 * t922 * t111 * t3780 * t927 + 0.15e2 / 0.8388608e7 * t2252 * t461 / t843 / t375 * t2257) * t38 * t43 * t51 / 0.24e2 + t102 * t5494 / 0.6e1;
  t5532 = t881 * t881;
  t5543 = t885 * t885;
  t5544 = t472 * t472;
  t5554 = my_piecewise3(t3, 0, -0.3e1 / 0.8e1 * t138 * t19 * t5523 * t349 + 0.3e1 / 0.2e1 * t595 * t2181 * t473 * t2188 + 0.9e1 / 0.8e1 * t595 * t5532 * t473 * t887 - 0.9e1 / 0.4e1 * t595 * t881 * t2194 * t885 * t2197 * t125 + 0.3e1 / 0.8e1 * t595 * t5543 / t5544 / t2196 / params->kappa * t125);
  tv4tau40 = 0.2e1 * rho[0] * t5554;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

}

#endif


#ifndef XC_DONT_COMPILE_EXC
GPU_DEVICE_FUNCTION static inline void
func_exc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t41;
  double t42, t46, t47, t48, t49, t50, t51, t52;
  double t53, t54, t56, t57, t61, t63, t65, t69;
  double t70, t71, t72, t75, t76, t77, t82, t83;
  double t86, t88, t89, t90, t91, t93, t97, t98;
  double t101, t102, t103, t107, t108, t111, t112, t113;
  double t114, t115, t116, t117, t121, t122, t125, t126;
  double t127, t130, t133, t137, t138, t139, t141, t142;
  double t143, t144, t146, t147, t148, t149, t150, t151;
  double t152, t153, t154, t155, t156, t158, t159, t160;
  double t161, t165, t166, t167, t168, t170, t171, t175;
  double t177, t179, t183, t184, t185, t188, t189, t190;
  double t195, t196, t199, t200, t202, t206, t207, t210;
  double t214, t217, t218, t219, t220, t224, t227, t228;
  double t229, t232, t235, t239, tzk0;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = sigma[0] * sigma[0];
  t30 = params->c * t29;
  t31 = rho[0] * rho[0];
  t32 = 0.1e1 / t31;
  t33 = tau[0] * tau[0];
  t34 = 0.1e1 / t33;
  t35 = t32 * t34;
  t36 = t29 * t32;
  t37 = t36 * t34;
  t39 = 0.1e1 + t37 / 0.64e2;
  t40 = t39 * t39;
  t41 = 0.1e1 / t40;
  t42 = t35 * t41;
  t46 = M_CBRT6;
  t47 = (0.1e2 / 0.81e2 + t30 * t42 / 0.64e2) * t46;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t51 * sigma[0];
  t53 = POW_1_3(rho[0]);
  t54 = t53 * t53;
  t56 = 0.1e1 / t54 / t31;
  t57 = t52 * t56;
  t61 = 0.1e1 / t54 / rho[0];
  t63 = sigma[0] * t56;
  t65 = tau[0] * t61 - t63 / 0.8e1;
  t69 = 0.5e1 / 0.9e1 * t65 * t46 * t51 - 0.1e1;
  t70 = params->b * t65;
  t71 = t46 * t51;
  t72 = t71 * t69;
  t75 = 0.5e1 * t70 * t72 + 0.9e1;
  t76 = sqrt(t75);
  t77 = 0.1e1 / t76;
  t82 = 0.27e2 / 0.2e2 * t69 * t77 + t71 * t63 / 0.36e2;
  t83 = t82 * t82;
  t86 = t46 * t46;
  t88 = 0.1e1 / t49 / t48;
  t89 = t86 * t88;
  t90 = t31 * t31;
  t91 = t90 * rho[0];
  t93 = 0.1e1 / t53 / t91;
  t97 = 0.5e2 * t89 * t29 * t93 + 0.162e3 * t37;
  t98 = sqrt(t97);
  t101 = 0.1e1 / params->kappa;
  t102 = t101 * t86;
  t103 = t88 * t29;
  t107 = sqrt(params->e);
  t108 = t107 * t29;
  t111 = params->e * params->mu;
  t112 = t48 * t48;
  t113 = 0.1e1 / t112;
  t114 = t29 * sigma[0];
  t115 = t113 * t114;
  t116 = t90 * t90;
  t117 = 0.1e1 / t116;
  t121 = t47 * t57 / 0.24e2 + 0.146e3 / 0.2025e4 * t83 - 0.73e2 / 0.972e5 * t82 * t98 + 0.25e2 / 0.944784e6 * t102 * t103 * t93 + t108 * t35 / 0.72e3 + t111 * t115 * t117 / 0.2304e4;
  t122 = t107 * t46;
  t125 = 0.1e1 + t122 * t57 / 0.24e2;
  t126 = t125 * t125;
  t127 = 0.1e1 / t126;
  t130 = exp(-t121 * t127 * t101);
  t133 = 0.1e1 + params->kappa * (0.1e1 - t130);
  t137 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t133);
  t138 = rho[1] <= p->dens_threshold;
  t139 = -t17;
  t141 = my_piecewise5(t15, t12, t11, t16, t139 * t8);
  t142 = 0.1e1 + t141;
  t143 = t142 <= p->zeta_threshold;
  t144 = POW_1_3(t142);
  t146 = my_piecewise3(t143, t23, t144 * t142);
  t147 = t146 * t27;
  t148 = sigma[2] * sigma[2];
  t149 = params->c * t148;
  t150 = rho[1] * rho[1];
  t151 = 0.1e1 / t150;
  t152 = tau[1] * tau[1];
  t153 = 0.1e1 / t152;
  t154 = t151 * t153;
  t155 = t148 * t151;
  t156 = t155 * t153;
  t158 = 0.1e1 + t156 / 0.64e2;
  t159 = t158 * t158;
  t160 = 0.1e1 / t159;
  t161 = t154 * t160;
  t165 = (0.1e2 / 0.81e2 + t149 * t161 / 0.64e2) * t46;
  t166 = t51 * sigma[2];
  t167 = POW_1_3(rho[1]);
  t168 = t167 * t167;
  t170 = 0.1e1 / t168 / t150;
  t171 = t166 * t170;
  t175 = 0.1e1 / t168 / rho[1];
  t177 = sigma[2] * t170;
  t179 = tau[1] * t175 - t177 / 0.8e1;
  t183 = 0.5e1 / 0.9e1 * t179 * t46 * t51 - 0.1e1;
  t184 = params->b * t179;
  t185 = t71 * t183;
  t188 = 0.5e1 * t184 * t185 + 0.9e1;
  t189 = sqrt(t188);
  t190 = 0.1e1 / t189;
  t195 = 0.27e2 / 0.2e2 * t183 * t190 + t71 * t177 / 0.36e2;
  t196 = t195 * t195;
  t199 = t150 * t150;
  t200 = t199 * rho[1];
  t202 = 0.1e1 / t167 / t200;
  t206 = 0.5e2 * t89 * t148 * t202 + 0.162e3 * t156;
  t207 = sqrt(t206);
  t210 = t88 * t148;
  t214 = t107 * t148;
  t217 = t148 * sigma[2];
  t218 = t113 * t217;
  t219 = t199 * t199;
  t220 = 0.1e1 / t219;
  t224 = t165 * t171 / 0.24e2 + 0.146e3 / 0.2025e4 * t196 - 0.73e2 / 0.972e5 * t195 * t207 + 0.25e2 / 0.944784e6 * t102 * t210 * t202 + t214 * t154 / 0.72e3 + t111 * t218 * t220 / 0.2304e4;
  t227 = 0.1e1 + t122 * t171 / 0.24e2;
  t228 = t227 * t227;
  t229 = 0.1e1 / t228;
  t232 = exp(-t224 * t229 * t101);
  t235 = 0.1e1 + params->kappa * (0.1e1 - t232);
  t239 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t147 * t235);
  tzk0 = t137 + t239;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

}

#endif


#ifndef XC_DONT_COMPILE_VXC
GPU_DEVICE_FUNCTION static inline void
func_vxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t41;
  double t42, t46, t47, t48, t49, t50, t51, t52;
  double t53, t54, t56, t57, t61, t63, t65, t69;
  double t70, t71, t72, t75, t76, t77, t82, t83;
  double t86, t88, t89, t90, t91, t93, t97, t98;
  double t101, t102, t103, t107, t108, t111, t112, t113;
  double t114, t115, t116, t117, t121, t122, t125, t126;
  double t127, t130, t133, t137, t138, t139, t141, t142;
  double t143, t144, t146, t147, t148, t149, t150, t151;
  double t152, t153, t154, t155, t156, t158, t159, t160;
  double t161, t165, t166, t167, t168, t170, t171, t175;
  double t177, t179, t183, t184, t185, t188, t189, t190;
  double t195, t196, t199, t200, t202, t206, t207, t210;
  double t214, t217, t218, t219, t220, t224, t227, t228;
  double t229, t232, t235, t239, tzk0;

  double t240, t241, t242, t244, t247, t248, t252, t253;
  double t254, t257, t258, t259, t260, t261, t262, t263;
  double t266, t267, t268, t269, t270, t273, t274, t278;
  double t282, t283, t288, t290, t291, t292, t296, t297;
  double t301, t304, t307, t309, t314, t315, t316, t319;
  double t321, t325, t333, t334, t338, t341, t342, t343;
  double t344, t345, t348, t349, t350, t354, t355, t357;
  double t360, t361, t365, t368, t370, tvrho0, t374, t377;
  double t378, t383, t385, t388, t389, t393, t394, t395;
  double t396, t397, t400, t401, t402, t403, t404, t407;
  double t408, t412, t416, t417, t422, t424, t425, t426;
  double t430, t431, t435, t438, t441, t443, t448, t449;
  double t450, t453, t455, t459, t467, t468, t472, t475;
  double t476, t477, t478, t481, t482, t483, t487, tvrho1;
  double t490, t493, t494, t495, t496, t500, t503, t506;
  double t507, t509, t510, t513, t515, t518, t520, t525;
  double t531, t534, t538, t541, t545, t548, t549, t552;
  double t553, t554, t557, tvsigma0, tvsigma1, t558, t561, t562;
  double t563, t564, t568, t571, t574, t575, t577, t578;
  double t581, t583, t586, t588, t593, t599, t602, t606;
  double t609, t613, t616, t617, t620, t621, t622, t625;
  double tvsigma2, tvlapl0, tvlapl1, t626, t627, t628, t629, t632;
  double t633, t635, t639, t642, t645, t651, t654, t659;
  double t664, t665, t666, t667, t670, tvtau0, t671, t672;
  double t673, t674, t677, t678, t680, t684, t687, t690;
  double t696, t699, t704, t709, t710, t711, t712, t715;
  double tvtau1;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = sigma[0] * sigma[0];
  t30 = params->c * t29;
  t31 = rho[0] * rho[0];
  t32 = 0.1e1 / t31;
  t33 = tau[0] * tau[0];
  t34 = 0.1e1 / t33;
  t35 = t32 * t34;
  t36 = t29 * t32;
  t37 = t36 * t34;
  t39 = 0.1e1 + t37 / 0.64e2;
  t40 = t39 * t39;
  t41 = 0.1e1 / t40;
  t42 = t35 * t41;
  t46 = M_CBRT6;
  t47 = (0.1e2 / 0.81e2 + t30 * t42 / 0.64e2) * t46;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t51 * sigma[0];
  t53 = POW_1_3(rho[0]);
  t54 = t53 * t53;
  t56 = 0.1e1 / t54 / t31;
  t57 = t52 * t56;
  t61 = 0.1e1 / t54 / rho[0];
  t63 = sigma[0] * t56;
  t65 = tau[0] * t61 - t63 / 0.8e1;
  t69 = 0.5e1 / 0.9e1 * t65 * t46 * t51 - 0.1e1;
  t70 = params->b * t65;
  t71 = t46 * t51;
  t72 = t71 * t69;
  t75 = 0.5e1 * t70 * t72 + 0.9e1;
  t76 = sqrt(t75);
  t77 = 0.1e1 / t76;
  t82 = 0.27e2 / 0.2e2 * t69 * t77 + t71 * t63 / 0.36e2;
  t83 = t82 * t82;
  t86 = t46 * t46;
  t88 = 0.1e1 / t49 / t48;
  t89 = t86 * t88;
  t90 = t31 * t31;
  t91 = t90 * rho[0];
  t93 = 0.1e1 / t53 / t91;
  t97 = 0.5e2 * t89 * t29 * t93 + 0.162e3 * t37;
  t98 = sqrt(t97);
  t101 = 0.1e1 / params->kappa;
  t102 = t101 * t86;
  t103 = t88 * t29;
  t107 = sqrt(params->e);
  t108 = t107 * t29;
  t111 = params->e * params->mu;
  t112 = t48 * t48;
  t113 = 0.1e1 / t112;
  t114 = t29 * sigma[0];
  t115 = t113 * t114;
  t116 = t90 * t90;
  t117 = 0.1e1 / t116;
  t121 = t47 * t57 / 0.24e2 + 0.146e3 / 0.2025e4 * t83 - 0.73e2 / 0.972e5 * t82 * t98 + 0.25e2 / 0.944784e6 * t102 * t103 * t93 + t108 * t35 / 0.72e3 + t111 * t115 * t117 / 0.2304e4;
  t122 = t107 * t46;
  t125 = 0.1e1 + t122 * t57 / 0.24e2;
  t126 = t125 * t125;
  t127 = 0.1e1 / t126;
  t130 = exp(-t121 * t127 * t101);
  t133 = 0.1e1 + params->kappa * (0.1e1 - t130);
  t137 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t133);
  t138 = rho[1] <= p->dens_threshold;
  t139 = -t17;
  t141 = my_piecewise5(t15, t12, t11, t16, t139 * t8);
  t142 = 0.1e1 + t141;
  t143 = t142 <= p->zeta_threshold;
  t144 = POW_1_3(t142);
  t146 = my_piecewise3(t143, t23, t144 * t142);
  t147 = t146 * t27;
  t148 = sigma[2] * sigma[2];
  t149 = params->c * t148;
  t150 = rho[1] * rho[1];
  t151 = 0.1e1 / t150;
  t152 = tau[1] * tau[1];
  t153 = 0.1e1 / t152;
  t154 = t151 * t153;
  t155 = t148 * t151;
  t156 = t155 * t153;
  t158 = 0.1e1 + t156 / 0.64e2;
  t159 = t158 * t158;
  t160 = 0.1e1 / t159;
  t161 = t154 * t160;
  t165 = (0.1e2 / 0.81e2 + t149 * t161 / 0.64e2) * t46;
  t166 = t51 * sigma[2];
  t167 = POW_1_3(rho[1]);
  t168 = t167 * t167;
  t170 = 0.1e1 / t168 / t150;
  t171 = t166 * t170;
  t175 = 0.1e1 / t168 / rho[1];
  t177 = sigma[2] * t170;
  t179 = tau[1] * t175 - t177 / 0.8e1;
  t183 = 0.5e1 / 0.9e1 * t179 * t46 * t51 - 0.1e1;
  t184 = params->b * t179;
  t185 = t71 * t183;
  t188 = 0.5e1 * t184 * t185 + 0.9e1;
  t189 = sqrt(t188);
  t190 = 0.1e1 / t189;
  t195 = 0.27e2 / 0.2e2 * t183 * t190 + t71 * t177 / 0.36e2;
  t196 = t195 * t195;
  t199 = t150 * t150;
  t200 = t199 * rho[1];
  t202 = 0.1e1 / t167 / t200;
  t206 = 0.5e2 * t89 * t148 * t202 + 0.162e3 * t156;
  t207 = sqrt(t206);
  t210 = t88 * t148;
  t214 = t107 * t148;
  t217 = t148 * sigma[2];
  t218 = t113 * t217;
  t219 = t199 * t199;
  t220 = 0.1e1 / t219;
  t224 = t165 * t171 / 0.24e2 + 0.146e3 / 0.2025e4 * t196 - 0.73e2 / 0.972e5 * t195 * t207 + 0.25e2 / 0.944784e6 * t102 * t210 * t202 + t214 * t154 / 0.72e3 + t111 * t218 * t220 / 0.2304e4;
  t227 = 0.1e1 + t122 * t171 / 0.24e2;
  t228 = t227 * t227;
  t229 = 0.1e1 / t228;
  t232 = exp(-t224 * t229 * t101);
  t235 = 0.1e1 + params->kappa * (0.1e1 - t232);
  t239 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t147 * t235);
  tzk0 = t137 + t239;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t240 = t7 * t7;
  t241 = 0.1e1 / t240;
  t242 = t17 * t241;
  t244 = my_piecewise5(t11, 0, t15, 0, t8 - t242);
  t247 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t244);
  t248 = t247 * t27;
  t252 = t27 * t27;
  t253 = 0.1e1 / t252;
  t254 = t26 * t253;
  t257 = t6 * t254 * t133 / 0.8e1;
  t258 = t6 * t26;
  t259 = t27 * params->kappa;
  t260 = t31 * rho[0];
  t261 = 0.1e1 / t260;
  t262 = t261 * t34;
  t263 = t262 * t41;
  t266 = t29 * t29;
  t267 = params->c * t266;
  t268 = 0.1e1 / t91;
  t269 = t33 * t33;
  t270 = 0.1e1 / t269;
  t273 = 0.1e1 / t40 / t39;
  t274 = t268 * t270 * t273;
  t278 = (-t30 * t263 / 0.32e2 + t267 * t274 / 0.1024e4) * t46;
  t282 = 0.1e1 / t54 / t260;
  t283 = t52 * t282;
  t288 = sigma[0] * t282;
  t290 = -0.5e1 / 0.3e1 * tau[0] * t56 + t288 / 0.3e1;
  t291 = t290 * t46;
  t292 = t51 * t77;
  t296 = 0.1e1 / t76 / t75;
  t297 = t69 * t296;
  t301 = t89 * t290;
  t304 = 0.5e1 * params->b * t290 * t72 + 0.25e2 / 0.9e1 * t70 * t301;
  t307 = t71 * t288;
  t309 = 0.3e1 / 0.4e1 * t291 * t292 - 0.27e2 / 0.4e2 * t297 * t304 - 0.2e1 / 0.27e2 * t307;
  t314 = 0.1e1 / t98;
  t315 = t82 * t314;
  t316 = t29 * t261;
  t319 = t90 * t31;
  t321 = 0.1e1 / t53 / t319;
  t325 = -0.324e3 * t316 * t34 - 0.8e3 / 0.3e1 * t89 * t29 * t321;
  t333 = t116 * rho[0];
  t334 = 0.1e1 / t333;
  t338 = t278 * t57 / 0.24e2 - t47 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t82 * t309 - 0.73e2 / 0.972e5 * t309 * t98 - 0.73e2 / 0.1944e6 * t315 * t325 - 0.25e2 / 0.177147e6 * t102 * t103 * t321 - t108 * t262 / 0.36e3 - t111 * t115 * t334 / 0.288e3;
  t341 = t126 * t125;
  t342 = 0.1e1 / t341;
  t343 = t121 * t342;
  t344 = t101 * t107;
  t345 = t343 * t344;
  t348 = -t338 * t127 * t101 - 0.2e1 / 0.9e1 * t345 * t307;
  t349 = t348 * t130;
  t350 = t259 * t349;
  t354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t248 * t133 - t257 + 0.3e1 / 0.8e1 * t258 * t350);
  t355 = t139 * t241;
  t357 = my_piecewise5(t15, 0, t11, 0, -t8 - t355);
  t360 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t357);
  t361 = t360 * t27;
  t365 = t146 * t253;
  t368 = t6 * t365 * t235 / 0.8e1;
  t370 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t361 * t235 - t368);
  tvrho0 = t137 + t239 + t7 * (t354 + t370);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t374 = my_piecewise5(t11, 0, t15, 0, -t8 - t242);
  t377 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t374);
  t378 = t377 * t27;
  t383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t378 * t133 - t257);
  t385 = my_piecewise5(t15, 0, t11, 0, t8 - t355);
  t388 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t385);
  t389 = t388 * t27;
  t393 = t6 * t146;
  t394 = t150 * rho[1];
  t395 = 0.1e1 / t394;
  t396 = t395 * t153;
  t397 = t396 * t160;
  t400 = t148 * t148;
  t401 = params->c * t400;
  t402 = 0.1e1 / t200;
  t403 = t152 * t152;
  t404 = 0.1e1 / t403;
  t407 = 0.1e1 / t159 / t158;
  t408 = t402 * t404 * t407;
  t412 = (-t149 * t397 / 0.32e2 + t401 * t408 / 0.1024e4) * t46;
  t416 = 0.1e1 / t168 / t394;
  t417 = t166 * t416;
  t422 = sigma[2] * t416;
  t424 = -0.5e1 / 0.3e1 * tau[1] * t170 + t422 / 0.3e1;
  t425 = t424 * t46;
  t426 = t51 * t190;
  t430 = 0.1e1 / t189 / t188;
  t431 = t183 * t430;
  t435 = t89 * t424;
  t438 = 0.5e1 * params->b * t424 * t185 + 0.25e2 / 0.9e1 * t184 * t435;
  t441 = t71 * t422;
  t443 = 0.3e1 / 0.4e1 * t425 * t426 - 0.27e2 / 0.4e2 * t431 * t438 - 0.2e1 / 0.27e2 * t441;
  t448 = 0.1e1 / t207;
  t449 = t195 * t448;
  t450 = t148 * t395;
  t453 = t199 * t150;
  t455 = 0.1e1 / t167 / t453;
  t459 = -0.324e3 * t450 * t153 - 0.8e3 / 0.3e1 * t89 * t148 * t455;
  t467 = t219 * rho[1];
  t468 = 0.1e1 / t467;
  t472 = t412 * t171 / 0.24e2 - t165 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t195 * t443 - 0.73e2 / 0.972e5 * t443 * t207 - 0.73e2 / 0.1944e6 * t449 * t459 - 0.25e2 / 0.177147e6 * t102 * t210 * t455 - t214 * t396 / 0.36e3 - t111 * t218 * t468 / 0.288e3;
  t475 = t228 * t227;
  t476 = 0.1e1 / t475;
  t477 = t224 * t476;
  t478 = t477 * t344;
  t481 = -t472 * t229 * t101 - 0.2e1 / 0.9e1 * t478 * t441;
  t482 = t481 * t232;
  t483 = t259 * t482;
  t487 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t389 * t235 - t368 + 0.3e1 / 0.8e1 * t393 * t483);
  tvrho1 = t137 + t239 + t7 * (t383 + t487);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t490 = params->c * sigma[0];
  t493 = params->c * t114;
  t494 = 0.1e1 / t90;
  t495 = t494 * t270;
  t496 = t495 * t273;
  t500 = (t490 * t42 / 0.32e2 - t493 * t496 / 0.1024e4) * t46;
  t503 = t51 * t56;
  t506 = t56 * t46;
  t507 = t506 * t292;
  t509 = params->b * t56;
  t510 = t509 * t72;
  t513 = t70 * t89 * t56;
  t515 = -0.5e1 / 0.8e1 * t510 - 0.25e2 / 0.72e2 * t513;
  t518 = t506 * t51;
  t520 = -0.3e1 / 0.32e2 * t507 - 0.27e2 / 0.4e2 * t297 * t515 + t518 / 0.36e2;
  t525 = sigma[0] * t32;
  t531 = 0.1e3 * t89 * sigma[0] * t93 + 0.324e3 * t525 * t34;
  t534 = t88 * sigma[0];
  t538 = t107 * sigma[0];
  t541 = t113 * t29;
  t545 = t500 * t57 / 0.24e2 + t47 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t520 - 0.73e2 / 0.972e5 * t520 * t98 - 0.73e2 / 0.1944e6 * t315 * t531 + 0.25e2 / 0.472392e6 * t102 * t534 * t93 + t538 * t35 / 0.36e3 + t111 * t541 * t117 / 0.768e3;
  t548 = t343 * t101;
  t549 = t122 * t503;
  t552 = -t545 * t127 * t101 + t548 * t549 / 0.12e2;
  t553 = t552 * t130;
  t554 = t259 * t553;
  t557 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t554);
  tvsigma0 = t7 * t557;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t558 = params->c * sigma[2];
  t561 = params->c * t217;
  t562 = 0.1e1 / t199;
  t563 = t562 * t404;
  t564 = t563 * t407;
  t568 = (t558 * t161 / 0.32e2 - t561 * t564 / 0.1024e4) * t46;
  t571 = t51 * t170;
  t574 = t170 * t46;
  t575 = t574 * t426;
  t577 = params->b * t170;
  t578 = t577 * t185;
  t581 = t184 * t89 * t170;
  t583 = -0.5e1 / 0.8e1 * t578 - 0.25e2 / 0.72e2 * t581;
  t586 = t574 * t51;
  t588 = -0.3e1 / 0.32e2 * t575 - 0.27e2 / 0.4e2 * t431 * t583 + t586 / 0.36e2;
  t593 = sigma[2] * t151;
  t599 = 0.1e3 * t89 * sigma[2] * t202 + 0.324e3 * t593 * t153;
  t602 = t88 * sigma[2];
  t606 = t107 * sigma[2];
  t609 = t113 * t148;
  t613 = t568 * t171 / 0.24e2 + t165 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t588 - 0.73e2 / 0.972e5 * t588 * t207 - 0.73e2 / 0.1944e6 * t449 * t599 + 0.25e2 / 0.472392e6 * t102 * t602 * t202 + t606 * t154 / 0.36e3 + t111 * t609 * t220 / 0.768e3;
  t616 = t477 * t101;
  t617 = t122 * t571;
  t620 = -t613 * t229 * t101 + t616 * t617 / 0.12e2;
  t621 = t620 * t232;
  t622 = t259 * t621;
  t625 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t622);
  tvsigma2 = t7 * t625;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t626 = t33 * tau[0];
  t627 = 0.1e1 / t626;
  t628 = t32 * t627;
  t629 = t628 * t41;
  t632 = t269 * tau[0];
  t633 = 0.1e1 / t632;
  t635 = t494 * t633 * t273;
  t639 = (-t30 * t629 / 0.32e2 + t267 * t635 / 0.1024e4) * t46;
  t642 = t61 * t46;
  t645 = params->b * t61;
  t651 = 0.5e1 * t645 * t72 + 0.25e2 / 0.9e1 * t70 * t89 * t61;
  t654 = 0.3e1 / 0.4e1 * t642 * t292 - 0.27e2 / 0.4e2 * t297 * t651;
  t659 = t36 * t627;
  t664 = t639 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t654 - 0.73e2 / 0.972e5 * t654 * t98 + 0.73e2 / 0.6e3 * t315 * t659 - t108 * t628 / 0.36e3;
  t665 = t27 * t664;
  t666 = t127 * t130;
  t667 = t665 * t666;
  t670 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t667);
  tvtau0 = t7 * t670;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t671 = t152 * tau[1];
  t672 = 0.1e1 / t671;
  t673 = t151 * t672;
  t674 = t673 * t160;
  t677 = t403 * tau[1];
  t678 = 0.1e1 / t677;
  t680 = t562 * t678 * t407;
  t684 = (-t149 * t674 / 0.32e2 + t401 * t680 / 0.1024e4) * t46;
  t687 = t175 * t46;
  t690 = params->b * t175;
  t696 = 0.5e1 * t690 * t185 + 0.25e2 / 0.9e1 * t184 * t89 * t175;
  t699 = 0.3e1 / 0.4e1 * t687 * t426 - 0.27e2 / 0.4e2 * t431 * t696;
  t704 = t155 * t672;
  t709 = t684 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t699 - 0.73e2 / 0.972e5 * t699 * t207 + 0.73e2 / 0.6e3 * t449 * t704 - t214 * t673 / 0.36e3;
  t710 = t27 * t709;
  t711 = t229 * t232;
  t712 = t710 * t711;
  t715 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t712);
  tvtau1 = t7 * t715;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

}

#endif


#ifndef XC_DONT_COMPILE_FXC
GPU_DEVICE_FUNCTION static inline void
func_fxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t41;
  double t42, t46, t47, t48, t49, t50, t51, t52;
  double t53, t54, t56, t57, t61, t63, t65, t69;
  double t70, t71, t72, t75, t76, t77, t82, t83;
  double t86, t88, t89, t90, t91, t93, t97, t98;
  double t101, t102, t103, t107, t108, t111, t112, t113;
  double t114, t115, t116, t117, t121, t122, t125, t126;
  double t127, t130, t133, t137, t138, t139, t141, t142;
  double t143, t144, t146, t147, t148, t149, t150, t151;
  double t152, t153, t154, t155, t156, t158, t159, t160;
  double t161, t165, t166, t167, t168, t170, t171, t175;
  double t177, t179, t183, t184, t185, t188, t189, t190;
  double t195, t196, t199, t200, t202, t206, t207, t210;
  double t214, t217, t218, t219, t220, t224, t227, t228;
  double t229, t232, t235, t239, tzk0;

  double t240, t241, t242, t244, t247, t248, t252, t253;
  double t254, t257, t258, t259, t260, t261, t262, t263;
  double t266, t267, t268, t269, t270, t273, t274, t278;
  double t282, t283, t288, t290, t291, t292, t296, t297;
  double t301, t304, t307, t309, t314, t315, t316, t319;
  double t321, t325, t333, t334, t338, t341, t342, t343;
  double t344, t345, t348, t349, t350, t354, t355, t357;
  double t360, t361, t365, t368, t370, tvrho0, t374, t377;
  double t378, t383, t385, t388, t389, t393, t394, t395;
  double t396, t397, t400, t401, t402, t403, t404, t407;
  double t408, t412, t416, t417, t422, t424, t425, t426;
  double t430, t431, t435, t438, t441, t443, t448, t449;
  double t450, t453, t455, t459, t467, t468, t472, t475;
  double t476, t477, t478, t481, t482, t483, t487, tvrho1;
  double t490, t493, t494, t495, t496, t500, t503, t506;
  double t507, t509, t510, t513, t515, t518, t520, t525;
  double t531, t534, t538, t541, t545, t548, t549, t552;
  double t553, t554, t557, tvsigma0, tvsigma1, t558, t561, t562;
  double t563, t564, t568, t571, t574, t575, t577, t578;
  double t581, t583, t586, t588, t593, t599, t602, t606;
  double t609, t613, t616, t617, t620, t621, t622, t625;
  double tvsigma2, tvlapl0, tvlapl1, t626, t627, t628, t629, t632;
  double t633, t635, t639, t642, t645, t651, t654, t659;
  double t664, t665, t666, t667, t670, tvtau0, t671, t672;
  double t673, t674, t677, t678, t680, t684, t687, t690;
  double t696, t699, t704, t709, t710, t711, t712, t715;
  double tvtau1;

  double t718, t719, t720, t723, t724, t725, t728, t732;
  double t733, t737, t739, t741, t745, t746, t749, t750;
  double t751, t752, t754, t755, t758, t760, t763, t764;
  double t765, t766, t768, t769, t770, t774, t780, t781;
  double t784, t788, t790, t791, t794, t795, t798, t800;
  double t801, t802, t805, t808, t812, t815, t818, t820;
  double t825, t829, t830, t831, t834, t837, t839, t841;
  double t843, t846, t851, t852, t856, t859, t860, t863;
  double t864, t865, t866, t867, t872, t873, t874, t877;
  double t878, t879, t883, t884, t885, t886, t889, t892;
  double t896, t897, t901, t903, t905, t908, t910, tv2rho20;
  double t913, t917, t921, t922, t926, t928, t930, t936;
  double t937, t941, t945, t946, t950, t952, t955, t958;
  double t959, t962, tv2rho21, t967, t972, t976, t977, t983;
  double t984, t989, t993, t994, t999, t1003, t1004, t1007;
  double t1009, t1012, t1013, t1014, t1015, t1017, t1018, t1019;
  double t1023, t1029, t1030, t1033, t1037, t1039, t1040, t1043;
  double t1044, t1047, t1049, t1050, t1051, t1054, t1057, t1061;
  double t1064, t1067, t1069, t1074, t1078, t1079, t1080, t1083;
  double t1086, t1088, t1090, t1092, t1095, t1100, t1101, t1105;
  double t1108, t1109, t1112, t1113, t1114, t1115, t1120, t1121;
  double t1122, t1125, t1126, t1127, t1131, tv2rho22, t1136, t1138;
  double t1143, t1144, t1145, t1147, t1151, t1158, t1163, t1164;
  double t1166, t1168, t1171, t1174, t1175, t1177, t1180, t1182;
  double t1185, t1187, t1192, t1197, t1200, t1204, t1206, t1209;
  double t1217, t1220, t1221, t1224, t1229, t1232, t1233, t1234;
  double t1237, t1238, t1239, t1243, tv2rhosigma0, tv2rhosigma1, t1247, t1249;
  double t1251, tv2rhosigma2, t1256, tv2rhosigma3, tv2rhosigma4, t1264, t1265, t1266;
  double t1268, t1272, t1279, t1284, t1285, t1287, t1289, t1292;
  double t1295, t1296, t1298, t1301, t1303, t1306, t1308, t1313;
  double t1318, t1321, t1325, t1327, t1330, t1338, t1341, t1342;
  double t1345, t1350, t1353, t1354, t1355, t1358, t1359, t1360;
  double t1364, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1368, t1369;
  double t1371, t1372, t1373, t1377, t1381, t1383, t1387, t1397;
  double t1400, t1407, t1410, t1415, t1420, t1421, t1424, t1429;
  double t1430, t1431, t1434, t1435, t1437, t1438, t1441, t1442;
  double t1446, tv2rhotau0, t1450, t1451, t1453, t1455, tv2rhotau1, t1460;
  double tv2rhotau2, t1464, t1465, t1469, t1473, t1475, t1479, t1489;
  double t1492, t1499, t1502, t1507, t1512, t1513, t1516, t1521;
  double t1522, t1523, t1526, t1527, t1529, t1530, t1533, t1534;
  double t1538, tv2rhotau3, t1540, t1541, t1546, t1547, t1551, t1556;
  double t1558, t1560, t1563, t1564, t1565, t1567, t1574, t1579;
  double t1582, t1585, t1588, t1592, t1595, t1598, t1599, t1600;
  double t1603, t1604, t1605, t1607, t1608, t1609, t1613, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1614, t1615, t1620, t1621;
  double t1625, t1630, t1632, t1634, t1637, t1638, t1639, t1641;
  double t1648, t1653, t1656, t1659, t1662, t1666, t1669, t1672;
  double t1673, t1676, t1677, t1678, t1680, t1681, t1682, t1686;
  double tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1692;
  double t1696, t1705, t1707, t1711, t1712, t1714, t1716, t1725;
  double t1728, t1733, t1734, t1735, t1738, t1739, t1741, t1742;
  double t1745, t1749, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1755;
  double t1759, t1768, t1770, t1774, t1775, t1777, t1779, t1788;
  double t1791, t1796, t1797, t1798, t1801, t1802, t1804, t1805;
  double t1808, t1812, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, t1813, t1814, t1817, t1818, t1821, t1822;
  double t1824, t1828, t1831, t1835, t1839, t1840, t1844, t1851;
  double t1852, t1855, t1860, t1861, t1862, t1864, t1865, t1866;
  double t1867, t1871, tv2tau20, tv2tau21, t1872, t1873, t1876, t1877;
  double t1880, t1881, t1883, t1887, t1890, t1894, t1898, t1899;
  double t1903, t1910, t1911, t1914, t1919, t1920, t1921, t1923;
  double t1924, t1925, t1926, t1930, tv2tau22;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = sigma[0] * sigma[0];
  t30 = params->c * t29;
  t31 = rho[0] * rho[0];
  t32 = 0.1e1 / t31;
  t33 = tau[0] * tau[0];
  t34 = 0.1e1 / t33;
  t35 = t32 * t34;
  t36 = t29 * t32;
  t37 = t36 * t34;
  t39 = 0.1e1 + t37 / 0.64e2;
  t40 = t39 * t39;
  t41 = 0.1e1 / t40;
  t42 = t35 * t41;
  t46 = M_CBRT6;
  t47 = (0.1e2 / 0.81e2 + t30 * t42 / 0.64e2) * t46;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t51 * sigma[0];
  t53 = POW_1_3(rho[0]);
  t54 = t53 * t53;
  t56 = 0.1e1 / t54 / t31;
  t57 = t52 * t56;
  t61 = 0.1e1 / t54 / rho[0];
  t63 = sigma[0] * t56;
  t65 = tau[0] * t61 - t63 / 0.8e1;
  t69 = 0.5e1 / 0.9e1 * t65 * t46 * t51 - 0.1e1;
  t70 = params->b * t65;
  t71 = t46 * t51;
  t72 = t71 * t69;
  t75 = 0.5e1 * t70 * t72 + 0.9e1;
  t76 = sqrt(t75);
  t77 = 0.1e1 / t76;
  t82 = 0.27e2 / 0.2e2 * t69 * t77 + t71 * t63 / 0.36e2;
  t83 = t82 * t82;
  t86 = t46 * t46;
  t88 = 0.1e1 / t49 / t48;
  t89 = t86 * t88;
  t90 = t31 * t31;
  t91 = t90 * rho[0];
  t93 = 0.1e1 / t53 / t91;
  t97 = 0.5e2 * t89 * t29 * t93 + 0.162e3 * t37;
  t98 = sqrt(t97);
  t101 = 0.1e1 / params->kappa;
  t102 = t101 * t86;
  t103 = t88 * t29;
  t107 = sqrt(params->e);
  t108 = t107 * t29;
  t111 = params->e * params->mu;
  t112 = t48 * t48;
  t113 = 0.1e1 / t112;
  t114 = t29 * sigma[0];
  t115 = t113 * t114;
  t116 = t90 * t90;
  t117 = 0.1e1 / t116;
  t121 = t47 * t57 / 0.24e2 + 0.146e3 / 0.2025e4 * t83 - 0.73e2 / 0.972e5 * t82 * t98 + 0.25e2 / 0.944784e6 * t102 * t103 * t93 + t108 * t35 / 0.72e3 + t111 * t115 * t117 / 0.2304e4;
  t122 = t107 * t46;
  t125 = 0.1e1 + t122 * t57 / 0.24e2;
  t126 = t125 * t125;
  t127 = 0.1e1 / t126;
  t130 = exp(-t121 * t127 * t101);
  t133 = 0.1e1 + params->kappa * (0.1e1 - t130);
  t137 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t133);
  t138 = rho[1] <= p->dens_threshold;
  t139 = -t17;
  t141 = my_piecewise5(t15, t12, t11, t16, t139 * t8);
  t142 = 0.1e1 + t141;
  t143 = t142 <= p->zeta_threshold;
  t144 = POW_1_3(t142);
  t146 = my_piecewise3(t143, t23, t144 * t142);
  t147 = t146 * t27;
  t148 = sigma[2] * sigma[2];
  t149 = params->c * t148;
  t150 = rho[1] * rho[1];
  t151 = 0.1e1 / t150;
  t152 = tau[1] * tau[1];
  t153 = 0.1e1 / t152;
  t154 = t151 * t153;
  t155 = t148 * t151;
  t156 = t155 * t153;
  t158 = 0.1e1 + t156 / 0.64e2;
  t159 = t158 * t158;
  t160 = 0.1e1 / t159;
  t161 = t154 * t160;
  t165 = (0.1e2 / 0.81e2 + t149 * t161 / 0.64e2) * t46;
  t166 = t51 * sigma[2];
  t167 = POW_1_3(rho[1]);
  t168 = t167 * t167;
  t170 = 0.1e1 / t168 / t150;
  t171 = t166 * t170;
  t175 = 0.1e1 / t168 / rho[1];
  t177 = sigma[2] * t170;
  t179 = tau[1] * t175 - t177 / 0.8e1;
  t183 = 0.5e1 / 0.9e1 * t179 * t46 * t51 - 0.1e1;
  t184 = params->b * t179;
  t185 = t71 * t183;
  t188 = 0.5e1 * t184 * t185 + 0.9e1;
  t189 = sqrt(t188);
  t190 = 0.1e1 / t189;
  t195 = 0.27e2 / 0.2e2 * t183 * t190 + t71 * t177 / 0.36e2;
  t196 = t195 * t195;
  t199 = t150 * t150;
  t200 = t199 * rho[1];
  t202 = 0.1e1 / t167 / t200;
  t206 = 0.5e2 * t89 * t148 * t202 + 0.162e3 * t156;
  t207 = sqrt(t206);
  t210 = t88 * t148;
  t214 = t107 * t148;
  t217 = t148 * sigma[2];
  t218 = t113 * t217;
  t219 = t199 * t199;
  t220 = 0.1e1 / t219;
  t224 = t165 * t171 / 0.24e2 + 0.146e3 / 0.2025e4 * t196 - 0.73e2 / 0.972e5 * t195 * t207 + 0.25e2 / 0.944784e6 * t102 * t210 * t202 + t214 * t154 / 0.72e3 + t111 * t218 * t220 / 0.2304e4;
  t227 = 0.1e1 + t122 * t171 / 0.24e2;
  t228 = t227 * t227;
  t229 = 0.1e1 / t228;
  t232 = exp(-t224 * t229 * t101);
  t235 = 0.1e1 + params->kappa * (0.1e1 - t232);
  t239 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t147 * t235);
  tzk0 = t137 + t239;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t240 = t7 * t7;
  t241 = 0.1e1 / t240;
  t242 = t17 * t241;
  t244 = my_piecewise5(t11, 0, t15, 0, t8 - t242);
  t247 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t244);
  t248 = t247 * t27;
  t252 = t27 * t27;
  t253 = 0.1e1 / t252;
  t254 = t26 * t253;
  t257 = t6 * t254 * t133 / 0.8e1;
  t258 = t6 * t26;
  t259 = t27 * params->kappa;
  t260 = t31 * rho[0];
  t261 = 0.1e1 / t260;
  t262 = t261 * t34;
  t263 = t262 * t41;
  t266 = t29 * t29;
  t267 = params->c * t266;
  t268 = 0.1e1 / t91;
  t269 = t33 * t33;
  t270 = 0.1e1 / t269;
  t273 = 0.1e1 / t40 / t39;
  t274 = t268 * t270 * t273;
  t278 = (-t30 * t263 / 0.32e2 + t267 * t274 / 0.1024e4) * t46;
  t282 = 0.1e1 / t54 / t260;
  t283 = t52 * t282;
  t288 = sigma[0] * t282;
  t290 = -0.5e1 / 0.3e1 * tau[0] * t56 + t288 / 0.3e1;
  t291 = t290 * t46;
  t292 = t51 * t77;
  t296 = 0.1e1 / t76 / t75;
  t297 = t69 * t296;
  t301 = t89 * t290;
  t304 = 0.5e1 * params->b * t290 * t72 + 0.25e2 / 0.9e1 * t70 * t301;
  t307 = t71 * t288;
  t309 = 0.3e1 / 0.4e1 * t291 * t292 - 0.27e2 / 0.4e2 * t297 * t304 - 0.2e1 / 0.27e2 * t307;
  t314 = 0.1e1 / t98;
  t315 = t82 * t314;
  t316 = t29 * t261;
  t319 = t90 * t31;
  t321 = 0.1e1 / t53 / t319;
  t325 = -0.324e3 * t316 * t34 - 0.8e3 / 0.3e1 * t89 * t29 * t321;
  t333 = t116 * rho[0];
  t334 = 0.1e1 / t333;
  t338 = t278 * t57 / 0.24e2 - t47 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t82 * t309 - 0.73e2 / 0.972e5 * t309 * t98 - 0.73e2 / 0.1944e6 * t315 * t325 - 0.25e2 / 0.177147e6 * t102 * t103 * t321 - t108 * t262 / 0.36e3 - t111 * t115 * t334 / 0.288e3;
  t341 = t126 * t125;
  t342 = 0.1e1 / t341;
  t343 = t121 * t342;
  t344 = t101 * t107;
  t345 = t343 * t344;
  t348 = -t338 * t127 * t101 - 0.2e1 / 0.9e1 * t345 * t307;
  t349 = t348 * t130;
  t350 = t259 * t349;
  t354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t248 * t133 - t257 + 0.3e1 / 0.8e1 * t258 * t350);
  t355 = t139 * t241;
  t357 = my_piecewise5(t15, 0, t11, 0, -t8 - t355);
  t360 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t357);
  t361 = t360 * t27;
  t365 = t146 * t253;
  t368 = t6 * t365 * t235 / 0.8e1;
  t370 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t361 * t235 - t368);
  tvrho0 = t137 + t239 + t7 * (t354 + t370);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t374 = my_piecewise5(t11, 0, t15, 0, -t8 - t242);
  t377 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t374);
  t378 = t377 * t27;
  t383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t378 * t133 - t257);
  t385 = my_piecewise5(t15, 0, t11, 0, t8 - t355);
  t388 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t385);
  t389 = t388 * t27;
  t393 = t6 * t146;
  t394 = t150 * rho[1];
  t395 = 0.1e1 / t394;
  t396 = t395 * t153;
  t397 = t396 * t160;
  t400 = t148 * t148;
  t401 = params->c * t400;
  t402 = 0.1e1 / t200;
  t403 = t152 * t152;
  t404 = 0.1e1 / t403;
  t407 = 0.1e1 / t159 / t158;
  t408 = t402 * t404 * t407;
  t412 = (-t149 * t397 / 0.32e2 + t401 * t408 / 0.1024e4) * t46;
  t416 = 0.1e1 / t168 / t394;
  t417 = t166 * t416;
  t422 = sigma[2] * t416;
  t424 = -0.5e1 / 0.3e1 * tau[1] * t170 + t422 / 0.3e1;
  t425 = t424 * t46;
  t426 = t51 * t190;
  t430 = 0.1e1 / t189 / t188;
  t431 = t183 * t430;
  t435 = t89 * t424;
  t438 = 0.5e1 * params->b * t424 * t185 + 0.25e2 / 0.9e1 * t184 * t435;
  t441 = t71 * t422;
  t443 = 0.3e1 / 0.4e1 * t425 * t426 - 0.27e2 / 0.4e2 * t431 * t438 - 0.2e1 / 0.27e2 * t441;
  t448 = 0.1e1 / t207;
  t449 = t195 * t448;
  t450 = t148 * t395;
  t453 = t199 * t150;
  t455 = 0.1e1 / t167 / t453;
  t459 = -0.324e3 * t450 * t153 - 0.8e3 / 0.3e1 * t89 * t148 * t455;
  t467 = t219 * rho[1];
  t468 = 0.1e1 / t467;
  t472 = t412 * t171 / 0.24e2 - t165 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t195 * t443 - 0.73e2 / 0.972e5 * t443 * t207 - 0.73e2 / 0.1944e6 * t449 * t459 - 0.25e2 / 0.177147e6 * t102 * t210 * t455 - t214 * t396 / 0.36e3 - t111 * t218 * t468 / 0.288e3;
  t475 = t228 * t227;
  t476 = 0.1e1 / t475;
  t477 = t224 * t476;
  t478 = t477 * t344;
  t481 = -t472 * t229 * t101 - 0.2e1 / 0.9e1 * t478 * t441;
  t482 = t481 * t232;
  t483 = t259 * t482;
  t487 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t389 * t235 - t368 + 0.3e1 / 0.8e1 * t393 * t483);
  tvrho1 = t137 + t239 + t7 * (t383 + t487);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t490 = params->c * sigma[0];
  t493 = params->c * t114;
  t494 = 0.1e1 / t90;
  t495 = t494 * t270;
  t496 = t495 * t273;
  t500 = (t490 * t42 / 0.32e2 - t493 * t496 / 0.1024e4) * t46;
  t503 = t51 * t56;
  t506 = t56 * t46;
  t507 = t506 * t292;
  t509 = params->b * t56;
  t510 = t509 * t72;
  t513 = t70 * t89 * t56;
  t515 = -0.5e1 / 0.8e1 * t510 - 0.25e2 / 0.72e2 * t513;
  t518 = t506 * t51;
  t520 = -0.3e1 / 0.32e2 * t507 - 0.27e2 / 0.4e2 * t297 * t515 + t518 / 0.36e2;
  t525 = sigma[0] * t32;
  t531 = 0.1e3 * t89 * sigma[0] * t93 + 0.324e3 * t525 * t34;
  t534 = t88 * sigma[0];
  t538 = t107 * sigma[0];
  t541 = t113 * t29;
  t545 = t500 * t57 / 0.24e2 + t47 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t520 - 0.73e2 / 0.972e5 * t520 * t98 - 0.73e2 / 0.1944e6 * t315 * t531 + 0.25e2 / 0.472392e6 * t102 * t534 * t93 + t538 * t35 / 0.36e3 + t111 * t541 * t117 / 0.768e3;
  t548 = t343 * t101;
  t549 = t122 * t503;
  t552 = -t545 * t127 * t101 + t548 * t549 / 0.12e2;
  t553 = t552 * t130;
  t554 = t259 * t553;
  t557 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t554);
  tvsigma0 = t7 * t557;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t558 = params->c * sigma[2];
  t561 = params->c * t217;
  t562 = 0.1e1 / t199;
  t563 = t562 * t404;
  t564 = t563 * t407;
  t568 = (t558 * t161 / 0.32e2 - t561 * t564 / 0.1024e4) * t46;
  t571 = t51 * t170;
  t574 = t170 * t46;
  t575 = t574 * t426;
  t577 = params->b * t170;
  t578 = t577 * t185;
  t581 = t184 * t89 * t170;
  t583 = -0.5e1 / 0.8e1 * t578 - 0.25e2 / 0.72e2 * t581;
  t586 = t574 * t51;
  t588 = -0.3e1 / 0.32e2 * t575 - 0.27e2 / 0.4e2 * t431 * t583 + t586 / 0.36e2;
  t593 = sigma[2] * t151;
  t599 = 0.1e3 * t89 * sigma[2] * t202 + 0.324e3 * t593 * t153;
  t602 = t88 * sigma[2];
  t606 = t107 * sigma[2];
  t609 = t113 * t148;
  t613 = t568 * t171 / 0.24e2 + t165 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t588 - 0.73e2 / 0.972e5 * t588 * t207 - 0.73e2 / 0.1944e6 * t449 * t599 + 0.25e2 / 0.472392e6 * t102 * t602 * t202 + t606 * t154 / 0.36e3 + t111 * t609 * t220 / 0.768e3;
  t616 = t477 * t101;
  t617 = t122 * t571;
  t620 = -t613 * t229 * t101 + t616 * t617 / 0.12e2;
  t621 = t620 * t232;
  t622 = t259 * t621;
  t625 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t622);
  tvsigma2 = t7 * t625;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t626 = t33 * tau[0];
  t627 = 0.1e1 / t626;
  t628 = t32 * t627;
  t629 = t628 * t41;
  t632 = t269 * tau[0];
  t633 = 0.1e1 / t632;
  t635 = t494 * t633 * t273;
  t639 = (-t30 * t629 / 0.32e2 + t267 * t635 / 0.1024e4) * t46;
  t642 = t61 * t46;
  t645 = params->b * t61;
  t651 = 0.5e1 * t645 * t72 + 0.25e2 / 0.9e1 * t70 * t89 * t61;
  t654 = 0.3e1 / 0.4e1 * t642 * t292 - 0.27e2 / 0.4e2 * t297 * t651;
  t659 = t36 * t627;
  t664 = t639 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t654 - 0.73e2 / 0.972e5 * t654 * t98 + 0.73e2 / 0.6e3 * t315 * t659 - t108 * t628 / 0.36e3;
  t665 = t27 * t664;
  t666 = t127 * t130;
  t667 = t665 * t666;
  t670 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t667);
  tvtau0 = t7 * t670;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t671 = t152 * tau[1];
  t672 = 0.1e1 / t671;
  t673 = t151 * t672;
  t674 = t673 * t160;
  t677 = t403 * tau[1];
  t678 = 0.1e1 / t677;
  t680 = t562 * t678 * t407;
  t684 = (-t149 * t674 / 0.32e2 + t401 * t680 / 0.1024e4) * t46;
  t687 = t175 * t46;
  t690 = params->b * t175;
  t696 = 0.5e1 * t690 * t185 + 0.25e2 / 0.9e1 * t184 * t89 * t175;
  t699 = 0.3e1 / 0.4e1 * t687 * t426 - 0.27e2 / 0.4e2 * t431 * t696;
  t704 = t155 * t672;
  t709 = t684 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t699 - 0.73e2 / 0.972e5 * t699 * t207 + 0.73e2 / 0.6e3 * t449 * t704 - t214 * t673 / 0.36e3;
  t710 = t27 * t709;
  t711 = t229 * t232;
  t712 = t710 * t711;
  t715 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t712);
  tvtau1 = t7 * t715;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t718 = t24 * t24;
  t719 = 0.1e1 / t718;
  t720 = t244 * t244;
  t723 = t240 * t7;
  t724 = 0.1e1 / t723;
  t725 = t17 * t724;
  t728 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t241 + 0.2e1 * t725);
  t732 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t720 + 0.4e1 / 0.3e1 * t24 * t728);
  t733 = t732 * t27;
  t737 = t247 * t253;
  t739 = t6 * t737 * t133;
  t741 = t6 * t247;
  t745 = 0.1e1 / t252 / t7;
  t746 = t26 * t745;
  t749 = t6 * t746 * t133 / 0.12e2;
  t750 = t253 * params->kappa;
  t751 = t750 * t349;
  t752 = t258 * t751;
  t754 = t494 * t34;
  t755 = t754 * t41;
  t758 = 0.1e1 / t319;
  t760 = t758 * t270 * t273;
  t763 = t266 * t29;
  t764 = params->c * t763;
  t765 = t269 * t33;
  t766 = 0.1e1 / t765;
  t768 = t40 * t40;
  t769 = 0.1e1 / t768;
  t770 = t117 * t766 * t769;
  t774 = (0.3e1 / 0.32e2 * t30 * t755 - 0.7e1 / 0.1024e4 * t267 * t760 + 0.3e1 / 0.32768e5 * t764 * t770) * t46;
  t780 = 0.1e1 / t54 / t90;
  t781 = t52 * t780;
  t784 = t309 * t309;
  t788 = sigma[0] * t780;
  t790 = 0.4e2 / 0.9e1 * tau[0] * t282 - 0.11e2 / 0.9e1 * t788;
  t791 = t790 * t46;
  t794 = t51 * t296;
  t795 = t794 * t304;
  t798 = t75 * t75;
  t800 = 0.1e1 / t76 / t798;
  t801 = t69 * t800;
  t802 = t304 * t304;
  t805 = params->b * t790;
  t808 = t290 * t290;
  t812 = t89 * t790;
  t815 = 0.5e1 * t805 * t72 + 0.5e2 / 0.9e1 * params->b * t808 * t89 + 0.25e2 / 0.9e1 * t70 * t812;
  t818 = t71 * t788;
  t820 = 0.3e1 / 0.4e1 * t791 * t292 - 0.3e1 / 0.4e1 * t291 * t795 + 0.81e2 / 0.8e2 * t801 * t802 - 0.27e2 / 0.4e2 * t297 * t815 + 0.22e2 / 0.81e2 * t818;
  t825 = t309 * t314;
  t829 = 0.1e1 / t98 / t97;
  t830 = t82 * t829;
  t831 = t325 * t325;
  t834 = t29 * t494;
  t837 = t90 * t260;
  t839 = 0.1e1 / t53 / t837;
  t841 = t89 * t29 * t839;
  t843 = 0.972e3 * t834 * t34 + 0.152e5 / 0.9e1 * t841;
  t846 = t103 * t839;
  t851 = t116 * t31;
  t852 = 0.1e1 / t851;
  t856 = t774 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t278 * t283 + 0.11e2 / 0.27e2 * t47 * t781 + 0.292e3 / 0.2025e4 * t784 + 0.292e3 / 0.2025e4 * t82 * t820 - 0.73e2 / 0.972e5 * t820 * t98 - 0.73e2 / 0.972e5 * t825 * t325 + 0.73e2 / 0.3888e6 * t830 * t831 - 0.73e2 / 0.1944e6 * t315 * t843 + 0.475e3 / 0.531441e6 * t102 * t846 + t108 * t754 / 0.12e3 + t111 * t115 * t852 / 0.32e2;
  t859 = t338 * t342;
  t860 = t859 * t344;
  t863 = t126 * t126;
  t864 = 0.1e1 / t863;
  t865 = t121 * t864;
  t866 = t101 * params->e;
  t867 = t865 * t866;
  t872 = -t856 * t127 * t101 - 0.4e1 / 0.9e1 * t860 * t307 - 0.2e1 / 0.27e2 * t867 * t841 + 0.22e2 / 0.27e2 * t345 * t818;
  t873 = t872 * t130;
  t874 = t259 * t873;
  t877 = t348 * t348;
  t878 = t877 * t130;
  t879 = t259 * t878;
  t883 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t733 * t133 - t739 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t350 + t749 + t752 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t874 + 0.3e1 / 0.8e1 * t258 * t879);
  t884 = t144 * t144;
  t885 = 0.1e1 / t884;
  t886 = t357 * t357;
  t889 = t139 * t724;
  t892 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t241 + 0.2e1 * t889);
  t896 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t886 + 0.4e1 / 0.3e1 * t144 * t892);
  t897 = t896 * t27;
  t901 = t360 * t253;
  t903 = t6 * t901 * t235;
  t905 = t146 * t745;
  t908 = t6 * t905 * t235 / 0.12e2;
  t910 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t897 * t235 - t903 / 0.4e1 + t908);
  tv2rho20 = 0.2e1 * t354 + 0.2e1 * t370 + t7 * (t883 + t910);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t913 = t719 * t374;
  t917 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t725);
  t921 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t913 * t244 + 0.4e1 / 0.3e1 * t24 * t917);
  t922 = t921 * t27;
  t926 = t377 * t253;
  t928 = t6 * t926 * t133;
  t930 = t6 * t377;
  t936 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t922 * t133 - t928 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t350 - t739 / 0.8e1 + t749 + t752 / 0.8e1);
  t937 = t885 * t385;
  t941 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t889);
  t945 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t937 * t357 + 0.4e1 / 0.3e1 * t144 * t941);
  t946 = t945 * t27;
  t950 = t388 * t253;
  t952 = t6 * t950 * t235;
  t955 = t6 * t360;
  t958 = t750 * t482;
  t959 = t393 * t958;
  t962 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t946 * t235 - t952 / 0.8e1 - t903 / 0.8e1 + t908 + 0.3e1 / 0.8e1 * t955 * t483 + t959 / 0.8e1);
  tv2rho21 = t354 + t370 + t383 + t487 + t7 * (t936 + t962);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t967 = t374 * t374;
  t972 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t241 + 0.2e1 * t725);
  t976 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t967 + 0.4e1 / 0.3e1 * t24 * t972);
  t977 = t976 * t27;
  t983 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t977 * t133 - t928 / 0.4e1 + t749);
  t984 = t385 * t385;
  t989 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t241 + 0.2e1 * t889);
  t993 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t984 + 0.4e1 / 0.3e1 * t144 * t989);
  t994 = t993 * t27;
  t999 = t6 * t388;
  t1003 = t562 * t153;
  t1004 = t1003 * t160;
  t1007 = 0.1e1 / t453;
  t1009 = t1007 * t404 * t407;
  t1012 = t400 * t148;
  t1013 = params->c * t1012;
  t1014 = t403 * t152;
  t1015 = 0.1e1 / t1014;
  t1017 = t159 * t159;
  t1018 = 0.1e1 / t1017;
  t1019 = t220 * t1015 * t1018;
  t1023 = (0.3e1 / 0.32e2 * t149 * t1004 - 0.7e1 / 0.1024e4 * t401 * t1009 + 0.3e1 / 0.32768e5 * t1013 * t1019) * t46;
  t1029 = 0.1e1 / t168 / t199;
  t1030 = t166 * t1029;
  t1033 = t443 * t443;
  t1037 = sigma[2] * t1029;
  t1039 = 0.4e2 / 0.9e1 * tau[1] * t416 - 0.11e2 / 0.9e1 * t1037;
  t1040 = t1039 * t46;
  t1043 = t51 * t430;
  t1044 = t1043 * t438;
  t1047 = t188 * t188;
  t1049 = 0.1e1 / t189 / t1047;
  t1050 = t183 * t1049;
  t1051 = t438 * t438;
  t1054 = params->b * t1039;
  t1057 = t424 * t424;
  t1061 = t89 * t1039;
  t1064 = 0.5e1 * t1054 * t185 + 0.5e2 / 0.9e1 * params->b * t1057 * t89 + 0.25e2 / 0.9e1 * t184 * t1061;
  t1067 = t71 * t1037;
  t1069 = 0.3e1 / 0.4e1 * t1040 * t426 - 0.3e1 / 0.4e1 * t425 * t1044 + 0.81e2 / 0.8e2 * t1050 * t1051 - 0.27e2 / 0.4e2 * t431 * t1064 + 0.22e2 / 0.81e2 * t1067;
  t1074 = t443 * t448;
  t1078 = 0.1e1 / t207 / t206;
  t1079 = t195 * t1078;
  t1080 = t459 * t459;
  t1083 = t148 * t562;
  t1086 = t199 * t394;
  t1088 = 0.1e1 / t167 / t1086;
  t1090 = t89 * t148 * t1088;
  t1092 = 0.972e3 * t1083 * t153 + 0.152e5 / 0.9e1 * t1090;
  t1095 = t210 * t1088;
  t1100 = t219 * t150;
  t1101 = 0.1e1 / t1100;
  t1105 = t1023 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t412 * t417 + 0.11e2 / 0.27e2 * t165 * t1030 + 0.292e3 / 0.2025e4 * t1033 + 0.292e3 / 0.2025e4 * t195 * t1069 - 0.73e2 / 0.972e5 * t1069 * t207 - 0.73e2 / 0.972e5 * t1074 * t459 + 0.73e2 / 0.3888e6 * t1079 * t1080 - 0.73e2 / 0.1944e6 * t449 * t1092 + 0.475e3 / 0.531441e6 * t102 * t1095 + t214 * t1003 / 0.12e3 + t111 * t218 * t1101 / 0.32e2;
  t1108 = t472 * t476;
  t1109 = t1108 * t344;
  t1112 = t228 * t228;
  t1113 = 0.1e1 / t1112;
  t1114 = t224 * t1113;
  t1115 = t1114 * t866;
  t1120 = -t1105 * t229 * t101 - 0.4e1 / 0.9e1 * t1109 * t441 - 0.2e1 / 0.27e2 * t1115 * t1090 + 0.22e2 / 0.27e2 * t478 * t1067;
  t1121 = t1120 * t232;
  t1122 = t259 * t1121;
  t1125 = t481 * t481;
  t1126 = t1125 * t232;
  t1127 = t259 * t1126;
  t1131 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t994 * t235 - t952 / 0.4e1 + 0.3e1 / 0.4e1 * t999 * t483 + t908 + t959 / 0.4e1 + 0.3e1 / 0.8e1 * t393 * t1122 + 0.3e1 / 0.8e1 * t393 * t1127);
  tv2rho22 = 0.2e1 * t383 + 0.2e1 * t487 + t7 * (t983 + t1131);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1136 = t750 * t553;
  t1138 = t258 * t1136 / 0.8e1;
  t1143 = t266 * sigma[0];
  t1144 = params->c * t1143;
  t1145 = 0.1e1 / t837;
  t1147 = t1145 * t766 * t769;
  t1151 = (-t490 * t263 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t274 - 0.3e1 / 0.32768e5 * t1144 * t1147) * t46;
  t1158 = t51 * t282;
  t1163 = t282 * t46;
  t1164 = t1163 * t292;
  t1166 = t506 * t795;
  t1168 = t794 * t515;
  t1171 = t515 * t304;
  t1174 = params->b * t282;
  t1175 = t1174 * t72;
  t1177 = t509 * t301;
  t1180 = t70 * t89 * t282;
  t1182 = 0.5e1 / 0.3e1 * t1175 - 0.25e2 / 0.36e2 * t1177 + 0.25e2 / 0.27e2 * t1180;
  t1185 = t1163 * t51;
  t1187 = t1164 / 0.4e1 + 0.3e1 / 0.64e2 * t1166 - 0.3e1 / 0.8e1 * t291 * t1168 + 0.81e2 / 0.8e2 * t801 * t1171 - 0.27e2 / 0.4e2 * t297 * t1182 - 0.2e1 / 0.27e2 * t1185;
  t1192 = t520 * t314;
  t1197 = t531 * t325;
  t1200 = sigma[0] * t261;
  t1204 = t89 * sigma[0] * t321;
  t1206 = -0.648e3 * t1200 * t34 - 0.16e4 / 0.3e1 * t1204;
  t1209 = t534 * t321;
  t1217 = t1151 * t57 / 0.24e2 - t500 * t283 / 0.9e1 + t278 * t503 / 0.24e2 - t47 * t1158 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t520 + 0.292e3 / 0.2025e4 * t82 * t1187 - 0.73e2 / 0.972e5 * t1187 * t98 - 0.73e2 / 0.1944e6 * t1192 * t325 - 0.73e2 / 0.1944e6 * t825 * t531 + 0.73e2 / 0.3888e6 * t830 * t1197 - 0.73e2 / 0.1944e6 * t315 * t1206 - 0.5e2 / 0.177147e6 * t102 * t1209 - t538 * t262 / 0.18e3 - t111 * t541 * t334 / 0.96e2;
  t1220 = t545 * t342;
  t1221 = t1220 * t344;
  t1224 = t859 * t101;
  t1229 = t122 * t1158;
  t1232 = -t1217 * t127 * t101 - 0.2e1 / 0.9e1 * t1221 * t307 + t1224 * t549 / 0.12e2 + t867 * t1204 / 0.36e2 - 0.2e1 / 0.9e1 * t548 * t1229;
  t1233 = t1232 * t130;
  t1234 = t259 * t1233;
  t1237 = t6 * t28;
  t1238 = params->kappa * t552;
  t1239 = t1238 * t349;
  t1243 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t741 * t554 + t1138 + 0.3e1 / 0.8e1 * t258 * t1234 + 0.3e1 / 0.8e1 * t1237 * t1239);
  tv2rhosigma0 = t7 * t1243 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t1247 = t750 * t621;
  t1249 = t393 * t1247 / 0.8e1;
  t1251 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t622 + t1249);
  tv2rhosigma2 = t7 * t1251 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1256 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t554 + t1138);
  tv2rhosigma3 = t7 * t1256 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1264 = t400 * sigma[2];
  t1265 = params->c * t1264;
  t1266 = 0.1e1 / t1086;
  t1268 = t1266 * t1015 * t1018;
  t1272 = (-t558 * t397 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t408 - 0.3e1 / 0.32768e5 * t1265 * t1268) * t46;
  t1279 = t51 * t416;
  t1284 = t416 * t46;
  t1285 = t1284 * t426;
  t1287 = t574 * t1044;
  t1289 = t1043 * t583;
  t1292 = t583 * t438;
  t1295 = params->b * t416;
  t1296 = t1295 * t185;
  t1298 = t577 * t435;
  t1301 = t184 * t89 * t416;
  t1303 = 0.5e1 / 0.3e1 * t1296 - 0.25e2 / 0.36e2 * t1298 + 0.25e2 / 0.27e2 * t1301;
  t1306 = t1284 * t51;
  t1308 = t1285 / 0.4e1 + 0.3e1 / 0.64e2 * t1287 - 0.3e1 / 0.8e1 * t425 * t1289 + 0.81e2 / 0.8e2 * t1050 * t1292 - 0.27e2 / 0.4e2 * t431 * t1303 - 0.2e1 / 0.27e2 * t1306;
  t1313 = t588 * t448;
  t1318 = t599 * t459;
  t1321 = sigma[2] * t395;
  t1325 = t89 * sigma[2] * t455;
  t1327 = -0.648e3 * t1321 * t153 - 0.16e4 / 0.3e1 * t1325;
  t1330 = t602 * t455;
  t1338 = t1272 * t171 / 0.24e2 - t568 * t417 / 0.9e1 + t412 * t571 / 0.24e2 - t165 * t1279 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t588 + 0.292e3 / 0.2025e4 * t195 * t1308 - 0.73e2 / 0.972e5 * t1308 * t207 - 0.73e2 / 0.1944e6 * t1313 * t459 - 0.73e2 / 0.1944e6 * t1074 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1318 - 0.73e2 / 0.1944e6 * t449 * t1327 - 0.5e2 / 0.177147e6 * t102 * t1330 - t606 * t396 / 0.18e3 - t111 * t609 * t468 / 0.96e2;
  t1341 = t613 * t476;
  t1342 = t1341 * t344;
  t1345 = t1108 * t101;
  t1350 = t122 * t1279;
  t1353 = -t1338 * t229 * t101 - 0.2e1 / 0.9e1 * t1342 * t441 + t1345 * t617 / 0.12e2 + t1115 * t1325 / 0.36e2 - 0.2e1 / 0.9e1 * t616 * t1350;
  t1354 = t1353 * t232;
  t1355 = t259 * t1354;
  t1358 = t6 * t147;
  t1359 = params->kappa * t620;
  t1360 = t1359 * t482;
  t1364 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t999 * t622 + t1249 + 0.3e1 / 0.8e1 * t393 * t1355 + 0.3e1 / 0.8e1 * t1358 * t1360);
  tv2rhosigma5 = t7 * t1364 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1368 = t253 * t664;
  t1369 = t1368 * t666;
  t1371 = t258 * t1369 / 0.8e1;
  t1372 = t261 * t627;
  t1373 = t1372 * t41;
  t1377 = t268 * t633 * t273;
  t1381 = 0.1e1 / t269 / t626;
  t1383 = t1145 * t1381 * t769;
  t1387 = (t30 * t1373 / 0.16e2 - 0.3e1 / 0.512e3 * t267 * t1377 + 0.3e1 / 0.32768e5 * t764 * t1383) * t46;
  t1397 = t794 * t651;
  t1400 = t651 * t304;
  t1407 = -0.25e2 / 0.3e1 * t510 + 0.5e2 / 0.9e1 * t645 * t301 - 0.125e3 / 0.27e2 * t513;
  t1410 = -0.5e1 / 0.4e1 * t507 - 0.3e1 / 0.8e1 * t642 * t795 - 0.3e1 / 0.8e1 * t291 * t1397 + 0.81e2 / 0.8e2 * t801 * t1400 - 0.27e2 / 0.4e2 * t297 * t1407;
  t1415 = t654 * t314;
  t1420 = t830 * t29;
  t1421 = t628 * t325;
  t1424 = t316 * t627;
  t1429 = t1387 * t57 / 0.24e2 - t639 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t654 + 0.292e3 / 0.2025e4 * t82 * t1410 - 0.73e2 / 0.972e5 * t1410 * t98 - 0.73e2 / 0.1944e6 * t1415 * t325 + 0.73e2 / 0.6e3 * t825 * t659 - 0.73e2 / 0.12e4 * t1420 * t1421 - 0.73e2 / 0.3e3 * t315 * t1424 + t108 * t1372 / 0.18e3;
  t1430 = t27 * t1429;
  t1431 = t1430 * t666;
  t1434 = t665 * t342;
  t1435 = t258 * t1434;
  t1437 = t130 * t107 * t46;
  t1438 = t1437 * t283;
  t1441 = t664 * t127;
  t1442 = t1441 * t349;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t741 * t667 - t1371 - 0.3e1 / 0.8e1 * t258 * t1431 - t1435 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t1442);
  tv2rhotau0 = t7 * t1446 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1450 = t253 * t709;
  t1451 = t1450 * t711;
  t1453 = t393 * t1451 / 0.8e1;
  t1455 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t712 - t1453);
  tv2rhotau1 = t7 * t1455 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1460 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t667 - t1371);
  tv2rhotau2 = t7 * t1460 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1464 = t395 * t672;
  t1465 = t1464 * t160;
  t1469 = t402 * t678 * t407;
  t1473 = 0.1e1 / t403 / t671;
  t1475 = t1266 * t1473 * t1018;
  t1479 = (t149 * t1465 / 0.16e2 - 0.3e1 / 0.512e3 * t401 * t1469 + 0.3e1 / 0.32768e5 * t1013 * t1475) * t46;
  t1489 = t1043 * t696;
  t1492 = t696 * t438;
  t1499 = -0.25e2 / 0.3e1 * t578 + 0.5e2 / 0.9e1 * t690 * t435 - 0.125e3 / 0.27e2 * t581;
  t1502 = -0.5e1 / 0.4e1 * t575 - 0.3e1 / 0.8e1 * t687 * t1044 - 0.3e1 / 0.8e1 * t425 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1492 - 0.27e2 / 0.4e2 * t431 * t1499;
  t1507 = t699 * t448;
  t1512 = t1079 * t148;
  t1513 = t673 * t459;
  t1516 = t450 * t672;
  t1521 = t1479 * t171 / 0.24e2 - t684 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t699 + 0.292e3 / 0.2025e4 * t195 * t1502 - 0.73e2 / 0.972e5 * t1502 * t207 - 0.73e2 / 0.1944e6 * t1507 * t459 + 0.73e2 / 0.6e3 * t1074 * t704 - 0.73e2 / 0.12e4 * t1512 * t1513 - 0.73e2 / 0.3e3 * t449 * t1516 + t214 * t1464 / 0.18e3;
  t1522 = t27 * t1521;
  t1523 = t1522 * t711;
  t1526 = t710 * t476;
  t1527 = t393 * t1526;
  t1529 = t232 * t107 * t46;
  t1530 = t1529 * t417;
  t1533 = t709 * t229;
  t1534 = t1533 * t482;
  t1538 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t999 * t712 - t1453 - 0.3e1 / 0.8e1 * t393 * t1523 - t1527 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t1534);
  tv2rhotau3 = t7 * t1538 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1540 = params->c * t32;
  t1541 = t34 * t41;
  t1546 = t758 * t766;
  t1547 = t1546 * t769;
  t1551 = (t1540 * t1541 / 0.32e2 - 0.5e1 / 0.1024e4 * t30 * t496 + 0.3e1 / 0.32768e5 * t267 * t1547) * t46;
  t1556 = t520 * t520;
  t1558 = t506 * t1168;
  t1560 = t515 * t515;
  t1563 = t297 * params->b;
  t1564 = t89 * t93;
  t1565 = t1563 * t1564;
  t1567 = 0.3e1 / 0.32e2 * t1558 + 0.81e2 / 0.8e2 * t801 * t1560 - 0.15e2 / 0.256e3 * t1565;
  t1574 = t531 * t531;
  t1579 = 0.324e3 * t35 + 0.1e3 * t1564;
  t1582 = t88 * t93;
  t1585 = t107 * t32;
  t1588 = t113 * sigma[0];
  t1592 = t1551 * t57 / 0.24e2 + t500 * t503 / 0.12e2 + 0.292e3 / 0.2025e4 * t1556 + 0.292e3 / 0.2025e4 * t82 * t1567 - 0.73e2 / 0.972e5 * t1567 * t98 - 0.73e2 / 0.972e5 * t1192 * t531 + 0.73e2 / 0.3888e6 * t830 * t1574 - 0.73e2 / 0.1944e6 * t315 * t1579 + 0.25e2 / 0.472392e6 * t102 * t1582 + t1585 * t34 / 0.36e3 + t111 * t1588 * t117 / 0.384e3;
  t1595 = t1220 * t101;
  t1598 = t865 * t101;
  t1599 = params->e * t86;
  t1600 = t1599 * t1582;
  t1603 = -t1592 * t127 * t101 + t1595 * t549 / 0.6e1 - t1598 * t1600 / 0.96e2;
  t1604 = t1603 * t130;
  t1605 = t259 * t1604;
  t1607 = t552 * t552;
  t1608 = t1607 * t130;
  t1609 = t259 * t1608;
  t1613 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t1605 + 0.3e1 / 0.8e1 * t258 * t1609);
  tv2sigma20 = t7 * t1613;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1614 = params->c * t151;
  t1615 = t153 * t160;
  t1620 = t1007 * t1015;
  t1621 = t1620 * t1018;
  t1625 = (t1614 * t1615 / 0.32e2 - 0.5e1 / 0.1024e4 * t149 * t564 + 0.3e1 / 0.32768e5 * t401 * t1621) * t46;
  t1630 = t588 * t588;
  t1632 = t574 * t1289;
  t1634 = t583 * t583;
  t1637 = t431 * params->b;
  t1638 = t89 * t202;
  t1639 = t1637 * t1638;
  t1641 = 0.3e1 / 0.32e2 * t1632 + 0.81e2 / 0.8e2 * t1050 * t1634 - 0.15e2 / 0.256e3 * t1639;
  t1648 = t599 * t599;
  t1653 = 0.324e3 * t154 + 0.1e3 * t1638;
  t1656 = t88 * t202;
  t1659 = t107 * t151;
  t1662 = t113 * sigma[2];
  t1666 = t1625 * t171 / 0.24e2 + t568 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1630 + 0.292e3 / 0.2025e4 * t195 * t1641 - 0.73e2 / 0.972e5 * t1641 * t207 - 0.73e2 / 0.972e5 * t1313 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1648 - 0.73e2 / 0.1944e6 * t449 * t1653 + 0.25e2 / 0.472392e6 * t102 * t1656 + t1659 * t153 / 0.36e3 + t111 * t1662 * t220 / 0.384e3;
  t1669 = t1341 * t101;
  t1672 = t1114 * t101;
  t1673 = t1599 * t1656;
  t1676 = -t1666 * t229 * t101 + t1669 * t617 / 0.6e1 - t1672 * t1673 / 0.96e2;
  t1677 = t1676 * t232;
  t1678 = t259 * t1677;
  t1680 = t620 * t620;
  t1681 = t1680 * t232;
  t1682 = t259 * t1681;
  t1686 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t1678 + 0.3e1 / 0.8e1 * t393 * t1682);
  tv2sigma25 = t7 * t1686;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1692 = t758 * t1381 * t769;
  t1696 = (-t490 * t629 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t635 - 0.3e1 / 0.32768e5 * t1144 * t1692) * t46;
  t1705 = t506 * t1397;
  t1707 = t651 * t515;
  t1711 = 0.1e1 / t53 / t90;
  t1712 = t1711 * t86;
  t1714 = t1563 * t1712 * t88;
  t1716 = -0.3e1 / 0.8e1 * t642 * t1168 + 0.3e1 / 0.64e2 * t1705 + 0.81e2 / 0.8e2 * t801 * t1707 + 0.15e2 / 0.32e2 * t1714;
  t1725 = t628 * t531;
  t1728 = t525 * t627;
  t1733 = t1696 * t57 / 0.24e2 + t639 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t520 * t654 + 0.292e3 / 0.2025e4 * t82 * t1716 - 0.73e2 / 0.972e5 * t1716 * t98 - 0.73e2 / 0.1944e6 * t1415 * t531 + 0.73e2 / 0.6e3 * t1192 * t659 - 0.73e2 / 0.12e4 * t1420 * t1725 + 0.73e2 / 0.3e3 * t315 * t1728 - t538 * t628 / 0.18e3;
  t1734 = t27 * t1733;
  t1735 = t1734 * t666;
  t1738 = t28 * t664;
  t1739 = t6 * t1738;
  t1741 = t342 * t130 * t107;
  t1742 = t1741 * t518;
  t1745 = t1441 * t553;
  t1749 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t1735 + t1739 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t1745);
  tv2sigmatau0 = t7 * t1749;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1755 = t1007 * t1473 * t1018;
  t1759 = (-t558 * t674 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t680 - 0.3e1 / 0.32768e5 * t1265 * t1755) * t46;
  t1768 = t574 * t1489;
  t1770 = t696 * t583;
  t1774 = 0.1e1 / t167 / t199;
  t1775 = t1774 * t86;
  t1777 = t1637 * t1775 * t88;
  t1779 = -0.3e1 / 0.8e1 * t687 * t1289 + 0.3e1 / 0.64e2 * t1768 + 0.81e2 / 0.8e2 * t1050 * t1770 + 0.15e2 / 0.32e2 * t1777;
  t1788 = t673 * t599;
  t1791 = t593 * t672;
  t1796 = t1759 * t171 / 0.24e2 + t684 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t588 * t699 + 0.292e3 / 0.2025e4 * t195 * t1779 - 0.73e2 / 0.972e5 * t1779 * t207 - 0.73e2 / 0.1944e6 * t1507 * t599 + 0.73e2 / 0.6e3 * t1313 * t704 - 0.73e2 / 0.12e4 * t1512 * t1788 + 0.73e2 / 0.3e3 * t449 * t1791 - t606 * t673 / 0.18e3;
  t1797 = t27 * t1796;
  t1798 = t1797 * t711;
  t1801 = t147 * t709;
  t1802 = t6 * t1801;
  t1804 = t476 * t232 * t107;
  t1805 = t1804 * t586;
  t1808 = t1533 * t621;
  t1812 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t1798 + t1802 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t1808);
  tv2sigmatau5 = t7 * t1812;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1813 = t32 * t270;
  t1814 = t1813 * t41;
  t1817 = t494 * t766;
  t1818 = t1817 * t273;
  t1821 = t269 * t269;
  t1822 = 0.1e1 / t1821;
  t1824 = t758 * t1822 * t769;
  t1828 = (0.3e1 / 0.32e2 * t30 * t1814 - 0.7e1 / 0.1024e4 * t267 * t1818 + 0.3e1 / 0.32768e5 * t764 * t1824) * t46;
  t1831 = t654 * t654;
  t1835 = t651 * t651;
  t1839 = 0.1e1 / t53 / t260;
  t1840 = t1839 * t86;
  t1844 = -0.3e1 / 0.4e1 * t642 * t1397 + 0.81e2 / 0.8e2 * t801 * t1835 - 0.15e2 / 0.4e1 * t1563 * t1840 * t88;
  t1851 = t266 * t494;
  t1852 = t1851 * t766;
  t1855 = t36 * t270;
  t1860 = t1828 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t1831 + 0.292e3 / 0.2025e4 * t82 * t1844 - 0.73e2 / 0.972e5 * t1844 * t98 + 0.73e2 / 0.3e3 * t1415 * t659 + 0.1971e4 / 0.1e3 * t830 * t1852 - 0.73e2 / 0.2e3 * t315 * t1855 + t108 * t1813 / 0.12e3;
  t1861 = t27 * t1860;
  t1862 = t1861 * t666;
  t1864 = t664 * t664;
  t1865 = t1864 * t864;
  t1866 = t101 * t130;
  t1867 = t1865 * t1866;
  t1871 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t1237 * t1867 - 0.3e1 / 0.8e1 * t258 * t1862);
  tv2tau20 = t7 * t1871;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1872 = t151 * t404;
  t1873 = t1872 * t160;
  t1876 = t562 * t1015;
  t1877 = t1876 * t407;
  t1880 = t403 * t403;
  t1881 = 0.1e1 / t1880;
  t1883 = t1007 * t1881 * t1018;
  t1887 = (0.3e1 / 0.32e2 * t149 * t1873 - 0.7e1 / 0.1024e4 * t401 * t1877 + 0.3e1 / 0.32768e5 * t1013 * t1883) * t46;
  t1890 = t699 * t699;
  t1894 = t696 * t696;
  t1898 = 0.1e1 / t167 / t394;
  t1899 = t1898 * t86;
  t1903 = -0.3e1 / 0.4e1 * t687 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1894 - 0.15e2 / 0.4e1 * t1637 * t1899 * t88;
  t1910 = t400 * t562;
  t1911 = t1910 * t1015;
  t1914 = t155 * t404;
  t1919 = t1887 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t1890 + 0.292e3 / 0.2025e4 * t195 * t1903 - 0.73e2 / 0.972e5 * t1903 * t207 + 0.73e2 / 0.3e3 * t1507 * t704 + 0.1971e4 / 0.1e3 * t1079 * t1911 - 0.73e2 / 0.2e3 * t449 * t1914 + t214 * t1872 / 0.12e3;
  t1920 = t27 * t1919;
  t1921 = t1920 * t711;
  t1923 = t709 * t709;
  t1924 = t1923 * t1113;
  t1925 = t101 * t232;
  t1926 = t1924 * t1925;
  t1930 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t1358 * t1926 - 0.3e1 / 0.8e1 * t393 * t1921);
  tv2tau22 = t7 * t1930;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

}

#endif


#ifndef XC_DONT_COMPILE_KXC
GPU_DEVICE_FUNCTION static inline void
func_kxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t41;
  double t42, t46, t47, t48, t49, t50, t51, t52;
  double t53, t54, t56, t57, t61, t63, t65, t69;
  double t70, t71, t72, t75, t76, t77, t82, t83;
  double t86, t88, t89, t90, t91, t93, t97, t98;
  double t101, t102, t103, t107, t108, t111, t112, t113;
  double t114, t115, t116, t117, t121, t122, t125, t126;
  double t127, t130, t133, t137, t138, t139, t141, t142;
  double t143, t144, t146, t147, t148, t149, t150, t151;
  double t152, t153, t154, t155, t156, t158, t159, t160;
  double t161, t165, t166, t167, t168, t170, t171, t175;
  double t177, t179, t183, t184, t185, t188, t189, t190;
  double t195, t196, t199, t200, t202, t206, t207, t210;
  double t214, t217, t218, t219, t220, t224, t227, t228;
  double t229, t232, t235, t239, tzk0;

  double t240, t241, t242, t244, t247, t248, t252, t253;
  double t254, t257, t258, t259, t260, t261, t262, t263;
  double t266, t267, t268, t269, t270, t273, t274, t278;
  double t282, t283, t288, t290, t291, t292, t296, t297;
  double t301, t304, t307, t309, t314, t315, t316, t319;
  double t321, t325, t333, t334, t338, t341, t342, t343;
  double t344, t345, t348, t349, t350, t354, t355, t357;
  double t360, t361, t365, t368, t370, tvrho0, t374, t377;
  double t378, t383, t385, t388, t389, t393, t394, t395;
  double t396, t397, t400, t401, t402, t403, t404, t407;
  double t408, t412, t416, t417, t422, t424, t425, t426;
  double t430, t431, t435, t438, t441, t443, t448, t449;
  double t450, t453, t455, t459, t467, t468, t472, t475;
  double t476, t477, t478, t481, t482, t483, t487, tvrho1;
  double t490, t493, t494, t495, t496, t500, t503, t506;
  double t507, t509, t510, t513, t515, t518, t520, t525;
  double t531, t534, t538, t541, t545, t548, t549, t552;
  double t553, t554, t557, tvsigma0, tvsigma1, t558, t561, t562;
  double t563, t564, t568, t571, t574, t575, t577, t578;
  double t581, t583, t586, t588, t593, t599, t602, t606;
  double t609, t613, t616, t617, t620, t621, t622, t625;
  double tvsigma2, tvlapl0, tvlapl1, t626, t627, t628, t629, t632;
  double t633, t635, t639, t642, t645, t651, t654, t659;
  double t664, t665, t666, t667, t670, tvtau0, t671, t672;
  double t673, t674, t677, t678, t680, t684, t687, t690;
  double t696, t699, t704, t709, t710, t711, t712, t715;
  double tvtau1;

  double t718, t719, t720, t723, t724, t725, t728, t732;
  double t733, t737, t739, t741, t745, t746, t749, t750;
  double t751, t752, t754, t755, t758, t760, t763, t764;
  double t765, t766, t768, t769, t770, t774, t780, t781;
  double t784, t788, t790, t791, t794, t795, t798, t800;
  double t801, t802, t805, t808, t812, t815, t818, t820;
  double t825, t829, t830, t831, t834, t837, t839, t841;
  double t843, t846, t851, t852, t856, t859, t860, t863;
  double t864, t865, t866, t867, t872, t873, t874, t877;
  double t878, t879, t883, t884, t885, t886, t889, t892;
  double t896, t897, t901, t903, t905, t908, t910, tv2rho20;
  double t913, t917, t921, t922, t926, t928, t930, t936;
  double t937, t941, t945, t946, t950, t952, t955, t958;
  double t959, t962, tv2rho21, t967, t972, t976, t977, t983;
  double t984, t989, t993, t994, t999, t1003, t1004, t1007;
  double t1009, t1012, t1013, t1014, t1015, t1017, t1018, t1019;
  double t1023, t1029, t1030, t1033, t1037, t1039, t1040, t1043;
  double t1044, t1047, t1049, t1050, t1051, t1054, t1057, t1061;
  double t1064, t1067, t1069, t1074, t1078, t1079, t1080, t1083;
  double t1086, t1088, t1090, t1092, t1095, t1100, t1101, t1105;
  double t1108, t1109, t1112, t1113, t1114, t1115, t1120, t1121;
  double t1122, t1125, t1126, t1127, t1131, tv2rho22, t1136, t1138;
  double t1143, t1144, t1145, t1147, t1151, t1158, t1163, t1164;
  double t1166, t1168, t1171, t1174, t1175, t1177, t1180, t1182;
  double t1185, t1187, t1192, t1197, t1200, t1204, t1206, t1209;
  double t1217, t1220, t1221, t1224, t1229, t1232, t1233, t1234;
  double t1237, t1238, t1239, t1243, tv2rhosigma0, tv2rhosigma1, t1247, t1249;
  double t1251, tv2rhosigma2, t1256, tv2rhosigma3, tv2rhosigma4, t1264, t1265, t1266;
  double t1268, t1272, t1279, t1284, t1285, t1287, t1289, t1292;
  double t1295, t1296, t1298, t1301, t1303, t1306, t1308, t1313;
  double t1318, t1321, t1325, t1327, t1330, t1338, t1341, t1342;
  double t1345, t1350, t1353, t1354, t1355, t1358, t1359, t1360;
  double t1364, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1368, t1369;
  double t1371, t1372, t1373, t1377, t1381, t1383, t1387, t1397;
  double t1400, t1407, t1410, t1415, t1420, t1421, t1424, t1429;
  double t1430, t1431, t1434, t1435, t1437, t1438, t1441, t1442;
  double t1446, tv2rhotau0, t1450, t1451, t1453, t1455, tv2rhotau1, t1460;
  double tv2rhotau2, t1464, t1465, t1469, t1473, t1475, t1479, t1489;
  double t1492, t1499, t1502, t1507, t1512, t1513, t1516, t1521;
  double t1522, t1523, t1526, t1527, t1529, t1530, t1533, t1534;
  double t1538, tv2rhotau3, t1540, t1541, t1546, t1547, t1551, t1556;
  double t1558, t1560, t1563, t1564, t1565, t1567, t1574, t1579;
  double t1582, t1585, t1588, t1592, t1595, t1598, t1599, t1600;
  double t1603, t1604, t1605, t1607, t1608, t1609, t1613, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1614, t1615, t1620, t1621;
  double t1625, t1630, t1632, t1634, t1637, t1638, t1639, t1641;
  double t1648, t1653, t1656, t1659, t1662, t1666, t1669, t1672;
  double t1673, t1676, t1677, t1678, t1680, t1681, t1682, t1686;
  double tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1692;
  double t1696, t1705, t1707, t1711, t1712, t1714, t1716, t1725;
  double t1728, t1733, t1734, t1735, t1738, t1739, t1741, t1742;
  double t1745, t1749, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1755;
  double t1759, t1768, t1770, t1774, t1775, t1777, t1779, t1788;
  double t1791, t1796, t1797, t1798, t1801, t1802, t1804, t1805;
  double t1808, t1812, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, t1813, t1814, t1817, t1818, t1821, t1822;
  double t1824, t1828, t1831, t1835, t1839, t1840, t1844, t1851;
  double t1852, t1855, t1860, t1861, t1862, t1864, t1865, t1866;
  double t1867, t1871, tv2tau20, tv2tau21, t1872, t1873, t1876, t1877;
  double t1880, t1881, t1883, t1887, t1890, t1894, t1898, t1899;
  double t1903, t1910, t1911, t1914, t1919, t1920, t1921, t1923;
  double t1924, t1925, t1926, t1930, tv2tau22;

  double t1935, t1939, t1942, t1946, t1948, t1949, t1952, t1955;
  double t1956, t1957, t1960, t1964, t1969, t1970, t1972, t1973;
  double t1977, t1978, t1983, t1986, t1990, t1991, t1992, t1994;
  double t1995, t1997, t1998, t2002, t2006, t2009, t2010, t2011;
  double t2012, t2015, t2016, t2020, t2028, t2029, t2036, t2038;
  double t2039, t2044, t2045, t2048, t2053, t2054, t2055, t2061;
  double t2066, t2069, t2072, t2074, t2079, t2082, t2087, t2089;
  double t2090, t2091, t2094, t2097, t2101, t2103, t2105, t2108;
  double t2116, t2119, t2120, t2123, t2124, t2130, t2132, t2133;
  double t2134, t2136, t2143, t2144, t2145, t2148, t2149, t2151;
  double t2152, t2155, t2158, t2161, t2165, t2172, t2176, t2181;
  double t2183, tv3rho30, t2186, t2187, t2188, t2191, t2196, t2197;
  double t2199, t2203, t2211, t2212, t2217, t2220, t2231, t2232;
  double t2233, t2236, t2241, t2243, t2247, t2255, t2258, t2262;
  double t2266, t2267, t2268, t2271, tv3rho31, t2274, t2279, t2283;
  double t2287, t2294, t2296, t2303, t2304, t2309, t2313, t2317;
  double t2324, t2327, t2330, t2336, t2337, t2341, t2342, t2344;
  double t2345, tv3rho32, t2350, t2357, t2361, t2369, t2372, t2379;
  double t2383, t2388, t2389, t2393, t2394, t2405, t2406, t2410;
  double t2414, t2417, t2418, t2419, t2420, t2423, t2424, t2428;
  double t2436, t2437, t2444, t2446, t2447, t2452, t2453, t2456;
  double t2461, t2462, t2463, t2469, t2474, t2477, t2480, t2482;
  double t2487, t2490, t2495, t2497, t2498, t2499, t2502, t2505;
  double t2509, t2511, t2513, t2516, t2524, t2527, t2528, t2531;
  double t2532, t2538, t2540, t2542, t2549, t2550, t2551, t2554;
  double t2557, t2558, tv3rho33, t2564, t2568, t2571, t2573, t2574;
  double t2575, t2577, t2578, t2580, t2589, t2593, t2595, t2606;
  double t2607, t2609, t2611, t2613, t2617, t2618, t2619, t2622;
  double t2634, t2635, t2637, t2639, t2642, t2644, t2647, t2649;
  double t2654, t2655, t2658, t2671, t2673, t2677, t2682, t2687;
  double t2692, t2695, t2700, t2701, t2704, t2705, t2708, t2709;
  double t2714, t2722, t2727, t2730, t2731, t2732, t2735, t2736;
  double t2739, t2742, t2745, t2746, tv3rho2sigma0, tv3rho2sigma1, t2751, t2753;
  double t2755, t2757, tv3rho2sigma2, t2761, t2765, t2772, tv3rho2sigma3, tv3rho2sigma4;
  double t2776, t2781, t2782, t2784, t2787, t2788, t2791, tv3rho2sigma5;
  double t2798, tv3rho2sigma6, tv3rho2sigma7, t2806, t2815, t2816, t2818, t2820;
  double t2822, t2826, t2827, t2828, t2831, t2843, t2844, t2846;
  double t2848, t2851, t2853, t2856, t2858, t2873, t2875, t2879;
  double t2884, t2887, t2890, t2895, t2896, t2901, t2904, t2909;
  double t2918, t2922, t2924, t2931, t2932, t2935, t2936, t2939;
  double t2940, t2945, t2953, t2958, t2961, t2962, t2963, t2966;
  double t2967, t2970, t2973, t2976, t2977, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2980, t2981, t2983, t2984;
  double t2987, t2994, t2995, t2996, t2998, t2999, t3003, t3007;
  double t3011, t3013, t3017, t3036, t3037, t3040, t3057, t3060;
  double t3065, t3068, t3075, t3080, t3081, t3084, t3087, t3090;
  double t3095, t3096, t3097, t3100, t3102, t3103, t3106, t3109;
  double t3113, t3114, t3116, t3117, t3120, t3121, t3124, t3127;
  double t3128, t3129, t3131, t3132, t3135, t3136, tv3rho2tau0, t3141;
  double t3143, t3144, t3146, t3148, tv3rho2tau1, t3152, t3156, t3166;
  double tv3rho2tau2, t3170, t3175, t3176, t3177, t3179, t3182, t3183;
  double t3184, t3188, t3191, tv3rho2tau3, t3198, tv3rho2tau4, t3203, t3204;
  double t3207, t3212, t3213, t3215, t3216, t3219, t3222, t3223;
  double t3226, t3234, t3235, t3239, t3243, t3247, t3249, t3253;
  double t3272, t3273, t3276, t3293, t3296, t3301, t3304, t3311;
  double t3316, t3317, t3320, t3323, t3326, t3331, t3332, t3333;
  double t3336, t3339, t3340, t3344, t3345, tv3rho2tau5, t3349, t3351;
  double t3352, t3355, t3356, t3357, t3363, t3367, t3380, t3382;
  double t3384, t3386, t3395, t3396, t3397, t3398, t3400, t3401;
  double t3402, t3403, t3404, t3406, t3407, t3409, t3414, t3426;
  double t3429, t3434, t3439, t3442, t3445, t3451, t3452, t3455;
  double t3456, t3459, t3466, t3470, t3473, t3476, t3477, t3478;
  double t3481, t3482, t3487, t3489, t3490, t3493, t3494, t3498;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3502, t3504, t3507;
  double t3509, t3511, tv3rhosigma25, t3518, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t3522, t3525, t3526, t3527, t3533, t3537, t3550;
  double t3552, t3554, t3556, t3565, t3566, t3567, t3568, t3570;
  double t3571, t3572, t3573, t3574, t3576, t3577, t3579, t3584;
  double t3596, t3599, t3604, t3609, t3612, t3615, t3621, t3622;
  double t3625, t3626, t3629, t3636, t3640, t3643, t3646, t3647;
  double t3648, t3651, t3652, t3657, t3660, t3661, t3665, tv3rhosigma211;
  double tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7;
  double tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t3669, t3670, t3672, t3680;
  double t3684, t3700, t3705, t3707, t3709, t3711, t3717, t3720;
  double t3723, t3724, t3726, t3727, t3730, t3735, t3742, t3747;
  double t3754, t3757, t3760, t3765, t3768, t3773, t3774, t3775;
  double t3776, t3779, t3780, t3783, t3784, t3788, t3792, t3794;
  double t3796, t3799, t3802, t3805, t3811, t3812, t3815, t3816;
  double t3819, t3823, t3824, t3827, t3828, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, t3832, t3833, t3835, t3837, t3841, t3843;
  double t3847, t3849, tv3rhosigmatau5, t3854, t3860, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, t3871, t3875, t3891, t3896, t3898, t3900;
  double t3902, t3908, t3911, t3914, t3915, t3917, t3918, t3921;
  double t3926, t3933, t3938, t3945, t3948, t3951, t3956, t3959;
  double t3964, t3965, t3966, t3967, t3970, t3971, t3974, t3975;
  double t3979, t3983, t3986, t3989, t3992, t3997, t4000, t4001;
  double t4004, t4008, t4009, t4012, t4013, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21;
  double tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t4017, t4018, t4020, t4021;
  double t4022, t4025, t4026, t4030, t4034, t4036, t4040, t4054;
  double t4063, t4066, t4070, t4075, t4080, t4087, t4088, t4091;
  double t4092, t4097, t4100, t4105, t4106, t4107, t4110, t4111;
  double t4114, t4115, t4121, t4122, t4123, t4124, t4127, t4128;
  double t4129, t4130, t4131, t4135, t4136, t4140, tv3rhotau20, tv3rhotau21;
  double t4144, t4145, t4147, t4151, t4153, tv3rhotau22, t4160, tv3rhotau23;
  double tv3rhotau24, t4164, t4165, t4168, t4169, t4173, t4177, t4179;
  double t4183, t4197, t4206, t4209, t4213, t4218, t4223, t4230;
  double t4231, t4234, t4235, t4240, t4243, t4248, t4249, t4250;
  double t4253, t4254, t4257, t4258, t4263, t4264, t4265, t4268;
  double t4269, t4270, t4271, t4272, t4276, t4277, t4281, tv3rhotau25;
  double t4283, t4284, t4289, t4290, t4294, t4301, t4303, t4304;
  double t4306, t4309, t4310, t4311, t4312, t4314, t4325, t4328;
  double t4333, t4336, t4339, t4342, t4345, t4346, t4347, t4350;
  double t4353, t4354, t4355, t4359, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t4360, t4361, t4366;
  double t4367, t4371, t4378, t4380, t4381, t4383, t4386, t4387;
  double t4388, t4389, t4391, t4402, t4405, t4410, t4413, t4416;
  double t4419, t4422, t4423, t4424, t4427, t4430, t4431, t4432;
  double t4436, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t4437, t4445;
  double t4449, t4460, t4461, t4463, t4465, t4468, t4470, t4472;
  double t4473, t4475, t4492, t4497, t4504, t4505, t4506, t4510;
  double t4513, t4517, t4518, t4521, t4524, t4527, t4531, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, t4532, t4540, t4544, t4555, t4556, t4558;
  double t4560, t4563, t4565, t4567, t4568, t4570, t4587, t4592;
  double t4599, t4600, t4601, t4605, t4608, t4612, t4613, t4616;
  double t4619, t4622, t4626, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t4634, t4638, t4649, t4650, t4652, t4654, t4657;
  double t4658, t4659, t4661, t4664, t4679, t4682, t4683, t4688;
  double t4691, t4696, t4697, t4698, t4702, t4705, t4708, t4709;
  double t4712, t4716, t4717, t4721, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23;
  double tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t4729, t4733, t4744, t4745;
  double t4747, t4749, t4752, t4753, t4754, t4756, t4759, t4774;
  double t4777, t4778, t4783, t4786, t4791, t4792, t4793, t4797;
  double t4800, t4803, t4804, t4807, t4811, t4812, t4816, tv3sigmatau28;
  double tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3;
  double tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25;
  double t4817, t4818, t4821, t4822, t4825, t4826, t4830, t4832;
  double t4836, t4843, t4846, t4849, t4850, t4853, t4864, t4865;
  double t4868, t4871, t4876, t4877, t4878, t4881, t4883, t4884;
  double t4887, t4889, t4890, t4891, t4892, t4893, t4894, t4898;
  double tv3tau30, tv3tau31, tv3tau32, t4899, t4900, t4903, t4904, t4907;
  double t4908, t4912, t4914, t4918, t4925, t4928, t4931, t4932;
  double t4935, t4946, t4947, t4950, t4953, t4958, t4959, t4960;
  double t4963, t4965, t4966, t4969, t4971, t4972, t4973, t4974;
  double t4978, tv3tau33;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = sigma[0] * sigma[0];
  t30 = params->c * t29;
  t31 = rho[0] * rho[0];
  t32 = 0.1e1 / t31;
  t33 = tau[0] * tau[0];
  t34 = 0.1e1 / t33;
  t35 = t32 * t34;
  t36 = t29 * t32;
  t37 = t36 * t34;
  t39 = 0.1e1 + t37 / 0.64e2;
  t40 = t39 * t39;
  t41 = 0.1e1 / t40;
  t42 = t35 * t41;
  t46 = M_CBRT6;
  t47 = (0.1e2 / 0.81e2 + t30 * t42 / 0.64e2) * t46;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t51 * sigma[0];
  t53 = POW_1_3(rho[0]);
  t54 = t53 * t53;
  t56 = 0.1e1 / t54 / t31;
  t57 = t52 * t56;
  t61 = 0.1e1 / t54 / rho[0];
  t63 = sigma[0] * t56;
  t65 = tau[0] * t61 - t63 / 0.8e1;
  t69 = 0.5e1 / 0.9e1 * t65 * t46 * t51 - 0.1e1;
  t70 = params->b * t65;
  t71 = t46 * t51;
  t72 = t71 * t69;
  t75 = 0.5e1 * t70 * t72 + 0.9e1;
  t76 = sqrt(t75);
  t77 = 0.1e1 / t76;
  t82 = 0.27e2 / 0.2e2 * t69 * t77 + t71 * t63 / 0.36e2;
  t83 = t82 * t82;
  t86 = t46 * t46;
  t88 = 0.1e1 / t49 / t48;
  t89 = t86 * t88;
  t90 = t31 * t31;
  t91 = t90 * rho[0];
  t93 = 0.1e1 / t53 / t91;
  t97 = 0.5e2 * t89 * t29 * t93 + 0.162e3 * t37;
  t98 = sqrt(t97);
  t101 = 0.1e1 / params->kappa;
  t102 = t101 * t86;
  t103 = t88 * t29;
  t107 = sqrt(params->e);
  t108 = t107 * t29;
  t111 = params->e * params->mu;
  t112 = t48 * t48;
  t113 = 0.1e1 / t112;
  t114 = t29 * sigma[0];
  t115 = t113 * t114;
  t116 = t90 * t90;
  t117 = 0.1e1 / t116;
  t121 = t47 * t57 / 0.24e2 + 0.146e3 / 0.2025e4 * t83 - 0.73e2 / 0.972e5 * t82 * t98 + 0.25e2 / 0.944784e6 * t102 * t103 * t93 + t108 * t35 / 0.72e3 + t111 * t115 * t117 / 0.2304e4;
  t122 = t107 * t46;
  t125 = 0.1e1 + t122 * t57 / 0.24e2;
  t126 = t125 * t125;
  t127 = 0.1e1 / t126;
  t130 = exp(-t121 * t127 * t101);
  t133 = 0.1e1 + params->kappa * (0.1e1 - t130);
  t137 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t133);
  t138 = rho[1] <= p->dens_threshold;
  t139 = -t17;
  t141 = my_piecewise5(t15, t12, t11, t16, t139 * t8);
  t142 = 0.1e1 + t141;
  t143 = t142 <= p->zeta_threshold;
  t144 = POW_1_3(t142);
  t146 = my_piecewise3(t143, t23, t144 * t142);
  t147 = t146 * t27;
  t148 = sigma[2] * sigma[2];
  t149 = params->c * t148;
  t150 = rho[1] * rho[1];
  t151 = 0.1e1 / t150;
  t152 = tau[1] * tau[1];
  t153 = 0.1e1 / t152;
  t154 = t151 * t153;
  t155 = t148 * t151;
  t156 = t155 * t153;
  t158 = 0.1e1 + t156 / 0.64e2;
  t159 = t158 * t158;
  t160 = 0.1e1 / t159;
  t161 = t154 * t160;
  t165 = (0.1e2 / 0.81e2 + t149 * t161 / 0.64e2) * t46;
  t166 = t51 * sigma[2];
  t167 = POW_1_3(rho[1]);
  t168 = t167 * t167;
  t170 = 0.1e1 / t168 / t150;
  t171 = t166 * t170;
  t175 = 0.1e1 / t168 / rho[1];
  t177 = sigma[2] * t170;
  t179 = tau[1] * t175 - t177 / 0.8e1;
  t183 = 0.5e1 / 0.9e1 * t179 * t46 * t51 - 0.1e1;
  t184 = params->b * t179;
  t185 = t71 * t183;
  t188 = 0.5e1 * t184 * t185 + 0.9e1;
  t189 = sqrt(t188);
  t190 = 0.1e1 / t189;
  t195 = 0.27e2 / 0.2e2 * t183 * t190 + t71 * t177 / 0.36e2;
  t196 = t195 * t195;
  t199 = t150 * t150;
  t200 = t199 * rho[1];
  t202 = 0.1e1 / t167 / t200;
  t206 = 0.5e2 * t89 * t148 * t202 + 0.162e3 * t156;
  t207 = sqrt(t206);
  t210 = t88 * t148;
  t214 = t107 * t148;
  t217 = t148 * sigma[2];
  t218 = t113 * t217;
  t219 = t199 * t199;
  t220 = 0.1e1 / t219;
  t224 = t165 * t171 / 0.24e2 + 0.146e3 / 0.2025e4 * t196 - 0.73e2 / 0.972e5 * t195 * t207 + 0.25e2 / 0.944784e6 * t102 * t210 * t202 + t214 * t154 / 0.72e3 + t111 * t218 * t220 / 0.2304e4;
  t227 = 0.1e1 + t122 * t171 / 0.24e2;
  t228 = t227 * t227;
  t229 = 0.1e1 / t228;
  t232 = exp(-t224 * t229 * t101);
  t235 = 0.1e1 + params->kappa * (0.1e1 - t232);
  t239 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t147 * t235);
  tzk0 = t137 + t239;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t240 = t7 * t7;
  t241 = 0.1e1 / t240;
  t242 = t17 * t241;
  t244 = my_piecewise5(t11, 0, t15, 0, t8 - t242);
  t247 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t244);
  t248 = t247 * t27;
  t252 = t27 * t27;
  t253 = 0.1e1 / t252;
  t254 = t26 * t253;
  t257 = t6 * t254 * t133 / 0.8e1;
  t258 = t6 * t26;
  t259 = t27 * params->kappa;
  t260 = t31 * rho[0];
  t261 = 0.1e1 / t260;
  t262 = t261 * t34;
  t263 = t262 * t41;
  t266 = t29 * t29;
  t267 = params->c * t266;
  t268 = 0.1e1 / t91;
  t269 = t33 * t33;
  t270 = 0.1e1 / t269;
  t273 = 0.1e1 / t40 / t39;
  t274 = t268 * t270 * t273;
  t278 = (-t30 * t263 / 0.32e2 + t267 * t274 / 0.1024e4) * t46;
  t282 = 0.1e1 / t54 / t260;
  t283 = t52 * t282;
  t288 = sigma[0] * t282;
  t290 = -0.5e1 / 0.3e1 * tau[0] * t56 + t288 / 0.3e1;
  t291 = t290 * t46;
  t292 = t51 * t77;
  t296 = 0.1e1 / t76 / t75;
  t297 = t69 * t296;
  t301 = t89 * t290;
  t304 = 0.5e1 * params->b * t290 * t72 + 0.25e2 / 0.9e1 * t70 * t301;
  t307 = t71 * t288;
  t309 = 0.3e1 / 0.4e1 * t291 * t292 - 0.27e2 / 0.4e2 * t297 * t304 - 0.2e1 / 0.27e2 * t307;
  t314 = 0.1e1 / t98;
  t315 = t82 * t314;
  t316 = t29 * t261;
  t319 = t90 * t31;
  t321 = 0.1e1 / t53 / t319;
  t325 = -0.324e3 * t316 * t34 - 0.8e3 / 0.3e1 * t89 * t29 * t321;
  t333 = t116 * rho[0];
  t334 = 0.1e1 / t333;
  t338 = t278 * t57 / 0.24e2 - t47 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t82 * t309 - 0.73e2 / 0.972e5 * t309 * t98 - 0.73e2 / 0.1944e6 * t315 * t325 - 0.25e2 / 0.177147e6 * t102 * t103 * t321 - t108 * t262 / 0.36e3 - t111 * t115 * t334 / 0.288e3;
  t341 = t126 * t125;
  t342 = 0.1e1 / t341;
  t343 = t121 * t342;
  t344 = t101 * t107;
  t345 = t343 * t344;
  t348 = -t338 * t127 * t101 - 0.2e1 / 0.9e1 * t345 * t307;
  t349 = t348 * t130;
  t350 = t259 * t349;
  t354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t248 * t133 - t257 + 0.3e1 / 0.8e1 * t258 * t350);
  t355 = t139 * t241;
  t357 = my_piecewise5(t15, 0, t11, 0, -t8 - t355);
  t360 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t357);
  t361 = t360 * t27;
  t365 = t146 * t253;
  t368 = t6 * t365 * t235 / 0.8e1;
  t370 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t361 * t235 - t368);
  tvrho0 = t137 + t239 + t7 * (t354 + t370);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t374 = my_piecewise5(t11, 0, t15, 0, -t8 - t242);
  t377 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t374);
  t378 = t377 * t27;
  t383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t378 * t133 - t257);
  t385 = my_piecewise5(t15, 0, t11, 0, t8 - t355);
  t388 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t385);
  t389 = t388 * t27;
  t393 = t6 * t146;
  t394 = t150 * rho[1];
  t395 = 0.1e1 / t394;
  t396 = t395 * t153;
  t397 = t396 * t160;
  t400 = t148 * t148;
  t401 = params->c * t400;
  t402 = 0.1e1 / t200;
  t403 = t152 * t152;
  t404 = 0.1e1 / t403;
  t407 = 0.1e1 / t159 / t158;
  t408 = t402 * t404 * t407;
  t412 = (-t149 * t397 / 0.32e2 + t401 * t408 / 0.1024e4) * t46;
  t416 = 0.1e1 / t168 / t394;
  t417 = t166 * t416;
  t422 = sigma[2] * t416;
  t424 = -0.5e1 / 0.3e1 * tau[1] * t170 + t422 / 0.3e1;
  t425 = t424 * t46;
  t426 = t51 * t190;
  t430 = 0.1e1 / t189 / t188;
  t431 = t183 * t430;
  t435 = t89 * t424;
  t438 = 0.5e1 * params->b * t424 * t185 + 0.25e2 / 0.9e1 * t184 * t435;
  t441 = t71 * t422;
  t443 = 0.3e1 / 0.4e1 * t425 * t426 - 0.27e2 / 0.4e2 * t431 * t438 - 0.2e1 / 0.27e2 * t441;
  t448 = 0.1e1 / t207;
  t449 = t195 * t448;
  t450 = t148 * t395;
  t453 = t199 * t150;
  t455 = 0.1e1 / t167 / t453;
  t459 = -0.324e3 * t450 * t153 - 0.8e3 / 0.3e1 * t89 * t148 * t455;
  t467 = t219 * rho[1];
  t468 = 0.1e1 / t467;
  t472 = t412 * t171 / 0.24e2 - t165 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t195 * t443 - 0.73e2 / 0.972e5 * t443 * t207 - 0.73e2 / 0.1944e6 * t449 * t459 - 0.25e2 / 0.177147e6 * t102 * t210 * t455 - t214 * t396 / 0.36e3 - t111 * t218 * t468 / 0.288e3;
  t475 = t228 * t227;
  t476 = 0.1e1 / t475;
  t477 = t224 * t476;
  t478 = t477 * t344;
  t481 = -t472 * t229 * t101 - 0.2e1 / 0.9e1 * t478 * t441;
  t482 = t481 * t232;
  t483 = t259 * t482;
  t487 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t389 * t235 - t368 + 0.3e1 / 0.8e1 * t393 * t483);
  tvrho1 = t137 + t239 + t7 * (t383 + t487);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t490 = params->c * sigma[0];
  t493 = params->c * t114;
  t494 = 0.1e1 / t90;
  t495 = t494 * t270;
  t496 = t495 * t273;
  t500 = (t490 * t42 / 0.32e2 - t493 * t496 / 0.1024e4) * t46;
  t503 = t51 * t56;
  t506 = t56 * t46;
  t507 = t506 * t292;
  t509 = params->b * t56;
  t510 = t509 * t72;
  t513 = t70 * t89 * t56;
  t515 = -0.5e1 / 0.8e1 * t510 - 0.25e2 / 0.72e2 * t513;
  t518 = t506 * t51;
  t520 = -0.3e1 / 0.32e2 * t507 - 0.27e2 / 0.4e2 * t297 * t515 + t518 / 0.36e2;
  t525 = sigma[0] * t32;
  t531 = 0.1e3 * t89 * sigma[0] * t93 + 0.324e3 * t525 * t34;
  t534 = t88 * sigma[0];
  t538 = t107 * sigma[0];
  t541 = t113 * t29;
  t545 = t500 * t57 / 0.24e2 + t47 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t520 - 0.73e2 / 0.972e5 * t520 * t98 - 0.73e2 / 0.1944e6 * t315 * t531 + 0.25e2 / 0.472392e6 * t102 * t534 * t93 + t538 * t35 / 0.36e3 + t111 * t541 * t117 / 0.768e3;
  t548 = t343 * t101;
  t549 = t122 * t503;
  t552 = -t545 * t127 * t101 + t548 * t549 / 0.12e2;
  t553 = t552 * t130;
  t554 = t259 * t553;
  t557 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t554);
  tvsigma0 = t7 * t557;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t558 = params->c * sigma[2];
  t561 = params->c * t217;
  t562 = 0.1e1 / t199;
  t563 = t562 * t404;
  t564 = t563 * t407;
  t568 = (t558 * t161 / 0.32e2 - t561 * t564 / 0.1024e4) * t46;
  t571 = t51 * t170;
  t574 = t170 * t46;
  t575 = t574 * t426;
  t577 = params->b * t170;
  t578 = t577 * t185;
  t581 = t184 * t89 * t170;
  t583 = -0.5e1 / 0.8e1 * t578 - 0.25e2 / 0.72e2 * t581;
  t586 = t574 * t51;
  t588 = -0.3e1 / 0.32e2 * t575 - 0.27e2 / 0.4e2 * t431 * t583 + t586 / 0.36e2;
  t593 = sigma[2] * t151;
  t599 = 0.1e3 * t89 * sigma[2] * t202 + 0.324e3 * t593 * t153;
  t602 = t88 * sigma[2];
  t606 = t107 * sigma[2];
  t609 = t113 * t148;
  t613 = t568 * t171 / 0.24e2 + t165 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t588 - 0.73e2 / 0.972e5 * t588 * t207 - 0.73e2 / 0.1944e6 * t449 * t599 + 0.25e2 / 0.472392e6 * t102 * t602 * t202 + t606 * t154 / 0.36e3 + t111 * t609 * t220 / 0.768e3;
  t616 = t477 * t101;
  t617 = t122 * t571;
  t620 = -t613 * t229 * t101 + t616 * t617 / 0.12e2;
  t621 = t620 * t232;
  t622 = t259 * t621;
  t625 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t622);
  tvsigma2 = t7 * t625;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t626 = t33 * tau[0];
  t627 = 0.1e1 / t626;
  t628 = t32 * t627;
  t629 = t628 * t41;
  t632 = t269 * tau[0];
  t633 = 0.1e1 / t632;
  t635 = t494 * t633 * t273;
  t639 = (-t30 * t629 / 0.32e2 + t267 * t635 / 0.1024e4) * t46;
  t642 = t61 * t46;
  t645 = params->b * t61;
  t651 = 0.5e1 * t645 * t72 + 0.25e2 / 0.9e1 * t70 * t89 * t61;
  t654 = 0.3e1 / 0.4e1 * t642 * t292 - 0.27e2 / 0.4e2 * t297 * t651;
  t659 = t36 * t627;
  t664 = t639 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t654 - 0.73e2 / 0.972e5 * t654 * t98 + 0.73e2 / 0.6e3 * t315 * t659 - t108 * t628 / 0.36e3;
  t665 = t27 * t664;
  t666 = t127 * t130;
  t667 = t665 * t666;
  t670 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t667);
  tvtau0 = t7 * t670;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t671 = t152 * tau[1];
  t672 = 0.1e1 / t671;
  t673 = t151 * t672;
  t674 = t673 * t160;
  t677 = t403 * tau[1];
  t678 = 0.1e1 / t677;
  t680 = t562 * t678 * t407;
  t684 = (-t149 * t674 / 0.32e2 + t401 * t680 / 0.1024e4) * t46;
  t687 = t175 * t46;
  t690 = params->b * t175;
  t696 = 0.5e1 * t690 * t185 + 0.25e2 / 0.9e1 * t184 * t89 * t175;
  t699 = 0.3e1 / 0.4e1 * t687 * t426 - 0.27e2 / 0.4e2 * t431 * t696;
  t704 = t155 * t672;
  t709 = t684 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t699 - 0.73e2 / 0.972e5 * t699 * t207 + 0.73e2 / 0.6e3 * t449 * t704 - t214 * t673 / 0.36e3;
  t710 = t27 * t709;
  t711 = t229 * t232;
  t712 = t710 * t711;
  t715 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t712);
  tvtau1 = t7 * t715;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t718 = t24 * t24;
  t719 = 0.1e1 / t718;
  t720 = t244 * t244;
  t723 = t240 * t7;
  t724 = 0.1e1 / t723;
  t725 = t17 * t724;
  t728 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t241 + 0.2e1 * t725);
  t732 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t720 + 0.4e1 / 0.3e1 * t24 * t728);
  t733 = t732 * t27;
  t737 = t247 * t253;
  t739 = t6 * t737 * t133;
  t741 = t6 * t247;
  t745 = 0.1e1 / t252 / t7;
  t746 = t26 * t745;
  t749 = t6 * t746 * t133 / 0.12e2;
  t750 = t253 * params->kappa;
  t751 = t750 * t349;
  t752 = t258 * t751;
  t754 = t494 * t34;
  t755 = t754 * t41;
  t758 = 0.1e1 / t319;
  t760 = t758 * t270 * t273;
  t763 = t266 * t29;
  t764 = params->c * t763;
  t765 = t269 * t33;
  t766 = 0.1e1 / t765;
  t768 = t40 * t40;
  t769 = 0.1e1 / t768;
  t770 = t117 * t766 * t769;
  t774 = (0.3e1 / 0.32e2 * t30 * t755 - 0.7e1 / 0.1024e4 * t267 * t760 + 0.3e1 / 0.32768e5 * t764 * t770) * t46;
  t780 = 0.1e1 / t54 / t90;
  t781 = t52 * t780;
  t784 = t309 * t309;
  t788 = sigma[0] * t780;
  t790 = 0.4e2 / 0.9e1 * tau[0] * t282 - 0.11e2 / 0.9e1 * t788;
  t791 = t790 * t46;
  t794 = t51 * t296;
  t795 = t794 * t304;
  t798 = t75 * t75;
  t800 = 0.1e1 / t76 / t798;
  t801 = t69 * t800;
  t802 = t304 * t304;
  t805 = params->b * t790;
  t808 = t290 * t290;
  t812 = t89 * t790;
  t815 = 0.5e1 * t805 * t72 + 0.5e2 / 0.9e1 * params->b * t808 * t89 + 0.25e2 / 0.9e1 * t70 * t812;
  t818 = t71 * t788;
  t820 = 0.3e1 / 0.4e1 * t791 * t292 - 0.3e1 / 0.4e1 * t291 * t795 + 0.81e2 / 0.8e2 * t801 * t802 - 0.27e2 / 0.4e2 * t297 * t815 + 0.22e2 / 0.81e2 * t818;
  t825 = t309 * t314;
  t829 = 0.1e1 / t98 / t97;
  t830 = t82 * t829;
  t831 = t325 * t325;
  t834 = t29 * t494;
  t837 = t90 * t260;
  t839 = 0.1e1 / t53 / t837;
  t841 = t89 * t29 * t839;
  t843 = 0.972e3 * t834 * t34 + 0.152e5 / 0.9e1 * t841;
  t846 = t103 * t839;
  t851 = t116 * t31;
  t852 = 0.1e1 / t851;
  t856 = t774 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t278 * t283 + 0.11e2 / 0.27e2 * t47 * t781 + 0.292e3 / 0.2025e4 * t784 + 0.292e3 / 0.2025e4 * t82 * t820 - 0.73e2 / 0.972e5 * t820 * t98 - 0.73e2 / 0.972e5 * t825 * t325 + 0.73e2 / 0.3888e6 * t830 * t831 - 0.73e2 / 0.1944e6 * t315 * t843 + 0.475e3 / 0.531441e6 * t102 * t846 + t108 * t754 / 0.12e3 + t111 * t115 * t852 / 0.32e2;
  t859 = t338 * t342;
  t860 = t859 * t344;
  t863 = t126 * t126;
  t864 = 0.1e1 / t863;
  t865 = t121 * t864;
  t866 = t101 * params->e;
  t867 = t865 * t866;
  t872 = -t856 * t127 * t101 - 0.4e1 / 0.9e1 * t860 * t307 - 0.2e1 / 0.27e2 * t867 * t841 + 0.22e2 / 0.27e2 * t345 * t818;
  t873 = t872 * t130;
  t874 = t259 * t873;
  t877 = t348 * t348;
  t878 = t877 * t130;
  t879 = t259 * t878;
  t883 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t733 * t133 - t739 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t350 + t749 + t752 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t874 + 0.3e1 / 0.8e1 * t258 * t879);
  t884 = t144 * t144;
  t885 = 0.1e1 / t884;
  t886 = t357 * t357;
  t889 = t139 * t724;
  t892 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t241 + 0.2e1 * t889);
  t896 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t886 + 0.4e1 / 0.3e1 * t144 * t892);
  t897 = t896 * t27;
  t901 = t360 * t253;
  t903 = t6 * t901 * t235;
  t905 = t146 * t745;
  t908 = t6 * t905 * t235 / 0.12e2;
  t910 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t897 * t235 - t903 / 0.4e1 + t908);
  tv2rho20 = 0.2e1 * t354 + 0.2e1 * t370 + t7 * (t883 + t910);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t913 = t719 * t374;
  t917 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t725);
  t921 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t913 * t244 + 0.4e1 / 0.3e1 * t24 * t917);
  t922 = t921 * t27;
  t926 = t377 * t253;
  t928 = t6 * t926 * t133;
  t930 = t6 * t377;
  t936 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t922 * t133 - t928 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t350 - t739 / 0.8e1 + t749 + t752 / 0.8e1);
  t937 = t885 * t385;
  t941 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t889);
  t945 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t937 * t357 + 0.4e1 / 0.3e1 * t144 * t941);
  t946 = t945 * t27;
  t950 = t388 * t253;
  t952 = t6 * t950 * t235;
  t955 = t6 * t360;
  t958 = t750 * t482;
  t959 = t393 * t958;
  t962 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t946 * t235 - t952 / 0.8e1 - t903 / 0.8e1 + t908 + 0.3e1 / 0.8e1 * t955 * t483 + t959 / 0.8e1);
  tv2rho21 = t354 + t370 + t383 + t487 + t7 * (t936 + t962);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t967 = t374 * t374;
  t972 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t241 + 0.2e1 * t725);
  t976 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t967 + 0.4e1 / 0.3e1 * t24 * t972);
  t977 = t976 * t27;
  t983 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t977 * t133 - t928 / 0.4e1 + t749);
  t984 = t385 * t385;
  t989 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t241 + 0.2e1 * t889);
  t993 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t984 + 0.4e1 / 0.3e1 * t144 * t989);
  t994 = t993 * t27;
  t999 = t6 * t388;
  t1003 = t562 * t153;
  t1004 = t1003 * t160;
  t1007 = 0.1e1 / t453;
  t1009 = t1007 * t404 * t407;
  t1012 = t400 * t148;
  t1013 = params->c * t1012;
  t1014 = t403 * t152;
  t1015 = 0.1e1 / t1014;
  t1017 = t159 * t159;
  t1018 = 0.1e1 / t1017;
  t1019 = t220 * t1015 * t1018;
  t1023 = (0.3e1 / 0.32e2 * t149 * t1004 - 0.7e1 / 0.1024e4 * t401 * t1009 + 0.3e1 / 0.32768e5 * t1013 * t1019) * t46;
  t1029 = 0.1e1 / t168 / t199;
  t1030 = t166 * t1029;
  t1033 = t443 * t443;
  t1037 = sigma[2] * t1029;
  t1039 = 0.4e2 / 0.9e1 * tau[1] * t416 - 0.11e2 / 0.9e1 * t1037;
  t1040 = t1039 * t46;
  t1043 = t51 * t430;
  t1044 = t1043 * t438;
  t1047 = t188 * t188;
  t1049 = 0.1e1 / t189 / t1047;
  t1050 = t183 * t1049;
  t1051 = t438 * t438;
  t1054 = params->b * t1039;
  t1057 = t424 * t424;
  t1061 = t89 * t1039;
  t1064 = 0.5e1 * t1054 * t185 + 0.5e2 / 0.9e1 * params->b * t1057 * t89 + 0.25e2 / 0.9e1 * t184 * t1061;
  t1067 = t71 * t1037;
  t1069 = 0.3e1 / 0.4e1 * t1040 * t426 - 0.3e1 / 0.4e1 * t425 * t1044 + 0.81e2 / 0.8e2 * t1050 * t1051 - 0.27e2 / 0.4e2 * t431 * t1064 + 0.22e2 / 0.81e2 * t1067;
  t1074 = t443 * t448;
  t1078 = 0.1e1 / t207 / t206;
  t1079 = t195 * t1078;
  t1080 = t459 * t459;
  t1083 = t148 * t562;
  t1086 = t199 * t394;
  t1088 = 0.1e1 / t167 / t1086;
  t1090 = t89 * t148 * t1088;
  t1092 = 0.972e3 * t1083 * t153 + 0.152e5 / 0.9e1 * t1090;
  t1095 = t210 * t1088;
  t1100 = t219 * t150;
  t1101 = 0.1e1 / t1100;
  t1105 = t1023 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t412 * t417 + 0.11e2 / 0.27e2 * t165 * t1030 + 0.292e3 / 0.2025e4 * t1033 + 0.292e3 / 0.2025e4 * t195 * t1069 - 0.73e2 / 0.972e5 * t1069 * t207 - 0.73e2 / 0.972e5 * t1074 * t459 + 0.73e2 / 0.3888e6 * t1079 * t1080 - 0.73e2 / 0.1944e6 * t449 * t1092 + 0.475e3 / 0.531441e6 * t102 * t1095 + t214 * t1003 / 0.12e3 + t111 * t218 * t1101 / 0.32e2;
  t1108 = t472 * t476;
  t1109 = t1108 * t344;
  t1112 = t228 * t228;
  t1113 = 0.1e1 / t1112;
  t1114 = t224 * t1113;
  t1115 = t1114 * t866;
  t1120 = -t1105 * t229 * t101 - 0.4e1 / 0.9e1 * t1109 * t441 - 0.2e1 / 0.27e2 * t1115 * t1090 + 0.22e2 / 0.27e2 * t478 * t1067;
  t1121 = t1120 * t232;
  t1122 = t259 * t1121;
  t1125 = t481 * t481;
  t1126 = t1125 * t232;
  t1127 = t259 * t1126;
  t1131 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t994 * t235 - t952 / 0.4e1 + 0.3e1 / 0.4e1 * t999 * t483 + t908 + t959 / 0.4e1 + 0.3e1 / 0.8e1 * t393 * t1122 + 0.3e1 / 0.8e1 * t393 * t1127);
  tv2rho22 = 0.2e1 * t383 + 0.2e1 * t487 + t7 * (t983 + t1131);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1136 = t750 * t553;
  t1138 = t258 * t1136 / 0.8e1;
  t1143 = t266 * sigma[0];
  t1144 = params->c * t1143;
  t1145 = 0.1e1 / t837;
  t1147 = t1145 * t766 * t769;
  t1151 = (-t490 * t263 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t274 - 0.3e1 / 0.32768e5 * t1144 * t1147) * t46;
  t1158 = t51 * t282;
  t1163 = t282 * t46;
  t1164 = t1163 * t292;
  t1166 = t506 * t795;
  t1168 = t794 * t515;
  t1171 = t515 * t304;
  t1174 = params->b * t282;
  t1175 = t1174 * t72;
  t1177 = t509 * t301;
  t1180 = t70 * t89 * t282;
  t1182 = 0.5e1 / 0.3e1 * t1175 - 0.25e2 / 0.36e2 * t1177 + 0.25e2 / 0.27e2 * t1180;
  t1185 = t1163 * t51;
  t1187 = t1164 / 0.4e1 + 0.3e1 / 0.64e2 * t1166 - 0.3e1 / 0.8e1 * t291 * t1168 + 0.81e2 / 0.8e2 * t801 * t1171 - 0.27e2 / 0.4e2 * t297 * t1182 - 0.2e1 / 0.27e2 * t1185;
  t1192 = t520 * t314;
  t1197 = t531 * t325;
  t1200 = sigma[0] * t261;
  t1204 = t89 * sigma[0] * t321;
  t1206 = -0.648e3 * t1200 * t34 - 0.16e4 / 0.3e1 * t1204;
  t1209 = t534 * t321;
  t1217 = t1151 * t57 / 0.24e2 - t500 * t283 / 0.9e1 + t278 * t503 / 0.24e2 - t47 * t1158 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t520 + 0.292e3 / 0.2025e4 * t82 * t1187 - 0.73e2 / 0.972e5 * t1187 * t98 - 0.73e2 / 0.1944e6 * t1192 * t325 - 0.73e2 / 0.1944e6 * t825 * t531 + 0.73e2 / 0.3888e6 * t830 * t1197 - 0.73e2 / 0.1944e6 * t315 * t1206 - 0.5e2 / 0.177147e6 * t102 * t1209 - t538 * t262 / 0.18e3 - t111 * t541 * t334 / 0.96e2;
  t1220 = t545 * t342;
  t1221 = t1220 * t344;
  t1224 = t859 * t101;
  t1229 = t122 * t1158;
  t1232 = -t1217 * t127 * t101 - 0.2e1 / 0.9e1 * t1221 * t307 + t1224 * t549 / 0.12e2 + t867 * t1204 / 0.36e2 - 0.2e1 / 0.9e1 * t548 * t1229;
  t1233 = t1232 * t130;
  t1234 = t259 * t1233;
  t1237 = t6 * t28;
  t1238 = params->kappa * t552;
  t1239 = t1238 * t349;
  t1243 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t741 * t554 + t1138 + 0.3e1 / 0.8e1 * t258 * t1234 + 0.3e1 / 0.8e1 * t1237 * t1239);
  tv2rhosigma0 = t7 * t1243 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t1247 = t750 * t621;
  t1249 = t393 * t1247 / 0.8e1;
  t1251 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t622 + t1249);
  tv2rhosigma2 = t7 * t1251 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1256 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t554 + t1138);
  tv2rhosigma3 = t7 * t1256 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1264 = t400 * sigma[2];
  t1265 = params->c * t1264;
  t1266 = 0.1e1 / t1086;
  t1268 = t1266 * t1015 * t1018;
  t1272 = (-t558 * t397 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t408 - 0.3e1 / 0.32768e5 * t1265 * t1268) * t46;
  t1279 = t51 * t416;
  t1284 = t416 * t46;
  t1285 = t1284 * t426;
  t1287 = t574 * t1044;
  t1289 = t1043 * t583;
  t1292 = t583 * t438;
  t1295 = params->b * t416;
  t1296 = t1295 * t185;
  t1298 = t577 * t435;
  t1301 = t184 * t89 * t416;
  t1303 = 0.5e1 / 0.3e1 * t1296 - 0.25e2 / 0.36e2 * t1298 + 0.25e2 / 0.27e2 * t1301;
  t1306 = t1284 * t51;
  t1308 = t1285 / 0.4e1 + 0.3e1 / 0.64e2 * t1287 - 0.3e1 / 0.8e1 * t425 * t1289 + 0.81e2 / 0.8e2 * t1050 * t1292 - 0.27e2 / 0.4e2 * t431 * t1303 - 0.2e1 / 0.27e2 * t1306;
  t1313 = t588 * t448;
  t1318 = t599 * t459;
  t1321 = sigma[2] * t395;
  t1325 = t89 * sigma[2] * t455;
  t1327 = -0.648e3 * t1321 * t153 - 0.16e4 / 0.3e1 * t1325;
  t1330 = t602 * t455;
  t1338 = t1272 * t171 / 0.24e2 - t568 * t417 / 0.9e1 + t412 * t571 / 0.24e2 - t165 * t1279 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t588 + 0.292e3 / 0.2025e4 * t195 * t1308 - 0.73e2 / 0.972e5 * t1308 * t207 - 0.73e2 / 0.1944e6 * t1313 * t459 - 0.73e2 / 0.1944e6 * t1074 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1318 - 0.73e2 / 0.1944e6 * t449 * t1327 - 0.5e2 / 0.177147e6 * t102 * t1330 - t606 * t396 / 0.18e3 - t111 * t609 * t468 / 0.96e2;
  t1341 = t613 * t476;
  t1342 = t1341 * t344;
  t1345 = t1108 * t101;
  t1350 = t122 * t1279;
  t1353 = -t1338 * t229 * t101 - 0.2e1 / 0.9e1 * t1342 * t441 + t1345 * t617 / 0.12e2 + t1115 * t1325 / 0.36e2 - 0.2e1 / 0.9e1 * t616 * t1350;
  t1354 = t1353 * t232;
  t1355 = t259 * t1354;
  t1358 = t6 * t147;
  t1359 = params->kappa * t620;
  t1360 = t1359 * t482;
  t1364 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t999 * t622 + t1249 + 0.3e1 / 0.8e1 * t393 * t1355 + 0.3e1 / 0.8e1 * t1358 * t1360);
  tv2rhosigma5 = t7 * t1364 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1368 = t253 * t664;
  t1369 = t1368 * t666;
  t1371 = t258 * t1369 / 0.8e1;
  t1372 = t261 * t627;
  t1373 = t1372 * t41;
  t1377 = t268 * t633 * t273;
  t1381 = 0.1e1 / t269 / t626;
  t1383 = t1145 * t1381 * t769;
  t1387 = (t30 * t1373 / 0.16e2 - 0.3e1 / 0.512e3 * t267 * t1377 + 0.3e1 / 0.32768e5 * t764 * t1383) * t46;
  t1397 = t794 * t651;
  t1400 = t651 * t304;
  t1407 = -0.25e2 / 0.3e1 * t510 + 0.5e2 / 0.9e1 * t645 * t301 - 0.125e3 / 0.27e2 * t513;
  t1410 = -0.5e1 / 0.4e1 * t507 - 0.3e1 / 0.8e1 * t642 * t795 - 0.3e1 / 0.8e1 * t291 * t1397 + 0.81e2 / 0.8e2 * t801 * t1400 - 0.27e2 / 0.4e2 * t297 * t1407;
  t1415 = t654 * t314;
  t1420 = t830 * t29;
  t1421 = t628 * t325;
  t1424 = t316 * t627;
  t1429 = t1387 * t57 / 0.24e2 - t639 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t654 + 0.292e3 / 0.2025e4 * t82 * t1410 - 0.73e2 / 0.972e5 * t1410 * t98 - 0.73e2 / 0.1944e6 * t1415 * t325 + 0.73e2 / 0.6e3 * t825 * t659 - 0.73e2 / 0.12e4 * t1420 * t1421 - 0.73e2 / 0.3e3 * t315 * t1424 + t108 * t1372 / 0.18e3;
  t1430 = t27 * t1429;
  t1431 = t1430 * t666;
  t1434 = t665 * t342;
  t1435 = t258 * t1434;
  t1437 = t130 * t107 * t46;
  t1438 = t1437 * t283;
  t1441 = t664 * t127;
  t1442 = t1441 * t349;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t741 * t667 - t1371 - 0.3e1 / 0.8e1 * t258 * t1431 - t1435 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t1442);
  tv2rhotau0 = t7 * t1446 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1450 = t253 * t709;
  t1451 = t1450 * t711;
  t1453 = t393 * t1451 / 0.8e1;
  t1455 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t712 - t1453);
  tv2rhotau1 = t7 * t1455 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1460 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t667 - t1371);
  tv2rhotau2 = t7 * t1460 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1464 = t395 * t672;
  t1465 = t1464 * t160;
  t1469 = t402 * t678 * t407;
  t1473 = 0.1e1 / t403 / t671;
  t1475 = t1266 * t1473 * t1018;
  t1479 = (t149 * t1465 / 0.16e2 - 0.3e1 / 0.512e3 * t401 * t1469 + 0.3e1 / 0.32768e5 * t1013 * t1475) * t46;
  t1489 = t1043 * t696;
  t1492 = t696 * t438;
  t1499 = -0.25e2 / 0.3e1 * t578 + 0.5e2 / 0.9e1 * t690 * t435 - 0.125e3 / 0.27e2 * t581;
  t1502 = -0.5e1 / 0.4e1 * t575 - 0.3e1 / 0.8e1 * t687 * t1044 - 0.3e1 / 0.8e1 * t425 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1492 - 0.27e2 / 0.4e2 * t431 * t1499;
  t1507 = t699 * t448;
  t1512 = t1079 * t148;
  t1513 = t673 * t459;
  t1516 = t450 * t672;
  t1521 = t1479 * t171 / 0.24e2 - t684 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t699 + 0.292e3 / 0.2025e4 * t195 * t1502 - 0.73e2 / 0.972e5 * t1502 * t207 - 0.73e2 / 0.1944e6 * t1507 * t459 + 0.73e2 / 0.6e3 * t1074 * t704 - 0.73e2 / 0.12e4 * t1512 * t1513 - 0.73e2 / 0.3e3 * t449 * t1516 + t214 * t1464 / 0.18e3;
  t1522 = t27 * t1521;
  t1523 = t1522 * t711;
  t1526 = t710 * t476;
  t1527 = t393 * t1526;
  t1529 = t232 * t107 * t46;
  t1530 = t1529 * t417;
  t1533 = t709 * t229;
  t1534 = t1533 * t482;
  t1538 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t999 * t712 - t1453 - 0.3e1 / 0.8e1 * t393 * t1523 - t1527 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t1534);
  tv2rhotau3 = t7 * t1538 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1540 = params->c * t32;
  t1541 = t34 * t41;
  t1546 = t758 * t766;
  t1547 = t1546 * t769;
  t1551 = (t1540 * t1541 / 0.32e2 - 0.5e1 / 0.1024e4 * t30 * t496 + 0.3e1 / 0.32768e5 * t267 * t1547) * t46;
  t1556 = t520 * t520;
  t1558 = t506 * t1168;
  t1560 = t515 * t515;
  t1563 = t297 * params->b;
  t1564 = t89 * t93;
  t1565 = t1563 * t1564;
  t1567 = 0.3e1 / 0.32e2 * t1558 + 0.81e2 / 0.8e2 * t801 * t1560 - 0.15e2 / 0.256e3 * t1565;
  t1574 = t531 * t531;
  t1579 = 0.324e3 * t35 + 0.1e3 * t1564;
  t1582 = t88 * t93;
  t1585 = t107 * t32;
  t1588 = t113 * sigma[0];
  t1592 = t1551 * t57 / 0.24e2 + t500 * t503 / 0.12e2 + 0.292e3 / 0.2025e4 * t1556 + 0.292e3 / 0.2025e4 * t82 * t1567 - 0.73e2 / 0.972e5 * t1567 * t98 - 0.73e2 / 0.972e5 * t1192 * t531 + 0.73e2 / 0.3888e6 * t830 * t1574 - 0.73e2 / 0.1944e6 * t315 * t1579 + 0.25e2 / 0.472392e6 * t102 * t1582 + t1585 * t34 / 0.36e3 + t111 * t1588 * t117 / 0.384e3;
  t1595 = t1220 * t101;
  t1598 = t865 * t101;
  t1599 = params->e * t86;
  t1600 = t1599 * t1582;
  t1603 = -t1592 * t127 * t101 + t1595 * t549 / 0.6e1 - t1598 * t1600 / 0.96e2;
  t1604 = t1603 * t130;
  t1605 = t259 * t1604;
  t1607 = t552 * t552;
  t1608 = t1607 * t130;
  t1609 = t259 * t1608;
  t1613 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t1605 + 0.3e1 / 0.8e1 * t258 * t1609);
  tv2sigma20 = t7 * t1613;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1614 = params->c * t151;
  t1615 = t153 * t160;
  t1620 = t1007 * t1015;
  t1621 = t1620 * t1018;
  t1625 = (t1614 * t1615 / 0.32e2 - 0.5e1 / 0.1024e4 * t149 * t564 + 0.3e1 / 0.32768e5 * t401 * t1621) * t46;
  t1630 = t588 * t588;
  t1632 = t574 * t1289;
  t1634 = t583 * t583;
  t1637 = t431 * params->b;
  t1638 = t89 * t202;
  t1639 = t1637 * t1638;
  t1641 = 0.3e1 / 0.32e2 * t1632 + 0.81e2 / 0.8e2 * t1050 * t1634 - 0.15e2 / 0.256e3 * t1639;
  t1648 = t599 * t599;
  t1653 = 0.324e3 * t154 + 0.1e3 * t1638;
  t1656 = t88 * t202;
  t1659 = t107 * t151;
  t1662 = t113 * sigma[2];
  t1666 = t1625 * t171 / 0.24e2 + t568 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1630 + 0.292e3 / 0.2025e4 * t195 * t1641 - 0.73e2 / 0.972e5 * t1641 * t207 - 0.73e2 / 0.972e5 * t1313 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1648 - 0.73e2 / 0.1944e6 * t449 * t1653 + 0.25e2 / 0.472392e6 * t102 * t1656 + t1659 * t153 / 0.36e3 + t111 * t1662 * t220 / 0.384e3;
  t1669 = t1341 * t101;
  t1672 = t1114 * t101;
  t1673 = t1599 * t1656;
  t1676 = -t1666 * t229 * t101 + t1669 * t617 / 0.6e1 - t1672 * t1673 / 0.96e2;
  t1677 = t1676 * t232;
  t1678 = t259 * t1677;
  t1680 = t620 * t620;
  t1681 = t1680 * t232;
  t1682 = t259 * t1681;
  t1686 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t1678 + 0.3e1 / 0.8e1 * t393 * t1682);
  tv2sigma25 = t7 * t1686;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1692 = t758 * t1381 * t769;
  t1696 = (-t490 * t629 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t635 - 0.3e1 / 0.32768e5 * t1144 * t1692) * t46;
  t1705 = t506 * t1397;
  t1707 = t651 * t515;
  t1711 = 0.1e1 / t53 / t90;
  t1712 = t1711 * t86;
  t1714 = t1563 * t1712 * t88;
  t1716 = -0.3e1 / 0.8e1 * t642 * t1168 + 0.3e1 / 0.64e2 * t1705 + 0.81e2 / 0.8e2 * t801 * t1707 + 0.15e2 / 0.32e2 * t1714;
  t1725 = t628 * t531;
  t1728 = t525 * t627;
  t1733 = t1696 * t57 / 0.24e2 + t639 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t520 * t654 + 0.292e3 / 0.2025e4 * t82 * t1716 - 0.73e2 / 0.972e5 * t1716 * t98 - 0.73e2 / 0.1944e6 * t1415 * t531 + 0.73e2 / 0.6e3 * t1192 * t659 - 0.73e2 / 0.12e4 * t1420 * t1725 + 0.73e2 / 0.3e3 * t315 * t1728 - t538 * t628 / 0.18e3;
  t1734 = t27 * t1733;
  t1735 = t1734 * t666;
  t1738 = t28 * t664;
  t1739 = t6 * t1738;
  t1741 = t342 * t130 * t107;
  t1742 = t1741 * t518;
  t1745 = t1441 * t553;
  t1749 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t1735 + t1739 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t1745);
  tv2sigmatau0 = t7 * t1749;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1755 = t1007 * t1473 * t1018;
  t1759 = (-t558 * t674 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t680 - 0.3e1 / 0.32768e5 * t1265 * t1755) * t46;
  t1768 = t574 * t1489;
  t1770 = t696 * t583;
  t1774 = 0.1e1 / t167 / t199;
  t1775 = t1774 * t86;
  t1777 = t1637 * t1775 * t88;
  t1779 = -0.3e1 / 0.8e1 * t687 * t1289 + 0.3e1 / 0.64e2 * t1768 + 0.81e2 / 0.8e2 * t1050 * t1770 + 0.15e2 / 0.32e2 * t1777;
  t1788 = t673 * t599;
  t1791 = t593 * t672;
  t1796 = t1759 * t171 / 0.24e2 + t684 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t588 * t699 + 0.292e3 / 0.2025e4 * t195 * t1779 - 0.73e2 / 0.972e5 * t1779 * t207 - 0.73e2 / 0.1944e6 * t1507 * t599 + 0.73e2 / 0.6e3 * t1313 * t704 - 0.73e2 / 0.12e4 * t1512 * t1788 + 0.73e2 / 0.3e3 * t449 * t1791 - t606 * t673 / 0.18e3;
  t1797 = t27 * t1796;
  t1798 = t1797 * t711;
  t1801 = t147 * t709;
  t1802 = t6 * t1801;
  t1804 = t476 * t232 * t107;
  t1805 = t1804 * t586;
  t1808 = t1533 * t621;
  t1812 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t1798 + t1802 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t1808);
  tv2sigmatau5 = t7 * t1812;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1813 = t32 * t270;
  t1814 = t1813 * t41;
  t1817 = t494 * t766;
  t1818 = t1817 * t273;
  t1821 = t269 * t269;
  t1822 = 0.1e1 / t1821;
  t1824 = t758 * t1822 * t769;
  t1828 = (0.3e1 / 0.32e2 * t30 * t1814 - 0.7e1 / 0.1024e4 * t267 * t1818 + 0.3e1 / 0.32768e5 * t764 * t1824) * t46;
  t1831 = t654 * t654;
  t1835 = t651 * t651;
  t1839 = 0.1e1 / t53 / t260;
  t1840 = t1839 * t86;
  t1844 = -0.3e1 / 0.4e1 * t642 * t1397 + 0.81e2 / 0.8e2 * t801 * t1835 - 0.15e2 / 0.4e1 * t1563 * t1840 * t88;
  t1851 = t266 * t494;
  t1852 = t1851 * t766;
  t1855 = t36 * t270;
  t1860 = t1828 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t1831 + 0.292e3 / 0.2025e4 * t82 * t1844 - 0.73e2 / 0.972e5 * t1844 * t98 + 0.73e2 / 0.3e3 * t1415 * t659 + 0.1971e4 / 0.1e3 * t830 * t1852 - 0.73e2 / 0.2e3 * t315 * t1855 + t108 * t1813 / 0.12e3;
  t1861 = t27 * t1860;
  t1862 = t1861 * t666;
  t1864 = t664 * t664;
  t1865 = t1864 * t864;
  t1866 = t101 * t130;
  t1867 = t1865 * t1866;
  t1871 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t1237 * t1867 - 0.3e1 / 0.8e1 * t258 * t1862);
  tv2tau20 = t7 * t1871;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1872 = t151 * t404;
  t1873 = t1872 * t160;
  t1876 = t562 * t1015;
  t1877 = t1876 * t407;
  t1880 = t403 * t403;
  t1881 = 0.1e1 / t1880;
  t1883 = t1007 * t1881 * t1018;
  t1887 = (0.3e1 / 0.32e2 * t149 * t1873 - 0.7e1 / 0.1024e4 * t401 * t1877 + 0.3e1 / 0.32768e5 * t1013 * t1883) * t46;
  t1890 = t699 * t699;
  t1894 = t696 * t696;
  t1898 = 0.1e1 / t167 / t394;
  t1899 = t1898 * t86;
  t1903 = -0.3e1 / 0.4e1 * t687 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1894 - 0.15e2 / 0.4e1 * t1637 * t1899 * t88;
  t1910 = t400 * t562;
  t1911 = t1910 * t1015;
  t1914 = t155 * t404;
  t1919 = t1887 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t1890 + 0.292e3 / 0.2025e4 * t195 * t1903 - 0.73e2 / 0.972e5 * t1903 * t207 + 0.73e2 / 0.3e3 * t1507 * t704 + 0.1971e4 / 0.1e3 * t1079 * t1911 - 0.73e2 / 0.2e3 * t449 * t1914 + t214 * t1872 / 0.12e3;
  t1920 = t27 * t1919;
  t1921 = t1920 * t711;
  t1923 = t709 * t709;
  t1924 = t1923 * t1113;
  t1925 = t101 * t232;
  t1926 = t1924 * t1925;
  t1930 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t1358 * t1926 - 0.3e1 / 0.8e1 * t393 * t1921);
  tv2tau22 = t7 * t1930;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1935 = t6 * t732 * t253 * t133;
  t1939 = t6 * t247 * t745 * t133;
  t1942 = 0.1e1 / t252 / t240;
  t1946 = 0.5e1 / 0.36e2 * t6 * t26 * t1942 * t133;
  t1948 = 0.1e1 / t718 / t20;
  t1949 = t720 * t244;
  t1952 = t719 * t244;
  t1955 = t240 * t240;
  t1956 = 0.1e1 / t1955;
  t1957 = t17 * t1956;
  t1960 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t724 - 0.6e1 * t1957);
  t1964 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1948 * t1949 + 0.4e1 / 0.3e1 * t1952 * t728 + 0.4e1 / 0.3e1 * t24 * t1960);
  t1969 = t750 * t878;
  t1970 = t258 * t1969;
  t1972 = params->kappa * t872;
  t1973 = t1972 * t349;
  t1977 = t877 * t348 * t130;
  t1978 = t259 * t1977;
  t1983 = t6 * t732;
  t1986 = t741 * t751;
  t1990 = t745 * params->kappa;
  t1991 = t1990 * t349;
  t1992 = t258 * t1991;
  t1994 = t750 * t873;
  t1995 = t258 * t1994;
  t1997 = t268 * t34;
  t1998 = t1997 * t41;
  t2002 = t1145 * t270 * t273;
  t2006 = t334 * t766 * t769;
  t2009 = t266 * t266;
  t2010 = params->c * t2009;
  t2011 = t116 * t260;
  t2012 = 0.1e1 / t2011;
  t2015 = 0.1e1 / t768 / t39;
  t2016 = t2012 * t1822 * t2015;
  t2020 = (-0.3e1 / 0.8e1 * t30 * t1998 + 0.3e1 / 0.64e2 * t267 * t2002 - 0.45e2 / 0.32768e5 * t764 * t2006 + 0.3e1 / 0.262144e6 * t2010 * t2016) * t46;
  t2028 = 0.1e1 / t54 / t91;
  t2029 = t52 * t2028;
  t2036 = sigma[0] * t2028;
  t2038 = -0.44e3 / 0.27e2 * tau[0] * t780 + 0.154e3 / 0.27e2 * t2036;
  t2039 = t2038 * t46;
  t2044 = t51 * t800;
  t2045 = t2044 * t802;
  t2048 = t794 * t815;
  t2053 = 0.1e1 / t76 / t798 / t75;
  t2054 = t69 * t2053;
  t2055 = t802 * t304;
  t2061 = params->b * t2038;
  t2066 = t89 * t2038;
  t2069 = 0.5e1 * t2061 * t72 + 0.5e2 / 0.3e1 * t805 * t301 + 0.25e2 / 0.9e1 * t70 * t2066;
  t2072 = t71 * t2036;
  t2074 = 0.3e1 / 0.4e1 * t2039 * t292 - 0.9e1 / 0.8e1 * t791 * t795 + 0.27e2 / 0.16e2 * t291 * t2045 - 0.9e1 / 0.8e1 * t291 * t2048 - 0.81e2 / 0.32e2 * t2054 * t2055 + 0.243e3 / 0.8e2 * t801 * t304 * t815 - 0.27e2 / 0.4e2 * t297 * t2069 - 0.308e3 / 0.243e3 * t2072;
  t2079 = t820 * t314;
  t2082 = t309 * t829;
  t2087 = t97 * t97;
  t2089 = 0.1e1 / t98 / t2087;
  t2090 = t82 * t2089;
  t2091 = t831 * t325;
  t2094 = t325 * t843;
  t2097 = t29 * t268;
  t2101 = 0.1e1 / t53 / t116;
  t2103 = t89 * t29 * t2101;
  t2105 = -0.3888e4 * t2097 * t34 - 0.3344e6 / 0.27e2 * t2103;
  t2108 = t103 * t2101;
  t2116 = t2020 * t57 / 0.24e2 - t774 * t283 / 0.3e1 + 0.11e2 / 0.9e1 * t278 * t781 - 0.154e3 / 0.81e2 * t47 * t2029 + 0.292e3 / 0.675e3 * t309 * t820 + 0.292e3 / 0.2025e4 * t82 * t2074 - 0.73e2 / 0.972e5 * t2074 * t98 - 0.73e2 / 0.648e5 * t2079 * t325 + 0.73e2 / 0.1296e6 * t2082 * t831 - 0.73e2 / 0.648e5 * t825 * t843 - 0.73e2 / 0.2592e6 * t2090 * t2091 + 0.73e2 / 0.1296e6 * t830 * t2094 - 0.73e2 / 0.1944e6 * t315 * t2105 - 0.1045e5 / 0.1594323e7 * t102 * t2108 - t108 * t1997 / 0.3e2 - 0.5e1 / 0.16e2 * t111 * t115 * t2012;
  t2119 = t856 * t342;
  t2120 = t2119 * t344;
  t2123 = t338 * t864;
  t2124 = t2123 * t866;
  t2130 = 0.1e1 / t863 / t125;
  t2132 = t121 * t2130 * t101;
  t2133 = t107 * params->e;
  t2134 = t2133 * t113;
  t2136 = t2134 * t114 * t2012;
  t2143 = -t2116 * t127 * t101 - 0.2e1 / 0.3e1 * t2120 * t307 - 0.2e1 / 0.9e1 * t2124 * t841 + 0.22e2 / 0.9e1 * t860 * t818 - 0.16e2 / 0.81e2 * t2132 * t2136 + 0.22e2 / 0.27e2 * t867 * t2103 - 0.308e3 / 0.81e2 * t345 * t2072;
  t2144 = t2143 * t130;
  t2145 = t259 * t2144;
  t2148 = -0.3e1 / 0.8e1 * t1935 + t1939 / 0.4e1 - t1946 - 0.3e1 / 0.8e1 * t6 * t1964 * t27 * t133 + 0.3e1 / 0.8e1 * t1970 + 0.9e1 / 0.8e1 * t1237 * t1973 + 0.3e1 / 0.8e1 * t258 * t1978 + 0.9e1 / 0.8e1 * t741 * t879 + 0.9e1 / 0.8e1 * t1983 * t350 + 0.3e1 / 0.4e1 * t1986 + 0.9e1 / 0.8e1 * t741 * t874 - t1992 / 0.4e1 + 0.3e1 / 0.8e1 * t1995 + 0.3e1 / 0.8e1 * t258 * t2145;
  t2149 = my_piecewise3(t2, 0, t2148);
  t2151 = 0.1e1 / t884 / t142;
  t2152 = t886 * t357;
  t2155 = t885 * t357;
  t2158 = t139 * t1956;
  t2161 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t724 - 0.6e1 * t2158);
  t2165 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2151 * t2152 + 0.4e1 / 0.3e1 * t2155 * t892 + 0.4e1 / 0.3e1 * t144 * t2161);
  t2172 = t6 * t896 * t253 * t235;
  t2176 = t6 * t360 * t745 * t235;
  t2181 = 0.5e1 / 0.36e2 * t6 * t146 * t1942 * t235;
  t2183 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t2165 * t27 * t235 - 0.3e1 / 0.8e1 * t2172 + t2176 / 0.4e1 - t2181);
  tv3rho30 = 0.3e1 * t883 + 0.3e1 * t910 + t7 * (t2149 + t2183);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2186 = 0.2e1 * t936;
  t2187 = 0.2e1 * t962;
  t2188 = t1948 * t374;
  t2191 = t719 * t917;
  t2196 = 0.2e1 * t724;
  t2197 = 0.6e1 * t1957;
  t2199 = my_piecewise5(t11, 0, t15, 0, t2196 - t2197);
  t2203 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t2188 * t720 + 0.8e1 / 0.9e1 * t2191 * t244 + 0.4e1 / 0.9e1 * t913 * t728 + 0.4e1 / 0.3e1 * t24 * t2199);
  t2211 = t6 * t921 * t253 * t133 / 0.4e1;
  t2212 = t6 * t921;
  t2217 = t6 * t377 * t745 * t133;
  t2220 = t930 * t751 / 0.4e1;
  t2231 = -0.3e1 / 0.8e1 * t6 * t2203 * t27 * t133 - t2211 + 0.3e1 / 0.4e1 * t2212 * t350 + t2217 / 0.12e2 + t2220 + 0.3e1 / 0.8e1 * t930 * t874 + 0.3e1 / 0.8e1 * t930 * t879 - t1935 / 0.8e1 + t1939 / 0.6e1 + t1986 / 0.4e1 - t1946 - t1992 / 0.6e1 + t1995 / 0.8e1 + t1970 / 0.8e1;
  t2232 = my_piecewise3(t2, 0, t2231);
  t2233 = t2151 * t385;
  t2236 = t885 * t941;
  t2241 = 0.6e1 * t2158;
  t2243 = my_piecewise5(t15, 0, t11, 0, -t2196 - t2241);
  t2247 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2233 * t886 + 0.8e1 / 0.9e1 * t2236 * t357 + 0.4e1 / 0.9e1 * t937 * t892 + 0.4e1 / 0.3e1 * t144 * t2243);
  t2255 = t6 * t945 * t253 * t235 / 0.4e1;
  t2258 = t6 * t388 * t745 * t235;
  t2262 = t6 * t896;
  t2266 = t955 * t958 / 0.4e1;
  t2267 = t1990 * t482;
  t2268 = t393 * t2267;
  t2271 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t2247 * t27 * t235 - t2255 + t2258 / 0.12e2 - t2172 / 0.8e1 + t2176 / 0.6e1 - t2181 + 0.3e1 / 0.8e1 * t2262 * t483 + t2266 - t2268 / 0.12e2);
  tv3rho31 = t883 + t910 + t2186 + t2187 + t7 * (t2232 + t2271);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2274 = t1948 * t967;
  t2279 = t719 * t972;
  t2283 = my_piecewise5(t11, 0, t15, 0, -t2196 - t2197);
  t2287 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t2274 * t244 + 0.8e1 / 0.9e1 * t913 * t917 + 0.4e1 / 0.9e1 * t2279 * t244 + 0.4e1 / 0.3e1 * t24 * t2283);
  t2294 = t6 * t976 * t253 * t133;
  t2296 = t6 * t976;
  t2303 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t2287 * t27 * t133 - t2294 / 0.8e1 + 0.3e1 / 0.8e1 * t2296 * t350 - t2211 + t2217 / 0.6e1 + t2220 + t1939 / 0.12e2 - t1946 - t1992 / 0.12e2);
  t2304 = t2151 * t984;
  t2309 = t885 * t989;
  t2313 = my_piecewise5(t15, 0, t11, 0, t2196 - t2241);
  t2317 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2304 * t357 + 0.8e1 / 0.9e1 * t937 * t941 + 0.4e1 / 0.9e1 * t2309 * t357 + 0.4e1 / 0.3e1 * t144 * t2313);
  t2324 = t6 * t993 * t253 * t235;
  t2327 = t6 * t945;
  t2330 = t999 * t958;
  t2336 = t750 * t1121;
  t2337 = t393 * t2336;
  t2341 = t750 * t1126;
  t2342 = t393 * t2341;
  t2344 = -0.3e1 / 0.8e1 * t6 * t2317 * t27 * t235 - t2324 / 0.8e1 - t2255 + t2258 / 0.6e1 + 0.3e1 / 0.4e1 * t2327 * t483 + t2330 / 0.4e1 + t2176 / 0.12e2 - t2181 + t2266 - t2268 / 0.6e1 + 0.3e1 / 0.8e1 * t955 * t1122 + t2337 / 0.8e1 + 0.3e1 / 0.8e1 * t955 * t1127 + t2342 / 0.8e1;
  t2345 = my_piecewise3(t138, 0, t2344);
  tv3rho32 = t2186 + t2187 + t983 + t1131 + t7 * (t2303 + t2345);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t2350 = t967 * t374;
  t2357 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t724 - 0.6e1 * t1957);
  t2361 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1948 * t2350 + 0.4e1 / 0.3e1 * t913 * t972 + 0.4e1 / 0.3e1 * t24 * t2357);
  t2369 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t2361 * t27 * t133 - 0.3e1 / 0.8e1 * t2294 + t2217 / 0.4e1 - t1946);
  t2372 = t984 * t385;
  t2379 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t724 - 0.6e1 * t2158);
  t2383 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2151 * t2372 + 0.4e1 / 0.3e1 * t937 * t989 + 0.4e1 / 0.3e1 * t144 * t2379);
  t2388 = params->kappa * t1120;
  t2389 = t2388 * t482;
  t2393 = t1125 * t481 * t232;
  t2394 = t259 * t2393;
  t2405 = t402 * t153;
  t2406 = t2405 * t160;
  t2410 = t1266 * t404 * t407;
  t2414 = t468 * t1015 * t1018;
  t2417 = t400 * t400;
  t2418 = params->c * t2417;
  t2419 = t219 * t394;
  t2420 = 0.1e1 / t2419;
  t2423 = 0.1e1 / t1017 / t158;
  t2424 = t2420 * t1881 * t2423;
  t2428 = (-0.3e1 / 0.8e1 * t149 * t2406 + 0.3e1 / 0.64e2 * t401 * t2410 - 0.45e2 / 0.32768e5 * t1013 * t2414 + 0.3e1 / 0.262144e6 * t2418 * t2424) * t46;
  t2436 = 0.1e1 / t168 / t200;
  t2437 = t166 * t2436;
  t2444 = sigma[2] * t2436;
  t2446 = -0.44e3 / 0.27e2 * tau[1] * t1029 + 0.154e3 / 0.27e2 * t2444;
  t2447 = t2446 * t46;
  t2452 = t51 * t1049;
  t2453 = t2452 * t1051;
  t2456 = t1043 * t1064;
  t2461 = 0.1e1 / t189 / t1047 / t188;
  t2462 = t183 * t2461;
  t2463 = t1051 * t438;
  t2469 = params->b * t2446;
  t2474 = t89 * t2446;
  t2477 = 0.5e1 * t2469 * t185 + 0.5e2 / 0.3e1 * t1054 * t435 + 0.25e2 / 0.9e1 * t184 * t2474;
  t2480 = t71 * t2444;
  t2482 = 0.3e1 / 0.4e1 * t2447 * t426 - 0.9e1 / 0.8e1 * t1040 * t1044 + 0.27e2 / 0.16e2 * t425 * t2453 - 0.9e1 / 0.8e1 * t425 * t2456 - 0.81e2 / 0.32e2 * t2462 * t2463 + 0.243e3 / 0.8e2 * t1050 * t438 * t1064 - 0.27e2 / 0.4e2 * t431 * t2477 - 0.308e3 / 0.243e3 * t2480;
  t2487 = t1069 * t448;
  t2490 = t443 * t1078;
  t2495 = t206 * t206;
  t2497 = 0.1e1 / t207 / t2495;
  t2498 = t195 * t2497;
  t2499 = t1080 * t459;
  t2502 = t459 * t1092;
  t2505 = t148 * t402;
  t2509 = 0.1e1 / t167 / t219;
  t2511 = t89 * t148 * t2509;
  t2513 = -0.3888e4 * t2505 * t153 - 0.3344e6 / 0.27e2 * t2511;
  t2516 = t210 * t2509;
  t2524 = t2428 * t171 / 0.24e2 - t1023 * t417 / 0.3e1 + 0.11e2 / 0.9e1 * t412 * t1030 - 0.154e3 / 0.81e2 * t165 * t2437 + 0.292e3 / 0.675e3 * t443 * t1069 + 0.292e3 / 0.2025e4 * t195 * t2482 - 0.73e2 / 0.972e5 * t2482 * t207 - 0.73e2 / 0.648e5 * t2487 * t459 + 0.73e2 / 0.1296e6 * t2490 * t1080 - 0.73e2 / 0.648e5 * t1074 * t1092 - 0.73e2 / 0.2592e6 * t2498 * t2499 + 0.73e2 / 0.1296e6 * t1079 * t2502 - 0.73e2 / 0.1944e6 * t449 * t2513 - 0.1045e5 / 0.1594323e7 * t102 * t2516 - t214 * t2405 / 0.3e2 - 0.5e1 / 0.16e2 * t111 * t218 * t2420;
  t2527 = t1105 * t476;
  t2528 = t2527 * t344;
  t2531 = t472 * t1113;
  t2532 = t2531 * t866;
  t2538 = 0.1e1 / t1112 / t227;
  t2540 = t224 * t2538 * t101;
  t2542 = t2134 * t217 * t2420;
  t2549 = -t2524 * t229 * t101 - 0.2e1 / 0.3e1 * t2528 * t441 - 0.2e1 / 0.9e1 * t2532 * t1090 + 0.22e2 / 0.9e1 * t1109 * t1067 - 0.16e2 / 0.81e2 * t2540 * t2542 + 0.22e2 / 0.27e2 * t1115 * t2511 - 0.308e3 / 0.81e2 * t478 * t2480;
  t2550 = t2549 * t232;
  t2551 = t259 * t2550;
  t2554 = t6 * t993;
  t2557 = -0.3e1 / 0.8e1 * t2324 + t2258 / 0.4e1 - t2181 - 0.3e1 / 0.8e1 * t6 * t2383 * t27 * t235 + 0.9e1 / 0.8e1 * t1358 * t2389 + 0.3e1 / 0.8e1 * t393 * t2394 + 0.3e1 / 0.8e1 * t2337 + 0.3e1 / 0.8e1 * t2342 + 0.9e1 / 0.8e1 * t999 * t1127 - t2268 / 0.4e1 + 0.3e1 / 0.4e1 * t2330 + 0.9e1 / 0.8e1 * t999 * t1122 + 0.3e1 / 0.8e1 * t393 * t2551 + 0.9e1 / 0.8e1 * t2554 * t483;
  t2558 = my_piecewise3(t138, 0, t2557);
  tv3rho33 = 0.3e1 * t983 + 0.3e1 * t1131 + t7 * (t2369 + t2558);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2564 = t741 * t1136;
  t2568 = t6 * t248;
  t2571 = t1990 * t553;
  t2573 = t258 * t2571 / 0.12e2;
  t2574 = t750 * t1233;
  t2575 = t258 * t2574;
  t2577 = t6 * t254;
  t2578 = t2577 * t1239;
  t2580 = t1187 * t314;
  t2589 = sigma[0] * t494;
  t2593 = t89 * sigma[0] * t839;
  t2595 = 0.1944e4 * t2589 * t34 + 0.304e5 / 0.9e1 * t2593;
  t2606 = t780 * t46;
  t2607 = t2606 * t292;
  t2609 = t1163 * t795;
  t2611 = t506 * t2045;
  t2613 = t506 * t2048;
  t2617 = t291 * t51;
  t2618 = t800 * t515;
  t2619 = t2618 * t304;
  t2622 = t794 * t1182;
  t2634 = params->b * t780;
  t2635 = t2634 * t72;
  t2637 = t1174 * t301;
  t2639 = t509 * t812;
  t2642 = t70 * t89 * t780;
  t2644 = -0.55e2 / 0.9e1 * t2635 + 0.1e3 / 0.27e2 * t2637 - 0.25e2 / 0.36e2 * t2639 - 0.275e3 / 0.81e2 * t2642;
  t2647 = t2606 * t51;
  t2649 = -0.11e2 / 0.12e2 * t2607 - t2609 / 0.4e1 - 0.9e1 / 0.128e3 * t2611 + 0.3e1 / 0.64e2 * t2613 - 0.3e1 / 0.8e1 * t791 * t1168 + 0.9e1 / 0.8e1 * t2617 * t2619 - 0.3e1 / 0.4e1 * t291 * t2622 - 0.81e2 / 0.32e2 * t2054 * t515 * t802 + 0.81e2 / 0.4e2 * t801 * t1182 * t304 + 0.81e2 / 0.8e2 * t801 * t515 * t815 - 0.27e2 / 0.4e2 * t297 * t2644 + 0.22e2 / 0.81e2 * t2647;
  t2654 = -0.73e2 / 0.972e5 * t2580 * t325 - 0.73e2 / 0.1944e6 * t1192 * t843 - 0.73e2 / 0.1944e6 * t2079 * t531 - 0.73e2 / 0.972e5 * t825 * t1206 - 0.73e2 / 0.1944e6 * t315 * t2595 - 0.2e1 / 0.9e1 * t1151 * t283 + 0.11e2 / 0.27e2 * t500 * t781 + 0.292e3 / 0.2025e4 * t820 * t520 + 0.584e3 / 0.2025e4 * t309 * t1187 + 0.292e3 / 0.2025e4 * t82 * t2649 - 0.73e2 / 0.972e5 * t2649 * t98;
  t2655 = t531 * t831;
  t2658 = t534 * t839;
  t2671 = params->c * t266 * t114;
  t2673 = t852 * t1822 * t2015;
  t2677 = (0.3e1 / 0.16e2 * t490 * t755 - 0.17e2 / 0.512e3 * t493 * t760 + 0.39e2 / 0.32768e5 * t1144 * t770 - 0.3e1 / 0.262144e6 * t2671 * t2673) * t46;
  t2682 = t51 * t780;
  t2687 = t520 * t829;
  t2692 = t1206 * t325;
  t2695 = t531 * t843;
  t2700 = -0.73e2 / 0.2592e6 * t2090 * t2655 + 0.95e3 / 0.531441e6 * t102 * t2658 + 0.3e1 / 0.32e2 * t111 * t541 * t852 + t2677 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t278 * t1158 + 0.11e2 / 0.27e2 * t47 * t2682 + t774 * t503 / 0.24e2 + 0.73e2 / 0.3888e6 * t2687 * t831 + 0.73e2 / 0.1944e6 * t2082 * t1197 + 0.73e2 / 0.1944e6 * t830 * t2692 + 0.73e2 / 0.3888e6 * t830 * t2695 + t538 * t754 / 0.6e2;
  t2701 = t2654 + t2700;
  t2704 = t1217 * t342;
  t2705 = t2704 * t344;
  t2708 = t545 * t864;
  t2709 = t2708 * t866;
  t2714 = t2119 * t101;
  t2722 = t2134 * t852 * t29;
  t2727 = t122 * t2682;
  t2730 = -t2701 * t127 * t101 - 0.4e1 / 0.9e1 * t2705 * t307 - 0.2e1 / 0.27e2 * t2709 * t841 + 0.22e2 / 0.27e2 * t1221 * t818 + t2714 * t549 / 0.12e2 + t2124 * t1204 / 0.18e2 - 0.4e1 / 0.9e1 * t1224 * t1229 + 0.2e1 / 0.27e2 * t2132 * t2722 - t867 * t2593 / 0.4e1 + 0.22e2 / 0.27e2 * t548 * t2727;
  t2731 = t2730 * t130;
  t2732 = t259 * t2731;
  t2735 = params->kappa * t1232;
  t2736 = t2735 * t349;
  t2739 = t1238 * t873;
  t2742 = t1238 * t878;
  t2745 = 0.3e1 / 0.8e1 * t1983 * t554 + t2564 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t1234 + 0.3e1 / 0.4e1 * t2568 * t1239 - t2573 + t2575 / 0.4e1 + t2578 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t2732 + 0.3e1 / 0.4e1 * t1237 * t2736 + 0.3e1 / 0.8e1 * t1237 * t2739 + 0.3e1 / 0.8e1 * t1237 * t2742;
  t2746 = my_piecewise3(t2, 0, t2745);
  tv3rho2sigma0 = t7 * t2746 + 0.2e1 * t1243;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2751 = t955 * t1247;
  t2753 = t1990 * t621;
  t2755 = t393 * t2753 / 0.12e2;
  t2757 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t2262 * t622 + t2751 / 0.4e1 - t2755);
  tv3rho2sigma2 = t7 * t2757 + 0.2e1 * t1251;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2761 = t930 * t1136;
  t2765 = t6 * t378;
  t2772 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t2212 * t554 + t2761 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t1234 + 0.3e1 / 0.8e1 * t2765 * t1239 + t2564 / 0.8e1 - t2573 + t2575 / 0.8e1 + t2578 / 0.8e1);
  tv3rho2sigma3 = t7 * t2772 + t1243 + t1256;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2776 = t999 * t1247;
  t2781 = t750 * t1354;
  t2782 = t393 * t2781;
  t2784 = t6 * t361;
  t2787 = t6 * t365;
  t2788 = t2787 * t1360;
  t2791 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t2327 * t622 + t2776 / 0.8e1 + t2751 / 0.8e1 - t2755 + 0.3e1 / 0.8e1 * t955 * t1355 + t2782 / 0.8e1 + 0.3e1 / 0.8e1 * t2784 * t1360 + t2788 / 0.8e1);
  tv3rho2sigma5 = t7 * t2791 + t1251 + t1364;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2798 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t2296 * t554 + t2761 / 0.4e1 - t2573);
  tv3rho2sigma6 = t7 * t2798 + 0.2e1 * t1256;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2806 = t6 * t389;
  t2815 = t1029 * t46;
  t2816 = t2815 * t426;
  t2818 = t1284 * t1044;
  t2820 = t574 * t2453;
  t2822 = t574 * t2456;
  t2826 = t425 * t51;
  t2827 = t1049 * t583;
  t2828 = t2827 * t438;
  t2831 = t1043 * t1303;
  t2843 = params->b * t1029;
  t2844 = t2843 * t185;
  t2846 = t1295 * t435;
  t2848 = t577 * t1061;
  t2851 = t184 * t89 * t1029;
  t2853 = -0.55e2 / 0.9e1 * t2844 + 0.1e3 / 0.27e2 * t2846 - 0.25e2 / 0.36e2 * t2848 - 0.275e3 / 0.81e2 * t2851;
  t2856 = t2815 * t51;
  t2858 = -0.11e2 / 0.12e2 * t2816 - t2818 / 0.4e1 - 0.9e1 / 0.128e3 * t2820 + 0.3e1 / 0.64e2 * t2822 - 0.3e1 / 0.8e1 * t1040 * t1289 + 0.9e1 / 0.8e1 * t2826 * t2828 - 0.3e1 / 0.4e1 * t425 * t2831 - 0.81e2 / 0.32e2 * t2462 * t583 * t1051 + 0.81e2 / 0.4e2 * t1050 * t1303 * t438 + 0.81e2 / 0.8e2 * t1050 * t583 * t1064 - 0.27e2 / 0.4e2 * t431 * t2853 + 0.22e2 / 0.81e2 * t2856;
  t2873 = params->c * t400 * t217;
  t2875 = t1101 * t1881 * t2423;
  t2879 = (0.3e1 / 0.16e2 * t558 * t1004 - 0.17e2 / 0.512e3 * t561 * t1009 + 0.39e2 / 0.32768e5 * t1265 * t1019 - 0.3e1 / 0.262144e6 * t2873 * t2875) * t46;
  t2884 = t51 * t1029;
  t2887 = t599 * t1080;
  t2890 = t602 * t1088;
  t2895 = 0.292e3 / 0.2025e4 * t1069 * t588 + 0.584e3 / 0.2025e4 * t443 * t1308 + 0.292e3 / 0.2025e4 * t195 * t2858 - 0.73e2 / 0.972e5 * t2858 * t207 + 0.3e1 / 0.32e2 * t111 * t609 * t1101 + t2879 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t412 * t1279 + 0.11e2 / 0.27e2 * t165 * t2884 - 0.73e2 / 0.2592e6 * t2498 * t2887 + 0.95e3 / 0.531441e6 * t102 * t2890 + t1023 * t571 / 0.24e2;
  t2896 = t588 * t1078;
  t2901 = t1327 * t459;
  t2904 = t599 * t1092;
  t2909 = t1308 * t448;
  t2918 = sigma[2] * t562;
  t2922 = t89 * sigma[2] * t1088;
  t2924 = 0.1944e4 * t2918 * t153 + 0.304e5 / 0.9e1 * t2922;
  t2931 = 0.73e2 / 0.3888e6 * t2896 * t1080 + 0.73e2 / 0.1944e6 * t2490 * t1318 + 0.73e2 / 0.1944e6 * t1079 * t2901 + 0.73e2 / 0.3888e6 * t1079 * t2904 + t606 * t1003 / 0.6e2 - 0.73e2 / 0.972e5 * t2909 * t459 - 0.73e2 / 0.1944e6 * t1313 * t1092 - 0.73e2 / 0.1944e6 * t2487 * t599 - 0.73e2 / 0.972e5 * t1074 * t1327 - 0.73e2 / 0.1944e6 * t449 * t2924 - 0.2e1 / 0.9e1 * t1272 * t417 + 0.11e2 / 0.27e2 * t568 * t1030;
  t2932 = t2895 + t2931;
  t2935 = t1338 * t476;
  t2936 = t2935 * t344;
  t2939 = t613 * t1113;
  t2940 = t2939 * t866;
  t2945 = t2527 * t101;
  t2953 = t2134 * t1101 * t148;
  t2958 = t122 * t2884;
  t2961 = -t2932 * t229 * t101 - 0.4e1 / 0.9e1 * t2936 * t441 - 0.2e1 / 0.27e2 * t2940 * t1090 + 0.22e2 / 0.27e2 * t1342 * t1067 + t2945 * t617 / 0.12e2 + t2532 * t1325 / 0.18e2 - 0.4e1 / 0.9e1 * t1345 * t1350 + 0.2e1 / 0.27e2 * t2540 * t2953 - t1115 * t2922 / 0.4e1 + 0.22e2 / 0.27e2 * t616 * t2958;
  t2962 = t2961 * t232;
  t2963 = t259 * t2962;
  t2966 = params->kappa * t1353;
  t2967 = t2966 * t482;
  t2970 = t1359 * t1121;
  t2973 = t1359 * t1126;
  t2976 = 0.3e1 / 0.8e1 * t2554 * t622 + t2776 / 0.4e1 + 0.3e1 / 0.4e1 * t999 * t1355 + 0.3e1 / 0.4e1 * t2806 * t1360 - t2755 + t2782 / 0.4e1 + t2788 / 0.4e1 + 0.3e1 / 0.8e1 * t393 * t2963 + 0.3e1 / 0.4e1 * t1358 * t2967 + 0.3e1 / 0.8e1 * t1358 * t2970 + 0.3e1 / 0.8e1 * t1358 * t2973;
  t2977 = my_piecewise3(t138, 0, t2976);
  tv3rho2sigma8 = t7 * t2977 + 0.2e1 * t1364;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2980 = t665 * t864;
  t2981 = t258 * t2980;
  t2983 = t130 * params->e * t86;
  t2984 = t2983 * t846;
  t2987 = t1441 * t878;
  t2994 = t253 * t1429;
  t2995 = t2994 * t666;
  t2996 = t258 * t2995;
  t2998 = t494 * t627;
  t2999 = t2998 * t41;
  t3003 = t758 * t633 * t273;
  t3007 = t117 * t1381 * t769;
  t3011 = 0.1e1 / t1821 / tau[0];
  t3013 = t852 * t3011 * t2015;
  t3017 = (-0.3e1 / 0.16e2 * t30 * t2999 + 0.17e2 / 0.512e3 * t267 * t3003 - 0.39e2 / 0.32768e5 * t764 * t3007 + 0.3e1 / 0.262144e6 * t2010 * t3013) * t46;
  t3036 = t800 * t651;
  t3037 = t3036 * t304;
  t3040 = t794 * t1407;
  t3057 = 0.2e3 / 0.9e1 * t1175 - 0.5e3 / 0.27e2 * t1177 + 0.5e2 / 0.9e1 * t645 * t812 + 0.1e4 / 0.81e2 * t1180;
  t3060 = 0.1e2 / 0.3e1 * t1164 + 0.5e1 / 0.4e1 * t1166 + 0.9e1 / 0.16e2 * t642 * t2045 - 0.3e1 / 0.8e1 * t642 * t2048 - 0.3e1 / 0.8e1 * t791 * t1397 + 0.9e1 / 0.8e1 * t2617 * t3037 - 0.3e1 / 0.4e1 * t291 * t3040 - 0.81e2 / 0.32e2 * t2054 * t651 * t802 + 0.81e2 / 0.4e2 * t801 * t1407 * t304 + 0.81e2 / 0.8e2 * t801 * t651 * t815 - 0.27e2 / 0.4e2 * t297 * t3057;
  t3065 = t1410 * t314;
  t3068 = t654 * t829;
  t3075 = t2082 * t29;
  t3080 = t2090 * t29;
  t3081 = t628 * t831;
  t3084 = t1372 * t325;
  t3087 = t628 * t843;
  t3090 = t834 * t627;
  t3095 = t3017 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t1387 * t283 + 0.11e2 / 0.27e2 * t639 * t781 + 0.292e3 / 0.2025e4 * t820 * t654 + 0.584e3 / 0.2025e4 * t309 * t1410 + 0.292e3 / 0.2025e4 * t82 * t3060 - 0.73e2 / 0.972e5 * t3060 * t98 - 0.73e2 / 0.972e5 * t3065 * t325 + 0.73e2 / 0.3888e6 * t3068 * t831 - 0.73e2 / 0.1944e6 * t1415 * t843 + 0.73e2 / 0.6e3 * t2079 * t659 - 0.73e2 / 0.6e3 * t3075 * t1421 - 0.73e2 / 0.15e3 * t825 * t1424 + 0.73e2 / 0.8e3 * t3080 * t3081 + 0.73e2 / 0.3e3 * t1420 * t3084 - 0.73e2 / 0.12e4 * t1420 * t3087 + 0.73e2 / 0.1e3 * t315 * t3090 - t108 * t2998 / 0.6e2;
  t3096 = t27 * t3095;
  t3097 = t3096 * t666;
  t3100 = t2577 * t1442;
  t3102 = t1429 * t127;
  t3103 = t3102 * t349;
  t3106 = t1441 * t873;
  t3109 = t741 * t1369;
  t3113 = t745 * t664;
  t3114 = t3113 * t666;
  t3116 = t258 * t3114 / 0.12e2;
  t3117 = t1437 * t781;
  t3120 = t349 * t107;
  t3121 = t3120 * t307;
  t3124 = t741 * t1434;
  t3127 = t1368 * t342;
  t3128 = t258 * t3127;
  t3129 = t3128 * t1438;
  t3131 = t1430 * t342;
  t3132 = t258 * t3131;
  t3135 = -t2981 * t2984 / 0.36e2 - 0.3e1 / 0.8e1 * t1237 * t2987 - 0.3e1 / 0.8e1 * t1983 * t667 - 0.3e1 / 0.4e1 * t741 * t1431 - t2996 / 0.4e1 - 0.3e1 / 0.8e1 * t258 * t3097 - t3100 / 0.4e1 - 0.3e1 / 0.4e1 * t1237 * t3103 - 0.3e1 / 0.8e1 * t1237 * t3106 - t3109 / 0.4e1 - 0.3e1 / 0.4e1 * t2568 * t1442 + t3116 + 0.11e2 / 0.36e2 * t1435 * t3117 - t1435 * t3121 / 0.6e1 - t3124 * t1438 / 0.6e1 - t3129 / 0.18e2 - t3132 * t1438 / 0.6e1;
  t3136 = my_piecewise3(t2, 0, t3135);
  tv3rho2tau0 = t7 * t3136 + 0.2e1 * t1446;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t3141 = t955 * t1451;
  t3143 = t745 * t709;
  t3144 = t3143 * t711;
  t3146 = t393 * t3144 / 0.12e2;
  t3148 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2262 * t712 - t3141 / 0.4e1 + t3146);
  tv3rho2tau1 = t7 * t3148 + 0.2e1 * t1455;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t3152 = t930 * t1369;
  t3156 = t930 * t1434;
  t3166 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2212 * t667 - t3152 / 0.8e1 - 0.3e1 / 0.8e1 * t930 * t1431 - t3156 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t2765 * t1442 - t3109 / 0.8e1 + t3116 - t2996 / 0.8e1 - t3129 / 0.36e2 - t3100 / 0.8e1);
  tv3rho2tau2 = t7 * t3166 + t1446 + t1460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t3170 = t999 * t1451;
  t3175 = t253 * t1521;
  t3176 = t3175 * t711;
  t3177 = t393 * t3176;
  t3179 = t955 * t1526;
  t3182 = t1450 * t476;
  t3183 = t393 * t3182;
  t3184 = t3183 * t1530;
  t3188 = t2787 * t1534;
  t3191 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2327 * t712 - t3170 / 0.8e1 - t3141 / 0.8e1 + t3146 - 0.3e1 / 0.8e1 * t955 * t1523 - t3177 / 0.8e1 - t3179 * t1530 / 0.12e2 - t3184 / 0.36e2 - 0.3e1 / 0.8e1 * t2784 * t1534 - t3188 / 0.8e1);
  tv3rho2tau3 = t7 * t3191 + t1455 + t1538;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t3198 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2296 * t667 - t3152 / 0.4e1 + t3116);
  tv3rho2tau4 = t7 * t3198 + 0.2e1 * t1460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t3203 = t1521 * t229;
  t3204 = t3203 * t482;
  t3207 = t1533 * t1121;
  t3212 = t710 * t1113;
  t3213 = t393 * t3212;
  t3215 = t232 * params->e * t86;
  t3216 = t3215 * t1095;
  t3219 = t999 * t1526;
  t3222 = t1522 * t476;
  t3223 = t393 * t3222;
  t3226 = t1533 * t1126;
  t3234 = t562 * t672;
  t3235 = t3234 * t160;
  t3239 = t1007 * t678 * t407;
  t3243 = t220 * t1473 * t1018;
  t3247 = 0.1e1 / t1880 / tau[1];
  t3249 = t1101 * t3247 * t2423;
  t3253 = (-0.3e1 / 0.16e2 * t149 * t3235 + 0.17e2 / 0.512e3 * t401 * t3239 - 0.39e2 / 0.32768e5 * t1013 * t3243 + 0.3e1 / 0.262144e6 * t2418 * t3249) * t46;
  t3272 = t1049 * t696;
  t3273 = t3272 * t438;
  t3276 = t1043 * t1499;
  t3293 = 0.2e3 / 0.9e1 * t1296 - 0.5e3 / 0.27e2 * t1298 + 0.5e2 / 0.9e1 * t690 * t1061 + 0.1e4 / 0.81e2 * t1301;
  t3296 = 0.1e2 / 0.3e1 * t1285 + 0.5e1 / 0.4e1 * t1287 + 0.9e1 / 0.16e2 * t687 * t2453 - 0.3e1 / 0.8e1 * t687 * t2456 - 0.3e1 / 0.8e1 * t1040 * t1489 + 0.9e1 / 0.8e1 * t2826 * t3273 - 0.3e1 / 0.4e1 * t425 * t3276 - 0.81e2 / 0.32e2 * t2462 * t696 * t1051 + 0.81e2 / 0.4e2 * t1050 * t1499 * t438 + 0.81e2 / 0.8e2 * t1050 * t696 * t1064 - 0.27e2 / 0.4e2 * t431 * t3293;
  t3301 = t1502 * t448;
  t3304 = t699 * t1078;
  t3311 = t2490 * t148;
  t3316 = t2498 * t148;
  t3317 = t673 * t1080;
  t3320 = t1464 * t459;
  t3323 = t673 * t1092;
  t3326 = t1083 * t672;
  t3331 = t3253 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t1479 * t417 + 0.11e2 / 0.27e2 * t684 * t1030 + 0.292e3 / 0.2025e4 * t1069 * t699 + 0.584e3 / 0.2025e4 * t443 * t1502 + 0.292e3 / 0.2025e4 * t195 * t3296 - 0.73e2 / 0.972e5 * t3296 * t207 - 0.73e2 / 0.972e5 * t3301 * t459 + 0.73e2 / 0.3888e6 * t3304 * t1080 - 0.73e2 / 0.1944e6 * t1507 * t1092 + 0.73e2 / 0.6e3 * t2487 * t704 - 0.73e2 / 0.6e3 * t3311 * t1513 - 0.73e2 / 0.15e3 * t1074 * t1516 + 0.73e2 / 0.8e3 * t3316 * t3317 + 0.73e2 / 0.3e3 * t1512 * t3320 - 0.73e2 / 0.12e4 * t1512 * t3323 + 0.73e2 / 0.1e3 * t449 * t3326 - t214 * t3234 / 0.6e2;
  t3332 = t27 * t3331;
  t3333 = t3332 * t711;
  t3336 = t1529 * t1030;
  t3339 = t482 * t107;
  t3340 = t3339 * t441;
  t3344 = -0.3e1 / 0.4e1 * t2806 * t1534 - 0.3e1 / 0.4e1 * t1358 * t3204 - 0.3e1 / 0.8e1 * t1358 * t3207 - t3170 / 0.4e1 - t3177 / 0.4e1 - t3213 * t3216 / 0.36e2 - t3219 * t1530 / 0.6e1 - t3223 * t1530 / 0.6e1 - 0.3e1 / 0.8e1 * t1358 * t3226 - t3188 / 0.4e1 - 0.3e1 / 0.8e1 * t2554 * t712 - 0.3e1 / 0.4e1 * t999 * t1523 - 0.3e1 / 0.8e1 * t393 * t3333 + t3146 + 0.11e2 / 0.36e2 * t1527 * t3336 - t1527 * t3340 / 0.6e1 - t3184 / 0.18e2;
  t3345 = my_piecewise3(t138, 0, t3344);
  tv3rho2tau5 = t7 * t3345 + 0.2e1 * t1538;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3349 = t750 * t1604;
  t3351 = t258 * t3349 / 0.8e1;
  t3352 = params->c * t261;
  t3355 = params->c * t268;
  t3356 = t270 * t273;
  t3357 = t3356 * t29;
  t3363 = t334 * t1822 * t2015;
  t3367 = (-t3352 * t1541 / 0.16e2 + 0.11e2 / 0.512e3 * t3355 * t3357 - 0.33e2 / 0.32768e5 * t267 * t1147 + 0.3e1 / 0.262144e6 * t764 * t3363) * t46;
  t3380 = t1163 * t1168;
  t3382 = t518 * t2619;
  t3384 = t506 * t2622;
  t3386 = t2044 * t1560;
  t3395 = t290 * t113;
  t3396 = t296 * params->b;
  t3397 = t3396 * t93;
  t3398 = t3395 * t3397;
  t3400 = t801 * params->b;
  t3401 = t93 * t86;
  t3402 = t88 * t304;
  t3403 = t3401 * t3402;
  t3404 = t3400 * t3403;
  t3406 = t89 * t321;
  t3407 = t1563 * t3406;
  t3409 = -t3380 / 0.4e1 - 0.9e1 / 0.64e2 * t3382 + 0.3e1 / 0.32e2 * t3384 + 0.9e1 / 0.16e2 * t291 * t3386 - 0.81e2 / 0.32e2 * t2054 * t1560 * t304 + 0.81e2 / 0.4e2 * t801 * t515 * t1182 - 0.25e2 / 0.128e3 * t3398 + 0.45e2 / 0.512e3 * t3404 + 0.5e1 / 0.16e2 * t3407;
  t3414 = t1567 * t314;
  t3426 = t1574 * t325;
  t3429 = t531 * t1206;
  t3434 = t1579 * t325;
  t3439 = -0.648e3 * t262 - 0.16e4 / 0.3e1 * t3406;
  t3442 = t88 * t321;
  t3445 = t107 * t261;
  t3451 = 0.73e2 / 0.1944e6 * t2687 * t1197 - 0.73e2 / 0.972e5 * t1192 * t1206 + 0.73e2 / 0.3888e6 * t2082 * t1574 - 0.73e2 / 0.2592e6 * t2090 * t3426 + 0.73e2 / 0.1944e6 * t830 * t3429 - 0.73e2 / 0.1944e6 * t825 * t1579 + 0.73e2 / 0.3888e6 * t830 * t3434 - 0.73e2 / 0.1944e6 * t315 * t3439 - 0.5e2 / 0.177147e6 * t102 * t3442 - t3445 * t34 / 0.18e3 - t111 * t1588 * t334 / 0.48e2;
  t3452 = t3367 * t57 / 0.24e2 - t1551 * t283 / 0.9e1 + t1151 * t503 / 0.12e2 - 0.2e1 / 0.9e1 * t500 * t1158 + 0.584e3 / 0.2025e4 * t520 * t1187 + 0.292e3 / 0.2025e4 * t309 * t1567 + 0.292e3 / 0.2025e4 * t82 * t3409 - 0.73e2 / 0.972e5 * t3409 * t98 - 0.73e2 / 0.1944e6 * t3414 * t325 - 0.73e2 / 0.972e5 * t2580 * t531 + t3451;
  t3455 = t1592 * t342;
  t3456 = t3455 * t344;
  t3459 = t2704 * t101;
  t3466 = t2123 * t101;
  t3470 = t2134 * t334 * sigma[0];
  t3473 = t1599 * t3442;
  t3476 = -t3452 * t127 * t101 - 0.2e1 / 0.9e1 * t3456 * t307 + t3459 * t549 / 0.6e1 + t2709 * t1204 / 0.18e2 - 0.4e1 / 0.9e1 * t1595 * t1229 - t3466 * t1600 / 0.96e2 - t2132 * t3470 / 0.36e2 + t1598 * t3473 / 0.18e2;
  t3477 = t3476 * t130;
  t3478 = t259 * t3477;
  t3481 = params->kappa * t1603;
  t3482 = t3481 * t349;
  t3487 = t750 * t1608;
  t3489 = t258 * t3487 / 0.8e1;
  t3490 = t1238 * t1233;
  t3493 = params->kappa * t1607;
  t3494 = t3493 * t349;
  t3498 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t741 * t1605 + t3351 + 0.3e1 / 0.8e1 * t258 * t3478 + 0.3e1 / 0.8e1 * t1237 * t3482 + 0.3e1 / 0.8e1 * t741 * t1609 + t3489 + 0.3e1 / 0.4e1 * t1237 * t3490 + 0.3e1 / 0.8e1 * t1237 * t3494);
  tv3rhosigma20 = t7 * t3498 + t1613;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3502 = t750 * t1677;
  t3504 = t393 * t3502 / 0.8e1;
  t3507 = t750 * t1681;
  t3509 = t393 * t3507 / 0.8e1;
  t3511 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t1678 + t3504 + 0.3e1 / 0.8e1 * t955 * t1682 + t3509);
  tv3rhosigma25 = t7 * t3511 + t1686;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3518 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t1605 + t3351 + 0.3e1 / 0.8e1 * t930 * t1609 + t3489);
  tv3rhosigma26 = t7 * t3518 + t1613;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3522 = params->c * t395;
  t3525 = params->c * t402;
  t3526 = t404 * t407;
  t3527 = t3526 * t148;
  t3533 = t468 * t1881 * t2423;
  t3537 = (-t3522 * t1615 / 0.16e2 + 0.11e2 / 0.512e3 * t3525 * t3527 - 0.33e2 / 0.32768e5 * t401 * t1268 + 0.3e1 / 0.262144e6 * t1013 * t3533) * t46;
  t3550 = t1284 * t1289;
  t3552 = t586 * t2828;
  t3554 = t574 * t2831;
  t3556 = t2452 * t1634;
  t3565 = t424 * t113;
  t3566 = t430 * params->b;
  t3567 = t3566 * t202;
  t3568 = t3565 * t3567;
  t3570 = t1050 * params->b;
  t3571 = t202 * t86;
  t3572 = t88 * t438;
  t3573 = t3571 * t3572;
  t3574 = t3570 * t3573;
  t3576 = t89 * t455;
  t3577 = t1637 * t3576;
  t3579 = -t3550 / 0.4e1 - 0.9e1 / 0.64e2 * t3552 + 0.3e1 / 0.32e2 * t3554 + 0.9e1 / 0.16e2 * t425 * t3556 - 0.81e2 / 0.32e2 * t2462 * t1634 * t438 + 0.81e2 / 0.4e2 * t1050 * t583 * t1303 - 0.25e2 / 0.128e3 * t3568 + 0.45e2 / 0.512e3 * t3574 + 0.5e1 / 0.16e2 * t3577;
  t3584 = t1641 * t448;
  t3596 = t1648 * t459;
  t3599 = t599 * t1327;
  t3604 = t1653 * t459;
  t3609 = -0.648e3 * t396 - 0.16e4 / 0.3e1 * t3576;
  t3612 = t88 * t455;
  t3615 = t107 * t395;
  t3621 = 0.73e2 / 0.1944e6 * t2896 * t1318 - 0.73e2 / 0.972e5 * t1313 * t1327 + 0.73e2 / 0.3888e6 * t2490 * t1648 - 0.73e2 / 0.2592e6 * t2498 * t3596 + 0.73e2 / 0.1944e6 * t1079 * t3599 - 0.73e2 / 0.1944e6 * t1074 * t1653 + 0.73e2 / 0.3888e6 * t1079 * t3604 - 0.73e2 / 0.1944e6 * t449 * t3609 - 0.5e2 / 0.177147e6 * t102 * t3612 - t3615 * t153 / 0.18e3 - t111 * t1662 * t468 / 0.48e2;
  t3622 = t3537 * t171 / 0.24e2 - t1625 * t417 / 0.9e1 + t1272 * t571 / 0.12e2 - 0.2e1 / 0.9e1 * t568 * t1279 + 0.584e3 / 0.2025e4 * t588 * t1308 + 0.292e3 / 0.2025e4 * t443 * t1641 + 0.292e3 / 0.2025e4 * t195 * t3579 - 0.73e2 / 0.972e5 * t3579 * t207 - 0.73e2 / 0.1944e6 * t3584 * t459 - 0.73e2 / 0.972e5 * t2909 * t599 + t3621;
  t3625 = t1666 * t476;
  t3626 = t3625 * t344;
  t3629 = t2935 * t101;
  t3636 = t2531 * t101;
  t3640 = t2134 * t468 * sigma[2];
  t3643 = t1599 * t3612;
  t3646 = -t3622 * t229 * t101 - 0.2e1 / 0.9e1 * t3626 * t441 + t3629 * t617 / 0.6e1 + t2940 * t1325 / 0.18e2 - 0.4e1 / 0.9e1 * t1669 * t1350 - t3636 * t1673 / 0.96e2 - t2540 * t3640 / 0.36e2 + t1672 * t3643 / 0.18e2;
  t3647 = t3646 * t232;
  t3648 = t259 * t3647;
  t3651 = params->kappa * t1676;
  t3652 = t3651 * t482;
  t3657 = t1359 * t1354;
  t3660 = params->kappa * t1680;
  t3661 = t3660 * t482;
  t3665 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t999 * t1678 + t3504 + 0.3e1 / 0.8e1 * t393 * t3648 + 0.3e1 / 0.8e1 * t1358 * t3652 + 0.3e1 / 0.8e1 * t999 * t1682 + t3509 + 0.3e1 / 0.4e1 * t1358 * t3657 + 0.3e1 / 0.8e1 * t1358 * t3661);
  tv3rhosigma211 = t7 * t3665 + t1686;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3669 = t253 * t1733;
  t3670 = t3669 * t666;
  t3672 = t258 * t3670 / 0.8e1;
  t3680 = t334 * t3011 * t2015;
  t3684 = (t490 * t1373 / 0.8e1 - 0.7e1 / 0.256e3 * t493 * t1377 + 0.9e1 / 0.8192e4 * t1144 * t1383 - 0.3e1 / 0.262144e6 * t2671 * t3680) * t46;
  t3700 = t642 * t51;
  t3705 = t1163 * t1397;
  t3707 = t518 * t3037;
  t3709 = t506 * t3040;
  t3711 = t3036 * t515;
  t3717 = t1407 * t515;
  t3720 = t651 * t1182;
  t3723 = t3396 * t1711;
  t3724 = t3395 * t3723;
  t3726 = t1712 * t3402;
  t3727 = t3400 * t3726;
  t3730 = 0.5e1 / 0.8e1 * t1558 + 0.9e1 / 0.16e2 * t3700 * t2619 - 0.3e1 / 0.8e1 * t642 * t2622 - t3705 / 0.8e1 - 0.9e1 / 0.128e3 * t3707 + 0.3e1 / 0.64e2 * t3709 + 0.9e1 / 0.16e2 * t2617 * t3711 - 0.81e2 / 0.32e2 * t2054 * t1707 * t304 + 0.81e2 / 0.8e2 * t801 * t3717 + 0.81e2 / 0.8e2 * t801 * t3720 + 0.25e2 / 0.16e2 * t3724 - 0.45e2 / 0.64e2 * t3727 - 0.65e2 / 0.32e2 * t1565;
  t3735 = t1716 * t314;
  t3742 = t3684 * t57 / 0.24e2 - t1696 * t283 / 0.9e1 + t1387 * t503 / 0.24e2 - t639 * t1158 / 0.9e1 + 0.292e3 / 0.2025e4 * t1187 * t654 + 0.292e3 / 0.2025e4 * t520 * t1410 + 0.292e3 / 0.2025e4 * t309 * t1716 + 0.292e3 / 0.2025e4 * t82 * t3730 - 0.73e2 / 0.972e5 * t3730 * t98 - 0.73e2 / 0.1944e6 * t3735 * t325 - 0.73e2 / 0.1944e6 * t3065 * t531 + 0.73e2 / 0.3888e6 * t3068 * t1197;
  t3747 = t2687 * t29;
  t3754 = t628 * t1197;
  t3757 = t1372 * t531;
  t3760 = t628 * t1206;
  t3765 = t830 * sigma[0];
  t3768 = t1200 * t627;
  t3773 = -0.73e2 / 0.1944e6 * t1415 * t1206 + 0.73e2 / 0.6e3 * t2580 * t659 - 0.73e2 / 0.12e4 * t3747 * t1421 - 0.73e2 / 0.3e3 * t1192 * t1424 - 0.73e2 / 0.12e4 * t3075 * t1725 + 0.73e2 / 0.8e3 * t3080 * t3754 + 0.73e2 / 0.6e3 * t1420 * t3757 - 0.73e2 / 0.12e4 * t1420 * t3760 + 0.73e2 / 0.3e3 * t825 * t1728 - 0.73e2 / 0.6e3 * t3765 * t1421 - 0.73e2 / 0.15e3 * t315 * t3768 + t538 * t1372 / 0.9e2;
  t3774 = t3742 + t3773;
  t3775 = t27 * t3774;
  t3776 = t3775 * t666;
  t3779 = t1734 * t342;
  t3780 = t258 * t3779;
  t3783 = t1733 * t127;
  t3784 = t3783 * t349;
  t3788 = t6 * t248 * t664;
  t3792 = t6 * t254 * t664;
  t3794 = t3792 * t1742 / 0.96e2;
  t3796 = t6 * t28 * t1429;
  t3799 = t2983 * t1209;
  t3802 = t3120 * t518;
  t3805 = t1741 * t1185;
  t3811 = t2577 * t1745 / 0.8e1;
  t3812 = t3102 * t553;
  t3815 = t553 * t107;
  t3816 = t3815 * t307;
  t3819 = t1441 * t1233;
  t3823 = t552 * t348 * t130;
  t3824 = t1441 * t3823;
  t3827 = -0.3e1 / 0.8e1 * t741 * t1735 - t3672 - 0.3e1 / 0.8e1 * t258 * t3776 - t3780 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t3784 + t3788 * t1742 / 0.32e2 + t3794 + t3796 * t1742 / 0.32e2 + t2981 * t3799 / 0.96e2 + t1435 * t3802 / 0.32e2 - t1739 * t3805 / 0.12e2 - 0.3e1 / 0.8e1 * t2568 * t1745 - t3811 - 0.3e1 / 0.8e1 * t1237 * t3812 - t1435 * t3816 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t3819 - 0.3e1 / 0.8e1 * t1237 * t3824;
  t3828 = my_piecewise3(t2, 0, t3827);
  tv3rhosigmatau0 = t7 * t3828 + t1749;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3832 = t253 * t1796;
  t3833 = t3832 * t711;
  t3835 = t393 * t3833 / 0.8e1;
  t3837 = t6 * t361 * t709;
  t3841 = t6 * t365 * t709;
  t3843 = t3841 * t1805 / 0.96e2;
  t3847 = t2787 * t1808 / 0.8e1;
  t3849 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t1798 - t3835 + t3837 * t1805 / 0.32e2 + t3843 - 0.3e1 / 0.8e1 * t2784 * t1808 - t3847);
  tv3rhosigmatau5 = t7 * t3849 + t1812;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3854 = t6 * t378 * t664;
  t3860 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t1735 - t3672 + t3854 * t1742 / 0.32e2 + t3794 - 0.3e1 / 0.8e1 * t2765 * t1745 - t3811);
  tv3rhosigmatau6 = t7 * t3860 + t1749;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3871 = t468 * t3247 * t2423;
  t3875 = (t558 * t1465 / 0.8e1 - 0.7e1 / 0.256e3 * t561 * t1469 + 0.9e1 / 0.8192e4 * t1265 * t1475 - 0.3e1 / 0.262144e6 * t2873 * t3871) * t46;
  t3891 = t687 * t51;
  t3896 = t1284 * t1489;
  t3898 = t586 * t3273;
  t3900 = t574 * t3276;
  t3902 = t3272 * t583;
  t3908 = t1499 * t583;
  t3911 = t696 * t1303;
  t3914 = t3566 * t1774;
  t3915 = t3565 * t3914;
  t3917 = t1775 * t3572;
  t3918 = t3570 * t3917;
  t3921 = 0.5e1 / 0.8e1 * t1632 + 0.9e1 / 0.16e2 * t3891 * t2828 - 0.3e1 / 0.8e1 * t687 * t2831 - t3896 / 0.8e1 - 0.9e1 / 0.128e3 * t3898 + 0.3e1 / 0.64e2 * t3900 + 0.9e1 / 0.16e2 * t2826 * t3902 - 0.81e2 / 0.32e2 * t2462 * t1770 * t438 + 0.81e2 / 0.8e2 * t1050 * t3908 + 0.81e2 / 0.8e2 * t1050 * t3911 + 0.25e2 / 0.16e2 * t3915 - 0.45e2 / 0.64e2 * t3918 - 0.65e2 / 0.32e2 * t1639;
  t3926 = t1779 * t448;
  t3933 = t3875 * t171 / 0.24e2 - t1759 * t417 / 0.9e1 + t1479 * t571 / 0.24e2 - t684 * t1279 / 0.9e1 + 0.292e3 / 0.2025e4 * t1308 * t699 + 0.292e3 / 0.2025e4 * t588 * t1502 + 0.292e3 / 0.2025e4 * t443 * t1779 + 0.292e3 / 0.2025e4 * t195 * t3921 - 0.73e2 / 0.972e5 * t3921 * t207 - 0.73e2 / 0.1944e6 * t3926 * t459 - 0.73e2 / 0.1944e6 * t3301 * t599 + 0.73e2 / 0.3888e6 * t3304 * t1318;
  t3938 = t2896 * t148;
  t3945 = t673 * t1318;
  t3948 = t1464 * t599;
  t3951 = t673 * t1327;
  t3956 = t1079 * sigma[2];
  t3959 = t1321 * t672;
  t3964 = -0.73e2 / 0.1944e6 * t1507 * t1327 + 0.73e2 / 0.6e3 * t2909 * t704 - 0.73e2 / 0.12e4 * t3938 * t1513 - 0.73e2 / 0.3e3 * t1313 * t1516 - 0.73e2 / 0.12e4 * t3311 * t1788 + 0.73e2 / 0.8e3 * t3316 * t3945 + 0.73e2 / 0.6e3 * t1512 * t3948 - 0.73e2 / 0.12e4 * t1512 * t3951 + 0.73e2 / 0.3e3 * t1074 * t1791 - 0.73e2 / 0.6e3 * t3956 * t1513 - 0.73e2 / 0.15e3 * t449 * t3959 + t606 * t1464 / 0.9e2;
  t3965 = t3933 + t3964;
  t3966 = t27 * t3965;
  t3967 = t3966 * t711;
  t3970 = t1797 * t476;
  t3971 = t393 * t3970;
  t3974 = t1796 * t229;
  t3975 = t3974 * t482;
  t3979 = t6 * t389 * t709;
  t3983 = t6 * t147 * t1521;
  t3986 = t3215 * t1330;
  t3989 = t3339 * t586;
  t3992 = t1804 * t1306;
  t3997 = t3203 * t621;
  t4000 = t621 * t107;
  t4001 = t4000 * t441;
  t4004 = t1533 * t1354;
  t4008 = t620 * t481 * t232;
  t4009 = t1533 * t4008;
  t4012 = -0.3e1 / 0.8e1 * t999 * t1798 - t3835 - 0.3e1 / 0.8e1 * t393 * t3967 - t3971 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t3975 + t3979 * t1805 / 0.32e2 + t3843 + t3983 * t1805 / 0.32e2 + t3213 * t3986 / 0.96e2 + t1527 * t3989 / 0.32e2 - t1802 * t3992 / 0.12e2 - 0.3e1 / 0.8e1 * t2806 * t1808 - t3847 - 0.3e1 / 0.8e1 * t1358 * t3997 - t1527 * t4001 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t4004 - 0.3e1 / 0.8e1 * t1358 * t4009;
  t4013 = my_piecewise3(t138, 0, t4012);
  tv3rhosigmatau11 = t7 * t4013 + t1812;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t4017 = t253 * t1860;
  t4018 = t4017 * t666;
  t4020 = t258 * t4018 / 0.8e1;
  t4021 = t261 * t270;
  t4022 = t4021 * t41;
  t4025 = t268 * t766;
  t4026 = t4025 * t273;
  t4030 = t1145 * t1822 * t769;
  t4034 = 0.1e1 / t1821 / t33;
  t4036 = t334 * t4034 * t2015;
  t4040 = (-0.3e1 / 0.16e2 * t30 * t4022 + 0.17e2 / 0.512e3 * t267 * t4026 - 0.39e2 / 0.32768e5 * t764 * t4030 + 0.3e1 / 0.262144e6 * t2010 * t4036) * t46;
  t4054 = t2044 * t1835;
  t4063 = t3396 * t1839;
  t4066 = t1840 * t3402;
  t4070 = 0.5e1 / 0.4e1 * t1705 + 0.9e1 / 0.8e1 * t3700 * t3037 - 0.3e1 / 0.4e1 * t642 * t3040 + 0.9e1 / 0.16e2 * t291 * t4054 - 0.81e2 / 0.32e2 * t2054 * t1835 * t304 + 0.81e2 / 0.4e2 * t801 * t651 * t1407 - 0.25e2 / 0.2e1 * t3395 * t4063 + 0.45e2 / 0.8e1 * t3400 * t4066 + 0.25e2 / 0.2e1 * t1714;
  t4075 = t1844 * t314;
  t4080 = t3068 * t29;
  t4087 = t2090 * t266;
  t4088 = t1817 * t325;
  t4091 = t266 * t268;
  t4092 = t4091 * t766;
  t4097 = t1813 * t325;
  t4100 = t316 * t270;
  t4105 = t4040 * t57 / 0.24e2 - t1828 * t283 / 0.9e1 + 0.584e3 / 0.2025e4 * t654 * t1410 + 0.292e3 / 0.2025e4 * t309 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4070 - 0.73e2 / 0.972e5 * t4070 * t98 - 0.73e2 / 0.1944e6 * t4075 * t325 + 0.73e2 / 0.3e3 * t3065 * t659 - 0.73e2 / 0.6e3 * t4080 * t1421 - 0.73e2 / 0.15e3 * t1415 * t1424 + 0.1971e4 / 0.1e3 * t2082 * t1852 - 0.5913e4 / 0.2e3 * t4087 * t4088 - 0.1971e4 / 0.25e2 * t830 * t4092 - 0.73e2 / 0.2e3 * t825 * t1855 + 0.73e2 / 0.4e3 * t1420 * t4097 + 0.73e2 / 0.1e3 * t315 * t4100 - t108 * t4021 / 0.6e2;
  t4106 = t27 * t4105;
  t4107 = t4106 * t666;
  t4110 = t1861 * t342;
  t4111 = t258 * t4110;
  t4114 = t1860 * t127;
  t4115 = t4114 * t349;
  t4121 = t2577 * t1867 / 0.8e1;
  t4122 = t664 * t864;
  t4123 = t1866 * t1429;
  t4124 = t4122 * t4123;
  t4127 = t27 * t1864;
  t4128 = t4127 * t2130;
  t4129 = t258 * t4128;
  t4130 = t1866 * t107;
  t4131 = t4130 * t307;
  t4135 = t101 * t348 * t130;
  t4136 = t1865 * t4135;
  t4140 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t741 * t1862 - t4020 - 0.3e1 / 0.8e1 * t258 * t4107 - t4111 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t4115 + 0.3e1 / 0.8e1 * t2568 * t1867 + t4121 + 0.3e1 / 0.4e1 * t1237 * t4124 + t4129 * t4131 / 0.6e1 + 0.3e1 / 0.8e1 * t1237 * t4136);
  tv3rhotau20 = t7 * t4140 + t1871;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t4144 = t253 * t1919;
  t4145 = t4144 * t711;
  t4147 = t393 * t4145 / 0.8e1;
  t4151 = t2787 * t1926 / 0.8e1;
  t4153 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t1921 - t4147 + 0.3e1 / 0.8e1 * t2784 * t1926 + t4151);
  tv3rhotau22 = t7 * t4153 + t1930;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t4160 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t1862 - t4020 + 0.3e1 / 0.8e1 * t2765 * t1867 + t4121);
  tv3rhotau23 = t7 * t4160 + t1871;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t4164 = t395 * t404;
  t4165 = t4164 * t160;
  t4168 = t402 * t1015;
  t4169 = t4168 * t407;
  t4173 = t1266 * t1881 * t1018;
  t4177 = 0.1e1 / t1880 / t152;
  t4179 = t468 * t4177 * t2423;
  t4183 = (-0.3e1 / 0.16e2 * t149 * t4165 + 0.17e2 / 0.512e3 * t401 * t4169 - 0.39e2 / 0.32768e5 * t1013 * t4173 + 0.3e1 / 0.262144e6 * t2418 * t4179) * t46;
  t4197 = t2452 * t1894;
  t4206 = t3566 * t1898;
  t4209 = t1899 * t3572;
  t4213 = 0.5e1 / 0.4e1 * t1768 + 0.9e1 / 0.8e1 * t3891 * t3273 - 0.3e1 / 0.4e1 * t687 * t3276 + 0.9e1 / 0.16e2 * t425 * t4197 - 0.81e2 / 0.32e2 * t2462 * t1894 * t438 + 0.81e2 / 0.4e2 * t1050 * t696 * t1499 - 0.25e2 / 0.2e1 * t3565 * t4206 + 0.45e2 / 0.8e1 * t3570 * t4209 + 0.25e2 / 0.2e1 * t1777;
  t4218 = t1903 * t448;
  t4223 = t3304 * t148;
  t4230 = t2498 * t400;
  t4231 = t1876 * t459;
  t4234 = t400 * t402;
  t4235 = t4234 * t1015;
  t4240 = t1872 * t459;
  t4243 = t450 * t404;
  t4248 = t4183 * t171 / 0.24e2 - t1887 * t417 / 0.9e1 + 0.584e3 / 0.2025e4 * t699 * t1502 + 0.292e3 / 0.2025e4 * t443 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4213 - 0.73e2 / 0.972e5 * t4213 * t207 - 0.73e2 / 0.1944e6 * t4218 * t459 + 0.73e2 / 0.3e3 * t3301 * t704 - 0.73e2 / 0.6e3 * t4223 * t1513 - 0.73e2 / 0.15e3 * t1507 * t1516 + 0.1971e4 / 0.1e3 * t2490 * t1911 - 0.5913e4 / 0.2e3 * t4230 * t4231 - 0.1971e4 / 0.25e2 * t1079 * t4235 - 0.73e2 / 0.2e3 * t1074 * t1914 + 0.73e2 / 0.4e3 * t1512 * t4240 + 0.73e2 / 0.1e3 * t449 * t4243 - t214 * t4164 / 0.6e2;
  t4249 = t27 * t4248;
  t4250 = t4249 * t711;
  t4253 = t1920 * t476;
  t4254 = t393 * t4253;
  t4257 = t1919 * t229;
  t4258 = t4257 * t482;
  t4263 = t709 * t1113;
  t4264 = t1925 * t1521;
  t4265 = t4263 * t4264;
  t4268 = t27 * t1923;
  t4269 = t4268 * t2538;
  t4270 = t393 * t4269;
  t4271 = t1925 * t107;
  t4272 = t4271 * t441;
  t4276 = t101 * t481 * t232;
  t4277 = t1924 * t4276;
  t4281 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t999 * t1921 - t4147 - 0.3e1 / 0.8e1 * t393 * t4250 - t4254 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t4258 + 0.3e1 / 0.8e1 * t2806 * t1926 + t4151 + 0.3e1 / 0.4e1 * t1358 * t4265 + t4270 * t4272 / 0.6e1 + 0.3e1 / 0.8e1 * t1358 * t4277);
  tv3rhotau25 = t7 * t4281 + t1930;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4283 = params->c * t494;
  t4284 = t3356 * sigma[0];
  t4289 = t117 * t1822;
  t4290 = t4289 * t2015;
  t4294 = (-0.3e1 / 0.256e3 * t4283 * t4284 + 0.27e2 / 0.32768e5 * t493 * t1547 - 0.3e1 / 0.262144e6 * t1144 * t4290) * t46;
  t4301 = t506 * t3386;
  t4303 = t117 * t113;
  t4304 = t4303 * t3396;
  t4306 = t1560 * t515;
  t4309 = t801 * t515;
  t4310 = params->b * t93;
  t4311 = t4310 * t89;
  t4312 = t4309 * t4311;
  t4314 = -0.27e2 / 0.128e3 * t4301 + 0.75e2 / 0.1024e4 * t4304 - 0.81e2 / 0.32e2 * t2054 * t4306 + 0.135e3 / 0.512e3 * t4312;
  t4325 = t1574 * t531;
  t4328 = t531 * t1579;
  t4333 = t4294 * t57 / 0.24e2 + t1551 * t503 / 0.8e1 + 0.292e3 / 0.675e3 * t520 * t1567 + 0.292e3 / 0.2025e4 * t82 * t4314 - 0.73e2 / 0.972e5 * t4314 * t98 - 0.73e2 / 0.648e5 * t3414 * t531 + 0.73e2 / 0.1296e6 * t2687 * t1574 - 0.73e2 / 0.648e5 * t1192 * t1579 - 0.73e2 / 0.2592e6 * t2090 * t4325 + 0.73e2 / 0.1296e6 * t830 * t4328 + t111 * t4303 / 0.384e3;
  t4336 = t3455 * t101;
  t4339 = t2708 * t101;
  t4342 = t2134 * t117;
  t4345 = -t4333 * t127 * t101 + t4336 * t549 / 0.4e1 - t4339 * t1600 / 0.32e2 + t2132 * t4342 / 0.96e2;
  t4346 = t4345 * t130;
  t4347 = t259 * t4346;
  t4350 = t3481 * t553;
  t4353 = t1607 * t552;
  t4354 = t4353 * t130;
  t4355 = t259 * t4354;
  t4359 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t4347 + 0.9e1 / 0.8e1 * t1237 * t4350 + 0.3e1 / 0.8e1 * t258 * t4355);
  tv3sigma30 = t7 * t4359;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4360 = params->c * t562;
  t4361 = t3526 * sigma[2];
  t4366 = t220 * t1881;
  t4367 = t4366 * t2423;
  t4371 = (-0.3e1 / 0.256e3 * t4360 * t4361 + 0.27e2 / 0.32768e5 * t561 * t1621 - 0.3e1 / 0.262144e6 * t1265 * t4367) * t46;
  t4378 = t574 * t3556;
  t4380 = t220 * t113;
  t4381 = t4380 * t3566;
  t4383 = t1634 * t583;
  t4386 = t1050 * t583;
  t4387 = params->b * t202;
  t4388 = t4387 * t89;
  t4389 = t4386 * t4388;
  t4391 = -0.27e2 / 0.128e3 * t4378 + 0.75e2 / 0.1024e4 * t4381 - 0.81e2 / 0.32e2 * t2462 * t4383 + 0.135e3 / 0.512e3 * t4389;
  t4402 = t1648 * t599;
  t4405 = t599 * t1653;
  t4410 = t4371 * t171 / 0.24e2 + t1625 * t571 / 0.8e1 + 0.292e3 / 0.675e3 * t588 * t1641 + 0.292e3 / 0.2025e4 * t195 * t4391 - 0.73e2 / 0.972e5 * t4391 * t207 - 0.73e2 / 0.648e5 * t3584 * t599 + 0.73e2 / 0.1296e6 * t2896 * t1648 - 0.73e2 / 0.648e5 * t1313 * t1653 - 0.73e2 / 0.2592e6 * t2498 * t4402 + 0.73e2 / 0.1296e6 * t1079 * t4405 + t111 * t4380 / 0.384e3;
  t4413 = t3625 * t101;
  t4416 = t2939 * t101;
  t4419 = t2134 * t220;
  t4422 = -t4410 * t229 * t101 + t4413 * t617 / 0.4e1 - t4416 * t1673 / 0.32e2 + t2540 * t4419 / 0.96e2;
  t4423 = t4422 * t232;
  t4424 = t259 * t4423;
  t4427 = t3651 * t621;
  t4430 = t1680 * t620;
  t4431 = t4430 * t232;
  t4432 = t259 * t4431;
  t4436 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t4424 + 0.9e1 / 0.8e1 * t1358 * t4427 + 0.3e1 / 0.8e1 * t393 * t4432);
  tv3sigma39 = t7 * t4436;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4437 = t627 * t41;
  t4445 = t117 * t3011 * t2015;
  t4449 = (-t1540 * t4437 / 0.16e2 + 0.11e2 / 0.512e3 * t30 * t635 - 0.33e2 / 0.32768e5 * t267 * t1692 + 0.3e1 / 0.262144e6 * t764 * t4445) * t46;
  t4460 = t1145 * t113;
  t4461 = t4460 * t3396;
  t4463 = t518 * t3711;
  t4465 = t651 * t1560;
  t4468 = t88 * t515;
  t4470 = t3400 * t1712 * t4468;
  t4472 = t801 * t651;
  t4473 = t4472 * t4311;
  t4475 = 0.9e1 / 0.16e2 * t642 * t3386 - 0.75e2 / 0.128e3 * t4461 - 0.9e1 / 0.64e2 * t4463 - 0.81e2 / 0.32e2 * t2054 * t4465 - 0.45e2 / 0.32e2 * t4470 + 0.45e2 / 0.512e3 * t4473;
  t4492 = t628 * t1574;
  t4497 = t628 * t1579;
  t4504 = t4449 * t57 / 0.24e2 + t1696 * t503 / 0.12e2 + 0.292e3 / 0.2025e4 * t1567 * t654 + 0.584e3 / 0.2025e4 * t520 * t1716 + 0.292e3 / 0.2025e4 * t82 * t4475 - 0.73e2 / 0.972e5 * t4475 * t98 - 0.73e2 / 0.972e5 * t3735 * t531 + 0.73e2 / 0.3888e6 * t3068 * t1574 - 0.73e2 / 0.1944e6 * t1415 * t1579 + 0.73e2 / 0.6e3 * t3414 * t659 - 0.73e2 / 0.6e3 * t3747 * t1725 + 0.73e2 / 0.15e3 * t1192 * t1728 + 0.73e2 / 0.8e3 * t3080 * t4492 - 0.73e2 / 0.3e3 * t3765 * t1725 - 0.73e2 / 0.12e4 * t1420 * t4497 + 0.73e2 / 0.3e3 * t315 * t628 - t1585 * t627 / 0.18e3;
  t4505 = t27 * t4504;
  t4506 = t4505 * t666;
  t4510 = t6 * t28 * t1733;
  t4513 = t3783 * t553;
  t4517 = t864 * t130 * params->e;
  t4518 = t4517 * t1564;
  t4521 = t3815 * t518;
  t4524 = t1441 * t1604;
  t4527 = t1441 * t1608;
  t4531 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4506 + t4510 * t1742 / 0.16e2 - 0.3e1 / 0.4e1 * t1237 * t4513 - t1739 * t4518 / 0.256e3 + t1435 * t4521 / 0.16e2 - 0.3e1 / 0.8e1 * t1237 * t4524 - 0.3e1 / 0.8e1 * t1237 * t4527);
  tv3sigma2tau0 = t7 * t4531;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4532 = t672 * t160;
  t4540 = t220 * t3247 * t2423;
  t4544 = (-t1614 * t4532 / 0.16e2 + 0.11e2 / 0.512e3 * t149 * t680 - 0.33e2 / 0.32768e5 * t401 * t1755 + 0.3e1 / 0.262144e6 * t1013 * t4540) * t46;
  t4555 = t1266 * t113;
  t4556 = t4555 * t3566;
  t4558 = t586 * t3902;
  t4560 = t696 * t1634;
  t4563 = t88 * t583;
  t4565 = t3570 * t1775 * t4563;
  t4567 = t1050 * t696;
  t4568 = t4567 * t4388;
  t4570 = 0.9e1 / 0.16e2 * t687 * t3556 - 0.75e2 / 0.128e3 * t4556 - 0.9e1 / 0.64e2 * t4558 - 0.81e2 / 0.32e2 * t2462 * t4560 - 0.45e2 / 0.32e2 * t4565 + 0.45e2 / 0.512e3 * t4568;
  t4587 = t673 * t1648;
  t4592 = t673 * t1653;
  t4599 = t4544 * t171 / 0.24e2 + t1759 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1641 * t699 + 0.584e3 / 0.2025e4 * t588 * t1779 + 0.292e3 / 0.2025e4 * t195 * t4570 - 0.73e2 / 0.972e5 * t4570 * t207 - 0.73e2 / 0.972e5 * t3926 * t599 + 0.73e2 / 0.3888e6 * t3304 * t1648 - 0.73e2 / 0.1944e6 * t1507 * t1653 + 0.73e2 / 0.6e3 * t3584 * t704 - 0.73e2 / 0.6e3 * t3938 * t1788 + 0.73e2 / 0.15e3 * t1313 * t1791 + 0.73e2 / 0.8e3 * t3316 * t4587 - 0.73e2 / 0.3e3 * t3956 * t1788 - 0.73e2 / 0.12e4 * t1512 * t4592 + 0.73e2 / 0.3e3 * t449 * t673 - t1659 * t672 / 0.18e3;
  t4600 = t27 * t4599;
  t4601 = t4600 * t711;
  t4605 = t6 * t147 * t1796;
  t4608 = t3974 * t621;
  t4612 = t1113 * t232 * params->e;
  t4613 = t4612 * t1638;
  t4616 = t4000 * t586;
  t4619 = t1533 * t1677;
  t4622 = t1533 * t1681;
  t4626 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4601 + t4605 * t1805 / 0.16e2 - 0.3e1 / 0.4e1 * t1358 * t4608 - t1802 * t4613 / 0.256e3 + t1527 * t4616 / 0.16e2 - 0.3e1 / 0.8e1 * t1358 * t4619 - 0.3e1 / 0.8e1 * t1358 * t4622);
  tv3sigma2tau11 = t7 * t4626;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4634 = t117 * t4034 * t2015;
  t4638 = (0.3e1 / 0.16e2 * t490 * t1814 - 0.17e2 / 0.512e3 * t493 * t1818 + 0.39e2 / 0.32768e5 * t1144 * t1824 - 0.3e1 / 0.262144e6 * t2671 * t4634) * t46;
  t4649 = t758 * t113;
  t4650 = t4649 * t3396;
  t4652 = t506 * t4054;
  t4654 = t1835 * t515;
  t4657 = params->b * t1711;
  t4658 = t4657 * t89;
  t4659 = t4472 * t4658;
  t4661 = t1840 * t4468;
  t4664 = 0.9e1 / 0.8e1 * t3700 * t3711 + 0.75e2 / 0.16e2 * t4650 - 0.9e1 / 0.128e3 * t4652 - 0.81e2 / 0.32e2 * t2054 * t4654 - 0.45e2 / 0.32e2 * t4659 + 0.45e2 / 0.8e1 * t3400 * t4661;
  t4679 = t1817 * t531;
  t4682 = t114 * t494;
  t4683 = t4682 * t766;
  t4688 = t1813 * t531;
  t4691 = t525 * t270;
  t4696 = t4638 * t57 / 0.24e2 + t1828 * t503 / 0.24e2 + 0.584e3 / 0.2025e4 * t654 * t1716 + 0.292e3 / 0.2025e4 * t520 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4664 - 0.73e2 / 0.972e5 * t4664 * t98 - 0.73e2 / 0.1944e6 * t4075 * t531 + 0.73e2 / 0.3e3 * t3735 * t659 - 0.73e2 / 0.6e3 * t4080 * t1725 + 0.73e2 / 0.15e3 * t1415 * t1728 + 0.1971e4 / 0.1e3 * t2687 * t1852 - 0.5913e4 / 0.2e3 * t4087 * t4679 + 0.1971e4 / 0.25e2 * t830 * t4683 - 0.73e2 / 0.2e3 * t1192 * t1855 + 0.73e2 / 0.4e3 * t1420 * t4688 - 0.73e2 / 0.1e3 * t315 * t4691 + t538 * t1813 / 0.6e2;
  t4697 = t27 * t4696;
  t4698 = t4697 * t666;
  t4702 = t6 * t28 * t1860;
  t4705 = t4114 * t553;
  t4708 = t1866 * t1733;
  t4709 = t4122 * t4708;
  t4712 = t4130 * t518;
  t4716 = t101 * t552 * t130;
  t4717 = t1865 * t4716;
  t4721 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4698 + t4702 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t4705 + 0.3e1 / 0.4e1 * t1237 * t4709 - t4129 * t4712 / 0.16e2 + 0.3e1 / 0.8e1 * t1237 * t4717);
  tv3sigmatau20 = t7 * t4721;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4729 = t220 * t4177 * t2423;
  t4733 = (0.3e1 / 0.16e2 * t558 * t1873 - 0.17e2 / 0.512e3 * t561 * t1877 + 0.39e2 / 0.32768e5 * t1265 * t1883 - 0.3e1 / 0.262144e6 * t2873 * t4729) * t46;
  t4744 = t1007 * t113;
  t4745 = t4744 * t3566;
  t4747 = t574 * t4197;
  t4749 = t1894 * t583;
  t4752 = params->b * t1774;
  t4753 = t4752 * t89;
  t4754 = t4567 * t4753;
  t4756 = t1899 * t4563;
  t4759 = 0.9e1 / 0.8e1 * t3891 * t3902 + 0.75e2 / 0.16e2 * t4745 - 0.9e1 / 0.128e3 * t4747 - 0.81e2 / 0.32e2 * t2462 * t4749 - 0.45e2 / 0.32e2 * t4754 + 0.45e2 / 0.8e1 * t3570 * t4756;
  t4774 = t1876 * t599;
  t4777 = t217 * t562;
  t4778 = t4777 * t1015;
  t4783 = t1872 * t599;
  t4786 = t593 * t404;
  t4791 = t4733 * t171 / 0.24e2 + t1887 * t571 / 0.24e2 + 0.584e3 / 0.2025e4 * t699 * t1779 + 0.292e3 / 0.2025e4 * t588 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4759 - 0.73e2 / 0.972e5 * t4759 * t207 - 0.73e2 / 0.1944e6 * t4218 * t599 + 0.73e2 / 0.3e3 * t3926 * t704 - 0.73e2 / 0.6e3 * t4223 * t1788 + 0.73e2 / 0.15e3 * t1507 * t1791 + 0.1971e4 / 0.1e3 * t2896 * t1911 - 0.5913e4 / 0.2e3 * t4230 * t4774 + 0.1971e4 / 0.25e2 * t1079 * t4778 - 0.73e2 / 0.2e3 * t1313 * t1914 + 0.73e2 / 0.4e3 * t1512 * t4783 - 0.73e2 / 0.1e3 * t449 * t4786 + t606 * t1872 / 0.6e2;
  t4792 = t27 * t4791;
  t4793 = t4792 * t711;
  t4797 = t6 * t147 * t1919;
  t4800 = t4257 * t621;
  t4803 = t1925 * t1796;
  t4804 = t4263 * t4803;
  t4807 = t4271 * t586;
  t4811 = t101 * t620 * t232;
  t4812 = t1924 * t4811;
  t4816 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4793 + t4797 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t4800 + 0.3e1 / 0.4e1 * t1358 * t4804 - t4270 * t4807 / 0.16e2 + 0.3e1 / 0.8e1 * t1358 * t4812);
  tv3sigmatau28 = t7 * t4816;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4817 = t32 * t633;
  t4818 = t4817 * t41;
  t4821 = t494 * t1381;
  t4822 = t4821 * t273;
  t4825 = t758 * t3011;
  t4826 = t4825 * t769;
  t4830 = 0.1e1 / t1821 / t626;
  t4832 = t117 * t4830 * t2015;
  t4836 = (-0.3e1 / 0.8e1 * t30 * t4818 + 0.3e1 / 0.64e2 * t267 * t4822 - 0.45e2 / 0.32768e5 * t764 * t4826 + 0.3e1 / 0.262144e6 * t2010 * t4832) * t46;
  t4843 = t268 * t113;
  t4846 = t1835 * t651;
  t4849 = params->b * t1839;
  t4850 = t4849 * t89;
  t4853 = 0.27e2 / 0.16e2 * t642 * t4054 - 0.75e2 / 0.2e1 * t4843 * t3396 - 0.81e2 / 0.32e2 * t2054 * t4846 + 0.135e3 / 0.8e1 * t4472 * t4850;
  t4864 = t763 * t758;
  t4865 = t4864 * t3011;
  t4868 = t1851 * t1381;
  t4871 = t36 * t633;
  t4876 = t4836 * t57 / 0.24e2 + 0.292e3 / 0.675e3 * t654 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4853 - 0.73e2 / 0.972e5 * t4853 * t98 + 0.73e2 / 0.2e3 * t4075 * t659 + 0.5913e4 / 0.1e3 * t3068 * t1852 - 0.219e3 / 0.2e3 * t1415 * t1855 + 0.478953e6 / 0.5e2 * t2090 * t4865 - 0.17739e5 / 0.1e3 * t830 * t4868 + 0.73e2 / 0.5e2 * t315 * t4871 - t108 * t4817 / 0.3e2;
  t4877 = t27 * t4876;
  t4878 = t4877 * t666;
  t4881 = t1860 * t864;
  t4883 = t664 * t101 * t130;
  t4884 = t4881 * t4883;
  t4887 = t1864 * t664;
  t4889 = 0.1e1 / t863 / t126;
  t4890 = t4887 * t4889;
  t4891 = params->kappa * params->kappa;
  t4892 = 0.1e1 / t4891;
  t4893 = t4892 * t130;
  t4894 = t4890 * t4893;
  t4898 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4878 + 0.9e1 / 0.8e1 * t1237 * t4884 - 0.3e1 / 0.8e1 * t1237 * t4894);
  tv3tau30 = t7 * t4898;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4899 = t151 * t678;
  t4900 = t4899 * t160;
  t4903 = t562 * t1473;
  t4904 = t4903 * t407;
  t4907 = t1007 * t3247;
  t4908 = t4907 * t1018;
  t4912 = 0.1e1 / t1880 / t671;
  t4914 = t220 * t4912 * t2423;
  t4918 = (-0.3e1 / 0.8e1 * t149 * t4900 + 0.3e1 / 0.64e2 * t401 * t4904 - 0.45e2 / 0.32768e5 * t1013 * t4908 + 0.3e1 / 0.262144e6 * t2418 * t4914) * t46;
  t4925 = t402 * t113;
  t4928 = t1894 * t696;
  t4931 = params->b * t1898;
  t4932 = t4931 * t89;
  t4935 = 0.27e2 / 0.16e2 * t687 * t4197 - 0.75e2 / 0.2e1 * t4925 * t3566 - 0.81e2 / 0.32e2 * t2462 * t4928 + 0.135e3 / 0.8e1 * t4567 * t4932;
  t4946 = t1012 * t1007;
  t4947 = t4946 * t3247;
  t4950 = t1910 * t1473;
  t4953 = t155 * t678;
  t4958 = t4918 * t171 / 0.24e2 + 0.292e3 / 0.675e3 * t699 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4935 - 0.73e2 / 0.972e5 * t4935 * t207 + 0.73e2 / 0.2e3 * t4218 * t704 + 0.5913e4 / 0.1e3 * t3304 * t1911 - 0.219e3 / 0.2e3 * t1507 * t1914 + 0.478953e6 / 0.5e2 * t2498 * t4947 - 0.17739e5 / 0.1e3 * t1079 * t4950 + 0.73e2 / 0.5e2 * t449 * t4953 - t214 * t4899 / 0.3e2;
  t4959 = t27 * t4958;
  t4960 = t4959 * t711;
  t4963 = t1919 * t1113;
  t4965 = t709 * t101 * t232;
  t4966 = t4963 * t4965;
  t4969 = t1923 * t709;
  t4971 = 0.1e1 / t1112 / t228;
  t4972 = t4969 * t4971;
  t4973 = t4892 * t232;
  t4974 = t4972 * t4973;
  t4978 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4960 + 0.9e1 / 0.8e1 * t1358 * t4966 - 0.3e1 / 0.8e1 * t1358 * t4974);
  tv3tau33 = t7 * t4978;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

}

#endif


#ifndef XC_DONT_COMPILE_LXC
GPU_DEVICE_FUNCTION static inline void
func_lxc_pol(const xc_func_type *p, size_t ip, const double *rho, const double *sigma, const double *lapl, const double *tau, xc_mgga_out_params *out)
{
  double t2, t3, t4, t6, t7, t8, t11, t12;
  double t15, t16, t17, t19, t20, t21, t22, t23;
  double t24, t26, t27, t28, t29, t30, t31, t32;
  double t33, t34, t35, t36, t37, t39, t40, t41;
  double t42, t46, t47, t48, t49, t50, t51, t52;
  double t53, t54, t56, t57, t61, t63, t65, t69;
  double t70, t71, t72, t75, t76, t77, t82, t83;
  double t86, t88, t89, t90, t91, t93, t97, t98;
  double t101, t102, t103, t107, t108, t111, t112, t113;
  double t114, t115, t116, t117, t121, t122, t125, t126;
  double t127, t130, t133, t137, t138, t139, t141, t142;
  double t143, t144, t146, t147, t148, t149, t150, t151;
  double t152, t153, t154, t155, t156, t158, t159, t160;
  double t161, t165, t166, t167, t168, t170, t171, t175;
  double t177, t179, t183, t184, t185, t188, t189, t190;
  double t195, t196, t199, t200, t202, t206, t207, t210;
  double t214, t217, t218, t219, t220, t224, t227, t228;
  double t229, t232, t235, t239, tzk0;

  double t240, t241, t242, t244, t247, t248, t252, t253;
  double t254, t257, t258, t259, t260, t261, t262, t263;
  double t266, t267, t268, t269, t270, t273, t274, t278;
  double t282, t283, t288, t290, t291, t292, t296, t297;
  double t301, t304, t307, t309, t314, t315, t316, t319;
  double t321, t325, t333, t334, t338, t341, t342, t343;
  double t344, t345, t348, t349, t350, t354, t355, t357;
  double t360, t361, t365, t368, t370, tvrho0, t374, t377;
  double t378, t383, t385, t388, t389, t393, t394, t395;
  double t396, t397, t400, t401, t402, t403, t404, t407;
  double t408, t412, t416, t417, t422, t424, t425, t426;
  double t430, t431, t435, t438, t441, t443, t448, t449;
  double t450, t453, t455, t459, t467, t468, t472, t475;
  double t476, t477, t478, t481, t482, t483, t487, tvrho1;
  double t490, t493, t494, t495, t496, t500, t503, t506;
  double t507, t509, t510, t513, t515, t518, t520, t525;
  double t531, t534, t538, t541, t545, t548, t549, t552;
  double t553, t554, t557, tvsigma0, tvsigma1, t558, t561, t562;
  double t563, t564, t568, t571, t574, t575, t577, t578;
  double t581, t583, t586, t588, t593, t599, t602, t606;
  double t609, t613, t616, t617, t620, t621, t622, t625;
  double tvsigma2, tvlapl0, tvlapl1, t626, t627, t628, t629, t632;
  double t633, t635, t639, t642, t645, t651, t654, t659;
  double t664, t665, t666, t667, t670, tvtau0, t671, t672;
  double t673, t674, t677, t678, t680, t684, t687, t690;
  double t696, t699, t704, t709, t710, t711, t712, t715;
  double tvtau1;

  double t718, t719, t720, t723, t724, t725, t728, t732;
  double t733, t737, t739, t741, t745, t746, t749, t750;
  double t751, t752, t754, t755, t758, t760, t763, t764;
  double t765, t766, t768, t769, t770, t774, t780, t781;
  double t784, t788, t790, t791, t794, t795, t798, t800;
  double t801, t802, t805, t808, t812, t815, t818, t820;
  double t825, t829, t830, t831, t834, t837, t839, t841;
  double t843, t846, t851, t852, t856, t859, t860, t863;
  double t864, t865, t866, t867, t872, t873, t874, t877;
  double t878, t879, t883, t884, t885, t886, t889, t892;
  double t896, t897, t901, t903, t905, t908, t910, tv2rho20;
  double t913, t917, t921, t922, t926, t928, t930, t936;
  double t937, t941, t945, t946, t950, t952, t955, t958;
  double t959, t962, tv2rho21, t967, t972, t976, t977, t983;
  double t984, t989, t993, t994, t999, t1003, t1004, t1007;
  double t1009, t1012, t1013, t1014, t1015, t1017, t1018, t1019;
  double t1023, t1029, t1030, t1033, t1037, t1039, t1040, t1043;
  double t1044, t1047, t1049, t1050, t1051, t1054, t1057, t1061;
  double t1064, t1067, t1069, t1074, t1078, t1079, t1080, t1083;
  double t1086, t1088, t1090, t1092, t1095, t1100, t1101, t1105;
  double t1108, t1109, t1112, t1113, t1114, t1115, t1120, t1121;
  double t1122, t1125, t1126, t1127, t1131, tv2rho22, t1136, t1138;
  double t1143, t1144, t1145, t1147, t1151, t1158, t1163, t1164;
  double t1166, t1168, t1171, t1174, t1175, t1177, t1180, t1182;
  double t1185, t1187, t1192, t1197, t1200, t1204, t1206, t1209;
  double t1217, t1220, t1221, t1224, t1229, t1232, t1233, t1234;
  double t1237, t1238, t1239, t1243, tv2rhosigma0, tv2rhosigma1, t1247, t1249;
  double t1251, tv2rhosigma2, t1256, tv2rhosigma3, tv2rhosigma4, t1264, t1265, t1266;
  double t1268, t1272, t1279, t1284, t1285, t1287, t1289, t1292;
  double t1295, t1296, t1298, t1301, t1303, t1306, t1308, t1313;
  double t1318, t1321, t1325, t1327, t1330, t1338, t1341, t1342;
  double t1345, t1350, t1353, t1354, t1355, t1358, t1359, t1360;
  double t1364, tv2rhosigma5, tv2rholapl0, tv2rholapl1, tv2rholapl2, tv2rholapl3, t1368, t1369;
  double t1371, t1372, t1373, t1377, t1381, t1383, t1387, t1397;
  double t1400, t1407, t1410, t1415, t1420, t1421, t1424, t1429;
  double t1430, t1431, t1434, t1435, t1437, t1438, t1441, t1442;
  double t1446, tv2rhotau0, t1450, t1451, t1453, t1455, tv2rhotau1, t1460;
  double tv2rhotau2, t1464, t1465, t1469, t1473, t1475, t1479, t1489;
  double t1492, t1499, t1502, t1507, t1512, t1513, t1516, t1521;
  double t1522, t1523, t1526, t1527, t1529, t1530, t1533, t1534;
  double t1538, tv2rhotau3, t1540, t1541, t1546, t1547, t1551, t1556;
  double t1558, t1560, t1563, t1564, t1565, t1567, t1574, t1579;
  double t1582, t1585, t1588, t1592, t1595, t1598, t1599, t1600;
  double t1603, t1604, t1605, t1607, t1608, t1609, t1613, tv2sigma20;
  double tv2sigma21, tv2sigma22, tv2sigma23, tv2sigma24, t1614, t1615, t1620, t1621;
  double t1625, t1630, t1632, t1634, t1637, t1638, t1639, t1641;
  double t1648, t1653, t1656, t1659, t1662, t1666, t1669, t1672;
  double t1673, t1676, t1677, t1678, t1680, t1681, t1682, t1686;
  double tv2sigma25, tv2sigmalapl0, tv2sigmalapl1, tv2sigmalapl2, tv2sigmalapl3, tv2sigmalapl4, tv2sigmalapl5, t1692;
  double t1696, t1705, t1707, t1711, t1712, t1714, t1716, t1725;
  double t1728, t1733, t1734, t1735, t1738, t1739, t1741, t1742;
  double t1745, t1749, tv2sigmatau0, tv2sigmatau1, tv2sigmatau2, tv2sigmatau3, tv2sigmatau4, t1755;
  double t1759, t1768, t1770, t1774, t1775, t1777, t1779, t1788;
  double t1791, t1796, t1797, t1798, t1801, t1802, t1804, t1805;
  double t1808, t1812, tv2sigmatau5, tv2lapl20, tv2lapl21, tv2lapl22, tv2lapltau0, tv2lapltau1;
  double tv2lapltau2, tv2lapltau3, t1813, t1814, t1817, t1818, t1821, t1822;
  double t1824, t1828, t1831, t1835, t1839, t1840, t1844, t1851;
  double t1852, t1855, t1860, t1861, t1862, t1864, t1865, t1866;
  double t1867, t1871, tv2tau20, tv2tau21, t1872, t1873, t1876, t1877;
  double t1880, t1881, t1883, t1887, t1890, t1894, t1898, t1899;
  double t1903, t1910, t1911, t1914, t1919, t1920, t1921, t1923;
  double t1924, t1925, t1926, t1930, tv2tau22;

  double t1935, t1939, t1942, t1946, t1948, t1949, t1952, t1955;
  double t1956, t1957, t1960, t1964, t1969, t1970, t1972, t1973;
  double t1977, t1978, t1983, t1986, t1990, t1991, t1992, t1994;
  double t1995, t1997, t1998, t2002, t2006, t2009, t2010, t2011;
  double t2012, t2015, t2016, t2020, t2028, t2029, t2036, t2038;
  double t2039, t2044, t2045, t2048, t2053, t2054, t2055, t2061;
  double t2066, t2069, t2072, t2074, t2079, t2082, t2087, t2089;
  double t2090, t2091, t2094, t2097, t2101, t2103, t2105, t2108;
  double t2116, t2119, t2120, t2123, t2124, t2130, t2132, t2133;
  double t2134, t2136, t2143, t2144, t2145, t2148, t2149, t2151;
  double t2152, t2155, t2158, t2161, t2165, t2172, t2176, t2181;
  double t2183, tv3rho30, t2186, t2187, t2188, t2191, t2196, t2197;
  double t2199, t2203, t2211, t2212, t2217, t2220, t2231, t2232;
  double t2233, t2236, t2241, t2243, t2247, t2255, t2258, t2262;
  double t2266, t2267, t2268, t2271, tv3rho31, t2274, t2279, t2283;
  double t2287, t2294, t2296, t2303, t2304, t2309, t2313, t2317;
  double t2324, t2327, t2330, t2336, t2337, t2341, t2342, t2344;
  double t2345, tv3rho32, t2350, t2357, t2361, t2369, t2372, t2379;
  double t2383, t2388, t2389, t2393, t2394, t2405, t2406, t2410;
  double t2414, t2417, t2418, t2419, t2420, t2423, t2424, t2428;
  double t2436, t2437, t2444, t2446, t2447, t2452, t2453, t2456;
  double t2461, t2462, t2463, t2469, t2474, t2477, t2480, t2482;
  double t2487, t2490, t2495, t2497, t2498, t2499, t2502, t2505;
  double t2509, t2511, t2513, t2516, t2524, t2527, t2528, t2531;
  double t2532, t2538, t2540, t2542, t2549, t2550, t2551, t2554;
  double t2557, t2558, tv3rho33, t2564, t2568, t2571, t2573, t2574;
  double t2575, t2577, t2578, t2580, t2589, t2593, t2595, t2606;
  double t2607, t2609, t2611, t2613, t2617, t2618, t2619, t2622;
  double t2634, t2635, t2637, t2639, t2642, t2644, t2647, t2649;
  double t2654, t2655, t2658, t2671, t2673, t2677, t2682, t2687;
  double t2692, t2695, t2700, t2701, t2704, t2705, t2708, t2709;
  double t2714, t2722, t2727, t2730, t2731, t2732, t2735, t2736;
  double t2739, t2742, t2745, t2746, tv3rho2sigma0, tv3rho2sigma1, t2751, t2753;
  double t2755, t2757, tv3rho2sigma2, t2761, t2765, t2772, tv3rho2sigma3, tv3rho2sigma4;
  double t2776, t2781, t2782, t2784, t2787, t2788, t2791, tv3rho2sigma5;
  double t2798, tv3rho2sigma6, tv3rho2sigma7, t2806, t2815, t2816, t2818, t2820;
  double t2822, t2826, t2827, t2828, t2831, t2843, t2844, t2846;
  double t2848, t2851, t2853, t2856, t2858, t2873, t2875, t2879;
  double t2884, t2887, t2890, t2895, t2896, t2901, t2904, t2909;
  double t2918, t2922, t2924, t2931, t2932, t2935, t2936, t2939;
  double t2940, t2945, t2953, t2958, t2961, t2962, t2963, t2966;
  double t2967, t2970, t2973, t2976, t2977, tv3rho2sigma8, tv3rho2lapl0, tv3rho2lapl1;
  double tv3rho2lapl2, tv3rho2lapl3, tv3rho2lapl4, tv3rho2lapl5, t2980, t2981, t2983, t2984;
  double t2987, t2994, t2995, t2996, t2998, t2999, t3003, t3007;
  double t3011, t3013, t3017, t3036, t3037, t3040, t3057, t3060;
  double t3065, t3068, t3075, t3080, t3081, t3084, t3087, t3090;
  double t3095, t3096, t3097, t3100, t3102, t3103, t3106, t3109;
  double t3113, t3114, t3116, t3117, t3120, t3121, t3124, t3127;
  double t3128, t3129, t3131, t3132, t3135, t3136, tv3rho2tau0, t3141;
  double t3143, t3144, t3146, t3148, tv3rho2tau1, t3152, t3156, t3166;
  double tv3rho2tau2, t3170, t3175, t3176, t3177, t3179, t3182, t3183;
  double t3184, t3188, t3191, tv3rho2tau3, t3198, tv3rho2tau4, t3203, t3204;
  double t3207, t3212, t3213, t3215, t3216, t3219, t3222, t3223;
  double t3226, t3234, t3235, t3239, t3243, t3247, t3249, t3253;
  double t3272, t3273, t3276, t3293, t3296, t3301, t3304, t3311;
  double t3316, t3317, t3320, t3323, t3326, t3331, t3332, t3333;
  double t3336, t3339, t3340, t3344, t3345, tv3rho2tau5, t3349, t3351;
  double t3352, t3355, t3356, t3357, t3363, t3367, t3380, t3382;
  double t3384, t3386, t3395, t3396, t3397, t3398, t3400, t3401;
  double t3402, t3403, t3404, t3406, t3407, t3409, t3414, t3426;
  double t3429, t3434, t3439, t3442, t3445, t3451, t3452, t3455;
  double t3456, t3459, t3466, t3470, t3473, t3476, t3477, t3478;
  double t3481, t3482, t3487, t3489, t3490, t3493, t3494, t3498;
  double tv3rhosigma20, tv3rhosigma21, tv3rhosigma22, tv3rhosigma23, tv3rhosigma24, t3502, t3504, t3507;
  double t3509, t3511, tv3rhosigma25, t3518, tv3rhosigma26, tv3rhosigma27, tv3rhosigma28, tv3rhosigma29;
  double tv3rhosigma210, t3522, t3525, t3526, t3527, t3533, t3537, t3550;
  double t3552, t3554, t3556, t3565, t3566, t3567, t3568, t3570;
  double t3571, t3572, t3573, t3574, t3576, t3577, t3579, t3584;
  double t3596, t3599, t3604, t3609, t3612, t3615, t3621, t3622;
  double t3625, t3626, t3629, t3636, t3640, t3643, t3646, t3647;
  double t3648, t3651, t3652, t3657, t3660, t3661, t3665, tv3rhosigma211;
  double tv3rhosigmalapl0, tv3rhosigmalapl1, tv3rhosigmalapl2, tv3rhosigmalapl3, tv3rhosigmalapl4, tv3rhosigmalapl5, tv3rhosigmalapl6, tv3rhosigmalapl7;
  double tv3rhosigmalapl8, tv3rhosigmalapl9, tv3rhosigmalapl10, tv3rhosigmalapl11, t3669, t3670, t3672, t3680;
  double t3684, t3700, t3705, t3707, t3709, t3711, t3717, t3720;
  double t3723, t3724, t3726, t3727, t3730, t3735, t3742, t3747;
  double t3754, t3757, t3760, t3765, t3768, t3773, t3774, t3775;
  double t3776, t3779, t3780, t3783, t3784, t3788, t3792, t3794;
  double t3796, t3799, t3802, t3805, t3811, t3812, t3815, t3816;
  double t3819, t3823, t3824, t3827, t3828, tv3rhosigmatau0, tv3rhosigmatau1, tv3rhosigmatau2;
  double tv3rhosigmatau3, tv3rhosigmatau4, t3832, t3833, t3835, t3837, t3841, t3843;
  double t3847, t3849, tv3rhosigmatau5, t3854, t3860, tv3rhosigmatau6, tv3rhosigmatau7, tv3rhosigmatau8;
  double tv3rhosigmatau9, tv3rhosigmatau10, t3871, t3875, t3891, t3896, t3898, t3900;
  double t3902, t3908, t3911, t3914, t3915, t3917, t3918, t3921;
  double t3926, t3933, t3938, t3945, t3948, t3951, t3956, t3959;
  double t3964, t3965, t3966, t3967, t3970, t3971, t3974, t3975;
  double t3979, t3983, t3986, t3989, t3992, t3997, t4000, t4001;
  double t4004, t4008, t4009, t4012, t4013, tv3rhosigmatau11, tv3rholapl20, tv3rholapl21;
  double tv3rholapl22, tv3rholapl23, tv3rholapl24, tv3rholapl25, tv3rholapltau0, tv3rholapltau1, tv3rholapltau2, tv3rholapltau3;
  double tv3rholapltau4, tv3rholapltau5, tv3rholapltau6, tv3rholapltau7, t4017, t4018, t4020, t4021;
  double t4022, t4025, t4026, t4030, t4034, t4036, t4040, t4054;
  double t4063, t4066, t4070, t4075, t4080, t4087, t4088, t4091;
  double t4092, t4097, t4100, t4105, t4106, t4107, t4110, t4111;
  double t4114, t4115, t4121, t4122, t4123, t4124, t4127, t4128;
  double t4129, t4130, t4131, t4135, t4136, t4140, tv3rhotau20, tv3rhotau21;
  double t4144, t4145, t4147, t4151, t4153, tv3rhotau22, t4160, tv3rhotau23;
  double tv3rhotau24, t4164, t4165, t4168, t4169, t4173, t4177, t4179;
  double t4183, t4197, t4206, t4209, t4213, t4218, t4223, t4230;
  double t4231, t4234, t4235, t4240, t4243, t4248, t4249, t4250;
  double t4253, t4254, t4257, t4258, t4263, t4264, t4265, t4268;
  double t4269, t4270, t4271, t4272, t4276, t4277, t4281, tv3rhotau25;
  double t4283, t4284, t4289, t4290, t4294, t4301, t4303, t4304;
  double t4306, t4309, t4310, t4311, t4312, t4314, t4325, t4328;
  double t4333, t4336, t4339, t4342, t4345, t4346, t4347, t4350;
  double t4353, t4354, t4355, t4359, tv3sigma30, tv3sigma31, tv3sigma32, tv3sigma33;
  double tv3sigma34, tv3sigma35, tv3sigma36, tv3sigma37, tv3sigma38, t4360, t4361, t4366;
  double t4367, t4371, t4378, t4380, t4381, t4383, t4386, t4387;
  double t4388, t4389, t4391, t4402, t4405, t4410, t4413, t4416;
  double t4419, t4422, t4423, t4424, t4427, t4430, t4431, t4432;
  double t4436, tv3sigma39, tv3sigma2lapl0, tv3sigma2lapl1, tv3sigma2lapl2, tv3sigma2lapl3, tv3sigma2lapl4, tv3sigma2lapl5;
  double tv3sigma2lapl6, tv3sigma2lapl7, tv3sigma2lapl8, tv3sigma2lapl9, tv3sigma2lapl10, tv3sigma2lapl11, t4437, t4445;
  double t4449, t4460, t4461, t4463, t4465, t4468, t4470, t4472;
  double t4473, t4475, t4492, t4497, t4504, t4505, t4506, t4510;
  double t4513, t4517, t4518, t4521, t4524, t4527, t4531, tv3sigma2tau0;
  double tv3sigma2tau1, tv3sigma2tau2, tv3sigma2tau3, tv3sigma2tau4, tv3sigma2tau5, tv3sigma2tau6, tv3sigma2tau7, tv3sigma2tau8;
  double tv3sigma2tau9, tv3sigma2tau10, t4532, t4540, t4544, t4555, t4556, t4558;
  double t4560, t4563, t4565, t4567, t4568, t4570, t4587, t4592;
  double t4599, t4600, t4601, t4605, t4608, t4612, t4613, t4616;
  double t4619, t4622, t4626, tv3sigma2tau11, tv3sigmalapl20, tv3sigmalapl21, tv3sigmalapl22, tv3sigmalapl23;
  double tv3sigmalapl24, tv3sigmalapl25, tv3sigmalapl26, tv3sigmalapl27, tv3sigmalapl28, tv3sigmalapltau0, tv3sigmalapltau1, tv3sigmalapltau2;
  double tv3sigmalapltau3, tv3sigmalapltau4, tv3sigmalapltau5, tv3sigmalapltau6, tv3sigmalapltau7, tv3sigmalapltau8, tv3sigmalapltau9, tv3sigmalapltau10;
  double tv3sigmalapltau11, t4634, t4638, t4649, t4650, t4652, t4654, t4657;
  double t4658, t4659, t4661, t4664, t4679, t4682, t4683, t4688;
  double t4691, t4696, t4697, t4698, t4702, t4705, t4708, t4709;
  double t4712, t4716, t4717, t4721, tv3sigmatau20, tv3sigmatau21, tv3sigmatau22, tv3sigmatau23;
  double tv3sigmatau24, tv3sigmatau25, tv3sigmatau26, tv3sigmatau27, t4729, t4733, t4744, t4745;
  double t4747, t4749, t4752, t4753, t4754, t4756, t4759, t4774;
  double t4777, t4778, t4783, t4786, t4791, t4792, t4793, t4797;
  double t4800, t4803, t4804, t4807, t4811, t4812, t4816, tv3sigmatau28;
  double tv3lapl30, tv3lapl31, tv3lapl32, tv3lapl33, tv3lapl2tau0, tv3lapl2tau1, tv3lapl2tau2, tv3lapl2tau3;
  double tv3lapl2tau4, tv3lapl2tau5, tv3lapltau20, tv3lapltau21, tv3lapltau22, tv3lapltau23, tv3lapltau24, tv3lapltau25;
  double t4817, t4818, t4821, t4822, t4825, t4826, t4830, t4832;
  double t4836, t4843, t4846, t4849, t4850, t4853, t4864, t4865;
  double t4868, t4871, t4876, t4877, t4878, t4881, t4883, t4884;
  double t4887, t4889, t4890, t4891, t4892, t4893, t4894, t4898;
  double tv3tau30, tv3tau31, tv3tau32, t4899, t4900, t4903, t4904, t4907;
  double t4908, t4912, t4914, t4918, t4925, t4928, t4931, t4932;
  double t4935, t4946, t4947, t4950, t4953, t4958, t4959, t4960;
  double t4963, t4965, t4966, t4969, t4971, t4972, t4973, t4974;
  double t4978, tv3tau33;

  double t4990, t4993, t4996, t5000, t5001, t5005, t5012, t5013;
  double t5015, t5025, t5026, t5030, t5033, t5036, t5039, t5040;
  double t5046, t5057, t5067, t5069, t5085, t5092, t5097, t5100;
  double t5106, t5109, t5112, t5120, t5121, t5143, t5144, t5148;
  double t5156, t5160, t5164, t5165, t5171, t5179, t5180, t5181;
  double t5198, t5203, t5205, t5207, t5210, t5218, t5220, t5223;
  double t5225, t5226, t5232, t5235, t5237, t5243, t5247, t5251;
  double t5254, t5258, t5261, t5263, t5265, t5266, t5272, t5278;
  double t5279, t5282, t5286, t5291, t5293, t5294, t5296, t5297;
  double t5303, t5308, t5311, t5315, t5322, t5326, t5330, t5335;
  double t5337, tv4rho40, t5345, t5346, t5347, t5359, t5363, t5364;
  double t5367, t5393, t5394, t5396, t5400, t5407, t5411, t5412;
  double t5415, t5417, t5419, t5436, t5438, t5442, t5449, t5453;
  double t5454, t5457, t5462, t5465, t5467, t5468, t5470, t5472;
  double t5473, tv4rho41, t5488, t5501, t5505, t5512, t5516, t5528;
  double t5531, t5541, t5543, t5545, t5555, t5568, t5572, t5579;
  double t5583, t5593, t5595, t5597, t5600, t5602, t5609, t5612;
  double t5614, tv4rho42, t5635, t5639, t5646, t5648, t5657, t5658;
  double t5659, t5671, t5681, t5683, t5686, t5688, t5690, t5693;
  double t5714, t5718, t5725, t5727, t5729, tv4rho43, t5734, t5739;
  double t5746, t5750, t5759, t5771, t5774, t5782, t5783, t5789;
  double t5795, t5799, t5803, t5804, t5824, t5825, t5829, t5837;
  double t5838, t5845, t5846, t5848, t5858, t5859, t5863, t5866;
  double t5869, t5872, t5873, t5879, t5890, t5900, t5902, t5916;
  double t5927, t5932, t5936, t5940, t5941, t5947, t5955, t5972;
  double t5977, t5988, t5993, t5998, t6009, t6014, t6021, t6025;
  double t6030, t6032, tv4rho44, t6037, t6046, t6048, t6050, t6059;
  double t6060, t6066, t6069, t6070, t6071, t6096, t6100, t6123;
  double t6128, t6138, t6141, t6150, t6153, t6154, t6187, t6188;
  double t6189, t6205, t6216, t6237, t6240, t6251, t6262, t6265;
  double t6270, t6287, t6291, t6292, t6317, t6322, t6324, t6328;
  double t6330, t6333, t6337, t6341, t6343, tv4rho3sigma0, tv4rho3sigma1, t6348;
  double t6350, t6354, t6356, tv4rho3sigma2, t6358, t6364, t6371, t6372;
  double t6375, t6377, t6379, t6380, t6394, t6396, tv4rho3sigma3, tv4rho3sigma4;
  double t6398, t6402, t6403, t6410, t6412, t6414, t6417, t6419;
  double t6420, t6421, t6423, t6424, tv4rho3sigma5, t6428, t6432, t6439;
  double t6440, tv4rho3sigma6, tv4rho3sigma7, t6444, t6449, t6451, t6454, t6455;
  double t6458, t6464, t6468, t6472, t6476, t6478, t6480, tv4rho3sigma8;
  double t6488, tv4rho3sigma9, tv4rho3sigma10, t6493, t6506, t6515, t6520, t6525;
  double t6529, t6550, t6565, t6566, t6571, t6578, t6581, t6603;
  double t6616, t6642, t6660, t6661, t6662, t6677, t6682, t6703;
  double t6707, t6708, t6729, t6744, t6749, t6764, t6779, t6781;
  double tv4rho3sigma11, tv4rho3lapl0, tv4rho3lapl1, tv4rho3lapl2, tv4rho3lapl3, tv4rho3lapl4, tv4rho3lapl5, tv4rho3lapl6;
  double tv4rho3lapl7, t6792, t6799, t6803, t6809, t6813, t6816, t6818;
  double t6823, t6824, t6829, t6838, t6842, t6846, t6862, t6867;
  double t6874, t6904, t6918, t6919, t6922, t6929, t6930, t6937;
  double t6938, t6949, t6954, t6993, t6996, t6999, t7006, t7014;
  double t7022, t7024, t7029, t7030, t7032, t7036, t7044, t7046;
  double t7048, t7054, t7056, t7065, t7067, t7078, t7079, t7080;
  double t7086, t7089, tv4rho3tau0, t7094, t7096, t7101, t7103, tv4rho3tau1;
  double t7105, t7111, t7119, t7131, t7132, t7138, t7140, t7153;
  double t7161, t7163, tv4rho3tau2, t7165, t7169, t7170, t7177, t7180;
  double t7187, t7190, t7195, t7196, t7198, t7199, tv4rho3tau3, t7203;
  double t7217, t7218, tv4rho3tau4, t7221, t7224, t7228, t7231, t7232;
  double t7239, t7245, t7255, t7257, t7259, t7262, t7267, t7269;
  double t7277, t7279, t7284, t7286, tv4rho3tau5, t7294, tv4rho3tau6, t7317;
  double t7321, t7326, t7334, t7342, t7346, t7353, t7363, t7376;
  double t7393, t7413, t7414, t7417, t7429, t7430, t7437, t7438;
  double t7449, t7465, t7495, t7498, t7501, t7506, t7514, t7536;
  double t7539, t7558, t7559, t7565, t7568, tv4rho3tau7, t7574, t7584;
  double t7591, t7599, t7600, t7602, t7603, t7605, t7613, t7619;
  double t7620, t7629, t7648, t7652, t7673, t7698, t7709, t7712;
  double t7730, t7735, t7738, t7744, t7753, t7769, t7773, t7776;
  double t7779, t7788, t7789, t7799, t7805, t7806, t7813, t7817;
  double t7821, t7822, t7862, t7867, t7869, tv4rho2sigma20, tv4rho2sigma21, tv4rho2sigma22;
  double tv4rho2sigma23, tv4rho2sigma24, t7874, t7878, t7881, t7885, t7887, tv4rho2sigma25;
  double t7891, t7902, t7911, t7912, tv4rho2sigma26, tv4rho2sigma27, tv4rho2sigma28, tv4rho2sigma29;
  double tv4rho2sigma210, t7916, t7922, t7926, t7930, t7935, t7939, t7941;
  double t7942, tv4rho2sigma211, t7952, tv4rho2sigma212, tv4rho2sigma213, tv4rho2sigma214, tv4rho2sigma215, tv4rho2sigma216;
  double t7959, t7970, t7983, t7994, t7997, t8000, t8010, t8016;
  double t8029, t8034, t8038, t8041, t8042, t8050, t8051, t8059;
  double t8063, t8094, t8117, t8134, t8137, t8140, t8165, t8169;
  double t8173, t8174, t8214, t8219, t8226, t8238, t8240, tv4rho2sigma217;
  double tv4rho2sigmalapl0, tv4rho2sigmalapl1, tv4rho2sigmalapl2, tv4rho2sigmalapl3, tv4rho2sigmalapl4, tv4rho2sigmalapl5, tv4rho2sigmalapl6, tv4rho2sigmalapl7;
  double tv4rho2sigmalapl8, tv4rho2sigmalapl9, tv4rho2sigmalapl10, tv4rho2sigmalapl11, tv4rho2sigmalapl12, tv4rho2sigmalapl13, tv4rho2sigmalapl14, tv4rho2sigmalapl15;
  double tv4rho2sigmalapl16, tv4rho2sigmalapl17, t8255, t8257, t8264, t8271, t8287, t8295;
  double t8301, t8305, t8315, t8318, t8319, t8329, t8341, t8342;
  double t8346, t8358, t8366, t8368, t8373, t8377, t8403, t8405;
  double t8415, t8420, t8434, t8438, t8459, t8462, t8497, t8500;
  double t8521, t8560, t8563, t8564, t8567, t8604, t8609, t8620;
  double t8624, t8629, t8635, t8638, tv4rho2sigmatau0, tv4rho2sigmatau1, tv4rho2sigmatau2, tv4rho2sigmatau3;
  double tv4rho2sigmatau4, t8643, t8648, t8655, t8660, t8663, t8666, t8668;
  double tv4rho2sigmatau5, t8679, t8693, t8704, t8718, t8726, t8728, tv4rho2sigmatau6;
  double tv4rho2sigmatau7, tv4rho2sigmatau8, tv4rho2sigmatau9, tv4rho2sigmatau10, t8730, t8734, t8742, t8744;
  double t8746, t8759, t8763, t8767, t8769, t8773, t8777, t8781;
  double t8783, t8796, t8800, t8803, t8805, tv4rho2sigmatau11, t8820, tv4rho2sigmatau12;
  double tv4rho2sigmatau13, tv4rho2sigmatau14, tv4rho2sigmatau15, tv4rho2sigmatau16, t8838, t8842, t8859, t8866;
  double t8895, t8907, t8921, t8924, t8935, t8936, t8962, t8978;
  double t9007, t9026, t9046, t9049, t9063, t9083, t9101, t9102;
  double t9109, t9148, t9157, t9183, t9186, tv4rho2sigmatau17, tv4rho2lapl20, tv4rho2lapl21;
  double tv4rho2lapl22, tv4rho2lapl23, tv4rho2lapl24, tv4rho2lapl25, tv4rho2lapl26, tv4rho2lapl27, tv4rho2lapl28, tv4rho2lapltau0;
  double tv4rho2lapltau1, tv4rho2lapltau2, tv4rho2lapltau3, tv4rho2lapltau4, tv4rho2lapltau5, tv4rho2lapltau6, tv4rho2lapltau7, tv4rho2lapltau8;
  double tv4rho2lapltau9, tv4rho2lapltau10, tv4rho2lapltau11, t9189, t9191, t9195, t9203, t9208;
  double t9209, t9212, t9213, t9220, t9222, t9236, t9239, t9240;
  double t9247, t9249, t9252, t9273, t9276, t9280, t9283, t9288;
  double t9297, t9314, t9336, t9337, t9340, t9341, t9361, t9362;
  double t9386, t9391, t9402, t9407, t9417, t9422, t9430, t9432;
  double t9448, t9456, t9462, t9467, t9469, tv4rho2tau20, tv4rho2tau21, t9474;
  double t9479, t9482, t9485, t9487, tv4rho2tau22, t9491, t9506, t9510;
  double t9519, t9520, tv4rho2tau23, tv4rho2tau24, t9524, t9531, t9538, t9542;
  double t9546, t9551, t9553, t9558, t9559, t9563, t9565, t9566;
  double tv4rho2tau25, t9576, tv4rho2tau26, tv4rho2tau27, t9579, t9581, t9585, t9593;
  double t9594, t9600, t9608, t9616, t9627, t9635, t9655, t9660;
  double t9669, t9686, t9690, t9695, t9718, t9721, t9739, t9740;
  double t9743, t9753, t9757, t9774, t9775, t9784, t9790, t9827;
  double t9831, t9836, t9838, tv4rho2tau28, t9844, t9851, t9855, t9858;
  double t9867, t9878, t9881, t9926, t9952, t9957, t9961, t9991;
  double t9996, t10003, t10017, t10025, t10026, tv4rhosigma30, tv4rhosigma31, tv4rhosigma32;
  double tv4rhosigma33, tv4rhosigma34, tv4rhosigma35, tv4rhosigma36, tv4rhosigma37, tv4rhosigma38, t10032, t10036;
  double t10041, t10043, tv4rhosigma39, t10052, tv4rhosigma310, tv4rhosigma311, tv4rhosigma312, tv4rhosigma313;
  double tv4rhosigma314, tv4rhosigma315, tv4rhosigma316, tv4rhosigma317, tv4rhosigma318, t10060, t10098, t10102;
  double t10105, t10114, t10125, t10128, t10135, t10168, t10172, t10202;
  double t10207, t10231, t10232, tv4rhosigma319, tv4rhosigma2lapl0, tv4rhosigma2lapl1, tv4rhosigma2lapl2, tv4rhosigma2lapl3;
  double tv4rhosigma2lapl4, tv4rhosigma2lapl5, tv4rhosigma2lapl6, tv4rhosigma2lapl7, tv4rhosigma2lapl8, tv4rhosigma2lapl9, tv4rhosigma2lapl10, tv4rhosigma2lapl11;
  double tv4rhosigma2lapl12, tv4rhosigma2lapl13, tv4rhosigma2lapl14, tv4rhosigma2lapl15, tv4rhosigma2lapl16, tv4rhosigma2lapl17, tv4rhosigma2lapl18, tv4rhosigma2lapl19;
  double tv4rhosigma2lapl20, tv4rhosigma2lapl21, tv4rhosigma2lapl22, tv4rhosigma2lapl23, t10237, t10239, t10241, t10243;
  double t10261, t10278, t10282, t10313, t10321, t10328, t10341, t10357;
  double t10395, t10412, t10416, t10420, t10424, t10427, t10432, t10433;
  double t10438, t10449, t10464, t10478, t10517, t10536, t10540, t10544;
  double t10547, tv4rhosigma2tau0, tv4rhosigma2tau1, tv4rhosigma2tau2, tv4rhosigma2tau3, tv4rhosigma2tau4, tv4rhosigma2tau5, tv4rhosigma2tau6;
  double tv4rhosigma2tau7, tv4rhosigma2tau8, tv4rhosigma2tau9, tv4rhosigma2tau10, t10554, t10562, t10566, t10570;
  double t10574, t10578, t10582, t10583, t10584, tv4rhosigma2tau11, t10602, t10603;
  double tv4rhosigma2tau12, tv4rhosigma2tau13, tv4rhosigma2tau14, tv4rhosigma2tau15, tv4rhosigma2tau16, tv4rhosigma2tau17, tv4rhosigma2tau18, tv4rhosigma2tau19;
  double tv4rhosigma2tau20, tv4rhosigma2tau21, tv4rhosigma2tau22, t10624, t10639, t10643, t10659, t10734;
  double t10751, t10755, t10759, t10763, t10766, t10771, t10772, t10787;
  double t10814, t10822, t10827, t10830, t10843, t10855, t10888, t10897;
  double t10900, tv4rhosigma2tau23, tv4rhosigmalapl20, tv4rhosigmalapl21, tv4rhosigmalapl22, tv4rhosigmalapl23, tv4rhosigmalapl24, tv4rhosigmalapl25;
  double tv4rhosigmalapl26, tv4rhosigmalapl27, tv4rhosigmalapl28, tv4rhosigmalapl29, tv4rhosigmalapl210, tv4rhosigmalapl211, tv4rhosigmalapl212, tv4rhosigmalapl213;
  double tv4rhosigmalapl214, tv4rhosigmalapl215, tv4rhosigmalapl216, tv4rhosigmalapl217, tv4rhosigmalapltau0, tv4rhosigmalapltau1, tv4rhosigmalapltau2, tv4rhosigmalapltau3;
  double tv4rhosigmalapltau4, tv4rhosigmalapltau5, tv4rhosigmalapltau6, tv4rhosigmalapltau7, tv4rhosigmalapltau8, tv4rhosigmalapltau9, tv4rhosigmalapltau10, tv4rhosigmalapltau11;
  double tv4rhosigmalapltau12, tv4rhosigmalapltau13, tv4rhosigmalapltau14, tv4rhosigmalapltau15, tv4rhosigmalapltau16, tv4rhosigmalapltau17, tv4rhosigmalapltau18, tv4rhosigmalapltau19;
  double tv4rhosigmalapltau20, tv4rhosigmalapltau21, tv4rhosigmalapltau22, tv4rhosigmalapltau23, t10902, t10919, t10948, t10950;
  double t10957, t10982, t11002, t11033, t11034, t11074, t11081, t11088;
  double t11101, t11114, t11122, t11129, t11132, t11159, t11173, t11185;
  double t11190, t11191, t11193, tv4rhosigmatau20, tv4rhosigmatau21, tv4rhosigmatau22, tv4rhosigmatau23, tv4rhosigmatau24;
  double tv4rhosigmatau25, tv4rhosigmatau26, tv4rhosigmatau27, t11200, t11208, t11212, t11216, t11220;
  double t11224, t11225, t11226, tv4rhosigmatau28, t11242, t11243, tv4rhosigmatau29, tv4rhosigmatau210;
  double tv4rhosigmatau211, tv4rhosigmatau212, tv4rhosigmatau213, tv4rhosigmatau214, tv4rhosigmatau215, tv4rhosigmatau216, t11261, t11300;
  double t11303, t11314, t11326, t11329, t11335, t11359, t11399, t11416;
  double t11447, t11448, t11465, t11474, t11514, t11518, t11520, tv4rhosigmatau217;
  double tv4rholapl30, tv4rholapl31, tv4rholapl32, tv4rholapl33, tv4rholapl34, tv4rholapl35, tv4rholapl36, tv4rholapl37;
  double tv4rholapl2tau0, tv4rholapl2tau1, tv4rholapl2tau2, tv4rholapl2tau3, tv4rholapl2tau4, tv4rholapl2tau5, tv4rholapl2tau6, tv4rholapl2tau7;
  double tv4rholapl2tau8, tv4rholapl2tau9, tv4rholapl2tau10, tv4rholapl2tau11, tv4rholapltau20, tv4rholapltau21, tv4rholapltau22, tv4rholapltau23;
  double tv4rholapltau24, tv4rholapltau25, tv4rholapltau26, tv4rholapltau27, tv4rholapltau28, tv4rholapltau29, tv4rholapltau210, tv4rholapltau211;
  double t11527, t11536, t11553, t11584, t11593, t11610, t11625, t11632;
  double t11635, t11641, t11644, t11654, t11661, t11666, t11680, t11681;
  double t11690, t11691, t11700, t11701, tv4rhotau30, tv4rhotau31, tv4rhotau32, t11708;
  double t11712, t11716, t11718, tv4rhotau33, t11727, tv4rhotau34, tv4rhotau35, tv4rhotau36;
  double t11739, t11756, t11786, t11798, t11815, t11824, t11833, t11838;
  double t11842, t11847, t11857, t11867, t11880, t11889, t11890, t11899;
  double t11900, tv4rhotau37, t11918, t11924, t11927, t11933, t11934, t11936;
  double t11939, t11943, t11958, t11964, t11967, t11990, t11998, t12004;
  double tv4sigma40, tv4sigma41, tv4sigma42, tv4sigma43, tv4sigma44, tv4sigma45, tv4sigma46, tv4sigma47;
  double tv4sigma48, tv4sigma49, tv4sigma410, tv4sigma411, tv4sigma412, tv4sigma413, t12021, t12027;
  double t12030, t12036, t12038, t12043, t12058, t12064, t12067, t12090;
  double t12098, t12104, tv4sigma414, tv4sigma3lapl0, tv4sigma3lapl1, tv4sigma3lapl2, tv4sigma3lapl3, tv4sigma3lapl4;
  double tv4sigma3lapl5, tv4sigma3lapl6, tv4sigma3lapl7, tv4sigma3lapl8, tv4sigma3lapl9, tv4sigma3lapl10, tv4sigma3lapl11, tv4sigma3lapl12;
  double tv4sigma3lapl13, tv4sigma3lapl14, tv4sigma3lapl15, tv4sigma3lapl16, tv4sigma3lapl17, tv4sigma3lapl18, tv4sigma3lapl19, t12176;
  double t12187, t12193, t12197, t12206, t12229, t12244, t12245, tv4sigma3tau0;
  double tv4sigma3tau1, tv4sigma3tau2, tv4sigma3tau3, tv4sigma3tau4, tv4sigma3tau5, tv4sigma3tau6, tv4sigma3tau7, tv4sigma3tau8;
  double tv4sigma3tau9, tv4sigma3tau10, tv4sigma3tau11, tv4sigma3tau12, tv4sigma3tau13, tv4sigma3tau14, tv4sigma3tau15, tv4sigma3tau16;
  double tv4sigma3tau17, tv4sigma3tau18, t12304, t12319, t12325, t12329, t12338, t12370;
  double t12385, t12386, tv4sigma3tau19, tv4sigma2lapl20, tv4sigma2lapl21, tv4sigma2lapl22, tv4sigma2lapl23, tv4sigma2lapl24;
  double tv4sigma2lapl25, tv4sigma2lapl26, tv4sigma2lapl27, tv4sigma2lapl28, tv4sigma2lapl29, tv4sigma2lapl210, tv4sigma2lapl211, tv4sigma2lapl212;
  double tv4sigma2lapl213, tv4sigma2lapl214, tv4sigma2lapl215, tv4sigma2lapl216, tv4sigma2lapl217, tv4sigma2lapltau0, tv4sigma2lapltau1, tv4sigma2lapltau2;
  double tv4sigma2lapltau3, tv4sigma2lapltau4, tv4sigma2lapltau5, tv4sigma2lapltau6, tv4sigma2lapltau7, tv4sigma2lapltau8, tv4sigma2lapltau9, tv4sigma2lapltau10;
  double tv4sigma2lapltau11, tv4sigma2lapltau12, tv4sigma2lapltau13, tv4sigma2lapltau14, tv4sigma2lapltau15, tv4sigma2lapltau16, tv4sigma2lapltau17, tv4sigma2lapltau18;
  double tv4sigma2lapltau19, tv4sigma2lapltau20, tv4sigma2lapltau21, tv4sigma2lapltau22, tv4sigma2lapltau23, t12423, t12424, t12448;
  double t12460, t12500, t12523, t12555, t12556, tv4sigma2tau20, tv4sigma2tau21, tv4sigma2tau22;
  double tv4sigma2tau23, tv4sigma2tau24, tv4sigma2tau25, tv4sigma2tau26, tv4sigma2tau27, tv4sigma2tau28, tv4sigma2tau29, tv4sigma2tau210;
  double tv4sigma2tau211, tv4sigma2tau212, tv4sigma2tau213, tv4sigma2tau214, tv4sigma2tau215, tv4sigma2tau216, t12557, t12572;
  double t12584, t12631, t12670, t12693, t12725, t12726, tv4sigma2tau217, tv4sigmalapl30;
  double tv4sigmalapl31, tv4sigmalapl32, tv4sigmalapl33, tv4sigmalapl34, tv4sigmalapl35, tv4sigmalapl36, tv4sigmalapl37, tv4sigmalapl38;
  double tv4sigmalapl39, tv4sigmalapl310, tv4sigmalapl311, tv4sigmalapl2tau0, tv4sigmalapl2tau1, tv4sigmalapl2tau2, tv4sigmalapl2tau3, tv4sigmalapl2tau4;
  double tv4sigmalapl2tau5, tv4sigmalapl2tau6, tv4sigmalapl2tau7, tv4sigmalapl2tau8, tv4sigmalapl2tau9, tv4sigmalapl2tau10, tv4sigmalapl2tau11, tv4sigmalapl2tau12;
  double tv4sigmalapl2tau13, tv4sigmalapl2tau14, tv4sigmalapl2tau15, tv4sigmalapl2tau16, tv4sigmalapl2tau17, tv4sigmalapltau20, tv4sigmalapltau21, tv4sigmalapltau22;
  double tv4sigmalapltau23, tv4sigmalapltau24, tv4sigmalapltau25, tv4sigmalapltau26, tv4sigmalapltau27, tv4sigmalapltau28, tv4sigmalapltau29, tv4sigmalapltau210;
  double tv4sigmalapltau211, tv4sigmalapltau212, tv4sigmalapltau213, tv4sigmalapltau214, tv4sigmalapltau215, tv4sigmalapltau216, tv4sigmalapltau217, t12748;
  double t12775, t12825, t12866, tv4sigmatau30, tv4sigmatau31, tv4sigmatau32, tv4sigmatau33, tv4sigmatau34;
  double tv4sigmatau35, tv4sigmatau36, tv4sigmatau37, tv4sigmatau38, tv4sigmatau39, tv4sigmatau310, t12900, t12934;
  double t12965, t13006, tv4sigmatau311, tv4lapl40, tv4lapl41, tv4lapl42, tv4lapl43, tv4lapl44;
  double tv4lapl3tau0, tv4lapl3tau1, tv4lapl3tau2, tv4lapl3tau3, tv4lapl3tau4, tv4lapl3tau5, tv4lapl3tau6, tv4lapl3tau7;
  double tv4lapl2tau20, tv4lapl2tau21, tv4lapl2tau22, tv4lapl2tau23, tv4lapl2tau24, tv4lapl2tau25, tv4lapl2tau26, tv4lapl2tau27;
  double tv4lapl2tau28, tv4lapltau30, tv4lapltau31, tv4lapltau32, tv4lapltau33, tv4lapltau34, tv4lapltau35, tv4lapltau36;
  double tv4lapltau37, t13007, t13045, t13053, t13062, t13082, t13091, t13102;
  double t13103, t13107, t13113, tv4tau40, tv4tau41, tv4tau42, tv4tau43, t13114;
  double t13152, t13160, t13169, t13189, t13198, t13209, t13210, t13218;
  double tv4tau44;

  mgga_x_rtpss_params *params;

  assert(p->params != NULL);
  params = (mgga_x_rtpss_params * ) (p->params);

  t2 = rho[0] <= p->dens_threshold;
  t3 = M_CBRT3;
  t4 = M_CBRTPI;
  t6 = t3 / t4;
  t7 = rho[0] + rho[1];
  t8 = 0.1e1 / t7;
  t11 = 0.2e1 * rho[0] * t8 <= p->zeta_threshold;
  t12 = p->zeta_threshold - 0.1e1;
  t15 = 0.2e1 * rho[1] * t8 <= p->zeta_threshold;
  t16 = -t12;
  t17 = rho[0] - rho[1];
  t19 = my_piecewise5(t11, t12, t15, t16, t17 * t8);
  t20 = 0.1e1 + t19;
  t21 = t20 <= p->zeta_threshold;
  t22 = POW_1_3(p->zeta_threshold);
  t23 = t22 * p->zeta_threshold;
  t24 = POW_1_3(t20);
  t26 = my_piecewise3(t21, t23, t24 * t20);
  t27 = POW_1_3(t7);
  t28 = t26 * t27;
  t29 = sigma[0] * sigma[0];
  t30 = params->c * t29;
  t31 = rho[0] * rho[0];
  t32 = 0.1e1 / t31;
  t33 = tau[0] * tau[0];
  t34 = 0.1e1 / t33;
  t35 = t32 * t34;
  t36 = t29 * t32;
  t37 = t36 * t34;
  t39 = 0.1e1 + t37 / 0.64e2;
  t40 = t39 * t39;
  t41 = 0.1e1 / t40;
  t42 = t35 * t41;
  t46 = M_CBRT6;
  t47 = (0.1e2 / 0.81e2 + t30 * t42 / 0.64e2) * t46;
  t48 = M_PI * M_PI;
  t49 = POW_1_3(t48);
  t50 = t49 * t49;
  t51 = 0.1e1 / t50;
  t52 = t51 * sigma[0];
  t53 = POW_1_3(rho[0]);
  t54 = t53 * t53;
  t56 = 0.1e1 / t54 / t31;
  t57 = t52 * t56;
  t61 = 0.1e1 / t54 / rho[0];
  t63 = sigma[0] * t56;
  t65 = tau[0] * t61 - t63 / 0.8e1;
  t69 = 0.5e1 / 0.9e1 * t65 * t46 * t51 - 0.1e1;
  t70 = params->b * t65;
  t71 = t46 * t51;
  t72 = t71 * t69;
  t75 = 0.5e1 * t70 * t72 + 0.9e1;
  t76 = sqrt(t75);
  t77 = 0.1e1 / t76;
  t82 = 0.27e2 / 0.2e2 * t69 * t77 + t71 * t63 / 0.36e2;
  t83 = t82 * t82;
  t86 = t46 * t46;
  t88 = 0.1e1 / t49 / t48;
  t89 = t86 * t88;
  t90 = t31 * t31;
  t91 = t90 * rho[0];
  t93 = 0.1e1 / t53 / t91;
  t97 = 0.5e2 * t89 * t29 * t93 + 0.162e3 * t37;
  t98 = sqrt(t97);
  t101 = 0.1e1 / params->kappa;
  t102 = t101 * t86;
  t103 = t88 * t29;
  t107 = sqrt(params->e);
  t108 = t107 * t29;
  t111 = params->e * params->mu;
  t112 = t48 * t48;
  t113 = 0.1e1 / t112;
  t114 = t29 * sigma[0];
  t115 = t113 * t114;
  t116 = t90 * t90;
  t117 = 0.1e1 / t116;
  t121 = t47 * t57 / 0.24e2 + 0.146e3 / 0.2025e4 * t83 - 0.73e2 / 0.972e5 * t82 * t98 + 0.25e2 / 0.944784e6 * t102 * t103 * t93 + t108 * t35 / 0.72e3 + t111 * t115 * t117 / 0.2304e4;
  t122 = t107 * t46;
  t125 = 0.1e1 + t122 * t57 / 0.24e2;
  t126 = t125 * t125;
  t127 = 0.1e1 / t126;
  t130 = exp(-t121 * t127 * t101);
  t133 = 0.1e1 + params->kappa * (0.1e1 - t130);
  t137 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t28 * t133);
  t138 = rho[1] <= p->dens_threshold;
  t139 = -t17;
  t141 = my_piecewise5(t15, t12, t11, t16, t139 * t8);
  t142 = 0.1e1 + t141;
  t143 = t142 <= p->zeta_threshold;
  t144 = POW_1_3(t142);
  t146 = my_piecewise3(t143, t23, t144 * t142);
  t147 = t146 * t27;
  t148 = sigma[2] * sigma[2];
  t149 = params->c * t148;
  t150 = rho[1] * rho[1];
  t151 = 0.1e1 / t150;
  t152 = tau[1] * tau[1];
  t153 = 0.1e1 / t152;
  t154 = t151 * t153;
  t155 = t148 * t151;
  t156 = t155 * t153;
  t158 = 0.1e1 + t156 / 0.64e2;
  t159 = t158 * t158;
  t160 = 0.1e1 / t159;
  t161 = t154 * t160;
  t165 = (0.1e2 / 0.81e2 + t149 * t161 / 0.64e2) * t46;
  t166 = t51 * sigma[2];
  t167 = POW_1_3(rho[1]);
  t168 = t167 * t167;
  t170 = 0.1e1 / t168 / t150;
  t171 = t166 * t170;
  t175 = 0.1e1 / t168 / rho[1];
  t177 = sigma[2] * t170;
  t179 = tau[1] * t175 - t177 / 0.8e1;
  t183 = 0.5e1 / 0.9e1 * t179 * t46 * t51 - 0.1e1;
  t184 = params->b * t179;
  t185 = t71 * t183;
  t188 = 0.5e1 * t184 * t185 + 0.9e1;
  t189 = sqrt(t188);
  t190 = 0.1e1 / t189;
  t195 = 0.27e2 / 0.2e2 * t183 * t190 + t71 * t177 / 0.36e2;
  t196 = t195 * t195;
  t199 = t150 * t150;
  t200 = t199 * rho[1];
  t202 = 0.1e1 / t167 / t200;
  t206 = 0.5e2 * t89 * t148 * t202 + 0.162e3 * t156;
  t207 = sqrt(t206);
  t210 = t88 * t148;
  t214 = t107 * t148;
  t217 = t148 * sigma[2];
  t218 = t113 * t217;
  t219 = t199 * t199;
  t220 = 0.1e1 / t219;
  t224 = t165 * t171 / 0.24e2 + 0.146e3 / 0.2025e4 * t196 - 0.73e2 / 0.972e5 * t195 * t207 + 0.25e2 / 0.944784e6 * t102 * t210 * t202 + t214 * t154 / 0.72e3 + t111 * t218 * t220 / 0.2304e4;
  t227 = 0.1e1 + t122 * t171 / 0.24e2;
  t228 = t227 * t227;
  t229 = 0.1e1 / t228;
  t232 = exp(-t224 * t229 * t101);
  t235 = 0.1e1 + params->kappa * (0.1e1 - t232);
  t239 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t147 * t235);
  tzk0 = t137 + t239;

  if(out->zk != NULL && (p->info->flags & XC_FLAGS_HAVE_EXC))
    out->zk[ip*p->dim.zk + 0] += tzk0;

  t240 = t7 * t7;
  t241 = 0.1e1 / t240;
  t242 = t17 * t241;
  t244 = my_piecewise5(t11, 0, t15, 0, t8 - t242);
  t247 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t244);
  t248 = t247 * t27;
  t252 = t27 * t27;
  t253 = 0.1e1 / t252;
  t254 = t26 * t253;
  t257 = t6 * t254 * t133 / 0.8e1;
  t258 = t6 * t26;
  t259 = t27 * params->kappa;
  t260 = t31 * rho[0];
  t261 = 0.1e1 / t260;
  t262 = t261 * t34;
  t263 = t262 * t41;
  t266 = t29 * t29;
  t267 = params->c * t266;
  t268 = 0.1e1 / t91;
  t269 = t33 * t33;
  t270 = 0.1e1 / t269;
  t273 = 0.1e1 / t40 / t39;
  t274 = t268 * t270 * t273;
  t278 = (-t30 * t263 / 0.32e2 + t267 * t274 / 0.1024e4) * t46;
  t282 = 0.1e1 / t54 / t260;
  t283 = t52 * t282;
  t288 = sigma[0] * t282;
  t290 = -0.5e1 / 0.3e1 * tau[0] * t56 + t288 / 0.3e1;
  t291 = t290 * t46;
  t292 = t51 * t77;
  t296 = 0.1e1 / t76 / t75;
  t297 = t69 * t296;
  t301 = t89 * t290;
  t304 = 0.5e1 * params->b * t290 * t72 + 0.25e2 / 0.9e1 * t70 * t301;
  t307 = t71 * t288;
  t309 = 0.3e1 / 0.4e1 * t291 * t292 - 0.27e2 / 0.4e2 * t297 * t304 - 0.2e1 / 0.27e2 * t307;
  t314 = 0.1e1 / t98;
  t315 = t82 * t314;
  t316 = t29 * t261;
  t319 = t90 * t31;
  t321 = 0.1e1 / t53 / t319;
  t325 = -0.324e3 * t316 * t34 - 0.8e3 / 0.3e1 * t89 * t29 * t321;
  t333 = t116 * rho[0];
  t334 = 0.1e1 / t333;
  t338 = t278 * t57 / 0.24e2 - t47 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t82 * t309 - 0.73e2 / 0.972e5 * t309 * t98 - 0.73e2 / 0.1944e6 * t315 * t325 - 0.25e2 / 0.177147e6 * t102 * t103 * t321 - t108 * t262 / 0.36e3 - t111 * t115 * t334 / 0.288e3;
  t341 = t126 * t125;
  t342 = 0.1e1 / t341;
  t343 = t121 * t342;
  t344 = t101 * t107;
  t345 = t343 * t344;
  t348 = -t338 * t127 * t101 - 0.2e1 / 0.9e1 * t345 * t307;
  t349 = t348 * t130;
  t350 = t259 * t349;
  t354 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t248 * t133 - t257 + 0.3e1 / 0.8e1 * t258 * t350);
  t355 = t139 * t241;
  t357 = my_piecewise5(t15, 0, t11, 0, -t8 - t355);
  t360 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t357);
  t361 = t360 * t27;
  t365 = t146 * t253;
  t368 = t6 * t365 * t235 / 0.8e1;
  t370 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t361 * t235 - t368);
  tvrho0 = t137 + t239 + t7 * (t354 + t370);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 0] += tvrho0;

  t374 = my_piecewise5(t11, 0, t15, 0, -t8 - t242);
  t377 = my_piecewise3(t21, 0, 0.4e1 / 0.3e1 * t24 * t374);
  t378 = t377 * t27;
  t383 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t378 * t133 - t257);
  t385 = my_piecewise5(t15, 0, t11, 0, t8 - t355);
  t388 = my_piecewise3(t143, 0, 0.4e1 / 0.3e1 * t144 * t385);
  t389 = t388 * t27;
  t393 = t6 * t146;
  t394 = t150 * rho[1];
  t395 = 0.1e1 / t394;
  t396 = t395 * t153;
  t397 = t396 * t160;
  t400 = t148 * t148;
  t401 = params->c * t400;
  t402 = 0.1e1 / t200;
  t403 = t152 * t152;
  t404 = 0.1e1 / t403;
  t407 = 0.1e1 / t159 / t158;
  t408 = t402 * t404 * t407;
  t412 = (-t149 * t397 / 0.32e2 + t401 * t408 / 0.1024e4) * t46;
  t416 = 0.1e1 / t168 / t394;
  t417 = t166 * t416;
  t422 = sigma[2] * t416;
  t424 = -0.5e1 / 0.3e1 * tau[1] * t170 + t422 / 0.3e1;
  t425 = t424 * t46;
  t426 = t51 * t190;
  t430 = 0.1e1 / t189 / t188;
  t431 = t183 * t430;
  t435 = t89 * t424;
  t438 = 0.5e1 * params->b * t424 * t185 + 0.25e2 / 0.9e1 * t184 * t435;
  t441 = t71 * t422;
  t443 = 0.3e1 / 0.4e1 * t425 * t426 - 0.27e2 / 0.4e2 * t431 * t438 - 0.2e1 / 0.27e2 * t441;
  t448 = 0.1e1 / t207;
  t449 = t195 * t448;
  t450 = t148 * t395;
  t453 = t199 * t150;
  t455 = 0.1e1 / t167 / t453;
  t459 = -0.324e3 * t450 * t153 - 0.8e3 / 0.3e1 * t89 * t148 * t455;
  t467 = t219 * rho[1];
  t468 = 0.1e1 / t467;
  t472 = t412 * t171 / 0.24e2 - t165 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t195 * t443 - 0.73e2 / 0.972e5 * t443 * t207 - 0.73e2 / 0.1944e6 * t449 * t459 - 0.25e2 / 0.177147e6 * t102 * t210 * t455 - t214 * t396 / 0.36e3 - t111 * t218 * t468 / 0.288e3;
  t475 = t228 * t227;
  t476 = 0.1e1 / t475;
  t477 = t224 * t476;
  t478 = t477 * t344;
  t481 = -t472 * t229 * t101 - 0.2e1 / 0.9e1 * t478 * t441;
  t482 = t481 * t232;
  t483 = t259 * t482;
  t487 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t389 * t235 - t368 + 0.3e1 / 0.8e1 * t393 * t483);
  tvrho1 = t137 + t239 + t7 * (t383 + t487);

  if(out->vrho != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vrho[ip*p->dim.vrho + 1] += tvrho1;

  t490 = params->c * sigma[0];
  t493 = params->c * t114;
  t494 = 0.1e1 / t90;
  t495 = t494 * t270;
  t496 = t495 * t273;
  t500 = (t490 * t42 / 0.32e2 - t493 * t496 / 0.1024e4) * t46;
  t503 = t51 * t56;
  t506 = t56 * t46;
  t507 = t506 * t292;
  t509 = params->b * t56;
  t510 = t509 * t72;
  t513 = t70 * t89 * t56;
  t515 = -0.5e1 / 0.8e1 * t510 - 0.25e2 / 0.72e2 * t513;
  t518 = t506 * t51;
  t520 = -0.3e1 / 0.32e2 * t507 - 0.27e2 / 0.4e2 * t297 * t515 + t518 / 0.36e2;
  t525 = sigma[0] * t32;
  t531 = 0.1e3 * t89 * sigma[0] * t93 + 0.324e3 * t525 * t34;
  t534 = t88 * sigma[0];
  t538 = t107 * sigma[0];
  t541 = t113 * t29;
  t545 = t500 * t57 / 0.24e2 + t47 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t520 - 0.73e2 / 0.972e5 * t520 * t98 - 0.73e2 / 0.1944e6 * t315 * t531 + 0.25e2 / 0.472392e6 * t102 * t534 * t93 + t538 * t35 / 0.36e3 + t111 * t541 * t117 / 0.768e3;
  t548 = t343 * t101;
  t549 = t122 * t503;
  t552 = -t545 * t127 * t101 + t548 * t549 / 0.12e2;
  t553 = t552 * t130;
  t554 = t259 * t553;
  t557 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t554);
  tvsigma0 = t7 * t557;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 0] += tvsigma0;

  tvsigma1 = 0.e0;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 1] += tvsigma1;

  t558 = params->c * sigma[2];
  t561 = params->c * t217;
  t562 = 0.1e1 / t199;
  t563 = t562 * t404;
  t564 = t563 * t407;
  t568 = (t558 * t161 / 0.32e2 - t561 * t564 / 0.1024e4) * t46;
  t571 = t51 * t170;
  t574 = t170 * t46;
  t575 = t574 * t426;
  t577 = params->b * t170;
  t578 = t577 * t185;
  t581 = t184 * t89 * t170;
  t583 = -0.5e1 / 0.8e1 * t578 - 0.25e2 / 0.72e2 * t581;
  t586 = t574 * t51;
  t588 = -0.3e1 / 0.32e2 * t575 - 0.27e2 / 0.4e2 * t431 * t583 + t586 / 0.36e2;
  t593 = sigma[2] * t151;
  t599 = 0.1e3 * t89 * sigma[2] * t202 + 0.324e3 * t593 * t153;
  t602 = t88 * sigma[2];
  t606 = t107 * sigma[2];
  t609 = t113 * t148;
  t613 = t568 * t171 / 0.24e2 + t165 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t588 - 0.73e2 / 0.972e5 * t588 * t207 - 0.73e2 / 0.1944e6 * t449 * t599 + 0.25e2 / 0.472392e6 * t102 * t602 * t202 + t606 * t154 / 0.36e3 + t111 * t609 * t220 / 0.768e3;
  t616 = t477 * t101;
  t617 = t122 * t571;
  t620 = -t613 * t229 * t101 + t616 * t617 / 0.12e2;
  t621 = t620 * t232;
  t622 = t259 * t621;
  t625 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t622);
  tvsigma2 = t7 * t625;

  if(out->vsigma != NULL && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vsigma[ip*p->dim.vsigma + 2] += tvsigma2;

  tvlapl0 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 0] += tvlapl0;

  tvlapl1 = 0.e0;

  if(out->vlapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vlapl[ip*p->dim.vlapl + 1] += tvlapl1;

  t626 = t33 * tau[0];
  t627 = 0.1e1 / t626;
  t628 = t32 * t627;
  t629 = t628 * t41;
  t632 = t269 * tau[0];
  t633 = 0.1e1 / t632;
  t635 = t494 * t633 * t273;
  t639 = (-t30 * t629 / 0.32e2 + t267 * t635 / 0.1024e4) * t46;
  t642 = t61 * t46;
  t645 = params->b * t61;
  t651 = 0.5e1 * t645 * t72 + 0.25e2 / 0.9e1 * t70 * t89 * t61;
  t654 = 0.3e1 / 0.4e1 * t642 * t292 - 0.27e2 / 0.4e2 * t297 * t651;
  t659 = t36 * t627;
  t664 = t639 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t82 * t654 - 0.73e2 / 0.972e5 * t654 * t98 + 0.73e2 / 0.6e3 * t315 * t659 - t108 * t628 / 0.36e3;
  t665 = t27 * t664;
  t666 = t127 * t130;
  t667 = t665 * t666;
  t670 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t667);
  tvtau0 = t7 * t670;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 0] += tvtau0;

  t671 = t152 * tau[1];
  t672 = 0.1e1 / t671;
  t673 = t151 * t672;
  t674 = t673 * t160;
  t677 = t403 * tau[1];
  t678 = 0.1e1 / t677;
  t680 = t562 * t678 * t407;
  t684 = (-t149 * t674 / 0.32e2 + t401 * t680 / 0.1024e4) * t46;
  t687 = t175 * t46;
  t690 = params->b * t175;
  t696 = 0.5e1 * t690 * t185 + 0.25e2 / 0.9e1 * t184 * t89 * t175;
  t699 = 0.3e1 / 0.4e1 * t687 * t426 - 0.27e2 / 0.4e2 * t431 * t696;
  t704 = t155 * t672;
  t709 = t684 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t195 * t699 - 0.73e2 / 0.972e5 * t699 * t207 + 0.73e2 / 0.6e3 * t449 * t704 - t214 * t673 / 0.36e3;
  t710 = t27 * t709;
  t711 = t229 * t232;
  t712 = t710 * t711;
  t715 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t712);
  tvtau1 = t7 * t715;

  if(out->vtau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_VXC))
    out->vtau[ip*p->dim.vtau + 1] += tvtau1;

  t718 = t24 * t24;
  t719 = 0.1e1 / t718;
  t720 = t244 * t244;
  t723 = t240 * t7;
  t724 = 0.1e1 / t723;
  t725 = t17 * t724;
  t728 = my_piecewise5(t11, 0, t15, 0, -0.2e1 * t241 + 0.2e1 * t725);
  t732 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t720 + 0.4e1 / 0.3e1 * t24 * t728);
  t733 = t732 * t27;
  t737 = t247 * t253;
  t739 = t6 * t737 * t133;
  t741 = t6 * t247;
  t745 = 0.1e1 / t252 / t7;
  t746 = t26 * t745;
  t749 = t6 * t746 * t133 / 0.12e2;
  t750 = t253 * params->kappa;
  t751 = t750 * t349;
  t752 = t258 * t751;
  t754 = t494 * t34;
  t755 = t754 * t41;
  t758 = 0.1e1 / t319;
  t760 = t758 * t270 * t273;
  t763 = t266 * t29;
  t764 = params->c * t763;
  t765 = t269 * t33;
  t766 = 0.1e1 / t765;
  t768 = t40 * t40;
  t769 = 0.1e1 / t768;
  t770 = t117 * t766 * t769;
  t774 = (0.3e1 / 0.32e2 * t30 * t755 - 0.7e1 / 0.1024e4 * t267 * t760 + 0.3e1 / 0.32768e5 * t764 * t770) * t46;
  t780 = 0.1e1 / t54 / t90;
  t781 = t52 * t780;
  t784 = t309 * t309;
  t788 = sigma[0] * t780;
  t790 = 0.4e2 / 0.9e1 * tau[0] * t282 - 0.11e2 / 0.9e1 * t788;
  t791 = t790 * t46;
  t794 = t51 * t296;
  t795 = t794 * t304;
  t798 = t75 * t75;
  t800 = 0.1e1 / t76 / t798;
  t801 = t69 * t800;
  t802 = t304 * t304;
  t805 = params->b * t790;
  t808 = t290 * t290;
  t812 = t89 * t790;
  t815 = 0.5e1 * t805 * t72 + 0.5e2 / 0.9e1 * params->b * t808 * t89 + 0.25e2 / 0.9e1 * t70 * t812;
  t818 = t71 * t788;
  t820 = 0.3e1 / 0.4e1 * t791 * t292 - 0.3e1 / 0.4e1 * t291 * t795 + 0.81e2 / 0.8e2 * t801 * t802 - 0.27e2 / 0.4e2 * t297 * t815 + 0.22e2 / 0.81e2 * t818;
  t825 = t309 * t314;
  t829 = 0.1e1 / t98 / t97;
  t830 = t82 * t829;
  t831 = t325 * t325;
  t834 = t29 * t494;
  t837 = t90 * t260;
  t839 = 0.1e1 / t53 / t837;
  t841 = t89 * t29 * t839;
  t843 = 0.972e3 * t834 * t34 + 0.152e5 / 0.9e1 * t841;
  t846 = t103 * t839;
  t851 = t116 * t31;
  t852 = 0.1e1 / t851;
  t856 = t774 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t278 * t283 + 0.11e2 / 0.27e2 * t47 * t781 + 0.292e3 / 0.2025e4 * t784 + 0.292e3 / 0.2025e4 * t82 * t820 - 0.73e2 / 0.972e5 * t820 * t98 - 0.73e2 / 0.972e5 * t825 * t325 + 0.73e2 / 0.3888e6 * t830 * t831 - 0.73e2 / 0.1944e6 * t315 * t843 + 0.475e3 / 0.531441e6 * t102 * t846 + t108 * t754 / 0.12e3 + t111 * t115 * t852 / 0.32e2;
  t859 = t338 * t342;
  t860 = t859 * t344;
  t863 = t126 * t126;
  t864 = 0.1e1 / t863;
  t865 = t121 * t864;
  t866 = t101 * params->e;
  t867 = t865 * t866;
  t872 = -t856 * t127 * t101 - 0.4e1 / 0.9e1 * t860 * t307 - 0.2e1 / 0.27e2 * t867 * t841 + 0.22e2 / 0.27e2 * t345 * t818;
  t873 = t872 * t130;
  t874 = t259 * t873;
  t877 = t348 * t348;
  t878 = t877 * t130;
  t879 = t259 * t878;
  t883 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t733 * t133 - t739 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t350 + t749 + t752 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t874 + 0.3e1 / 0.8e1 * t258 * t879);
  t884 = t144 * t144;
  t885 = 0.1e1 / t884;
  t886 = t357 * t357;
  t889 = t139 * t724;
  t892 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t241 + 0.2e1 * t889);
  t896 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t886 + 0.4e1 / 0.3e1 * t144 * t892);
  t897 = t896 * t27;
  t901 = t360 * t253;
  t903 = t6 * t901 * t235;
  t905 = t146 * t745;
  t908 = t6 * t905 * t235 / 0.12e2;
  t910 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t897 * t235 - t903 / 0.4e1 + t908);
  tv2rho20 = 0.2e1 * t354 + 0.2e1 * t370 + t7 * (t883 + t910);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 0] += tv2rho20;

  t913 = t719 * t374;
  t917 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t725);
  t921 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t913 * t244 + 0.4e1 / 0.3e1 * t24 * t917);
  t922 = t921 * t27;
  t926 = t377 * t253;
  t928 = t6 * t926 * t133;
  t930 = t6 * t377;
  t936 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t922 * t133 - t928 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t350 - t739 / 0.8e1 + t749 + t752 / 0.8e1);
  t937 = t885 * t385;
  t941 = my_piecewise5(t15, 0, t11, 0, 0.2e1 * t889);
  t945 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t937 * t357 + 0.4e1 / 0.3e1 * t144 * t941);
  t946 = t945 * t27;
  t950 = t388 * t253;
  t952 = t6 * t950 * t235;
  t955 = t6 * t360;
  t958 = t750 * t482;
  t959 = t393 * t958;
  t962 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t946 * t235 - t952 / 0.8e1 - t903 / 0.8e1 + t908 + 0.3e1 / 0.8e1 * t955 * t483 + t959 / 0.8e1);
  tv2rho21 = t354 + t370 + t383 + t487 + t7 * (t936 + t962);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 1] += tv2rho21;

  t967 = t374 * t374;
  t972 = my_piecewise5(t11, 0, t15, 0, 0.2e1 * t241 + 0.2e1 * t725);
  t976 = my_piecewise3(t21, 0, 0.4e1 / 0.9e1 * t719 * t967 + 0.4e1 / 0.3e1 * t24 * t972);
  t977 = t976 * t27;
  t983 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t977 * t133 - t928 / 0.4e1 + t749);
  t984 = t385 * t385;
  t989 = my_piecewise5(t15, 0, t11, 0, -0.2e1 * t241 + 0.2e1 * t889);
  t993 = my_piecewise3(t143, 0, 0.4e1 / 0.9e1 * t885 * t984 + 0.4e1 / 0.3e1 * t144 * t989);
  t994 = t993 * t27;
  t999 = t6 * t388;
  t1003 = t562 * t153;
  t1004 = t1003 * t160;
  t1007 = 0.1e1 / t453;
  t1009 = t1007 * t404 * t407;
  t1012 = t400 * t148;
  t1013 = params->c * t1012;
  t1014 = t403 * t152;
  t1015 = 0.1e1 / t1014;
  t1017 = t159 * t159;
  t1018 = 0.1e1 / t1017;
  t1019 = t220 * t1015 * t1018;
  t1023 = (0.3e1 / 0.32e2 * t149 * t1004 - 0.7e1 / 0.1024e4 * t401 * t1009 + 0.3e1 / 0.32768e5 * t1013 * t1019) * t46;
  t1029 = 0.1e1 / t168 / t199;
  t1030 = t166 * t1029;
  t1033 = t443 * t443;
  t1037 = sigma[2] * t1029;
  t1039 = 0.4e2 / 0.9e1 * tau[1] * t416 - 0.11e2 / 0.9e1 * t1037;
  t1040 = t1039 * t46;
  t1043 = t51 * t430;
  t1044 = t1043 * t438;
  t1047 = t188 * t188;
  t1049 = 0.1e1 / t189 / t1047;
  t1050 = t183 * t1049;
  t1051 = t438 * t438;
  t1054 = params->b * t1039;
  t1057 = t424 * t424;
  t1061 = t89 * t1039;
  t1064 = 0.5e1 * t1054 * t185 + 0.5e2 / 0.9e1 * params->b * t1057 * t89 + 0.25e2 / 0.9e1 * t184 * t1061;
  t1067 = t71 * t1037;
  t1069 = 0.3e1 / 0.4e1 * t1040 * t426 - 0.3e1 / 0.4e1 * t425 * t1044 + 0.81e2 / 0.8e2 * t1050 * t1051 - 0.27e2 / 0.4e2 * t431 * t1064 + 0.22e2 / 0.81e2 * t1067;
  t1074 = t443 * t448;
  t1078 = 0.1e1 / t207 / t206;
  t1079 = t195 * t1078;
  t1080 = t459 * t459;
  t1083 = t148 * t562;
  t1086 = t199 * t394;
  t1088 = 0.1e1 / t167 / t1086;
  t1090 = t89 * t148 * t1088;
  t1092 = 0.972e3 * t1083 * t153 + 0.152e5 / 0.9e1 * t1090;
  t1095 = t210 * t1088;
  t1100 = t219 * t150;
  t1101 = 0.1e1 / t1100;
  t1105 = t1023 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t412 * t417 + 0.11e2 / 0.27e2 * t165 * t1030 + 0.292e3 / 0.2025e4 * t1033 + 0.292e3 / 0.2025e4 * t195 * t1069 - 0.73e2 / 0.972e5 * t1069 * t207 - 0.73e2 / 0.972e5 * t1074 * t459 + 0.73e2 / 0.3888e6 * t1079 * t1080 - 0.73e2 / 0.1944e6 * t449 * t1092 + 0.475e3 / 0.531441e6 * t102 * t1095 + t214 * t1003 / 0.12e3 + t111 * t218 * t1101 / 0.32e2;
  t1108 = t472 * t476;
  t1109 = t1108 * t344;
  t1112 = t228 * t228;
  t1113 = 0.1e1 / t1112;
  t1114 = t224 * t1113;
  t1115 = t1114 * t866;
  t1120 = -t1105 * t229 * t101 - 0.4e1 / 0.9e1 * t1109 * t441 - 0.2e1 / 0.27e2 * t1115 * t1090 + 0.22e2 / 0.27e2 * t478 * t1067;
  t1121 = t1120 * t232;
  t1122 = t259 * t1121;
  t1125 = t481 * t481;
  t1126 = t1125 * t232;
  t1127 = t259 * t1126;
  t1131 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t994 * t235 - t952 / 0.4e1 + 0.3e1 / 0.4e1 * t999 * t483 + t908 + t959 / 0.4e1 + 0.3e1 / 0.8e1 * t393 * t1122 + 0.3e1 / 0.8e1 * t393 * t1127);
  tv2rho22 = 0.2e1 * t383 + 0.2e1 * t487 + t7 * (t983 + t1131);

  if(out->v2rho2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rho2[ip*p->dim.v2rho2 + 2] += tv2rho22;

  t1136 = t750 * t553;
  t1138 = t258 * t1136 / 0.8e1;
  t1143 = t266 * sigma[0];
  t1144 = params->c * t1143;
  t1145 = 0.1e1 / t837;
  t1147 = t1145 * t766 * t769;
  t1151 = (-t490 * t263 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t274 - 0.3e1 / 0.32768e5 * t1144 * t1147) * t46;
  t1158 = t51 * t282;
  t1163 = t282 * t46;
  t1164 = t1163 * t292;
  t1166 = t506 * t795;
  t1168 = t794 * t515;
  t1171 = t515 * t304;
  t1174 = params->b * t282;
  t1175 = t1174 * t72;
  t1177 = t509 * t301;
  t1180 = t70 * t89 * t282;
  t1182 = 0.5e1 / 0.3e1 * t1175 - 0.25e2 / 0.36e2 * t1177 + 0.25e2 / 0.27e2 * t1180;
  t1185 = t1163 * t51;
  t1187 = t1164 / 0.4e1 + 0.3e1 / 0.64e2 * t1166 - 0.3e1 / 0.8e1 * t291 * t1168 + 0.81e2 / 0.8e2 * t801 * t1171 - 0.27e2 / 0.4e2 * t297 * t1182 - 0.2e1 / 0.27e2 * t1185;
  t1192 = t520 * t314;
  t1197 = t531 * t325;
  t1200 = sigma[0] * t261;
  t1204 = t89 * sigma[0] * t321;
  t1206 = -0.648e3 * t1200 * t34 - 0.16e4 / 0.3e1 * t1204;
  t1209 = t534 * t321;
  t1217 = t1151 * t57 / 0.24e2 - t500 * t283 / 0.9e1 + t278 * t503 / 0.24e2 - t47 * t1158 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t520 + 0.292e3 / 0.2025e4 * t82 * t1187 - 0.73e2 / 0.972e5 * t1187 * t98 - 0.73e2 / 0.1944e6 * t1192 * t325 - 0.73e2 / 0.1944e6 * t825 * t531 + 0.73e2 / 0.3888e6 * t830 * t1197 - 0.73e2 / 0.1944e6 * t315 * t1206 - 0.5e2 / 0.177147e6 * t102 * t1209 - t538 * t262 / 0.18e3 - t111 * t541 * t334 / 0.96e2;
  t1220 = t545 * t342;
  t1221 = t1220 * t344;
  t1224 = t859 * t101;
  t1229 = t122 * t1158;
  t1232 = -t1217 * t127 * t101 - 0.2e1 / 0.9e1 * t1221 * t307 + t1224 * t549 / 0.12e2 + t867 * t1204 / 0.36e2 - 0.2e1 / 0.9e1 * t548 * t1229;
  t1233 = t1232 * t130;
  t1234 = t259 * t1233;
  t1237 = t6 * t28;
  t1238 = params->kappa * t552;
  t1239 = t1238 * t349;
  t1243 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t741 * t554 + t1138 + 0.3e1 / 0.8e1 * t258 * t1234 + 0.3e1 / 0.8e1 * t1237 * t1239);
  tv2rhosigma0 = t7 * t1243 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 0] += tv2rhosigma0;

  tv2rhosigma1 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 1] += tv2rhosigma1;

  t1247 = t750 * t621;
  t1249 = t393 * t1247 / 0.8e1;
  t1251 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t622 + t1249);
  tv2rhosigma2 = t7 * t1251 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 2] += tv2rhosigma2;

  t1256 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t554 + t1138);
  tv2rhosigma3 = t7 * t1256 + t557;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 3] += tv2rhosigma3;

  tv2rhosigma4 = 0.e0;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 4] += tv2rhosigma4;

  t1264 = t400 * sigma[2];
  t1265 = params->c * t1264;
  t1266 = 0.1e1 / t1086;
  t1268 = t1266 * t1015 * t1018;
  t1272 = (-t558 * t397 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t408 - 0.3e1 / 0.32768e5 * t1265 * t1268) * t46;
  t1279 = t51 * t416;
  t1284 = t416 * t46;
  t1285 = t1284 * t426;
  t1287 = t574 * t1044;
  t1289 = t1043 * t583;
  t1292 = t583 * t438;
  t1295 = params->b * t416;
  t1296 = t1295 * t185;
  t1298 = t577 * t435;
  t1301 = t184 * t89 * t416;
  t1303 = 0.5e1 / 0.3e1 * t1296 - 0.25e2 / 0.36e2 * t1298 + 0.25e2 / 0.27e2 * t1301;
  t1306 = t1284 * t51;
  t1308 = t1285 / 0.4e1 + 0.3e1 / 0.64e2 * t1287 - 0.3e1 / 0.8e1 * t425 * t1289 + 0.81e2 / 0.8e2 * t1050 * t1292 - 0.27e2 / 0.4e2 * t431 * t1303 - 0.2e1 / 0.27e2 * t1306;
  t1313 = t588 * t448;
  t1318 = t599 * t459;
  t1321 = sigma[2] * t395;
  t1325 = t89 * sigma[2] * t455;
  t1327 = -0.648e3 * t1321 * t153 - 0.16e4 / 0.3e1 * t1325;
  t1330 = t602 * t455;
  t1338 = t1272 * t171 / 0.24e2 - t568 * t417 / 0.9e1 + t412 * t571 / 0.24e2 - t165 * t1279 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t588 + 0.292e3 / 0.2025e4 * t195 * t1308 - 0.73e2 / 0.972e5 * t1308 * t207 - 0.73e2 / 0.1944e6 * t1313 * t459 - 0.73e2 / 0.1944e6 * t1074 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1318 - 0.73e2 / 0.1944e6 * t449 * t1327 - 0.5e2 / 0.177147e6 * t102 * t1330 - t606 * t396 / 0.18e3 - t111 * t609 * t468 / 0.96e2;
  t1341 = t613 * t476;
  t1342 = t1341 * t344;
  t1345 = t1108 * t101;
  t1350 = t122 * t1279;
  t1353 = -t1338 * t229 * t101 - 0.2e1 / 0.9e1 * t1342 * t441 + t1345 * t617 / 0.12e2 + t1115 * t1325 / 0.36e2 - 0.2e1 / 0.9e1 * t616 * t1350;
  t1354 = t1353 * t232;
  t1355 = t259 * t1354;
  t1358 = t6 * t147;
  t1359 = params->kappa * t620;
  t1360 = t1359 * t482;
  t1364 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t999 * t622 + t1249 + 0.3e1 / 0.8e1 * t393 * t1355 + 0.3e1 / 0.8e1 * t1358 * t1360);
  tv2rhosigma5 = t7 * t1364 + t625;

  if(out->v2rhosigma != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhosigma[ip*p->dim.v2rhosigma + 5] += tv2rhosigma5;

  tv2rholapl0 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 0] += tv2rholapl0;

  tv2rholapl1 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 1] += tv2rholapl1;

  tv2rholapl2 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 2] += tv2rholapl2;

  tv2rholapl3 = 0.e0;

  if(out->v2rholapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rholapl[ip*p->dim.v2rholapl + 3] += tv2rholapl3;

  t1368 = t253 * t664;
  t1369 = t1368 * t666;
  t1371 = t258 * t1369 / 0.8e1;
  t1372 = t261 * t627;
  t1373 = t1372 * t41;
  t1377 = t268 * t633 * t273;
  t1381 = 0.1e1 / t269 / t626;
  t1383 = t1145 * t1381 * t769;
  t1387 = (t30 * t1373 / 0.16e2 - 0.3e1 / 0.512e3 * t267 * t1377 + 0.3e1 / 0.32768e5 * t764 * t1383) * t46;
  t1397 = t794 * t651;
  t1400 = t651 * t304;
  t1407 = -0.25e2 / 0.3e1 * t510 + 0.5e2 / 0.9e1 * t645 * t301 - 0.125e3 / 0.27e2 * t513;
  t1410 = -0.5e1 / 0.4e1 * t507 - 0.3e1 / 0.8e1 * t642 * t795 - 0.3e1 / 0.8e1 * t291 * t1397 + 0.81e2 / 0.8e2 * t801 * t1400 - 0.27e2 / 0.4e2 * t297 * t1407;
  t1415 = t654 * t314;
  t1420 = t830 * t29;
  t1421 = t628 * t325;
  t1424 = t316 * t627;
  t1429 = t1387 * t57 / 0.24e2 - t639 * t283 / 0.9e1 + 0.292e3 / 0.2025e4 * t309 * t654 + 0.292e3 / 0.2025e4 * t82 * t1410 - 0.73e2 / 0.972e5 * t1410 * t98 - 0.73e2 / 0.1944e6 * t1415 * t325 + 0.73e2 / 0.6e3 * t825 * t659 - 0.73e2 / 0.12e4 * t1420 * t1421 - 0.73e2 / 0.3e3 * t315 * t1424 + t108 * t1372 / 0.18e3;
  t1430 = t27 * t1429;
  t1431 = t1430 * t666;
  t1434 = t665 * t342;
  t1435 = t258 * t1434;
  t1437 = t130 * t107 * t46;
  t1438 = t1437 * t283;
  t1441 = t664 * t127;
  t1442 = t1441 * t349;
  t1446 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t741 * t667 - t1371 - 0.3e1 / 0.8e1 * t258 * t1431 - t1435 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t1442);
  tv2rhotau0 = t7 * t1446 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 0] += tv2rhotau0;

  t1450 = t253 * t709;
  t1451 = t1450 * t711;
  t1453 = t393 * t1451 / 0.8e1;
  t1455 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t712 - t1453);
  tv2rhotau1 = t7 * t1455 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 1] += tv2rhotau1;

  t1460 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t667 - t1371);
  tv2rhotau2 = t7 * t1460 + t670;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 2] += tv2rhotau2;

  t1464 = t395 * t672;
  t1465 = t1464 * t160;
  t1469 = t402 * t678 * t407;
  t1473 = 0.1e1 / t403 / t671;
  t1475 = t1266 * t1473 * t1018;
  t1479 = (t149 * t1465 / 0.16e2 - 0.3e1 / 0.512e3 * t401 * t1469 + 0.3e1 / 0.32768e5 * t1013 * t1475) * t46;
  t1489 = t1043 * t696;
  t1492 = t696 * t438;
  t1499 = -0.25e2 / 0.3e1 * t578 + 0.5e2 / 0.9e1 * t690 * t435 - 0.125e3 / 0.27e2 * t581;
  t1502 = -0.5e1 / 0.4e1 * t575 - 0.3e1 / 0.8e1 * t687 * t1044 - 0.3e1 / 0.8e1 * t425 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1492 - 0.27e2 / 0.4e2 * t431 * t1499;
  t1507 = t699 * t448;
  t1512 = t1079 * t148;
  t1513 = t673 * t459;
  t1516 = t450 * t672;
  t1521 = t1479 * t171 / 0.24e2 - t684 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t443 * t699 + 0.292e3 / 0.2025e4 * t195 * t1502 - 0.73e2 / 0.972e5 * t1502 * t207 - 0.73e2 / 0.1944e6 * t1507 * t459 + 0.73e2 / 0.6e3 * t1074 * t704 - 0.73e2 / 0.12e4 * t1512 * t1513 - 0.73e2 / 0.3e3 * t449 * t1516 + t214 * t1464 / 0.18e3;
  t1522 = t27 * t1521;
  t1523 = t1522 * t711;
  t1526 = t710 * t476;
  t1527 = t393 * t1526;
  t1529 = t232 * t107 * t46;
  t1530 = t1529 * t417;
  t1533 = t709 * t229;
  t1534 = t1533 * t482;
  t1538 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t999 * t712 - t1453 - 0.3e1 / 0.8e1 * t393 * t1523 - t1527 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t1534);
  tv2rhotau3 = t7 * t1538 + t715;

  if(out->v2rhotau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2rhotau[ip*p->dim.v2rhotau + 3] += tv2rhotau3;

  t1540 = params->c * t32;
  t1541 = t34 * t41;
  t1546 = t758 * t766;
  t1547 = t1546 * t769;
  t1551 = (t1540 * t1541 / 0.32e2 - 0.5e1 / 0.1024e4 * t30 * t496 + 0.3e1 / 0.32768e5 * t267 * t1547) * t46;
  t1556 = t520 * t520;
  t1558 = t506 * t1168;
  t1560 = t515 * t515;
  t1563 = t297 * params->b;
  t1564 = t89 * t93;
  t1565 = t1563 * t1564;
  t1567 = 0.3e1 / 0.32e2 * t1558 + 0.81e2 / 0.8e2 * t801 * t1560 - 0.15e2 / 0.256e3 * t1565;
  t1574 = t531 * t531;
  t1579 = 0.324e3 * t35 + 0.1e3 * t1564;
  t1582 = t88 * t93;
  t1585 = t107 * t32;
  t1588 = t113 * sigma[0];
  t1592 = t1551 * t57 / 0.24e2 + t500 * t503 / 0.12e2 + 0.292e3 / 0.2025e4 * t1556 + 0.292e3 / 0.2025e4 * t82 * t1567 - 0.73e2 / 0.972e5 * t1567 * t98 - 0.73e2 / 0.972e5 * t1192 * t531 + 0.73e2 / 0.3888e6 * t830 * t1574 - 0.73e2 / 0.1944e6 * t315 * t1579 + 0.25e2 / 0.472392e6 * t102 * t1582 + t1585 * t34 / 0.36e3 + t111 * t1588 * t117 / 0.384e3;
  t1595 = t1220 * t101;
  t1598 = t865 * t101;
  t1599 = params->e * t86;
  t1600 = t1599 * t1582;
  t1603 = -t1592 * t127 * t101 + t1595 * t549 / 0.6e1 - t1598 * t1600 / 0.96e2;
  t1604 = t1603 * t130;
  t1605 = t259 * t1604;
  t1607 = t552 * t552;
  t1608 = t1607 * t130;
  t1609 = t259 * t1608;
  t1613 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t1605 + 0.3e1 / 0.8e1 * t258 * t1609);
  tv2sigma20 = t7 * t1613;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 0] += tv2sigma20;

  tv2sigma21 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 1] += tv2sigma21;

  tv2sigma22 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 2] += tv2sigma22;

  tv2sigma23 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 3] += tv2sigma23;

  tv2sigma24 = 0.e0;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 4] += tv2sigma24;

  t1614 = params->c * t151;
  t1615 = t153 * t160;
  t1620 = t1007 * t1015;
  t1621 = t1620 * t1018;
  t1625 = (t1614 * t1615 / 0.32e2 - 0.5e1 / 0.1024e4 * t149 * t564 + 0.3e1 / 0.32768e5 * t401 * t1621) * t46;
  t1630 = t588 * t588;
  t1632 = t574 * t1289;
  t1634 = t583 * t583;
  t1637 = t431 * params->b;
  t1638 = t89 * t202;
  t1639 = t1637 * t1638;
  t1641 = 0.3e1 / 0.32e2 * t1632 + 0.81e2 / 0.8e2 * t1050 * t1634 - 0.15e2 / 0.256e3 * t1639;
  t1648 = t599 * t599;
  t1653 = 0.324e3 * t154 + 0.1e3 * t1638;
  t1656 = t88 * t202;
  t1659 = t107 * t151;
  t1662 = t113 * sigma[2];
  t1666 = t1625 * t171 / 0.24e2 + t568 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1630 + 0.292e3 / 0.2025e4 * t195 * t1641 - 0.73e2 / 0.972e5 * t1641 * t207 - 0.73e2 / 0.972e5 * t1313 * t599 + 0.73e2 / 0.3888e6 * t1079 * t1648 - 0.73e2 / 0.1944e6 * t449 * t1653 + 0.25e2 / 0.472392e6 * t102 * t1656 + t1659 * t153 / 0.36e3 + t111 * t1662 * t220 / 0.384e3;
  t1669 = t1341 * t101;
  t1672 = t1114 * t101;
  t1673 = t1599 * t1656;
  t1676 = -t1666 * t229 * t101 + t1669 * t617 / 0.6e1 - t1672 * t1673 / 0.96e2;
  t1677 = t1676 * t232;
  t1678 = t259 * t1677;
  t1680 = t620 * t620;
  t1681 = t1680 * t232;
  t1682 = t259 * t1681;
  t1686 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t1678 + 0.3e1 / 0.8e1 * t393 * t1682);
  tv2sigma25 = t7 * t1686;

  if(out->v2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigma2[ip*p->dim.v2sigma2 + 5] += tv2sigma25;

  tv2sigmalapl0 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 0] += tv2sigmalapl0;

  tv2sigmalapl1 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 1] += tv2sigmalapl1;

  tv2sigmalapl2 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 2] += tv2sigmalapl2;

  tv2sigmalapl3 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 3] += tv2sigmalapl3;

  tv2sigmalapl4 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 4] += tv2sigmalapl4;

  tv2sigmalapl5 = 0.e0;

  if(out->v2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmalapl[ip*p->dim.v2sigmalapl + 5] += tv2sigmalapl5;

  t1692 = t758 * t1381 * t769;
  t1696 = (-t490 * t629 / 0.16e2 + 0.3e1 / 0.512e3 * t493 * t635 - 0.3e1 / 0.32768e5 * t1144 * t1692) * t46;
  t1705 = t506 * t1397;
  t1707 = t651 * t515;
  t1711 = 0.1e1 / t53 / t90;
  t1712 = t1711 * t86;
  t1714 = t1563 * t1712 * t88;
  t1716 = -0.3e1 / 0.8e1 * t642 * t1168 + 0.3e1 / 0.64e2 * t1705 + 0.81e2 / 0.8e2 * t801 * t1707 + 0.15e2 / 0.32e2 * t1714;
  t1725 = t628 * t531;
  t1728 = t525 * t627;
  t1733 = t1696 * t57 / 0.24e2 + t639 * t503 / 0.24e2 + 0.292e3 / 0.2025e4 * t520 * t654 + 0.292e3 / 0.2025e4 * t82 * t1716 - 0.73e2 / 0.972e5 * t1716 * t98 - 0.73e2 / 0.1944e6 * t1415 * t531 + 0.73e2 / 0.6e3 * t1192 * t659 - 0.73e2 / 0.12e4 * t1420 * t1725 + 0.73e2 / 0.3e3 * t315 * t1728 - t538 * t628 / 0.18e3;
  t1734 = t27 * t1733;
  t1735 = t1734 * t666;
  t1738 = t28 * t664;
  t1739 = t6 * t1738;
  t1741 = t342 * t130 * t107;
  t1742 = t1741 * t518;
  t1745 = t1441 * t553;
  t1749 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t1735 + t1739 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t1745);
  tv2sigmatau0 = t7 * t1749;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 0] += tv2sigmatau0;

  tv2sigmatau1 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 1] += tv2sigmatau1;

  tv2sigmatau2 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 2] += tv2sigmatau2;

  tv2sigmatau3 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 3] += tv2sigmatau3;

  tv2sigmatau4 = 0.e0;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 4] += tv2sigmatau4;

  t1755 = t1007 * t1473 * t1018;
  t1759 = (-t558 * t674 / 0.16e2 + 0.3e1 / 0.512e3 * t561 * t680 - 0.3e1 / 0.32768e5 * t1265 * t1755) * t46;
  t1768 = t574 * t1489;
  t1770 = t696 * t583;
  t1774 = 0.1e1 / t167 / t199;
  t1775 = t1774 * t86;
  t1777 = t1637 * t1775 * t88;
  t1779 = -0.3e1 / 0.8e1 * t687 * t1289 + 0.3e1 / 0.64e2 * t1768 + 0.81e2 / 0.8e2 * t1050 * t1770 + 0.15e2 / 0.32e2 * t1777;
  t1788 = t673 * t599;
  t1791 = t593 * t672;
  t1796 = t1759 * t171 / 0.24e2 + t684 * t571 / 0.24e2 + 0.292e3 / 0.2025e4 * t588 * t699 + 0.292e3 / 0.2025e4 * t195 * t1779 - 0.73e2 / 0.972e5 * t1779 * t207 - 0.73e2 / 0.1944e6 * t1507 * t599 + 0.73e2 / 0.6e3 * t1313 * t704 - 0.73e2 / 0.12e4 * t1512 * t1788 + 0.73e2 / 0.3e3 * t449 * t1791 - t606 * t673 / 0.18e3;
  t1797 = t27 * t1796;
  t1798 = t1797 * t711;
  t1801 = t147 * t709;
  t1802 = t6 * t1801;
  t1804 = t476 * t232 * t107;
  t1805 = t1804 * t586;
  t1808 = t1533 * t621;
  t1812 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t1798 + t1802 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t1808);
  tv2sigmatau5 = t7 * t1812;

  if(out->v2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2sigmatau[ip*p->dim.v2sigmatau + 5] += tv2sigmatau5;

  tv2lapl20 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 0] += tv2lapl20;

  tv2lapl21 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 1] += tv2lapl21;

  tv2lapl22 = 0.e0;

  if(out->v2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapl2[ip*p->dim.v2lapl2 + 2] += tv2lapl22;

  tv2lapltau0 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 0] += tv2lapltau0;

  tv2lapltau1 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 1] += tv2lapltau1;

  tv2lapltau2 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 2] += tv2lapltau2;

  tv2lapltau3 = 0.e0;

  if(out->v2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2lapltau[ip*p->dim.v2lapltau + 3] += tv2lapltau3;

  t1813 = t32 * t270;
  t1814 = t1813 * t41;
  t1817 = t494 * t766;
  t1818 = t1817 * t273;
  t1821 = t269 * t269;
  t1822 = 0.1e1 / t1821;
  t1824 = t758 * t1822 * t769;
  t1828 = (0.3e1 / 0.32e2 * t30 * t1814 - 0.7e1 / 0.1024e4 * t267 * t1818 + 0.3e1 / 0.32768e5 * t764 * t1824) * t46;
  t1831 = t654 * t654;
  t1835 = t651 * t651;
  t1839 = 0.1e1 / t53 / t260;
  t1840 = t1839 * t86;
  t1844 = -0.3e1 / 0.4e1 * t642 * t1397 + 0.81e2 / 0.8e2 * t801 * t1835 - 0.15e2 / 0.4e1 * t1563 * t1840 * t88;
  t1851 = t266 * t494;
  t1852 = t1851 * t766;
  t1855 = t36 * t270;
  t1860 = t1828 * t57 / 0.24e2 + 0.292e3 / 0.2025e4 * t1831 + 0.292e3 / 0.2025e4 * t82 * t1844 - 0.73e2 / 0.972e5 * t1844 * t98 + 0.73e2 / 0.3e3 * t1415 * t659 + 0.1971e4 / 0.1e3 * t830 * t1852 - 0.73e2 / 0.2e3 * t315 * t1855 + t108 * t1813 / 0.12e3;
  t1861 = t27 * t1860;
  t1862 = t1861 * t666;
  t1864 = t664 * t664;
  t1865 = t1864 * t864;
  t1866 = t101 * t130;
  t1867 = t1865 * t1866;
  t1871 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t1237 * t1867 - 0.3e1 / 0.8e1 * t258 * t1862);
  tv2tau20 = t7 * t1871;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 0] += tv2tau20;

  tv2tau21 = 0.e0;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 1] += tv2tau21;

  t1872 = t151 * t404;
  t1873 = t1872 * t160;
  t1876 = t562 * t1015;
  t1877 = t1876 * t407;
  t1880 = t403 * t403;
  t1881 = 0.1e1 / t1880;
  t1883 = t1007 * t1881 * t1018;
  t1887 = (0.3e1 / 0.32e2 * t149 * t1873 - 0.7e1 / 0.1024e4 * t401 * t1877 + 0.3e1 / 0.32768e5 * t1013 * t1883) * t46;
  t1890 = t699 * t699;
  t1894 = t696 * t696;
  t1898 = 0.1e1 / t167 / t394;
  t1899 = t1898 * t86;
  t1903 = -0.3e1 / 0.4e1 * t687 * t1489 + 0.81e2 / 0.8e2 * t1050 * t1894 - 0.15e2 / 0.4e1 * t1637 * t1899 * t88;
  t1910 = t400 * t562;
  t1911 = t1910 * t1015;
  t1914 = t155 * t404;
  t1919 = t1887 * t171 / 0.24e2 + 0.292e3 / 0.2025e4 * t1890 + 0.292e3 / 0.2025e4 * t195 * t1903 - 0.73e2 / 0.972e5 * t1903 * t207 + 0.73e2 / 0.3e3 * t1507 * t704 + 0.1971e4 / 0.1e3 * t1079 * t1911 - 0.73e2 / 0.2e3 * t449 * t1914 + t214 * t1872 / 0.12e3;
  t1920 = t27 * t1919;
  t1921 = t1920 * t711;
  t1923 = t709 * t709;
  t1924 = t1923 * t1113;
  t1925 = t101 * t232;
  t1926 = t1924 * t1925;
  t1930 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t1358 * t1926 - 0.3e1 / 0.8e1 * t393 * t1921);
  tv2tau22 = t7 * t1930;

  if(out->v2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_FXC))
    out->v2tau2[ip*p->dim.v2tau2 + 2] += tv2tau22;

  t1935 = t6 * t732 * t253 * t133;
  t1939 = t6 * t247 * t745 * t133;
  t1942 = 0.1e1 / t252 / t240;
  t1946 = 0.5e1 / 0.36e2 * t6 * t26 * t1942 * t133;
  t1948 = 0.1e1 / t718 / t20;
  t1949 = t720 * t244;
  t1952 = t719 * t244;
  t1955 = t240 * t240;
  t1956 = 0.1e1 / t1955;
  t1957 = t17 * t1956;
  t1960 = my_piecewise5(t11, 0, t15, 0, 0.6e1 * t724 - 0.6e1 * t1957);
  t1964 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1948 * t1949 + 0.4e1 / 0.3e1 * t1952 * t728 + 0.4e1 / 0.3e1 * t24 * t1960);
  t1969 = t750 * t878;
  t1970 = t258 * t1969;
  t1972 = params->kappa * t872;
  t1973 = t1972 * t349;
  t1977 = t877 * t348 * t130;
  t1978 = t259 * t1977;
  t1983 = t6 * t732;
  t1986 = t741 * t751;
  t1990 = t745 * params->kappa;
  t1991 = t1990 * t349;
  t1992 = t258 * t1991;
  t1994 = t750 * t873;
  t1995 = t258 * t1994;
  t1997 = t268 * t34;
  t1998 = t1997 * t41;
  t2002 = t1145 * t270 * t273;
  t2006 = t334 * t766 * t769;
  t2009 = t266 * t266;
  t2010 = params->c * t2009;
  t2011 = t116 * t260;
  t2012 = 0.1e1 / t2011;
  t2015 = 0.1e1 / t768 / t39;
  t2016 = t2012 * t1822 * t2015;
  t2020 = (-0.3e1 / 0.8e1 * t30 * t1998 + 0.3e1 / 0.64e2 * t267 * t2002 - 0.45e2 / 0.32768e5 * t764 * t2006 + 0.3e1 / 0.262144e6 * t2010 * t2016) * t46;
  t2028 = 0.1e1 / t54 / t91;
  t2029 = t52 * t2028;
  t2036 = sigma[0] * t2028;
  t2038 = -0.44e3 / 0.27e2 * tau[0] * t780 + 0.154e3 / 0.27e2 * t2036;
  t2039 = t2038 * t46;
  t2044 = t51 * t800;
  t2045 = t2044 * t802;
  t2048 = t794 * t815;
  t2053 = 0.1e1 / t76 / t798 / t75;
  t2054 = t69 * t2053;
  t2055 = t802 * t304;
  t2061 = params->b * t2038;
  t2066 = t89 * t2038;
  t2069 = 0.5e1 * t2061 * t72 + 0.5e2 / 0.3e1 * t805 * t301 + 0.25e2 / 0.9e1 * t70 * t2066;
  t2072 = t71 * t2036;
  t2074 = 0.3e1 / 0.4e1 * t2039 * t292 - 0.9e1 / 0.8e1 * t791 * t795 + 0.27e2 / 0.16e2 * t291 * t2045 - 0.9e1 / 0.8e1 * t291 * t2048 - 0.81e2 / 0.32e2 * t2054 * t2055 + 0.243e3 / 0.8e2 * t801 * t304 * t815 - 0.27e2 / 0.4e2 * t297 * t2069 - 0.308e3 / 0.243e3 * t2072;
  t2079 = t820 * t314;
  t2082 = t309 * t829;
  t2087 = t97 * t97;
  t2089 = 0.1e1 / t98 / t2087;
  t2090 = t82 * t2089;
  t2091 = t831 * t325;
  t2094 = t325 * t843;
  t2097 = t29 * t268;
  t2101 = 0.1e1 / t53 / t116;
  t2103 = t89 * t29 * t2101;
  t2105 = -0.3888e4 * t2097 * t34 - 0.3344e6 / 0.27e2 * t2103;
  t2108 = t103 * t2101;
  t2116 = t2020 * t57 / 0.24e2 - t774 * t283 / 0.3e1 + 0.11e2 / 0.9e1 * t278 * t781 - 0.154e3 / 0.81e2 * t47 * t2029 + 0.292e3 / 0.675e3 * t309 * t820 + 0.292e3 / 0.2025e4 * t82 * t2074 - 0.73e2 / 0.972e5 * t2074 * t98 - 0.73e2 / 0.648e5 * t2079 * t325 + 0.73e2 / 0.1296e6 * t2082 * t831 - 0.73e2 / 0.648e5 * t825 * t843 - 0.73e2 / 0.2592e6 * t2090 * t2091 + 0.73e2 / 0.1296e6 * t830 * t2094 - 0.73e2 / 0.1944e6 * t315 * t2105 - 0.1045e5 / 0.1594323e7 * t102 * t2108 - t108 * t1997 / 0.3e2 - 0.5e1 / 0.16e2 * t111 * t115 * t2012;
  t2119 = t856 * t342;
  t2120 = t2119 * t344;
  t2123 = t338 * t864;
  t2124 = t2123 * t866;
  t2130 = 0.1e1 / t863 / t125;
  t2132 = t121 * t2130 * t101;
  t2133 = t107 * params->e;
  t2134 = t2133 * t113;
  t2136 = t2134 * t114 * t2012;
  t2143 = -t2116 * t127 * t101 - 0.2e1 / 0.3e1 * t2120 * t307 - 0.2e1 / 0.9e1 * t2124 * t841 + 0.22e2 / 0.9e1 * t860 * t818 - 0.16e2 / 0.81e2 * t2132 * t2136 + 0.22e2 / 0.27e2 * t867 * t2103 - 0.308e3 / 0.81e2 * t345 * t2072;
  t2144 = t2143 * t130;
  t2145 = t259 * t2144;
  t2148 = -0.3e1 / 0.8e1 * t1935 + t1939 / 0.4e1 - t1946 - 0.3e1 / 0.8e1 * t6 * t1964 * t27 * t133 + 0.3e1 / 0.8e1 * t1970 + 0.9e1 / 0.8e1 * t1237 * t1973 + 0.3e1 / 0.8e1 * t258 * t1978 + 0.9e1 / 0.8e1 * t741 * t879 + 0.9e1 / 0.8e1 * t1983 * t350 + 0.3e1 / 0.4e1 * t1986 + 0.9e1 / 0.8e1 * t741 * t874 - t1992 / 0.4e1 + 0.3e1 / 0.8e1 * t1995 + 0.3e1 / 0.8e1 * t258 * t2145;
  t2149 = my_piecewise3(t2, 0, t2148);
  t2151 = 0.1e1 / t884 / t142;
  t2152 = t886 * t357;
  t2155 = t885 * t357;
  t2158 = t139 * t1956;
  t2161 = my_piecewise5(t15, 0, t11, 0, -0.6e1 * t724 - 0.6e1 * t2158);
  t2165 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2151 * t2152 + 0.4e1 / 0.3e1 * t2155 * t892 + 0.4e1 / 0.3e1 * t144 * t2161);
  t2172 = t6 * t896 * t253 * t235;
  t2176 = t6 * t360 * t745 * t235;
  t2181 = 0.5e1 / 0.36e2 * t6 * t146 * t1942 * t235;
  t2183 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t2165 * t27 * t235 - 0.3e1 / 0.8e1 * t2172 + t2176 / 0.4e1 - t2181);
  tv3rho30 = 0.3e1 * t883 + 0.3e1 * t910 + t7 * (t2149 + t2183);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 0] += tv3rho30;

  t2186 = 0.2e1 * t936;
  t2187 = 0.2e1 * t962;
  t2188 = t1948 * t374;
  t2191 = t719 * t917;
  t2196 = 0.2e1 * t724;
  t2197 = 0.6e1 * t1957;
  t2199 = my_piecewise5(t11, 0, t15, 0, t2196 - t2197);
  t2203 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t2188 * t720 + 0.8e1 / 0.9e1 * t2191 * t244 + 0.4e1 / 0.9e1 * t913 * t728 + 0.4e1 / 0.3e1 * t24 * t2199);
  t2211 = t6 * t921 * t253 * t133 / 0.4e1;
  t2212 = t6 * t921;
  t2217 = t6 * t377 * t745 * t133;
  t2220 = t930 * t751 / 0.4e1;
  t2231 = -0.3e1 / 0.8e1 * t6 * t2203 * t27 * t133 - t2211 + 0.3e1 / 0.4e1 * t2212 * t350 + t2217 / 0.12e2 + t2220 + 0.3e1 / 0.8e1 * t930 * t874 + 0.3e1 / 0.8e1 * t930 * t879 - t1935 / 0.8e1 + t1939 / 0.6e1 + t1986 / 0.4e1 - t1946 - t1992 / 0.6e1 + t1995 / 0.8e1 + t1970 / 0.8e1;
  t2232 = my_piecewise3(t2, 0, t2231);
  t2233 = t2151 * t385;
  t2236 = t885 * t941;
  t2241 = 0.6e1 * t2158;
  t2243 = my_piecewise5(t15, 0, t11, 0, -t2196 - t2241);
  t2247 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2233 * t886 + 0.8e1 / 0.9e1 * t2236 * t357 + 0.4e1 / 0.9e1 * t937 * t892 + 0.4e1 / 0.3e1 * t144 * t2243);
  t2255 = t6 * t945 * t253 * t235 / 0.4e1;
  t2258 = t6 * t388 * t745 * t235;
  t2262 = t6 * t896;
  t2266 = t955 * t958 / 0.4e1;
  t2267 = t1990 * t482;
  t2268 = t393 * t2267;
  t2271 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t2247 * t27 * t235 - t2255 + t2258 / 0.12e2 - t2172 / 0.8e1 + t2176 / 0.6e1 - t2181 + 0.3e1 / 0.8e1 * t2262 * t483 + t2266 - t2268 / 0.12e2);
  tv3rho31 = t883 + t910 + t2186 + t2187 + t7 * (t2232 + t2271);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 1] += tv3rho31;

  t2274 = t1948 * t967;
  t2279 = t719 * t972;
  t2283 = my_piecewise5(t11, 0, t15, 0, -t2196 - t2197);
  t2287 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t2274 * t244 + 0.8e1 / 0.9e1 * t913 * t917 + 0.4e1 / 0.9e1 * t2279 * t244 + 0.4e1 / 0.3e1 * t24 * t2283);
  t2294 = t6 * t976 * t253 * t133;
  t2296 = t6 * t976;
  t2303 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t2287 * t27 * t133 - t2294 / 0.8e1 + 0.3e1 / 0.8e1 * t2296 * t350 - t2211 + t2217 / 0.6e1 + t2220 + t1939 / 0.12e2 - t1946 - t1992 / 0.12e2);
  t2304 = t2151 * t984;
  t2309 = t885 * t989;
  t2313 = my_piecewise5(t15, 0, t11, 0, t2196 - t2241);
  t2317 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2304 * t357 + 0.8e1 / 0.9e1 * t937 * t941 + 0.4e1 / 0.9e1 * t2309 * t357 + 0.4e1 / 0.3e1 * t144 * t2313);
  t2324 = t6 * t993 * t253 * t235;
  t2327 = t6 * t945;
  t2330 = t999 * t958;
  t2336 = t750 * t1121;
  t2337 = t393 * t2336;
  t2341 = t750 * t1126;
  t2342 = t393 * t2341;
  t2344 = -0.3e1 / 0.8e1 * t6 * t2317 * t27 * t235 - t2324 / 0.8e1 - t2255 + t2258 / 0.6e1 + 0.3e1 / 0.4e1 * t2327 * t483 + t2330 / 0.4e1 + t2176 / 0.12e2 - t2181 + t2266 - t2268 / 0.6e1 + 0.3e1 / 0.8e1 * t955 * t1122 + t2337 / 0.8e1 + 0.3e1 / 0.8e1 * t955 * t1127 + t2342 / 0.8e1;
  t2345 = my_piecewise3(t138, 0, t2344);
  tv3rho32 = t2186 + t2187 + t983 + t1131 + t7 * (t2303 + t2345);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 2] += tv3rho32;

  t2350 = t967 * t374;
  t2357 = my_piecewise5(t11, 0, t15, 0, -0.6e1 * t724 - 0.6e1 * t1957);
  t2361 = my_piecewise3(t21, 0, -0.8e1 / 0.27e2 * t1948 * t2350 + 0.4e1 / 0.3e1 * t913 * t972 + 0.4e1 / 0.3e1 * t24 * t2357);
  t2369 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t2361 * t27 * t133 - 0.3e1 / 0.8e1 * t2294 + t2217 / 0.4e1 - t1946);
  t2372 = t984 * t385;
  t2379 = my_piecewise5(t15, 0, t11, 0, 0.6e1 * t724 - 0.6e1 * t2158);
  t2383 = my_piecewise3(t143, 0, -0.8e1 / 0.27e2 * t2151 * t2372 + 0.4e1 / 0.3e1 * t937 * t989 + 0.4e1 / 0.3e1 * t144 * t2379);
  t2388 = params->kappa * t1120;
  t2389 = t2388 * t482;
  t2393 = t1125 * t481 * t232;
  t2394 = t259 * t2393;
  t2405 = t402 * t153;
  t2406 = t2405 * t160;
  t2410 = t1266 * t404 * t407;
  t2414 = t468 * t1015 * t1018;
  t2417 = t400 * t400;
  t2418 = params->c * t2417;
  t2419 = t219 * t394;
  t2420 = 0.1e1 / t2419;
  t2423 = 0.1e1 / t1017 / t158;
  t2424 = t2420 * t1881 * t2423;
  t2428 = (-0.3e1 / 0.8e1 * t149 * t2406 + 0.3e1 / 0.64e2 * t401 * t2410 - 0.45e2 / 0.32768e5 * t1013 * t2414 + 0.3e1 / 0.262144e6 * t2418 * t2424) * t46;
  t2436 = 0.1e1 / t168 / t200;
  t2437 = t166 * t2436;
  t2444 = sigma[2] * t2436;
  t2446 = -0.44e3 / 0.27e2 * tau[1] * t1029 + 0.154e3 / 0.27e2 * t2444;
  t2447 = t2446 * t46;
  t2452 = t51 * t1049;
  t2453 = t2452 * t1051;
  t2456 = t1043 * t1064;
  t2461 = 0.1e1 / t189 / t1047 / t188;
  t2462 = t183 * t2461;
  t2463 = t1051 * t438;
  t2469 = params->b * t2446;
  t2474 = t89 * t2446;
  t2477 = 0.5e1 * t2469 * t185 + 0.5e2 / 0.3e1 * t1054 * t435 + 0.25e2 / 0.9e1 * t184 * t2474;
  t2480 = t71 * t2444;
  t2482 = 0.3e1 / 0.4e1 * t2447 * t426 - 0.9e1 / 0.8e1 * t1040 * t1044 + 0.27e2 / 0.16e2 * t425 * t2453 - 0.9e1 / 0.8e1 * t425 * t2456 - 0.81e2 / 0.32e2 * t2462 * t2463 + 0.243e3 / 0.8e2 * t1050 * t438 * t1064 - 0.27e2 / 0.4e2 * t431 * t2477 - 0.308e3 / 0.243e3 * t2480;
  t2487 = t1069 * t448;
  t2490 = t443 * t1078;
  t2495 = t206 * t206;
  t2497 = 0.1e1 / t207 / t2495;
  t2498 = t195 * t2497;
  t2499 = t1080 * t459;
  t2502 = t459 * t1092;
  t2505 = t148 * t402;
  t2509 = 0.1e1 / t167 / t219;
  t2511 = t89 * t148 * t2509;
  t2513 = -0.3888e4 * t2505 * t153 - 0.3344e6 / 0.27e2 * t2511;
  t2516 = t210 * t2509;
  t2524 = t2428 * t171 / 0.24e2 - t1023 * t417 / 0.3e1 + 0.11e2 / 0.9e1 * t412 * t1030 - 0.154e3 / 0.81e2 * t165 * t2437 + 0.292e3 / 0.675e3 * t443 * t1069 + 0.292e3 / 0.2025e4 * t195 * t2482 - 0.73e2 / 0.972e5 * t2482 * t207 - 0.73e2 / 0.648e5 * t2487 * t459 + 0.73e2 / 0.1296e6 * t2490 * t1080 - 0.73e2 / 0.648e5 * t1074 * t1092 - 0.73e2 / 0.2592e6 * t2498 * t2499 + 0.73e2 / 0.1296e6 * t1079 * t2502 - 0.73e2 / 0.1944e6 * t449 * t2513 - 0.1045e5 / 0.1594323e7 * t102 * t2516 - t214 * t2405 / 0.3e2 - 0.5e1 / 0.16e2 * t111 * t218 * t2420;
  t2527 = t1105 * t476;
  t2528 = t2527 * t344;
  t2531 = t472 * t1113;
  t2532 = t2531 * t866;
  t2538 = 0.1e1 / t1112 / t227;
  t2540 = t224 * t2538 * t101;
  t2542 = t2134 * t217 * t2420;
  t2549 = -t2524 * t229 * t101 - 0.2e1 / 0.3e1 * t2528 * t441 - 0.2e1 / 0.9e1 * t2532 * t1090 + 0.22e2 / 0.9e1 * t1109 * t1067 - 0.16e2 / 0.81e2 * t2540 * t2542 + 0.22e2 / 0.27e2 * t1115 * t2511 - 0.308e3 / 0.81e2 * t478 * t2480;
  t2550 = t2549 * t232;
  t2551 = t259 * t2550;
  t2554 = t6 * t993;
  t2557 = -0.3e1 / 0.8e1 * t2324 + t2258 / 0.4e1 - t2181 - 0.3e1 / 0.8e1 * t6 * t2383 * t27 * t235 + 0.9e1 / 0.8e1 * t1358 * t2389 + 0.3e1 / 0.8e1 * t393 * t2394 + 0.3e1 / 0.8e1 * t2337 + 0.3e1 / 0.8e1 * t2342 + 0.9e1 / 0.8e1 * t999 * t1127 - t2268 / 0.4e1 + 0.3e1 / 0.4e1 * t2330 + 0.9e1 / 0.8e1 * t999 * t1122 + 0.3e1 / 0.8e1 * t393 * t2551 + 0.9e1 / 0.8e1 * t2554 * t483;
  t2558 = my_piecewise3(t138, 0, t2557);
  tv3rho33 = 0.3e1 * t983 + 0.3e1 * t1131 + t7 * (t2369 + t2558);

  if(out->v3rho3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho3[ip*p->dim.v3rho3 + 3] += tv3rho33;

  t2564 = t741 * t1136;
  t2568 = t6 * t248;
  t2571 = t1990 * t553;
  t2573 = t258 * t2571 / 0.12e2;
  t2574 = t750 * t1233;
  t2575 = t258 * t2574;
  t2577 = t6 * t254;
  t2578 = t2577 * t1239;
  t2580 = t1187 * t314;
  t2589 = sigma[0] * t494;
  t2593 = t89 * sigma[0] * t839;
  t2595 = 0.1944e4 * t2589 * t34 + 0.304e5 / 0.9e1 * t2593;
  t2606 = t780 * t46;
  t2607 = t2606 * t292;
  t2609 = t1163 * t795;
  t2611 = t506 * t2045;
  t2613 = t506 * t2048;
  t2617 = t291 * t51;
  t2618 = t800 * t515;
  t2619 = t2618 * t304;
  t2622 = t794 * t1182;
  t2634 = params->b * t780;
  t2635 = t2634 * t72;
  t2637 = t1174 * t301;
  t2639 = t509 * t812;
  t2642 = t70 * t89 * t780;
  t2644 = -0.55e2 / 0.9e1 * t2635 + 0.1e3 / 0.27e2 * t2637 - 0.25e2 / 0.36e2 * t2639 - 0.275e3 / 0.81e2 * t2642;
  t2647 = t2606 * t51;
  t2649 = -0.11e2 / 0.12e2 * t2607 - t2609 / 0.4e1 - 0.9e1 / 0.128e3 * t2611 + 0.3e1 / 0.64e2 * t2613 - 0.3e1 / 0.8e1 * t791 * t1168 + 0.9e1 / 0.8e1 * t2617 * t2619 - 0.3e1 / 0.4e1 * t291 * t2622 - 0.81e2 / 0.32e2 * t2054 * t515 * t802 + 0.81e2 / 0.4e2 * t801 * t1182 * t304 + 0.81e2 / 0.8e2 * t801 * t515 * t815 - 0.27e2 / 0.4e2 * t297 * t2644 + 0.22e2 / 0.81e2 * t2647;
  t2654 = -0.73e2 / 0.972e5 * t2580 * t325 - 0.73e2 / 0.1944e6 * t1192 * t843 - 0.73e2 / 0.1944e6 * t2079 * t531 - 0.73e2 / 0.972e5 * t825 * t1206 - 0.73e2 / 0.1944e6 * t315 * t2595 - 0.2e1 / 0.9e1 * t1151 * t283 + 0.11e2 / 0.27e2 * t500 * t781 + 0.292e3 / 0.2025e4 * t820 * t520 + 0.584e3 / 0.2025e4 * t309 * t1187 + 0.292e3 / 0.2025e4 * t82 * t2649 - 0.73e2 / 0.972e5 * t2649 * t98;
  t2655 = t531 * t831;
  t2658 = t534 * t839;
  t2671 = params->c * t266 * t114;
  t2673 = t852 * t1822 * t2015;
  t2677 = (0.3e1 / 0.16e2 * t490 * t755 - 0.17e2 / 0.512e3 * t493 * t760 + 0.39e2 / 0.32768e5 * t1144 * t770 - 0.3e1 / 0.262144e6 * t2671 * t2673) * t46;
  t2682 = t51 * t780;
  t2687 = t520 * t829;
  t2692 = t1206 * t325;
  t2695 = t531 * t843;
  t2700 = -0.73e2 / 0.2592e6 * t2090 * t2655 + 0.95e3 / 0.531441e6 * t102 * t2658 + 0.3e1 / 0.32e2 * t111 * t541 * t852 + t2677 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t278 * t1158 + 0.11e2 / 0.27e2 * t47 * t2682 + t774 * t503 / 0.24e2 + 0.73e2 / 0.3888e6 * t2687 * t831 + 0.73e2 / 0.1944e6 * t2082 * t1197 + 0.73e2 / 0.1944e6 * t830 * t2692 + 0.73e2 / 0.3888e6 * t830 * t2695 + t538 * t754 / 0.6e2;
  t2701 = t2654 + t2700;
  t2704 = t1217 * t342;
  t2705 = t2704 * t344;
  t2708 = t545 * t864;
  t2709 = t2708 * t866;
  t2714 = t2119 * t101;
  t2722 = t2134 * t852 * t29;
  t2727 = t122 * t2682;
  t2730 = -t2701 * t127 * t101 - 0.4e1 / 0.9e1 * t2705 * t307 - 0.2e1 / 0.27e2 * t2709 * t841 + 0.22e2 / 0.27e2 * t1221 * t818 + t2714 * t549 / 0.12e2 + t2124 * t1204 / 0.18e2 - 0.4e1 / 0.9e1 * t1224 * t1229 + 0.2e1 / 0.27e2 * t2132 * t2722 - t867 * t2593 / 0.4e1 + 0.22e2 / 0.27e2 * t548 * t2727;
  t2731 = t2730 * t130;
  t2732 = t259 * t2731;
  t2735 = params->kappa * t1232;
  t2736 = t2735 * t349;
  t2739 = t1238 * t873;
  t2742 = t1238 * t878;
  t2745 = 0.3e1 / 0.8e1 * t1983 * t554 + t2564 / 0.4e1 + 0.3e1 / 0.4e1 * t741 * t1234 + 0.3e1 / 0.4e1 * t2568 * t1239 - t2573 + t2575 / 0.4e1 + t2578 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t2732 + 0.3e1 / 0.4e1 * t1237 * t2736 + 0.3e1 / 0.8e1 * t1237 * t2739 + 0.3e1 / 0.8e1 * t1237 * t2742;
  t2746 = my_piecewise3(t2, 0, t2745);
  tv3rho2sigma0 = t7 * t2746 + 0.2e1 * t1243;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 0] += tv3rho2sigma0;

  tv3rho2sigma1 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 1] += tv3rho2sigma1;

  t2751 = t955 * t1247;
  t2753 = t1990 * t621;
  t2755 = t393 * t2753 / 0.12e2;
  t2757 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t2262 * t622 + t2751 / 0.4e1 - t2755);
  tv3rho2sigma2 = t7 * t2757 + 0.2e1 * t1251;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 2] += tv3rho2sigma2;

  t2761 = t930 * t1136;
  t2765 = t6 * t378;
  t2772 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t2212 * t554 + t2761 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t1234 + 0.3e1 / 0.8e1 * t2765 * t1239 + t2564 / 0.8e1 - t2573 + t2575 / 0.8e1 + t2578 / 0.8e1);
  tv3rho2sigma3 = t7 * t2772 + t1243 + t1256;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 3] += tv3rho2sigma3;

  tv3rho2sigma4 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 4] += tv3rho2sigma4;

  t2776 = t999 * t1247;
  t2781 = t750 * t1354;
  t2782 = t393 * t2781;
  t2784 = t6 * t361;
  t2787 = t6 * t365;
  t2788 = t2787 * t1360;
  t2791 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t2327 * t622 + t2776 / 0.8e1 + t2751 / 0.8e1 - t2755 + 0.3e1 / 0.8e1 * t955 * t1355 + t2782 / 0.8e1 + 0.3e1 / 0.8e1 * t2784 * t1360 + t2788 / 0.8e1);
  tv3rho2sigma5 = t7 * t2791 + t1251 + t1364;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 5] += tv3rho2sigma5;

  t2798 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t2296 * t554 + t2761 / 0.4e1 - t2573);
  tv3rho2sigma6 = t7 * t2798 + 0.2e1 * t1256;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 6] += tv3rho2sigma6;

  tv3rho2sigma7 = 0.e0;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 7] += tv3rho2sigma7;

  t2806 = t6 * t389;
  t2815 = t1029 * t46;
  t2816 = t2815 * t426;
  t2818 = t1284 * t1044;
  t2820 = t574 * t2453;
  t2822 = t574 * t2456;
  t2826 = t425 * t51;
  t2827 = t1049 * t583;
  t2828 = t2827 * t438;
  t2831 = t1043 * t1303;
  t2843 = params->b * t1029;
  t2844 = t2843 * t185;
  t2846 = t1295 * t435;
  t2848 = t577 * t1061;
  t2851 = t184 * t89 * t1029;
  t2853 = -0.55e2 / 0.9e1 * t2844 + 0.1e3 / 0.27e2 * t2846 - 0.25e2 / 0.36e2 * t2848 - 0.275e3 / 0.81e2 * t2851;
  t2856 = t2815 * t51;
  t2858 = -0.11e2 / 0.12e2 * t2816 - t2818 / 0.4e1 - 0.9e1 / 0.128e3 * t2820 + 0.3e1 / 0.64e2 * t2822 - 0.3e1 / 0.8e1 * t1040 * t1289 + 0.9e1 / 0.8e1 * t2826 * t2828 - 0.3e1 / 0.4e1 * t425 * t2831 - 0.81e2 / 0.32e2 * t2462 * t583 * t1051 + 0.81e2 / 0.4e2 * t1050 * t1303 * t438 + 0.81e2 / 0.8e2 * t1050 * t583 * t1064 - 0.27e2 / 0.4e2 * t431 * t2853 + 0.22e2 / 0.81e2 * t2856;
  t2873 = params->c * t400 * t217;
  t2875 = t1101 * t1881 * t2423;
  t2879 = (0.3e1 / 0.16e2 * t558 * t1004 - 0.17e2 / 0.512e3 * t561 * t1009 + 0.39e2 / 0.32768e5 * t1265 * t1019 - 0.3e1 / 0.262144e6 * t2873 * t2875) * t46;
  t2884 = t51 * t1029;
  t2887 = t599 * t1080;
  t2890 = t602 * t1088;
  t2895 = 0.292e3 / 0.2025e4 * t1069 * t588 + 0.584e3 / 0.2025e4 * t443 * t1308 + 0.292e3 / 0.2025e4 * t195 * t2858 - 0.73e2 / 0.972e5 * t2858 * t207 + 0.3e1 / 0.32e2 * t111 * t609 * t1101 + t2879 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t412 * t1279 + 0.11e2 / 0.27e2 * t165 * t2884 - 0.73e2 / 0.2592e6 * t2498 * t2887 + 0.95e3 / 0.531441e6 * t102 * t2890 + t1023 * t571 / 0.24e2;
  t2896 = t588 * t1078;
  t2901 = t1327 * t459;
  t2904 = t599 * t1092;
  t2909 = t1308 * t448;
  t2918 = sigma[2] * t562;
  t2922 = t89 * sigma[2] * t1088;
  t2924 = 0.1944e4 * t2918 * t153 + 0.304e5 / 0.9e1 * t2922;
  t2931 = 0.73e2 / 0.3888e6 * t2896 * t1080 + 0.73e2 / 0.1944e6 * t2490 * t1318 + 0.73e2 / 0.1944e6 * t1079 * t2901 + 0.73e2 / 0.3888e6 * t1079 * t2904 + t606 * t1003 / 0.6e2 - 0.73e2 / 0.972e5 * t2909 * t459 - 0.73e2 / 0.1944e6 * t1313 * t1092 - 0.73e2 / 0.1944e6 * t2487 * t599 - 0.73e2 / 0.972e5 * t1074 * t1327 - 0.73e2 / 0.1944e6 * t449 * t2924 - 0.2e1 / 0.9e1 * t1272 * t417 + 0.11e2 / 0.27e2 * t568 * t1030;
  t2932 = t2895 + t2931;
  t2935 = t1338 * t476;
  t2936 = t2935 * t344;
  t2939 = t613 * t1113;
  t2940 = t2939 * t866;
  t2945 = t2527 * t101;
  t2953 = t2134 * t1101 * t148;
  t2958 = t122 * t2884;
  t2961 = -t2932 * t229 * t101 - 0.4e1 / 0.9e1 * t2936 * t441 - 0.2e1 / 0.27e2 * t2940 * t1090 + 0.22e2 / 0.27e2 * t1342 * t1067 + t2945 * t617 / 0.12e2 + t2532 * t1325 / 0.18e2 - 0.4e1 / 0.9e1 * t1345 * t1350 + 0.2e1 / 0.27e2 * t2540 * t2953 - t1115 * t2922 / 0.4e1 + 0.22e2 / 0.27e2 * t616 * t2958;
  t2962 = t2961 * t232;
  t2963 = t259 * t2962;
  t2966 = params->kappa * t1353;
  t2967 = t2966 * t482;
  t2970 = t1359 * t1121;
  t2973 = t1359 * t1126;
  t2976 = 0.3e1 / 0.8e1 * t2554 * t622 + t2776 / 0.4e1 + 0.3e1 / 0.4e1 * t999 * t1355 + 0.3e1 / 0.4e1 * t2806 * t1360 - t2755 + t2782 / 0.4e1 + t2788 / 0.4e1 + 0.3e1 / 0.8e1 * t393 * t2963 + 0.3e1 / 0.4e1 * t1358 * t2967 + 0.3e1 / 0.8e1 * t1358 * t2970 + 0.3e1 / 0.8e1 * t1358 * t2973;
  t2977 = my_piecewise3(t138, 0, t2976);
  tv3rho2sigma8 = t7 * t2977 + 0.2e1 * t1364;

  if(out->v3rho2sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2sigma[ip*p->dim.v3rho2sigma + 8] += tv3rho2sigma8;

  tv3rho2lapl0 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 0] += tv3rho2lapl0;

  tv3rho2lapl1 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 1] += tv3rho2lapl1;

  tv3rho2lapl2 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 2] += tv3rho2lapl2;

  tv3rho2lapl3 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 3] += tv3rho2lapl3;

  tv3rho2lapl4 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 4] += tv3rho2lapl4;

  tv3rho2lapl5 = 0.e0;

  if(out->v3rho2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2lapl[ip*p->dim.v3rho2lapl + 5] += tv3rho2lapl5;

  t2980 = t665 * t864;
  t2981 = t258 * t2980;
  t2983 = t130 * params->e * t86;
  t2984 = t2983 * t846;
  t2987 = t1441 * t878;
  t2994 = t253 * t1429;
  t2995 = t2994 * t666;
  t2996 = t258 * t2995;
  t2998 = t494 * t627;
  t2999 = t2998 * t41;
  t3003 = t758 * t633 * t273;
  t3007 = t117 * t1381 * t769;
  t3011 = 0.1e1 / t1821 / tau[0];
  t3013 = t852 * t3011 * t2015;
  t3017 = (-0.3e1 / 0.16e2 * t30 * t2999 + 0.17e2 / 0.512e3 * t267 * t3003 - 0.39e2 / 0.32768e5 * t764 * t3007 + 0.3e1 / 0.262144e6 * t2010 * t3013) * t46;
  t3036 = t800 * t651;
  t3037 = t3036 * t304;
  t3040 = t794 * t1407;
  t3057 = 0.2e3 / 0.9e1 * t1175 - 0.5e3 / 0.27e2 * t1177 + 0.5e2 / 0.9e1 * t645 * t812 + 0.1e4 / 0.81e2 * t1180;
  t3060 = 0.1e2 / 0.3e1 * t1164 + 0.5e1 / 0.4e1 * t1166 + 0.9e1 / 0.16e2 * t642 * t2045 - 0.3e1 / 0.8e1 * t642 * t2048 - 0.3e1 / 0.8e1 * t791 * t1397 + 0.9e1 / 0.8e1 * t2617 * t3037 - 0.3e1 / 0.4e1 * t291 * t3040 - 0.81e2 / 0.32e2 * t2054 * t651 * t802 + 0.81e2 / 0.4e2 * t801 * t1407 * t304 + 0.81e2 / 0.8e2 * t801 * t651 * t815 - 0.27e2 / 0.4e2 * t297 * t3057;
  t3065 = t1410 * t314;
  t3068 = t654 * t829;
  t3075 = t2082 * t29;
  t3080 = t2090 * t29;
  t3081 = t628 * t831;
  t3084 = t1372 * t325;
  t3087 = t628 * t843;
  t3090 = t834 * t627;
  t3095 = t3017 * t57 / 0.24e2 - 0.2e1 / 0.9e1 * t1387 * t283 + 0.11e2 / 0.27e2 * t639 * t781 + 0.292e3 / 0.2025e4 * t820 * t654 + 0.584e3 / 0.2025e4 * t309 * t1410 + 0.292e3 / 0.2025e4 * t82 * t3060 - 0.73e2 / 0.972e5 * t3060 * t98 - 0.73e2 / 0.972e5 * t3065 * t325 + 0.73e2 / 0.3888e6 * t3068 * t831 - 0.73e2 / 0.1944e6 * t1415 * t843 + 0.73e2 / 0.6e3 * t2079 * t659 - 0.73e2 / 0.6e3 * t3075 * t1421 - 0.73e2 / 0.15e3 * t825 * t1424 + 0.73e2 / 0.8e3 * t3080 * t3081 + 0.73e2 / 0.3e3 * t1420 * t3084 - 0.73e2 / 0.12e4 * t1420 * t3087 + 0.73e2 / 0.1e3 * t315 * t3090 - t108 * t2998 / 0.6e2;
  t3096 = t27 * t3095;
  t3097 = t3096 * t666;
  t3100 = t2577 * t1442;
  t3102 = t1429 * t127;
  t3103 = t3102 * t349;
  t3106 = t1441 * t873;
  t3109 = t741 * t1369;
  t3113 = t745 * t664;
  t3114 = t3113 * t666;
  t3116 = t258 * t3114 / 0.12e2;
  t3117 = t1437 * t781;
  t3120 = t349 * t107;
  t3121 = t3120 * t307;
  t3124 = t741 * t1434;
  t3127 = t1368 * t342;
  t3128 = t258 * t3127;
  t3129 = t3128 * t1438;
  t3131 = t1430 * t342;
  t3132 = t258 * t3131;
  t3135 = -t2981 * t2984 / 0.36e2 - 0.3e1 / 0.8e1 * t1237 * t2987 - 0.3e1 / 0.8e1 * t1983 * t667 - 0.3e1 / 0.4e1 * t741 * t1431 - t2996 / 0.4e1 - 0.3e1 / 0.8e1 * t258 * t3097 - t3100 / 0.4e1 - 0.3e1 / 0.4e1 * t1237 * t3103 - 0.3e1 / 0.8e1 * t1237 * t3106 - t3109 / 0.4e1 - 0.3e1 / 0.4e1 * t2568 * t1442 + t3116 + 0.11e2 / 0.36e2 * t1435 * t3117 - t1435 * t3121 / 0.6e1 - t3124 * t1438 / 0.6e1 - t3129 / 0.18e2 - t3132 * t1438 / 0.6e1;
  t3136 = my_piecewise3(t2, 0, t3135);
  tv3rho2tau0 = t7 * t3136 + 0.2e1 * t1446;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 0] += tv3rho2tau0;

  t3141 = t955 * t1451;
  t3143 = t745 * t709;
  t3144 = t3143 * t711;
  t3146 = t393 * t3144 / 0.12e2;
  t3148 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2262 * t712 - t3141 / 0.4e1 + t3146);
  tv3rho2tau1 = t7 * t3148 + 0.2e1 * t1455;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 1] += tv3rho2tau1;

  t3152 = t930 * t1369;
  t3156 = t930 * t1434;
  t3166 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2212 * t667 - t3152 / 0.8e1 - 0.3e1 / 0.8e1 * t930 * t1431 - t3156 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t2765 * t1442 - t3109 / 0.8e1 + t3116 - t2996 / 0.8e1 - t3129 / 0.36e2 - t3100 / 0.8e1);
  tv3rho2tau2 = t7 * t3166 + t1446 + t1460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 2] += tv3rho2tau2;

  t3170 = t999 * t1451;
  t3175 = t253 * t1521;
  t3176 = t3175 * t711;
  t3177 = t393 * t3176;
  t3179 = t955 * t1526;
  t3182 = t1450 * t476;
  t3183 = t393 * t3182;
  t3184 = t3183 * t1530;
  t3188 = t2787 * t1534;
  t3191 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2327 * t712 - t3170 / 0.8e1 - t3141 / 0.8e1 + t3146 - 0.3e1 / 0.8e1 * t955 * t1523 - t3177 / 0.8e1 - t3179 * t1530 / 0.12e2 - t3184 / 0.36e2 - 0.3e1 / 0.8e1 * t2784 * t1534 - t3188 / 0.8e1);
  tv3rho2tau3 = t7 * t3191 + t1455 + t1538;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 3] += tv3rho2tau3;

  t3198 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2296 * t667 - t3152 / 0.4e1 + t3116);
  tv3rho2tau4 = t7 * t3198 + 0.2e1 * t1460;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 4] += tv3rho2tau4;

  t3203 = t1521 * t229;
  t3204 = t3203 * t482;
  t3207 = t1533 * t1121;
  t3212 = t710 * t1113;
  t3213 = t393 * t3212;
  t3215 = t232 * params->e * t86;
  t3216 = t3215 * t1095;
  t3219 = t999 * t1526;
  t3222 = t1522 * t476;
  t3223 = t393 * t3222;
  t3226 = t1533 * t1126;
  t3234 = t562 * t672;
  t3235 = t3234 * t160;
  t3239 = t1007 * t678 * t407;
  t3243 = t220 * t1473 * t1018;
  t3247 = 0.1e1 / t1880 / tau[1];
  t3249 = t1101 * t3247 * t2423;
  t3253 = (-0.3e1 / 0.16e2 * t149 * t3235 + 0.17e2 / 0.512e3 * t401 * t3239 - 0.39e2 / 0.32768e5 * t1013 * t3243 + 0.3e1 / 0.262144e6 * t2418 * t3249) * t46;
  t3272 = t1049 * t696;
  t3273 = t3272 * t438;
  t3276 = t1043 * t1499;
  t3293 = 0.2e3 / 0.9e1 * t1296 - 0.5e3 / 0.27e2 * t1298 + 0.5e2 / 0.9e1 * t690 * t1061 + 0.1e4 / 0.81e2 * t1301;
  t3296 = 0.1e2 / 0.3e1 * t1285 + 0.5e1 / 0.4e1 * t1287 + 0.9e1 / 0.16e2 * t687 * t2453 - 0.3e1 / 0.8e1 * t687 * t2456 - 0.3e1 / 0.8e1 * t1040 * t1489 + 0.9e1 / 0.8e1 * t2826 * t3273 - 0.3e1 / 0.4e1 * t425 * t3276 - 0.81e2 / 0.32e2 * t2462 * t696 * t1051 + 0.81e2 / 0.4e2 * t1050 * t1499 * t438 + 0.81e2 / 0.8e2 * t1050 * t696 * t1064 - 0.27e2 / 0.4e2 * t431 * t3293;
  t3301 = t1502 * t448;
  t3304 = t699 * t1078;
  t3311 = t2490 * t148;
  t3316 = t2498 * t148;
  t3317 = t673 * t1080;
  t3320 = t1464 * t459;
  t3323 = t673 * t1092;
  t3326 = t1083 * t672;
  t3331 = t3253 * t171 / 0.24e2 - 0.2e1 / 0.9e1 * t1479 * t417 + 0.11e2 / 0.27e2 * t684 * t1030 + 0.292e3 / 0.2025e4 * t1069 * t699 + 0.584e3 / 0.2025e4 * t443 * t1502 + 0.292e3 / 0.2025e4 * t195 * t3296 - 0.73e2 / 0.972e5 * t3296 * t207 - 0.73e2 / 0.972e5 * t3301 * t459 + 0.73e2 / 0.3888e6 * t3304 * t1080 - 0.73e2 / 0.1944e6 * t1507 * t1092 + 0.73e2 / 0.6e3 * t2487 * t704 - 0.73e2 / 0.6e3 * t3311 * t1513 - 0.73e2 / 0.15e3 * t1074 * t1516 + 0.73e2 / 0.8e3 * t3316 * t3317 + 0.73e2 / 0.3e3 * t1512 * t3320 - 0.73e2 / 0.12e4 * t1512 * t3323 + 0.73e2 / 0.1e3 * t449 * t3326 - t214 * t3234 / 0.6e2;
  t3332 = t27 * t3331;
  t3333 = t3332 * t711;
  t3336 = t1529 * t1030;
  t3339 = t482 * t107;
  t3340 = t3339 * t441;
  t3344 = -0.3e1 / 0.4e1 * t2806 * t1534 - 0.3e1 / 0.4e1 * t1358 * t3204 - 0.3e1 / 0.8e1 * t1358 * t3207 - t3170 / 0.4e1 - t3177 / 0.4e1 - t3213 * t3216 / 0.36e2 - t3219 * t1530 / 0.6e1 - t3223 * t1530 / 0.6e1 - 0.3e1 / 0.8e1 * t1358 * t3226 - t3188 / 0.4e1 - 0.3e1 / 0.8e1 * t2554 * t712 - 0.3e1 / 0.4e1 * t999 * t1523 - 0.3e1 / 0.8e1 * t393 * t3333 + t3146 + 0.11e2 / 0.36e2 * t1527 * t3336 - t1527 * t3340 / 0.6e1 - t3184 / 0.18e2;
  t3345 = my_piecewise3(t138, 0, t3344);
  tv3rho2tau5 = t7 * t3345 + 0.2e1 * t1538;

  if(out->v3rho2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rho2tau[ip*p->dim.v3rho2tau + 5] += tv3rho2tau5;

  t3349 = t750 * t1604;
  t3351 = t258 * t3349 / 0.8e1;
  t3352 = params->c * t261;
  t3355 = params->c * t268;
  t3356 = t270 * t273;
  t3357 = t3356 * t29;
  t3363 = t334 * t1822 * t2015;
  t3367 = (-t3352 * t1541 / 0.16e2 + 0.11e2 / 0.512e3 * t3355 * t3357 - 0.33e2 / 0.32768e5 * t267 * t1147 + 0.3e1 / 0.262144e6 * t764 * t3363) * t46;
  t3380 = t1163 * t1168;
  t3382 = t518 * t2619;
  t3384 = t506 * t2622;
  t3386 = t2044 * t1560;
  t3395 = t290 * t113;
  t3396 = t296 * params->b;
  t3397 = t3396 * t93;
  t3398 = t3395 * t3397;
  t3400 = t801 * params->b;
  t3401 = t93 * t86;
  t3402 = t88 * t304;
  t3403 = t3401 * t3402;
  t3404 = t3400 * t3403;
  t3406 = t89 * t321;
  t3407 = t1563 * t3406;
  t3409 = -t3380 / 0.4e1 - 0.9e1 / 0.64e2 * t3382 + 0.3e1 / 0.32e2 * t3384 + 0.9e1 / 0.16e2 * t291 * t3386 - 0.81e2 / 0.32e2 * t2054 * t1560 * t304 + 0.81e2 / 0.4e2 * t801 * t515 * t1182 - 0.25e2 / 0.128e3 * t3398 + 0.45e2 / 0.512e3 * t3404 + 0.5e1 / 0.16e2 * t3407;
  t3414 = t1567 * t314;
  t3426 = t1574 * t325;
  t3429 = t531 * t1206;
  t3434 = t1579 * t325;
  t3439 = -0.648e3 * t262 - 0.16e4 / 0.3e1 * t3406;
  t3442 = t88 * t321;
  t3445 = t107 * t261;
  t3451 = 0.73e2 / 0.1944e6 * t2687 * t1197 - 0.73e2 / 0.972e5 * t1192 * t1206 + 0.73e2 / 0.3888e6 * t2082 * t1574 - 0.73e2 / 0.2592e6 * t2090 * t3426 + 0.73e2 / 0.1944e6 * t830 * t3429 - 0.73e2 / 0.1944e6 * t825 * t1579 + 0.73e2 / 0.3888e6 * t830 * t3434 - 0.73e2 / 0.1944e6 * t315 * t3439 - 0.5e2 / 0.177147e6 * t102 * t3442 - t3445 * t34 / 0.18e3 - t111 * t1588 * t334 / 0.48e2;
  t3452 = t3367 * t57 / 0.24e2 - t1551 * t283 / 0.9e1 + t1151 * t503 / 0.12e2 - 0.2e1 / 0.9e1 * t500 * t1158 + 0.584e3 / 0.2025e4 * t520 * t1187 + 0.292e3 / 0.2025e4 * t309 * t1567 + 0.292e3 / 0.2025e4 * t82 * t3409 - 0.73e2 / 0.972e5 * t3409 * t98 - 0.73e2 / 0.1944e6 * t3414 * t325 - 0.73e2 / 0.972e5 * t2580 * t531 + t3451;
  t3455 = t1592 * t342;
  t3456 = t3455 * t344;
  t3459 = t2704 * t101;
  t3466 = t2123 * t101;
  t3470 = t2134 * t334 * sigma[0];
  t3473 = t1599 * t3442;
  t3476 = -t3452 * t127 * t101 - 0.2e1 / 0.9e1 * t3456 * t307 + t3459 * t549 / 0.6e1 + t2709 * t1204 / 0.18e2 - 0.4e1 / 0.9e1 * t1595 * t1229 - t3466 * t1600 / 0.96e2 - t2132 * t3470 / 0.36e2 + t1598 * t3473 / 0.18e2;
  t3477 = t3476 * t130;
  t3478 = t259 * t3477;
  t3481 = params->kappa * t1603;
  t3482 = t3481 * t349;
  t3487 = t750 * t1608;
  t3489 = t258 * t3487 / 0.8e1;
  t3490 = t1238 * t1233;
  t3493 = params->kappa * t1607;
  t3494 = t3493 * t349;
  t3498 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t741 * t1605 + t3351 + 0.3e1 / 0.8e1 * t258 * t3478 + 0.3e1 / 0.8e1 * t1237 * t3482 + 0.3e1 / 0.8e1 * t741 * t1609 + t3489 + 0.3e1 / 0.4e1 * t1237 * t3490 + 0.3e1 / 0.8e1 * t1237 * t3494);
  tv3rhosigma20 = t7 * t3498 + t1613;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 0] += tv3rhosigma20;

  tv3rhosigma21 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 1] += tv3rhosigma21;

  tv3rhosigma22 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 2] += tv3rhosigma22;

  tv3rhosigma23 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 3] += tv3rhosigma23;

  tv3rhosigma24 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 4] += tv3rhosigma24;

  t3502 = t750 * t1677;
  t3504 = t393 * t3502 / 0.8e1;
  t3507 = t750 * t1681;
  t3509 = t393 * t3507 / 0.8e1;
  t3511 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t1678 + t3504 + 0.3e1 / 0.8e1 * t955 * t1682 + t3509);
  tv3rhosigma25 = t7 * t3511 + t1686;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 5] += tv3rhosigma25;

  t3518 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t1605 + t3351 + 0.3e1 / 0.8e1 * t930 * t1609 + t3489);
  tv3rhosigma26 = t7 * t3518 + t1613;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 6] += tv3rhosigma26;

  tv3rhosigma27 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 7] += tv3rhosigma27;

  tv3rhosigma28 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 8] += tv3rhosigma28;

  tv3rhosigma29 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 9] += tv3rhosigma29;

  tv3rhosigma210 = 0.e0;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 10] += tv3rhosigma210;

  t3522 = params->c * t395;
  t3525 = params->c * t402;
  t3526 = t404 * t407;
  t3527 = t3526 * t148;
  t3533 = t468 * t1881 * t2423;
  t3537 = (-t3522 * t1615 / 0.16e2 + 0.11e2 / 0.512e3 * t3525 * t3527 - 0.33e2 / 0.32768e5 * t401 * t1268 + 0.3e1 / 0.262144e6 * t1013 * t3533) * t46;
  t3550 = t1284 * t1289;
  t3552 = t586 * t2828;
  t3554 = t574 * t2831;
  t3556 = t2452 * t1634;
  t3565 = t424 * t113;
  t3566 = t430 * params->b;
  t3567 = t3566 * t202;
  t3568 = t3565 * t3567;
  t3570 = t1050 * params->b;
  t3571 = t202 * t86;
  t3572 = t88 * t438;
  t3573 = t3571 * t3572;
  t3574 = t3570 * t3573;
  t3576 = t89 * t455;
  t3577 = t1637 * t3576;
  t3579 = -t3550 / 0.4e1 - 0.9e1 / 0.64e2 * t3552 + 0.3e1 / 0.32e2 * t3554 + 0.9e1 / 0.16e2 * t425 * t3556 - 0.81e2 / 0.32e2 * t2462 * t1634 * t438 + 0.81e2 / 0.4e2 * t1050 * t583 * t1303 - 0.25e2 / 0.128e3 * t3568 + 0.45e2 / 0.512e3 * t3574 + 0.5e1 / 0.16e2 * t3577;
  t3584 = t1641 * t448;
  t3596 = t1648 * t459;
  t3599 = t599 * t1327;
  t3604 = t1653 * t459;
  t3609 = -0.648e3 * t396 - 0.16e4 / 0.3e1 * t3576;
  t3612 = t88 * t455;
  t3615 = t107 * t395;
  t3621 = 0.73e2 / 0.1944e6 * t2896 * t1318 - 0.73e2 / 0.972e5 * t1313 * t1327 + 0.73e2 / 0.3888e6 * t2490 * t1648 - 0.73e2 / 0.2592e6 * t2498 * t3596 + 0.73e2 / 0.1944e6 * t1079 * t3599 - 0.73e2 / 0.1944e6 * t1074 * t1653 + 0.73e2 / 0.3888e6 * t1079 * t3604 - 0.73e2 / 0.1944e6 * t449 * t3609 - 0.5e2 / 0.177147e6 * t102 * t3612 - t3615 * t153 / 0.18e3 - t111 * t1662 * t468 / 0.48e2;
  t3622 = t3537 * t171 / 0.24e2 - t1625 * t417 / 0.9e1 + t1272 * t571 / 0.12e2 - 0.2e1 / 0.9e1 * t568 * t1279 + 0.584e3 / 0.2025e4 * t588 * t1308 + 0.292e3 / 0.2025e4 * t443 * t1641 + 0.292e3 / 0.2025e4 * t195 * t3579 - 0.73e2 / 0.972e5 * t3579 * t207 - 0.73e2 / 0.1944e6 * t3584 * t459 - 0.73e2 / 0.972e5 * t2909 * t599 + t3621;
  t3625 = t1666 * t476;
  t3626 = t3625 * t344;
  t3629 = t2935 * t101;
  t3636 = t2531 * t101;
  t3640 = t2134 * t468 * sigma[2];
  t3643 = t1599 * t3612;
  t3646 = -t3622 * t229 * t101 - 0.2e1 / 0.9e1 * t3626 * t441 + t3629 * t617 / 0.6e1 + t2940 * t1325 / 0.18e2 - 0.4e1 / 0.9e1 * t1669 * t1350 - t3636 * t1673 / 0.96e2 - t2540 * t3640 / 0.36e2 + t1672 * t3643 / 0.18e2;
  t3647 = t3646 * t232;
  t3648 = t259 * t3647;
  t3651 = params->kappa * t1676;
  t3652 = t3651 * t482;
  t3657 = t1359 * t1354;
  t3660 = params->kappa * t1680;
  t3661 = t3660 * t482;
  t3665 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t999 * t1678 + t3504 + 0.3e1 / 0.8e1 * t393 * t3648 + 0.3e1 / 0.8e1 * t1358 * t3652 + 0.3e1 / 0.8e1 * t999 * t1682 + t3509 + 0.3e1 / 0.4e1 * t1358 * t3657 + 0.3e1 / 0.8e1 * t1358 * t3661);
  tv3rhosigma211 = t7 * t3665 + t1686;

  if(out->v3rhosigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigma2[ip*p->dim.v3rhosigma2 + 11] += tv3rhosigma211;

  tv3rhosigmalapl0 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 0] += tv3rhosigmalapl0;

  tv3rhosigmalapl1 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 1] += tv3rhosigmalapl1;

  tv3rhosigmalapl2 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 2] += tv3rhosigmalapl2;

  tv3rhosigmalapl3 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 3] += tv3rhosigmalapl3;

  tv3rhosigmalapl4 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 4] += tv3rhosigmalapl4;

  tv3rhosigmalapl5 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 5] += tv3rhosigmalapl5;

  tv3rhosigmalapl6 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 6] += tv3rhosigmalapl6;

  tv3rhosigmalapl7 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 7] += tv3rhosigmalapl7;

  tv3rhosigmalapl8 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 8] += tv3rhosigmalapl8;

  tv3rhosigmalapl9 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 9] += tv3rhosigmalapl9;

  tv3rhosigmalapl10 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 10] += tv3rhosigmalapl10;

  tv3rhosigmalapl11 = 0.e0;

  if(out->v3rhosigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmalapl[ip*p->dim.v3rhosigmalapl + 11] += tv3rhosigmalapl11;

  t3669 = t253 * t1733;
  t3670 = t3669 * t666;
  t3672 = t258 * t3670 / 0.8e1;
  t3680 = t334 * t3011 * t2015;
  t3684 = (t490 * t1373 / 0.8e1 - 0.7e1 / 0.256e3 * t493 * t1377 + 0.9e1 / 0.8192e4 * t1144 * t1383 - 0.3e1 / 0.262144e6 * t2671 * t3680) * t46;
  t3700 = t642 * t51;
  t3705 = t1163 * t1397;
  t3707 = t518 * t3037;
  t3709 = t506 * t3040;
  t3711 = t3036 * t515;
  t3717 = t1407 * t515;
  t3720 = t651 * t1182;
  t3723 = t3396 * t1711;
  t3724 = t3395 * t3723;
  t3726 = t1712 * t3402;
  t3727 = t3400 * t3726;
  t3730 = 0.5e1 / 0.8e1 * t1558 + 0.9e1 / 0.16e2 * t3700 * t2619 - 0.3e1 / 0.8e1 * t642 * t2622 - t3705 / 0.8e1 - 0.9e1 / 0.128e3 * t3707 + 0.3e1 / 0.64e2 * t3709 + 0.9e1 / 0.16e2 * t2617 * t3711 - 0.81e2 / 0.32e2 * t2054 * t1707 * t304 + 0.81e2 / 0.8e2 * t801 * t3717 + 0.81e2 / 0.8e2 * t801 * t3720 + 0.25e2 / 0.16e2 * t3724 - 0.45e2 / 0.64e2 * t3727 - 0.65e2 / 0.32e2 * t1565;
  t3735 = t1716 * t314;
  t3742 = t3684 * t57 / 0.24e2 - t1696 * t283 / 0.9e1 + t1387 * t503 / 0.24e2 - t639 * t1158 / 0.9e1 + 0.292e3 / 0.2025e4 * t1187 * t654 + 0.292e3 / 0.2025e4 * t520 * t1410 + 0.292e3 / 0.2025e4 * t309 * t1716 + 0.292e3 / 0.2025e4 * t82 * t3730 - 0.73e2 / 0.972e5 * t3730 * t98 - 0.73e2 / 0.1944e6 * t3735 * t325 - 0.73e2 / 0.1944e6 * t3065 * t531 + 0.73e2 / 0.3888e6 * t3068 * t1197;
  t3747 = t2687 * t29;
  t3754 = t628 * t1197;
  t3757 = t1372 * t531;
  t3760 = t628 * t1206;
  t3765 = t830 * sigma[0];
  t3768 = t1200 * t627;
  t3773 = -0.73e2 / 0.1944e6 * t1415 * t1206 + 0.73e2 / 0.6e3 * t2580 * t659 - 0.73e2 / 0.12e4 * t3747 * t1421 - 0.73e2 / 0.3e3 * t1192 * t1424 - 0.73e2 / 0.12e4 * t3075 * t1725 + 0.73e2 / 0.8e3 * t3080 * t3754 + 0.73e2 / 0.6e3 * t1420 * t3757 - 0.73e2 / 0.12e4 * t1420 * t3760 + 0.73e2 / 0.3e3 * t825 * t1728 - 0.73e2 / 0.6e3 * t3765 * t1421 - 0.73e2 / 0.15e3 * t315 * t3768 + t538 * t1372 / 0.9e2;
  t3774 = t3742 + t3773;
  t3775 = t27 * t3774;
  t3776 = t3775 * t666;
  t3779 = t1734 * t342;
  t3780 = t258 * t3779;
  t3783 = t1733 * t127;
  t3784 = t3783 * t349;
  t3788 = t6 * t248 * t664;
  t3792 = t6 * t254 * t664;
  t3794 = t3792 * t1742 / 0.96e2;
  t3796 = t6 * t28 * t1429;
  t3799 = t2983 * t1209;
  t3802 = t3120 * t518;
  t3805 = t1741 * t1185;
  t3811 = t2577 * t1745 / 0.8e1;
  t3812 = t3102 * t553;
  t3815 = t553 * t107;
  t3816 = t3815 * t307;
  t3819 = t1441 * t1233;
  t3823 = t552 * t348 * t130;
  t3824 = t1441 * t3823;
  t3827 = -0.3e1 / 0.8e1 * t741 * t1735 - t3672 - 0.3e1 / 0.8e1 * t258 * t3776 - t3780 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t3784 + t3788 * t1742 / 0.32e2 + t3794 + t3796 * t1742 / 0.32e2 + t2981 * t3799 / 0.96e2 + t1435 * t3802 / 0.32e2 - t1739 * t3805 / 0.12e2 - 0.3e1 / 0.8e1 * t2568 * t1745 - t3811 - 0.3e1 / 0.8e1 * t1237 * t3812 - t1435 * t3816 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t3819 - 0.3e1 / 0.8e1 * t1237 * t3824;
  t3828 = my_piecewise3(t2, 0, t3827);
  tv3rhosigmatau0 = t7 * t3828 + t1749;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 0] += tv3rhosigmatau0;

  tv3rhosigmatau1 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 1] += tv3rhosigmatau1;

  tv3rhosigmatau2 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 2] += tv3rhosigmatau2;

  tv3rhosigmatau3 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 3] += tv3rhosigmatau3;

  tv3rhosigmatau4 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 4] += tv3rhosigmatau4;

  t3832 = t253 * t1796;
  t3833 = t3832 * t711;
  t3835 = t393 * t3833 / 0.8e1;
  t3837 = t6 * t361 * t709;
  t3841 = t6 * t365 * t709;
  t3843 = t3841 * t1805 / 0.96e2;
  t3847 = t2787 * t1808 / 0.8e1;
  t3849 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t1798 - t3835 + t3837 * t1805 / 0.32e2 + t3843 - 0.3e1 / 0.8e1 * t2784 * t1808 - t3847);
  tv3rhosigmatau5 = t7 * t3849 + t1812;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 5] += tv3rhosigmatau5;

  t3854 = t6 * t378 * t664;
  t3860 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t1735 - t3672 + t3854 * t1742 / 0.32e2 + t3794 - 0.3e1 / 0.8e1 * t2765 * t1745 - t3811);
  tv3rhosigmatau6 = t7 * t3860 + t1749;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 6] += tv3rhosigmatau6;

  tv3rhosigmatau7 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 7] += tv3rhosigmatau7;

  tv3rhosigmatau8 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 8] += tv3rhosigmatau8;

  tv3rhosigmatau9 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 9] += tv3rhosigmatau9;

  tv3rhosigmatau10 = 0.e0;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 10] += tv3rhosigmatau10;

  t3871 = t468 * t3247 * t2423;
  t3875 = (t558 * t1465 / 0.8e1 - 0.7e1 / 0.256e3 * t561 * t1469 + 0.9e1 / 0.8192e4 * t1265 * t1475 - 0.3e1 / 0.262144e6 * t2873 * t3871) * t46;
  t3891 = t687 * t51;
  t3896 = t1284 * t1489;
  t3898 = t586 * t3273;
  t3900 = t574 * t3276;
  t3902 = t3272 * t583;
  t3908 = t1499 * t583;
  t3911 = t696 * t1303;
  t3914 = t3566 * t1774;
  t3915 = t3565 * t3914;
  t3917 = t1775 * t3572;
  t3918 = t3570 * t3917;
  t3921 = 0.5e1 / 0.8e1 * t1632 + 0.9e1 / 0.16e2 * t3891 * t2828 - 0.3e1 / 0.8e1 * t687 * t2831 - t3896 / 0.8e1 - 0.9e1 / 0.128e3 * t3898 + 0.3e1 / 0.64e2 * t3900 + 0.9e1 / 0.16e2 * t2826 * t3902 - 0.81e2 / 0.32e2 * t2462 * t1770 * t438 + 0.81e2 / 0.8e2 * t1050 * t3908 + 0.81e2 / 0.8e2 * t1050 * t3911 + 0.25e2 / 0.16e2 * t3915 - 0.45e2 / 0.64e2 * t3918 - 0.65e2 / 0.32e2 * t1639;
  t3926 = t1779 * t448;
  t3933 = t3875 * t171 / 0.24e2 - t1759 * t417 / 0.9e1 + t1479 * t571 / 0.24e2 - t684 * t1279 / 0.9e1 + 0.292e3 / 0.2025e4 * t1308 * t699 + 0.292e3 / 0.2025e4 * t588 * t1502 + 0.292e3 / 0.2025e4 * t443 * t1779 + 0.292e3 / 0.2025e4 * t195 * t3921 - 0.73e2 / 0.972e5 * t3921 * t207 - 0.73e2 / 0.1944e6 * t3926 * t459 - 0.73e2 / 0.1944e6 * t3301 * t599 + 0.73e2 / 0.3888e6 * t3304 * t1318;
  t3938 = t2896 * t148;
  t3945 = t673 * t1318;
  t3948 = t1464 * t599;
  t3951 = t673 * t1327;
  t3956 = t1079 * sigma[2];
  t3959 = t1321 * t672;
  t3964 = -0.73e2 / 0.1944e6 * t1507 * t1327 + 0.73e2 / 0.6e3 * t2909 * t704 - 0.73e2 / 0.12e4 * t3938 * t1513 - 0.73e2 / 0.3e3 * t1313 * t1516 - 0.73e2 / 0.12e4 * t3311 * t1788 + 0.73e2 / 0.8e3 * t3316 * t3945 + 0.73e2 / 0.6e3 * t1512 * t3948 - 0.73e2 / 0.12e4 * t1512 * t3951 + 0.73e2 / 0.3e3 * t1074 * t1791 - 0.73e2 / 0.6e3 * t3956 * t1513 - 0.73e2 / 0.15e3 * t449 * t3959 + t606 * t1464 / 0.9e2;
  t3965 = t3933 + t3964;
  t3966 = t27 * t3965;
  t3967 = t3966 * t711;
  t3970 = t1797 * t476;
  t3971 = t393 * t3970;
  t3974 = t1796 * t229;
  t3975 = t3974 * t482;
  t3979 = t6 * t389 * t709;
  t3983 = t6 * t147 * t1521;
  t3986 = t3215 * t1330;
  t3989 = t3339 * t586;
  t3992 = t1804 * t1306;
  t3997 = t3203 * t621;
  t4000 = t621 * t107;
  t4001 = t4000 * t441;
  t4004 = t1533 * t1354;
  t4008 = t620 * t481 * t232;
  t4009 = t1533 * t4008;
  t4012 = -0.3e1 / 0.8e1 * t999 * t1798 - t3835 - 0.3e1 / 0.8e1 * t393 * t3967 - t3971 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t3975 + t3979 * t1805 / 0.32e2 + t3843 + t3983 * t1805 / 0.32e2 + t3213 * t3986 / 0.96e2 + t1527 * t3989 / 0.32e2 - t1802 * t3992 / 0.12e2 - 0.3e1 / 0.8e1 * t2806 * t1808 - t3847 - 0.3e1 / 0.8e1 * t1358 * t3997 - t1527 * t4001 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t4004 - 0.3e1 / 0.8e1 * t1358 * t4009;
  t4013 = my_piecewise3(t138, 0, t4012);
  tv3rhosigmatau11 = t7 * t4013 + t1812;

  if(out->v3rhosigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhosigmatau[ip*p->dim.v3rhosigmatau + 11] += tv3rhosigmatau11;

  tv3rholapl20 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 0] += tv3rholapl20;

  tv3rholapl21 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 1] += tv3rholapl21;

  tv3rholapl22 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 2] += tv3rholapl22;

  tv3rholapl23 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 3] += tv3rholapl23;

  tv3rholapl24 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 4] += tv3rholapl24;

  tv3rholapl25 = 0.e0;

  if(out->v3rholapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapl2[ip*p->dim.v3rholapl2 + 5] += tv3rholapl25;

  tv3rholapltau0 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 0] += tv3rholapltau0;

  tv3rholapltau1 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 1] += tv3rholapltau1;

  tv3rholapltau2 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 2] += tv3rholapltau2;

  tv3rholapltau3 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 3] += tv3rholapltau3;

  tv3rholapltau4 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 4] += tv3rholapltau4;

  tv3rholapltau5 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 5] += tv3rholapltau5;

  tv3rholapltau6 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 6] += tv3rholapltau6;

  tv3rholapltau7 = 0.e0;

  if(out->v3rholapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rholapltau[ip*p->dim.v3rholapltau + 7] += tv3rholapltau7;

  t4017 = t253 * t1860;
  t4018 = t4017 * t666;
  t4020 = t258 * t4018 / 0.8e1;
  t4021 = t261 * t270;
  t4022 = t4021 * t41;
  t4025 = t268 * t766;
  t4026 = t4025 * t273;
  t4030 = t1145 * t1822 * t769;
  t4034 = 0.1e1 / t1821 / t33;
  t4036 = t334 * t4034 * t2015;
  t4040 = (-0.3e1 / 0.16e2 * t30 * t4022 + 0.17e2 / 0.512e3 * t267 * t4026 - 0.39e2 / 0.32768e5 * t764 * t4030 + 0.3e1 / 0.262144e6 * t2010 * t4036) * t46;
  t4054 = t2044 * t1835;
  t4063 = t3396 * t1839;
  t4066 = t1840 * t3402;
  t4070 = 0.5e1 / 0.4e1 * t1705 + 0.9e1 / 0.8e1 * t3700 * t3037 - 0.3e1 / 0.4e1 * t642 * t3040 + 0.9e1 / 0.16e2 * t291 * t4054 - 0.81e2 / 0.32e2 * t2054 * t1835 * t304 + 0.81e2 / 0.4e2 * t801 * t651 * t1407 - 0.25e2 / 0.2e1 * t3395 * t4063 + 0.45e2 / 0.8e1 * t3400 * t4066 + 0.25e2 / 0.2e1 * t1714;
  t4075 = t1844 * t314;
  t4080 = t3068 * t29;
  t4087 = t2090 * t266;
  t4088 = t1817 * t325;
  t4091 = t266 * t268;
  t4092 = t4091 * t766;
  t4097 = t1813 * t325;
  t4100 = t316 * t270;
  t4105 = t4040 * t57 / 0.24e2 - t1828 * t283 / 0.9e1 + 0.584e3 / 0.2025e4 * t654 * t1410 + 0.292e3 / 0.2025e4 * t309 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4070 - 0.73e2 / 0.972e5 * t4070 * t98 - 0.73e2 / 0.1944e6 * t4075 * t325 + 0.73e2 / 0.3e3 * t3065 * t659 - 0.73e2 / 0.6e3 * t4080 * t1421 - 0.73e2 / 0.15e3 * t1415 * t1424 + 0.1971e4 / 0.1e3 * t2082 * t1852 - 0.5913e4 / 0.2e3 * t4087 * t4088 - 0.1971e4 / 0.25e2 * t830 * t4092 - 0.73e2 / 0.2e3 * t825 * t1855 + 0.73e2 / 0.4e3 * t1420 * t4097 + 0.73e2 / 0.1e3 * t315 * t4100 - t108 * t4021 / 0.6e2;
  t4106 = t27 * t4105;
  t4107 = t4106 * t666;
  t4110 = t1861 * t342;
  t4111 = t258 * t4110;
  t4114 = t1860 * t127;
  t4115 = t4114 * t349;
  t4121 = t2577 * t1867 / 0.8e1;
  t4122 = t664 * t864;
  t4123 = t1866 * t1429;
  t4124 = t4122 * t4123;
  t4127 = t27 * t1864;
  t4128 = t4127 * t2130;
  t4129 = t258 * t4128;
  t4130 = t1866 * t107;
  t4131 = t4130 * t307;
  t4135 = t101 * t348 * t130;
  t4136 = t1865 * t4135;
  t4140 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t741 * t1862 - t4020 - 0.3e1 / 0.8e1 * t258 * t4107 - t4111 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t4115 + 0.3e1 / 0.8e1 * t2568 * t1867 + t4121 + 0.3e1 / 0.4e1 * t1237 * t4124 + t4129 * t4131 / 0.6e1 + 0.3e1 / 0.8e1 * t1237 * t4136);
  tv3rhotau20 = t7 * t4140 + t1871;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 0] += tv3rhotau20;

  tv3rhotau21 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 1] += tv3rhotau21;

  t4144 = t253 * t1919;
  t4145 = t4144 * t711;
  t4147 = t393 * t4145 / 0.8e1;
  t4151 = t2787 * t1926 / 0.8e1;
  t4153 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t1921 - t4147 + 0.3e1 / 0.8e1 * t2784 * t1926 + t4151);
  tv3rhotau22 = t7 * t4153 + t1930;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 2] += tv3rhotau22;

  t4160 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t1862 - t4020 + 0.3e1 / 0.8e1 * t2765 * t1867 + t4121);
  tv3rhotau23 = t7 * t4160 + t1871;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 3] += tv3rhotau23;

  tv3rhotau24 = 0.e0;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 4] += tv3rhotau24;

  t4164 = t395 * t404;
  t4165 = t4164 * t160;
  t4168 = t402 * t1015;
  t4169 = t4168 * t407;
  t4173 = t1266 * t1881 * t1018;
  t4177 = 0.1e1 / t1880 / t152;
  t4179 = t468 * t4177 * t2423;
  t4183 = (-0.3e1 / 0.16e2 * t149 * t4165 + 0.17e2 / 0.512e3 * t401 * t4169 - 0.39e2 / 0.32768e5 * t1013 * t4173 + 0.3e1 / 0.262144e6 * t2418 * t4179) * t46;
  t4197 = t2452 * t1894;
  t4206 = t3566 * t1898;
  t4209 = t1899 * t3572;
  t4213 = 0.5e1 / 0.4e1 * t1768 + 0.9e1 / 0.8e1 * t3891 * t3273 - 0.3e1 / 0.4e1 * t687 * t3276 + 0.9e1 / 0.16e2 * t425 * t4197 - 0.81e2 / 0.32e2 * t2462 * t1894 * t438 + 0.81e2 / 0.4e2 * t1050 * t696 * t1499 - 0.25e2 / 0.2e1 * t3565 * t4206 + 0.45e2 / 0.8e1 * t3570 * t4209 + 0.25e2 / 0.2e1 * t1777;
  t4218 = t1903 * t448;
  t4223 = t3304 * t148;
  t4230 = t2498 * t400;
  t4231 = t1876 * t459;
  t4234 = t400 * t402;
  t4235 = t4234 * t1015;
  t4240 = t1872 * t459;
  t4243 = t450 * t404;
  t4248 = t4183 * t171 / 0.24e2 - t1887 * t417 / 0.9e1 + 0.584e3 / 0.2025e4 * t699 * t1502 + 0.292e3 / 0.2025e4 * t443 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4213 - 0.73e2 / 0.972e5 * t4213 * t207 - 0.73e2 / 0.1944e6 * t4218 * t459 + 0.73e2 / 0.3e3 * t3301 * t704 - 0.73e2 / 0.6e3 * t4223 * t1513 - 0.73e2 / 0.15e3 * t1507 * t1516 + 0.1971e4 / 0.1e3 * t2490 * t1911 - 0.5913e4 / 0.2e3 * t4230 * t4231 - 0.1971e4 / 0.25e2 * t1079 * t4235 - 0.73e2 / 0.2e3 * t1074 * t1914 + 0.73e2 / 0.4e3 * t1512 * t4240 + 0.73e2 / 0.1e3 * t449 * t4243 - t214 * t4164 / 0.6e2;
  t4249 = t27 * t4248;
  t4250 = t4249 * t711;
  t4253 = t1920 * t476;
  t4254 = t393 * t4253;
  t4257 = t1919 * t229;
  t4258 = t4257 * t482;
  t4263 = t709 * t1113;
  t4264 = t1925 * t1521;
  t4265 = t4263 * t4264;
  t4268 = t27 * t1923;
  t4269 = t4268 * t2538;
  t4270 = t393 * t4269;
  t4271 = t1925 * t107;
  t4272 = t4271 * t441;
  t4276 = t101 * t481 * t232;
  t4277 = t1924 * t4276;
  t4281 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t999 * t1921 - t4147 - 0.3e1 / 0.8e1 * t393 * t4250 - t4254 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t4258 + 0.3e1 / 0.8e1 * t2806 * t1926 + t4151 + 0.3e1 / 0.4e1 * t1358 * t4265 + t4270 * t4272 / 0.6e1 + 0.3e1 / 0.8e1 * t1358 * t4277);
  tv3rhotau25 = t7 * t4281 + t1930;

  if(out->v3rhotau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3rhotau2[ip*p->dim.v3rhotau2 + 5] += tv3rhotau25;

  t4283 = params->c * t494;
  t4284 = t3356 * sigma[0];
  t4289 = t117 * t1822;
  t4290 = t4289 * t2015;
  t4294 = (-0.3e1 / 0.256e3 * t4283 * t4284 + 0.27e2 / 0.32768e5 * t493 * t1547 - 0.3e1 / 0.262144e6 * t1144 * t4290) * t46;
  t4301 = t506 * t3386;
  t4303 = t117 * t113;
  t4304 = t4303 * t3396;
  t4306 = t1560 * t515;
  t4309 = t801 * t515;
  t4310 = params->b * t93;
  t4311 = t4310 * t89;
  t4312 = t4309 * t4311;
  t4314 = -0.27e2 / 0.128e3 * t4301 + 0.75e2 / 0.1024e4 * t4304 - 0.81e2 / 0.32e2 * t2054 * t4306 + 0.135e3 / 0.512e3 * t4312;
  t4325 = t1574 * t531;
  t4328 = t531 * t1579;
  t4333 = t4294 * t57 / 0.24e2 + t1551 * t503 / 0.8e1 + 0.292e3 / 0.675e3 * t520 * t1567 + 0.292e3 / 0.2025e4 * t82 * t4314 - 0.73e2 / 0.972e5 * t4314 * t98 - 0.73e2 / 0.648e5 * t3414 * t531 + 0.73e2 / 0.1296e6 * t2687 * t1574 - 0.73e2 / 0.648e5 * t1192 * t1579 - 0.73e2 / 0.2592e6 * t2090 * t4325 + 0.73e2 / 0.1296e6 * t830 * t4328 + t111 * t4303 / 0.384e3;
  t4336 = t3455 * t101;
  t4339 = t2708 * t101;
  t4342 = t2134 * t117;
  t4345 = -t4333 * t127 * t101 + t4336 * t549 / 0.4e1 - t4339 * t1600 / 0.32e2 + t2132 * t4342 / 0.96e2;
  t4346 = t4345 * t130;
  t4347 = t259 * t4346;
  t4350 = t3481 * t553;
  t4353 = t1607 * t552;
  t4354 = t4353 * t130;
  t4355 = t259 * t4354;
  t4359 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t4347 + 0.9e1 / 0.8e1 * t1237 * t4350 + 0.3e1 / 0.8e1 * t258 * t4355);
  tv3sigma30 = t7 * t4359;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 0] += tv3sigma30;

  tv3sigma31 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 1] += tv3sigma31;

  tv3sigma32 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 2] += tv3sigma32;

  tv3sigma33 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 3] += tv3sigma33;

  tv3sigma34 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 4] += tv3sigma34;

  tv3sigma35 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 5] += tv3sigma35;

  tv3sigma36 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 6] += tv3sigma36;

  tv3sigma37 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 7] += tv3sigma37;

  tv3sigma38 = 0.e0;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 8] += tv3sigma38;

  t4360 = params->c * t562;
  t4361 = t3526 * sigma[2];
  t4366 = t220 * t1881;
  t4367 = t4366 * t2423;
  t4371 = (-0.3e1 / 0.256e3 * t4360 * t4361 + 0.27e2 / 0.32768e5 * t561 * t1621 - 0.3e1 / 0.262144e6 * t1265 * t4367) * t46;
  t4378 = t574 * t3556;
  t4380 = t220 * t113;
  t4381 = t4380 * t3566;
  t4383 = t1634 * t583;
  t4386 = t1050 * t583;
  t4387 = params->b * t202;
  t4388 = t4387 * t89;
  t4389 = t4386 * t4388;
  t4391 = -0.27e2 / 0.128e3 * t4378 + 0.75e2 / 0.1024e4 * t4381 - 0.81e2 / 0.32e2 * t2462 * t4383 + 0.135e3 / 0.512e3 * t4389;
  t4402 = t1648 * t599;
  t4405 = t599 * t1653;
  t4410 = t4371 * t171 / 0.24e2 + t1625 * t571 / 0.8e1 + 0.292e3 / 0.675e3 * t588 * t1641 + 0.292e3 / 0.2025e4 * t195 * t4391 - 0.73e2 / 0.972e5 * t4391 * t207 - 0.73e2 / 0.648e5 * t3584 * t599 + 0.73e2 / 0.1296e6 * t2896 * t1648 - 0.73e2 / 0.648e5 * t1313 * t1653 - 0.73e2 / 0.2592e6 * t2498 * t4402 + 0.73e2 / 0.1296e6 * t1079 * t4405 + t111 * t4380 / 0.384e3;
  t4413 = t3625 * t101;
  t4416 = t2939 * t101;
  t4419 = t2134 * t220;
  t4422 = -t4410 * t229 * t101 + t4413 * t617 / 0.4e1 - t4416 * t1673 / 0.32e2 + t2540 * t4419 / 0.96e2;
  t4423 = t4422 * t232;
  t4424 = t259 * t4423;
  t4427 = t3651 * t621;
  t4430 = t1680 * t620;
  t4431 = t4430 * t232;
  t4432 = t259 * t4431;
  t4436 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t4424 + 0.9e1 / 0.8e1 * t1358 * t4427 + 0.3e1 / 0.8e1 * t393 * t4432);
  tv3sigma39 = t7 * t4436;

  if(out->v3sigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma3[ip*p->dim.v3sigma3 + 9] += tv3sigma39;

  tv3sigma2lapl0 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 0] += tv3sigma2lapl0;

  tv3sigma2lapl1 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 1] += tv3sigma2lapl1;

  tv3sigma2lapl2 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 2] += tv3sigma2lapl2;

  tv3sigma2lapl3 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 3] += tv3sigma2lapl3;

  tv3sigma2lapl4 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 4] += tv3sigma2lapl4;

  tv3sigma2lapl5 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 5] += tv3sigma2lapl5;

  tv3sigma2lapl6 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 6] += tv3sigma2lapl6;

  tv3sigma2lapl7 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 7] += tv3sigma2lapl7;

  tv3sigma2lapl8 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 8] += tv3sigma2lapl8;

  tv3sigma2lapl9 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 9] += tv3sigma2lapl9;

  tv3sigma2lapl10 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 10] += tv3sigma2lapl10;

  tv3sigma2lapl11 = 0.e0;

  if(out->v3sigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2lapl[ip*p->dim.v3sigma2lapl + 11] += tv3sigma2lapl11;

  t4437 = t627 * t41;
  t4445 = t117 * t3011 * t2015;
  t4449 = (-t1540 * t4437 / 0.16e2 + 0.11e2 / 0.512e3 * t30 * t635 - 0.33e2 / 0.32768e5 * t267 * t1692 + 0.3e1 / 0.262144e6 * t764 * t4445) * t46;
  t4460 = t1145 * t113;
  t4461 = t4460 * t3396;
  t4463 = t518 * t3711;
  t4465 = t651 * t1560;
  t4468 = t88 * t515;
  t4470 = t3400 * t1712 * t4468;
  t4472 = t801 * t651;
  t4473 = t4472 * t4311;
  t4475 = 0.9e1 / 0.16e2 * t642 * t3386 - 0.75e2 / 0.128e3 * t4461 - 0.9e1 / 0.64e2 * t4463 - 0.81e2 / 0.32e2 * t2054 * t4465 - 0.45e2 / 0.32e2 * t4470 + 0.45e2 / 0.512e3 * t4473;
  t4492 = t628 * t1574;
  t4497 = t628 * t1579;
  t4504 = t4449 * t57 / 0.24e2 + t1696 * t503 / 0.12e2 + 0.292e3 / 0.2025e4 * t1567 * t654 + 0.584e3 / 0.2025e4 * t520 * t1716 + 0.292e3 / 0.2025e4 * t82 * t4475 - 0.73e2 / 0.972e5 * t4475 * t98 - 0.73e2 / 0.972e5 * t3735 * t531 + 0.73e2 / 0.3888e6 * t3068 * t1574 - 0.73e2 / 0.1944e6 * t1415 * t1579 + 0.73e2 / 0.6e3 * t3414 * t659 - 0.73e2 / 0.6e3 * t3747 * t1725 + 0.73e2 / 0.15e3 * t1192 * t1728 + 0.73e2 / 0.8e3 * t3080 * t4492 - 0.73e2 / 0.3e3 * t3765 * t1725 - 0.73e2 / 0.12e4 * t1420 * t4497 + 0.73e2 / 0.3e3 * t315 * t628 - t1585 * t627 / 0.18e3;
  t4505 = t27 * t4504;
  t4506 = t4505 * t666;
  t4510 = t6 * t28 * t1733;
  t4513 = t3783 * t553;
  t4517 = t864 * t130 * params->e;
  t4518 = t4517 * t1564;
  t4521 = t3815 * t518;
  t4524 = t1441 * t1604;
  t4527 = t1441 * t1608;
  t4531 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4506 + t4510 * t1742 / 0.16e2 - 0.3e1 / 0.4e1 * t1237 * t4513 - t1739 * t4518 / 0.256e3 + t1435 * t4521 / 0.16e2 - 0.3e1 / 0.8e1 * t1237 * t4524 - 0.3e1 / 0.8e1 * t1237 * t4527);
  tv3sigma2tau0 = t7 * t4531;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 0] += tv3sigma2tau0;

  tv3sigma2tau1 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 1] += tv3sigma2tau1;

  tv3sigma2tau2 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 2] += tv3sigma2tau2;

  tv3sigma2tau3 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 3] += tv3sigma2tau3;

  tv3sigma2tau4 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 4] += tv3sigma2tau4;

  tv3sigma2tau5 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 5] += tv3sigma2tau5;

  tv3sigma2tau6 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 6] += tv3sigma2tau6;

  tv3sigma2tau7 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 7] += tv3sigma2tau7;

  tv3sigma2tau8 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 8] += tv3sigma2tau8;

  tv3sigma2tau9 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 9] += tv3sigma2tau9;

  tv3sigma2tau10 = 0.e0;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 10] += tv3sigma2tau10;

  t4532 = t672 * t160;
  t4540 = t220 * t3247 * t2423;
  t4544 = (-t1614 * t4532 / 0.16e2 + 0.11e2 / 0.512e3 * t149 * t680 - 0.33e2 / 0.32768e5 * t401 * t1755 + 0.3e1 / 0.262144e6 * t1013 * t4540) * t46;
  t4555 = t1266 * t113;
  t4556 = t4555 * t3566;
  t4558 = t586 * t3902;
  t4560 = t696 * t1634;
  t4563 = t88 * t583;
  t4565 = t3570 * t1775 * t4563;
  t4567 = t1050 * t696;
  t4568 = t4567 * t4388;
  t4570 = 0.9e1 / 0.16e2 * t687 * t3556 - 0.75e2 / 0.128e3 * t4556 - 0.9e1 / 0.64e2 * t4558 - 0.81e2 / 0.32e2 * t2462 * t4560 - 0.45e2 / 0.32e2 * t4565 + 0.45e2 / 0.512e3 * t4568;
  t4587 = t673 * t1648;
  t4592 = t673 * t1653;
  t4599 = t4544 * t171 / 0.24e2 + t1759 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1641 * t699 + 0.584e3 / 0.2025e4 * t588 * t1779 + 0.292e3 / 0.2025e4 * t195 * t4570 - 0.73e2 / 0.972e5 * t4570 * t207 - 0.73e2 / 0.972e5 * t3926 * t599 + 0.73e2 / 0.3888e6 * t3304 * t1648 - 0.73e2 / 0.1944e6 * t1507 * t1653 + 0.73e2 / 0.6e3 * t3584 * t704 - 0.73e2 / 0.6e3 * t3938 * t1788 + 0.73e2 / 0.15e3 * t1313 * t1791 + 0.73e2 / 0.8e3 * t3316 * t4587 - 0.73e2 / 0.3e3 * t3956 * t1788 - 0.73e2 / 0.12e4 * t1512 * t4592 + 0.73e2 / 0.3e3 * t449 * t673 - t1659 * t672 / 0.18e3;
  t4600 = t27 * t4599;
  t4601 = t4600 * t711;
  t4605 = t6 * t147 * t1796;
  t4608 = t3974 * t621;
  t4612 = t1113 * t232 * params->e;
  t4613 = t4612 * t1638;
  t4616 = t4000 * t586;
  t4619 = t1533 * t1677;
  t4622 = t1533 * t1681;
  t4626 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4601 + t4605 * t1805 / 0.16e2 - 0.3e1 / 0.4e1 * t1358 * t4608 - t1802 * t4613 / 0.256e3 + t1527 * t4616 / 0.16e2 - 0.3e1 / 0.8e1 * t1358 * t4619 - 0.3e1 / 0.8e1 * t1358 * t4622);
  tv3sigma2tau11 = t7 * t4626;

  if(out->v3sigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigma2tau[ip*p->dim.v3sigma2tau + 11] += tv3sigma2tau11;

  tv3sigmalapl20 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 0] += tv3sigmalapl20;

  tv3sigmalapl21 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 1] += tv3sigmalapl21;

  tv3sigmalapl22 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 2] += tv3sigmalapl22;

  tv3sigmalapl23 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 3] += tv3sigmalapl23;

  tv3sigmalapl24 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 4] += tv3sigmalapl24;

  tv3sigmalapl25 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 5] += tv3sigmalapl25;

  tv3sigmalapl26 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 6] += tv3sigmalapl26;

  tv3sigmalapl27 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 7] += tv3sigmalapl27;

  tv3sigmalapl28 = 0.e0;

  if(out->v3sigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapl2[ip*p->dim.v3sigmalapl2 + 8] += tv3sigmalapl28;

  tv3sigmalapltau0 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 0] += tv3sigmalapltau0;

  tv3sigmalapltau1 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 1] += tv3sigmalapltau1;

  tv3sigmalapltau2 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 2] += tv3sigmalapltau2;

  tv3sigmalapltau3 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 3] += tv3sigmalapltau3;

  tv3sigmalapltau4 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 4] += tv3sigmalapltau4;

  tv3sigmalapltau5 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 5] += tv3sigmalapltau5;

  tv3sigmalapltau6 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 6] += tv3sigmalapltau6;

  tv3sigmalapltau7 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 7] += tv3sigmalapltau7;

  tv3sigmalapltau8 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 8] += tv3sigmalapltau8;

  tv3sigmalapltau9 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 9] += tv3sigmalapltau9;

  tv3sigmalapltau10 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 10] += tv3sigmalapltau10;

  tv3sigmalapltau11 = 0.e0;

  if(out->v3sigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmalapltau[ip*p->dim.v3sigmalapltau + 11] += tv3sigmalapltau11;

  t4634 = t117 * t4034 * t2015;
  t4638 = (0.3e1 / 0.16e2 * t490 * t1814 - 0.17e2 / 0.512e3 * t493 * t1818 + 0.39e2 / 0.32768e5 * t1144 * t1824 - 0.3e1 / 0.262144e6 * t2671 * t4634) * t46;
  t4649 = t758 * t113;
  t4650 = t4649 * t3396;
  t4652 = t506 * t4054;
  t4654 = t1835 * t515;
  t4657 = params->b * t1711;
  t4658 = t4657 * t89;
  t4659 = t4472 * t4658;
  t4661 = t1840 * t4468;
  t4664 = 0.9e1 / 0.8e1 * t3700 * t3711 + 0.75e2 / 0.16e2 * t4650 - 0.9e1 / 0.128e3 * t4652 - 0.81e2 / 0.32e2 * t2054 * t4654 - 0.45e2 / 0.32e2 * t4659 + 0.45e2 / 0.8e1 * t3400 * t4661;
  t4679 = t1817 * t531;
  t4682 = t114 * t494;
  t4683 = t4682 * t766;
  t4688 = t1813 * t531;
  t4691 = t525 * t270;
  t4696 = t4638 * t57 / 0.24e2 + t1828 * t503 / 0.24e2 + 0.584e3 / 0.2025e4 * t654 * t1716 + 0.292e3 / 0.2025e4 * t520 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4664 - 0.73e2 / 0.972e5 * t4664 * t98 - 0.73e2 / 0.1944e6 * t4075 * t531 + 0.73e2 / 0.3e3 * t3735 * t659 - 0.73e2 / 0.6e3 * t4080 * t1725 + 0.73e2 / 0.15e3 * t1415 * t1728 + 0.1971e4 / 0.1e3 * t2687 * t1852 - 0.5913e4 / 0.2e3 * t4087 * t4679 + 0.1971e4 / 0.25e2 * t830 * t4683 - 0.73e2 / 0.2e3 * t1192 * t1855 + 0.73e2 / 0.4e3 * t1420 * t4688 - 0.73e2 / 0.1e3 * t315 * t4691 + t538 * t1813 / 0.6e2;
  t4697 = t27 * t4696;
  t4698 = t4697 * t666;
  t4702 = t6 * t28 * t1860;
  t4705 = t4114 * t553;
  t4708 = t1866 * t1733;
  t4709 = t4122 * t4708;
  t4712 = t4130 * t518;
  t4716 = t101 * t552 * t130;
  t4717 = t1865 * t4716;
  t4721 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4698 + t4702 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t4705 + 0.3e1 / 0.4e1 * t1237 * t4709 - t4129 * t4712 / 0.16e2 + 0.3e1 / 0.8e1 * t1237 * t4717);
  tv3sigmatau20 = t7 * t4721;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 0] += tv3sigmatau20;

  tv3sigmatau21 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 1] += tv3sigmatau21;

  tv3sigmatau22 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 2] += tv3sigmatau22;

  tv3sigmatau23 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 3] += tv3sigmatau23;

  tv3sigmatau24 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 4] += tv3sigmatau24;

  tv3sigmatau25 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 5] += tv3sigmatau25;

  tv3sigmatau26 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 6] += tv3sigmatau26;

  tv3sigmatau27 = 0.e0;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 7] += tv3sigmatau27;

  t4729 = t220 * t4177 * t2423;
  t4733 = (0.3e1 / 0.16e2 * t558 * t1873 - 0.17e2 / 0.512e3 * t561 * t1877 + 0.39e2 / 0.32768e5 * t1265 * t1883 - 0.3e1 / 0.262144e6 * t2873 * t4729) * t46;
  t4744 = t1007 * t113;
  t4745 = t4744 * t3566;
  t4747 = t574 * t4197;
  t4749 = t1894 * t583;
  t4752 = params->b * t1774;
  t4753 = t4752 * t89;
  t4754 = t4567 * t4753;
  t4756 = t1899 * t4563;
  t4759 = 0.9e1 / 0.8e1 * t3891 * t3902 + 0.75e2 / 0.16e2 * t4745 - 0.9e1 / 0.128e3 * t4747 - 0.81e2 / 0.32e2 * t2462 * t4749 - 0.45e2 / 0.32e2 * t4754 + 0.45e2 / 0.8e1 * t3570 * t4756;
  t4774 = t1876 * t599;
  t4777 = t217 * t562;
  t4778 = t4777 * t1015;
  t4783 = t1872 * t599;
  t4786 = t593 * t404;
  t4791 = t4733 * t171 / 0.24e2 + t1887 * t571 / 0.24e2 + 0.584e3 / 0.2025e4 * t699 * t1779 + 0.292e3 / 0.2025e4 * t588 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4759 - 0.73e2 / 0.972e5 * t4759 * t207 - 0.73e2 / 0.1944e6 * t4218 * t599 + 0.73e2 / 0.3e3 * t3926 * t704 - 0.73e2 / 0.6e3 * t4223 * t1788 + 0.73e2 / 0.15e3 * t1507 * t1791 + 0.1971e4 / 0.1e3 * t2896 * t1911 - 0.5913e4 / 0.2e3 * t4230 * t4774 + 0.1971e4 / 0.25e2 * t1079 * t4778 - 0.73e2 / 0.2e3 * t1313 * t1914 + 0.73e2 / 0.4e3 * t1512 * t4783 - 0.73e2 / 0.1e3 * t449 * t4786 + t606 * t1872 / 0.6e2;
  t4792 = t27 * t4791;
  t4793 = t4792 * t711;
  t4797 = t6 * t147 * t1919;
  t4800 = t4257 * t621;
  t4803 = t1925 * t1796;
  t4804 = t4263 * t4803;
  t4807 = t4271 * t586;
  t4811 = t101 * t620 * t232;
  t4812 = t1924 * t4811;
  t4816 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4793 + t4797 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t4800 + 0.3e1 / 0.4e1 * t1358 * t4804 - t4270 * t4807 / 0.16e2 + 0.3e1 / 0.8e1 * t1358 * t4812);
  tv3sigmatau28 = t7 * t4816;

  if(out->v3sigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3sigmatau2[ip*p->dim.v3sigmatau2 + 8] += tv3sigmatau28;

  tv3lapl30 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 0] += tv3lapl30;

  tv3lapl31 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 1] += tv3lapl31;

  tv3lapl32 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 2] += tv3lapl32;

  tv3lapl33 = 0.e0;

  if(out->v3lapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl3[ip*p->dim.v3lapl3 + 3] += tv3lapl33;

  tv3lapl2tau0 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 0] += tv3lapl2tau0;

  tv3lapl2tau1 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 1] += tv3lapl2tau1;

  tv3lapl2tau2 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 2] += tv3lapl2tau2;

  tv3lapl2tau3 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 3] += tv3lapl2tau3;

  tv3lapl2tau4 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 4] += tv3lapl2tau4;

  tv3lapl2tau5 = 0.e0;

  if(out->v3lapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapl2tau[ip*p->dim.v3lapl2tau + 5] += tv3lapl2tau5;

  tv3lapltau20 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 0] += tv3lapltau20;

  tv3lapltau21 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 1] += tv3lapltau21;

  tv3lapltau22 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 2] += tv3lapltau22;

  tv3lapltau23 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 3] += tv3lapltau23;

  tv3lapltau24 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 4] += tv3lapltau24;

  tv3lapltau25 = 0.e0;

  if(out->v3lapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3lapltau2[ip*p->dim.v3lapltau2 + 5] += tv3lapltau25;

  t4817 = t32 * t633;
  t4818 = t4817 * t41;
  t4821 = t494 * t1381;
  t4822 = t4821 * t273;
  t4825 = t758 * t3011;
  t4826 = t4825 * t769;
  t4830 = 0.1e1 / t1821 / t626;
  t4832 = t117 * t4830 * t2015;
  t4836 = (-0.3e1 / 0.8e1 * t30 * t4818 + 0.3e1 / 0.64e2 * t267 * t4822 - 0.45e2 / 0.32768e5 * t764 * t4826 + 0.3e1 / 0.262144e6 * t2010 * t4832) * t46;
  t4843 = t268 * t113;
  t4846 = t1835 * t651;
  t4849 = params->b * t1839;
  t4850 = t4849 * t89;
  t4853 = 0.27e2 / 0.16e2 * t642 * t4054 - 0.75e2 / 0.2e1 * t4843 * t3396 - 0.81e2 / 0.32e2 * t2054 * t4846 + 0.135e3 / 0.8e1 * t4472 * t4850;
  t4864 = t763 * t758;
  t4865 = t4864 * t3011;
  t4868 = t1851 * t1381;
  t4871 = t36 * t633;
  t4876 = t4836 * t57 / 0.24e2 + 0.292e3 / 0.675e3 * t654 * t1844 + 0.292e3 / 0.2025e4 * t82 * t4853 - 0.73e2 / 0.972e5 * t4853 * t98 + 0.73e2 / 0.2e3 * t4075 * t659 + 0.5913e4 / 0.1e3 * t3068 * t1852 - 0.219e3 / 0.2e3 * t1415 * t1855 + 0.478953e6 / 0.5e2 * t2090 * t4865 - 0.17739e5 / 0.1e3 * t830 * t4868 + 0.73e2 / 0.5e2 * t315 * t4871 - t108 * t4817 / 0.3e2;
  t4877 = t27 * t4876;
  t4878 = t4877 * t666;
  t4881 = t1860 * t864;
  t4883 = t664 * t101 * t130;
  t4884 = t4881 * t4883;
  t4887 = t1864 * t664;
  t4889 = 0.1e1 / t863 / t126;
  t4890 = t4887 * t4889;
  t4891 = params->kappa * params->kappa;
  t4892 = 0.1e1 / t4891;
  t4893 = t4892 * t130;
  t4894 = t4890 * t4893;
  t4898 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t4878 + 0.9e1 / 0.8e1 * t1237 * t4884 - 0.3e1 / 0.8e1 * t1237 * t4894);
  tv3tau30 = t7 * t4898;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 0] += tv3tau30;

  tv3tau31 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 1] += tv3tau31;

  tv3tau32 = 0.e0;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 2] += tv3tau32;

  t4899 = t151 * t678;
  t4900 = t4899 * t160;
  t4903 = t562 * t1473;
  t4904 = t4903 * t407;
  t4907 = t1007 * t3247;
  t4908 = t4907 * t1018;
  t4912 = 0.1e1 / t1880 / t671;
  t4914 = t220 * t4912 * t2423;
  t4918 = (-0.3e1 / 0.8e1 * t149 * t4900 + 0.3e1 / 0.64e2 * t401 * t4904 - 0.45e2 / 0.32768e5 * t1013 * t4908 + 0.3e1 / 0.262144e6 * t2418 * t4914) * t46;
  t4925 = t402 * t113;
  t4928 = t1894 * t696;
  t4931 = params->b * t1898;
  t4932 = t4931 * t89;
  t4935 = 0.27e2 / 0.16e2 * t687 * t4197 - 0.75e2 / 0.2e1 * t4925 * t3566 - 0.81e2 / 0.32e2 * t2462 * t4928 + 0.135e3 / 0.8e1 * t4567 * t4932;
  t4946 = t1012 * t1007;
  t4947 = t4946 * t3247;
  t4950 = t1910 * t1473;
  t4953 = t155 * t678;
  t4958 = t4918 * t171 / 0.24e2 + 0.292e3 / 0.675e3 * t699 * t1903 + 0.292e3 / 0.2025e4 * t195 * t4935 - 0.73e2 / 0.972e5 * t4935 * t207 + 0.73e2 / 0.2e3 * t4218 * t704 + 0.5913e4 / 0.1e3 * t3304 * t1911 - 0.219e3 / 0.2e3 * t1507 * t1914 + 0.478953e6 / 0.5e2 * t2498 * t4947 - 0.17739e5 / 0.1e3 * t1079 * t4950 + 0.73e2 / 0.5e2 * t449 * t4953 - t214 * t4899 / 0.3e2;
  t4959 = t27 * t4958;
  t4960 = t4959 * t711;
  t4963 = t1919 * t1113;
  t4965 = t709 * t101 * t232;
  t4966 = t4963 * t4965;
  t4969 = t1923 * t709;
  t4971 = 0.1e1 / t1112 / t228;
  t4972 = t4969 * t4971;
  t4973 = t4892 * t232;
  t4974 = t4972 * t4973;
  t4978 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t4960 + 0.9e1 / 0.8e1 * t1358 * t4966 - 0.3e1 / 0.8e1 * t1358 * t4974);
  tv3tau33 = t7 * t4978;

  if(out->v3tau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_KXC))
    out->v3tau3[ip*p->dim.v3tau3 + 3] += tv3tau33;

  t4990 = t2577 * t1973;
  t4993 = t258 * t750 * t2144;
  t4996 = 0.1e1 / t53 / t333;
  t5000 = t116 * t90;
  t5001 = 0.1e1 / t5000;
  t5005 = t820 * t820;
  t5012 = 0.1e1 / t54 / t319;
  t5013 = sigma[0] * t5012;
  t5015 = 0.616e4 / 0.81e2 * tau[0] * t2028 - 0.2618e4 / 0.81e2 * t5013;
  t5025 = t51 * t2053;
  t5026 = t5025 * t2055;
  t5030 = t800 * t304 * t815;
  t5033 = t794 * t2069;
  t5036 = t798 * t798;
  t5039 = t69 / t76 / t5036;
  t5040 = t802 * t802;
  t5046 = t815 * t815;
  t5057 = t790 * t790;
  t5067 = t71 * t5013;
  t5069 = 0.3e1 / 0.4e1 * t5015 * t46 * t292 - 0.3e1 / 0.2e1 * t2039 * t795 + 0.27e2 / 0.8e1 * t791 * t2045 - 0.9e1 / 0.4e1 * t791 * t2048 - 0.45e2 / 0.8e1 * t291 * t5026 + 0.27e2 / 0.4e1 * t2617 * t5030 - 0.3e1 / 0.2e1 * t291 * t5033 + 0.567e3 / 0.64e2 * t5039 * t5040 - 0.243e3 / 0.16e2 * t2054 * t802 * t815 + 0.243e3 / 0.8e2 * t801 * t5046 + 0.81e2 / 0.2e2 * t801 * t304 * t2069 - 0.27e2 / 0.4e2 * t297 * (0.5e1 * params->b * t5015 * t72 + 0.2e3 / 0.9e1 * t2061 * t301 + 0.5e2 / 0.3e1 * params->b * t5057 * t89 + 0.25e2 / 0.9e1 * t70 * t89 * t5015) + 0.5236e4 / 0.729e3 * t5067;
  t5085 = 0.26125e6 / 0.4782969e7 * t102 * t103 * t4996 + 0.55e2 / 0.16e2 * t111 * t115 * t5001 + 0.292e3 / 0.675e3 * t5005 + 0.1168e4 / 0.2025e4 * t309 * t2074 + 0.292e3 / 0.2025e4 * t82 * t5069 - 0.73e2 / 0.972e5 * t5069 * t98 + 0.2618e4 / 0.243e3 * t47 * t52 * t5012 - 0.4e1 / 0.9e1 * t2020 * t283 + 0.22e2 / 0.9e1 * t774 * t781 - 0.616e3 / 0.81e2 * t278 * t2029 - 0.73e2 / 0.324e5 * t2079 * t843;
  t5092 = t89 * t29 * t4996;
  t5097 = t2074 * t314;
  t5100 = t843 * t843;
  t5106 = t758 * t34;
  t5109 = t820 * t829;
  t5112 = t309 * t2089;
  t5120 = t82 / t98 / t2087 / t97;
  t5121 = t831 * t831;
  t5143 = params->c * t2009 * t29;
  t5144 = t116 * t319;
  t5148 = 0.1e1 / t768 / t40;
  t5156 = -0.73e2 / 0.486e5 * t825 * t2105 - 0.73e2 / 0.1944e6 * t315 * (0.1944e5 * t29 * t758 * t34 + 0.836e7 / 0.81e2 * t5092) - 0.73e2 / 0.486e5 * t5097 * t325 + 0.73e2 / 0.1296e6 * t830 * t5100 + 0.73e2 / 0.972e5 * t830 * t325 * t2105 + t108 * t5106 / 0.6e1 + 0.73e2 / 0.648e5 * t5109 * t831 - 0.73e2 / 0.648e5 * t5112 * t2091 + 0.73e2 / 0.324e5 * t2082 * t2094 + 0.73e2 / 0.10368e6 * t5120 * t5121 - 0.73e2 / 0.432e5 * t2090 * t831 * t843 + (0.15e2 / 0.8e1 * t30 * t5106 * t41 - 0.45e2 / 0.128e3 * t267 * t117 * t270 * t273 + 0.549e3 / 0.32768e5 * t764 * t852 * t766 * t769 - 0.39e2 / 0.131072e6 * t2010 * t5001 * t1822 * t2015 + 0.15e2 / 0.8388608e7 * t5143 / t5144 * t4034 * t5148) * t46 * t57 / 0.24e2;
  t5160 = t2116 * t342;
  t5164 = t856 * t864;
  t5165 = t5164 * t866;
  t5171 = t338 * t2130 * t101;
  t5179 = params->e * params->e;
  t5180 = t101 * t5179;
  t5181 = t121 * t4889 * t5180;
  t5198 = -(t5085 + t5156) * t127 * t101 - 0.8e1 / 0.9e1 * t5160 * t344 * t307 - 0.4e1 / 0.9e1 * t5165 * t841 + 0.44e2 / 0.9e1 * t2120 * t818 - 0.64e2 / 0.81e2 * t5171 * t2136 + 0.88e2 / 0.27e2 * t2124 * t2103 - 0.1232e4 / 0.81e2 * t860 * t2072 - 0.8e2 / 0.729e3 * t5181 * t113 * t266 / t54 / t5144 * t46 * t51 + 0.352e3 / 0.81e2 * t2132 * t2134 * t114 * t5001 - 0.1958e4 / 0.243e3 * t867 * t5092 + 0.5236e4 / 0.243e3 * t345 * t5067;
  t5203 = t1942 * params->kappa;
  t5205 = t258 * t5203 * t349;
  t5207 = t6 * t1964;
  t5210 = t741 * t1969;
  t5218 = t741 * t1994;
  t5220 = 0.9e1 / 0.4e1 * t1237 * t1972 * t878 + 0.9e1 / 0.2e1 * t2568 * t1973 + 0.3e1 / 0.2e1 * t1237 * params->kappa * t2143 * t349 + 0.3e1 / 0.2e1 * t4990 + t4993 / 0.2e1 + 0.3e1 / 0.8e1 * t258 * t259 * t5198 * t130 + 0.5e1 / 0.9e1 * t5205 + 0.3e1 / 0.2e1 * t5207 * t350 + 0.3e1 / 0.2e1 * t5210 + 0.3e1 / 0.2e1 * t741 * t1978 + 0.9e1 / 0.4e1 * t1983 * t879 + 0.9e1 / 0.4e1 * t1983 * t874 + 0.3e1 / 0.2e1 * t5218;
  t5223 = t1983 * t751;
  t5225 = t741 * t1991;
  t5226 = t877 * t877;
  t5232 = t258 * t1990 * t878;
  t5235 = t258 * t750 * t1977;
  t5237 = t872 * t872;
  t5243 = t258 * t1990 * t873;
  t5247 = t6 * t732 * t745 * t133;
  t5251 = t6 * t247 * t1942 * t133;
  t5254 = 0.1e1 / t252 / t723;
  t5258 = 0.1e2 / 0.27e2 * t6 * t26 * t5254 * t133;
  t5261 = t6 * t1964 * t253 * t133;
  t5263 = t20 * t20;
  t5265 = 0.1e1 / t718 / t5263;
  t5266 = t720 * t720;
  t5272 = t728 * t728;
  t5278 = 0.1e1 / t1955 / t7;
  t5279 = t17 * t5278;
  t5282 = my_piecewise5(t11, 0, t15, 0, -0.24e2 * t1956 + 0.24e2 * t5279);
  t5286 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5265 * t5266 - 0.16e2 / 0.9e1 * t1948 * t720 * t728 + 0.4e1 / 0.3e1 * t719 * t5272 + 0.16e2 / 0.9e1 * t1952 * t1960 + 0.4e1 / 0.3e1 * t24 * t5282);
  t5291 = 0.3e1 / 0.2e1 * t741 * t2145 + 0.3e1 / 0.2e1 * t5223 - t5225 + 0.3e1 / 0.8e1 * t258 * t259 * t5226 * t130 - t5232 / 0.2e1 + t5235 / 0.2e1 + 0.9e1 / 0.8e1 * t258 * t259 * t5237 * t130 - t5243 / 0.2e1 + t5247 / 0.2e1 - 0.5e1 / 0.9e1 * t5251 + t5258 - t5261 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t5286 * t27 * t133;
  t5293 = my_piecewise3(t2, 0, t5220 + t5291);
  t5294 = t142 * t142;
  t5296 = 0.1e1 / t884 / t5294;
  t5297 = t886 * t886;
  t5303 = t892 * t892;
  t5308 = t139 * t5278;
  t5311 = my_piecewise5(t15, 0, t11, 0, 0.24e2 * t1956 + 0.24e2 * t5308);
  t5315 = my_piecewise3(t143, 0, 0.4e2 / 0.81e2 * t5296 * t5297 - 0.16e2 / 0.9e1 * t2151 * t886 * t892 + 0.4e1 / 0.3e1 * t885 * t5303 + 0.16e2 / 0.9e1 * t2155 * t2161 + 0.4e1 / 0.3e1 * t144 * t5311);
  t5322 = t6 * t2165 * t253 * t235;
  t5326 = t6 * t896 * t745 * t235;
  t5330 = t6 * t360 * t1942 * t235;
  t5335 = 0.1e2 / 0.27e2 * t6 * t146 * t5254 * t235;
  t5337 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t6 * t5315 * t27 * t235 - t5322 / 0.2e1 + t5326 / 0.2e1 - 0.5e1 / 0.9e1 * t5330 + t5335);
  tv4rho40 = 0.4e1 * t2149 + 0.4e1 * t2183 + t7 * (t5293 + t5337);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 0] += tv4rho40;

  t5345 = t930 * t1991;
  t5346 = t5345 / 0.4e1;
  t5347 = t930 * t1994;
  t5359 = t930 * t1969;
  t5363 = 0.9e1 / 0.8e1 * t2765 * t1973 + 0.3e1 / 0.8e1 * t4990 - t5346 + 0.3e1 / 0.8e1 * t5347 + 0.3e1 / 0.8e1 * t930 * t2145 + t4993 / 0.8e1 + 0.5e1 / 0.12e2 * t5205 + 0.3e1 / 0.8e1 * t5210 + 0.3e1 / 0.8e1 * t5218 + 0.3e1 / 0.8e1 * t5223 - t5225 / 0.2e1 + 0.9e1 / 0.8e1 * t2212 * t879 + 0.3e1 / 0.8e1 * t5359 + 0.3e1 / 0.8e1 * t930 * t1978;
  t5364 = t6 * t2203;
  t5367 = t2212 * t751;
  t5393 = 0.12e2 * t1956;
  t5394 = 0.24e2 * t5279;
  t5396 = my_piecewise5(t11, 0, t15, 0, -t5393 + t5394);
  t5400 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5265 * t374 * t1949 - 0.8e1 / 0.9e1 * t1948 * t917 * t720 - 0.8e1 / 0.9e1 * t2188 * t244 * t728 + 0.4e1 / 0.3e1 * t719 * t2199 * t244 + 0.4e1 / 0.3e1 * t2191 * t728 + 0.4e1 / 0.9e1 * t913 * t1960 + 0.4e1 / 0.3e1 * t24 * t5396);
  t5407 = t6 * t2203 * t253 * t133;
  t5411 = t6 * t921 * t745 * t133;
  t5412 = t5411 / 0.4e1;
  t5415 = t6 * t377 * t1942 * t133;
  t5417 = 0.9e1 / 0.8e1 * t5364 * t350 + 0.3e1 / 0.4e1 * t5367 + 0.9e1 / 0.8e1 * t2212 * t874 - t5232 / 0.4e1 + t5235 / 0.8e1 - t5243 / 0.4e1 + t5247 / 0.4e1 - 0.5e1 / 0.12e2 * t5251 + t5258 - t5261 / 0.8e1 - 0.3e1 / 0.8e1 * t6 * t5400 * t27 * t133 - 0.3e1 / 0.8e1 * t5407 + t5412 - 0.5e1 / 0.36e2 * t5415;
  t5419 = my_piecewise3(t2, 0, t5363 + t5417);
  t5436 = 0.24e2 * t5308;
  t5438 = my_piecewise5(t15, 0, t11, 0, t5393 + t5436);
  t5442 = my_piecewise3(t143, 0, 0.4e2 / 0.81e2 * t5296 * t385 * t2152 - 0.8e1 / 0.9e1 * t2151 * t941 * t886 - 0.8e1 / 0.9e1 * t2233 * t357 * t892 + 0.4e1 / 0.3e1 * t885 * t2243 * t357 + 0.4e1 / 0.3e1 * t2236 * t892 + 0.4e1 / 0.9e1 * t937 * t2161 + 0.4e1 / 0.3e1 * t144 * t5438);
  t5449 = t6 * t2247 * t253 * t235;
  t5453 = t6 * t945 * t745 * t235;
  t5454 = t5453 / 0.4e1;
  t5457 = t6 * t388 * t1942 * t235;
  t5462 = t6 * t2165;
  t5465 = t2262 * t958;
  t5467 = t955 * t2267;
  t5468 = t5467 / 0.4e1;
  t5470 = t393 * t5203 * t482;
  t5472 = -0.3e1 / 0.8e1 * t6 * t5442 * t27 * t235 - 0.3e1 / 0.8e1 * t5449 + t5454 - 0.5e1 / 0.36e2 * t5457 - t5322 / 0.8e1 + t5326 / 0.4e1 - 0.5e1 / 0.12e2 * t5330 + t5335 + 0.3e1 / 0.8e1 * t5462 * t483 + 0.3e1 / 0.8e1 * t5465 - t5468 + 0.5e1 / 0.36e2 * t5470;
  t5473 = my_piecewise3(t138, 0, t5472);
  tv4rho41 = t2149 + t2183 + 0.3e1 * t2232 + 0.3e1 * t2271 + t7 * (t5419 + t5473);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 1] += tv4rho41;

  t5488 = t917 * t917;
  t5501 = my_piecewise5(t11, 0, t15, 0, t5394);
  t5505 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5265 * t967 * t720 - 0.32e2 / 0.27e2 * t2188 * t244 * t917 - 0.8e1 / 0.27e2 * t2274 * t728 + 0.8e1 / 0.9e1 * t719 * t5488 + 0.8e1 / 0.9e1 * t913 * t2199 - 0.8e1 / 0.27e2 * t1948 * t972 * t720 + 0.8e1 / 0.9e1 * t719 * t2283 * t244 + 0.4e1 / 0.9e1 * t2279 * t728 + 0.4e1 / 0.3e1 * t24 * t5501);
  t5512 = t6 * t2287 * t253 * t133;
  t5516 = t6 * t976 * t745 * t133;
  t5528 = t6 * t2287;
  t5531 = t2296 * t751;
  t5541 = t5359 / 0.4e1 - t5232 / 0.12e2 + 0.3e1 / 0.4e1 * t5528 * t350 + t5531 / 0.4e1 + 0.3e1 / 0.8e1 * t2296 * t874 + t5367 / 0.2e1 - t5345 / 0.3e1 + t5347 / 0.4e1 - t5243 / 0.12e2 + 0.5e1 / 0.18e2 * t5205 - t5225 / 0.6e1;
  t5543 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t5505 * t27 * t133 - t5512 / 0.4e1 + t5516 / 0.12e2 - t5407 / 0.4e1 + t5411 / 0.3e1 - 0.5e1 / 0.18e2 * t5415 + t5247 / 0.12e2 - 0.5e1 / 0.18e2 * t5251 + t5258 + 0.3e1 / 0.8e1 * t2296 * t879 + t5541);
  t5545 = t393 * t1990 * t1126;
  t5555 = t941 * t941;
  t5568 = my_piecewise5(t15, 0, t11, 0, t5436);
  t5572 = my_piecewise3(t143, 0, 0.4e2 / 0.81e2 * t5296 * t984 * t886 - 0.32e2 / 0.27e2 * t2233 * t357 * t941 - 0.8e1 / 0.27e2 * t2304 * t892 + 0.8e1 / 0.9e1 * t885 * t5555 + 0.8e1 / 0.9e1 * t937 * t2243 - 0.8e1 / 0.27e2 * t2151 * t989 * t886 + 0.8e1 / 0.9e1 * t885 * t2313 * t357 + 0.4e1 / 0.9e1 * t2309 * t892 + 0.4e1 / 0.3e1 * t144 * t5568);
  t5579 = t6 * t2317 * t253 * t235;
  t5583 = t6 * t993 * t745 * t235;
  t5593 = t2327 * t958;
  t5595 = t999 * t2267;
  t5597 = t955 * t2336;
  t5600 = t393 * t1990 * t1121;
  t5602 = t955 * t2341;
  t5609 = t6 * t2247;
  t5612 = -t5467 / 0.3e1 + 0.5e1 / 0.18e2 * t5470 + t5593 / 0.2e1 - t5595 / 0.6e1 + t5597 / 0.4e1 - t5600 / 0.12e2 + t5602 / 0.4e1 + t5465 / 0.4e1 + 0.3e1 / 0.8e1 * t2262 * t1122 + 0.3e1 / 0.8e1 * t2262 * t1127 + 0.3e1 / 0.4e1 * t5609 * t483;
  t5614 = my_piecewise3(t138, 0, -t5545 / 0.12e2 - 0.3e1 / 0.8e1 * t6 * t5572 * t27 * t235 - t5579 / 0.4e1 + t5583 / 0.12e2 + t5453 / 0.3e1 - 0.5e1 / 0.18e2 * t5457 - t5449 / 0.4e1 + t5326 / 0.12e2 - 0.5e1 / 0.18e2 * t5330 + t5335 + t5612);
  tv4rho42 = 0.2e1 * t2232 + 0.2e1 * t2271 + 0.2e1 * t2303 + 0.2e1 * t2345 + t7 * (t5543 + t5614);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 2] += tv4rho42;

  t5635 = my_piecewise5(t11, 0, t15, 0, t5393 + t5394);
  t5639 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5265 * t2350 * t244 - 0.8e1 / 0.9e1 * t2274 * t917 - 0.8e1 / 0.9e1 * t2188 * t972 * t244 + 0.4e1 / 0.3e1 * t2191 * t972 + 0.4e1 / 0.3e1 * t913 * t2283 + 0.4e1 / 0.9e1 * t719 * t2357 * t244 + 0.4e1 / 0.3e1 * t24 * t5635);
  t5646 = t6 * t2361 * t253 * t133;
  t5648 = t6 * t2361;
  t5657 = -0.3e1 / 0.8e1 * t6 * t5639 * t27 * t133 - t5646 / 0.8e1 + 0.3e1 / 0.8e1 * t5648 * t350 - 0.3e1 / 0.8e1 * t5512 + t5516 / 0.4e1 + 0.3e1 / 0.8e1 * t5531 + t5412 - 0.5e1 / 0.12e2 * t5415 - t5346 - 0.5e1 / 0.36e2 * t5251 + t5258 + 0.5e1 / 0.36e2 * t5205;
  t5658 = my_piecewise3(t2, 0, t5657);
  t5659 = t2787 * t2389;
  t5671 = t6 * t2317;
  t5681 = 0.3e1 / 0.8e1 * t5659 + 0.9e1 / 0.8e1 * t2784 * t2389 - 0.3e1 / 0.8e1 * t5579 + t5583 / 0.4e1 + 0.9e1 / 0.8e1 * t2327 * t1127 + 0.9e1 / 0.8e1 * t2327 * t1122 + 0.3e1 / 0.8e1 * t955 * t2551 + 0.9e1 / 0.8e1 * t5671 * t483 + 0.3e1 / 0.8e1 * t955 * t2394 - t5545 / 0.4e1 + 0.3e1 / 0.4e1 * t5593 - t5595 / 0.2e1 + 0.3e1 / 0.8e1 * t5597 - t5600 / 0.4e1;
  t5683 = t2554 * t958;
  t5686 = t393 * t750 * t2393;
  t5688 = t999 * t2341;
  t5690 = t999 * t2336;
  t5693 = t393 * t750 * t2550;
  t5714 = my_piecewise5(t15, 0, t11, 0, -t5393 + t5436);
  t5718 = my_piecewise3(t143, 0, 0.4e2 / 0.81e2 * t5296 * t2372 * t357 - 0.8e1 / 0.9e1 * t2304 * t941 - 0.8e1 / 0.9e1 * t2233 * t989 * t357 + 0.4e1 / 0.3e1 * t2236 * t989 + 0.4e1 / 0.3e1 * t937 * t2313 + 0.4e1 / 0.9e1 * t885 * t2379 * t357 + 0.4e1 / 0.3e1 * t144 * t5714);
  t5725 = t6 * t2383 * t253 * t235;
  t5727 = 0.3e1 / 0.8e1 * t5602 + 0.3e1 / 0.8e1 * t5683 + t5686 / 0.8e1 + 0.3e1 / 0.8e1 * t5688 + 0.3e1 / 0.8e1 * t5690 + t5693 / 0.8e1 - t5468 + 0.5e1 / 0.12e2 * t5470 - 0.5e1 / 0.36e2 * t5330 + t5335 + t5454 - 0.5e1 / 0.12e2 * t5457 - 0.3e1 / 0.8e1 * t6 * t5718 * t27 * t235 - t5725 / 0.8e1;
  t5729 = my_piecewise3(t138, 0, t5681 + t5727);
  tv4rho43 = 0.3e1 * t2303 + 0.3e1 * t2345 + t2369 + t2558 + t7 * (t5658 + t5729);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 3] += tv4rho43;

  t5734 = t967 * t967;
  t5739 = t972 * t972;
  t5746 = my_piecewise5(t11, 0, t15, 0, 0.24e2 * t1956 + 0.24e2 * t5279);
  t5750 = my_piecewise3(t21, 0, 0.4e2 / 0.81e2 * t5265 * t5734 - 0.16e2 / 0.9e1 * t2274 * t972 + 0.4e1 / 0.3e1 * t719 * t5739 + 0.16e2 / 0.9e1 * t913 * t2357 + 0.4e1 / 0.3e1 * t24 * t5746);
  t5759 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t6 * t5750 * t27 * t133 - t5646 / 0.2e1 + t5516 / 0.2e1 - 0.5e1 / 0.9e1 * t5415 + t5258);
  t5771 = t1069 * t1078;
  t5774 = t443 * t2497;
  t5782 = t195 / t207 / t2495 / t206;
  t5783 = t1080 * t1080;
  t5789 = t1092 * t1092;
  t5795 = t1007 * t153;
  t5799 = 0.1e1 / t167 / t467;
  t5803 = t219 * t199;
  t5804 = 0.1e1 / t5803;
  t5824 = params->c * t2417 * t148;
  t5825 = t219 * t453;
  t5829 = 0.1e1 / t1017 / t159;
  t5837 = 0.73e2 / 0.648e5 * t5771 * t1080 - 0.73e2 / 0.648e5 * t5774 * t2499 + 0.73e2 / 0.324e5 * t2490 * t2502 + 0.73e2 / 0.10368e6 * t5782 * t5783 - 0.73e2 / 0.432e5 * t2498 * t1080 * t1092 + 0.73e2 / 0.1296e6 * t1079 * t5789 + 0.73e2 / 0.972e5 * t1079 * t459 * t2513 + t214 * t5795 / 0.6e1 + 0.26125e6 / 0.4782969e7 * t102 * t210 * t5799 + 0.55e2 / 0.16e2 * t111 * t218 * t5804 + (0.15e2 / 0.8e1 * t149 * t5795 * t160 - 0.45e2 / 0.128e3 * t401 * t220 * t404 * t407 + 0.549e3 / 0.32768e5 * t1013 * t1101 * t1015 * t1018 - 0.39e2 / 0.131072e6 * t2418 * t5804 * t1881 * t2423 + 0.15e2 / 0.8388608e7 * t5824 / t5825 * t4177 * t5829) * t46 * t171 / 0.24e2;
  t5838 = t1069 * t1069;
  t5845 = 0.1e1 / t168 / t453;
  t5846 = sigma[2] * t5845;
  t5848 = 0.616e4 / 0.81e2 * tau[1] * t2436 - 0.2618e4 / 0.81e2 * t5846;
  t5858 = t51 * t2461;
  t5859 = t5858 * t2463;
  t5863 = t1049 * t438 * t1064;
  t5866 = t1043 * t2477;
  t5869 = t1047 * t1047;
  t5872 = t183 / t189 / t5869;
  t5873 = t1051 * t1051;
  t5879 = t1064 * t1064;
  t5890 = t1039 * t1039;
  t5900 = t71 * t5846;
  t5902 = 0.3e1 / 0.4e1 * t5848 * t46 * t426 - 0.3e1 / 0.2e1 * t2447 * t1044 + 0.27e2 / 0.8e1 * t1040 * t2453 - 0.9e1 / 0.4e1 * t1040 * t2456 - 0.45e2 / 0.8e1 * t425 * t5859 + 0.27e2 / 0.4e1 * t2826 * t5863 - 0.3e1 / 0.2e1 * t425 * t5866 + 0.567e3 / 0.64e2 * t5872 * t5873 - 0.243e3 / 0.16e2 * t2462 * t1051 * t1064 + 0.243e3 / 0.8e2 * t1050 * t5879 + 0.81e2 / 0.2e2 * t1050 * t438 * t2477 - 0.27e2 / 0.4e2 * t431 * (0.5e1 * params->b * t5848 * t185 + 0.2e3 / 0.9e1 * t2469 * t435 + 0.5e2 / 0.3e1 * params->b * t5890 * t89 + 0.25e2 / 0.9e1 * t184 * t89 * t5848) + 0.5236e4 / 0.729e3 * t5900;
  t5916 = t2482 * t448;
  t5927 = t89 * t148 * t5799;
  t5932 = 0.292e3 / 0.675e3 * t5838 + 0.1168e4 / 0.2025e4 * t443 * t2482 + 0.292e3 / 0.2025e4 * t195 * t5902 - 0.73e2 / 0.972e5 * t5902 * t207 - 0.616e3 / 0.81e2 * t412 * t2437 + 0.2618e4 / 0.243e3 * t165 * t166 * t5845 - 0.4e1 / 0.9e1 * t2428 * t417 + 0.22e2 / 0.9e1 * t1023 * t1030 - 0.73e2 / 0.486e5 * t5916 * t459 - 0.73e2 / 0.324e5 * t2487 * t1092 - 0.73e2 / 0.486e5 * t1074 * t2513 - 0.73e2 / 0.1944e6 * t449 * (0.1944e5 * t148 * t1007 * t153 + 0.836e7 / 0.81e2 * t5927);
  t5936 = t2524 * t476;
  t5940 = t1105 * t1113;
  t5941 = t5940 * t866;
  t5947 = t472 * t2538 * t101;
  t5955 = t224 * t4971 * t5180;
  t5972 = -(t5837 + t5932) * t229 * t101 - 0.8e1 / 0.9e1 * t5936 * t344 * t441 - 0.4e1 / 0.9e1 * t5941 * t1090 + 0.44e2 / 0.9e1 * t2528 * t1067 - 0.64e2 / 0.81e2 * t5947 * t2542 + 0.88e2 / 0.27e2 * t2532 * t2511 - 0.1232e4 / 0.81e2 * t1109 * t2480 - 0.8e2 / 0.729e3 * t5955 * t113 * t400 / t168 / t5825 * t46 * t51 + 0.352e3 / 0.81e2 * t2540 * t2134 * t217 * t5804 - 0.1958e4 / 0.243e3 * t1115 * t5927 + 0.5236e4 / 0.243e3 * t478 * t5900;
  t5977 = t6 * t2383;
  t5988 = t1120 * t1120;
  t5993 = t1125 * t1125;
  t5998 = 0.9e1 / 0.4e1 * t1358 * t2388 * t1126 + 0.3e1 / 0.2e1 * t1358 * params->kappa * t2549 * t482 + 0.9e1 / 0.2e1 * t2806 * t2389 + 0.3e1 / 0.2e1 * t5659 + t5583 / 0.2e1 + 0.3e1 / 0.8e1 * t393 * t259 * t5972 * t232 + 0.3e1 / 0.2e1 * t5977 * t483 + 0.3e1 / 0.2e1 * t999 * t2394 + 0.9e1 / 0.4e1 * t2554 * t1127 + 0.9e1 / 0.4e1 * t2554 * t1122 + 0.3e1 / 0.2e1 * t999 * t2551 + 0.9e1 / 0.8e1 * t393 * t259 * t5988 * t232 + 0.3e1 / 0.8e1 * t393 * t259 * t5993 * t232;
  t6009 = t984 * t984;
  t6014 = t989 * t989;
  t6021 = my_piecewise5(t15, 0, t11, 0, -0.24e2 * t1956 + 0.24e2 * t5308);
  t6025 = my_piecewise3(t143, 0, 0.4e2 / 0.81e2 * t5296 * t6009 - 0.16e2 / 0.9e1 * t2304 * t989 + 0.4e1 / 0.3e1 * t885 * t6014 + 0.16e2 / 0.9e1 * t937 * t2379 + 0.4e1 / 0.3e1 * t144 * t6021);
  t6030 = -t5545 / 0.2e1 - t5595 - t5600 / 0.2e1 + 0.3e1 / 0.2e1 * t5683 + t5686 / 0.2e1 + 0.3e1 / 0.2e1 * t5688 + 0.3e1 / 0.2e1 * t5690 + t5693 / 0.2e1 + 0.5e1 / 0.9e1 * t5470 + t5335 - 0.5e1 / 0.9e1 * t5457 - t5725 / 0.2e1 - 0.3e1 / 0.8e1 * t6 * t6025 * t27 * t235;
  t6032 = my_piecewise3(t138, 0, t5998 + t6030);
  tv4rho44 = 0.4e1 * t2369 + 0.4e1 * t2558 + t7 * (t5759 + t6032);

  if(out->v4rho4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho4[ip*p->dim.v4rho4 + 4] += tv4rho44;

  t6037 = t872 * t348 * t130;
  t6046 = t2577 * t2742;
  t6048 = t2577 * t2736;
  t6050 = t2577 * t2739;
  t6059 = t6 * t746;
  t6060 = t6059 * t1239;
  t6066 = t6 * t733;
  t6069 = 0.9e1 / 0.8e1 * t1237 * t1238 * t6037 + 0.3e1 / 0.8e1 * t1237 * t1238 * t1977 + 0.9e1 / 0.8e1 * t2568 * t2742 + 0.3e1 / 0.8e1 * t6046 + 0.3e1 / 0.4e1 * t6048 + 0.3e1 / 0.8e1 * t6050 + 0.9e1 / 0.8e1 * t1237 * t2735 * t878 + 0.9e1 / 0.4e1 * t2568 * t2736 + 0.9e1 / 0.8e1 * t2568 * t2739 - t6060 / 0.4e1 + 0.9e1 / 0.8e1 * t1237 * params->kappa * t2730 * t349 + 0.9e1 / 0.8e1 * t6066 * t1239;
  t6070 = t6 * t737;
  t6071 = t6070 * t1239;
  t6096 = t2028 * t46;
  t6100 = t2053 * t515 * t802;
  t6123 = -0.27e2 / 0.4e2 * t297 * (0.77e3 / 0.27e2 * params->b * t2028 * t72 - 0.55e3 / 0.27e2 * t2634 * t301 + 0.5e2 / 0.9e1 * t1174 * t812 - 0.25e2 / 0.36e2 * t509 * t2066 + 0.385e4 / 0.243e3 * t70 * t89 * t2028) - 0.308e3 / 0.243e3 * t6096 * t51 - 0.135e3 / 0.32e2 * t2617 * t6100 - 0.243e3 / 0.32e2 * t2054 * t1182 * t802 + 0.243e3 / 0.8e2 * t801 * t2644 * t304 + 0.243e3 / 0.8e2 * t801 * t1182 * t815 + 0.81e2 / 0.8e2 * t801 * t515 * t2069 + 0.77e2 / 0.18e2 * t6096 * t292 + 0.11e2 / 0.8e1 * t2606 * t795 - 0.3e1 / 0.8e1 * t1163 * t2048 + 0.3e1 / 0.64e2 * t506 * t5033;
  t6128 = t794 * t2644;
  t6138 = t800 * t1182 * t304;
  t6141 = t2618 * t815;
  t6150 = t791 * t51;
  t6153 = -0.3e1 / 0.8e1 * t2039 * t1168 - 0.9e1 / 0.8e1 * t791 * t2622 - 0.9e1 / 0.8e1 * t291 * t6128 + 0.567e3 / 0.64e2 * t5039 * t515 * t2055 - 0.243e3 / 0.32e2 * t2054 * t1171 * t815 + 0.27e2 / 0.8e1 * t2617 * t6138 + 0.27e2 / 0.16e2 * t2617 * t6141 + 0.9e1 / 0.16e2 * t1163 * t2045 + 0.45e2 / 0.256e3 * t506 * t5026 - 0.27e2 / 0.128e3 * t518 * t5030 + 0.27e2 / 0.16e2 * t6150 * t2619;
  t6154 = t6123 + t6153;
  t6187 = params->c * t2009 * sigma[0];
  t6188 = t116 * t91;
  t6189 = 0.1e1 / t6188;
  t6205 = t51 * t2028;
  t6216 = -0.73e2 / 0.972e5 * t6154 * t98 + 0.292e3 / 0.2025e4 * t82 * t6154 + 0.292e3 / 0.675e3 * t309 * t2649 + 0.292e3 / 0.675e3 * t820 * t1187 + 0.292e3 / 0.2025e4 * t2074 * t520 + 0.11e2 / 0.9e1 * t1151 * t781 - 0.154e3 / 0.81e2 * t500 * t2029 - 0.73e2 / 0.864e5 * t2090 * t1197 * t843 - 0.209e5 / 0.1594323e7 * t102 * t534 * t2101 - 0.15e2 / 0.16e2 * t111 * t541 * t2012 + (-0.3e1 / 0.4e1 * t490 * t1998 + 0.27e2 / 0.128e3 * t493 * t2002 - 0.207e3 / 0.16384e5 * t1144 * t2006 + 0.69e2 / 0.262144e6 * t2671 * t2016 - 0.15e2 / 0.8388608e7 * t6187 * t6189 * t4034 * t5148) * t46 * t57 / 0.24e2 - t2677 * t283 / 0.3e1 + 0.73e2 / 0.10368e6 * t5120 * t531 * t2091 + 0.11e2 / 0.9e1 * t278 * t2682 - 0.154e3 / 0.81e2 * t47 * t6205 + 0.73e2 / 0.1296e6 * t830 * t2595 * t325 - 0.73e2 / 0.864e5 * t5112 * t2655 - 0.73e2 / 0.864e5 * t2090 * t1206 * t831;
  t6237 = t520 * t2089;
  t6240 = t1187 * t829;
  t6251 = t89 * sigma[0] * t2101;
  t6262 = t2649 * t314;
  t6265 = -t774 * t1158 / 0.3e1 + t2020 * t503 / 0.24e2 + 0.73e2 / 0.1296e6 * t2687 * t2094 + 0.73e2 / 0.1296e6 * t5109 * t1197 + 0.73e2 / 0.648e5 * t2082 * t2692 + 0.73e2 / 0.1296e6 * t830 * t1206 * t843 + 0.73e2 / 0.3888e6 * t830 * t531 * t2105 - t538 * t1997 / 0.15e2 + 0.73e2 / 0.1296e6 * t2082 * t2695 - 0.73e2 / 0.2592e6 * t6237 * t2091 + 0.73e2 / 0.1296e6 * t6240 * t831 - 0.73e2 / 0.648e5 * t2079 * t1206 - 0.73e2 / 0.648e5 * t825 * t2595 - 0.73e2 / 0.1944e6 * t315 * (-0.7776e4 * sigma[0] * t268 * t34 - 0.6688e6 / 0.27e2 * t6251) - 0.73e2 / 0.1944e6 * t5097 * t531 - 0.73e2 / 0.648e5 * t2580 * t843 - 0.73e2 / 0.1944e6 * t1192 * t2105 - 0.73e2 / 0.648e5 * t6262 * t325;
  t6270 = t545 * t2130 * t101;
  t6287 = t2701 * t342;
  t6291 = t1217 * t864;
  t6292 = t6291 * t866;
  t6317 = -(t6216 + t6265) * t127 * t101 - 0.16e2 / 0.81e2 * t6270 * t2136 + t5160 * t101 * t549 / 0.12e2 + 0.2e1 / 0.9e1 * t5171 * t2722 + 0.22e2 / 0.9e1 * t1224 * t2727 - 0.38e2 / 0.27e2 * t2132 * t2134 * t2012 * t29 - 0.308e3 / 0.81e2 * t548 * t122 * t6205 - 0.2e1 / 0.3e1 * t6287 * t344 * t307 - 0.2e1 / 0.9e1 * t6292 * t841 - 0.2e1 / 0.3e1 * t2714 * t1229 + t5165 * t1204 / 0.12e2 + 0.22e2 / 0.27e2 * t2709 * t2103 - 0.308e3 / 0.81e2 * t1221 * t2072 - 0.3e1 / 0.4e1 * t2124 * t2593 + 0.1e2 / 0.243e3 * t5181 * t113 / t54 / t6188 * t114 * t46 * t51 + 0.341e3 / 0.162e3 * t867 * t6251 + 0.22e2 / 0.9e1 * t2705 * t818;
  t6322 = t1983 * t1136;
  t6324 = t741 * t2571;
  t6328 = 0.5e1 / 0.36e2 * t258 * t5203 * t553;
  t6330 = t258 * t1990 * t1233;
  t6333 = t258 * t750 * t2731;
  t6337 = t741 * t2574;
  t6341 = 0.3e1 / 0.4e1 * t6071 + 0.9e1 / 0.8e1 * t1237 * t2735 * t873 + 0.3e1 / 0.8e1 * t1237 * t1238 * t2144 + 0.3e1 / 0.8e1 * t5207 * t554 + 0.3e1 / 0.8e1 * t258 * t259 * t6317 * t130 + 0.3e1 / 0.8e1 * t6322 - t6324 / 0.4e1 + t6328 - t6330 / 0.4e1 + 0.3e1 / 0.8e1 * t6333 + 0.9e1 / 0.8e1 * t1983 * t1234 + 0.3e1 / 0.4e1 * t6337 + 0.9e1 / 0.8e1 * t741 * t2732;
  t6343 = my_piecewise3(t2, 0, t6069 + t6341);
  tv4rho3sigma0 = t7 * t6343 + 0.3e1 * t2746;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 0] += tv4rho3sigma0;

  tv4rho3sigma1 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 1] += tv4rho3sigma1;

  t6348 = t2262 * t1247;
  t6350 = t955 * t2753;
  t6354 = 0.5e1 / 0.36e2 * t393 * t5203 * t621;
  t6356 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t5462 * t622 + 0.3e1 / 0.8e1 * t6348 - t6350 / 0.4e1 + t6354);
  tv4rho3sigma2 = t7 * t6356 + 0.3e1 * t2757;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 2] += tv4rho3sigma2;

  t6358 = 0.2e1 * t2772;
  t6364 = t930 * t2574 / 0.4e1;
  t6371 = t2212 * t1136 / 0.4e1;
  t6372 = t6 * t922;
  t6375 = t930 * t2571;
  t6377 = t6 * t926;
  t6379 = t6377 * t1239 / 0.4e1;
  t6380 = 0.3e1 / 0.8e1 * t5364 * t554 + 0.3e1 / 0.4e1 * t2212 * t1234 + t6364 + 0.3e1 / 0.8e1 * t930 * t2732 + t6337 / 0.4e1 - t6330 / 0.6e1 + t6333 / 0.8e1 + t6371 + 0.3e1 / 0.4e1 * t6372 * t1239 - t6375 / 0.12e2 + t6379;
  t6394 = 0.3e1 / 0.4e1 * t2765 * t2736 + 0.3e1 / 0.8e1 * t2765 * t2739 + t6322 / 0.8e1 - t6324 / 0.6e1 + t6071 / 0.4e1 + t6328 - t6060 / 0.6e1 + t6048 / 0.4e1 + t6050 / 0.8e1 + 0.3e1 / 0.8e1 * t2765 * t2742 + t6046 / 0.8e1;
  t6396 = my_piecewise3(t2, 0, t6380 + t6394);
  tv4rho3sigma3 = t7 * t6396 + t2746 + t6358;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 3] += tv4rho3sigma3;

  tv4rho3sigma4 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 4] += tv4rho3sigma4;

  t6398 = 0.2e1 * t2791;
  t6402 = t2327 * t1247 / 0.4e1;
  t6403 = t999 * t2753;
  t6410 = t955 * t2781 / 0.4e1;
  t6412 = t393 * t1990 * t1354;
  t6414 = t6 * t897;
  t6417 = t6 * t901;
  t6419 = t6417 * t1360 / 0.4e1;
  t6420 = t6 * t905;
  t6421 = t6420 * t1360;
  t6423 = 0.3e1 / 0.8e1 * t5609 * t622 + t6402 - t6403 / 0.12e2 + t6348 / 0.8e1 - t6350 / 0.6e1 + t6354 + 0.3e1 / 0.8e1 * t2262 * t1355 + t6410 - t6412 / 0.12e2 + 0.3e1 / 0.8e1 * t6414 * t1360 + t6419 - t6421 / 0.12e2;
  t6424 = my_piecewise3(t138, 0, t6423);
  tv4rho3sigma5 = t7 * t6424 + t2757 + t6398;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 5] += tv4rho3sigma5;

  t6428 = t2296 * t1136;
  t6432 = t6 * t977;
  t6439 = 0.3e1 / 0.8e1 * t5528 * t554 + t6428 / 0.8e1 + 0.3e1 / 0.8e1 * t2296 * t1234 + 0.3e1 / 0.8e1 * t6432 * t1239 + t6371 - t6375 / 0.6e1 + t6364 + t6379 - t6324 / 0.12e2 + t6328 - t6330 / 0.12e2 - t6060 / 0.12e2;
  t6440 = my_piecewise3(t2, 0, t6439);
  tv4rho3sigma6 = t7 * t6440 + t2798 + t6358;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 6] += tv4rho3sigma6;

  tv4rho3sigma7 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 7] += tv4rho3sigma7;

  t6444 = t2554 * t1247;
  t6449 = t999 * t2781;
  t6451 = t6 * t946;
  t6454 = t6 * t950;
  t6455 = t6454 * t1360;
  t6458 = 0.3e1 / 0.8e1 * t5671 * t622 + t6444 / 0.8e1 + t6402 - t6403 / 0.6e1 + 0.3e1 / 0.4e1 * t2327 * t1355 + t6449 / 0.4e1 + 0.3e1 / 0.4e1 * t6451 * t1360 + t6455 / 0.4e1 - t6350 / 0.12e2 + t6354 + t6410;
  t6464 = t393 * t750 * t2962;
  t6468 = t2787 * t2967;
  t6472 = t2787 * t2970;
  t6476 = t2787 * t2973;
  t6478 = -t6412 / 0.6e1 + t6419 - t6421 / 0.6e1 + 0.3e1 / 0.8e1 * t955 * t2963 + t6464 / 0.8e1 + 0.3e1 / 0.4e1 * t2784 * t2967 + t6468 / 0.4e1 + 0.3e1 / 0.8e1 * t2784 * t2970 + t6472 / 0.8e1 + 0.3e1 / 0.8e1 * t2784 * t2973 + t6476 / 0.8e1;
  t6480 = my_piecewise3(t138, 0, t6458 + t6478);
  tv4rho3sigma8 = t7 * t6480 + t2977 + t6398;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 8] += tv4rho3sigma8;

  t6488 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t5648 * t554 + 0.3e1 / 0.8e1 * t6428 - t6375 / 0.4e1 + t6328);
  tv4rho3sigma9 = t7 * t6488 + 0.3e1 * t2798;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 9] += tv4rho3sigma9;

  tv4rho3sigma10 = 0.e0;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 10] += tv4rho3sigma10;

  t6493 = t2436 * t46;
  t6506 = t1043 * t2853;
  t6515 = t2827 * t1064;
  t6520 = 0.77e2 / 0.18e2 * t6493 * t426 + 0.11e2 / 0.8e1 * t2815 * t1044 - 0.3e1 / 0.8e1 * t1284 * t2456 + 0.3e1 / 0.64e2 * t574 * t5866 - 0.3e1 / 0.8e1 * t2447 * t1289 - 0.9e1 / 0.8e1 * t1040 * t2831 - 0.9e1 / 0.8e1 * t425 * t6506 + 0.567e3 / 0.64e2 * t5872 * t583 * t2463 - 0.243e3 / 0.32e2 * t2462 * t1292 * t1064 + 0.27e2 / 0.16e2 * t2826 * t6515 + 0.9e1 / 0.16e2 * t1284 * t2453;
  t6525 = t1040 * t51;
  t6529 = t1049 * t1303 * t438;
  t6550 = t2461 * t583 * t1051;
  t6565 = 0.45e2 / 0.256e3 * t574 * t5859 - 0.27e2 / 0.128e3 * t586 * t5863 + 0.27e2 / 0.16e2 * t6525 * t2828 + 0.27e2 / 0.8e1 * t2826 * t6529 - 0.27e2 / 0.4e2 * t431 * (0.77e3 / 0.27e2 * params->b * t2436 * t185 - 0.55e3 / 0.27e2 * t2843 * t435 + 0.5e2 / 0.9e1 * t1295 * t1061 - 0.25e2 / 0.36e2 * t577 * t2474 + 0.385e4 / 0.243e3 * t184 * t89 * t2436) - 0.308e3 / 0.243e3 * t6493 * t51 - 0.135e3 / 0.32e2 * t2826 * t6550 + 0.243e3 / 0.8e2 * t1050 * t1303 * t1064 + 0.81e2 / 0.8e2 * t1050 * t583 * t2477 - 0.243e3 / 0.32e2 * t2462 * t1303 * t1051 + 0.243e3 / 0.8e2 * t1050 * t2853 * t438;
  t6566 = t6520 + t6565;
  t6571 = t588 * t2497;
  t6578 = t1308 * t1078;
  t6581 = t2858 * t448;
  t6603 = t89 * sigma[2] * t2509;
  t6616 = -0.73e2 / 0.972e5 * t6566 * t207 + 0.292e3 / 0.2025e4 * t195 * t6566 - 0.73e2 / 0.2592e6 * t6571 * t2499 - 0.73e2 / 0.648e5 * t2909 * t1092 - 0.73e2 / 0.1944e6 * t1313 * t2513 + 0.73e2 / 0.1296e6 * t6578 * t1080 - 0.73e2 / 0.648e5 * t6581 * t459 + 0.73e2 / 0.1296e6 * t2490 * t2904 + 0.73e2 / 0.1296e6 * t1079 * t2924 * t459 + 0.73e2 / 0.1296e6 * t1079 * t1327 * t1092 + 0.73e2 / 0.3888e6 * t1079 * t599 * t2513 - t606 * t2405 / 0.15e2 - 0.73e2 / 0.648e5 * t1074 * t2924 - 0.73e2 / 0.1944e6 * t449 * (-0.7776e4 * sigma[2] * t402 * t153 - 0.6688e6 / 0.27e2 * t6603) - 0.73e2 / 0.1944e6 * t5916 * t599 - 0.73e2 / 0.648e5 * t2487 * t1327 + 0.73e2 / 0.1296e6 * t5771 * t1318 + 0.73e2 / 0.648e5 * t2490 * t2901;
  t6642 = t51 * t2436;
  t6660 = params->c * t2417 * sigma[2];
  t6661 = t219 * t200;
  t6662 = 0.1e1 / t6661;
  t6677 = -0.73e2 / 0.864e5 * t5774 * t2887 - 0.73e2 / 0.864e5 * t2498 * t1327 * t1080 + t2428 * t571 / 0.24e2 + 0.73e2 / 0.1296e6 * t2896 * t2502 - t1023 * t1279 / 0.3e1 - t2879 * t417 / 0.3e1 - 0.73e2 / 0.864e5 * t2498 * t1318 * t1092 - 0.209e5 / 0.1594323e7 * t102 * t602 * t2509 + 0.11e2 / 0.9e1 * t1272 * t1030 - 0.154e3 / 0.81e2 * t568 * t2437 + 0.11e2 / 0.9e1 * t412 * t2884 - 0.154e3 / 0.81e2 * t165 * t6642 + 0.73e2 / 0.10368e6 * t5782 * t599 * t2499 - 0.15e2 / 0.16e2 * t111 * t609 * t2420 + (-0.3e1 / 0.4e1 * t558 * t2406 + 0.27e2 / 0.128e3 * t561 * t2410 - 0.207e3 / 0.16384e5 * t1265 * t2414 + 0.69e2 / 0.262144e6 * t2873 * t2424 - 0.15e2 / 0.8388608e7 * t6660 * t6662 * t4177 * t5829) * t46 * t171 / 0.24e2 + 0.292e3 / 0.675e3 * t443 * t2858 + 0.292e3 / 0.675e3 * t1069 * t1308 + 0.292e3 / 0.2025e4 * t2482 * t588;
  t6682 = t613 * t2538 * t101;
  t6703 = t2932 * t476;
  t6707 = t1338 * t1113;
  t6708 = t6707 * t866;
  t6729 = -(t6616 + t6677) * t229 * t101 - 0.16e2 / 0.81e2 * t6682 * t2542 + t5936 * t101 * t617 / 0.12e2 + 0.2e1 / 0.9e1 * t5947 * t2953 - 0.2e1 / 0.3e1 * t2945 * t1350 + t5941 * t1325 / 0.12e2 + 0.22e2 / 0.9e1 * t1345 * t2958 - 0.38e2 / 0.27e2 * t2540 * t2134 * t2420 * t148 - 0.308e3 / 0.81e2 * t616 * t122 * t6642 - 0.2e1 / 0.3e1 * t6703 * t344 * t441 - 0.2e1 / 0.9e1 * t6708 * t1090 - 0.308e3 / 0.81e2 * t1342 * t2480 - 0.3e1 / 0.4e1 * t2532 * t2922 + 0.1e2 / 0.243e3 * t5955 * t113 / t168 / t6661 * t217 * t46 * t51 + 0.341e3 / 0.162e3 * t1115 * t6603 + 0.22e2 / 0.9e1 * t2936 * t1067 + 0.22e2 / 0.27e2 * t2940 * t2511;
  t6744 = t1120 * t481 * t232;
  t6749 = 0.9e1 / 0.8e1 * t999 * t2963 + 0.3e1 / 0.8e1 * t393 * t259 * t6729 * t232 + 0.3e1 / 0.8e1 * t6464 + 0.3e1 / 0.8e1 * t5977 * t622 + 0.9e1 / 0.8e1 * t2554 * t1355 + 0.3e1 / 0.4e1 * t6449 + 0.3e1 / 0.8e1 * t6444 - t6403 / 0.4e1 - t6412 / 0.4e1 + t6354 + 0.9e1 / 0.8e1 * t1358 * t1359 * t6744 - t6421 / 0.4e1;
  t6764 = t6 * t994;
  t6779 = 0.3e1 / 0.4e1 * t6455 + 0.3e1 / 0.4e1 * t6468 + 0.3e1 / 0.8e1 * t6472 + 0.3e1 / 0.8e1 * t6476 + 0.9e1 / 0.8e1 * t1358 * params->kappa * t2961 * t482 + 0.9e1 / 0.8e1 * t1358 * t2966 * t1121 + 0.3e1 / 0.8e1 * t1358 * t1359 * t2550 + 0.9e1 / 0.8e1 * t6764 * t1360 + 0.9e1 / 0.4e1 * t2806 * t2967 + 0.9e1 / 0.8e1 * t2806 * t2970 + 0.3e1 / 0.8e1 * t1358 * t1359 * t2393 + 0.9e1 / 0.8e1 * t1358 * t2966 * t1126 + 0.9e1 / 0.8e1 * t2806 * t2973;
  t6781 = my_piecewise3(t138, 0, t6749 + t6779);
  tv4rho3sigma11 = t7 * t6781 + 0.3e1 * t2977;

  if(out->v4rho3sigma != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3sigma[ip*p->dim.v4rho3sigma + 11] += tv4rho3sigma11;

  tv4rho3lapl0 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 0] += tv4rho3lapl0;

  tv4rho3lapl1 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 1] += tv4rho3lapl1;

  tv4rho3lapl2 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 2] += tv4rho3lapl2;

  tv4rho3lapl3 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 3] += tv4rho3lapl3;

  tv4rho3lapl4 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 4] += tv4rho3lapl4;

  tv4rho3lapl5 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 5] += tv4rho3lapl5;

  tv4rho3lapl6 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 6] += tv4rho3lapl6;

  tv4rho3lapl7 = 0.e0;

  if(out->v4rho3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3lapl[ip*p->dim.v4rho3lapl + 7] += tv4rho3lapl7;

  t6792 = t258 * t2994 * t342 * t1438;
  t6799 = t741 * t3127 * t1438;
  t6803 = t258 * t3113 * t342 * t1438;
  t6809 = t741 * t2980;
  t6813 = t258 * t1430 * t864;
  t6816 = t3128 * t3117;
  t6818 = -t1983 * t1434 * t1438 / 0.4e1 - t741 * t3131 * t1438 / 0.2e1 - t6792 / 0.6e1 - t258 * t3096 * t342 * t1438 / 0.4e1 - t6799 / 0.6e1 + t6803 / 0.18e2 + 0.11e2 / 0.12e2 * t3124 * t3117 + 0.11e2 / 0.12e2 * t3132 * t3117 - t6809 * t2984 / 0.12e2 - t6813 * t2984 / 0.12e2 + 0.11e2 / 0.36e2 * t6816;
  t6823 = t258 * t1368 * t864;
  t6824 = t6823 * t2984;
  t6829 = t873 * t107;
  t6838 = t349 * params->e;
  t6842 = t878 * t107;
  t6846 = t3128 * t3121;
  t6862 = t5112 * t29;
  t6867 = t5120 * t29;
  t6874 = t5109 * t29;
  t6904 = t794 * t3057;
  t6918 = t800 * t1407;
  t6919 = t6918 * t304;
  t6922 = t3036 * t815;
  t6929 = t2053 * t651;
  t6930 = t6929 * t802;
  t6937 = -0.3e1 / 0.8e1 * t642 * t5033 + 0.27e2 / 0.16e2 * t6150 * t3037 + 0.27e2 / 0.8e1 * t2617 * t6919 + 0.27e2 / 0.16e2 * t2617 * t6922 - 0.45e2 / 0.32e2 * t642 * t5026 + 0.27e2 / 0.16e2 * t3700 * t5030 - 0.135e3 / 0.32e2 * t2617 * t6930 - 0.45e2 / 0.16e2 * t2611 - 0.11e3 / 0.9e1 * t2607 - 0.5e1 * t2609 + 0.15e2 / 0.8e1 * t2613;
  t6938 = -0.27e2 / 0.4e2 * t297 * (-0.22e4 / 0.27e2 * t2635 + 0.2e4 / 0.27e2 * t2637 - 0.25e3 / 0.9e1 * t2639 + 0.5e2 / 0.9e1 * t645 * t2066 - 0.11e5 / 0.243e3 * t2642) - 0.243e3 / 0.32e2 * t2054 * t1407 * t802 + 0.243e3 / 0.8e2 * t801 * t3057 * t304 + 0.243e3 / 0.8e2 * t801 * t1407 * t815 + 0.81e2 / 0.8e2 * t801 * t651 * t2069 - 0.3e1 / 0.8e1 * t2039 * t1397 - 0.9e1 / 0.8e1 * t791 * t3040 - 0.9e1 / 0.8e1 * t291 * t6904 + 0.567e3 / 0.64e2 * t5039 * t651 * t2055 - 0.243e3 / 0.32e2 * t2054 * t1400 * t815 + t6937;
  t6949 = 0.219e3 / 0.8e3 * t3080 * t628 * t2094 - 0.219e3 / 0.4e3 * t3080 * t1372 * t831 - 0.219e3 / 0.2e3 * t1420 * t2998 * t325 + 0.73e2 / 0.2e3 * t1420 * t1372 * t843 + 0.219e3 / 0.8e3 * t6862 * t3081 + 0.73e2 / 0.1e3 * t3075 * t3084 - 0.73e2 / 0.32e3 * t6867 * t628 * t2091 - 0.73e2 / 0.12e4 * t1420 * t628 * t2105 - 0.73e2 / 0.4e3 * t6874 * t1421 - 0.73e2 / 0.4e3 * t3075 * t3087 - 0.73e2 / 0.972e5 * t6938 * t98 + 0.219e3 / 0.1e3 * t825 * t3090 - t3017 * t283 / 0.3e1 + 0.11e2 / 0.9e1 * t1387 * t781 - 0.154e3 / 0.81e2 * t639 * t2029;
  t6954 = t268 * t627;
  t6993 = t654 * t2089;
  t6996 = t1410 * t829;
  t6999 = t3060 * t314;
  t7006 = -0.73e2 / 0.1e3 * t2079 * t1424 + 0.73e2 / 0.6e3 * t5097 * t659 + (0.3e1 / 0.4e1 * t30 * t6954 * t41 - 0.27e2 / 0.128e3 * t267 * t1145 * t633 * t273 + 0.207e3 / 0.16384e5 * t764 * t334 * t1381 * t769 - 0.69e2 / 0.262144e6 * t2010 * t2012 * t3011 * t2015 + 0.15e2 / 0.8388608e7 * t5143 * t6189 * t4830 * t5148) * t46 * t57 / 0.24e2 - 0.73e2 / 0.25e2 * t315 * t2097 * t627 + 0.292e3 / 0.2025e4 * t82 * t6938 + 0.292e3 / 0.675e3 * t309 * t3060 + 0.292e3 / 0.675e3 * t820 * t1410 + 0.292e3 / 0.2025e4 * t2074 * t654 + 0.73e2 / 0.1296e6 * t3068 * t2094 + t108 * t6954 / 0.15e2 - 0.73e2 / 0.2592e6 * t6993 * t2091 + 0.73e2 / 0.1296e6 * t6996 * t831 - 0.73e2 / 0.648e5 * t6999 * t325 - 0.73e2 / 0.648e5 * t3065 * t843 - 0.73e2 / 0.1944e6 * t1415 * t2105;
  t7014 = -0.77e2 / 0.54e2 * t1435 * t1437 * t2029 - t6824 / 0.36e2 + 0.11e2 / 0.36e2 * t2981 * t2983 * t2108 - t1435 * t6829 * t307 / 0.4e1 - t3124 * t3121 / 0.2e1 + 0.11e2 / 0.12e2 * t1435 * t3120 * t818 - t2981 * t6838 * t841 / 0.12e2 - t1435 * t6842 * t307 / 0.4e1 - t6846 / 0.6e1 - t3132 * t3121 / 0.2e1 - 0.3e1 / 0.8e1 * t258 * t27 * (t6949 + t7006) * t666 - 0.3e1 / 0.8e1 * t5207 * t667;
  t7022 = t258 * t253 * t3095 * t666;
  t7024 = t741 * t3114;
  t7029 = 0.5e1 / 0.36e2 * t258 * t1942 * t664 * t666;
  t7030 = t1983 * t1369;
  t7032 = t741 * t2995;
  t7036 = t258 * t745 * t1429 * t666;
  t7044 = t6070 * t1442;
  t7046 = t2577 * t3106;
  t7048 = -0.9e1 / 0.8e1 * t1983 * t1431 - 0.9e1 / 0.8e1 * t741 * t3097 - 0.3e1 / 0.8e1 * t7022 + t7024 / 0.4e1 - t7029 - 0.3e1 / 0.8e1 * t7030 - 0.3e1 / 0.4e1 * t7032 + t7036 / 0.4e1 - 0.9e1 / 0.8e1 * t1237 * t1441 * t6037 - 0.3e1 / 0.8e1 * t1237 * t1441 * t1977 - 0.3e1 / 0.4e1 * t7044 - 0.3e1 / 0.8e1 * t7046;
  t7054 = t6059 * t1442;
  t7056 = t2577 * t2987;
  t7065 = t2577 * t3103;
  t7067 = t3095 * t127;
  t7078 = t3 / t4 / t112;
  t7079 = t7078 * t1738;
  t7080 = t2130 * t130;
  t7086 = -0.9e1 / 0.8e1 * t2568 * t2987 - 0.9e1 / 0.8e1 * t1237 * t3102 * t878 + t7054 / 0.4e1 - 0.3e1 / 0.8e1 * t7056 - 0.3e1 / 0.8e1 * t1237 * t1441 * t2144 - 0.9e1 / 0.8e1 * t6066 * t1442 - 0.9e1 / 0.4e1 * t2568 * t3103 - 0.3e1 / 0.4e1 * t7065 - 0.9e1 / 0.8e1 * t1237 * t7067 * t349 - 0.9e1 / 0.8e1 * t1237 * t3102 * t873 - 0.9e1 / 0.8e1 * t2568 * t3106 - 0.2e1 / 0.27e2 * t7079 * t7080 * t2133 * t114 * t2012;
  t7089 = my_piecewise3(t2, 0, t6818 + t7014 + t7048 + t7086);
  tv4rho3tau0 = t7 * t7089 + 0.3e1 * t3136;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 0] += tv4rho3tau0;

  t7094 = t2262 * t1451;
  t7096 = t955 * t3144;
  t7101 = 0.5e1 / 0.36e2 * t393 * t1942 * t709 * t711;
  t7103 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t5462 * t712 - 0.3e1 / 0.8e1 * t7094 + t7096 / 0.4e1 - t7101);
  tv4rho3tau1 = t7 * t7103 + 0.3e1 * t3148;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 1] += tv4rho3tau1;

  t7105 = 0.2e1 * t3166;
  t7111 = t930 * t2980;
  t7119 = t930 * t3127 * t1438 / 0.18e2;
  t7131 = t2212 * t1369 / 0.4e1;
  t7132 = t930 * t3114;
  t7138 = -t6792 / 0.18e2 - t6799 / 0.18e2 + t6803 / 0.27e2 + 0.11e2 / 0.36e2 * t3156 * t3117 - t7111 * t2984 / 0.36e2 - t2212 * t1434 * t1438 / 0.6e1 - t7119 - t930 * t3131 * t1438 / 0.6e1 + 0.11e2 / 0.108e3 * t6816 - t6824 / 0.108e3 - t3156 * t3121 / 0.6e1 - t6846 / 0.18e2 - 0.3e1 / 0.8e1 * t930 * t3097 - t7131 + t7132 / 0.12e2 - 0.3e1 / 0.8e1 * t5364 * t667 - 0.3e1 / 0.4e1 * t2212 * t1431;
  t7140 = t930 * t2995 / 0.4e1;
  t7153 = t6377 * t1442 / 0.4e1;
  t7161 = -t7140 - t7022 / 0.8e1 + t7024 / 0.6e1 - t7029 - t7030 / 0.8e1 - t7032 / 0.4e1 + t7036 / 0.6e1 - 0.3e1 / 0.8e1 * t2765 * t2987 - 0.3e1 / 0.8e1 * t2765 * t3106 - 0.3e1 / 0.4e1 * t6372 * t1442 - t7153 - 0.3e1 / 0.4e1 * t2765 * t3103 - t7044 / 0.4e1 - t7046 / 0.8e1 + t7054 / 0.6e1 - t7056 / 0.8e1 - t7065 / 0.4e1;
  t7163 = my_piecewise3(t2, 0, t7138 + t7161);
  tv4rho3tau2 = t7 * t7163 + t3136 + t7105;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 2] += tv4rho3tau2;

  t7165 = 0.2e1 * t3191;
  t7169 = t2327 * t1451 / 0.4e1;
  t7170 = t999 * t3144;
  t7177 = t955 * t3176 / 0.4e1;
  t7180 = t393 * t745 * t1521 * t711;
  t7187 = t955 * t3182 * t1530 / 0.18e2;
  t7190 = t393 * t3143 * t476 * t1530;
  t7195 = t6417 * t1534 / 0.4e1;
  t7196 = t6420 * t1534;
  t7198 = -0.3e1 / 0.8e1 * t5609 * t712 - t7169 + t7170 / 0.12e2 - t7094 / 0.8e1 + t7096 / 0.6e1 - t7101 - 0.3e1 / 0.8e1 * t2262 * t1523 - t7177 + t7180 / 0.12e2 - t2262 * t1526 * t1530 / 0.12e2 - t7187 + t7190 / 0.54e2 - 0.3e1 / 0.8e1 * t6414 * t1534 - t7195 + t7196 / 0.12e2;
  t7199 = my_piecewise3(t138, 0, t7198);
  tv4rho3tau3 = t7 * t7199 + t3148 + t7165;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 3] += tv4rho3tau3;

  t7203 = t2296 * t1369;
  t7217 = -0.3e1 / 0.8e1 * t5528 * t667 - t7203 / 0.8e1 - 0.3e1 / 0.8e1 * t2296 * t1431 - t2296 * t1434 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t6432 * t1442 - t7131 + t7132 / 0.6e1 - t7140 - t7119 - t7153 + t7024 / 0.12e2 - t7029 + t7036 / 0.12e2 + t6803 / 0.54e2 + t7054 / 0.12e2;
  t7218 = my_piecewise3(t2, 0, t7217);
  tv4rho3tau4 = t7 * t7218 + t3198 + t7105;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 4] += tv4rho3tau4;

  t7221 = t3183 * t3336;
  t7224 = t999 * t3182 * t1530;
  t7228 = t393 * t3175 * t476 * t1530;
  t7231 = t393 * t1450 * t1113;
  t7232 = t7231 * t3216;
  t7239 = t955 * t3212;
  t7245 = t3183 * t3340;
  t7255 = t2554 * t1451;
  t7257 = t999 * t3176;
  t7259 = -t7187 + t7190 / 0.27e2 + 0.11e2 / 0.108e3 * t7221 - t7224 / 0.18e2 - t7228 / 0.18e2 - t7232 / 0.108e3 - t955 * t3222 * t1530 / 0.6e1 + 0.11e2 / 0.36e2 * t3179 * t3336 - t7239 * t3216 / 0.36e2 - t2327 * t1526 * t1530 / 0.6e1 - t7245 / 0.18e2 - t3179 * t3340 / 0.6e1 - 0.3e1 / 0.8e1 * t955 * t3333 - 0.3e1 / 0.8e1 * t5671 * t712 - 0.3e1 / 0.4e1 * t2327 * t1523 - t7255 / 0.8e1 - t7257 / 0.4e1;
  t7262 = t393 * t253 * t3331 * t711;
  t7267 = t2787 * t3207;
  t7269 = t2787 * t3226;
  t7277 = t6454 * t1534;
  t7279 = t2787 * t3204;
  t7284 = -t7262 / 0.8e1 - t7169 + t7170 / 0.6e1 - t7177 + t7180 / 0.6e1 + t7096 / 0.12e2 - t7101 - t7267 / 0.8e1 - t7269 / 0.8e1 - 0.3e1 / 0.4e1 * t6451 * t1534 - 0.3e1 / 0.4e1 * t2784 * t3204 - 0.3e1 / 0.8e1 * t2784 * t3207 - t7277 / 0.4e1 - t7279 / 0.4e1 - 0.3e1 / 0.8e1 * t2784 * t3226 - t7195 + t7196 / 0.6e1;
  t7286 = my_piecewise3(t138, 0, t7259 + t7284);
  tv4rho3tau5 = t7 * t7286 + t3345 + t7165;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 5] += tv4rho3tau5;

  t7294 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t5648 * t667 - 0.3e1 / 0.8e1 * t7203 + t7132 / 0.4e1 - t7029);
  tv4rho3tau6 = t7 * t7294 + 0.3e1 * t3198;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 6] += tv4rho3tau6;

  t7317 = t999 * t3212;
  t7321 = t393 * t1522 * t1113;
  t7326 = -0.77e2 / 0.54e2 * t1527 * t1529 * t2437 + 0.11e2 / 0.12e2 * t3219 * t3336 + 0.11e2 / 0.12e2 * t3223 * t3336 + 0.11e2 / 0.36e2 * t3213 * t3215 * t2516 - t2554 * t1526 * t1530 / 0.4e1 - t999 * t3222 * t1530 / 0.2e1 - t393 * t3332 * t476 * t1530 / 0.4e1 - t7317 * t3216 / 0.12e2 - t7321 * t3216 / 0.12e2 + t7190 / 0.18e2 + 0.11e2 / 0.36e2 * t7221;
  t7334 = t1126 * t107;
  t7342 = t1121 * t107;
  t7346 = t482 * params->e;
  t7353 = t5782 * t148;
  t7363 = t5774 * t148;
  t7376 = t5771 * t148;
  t7393 = t1043 * t3293;
  t7413 = t1049 * t1499;
  t7414 = t7413 * t438;
  t7417 = t3272 * t1064;
  t7429 = t2461 * t696;
  t7430 = t7429 * t1051;
  t7437 = -0.45e2 / 0.32e2 * t687 * t5859 + 0.27e2 / 0.16e2 * t3891 * t5863 + 0.27e2 / 0.16e2 * t6525 * t3273 + 0.27e2 / 0.8e1 * t2826 * t7414 + 0.27e2 / 0.16e2 * t2826 * t7417 - 0.27e2 / 0.4e2 * t431 * (-0.22e4 / 0.27e2 * t2844 + 0.2e4 / 0.27e2 * t2846 - 0.25e3 / 0.9e1 * t2848 + 0.5e2 / 0.9e1 * t690 * t2474 - 0.11e5 / 0.243e3 * t2851) - 0.135e3 / 0.32e2 * t2826 * t7430 - 0.11e3 / 0.9e1 * t2816 - 0.5e1 * t2818 + 0.15e2 / 0.8e1 * t2822 - 0.45e2 / 0.16e2 * t2820;
  t7438 = -0.243e3 / 0.32e2 * t2462 * t1499 * t1051 + 0.243e3 / 0.8e2 * t1050 * t3293 * t438 + 0.243e3 / 0.8e2 * t1050 * t1499 * t1064 + 0.81e2 / 0.8e2 * t1050 * t696 * t2477 - 0.9e1 / 0.8e1 * t1040 * t3276 - 0.9e1 / 0.8e1 * t425 * t7393 + 0.567e3 / 0.64e2 * t5872 * t696 * t2463 - 0.243e3 / 0.32e2 * t2462 * t1492 * t1064 - 0.3e1 / 0.8e1 * t687 * t5866 - 0.3e1 / 0.8e1 * t2447 * t1489 + t7437;
  t7449 = 0.219e3 / 0.8e3 * t3316 * t673 * t2502 - 0.73e2 / 0.32e3 * t7353 * t673 * t2499 - 0.219e3 / 0.4e3 * t3316 * t1464 * t1080 - 0.219e3 / 0.2e3 * t1512 * t3234 * t459 + 0.219e3 / 0.8e3 * t7363 * t3317 + 0.73e2 / 0.1e3 * t3311 * t3320 - 0.73e2 / 0.4e3 * t3311 * t3323 + 0.73e2 / 0.2e3 * t1512 * t1464 * t1092 - 0.73e2 / 0.12e4 * t1512 * t673 * t2513 - 0.73e2 / 0.4e3 * t7376 * t1513 - 0.73e2 / 0.972e5 * t7438 * t207 + 0.292e3 / 0.2025e4 * t195 * t7438 + 0.292e3 / 0.675e3 * t443 * t3296 + 0.292e3 / 0.675e3 * t1069 * t1502 + 0.292e3 / 0.2025e4 * t2482 * t699;
  t7465 = t402 * t672;
  t7495 = t3296 * t448;
  t7498 = t1502 * t1078;
  t7501 = t699 * t2497;
  t7506 = 0.219e3 / 0.1e3 * t1074 * t3326 - 0.73e2 / 0.25e2 * t449 * t2505 * t672 - t3253 * t417 / 0.3e1 + 0.11e2 / 0.9e1 * t1479 * t1030 - 0.154e3 / 0.81e2 * t684 * t2437 - 0.73e2 / 0.1e3 * t2487 * t1516 + 0.73e2 / 0.6e3 * t5916 * t704 + (0.3e1 / 0.4e1 * t149 * t7465 * t160 - 0.27e2 / 0.128e3 * t401 * t1266 * t678 * t407 + 0.207e3 / 0.16384e5 * t1013 * t468 * t1473 * t1018 - 0.69e2 / 0.262144e6 * t2418 * t2420 * t3247 * t2423 + 0.15e2 / 0.8388608e7 * t5824 * t6662 * t4912 * t5829) * t46 * t171 / 0.24e2 + 0.73e2 / 0.1296e6 * t3304 * t2502 + t214 * t7465 / 0.15e2 - 0.73e2 / 0.648e5 * t3301 * t1092 - 0.73e2 / 0.648e5 * t7495 * t459 + 0.73e2 / 0.1296e6 * t7498 * t1080 - 0.73e2 / 0.2592e6 * t7501 * t2499 - 0.73e2 / 0.1944e6 * t1507 * t2513;
  t7514 = -t7224 / 0.6e1 - t7228 / 0.6e1 - t7232 / 0.36e2 - t7245 / 0.6e1 + 0.11e2 / 0.12e2 * t1527 * t3339 * t1067 - t1527 * t7334 * t441 / 0.4e1 - t3219 * t3340 / 0.2e1 - t3223 * t3340 / 0.2e1 - t1527 * t7342 * t441 / 0.4e1 - t3213 * t7346 * t1090 / 0.12e2 - 0.3e1 / 0.8e1 * t393 * t27 * (t7449 + t7506) * t711 - 0.3e1 / 0.8e1 * t5977 * t712;
  t7536 = -0.9e1 / 0.8e1 * t2554 * t1523 - 0.9e1 / 0.8e1 * t999 * t3333 - 0.3e1 / 0.8e1 * t7255 - 0.3e1 / 0.4e1 * t7257 - 0.3e1 / 0.8e1 * t7262 + t7170 / 0.4e1 + t7180 / 0.4e1 - t7101 - 0.9e1 / 0.8e1 * t1358 * t1533 * t6744 - 0.3e1 / 0.8e1 * t1358 * t1533 * t2393 - 0.9e1 / 0.8e1 * t2806 * t3226 - 0.9e1 / 0.8e1 * t1358 * t3203 * t1126;
  t7539 = t3331 * t229;
  t7558 = t7078 * t1801;
  t7559 = t2538 * t232;
  t7565 = -0.9e1 / 0.8e1 * t2806 * t3207 - 0.9e1 / 0.8e1 * t1358 * t7539 * t482 - 0.9e1 / 0.8e1 * t1358 * t3203 * t1121 - 0.3e1 / 0.8e1 * t1358 * t1533 * t2550 - 0.3e1 / 0.8e1 * t7267 - 0.3e1 / 0.8e1 * t7269 - 0.9e1 / 0.8e1 * t6764 * t1534 - 0.9e1 / 0.4e1 * t2806 * t3204 - 0.3e1 / 0.4e1 * t7277 - 0.3e1 / 0.4e1 * t7279 + t7196 / 0.4e1 - 0.2e1 / 0.27e2 * t7558 * t7559 * t2133 * t217 * t2420;
  t7568 = my_piecewise3(t138, 0, t7326 + t7514 + t7536 + t7565);
  tv4rho3tau7 = t7 * t7568 + 0.3e1 * t3345;

  if(out->v4rho3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho3tau[ip*p->dim.v4rho3tau + 7] += tv4rho3tau7;

  t7574 = t349 * t1232;
  t7584 = params->kappa * t3476;
  t7591 = t741 * t3487;
  t7599 = t258 * t1990 * t1608 / 0.12e2;
  t7600 = t2577 * t3490;
  t7602 = 0.3e1 / 0.8e1 * t1237 * t3481 * t878 + 0.3e1 / 0.2e1 * t1237 * t1238 * t7574 + 0.3e1 / 0.8e1 * t1237 * t3493 * t878 + 0.3e1 / 0.8e1 * t1237 * t3493 * t873 + 0.3e1 / 0.4e1 * t1237 * t7584 * t349 + 0.3e1 / 0.8e1 * t1237 * t3481 * t873 + t7591 / 0.4e1 + 0.3e1 / 0.2e1 * t2568 * t3490 + 0.3e1 / 0.4e1 * t2568 * t3494 - t7599 + t7600 / 0.2e1;
  t7603 = t2577 * t3494;
  t7605 = t1232 * t1232;
  t7613 = t741 * t3349;
  t7619 = t258 * t1990 * t1604 / 0.12e2;
  t7620 = t2577 * t3482;
  t7629 = t258 * t750 * t3477;
  t7648 = params->c * t758;
  t7652 = t766 * t769;
  t7673 = t89 * t839;
  t7698 = -0.73e2 / 0.972e5 * t825 * t3439 + 0.292e3 / 0.2025e4 * t820 * t1567 + 0.584e3 / 0.2025e4 * t520 * t2649 + 0.73e2 / 0.3888e6 * t5109 * t1574 - 0.73e2 / 0.1944e6 * t2079 * t1579 - 0.73e2 / 0.972e5 * t1192 * t2595 + 0.3e1 / 0.16e2 * t111 * t1588 * t852 + (0.3e1 / 0.16e2 * t4283 * t1541 - 0.57e2 / 0.512e3 * t7648 * t3357 + 0.297e3 / 0.32768e5 * params->c * t117 * t7652 * t266 - 0.15e2 / 0.65536e5 * t764 * t2673 + 0.15e2 / 0.8388608e7 * t2010 * t5001 * t4034 * t5148) * t46 * t57 / 0.24e2 - 0.73e2 / 0.648e5 * t2090 * t1197 * t1206 + t107 * t494 * t34 / 0.6e2 - 0.73e2 / 0.1944e6 * t315 * (0.1944e4 * t754 + 0.304e5 / 0.9e1 * t7673) - 0.73e2 / 0.972e5 * t6262 * t531 - 0.73e2 / 0.486e5 * t2580 * t1206 - 0.73e2 / 0.2592e6 * t2090 * t1579 * t831 - 0.4e1 / 0.9e1 * t1151 * t1158 + 0.22e2 / 0.27e2 * t500 * t2682 - 0.73e2 / 0.1944e6 * t3414 * t843 - 0.2e1 / 0.9e1 * t3367 * t283 + 0.11e2 / 0.27e2 * t1551 * t781 + 0.73e2 / 0.1944e6 * t830 * t531 * t2595;
  t7709 = t3409 * t314;
  t7712 = t1187 * t1187;
  t7730 = t88 * t839;
  t7735 = t1206 * t1206;
  t7738 = t1567 * t829;
  t7744 = t1182 * t1182;
  t7753 = t790 * t113;
  t7769 = -0.81e2 / 0.32e2 * t2054 * t1560 * t815 + 0.81e2 / 0.4e2 * t801 * t7744 + 0.81e2 / 0.4e2 * t801 * t515 * t2644 - 0.81e2 / 0.8e1 * t2054 * t1171 * t1182 - 0.25e2 / 0.128e3 * t7753 * t3397 - t1163 * t2622 / 0.2e1 + 0.3e1 / 0.32e2 * t506 * t6128 + 0.9e1 / 0.16e2 * t791 * t3386 + 0.567e3 / 0.64e2 * t5039 * t1560 * t802 + 0.3e1 / 0.4e1 * t1185 * t2619 - 0.9e1 / 0.32e2 * t518 * t6138;
  t7773 = t2053 * t1560 * t304;
  t7776 = t2618 * t1182;
  t7779 = t3395 * t800;
  t7788 = t2054 * params->b;
  t7789 = t88 * t802;
  t7799 = t88 * t815;
  t7805 = -0.9e1 / 0.64e2 * t518 * t6141 - 0.45e2 / 0.16e2 * t2617 * t7773 + 0.9e1 / 0.4e1 * t2617 * t7776 + 0.75e2 / 0.128e3 * t7779 * t4310 * t304 + 0.25e2 / 0.12e2 * t3395 * t3396 * t321 + 0.11e2 / 0.12e2 * t2606 * t1168 - 0.225e3 / 0.1024e4 * t7788 * t3401 * t7789 - 0.15e2 / 0.16e2 * t3400 * t321 * t86 * t3402 + 0.45e2 / 0.128e3 * t518 * t6100 + 0.45e2 / 0.512e3 * t3400 * t3401 * t7799 - 0.95e2 / 0.48e2 * t1563 * t7673;
  t7806 = t7769 + t7805;
  t7813 = 0.73e2 / 0.1944e6 * t2082 * t3434 + 0.73e2 / 0.1944e6 * t830 * t3439 * t325 - 0.73e2 / 0.1296e6 * t6237 * t2655 + 0.73e2 / 0.10368e6 * t5120 * t1574 * t831 - 0.73e2 / 0.972e5 * t7709 * t325 + 0.584e3 / 0.2025e4 * t7712 + 0.73e2 / 0.1944e6 * t2687 * t2695 - 0.73e2 / 0.1296e6 * t5112 * t3426 + 0.73e2 / 0.972e5 * t2082 * t3429 - 0.73e2 / 0.2592e6 * t2090 * t1574 * t843 + 0.73e2 / 0.972e5 * t6240 * t1197 + 0.73e2 / 0.972e5 * t2687 * t2692 + 0.73e2 / 0.3888e6 * t830 * t1579 * t843 + 0.95e3 / 0.531441e6 * t102 * t7730 + t2677 * t503 / 0.12e2 + 0.73e2 / 0.1944e6 * t830 * t7735 + 0.73e2 / 0.3888e6 * t7738 * t831 - 0.73e2 / 0.972e5 * t7806 * t98 + 0.584e3 / 0.2025e4 * t309 * t3409 + 0.292e3 / 0.2025e4 * t82 * t7806;
  t7817 = t3452 * t342;
  t7821 = t1592 * t864;
  t7822 = t7821 * t866;
  t7862 = -(t7698 + t7813) * t127 * t101 - 0.4e1 / 0.9e1 * t7817 * t344 * t307 - 0.2e1 / 0.27e2 * t7822 * t841 + 0.22e2 / 0.27e2 * t3456 * t818 + t6287 * t101 * t549 / 0.6e1 + t6292 * t1204 / 0.9e1 - 0.8e1 / 0.9e1 * t3459 * t1229 + 0.4e1 / 0.27e2 * t6270 * t2722 - t2709 * t2593 / 0.2e1 + 0.44e2 / 0.27e2 * t1595 * t2727 - t5164 * t101 * t1600 / 0.96e2 - t5171 * t3470 / 0.18e2 + t3466 * t3473 / 0.9e1 - 0.5e1 / 0.324e3 * t5181 * t113 / t54 / t5000 * t29 * t46 * t51 + 0.43e2 / 0.108e3 * t2132 * t2134 * t852 * sigma[0] - 0.19e2 / 0.54e2 * t1598 * t1599 * t7730;
  t7867 = t7603 / 0.4e1 + 0.3e1 / 0.4e1 * t258 * t259 * t7605 * t130 + 0.3e1 / 0.4e1 * t1237 * t1238 * t2731 + t7613 / 0.4e1 + 0.3e1 / 0.4e1 * t2568 * t3482 - t7619 + t7620 / 0.4e1 + 0.3e1 / 0.8e1 * t1983 * t1609 + 0.3e1 / 0.8e1 * t1983 * t1605 + 0.3e1 / 0.4e1 * t741 * t3478 + t7629 / 0.4e1 + 0.3e1 / 0.8e1 * t258 * t259 * t7862 * t130;
  t7869 = my_piecewise3(t2, 0, t7602 + t7867);
  tv4rho2sigma20 = t7 * t7869 + 0.2e1 * t3498;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 0] += tv4rho2sigma20;

  tv4rho2sigma21 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 1] += tv4rho2sigma21;

  tv4rho2sigma22 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 2] += tv4rho2sigma22;

  tv4rho2sigma23 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 3] += tv4rho2sigma23;

  tv4rho2sigma24 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 4] += tv4rho2sigma24;

  t7874 = t955 * t3502;
  t7878 = t393 * t1990 * t1677 / 0.12e2;
  t7881 = t955 * t3507;
  t7885 = t393 * t1990 * t1681 / 0.12e2;
  t7887 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t2262 * t1678 + t7874 / 0.4e1 - t7878 + 0.3e1 / 0.8e1 * t2262 * t1682 + t7881 / 0.4e1 - t7885);
  tv4rho2sigma25 = t7 * t7887 + 0.2e1 * t3511;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 5] += tv4rho2sigma25;

  t7891 = t930 * t3349;
  t7902 = t930 * t3487;
  t7911 = 0.3e1 / 0.8e1 * t2212 * t1605 + t7891 / 0.8e1 + 0.3e1 / 0.8e1 * t930 * t3478 + 0.3e1 / 0.8e1 * t2765 * t3482 + t7613 / 0.8e1 - t7619 + t7629 / 0.8e1 + t7620 / 0.8e1 + 0.3e1 / 0.8e1 * t2212 * t1609 + t7902 / 0.8e1 + 0.3e1 / 0.4e1 * t2765 * t3490 + 0.3e1 / 0.8e1 * t2765 * t3494 + t7591 / 0.8e1 - t7599 + t7600 / 0.4e1 + t7603 / 0.8e1;
  t7912 = my_piecewise3(t2, 0, t7911);
  tv4rho2sigma26 = t7 * t7912 + t3498 + t3518;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 6] += tv4rho2sigma26;

  tv4rho2sigma27 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 7] += tv4rho2sigma27;

  tv4rho2sigma28 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 8] += tv4rho2sigma28;

  tv4rho2sigma29 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 9] += tv4rho2sigma29;

  tv4rho2sigma210 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 10] += tv4rho2sigma210;

  t7916 = t999 * t3502;
  t7922 = t393 * t750 * t3647;
  t7926 = t2787 * t3652;
  t7930 = t999 * t3507;
  t7935 = t2787 * t3657;
  t7939 = t2787 * t3661;
  t7941 = 0.3e1 / 0.8e1 * t2327 * t1678 + t7916 / 0.8e1 + t7874 / 0.8e1 - t7878 + 0.3e1 / 0.8e1 * t955 * t3648 + t7922 / 0.8e1 + 0.3e1 / 0.8e1 * t2784 * t3652 + t7926 / 0.8e1 + 0.3e1 / 0.8e1 * t2327 * t1682 + t7930 / 0.8e1 + t7881 / 0.8e1 - t7885 + 0.3e1 / 0.4e1 * t2784 * t3657 + t7935 / 0.4e1 + 0.3e1 / 0.8e1 * t2784 * t3661 + t7939 / 0.8e1;
  t7942 = my_piecewise3(t138, 0, t7941);
  tv4rho2sigma211 = t7 * t7942 + t3511 + t3665;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 11] += tv4rho2sigma211;

  t7952 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t2296 * t1605 + t7891 / 0.4e1 - t7619 + 0.3e1 / 0.8e1 * t2296 * t1609 + t7902 / 0.4e1 - t7599);
  tv4rho2sigma212 = t7 * t7952 + 0.2e1 * t3518;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 12] += tv4rho2sigma212;

  tv4rho2sigma213 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 13] += tv4rho2sigma213;

  tv4rho2sigma214 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 14] += tv4rho2sigma214;

  tv4rho2sigma215 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 15] += tv4rho2sigma215;

  tv4rho2sigma216 = 0.e0;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 16] += tv4rho2sigma216;

  t7959 = t1353 * t1353;
  t7970 = params->kappa * t3646;
  t7983 = t1308 * t1308;
  t7994 = t2461 * t1634 * t438;
  t7997 = t2827 * t1303;
  t8000 = t3565 * t1049;
  t8010 = t1303 * t1303;
  t8016 = 0.11e2 / 0.12e2 * t2815 * t1289 + 0.3e1 / 0.4e1 * t1306 * t2828 - 0.9e1 / 0.32e2 * t586 * t6529 - 0.9e1 / 0.64e2 * t586 * t6515 - 0.45e2 / 0.16e2 * t2826 * t7994 + 0.9e1 / 0.4e1 * t2826 * t7997 + 0.75e2 / 0.128e3 * t8000 * t4387 * t438 + 0.25e2 / 0.12e2 * t3565 * t3566 * t455 - 0.81e2 / 0.32e2 * t2462 * t1634 * t1064 + 0.81e2 / 0.4e2 * t1050 * t8010 + 0.81e2 / 0.4e2 * t1050 * t583 * t2853;
  t8029 = t1039 * t113;
  t8034 = t88 * t1064;
  t8038 = t89 * t1088;
  t8041 = t2462 * params->b;
  t8042 = t88 * t1051;
  t8050 = -t1284 * t2831 / 0.2e1 + 0.3e1 / 0.32e2 * t574 * t6506 + 0.9e1 / 0.16e2 * t1040 * t3556 + 0.567e3 / 0.64e2 * t5872 * t1634 * t1051 - 0.81e2 / 0.8e1 * t2462 * t1292 * t1303 - 0.25e2 / 0.128e3 * t8029 * t3567 + 0.45e2 / 0.128e3 * t586 * t6550 + 0.45e2 / 0.512e3 * t3570 * t3571 * t8034 - 0.95e2 / 0.48e2 * t1637 * t8038 - 0.225e3 / 0.1024e4 * t8041 * t3571 * t8042 - 0.15e2 / 0.16e2 * t3570 * t455 * t86 * t3572;
  t8051 = t8016 + t8050;
  t8059 = params->c * t1007;
  t8063 = t1015 * t1018;
  t8094 = t88 * t1088;
  t8117 = 0.584e3 / 0.2025e4 * t7983 - 0.73e2 / 0.972e5 * t8051 * t207 + 0.3e1 / 0.16e2 * t111 * t1662 * t1101 + (0.3e1 / 0.16e2 * t4360 * t1615 - 0.57e2 / 0.512e3 * t8059 * t3527 + 0.297e3 / 0.32768e5 * params->c * t220 * t8063 * t400 - 0.15e2 / 0.65536e5 * t1013 * t2875 + 0.15e2 / 0.8388608e7 * t2418 * t5804 * t4177 * t5829) * t46 * t171 / 0.24e2 - 0.73e2 / 0.648e5 * t2498 * t1318 * t1327 + 0.73e2 / 0.10368e6 * t5782 * t1648 * t1080 - 0.73e2 / 0.2592e6 * t2498 * t1653 * t1080 + 0.73e2 / 0.1944e6 * t2490 * t3604 + 0.73e2 / 0.1944e6 * t1079 * t3609 * t459 + 0.73e2 / 0.3888e6 * t1079 * t1653 * t1092 + 0.95e3 / 0.531441e6 * t102 * t8094 - 0.4e1 / 0.9e1 * t1272 * t1279 + 0.22e2 / 0.27e2 * t568 * t2884 - 0.73e2 / 0.1296e6 * t6571 * t2887 + 0.73e2 / 0.972e5 * t2490 * t3599 - 0.73e2 / 0.2592e6 * t2498 * t1648 * t1092 + 0.73e2 / 0.1944e6 * t1079 * t599 * t2924 + 0.73e2 / 0.972e5 * t2896 * t2901 + 0.73e2 / 0.1944e6 * t2896 * t2904 - 0.73e2 / 0.1296e6 * t5774 * t3596;
  t8134 = t3579 * t448;
  t8137 = t1327 * t1327;
  t8140 = t1641 * t1078;
  t8165 = t2879 * t571 / 0.12e2 + 0.73e2 / 0.972e5 * t6578 * t1318 + 0.292e3 / 0.2025e4 * t195 * t8051 - 0.2e1 / 0.9e1 * t3537 * t417 + 0.11e2 / 0.27e2 * t1625 * t1030 + 0.584e3 / 0.2025e4 * t443 * t3579 + 0.292e3 / 0.2025e4 * t1069 * t1641 + 0.584e3 / 0.2025e4 * t588 * t2858 - 0.73e2 / 0.972e5 * t8134 * t459 + 0.73e2 / 0.1944e6 * t1079 * t8137 + 0.73e2 / 0.3888e6 * t8140 * t1080 - 0.73e2 / 0.1944e6 * t3584 * t1092 - 0.73e2 / 0.972e5 * t6581 * t599 - 0.73e2 / 0.486e5 * t2909 * t1327 - 0.73e2 / 0.972e5 * t1313 * t2924 + 0.73e2 / 0.3888e6 * t5771 * t1648 - 0.73e2 / 0.1944e6 * t2487 * t1653 - 0.73e2 / 0.972e5 * t1074 * t3609 - 0.73e2 / 0.1944e6 * t449 * (0.1944e4 * t1003 + 0.304e5 / 0.9e1 * t8038) + t107 * t562 * t153 / 0.6e2;
  t8169 = t3622 * t476;
  t8173 = t1666 * t1113;
  t8174 = t8173 * t866;
  t8214 = -(t8117 + t8165) * t229 * t101 - 0.4e1 / 0.9e1 * t8169 * t344 * t441 - 0.2e1 / 0.27e2 * t8174 * t1090 + 0.22e2 / 0.27e2 * t3626 * t1067 + t6703 * t101 * t617 / 0.6e1 + t6708 * t1325 / 0.9e1 - 0.8e1 / 0.9e1 * t3629 * t1350 + 0.4e1 / 0.27e2 * t6682 * t2953 - t2940 * t2922 / 0.2e1 + 0.44e2 / 0.27e2 * t1669 * t2958 - t5940 * t101 * t1673 / 0.96e2 - t5947 * t3640 / 0.18e2 + t3636 * t3643 / 0.9e1 - 0.5e1 / 0.324e3 * t5955 * t113 / t168 / t5803 * t148 * t46 * t51 + 0.43e2 / 0.108e3 * t2540 * t2134 * t1101 * sigma[2] - 0.19e2 / 0.54e2 * t1672 * t1599 * t8094;
  t8219 = 0.3e1 / 0.2e1 * t2806 * t3657 + 0.3e1 / 0.4e1 * t2806 * t3661 + 0.3e1 / 0.4e1 * t393 * t259 * t7959 * t232 + 0.3e1 / 0.4e1 * t1358 * t1359 * t2962 + 0.3e1 / 0.8e1 * t1358 * t3660 * t1121 + 0.3e1 / 0.4e1 * t1358 * t7970 * t482 + 0.3e1 / 0.8e1 * t1358 * t3651 * t1121 + 0.3e1 / 0.8e1 * t2554 * t1682 + 0.3e1 / 0.8e1 * t2554 * t1678 + 0.3e1 / 0.4e1 * t999 * t3648 + 0.3e1 / 0.8e1 * t393 * t259 * t8214 * t232;
  t8226 = t482 * t1353;
  t8238 = 0.3e1 / 0.8e1 * t1358 * t3660 * t1126 + 0.3e1 / 0.8e1 * t1358 * t3651 * t1126 + 0.3e1 / 0.2e1 * t1358 * t1359 * t8226 + t7926 / 0.4e1 + t7935 / 0.2e1 + t7939 / 0.4e1 + 0.3e1 / 0.4e1 * t2806 * t3652 + t7916 / 0.4e1 + t7922 / 0.4e1 + t7930 / 0.4e1 - t7878 - t7885;
  t8240 = my_piecewise3(t138, 0, t8219 + t8238);
  tv4rho2sigma217 = t7 * t8240 + 0.2e1 * t3665;

  if(out->v4rho2sigma2 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigma2[ip*p->dim.v4rho2sigma2 + 17] += tv4rho2sigma217;

  tv4rho2sigmalapl0 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 0] += tv4rho2sigmalapl0;

  tv4rho2sigmalapl1 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 1] += tv4rho2sigmalapl1;

  tv4rho2sigmalapl2 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 2] += tv4rho2sigmalapl2;

  tv4rho2sigmalapl3 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 3] += tv4rho2sigmalapl3;

  tv4rho2sigmalapl4 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 4] += tv4rho2sigmalapl4;

  tv4rho2sigmalapl5 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 5] += tv4rho2sigmalapl5;

  tv4rho2sigmalapl6 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 6] += tv4rho2sigmalapl6;

  tv4rho2sigmalapl7 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 7] += tv4rho2sigmalapl7;

  tv4rho2sigmalapl8 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 8] += tv4rho2sigmalapl8;

  tv4rho2sigmalapl9 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 9] += tv4rho2sigmalapl9;

  tv4rho2sigmalapl10 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 10] += tv4rho2sigmalapl10;

  tv4rho2sigmalapl11 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 11] += tv4rho2sigmalapl11;

  tv4rho2sigmalapl12 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 12] += tv4rho2sigmalapl12;

  tv4rho2sigmalapl13 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 13] += tv4rho2sigmalapl13;

  tv4rho2sigmalapl14 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 14] += tv4rho2sigmalapl14;

  tv4rho2sigmalapl15 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 15] += tv4rho2sigmalapl15;

  tv4rho2sigmalapl16 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 16] += tv4rho2sigmalapl16;

  tv4rho2sigmalapl17 = 0.e0;

  if(out->v4rho2sigmalapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmalapl[ip*p->dim.v4rho2sigmalapl + 17] += tv4rho2sigmalapl17;

  t8255 = t6823 * t3799;
  t8257 = t3128 * t3802;
  t8264 = t258 * t3669 * t342 * t1438;
  t8271 = t258 * t1734 * t864;
  t8287 = -t258 * t665 * t342 * t552 * t3121 / 0.6e1 + t1435 * t6829 * t518 / 0.32e2 + t6809 * t3799 / 0.48e2 + t3124 * t3802 / 0.16e2 + t8255 / 0.144e3 + t8257 / 0.48e2 - t741 * t3779 * t1438 / 0.6e1 - t8264 / 0.18e2 - t258 * t3775 * t342 * t1438 / 0.6e1 - t8271 * t2984 / 0.36e2 - t1435 * t3120 * t1185 / 0.6e1 + t1435 * t6842 * t518 / 0.32e2 - 0.3e1 / 0.32e2 * t2981 * t2983 * t2658 + 0.11e2 / 0.36e2 * t3780 * t3117 + t6813 * t3799 / 0.48e2;
  t8295 = t3128 * t3816;
  t8301 = t1233 * t107;
  t8305 = t553 * params->e;
  t8315 = t6070 * t1745;
  t8318 = t6059 * t1745 / 0.12e2;
  t8319 = t2577 * t3784;
  t8329 = t3132 * t3802 / 0.16e2 + 0.11e2 / 0.36e2 * t1435 * t3815 * t818 - t3124 * t3816 / 0.6e1 - t8295 / 0.18e2 - t3132 * t3816 / 0.6e1 - t3780 * t3121 / 0.6e1 - t1435 * t8301 * t307 / 0.6e1 - t2981 * t8305 * t841 / 0.36e2 + t2981 * t6838 * t1204 / 0.48e2 - 0.3e1 / 0.8e1 * t1237 * t3783 * t878 - t8315 / 0.4e1 + t8318 - t8319 / 0.4e1 - 0.3e1 / 0.4e1 * t1237 * t3102 * t1233 - 0.3e1 / 0.8e1 * t1237 * t1441 * t2731 - 0.3e1 / 0.4e1 * t2568 * t3784;
  t8341 = t6 * t746 * t664 * t1742 / 0.144e3;
  t8342 = t3792 * t3805;
  t8346 = t6 * t737 * t664 * t1742;
  t8358 = t6 * t254 * t1429 * t1742;
  t8366 = t2577 * t3812;
  t8368 = t2577 * t3819;
  t8373 = t3774 * t127;
  t8377 = 0.11e2 / 0.36e2 * t1739 * t1741 * t2647 - t3796 * t3805 / 0.6e1 - t3788 * t3805 / 0.6e1 - t8341 - t8342 / 0.18e2 + t8346 / 0.48e2 + t6 * t733 * t664 * t1742 / 0.32e2 + t6 * t248 * t1429 * t1742 / 0.16e2 + t8358 / 0.48e2 + t6 * t28 * t3095 * t1742 / 0.32e2 - 0.3e1 / 0.4e1 * t2568 * t3819 - t8366 / 0.4e1 - t8368 / 0.4e1 - 0.3e1 / 0.8e1 * t1237 * t7067 * t553 - 0.3e1 / 0.4e1 * t1237 * t8373 * t349;
  t8403 = t2577 * t3824;
  t8405 = t6237 * t29;
  t8415 = t2090 * sigma[0];
  t8420 = t2082 * sigma[0];
  t8434 = 0.73e2 / 0.8e3 * t8405 * t3081 + 0.73e2 / 0.3e3 * t3747 * t3084 + 0.73e2 / 0.3e3 * t3075 * t3757 - 0.73e2 / 0.2e3 * t1420 * t2998 * t531 + 0.73e2 / 0.4e3 * t8415 * t3081 + 0.73e2 / 0.15e3 * t3765 * t3084 - 0.73e2 / 0.3e3 * t8420 * t1421 - 0.73e2 / 0.6e3 * t3765 * t3087 - 0.73e2 / 0.12e4 * t3747 * t3087 - 0.73e2 / 0.12e4 * t6874 * t1725 - 0.73e2 / 0.6e3 * t3075 * t3760 + 0.73e2 / 0.3e3 * t1420 * t1372 * t1206;
  t8438 = t6240 * t29;
  t8459 = t3730 * t314;
  t8462 = -0.73e2 / 0.12e4 * t1420 * t628 * t2595 - 0.73e2 / 0.6e3 * t8438 * t1421 + 0.292e3 / 0.2025e4 * t2649 * t654 + 0.73e2 / 0.3888e6 * t3068 * t2695 - t538 * t2998 / 0.3e2 + t3017 * t503 / 0.24e2 + 0.73e2 / 0.1944e6 * t6996 * t1197 + 0.73e2 / 0.1944e6 * t3068 * t2692 - 0.2e1 / 0.9e1 * t1387 * t1158 + 0.11e2 / 0.27e2 * t639 * t2682 - 0.73e2 / 0.2592e6 * t6993 * t2655 - 0.73e2 / 0.972e5 * t8459 * t325;
  t8497 = t6918 * t515;
  t8500 = t3036 * t1182;
  t8521 = -0.45e2 / 0.32e2 * t3700 * t6100 + 0.45e2 / 0.256e3 * t518 * t6930 + 0.9e1 / 0.16e2 * t6150 * t3711 + 0.9e1 / 0.8e1 * t2617 * t8497 + 0.9e1 / 0.8e1 * t2617 * t8500 + 0.9e1 / 0.8e1 * t3700 * t6138 + 0.9e1 / 0.16e2 * t3700 * t6141 + 0.3e1 / 0.8e1 * t1185 * t3037 - 0.9e1 / 0.64e2 * t518 * t6919 - 0.9e1 / 0.128e3 * t518 * t6922 - 0.75e2 / 0.16e2 * t7779 * t4657 * t304 - 0.325e3 / 0.24e2 * t3398 - 0.5e1 / 0.3e1 * t3380 + 0.5e1 / 0.4e1 * t3384 - 0.15e2 / 0.8e1 * t3382 + 0.65e2 / 0.6e1 * t3407;
  t8560 = t6929 * t1171;
  t8563 = 0.25e2 / 0.16e2 * t7753 * t3723 - 0.3e1 / 0.8e1 * t642 * t6128 - t1163 * t3040 / 0.4e1 + 0.3e1 / 0.64e2 * t506 * t6904 - 0.81e2 / 0.16e2 * t2054 * t3717 * t304 - 0.81e2 / 0.16e2 * t2054 * t3720 * t304 - 0.81e2 / 0.32e2 * t2054 * t1707 * t815 + 0.567e3 / 0.64e2 * t5039 * t1707 * t802 + 0.11e2 / 0.24e2 * t2606 * t1397 + 0.195e3 / 0.32e2 * t3404 + 0.81e2 / 0.8e2 * t801 * t3057 * t515 + 0.81e2 / 0.4e2 * t801 * t1407 * t1182 + 0.81e2 / 0.8e2 * t801 * t651 * t2644 + 0.225e3 / 0.128e3 * t7788 * t1712 * t7789 - 0.45e2 / 0.64e2 * t3400 * t1712 * t7799 - 0.45e2 / 0.16e2 * t2617 * t8560;
  t8564 = t8521 + t8563;
  t8567 = -0.73e2 / 0.75e2 * t825 * t3768 + 0.73e2 / 0.5e2 * t315 * t2589 * t627 - 0.2e1 / 0.9e1 * t3684 * t283 + 0.11e2 / 0.27e2 * t1696 * t781 - 0.73e2 / 0.15e3 * t2580 * t1424 + 0.73e2 / 0.1e3 * t1192 * t3090 - 0.73e2 / 0.32e3 * t6867 * t628 * t2655 - 0.73e2 / 0.2e3 * t3080 * t1372 * t1197 + 0.73e2 / 0.4e3 * t6862 * t3754 + 0.73e2 / 0.4e3 * t3080 * t628 * t2692 + 0.73e2 / 0.8e3 * t3080 * t628 * t2695 - 0.73e2 / 0.972e5 * t8564 * t98;
  t8604 = t1716 * t829;
  t8609 = 0.73e2 / 0.3e3 * t2079 * t1728 + (-0.3e1 / 0.8e1 * t490 * t2999 + 0.37e2 / 0.256e3 * t493 * t3003 - 0.21e2 / 0.2048e4 * t1144 * t3007 + 0.63e2 / 0.262144e6 * t2671 * t3013 - 0.15e2 / 0.8388608e7 * t6187 * t5001 * t4830 * t5148) * t46 * t57 / 0.24e2 + 0.73e2 / 0.6e3 * t6262 * t659 + 0.292e3 / 0.2025e4 * t82 * t8564 - 0.73e2 / 0.1944e6 * t3735 * t843 - 0.73e2 / 0.1944e6 * t6999 * t531 - 0.73e2 / 0.972e5 * t3065 * t1206 - 0.73e2 / 0.1944e6 * t1415 * t2595 + 0.584e3 / 0.2025e4 * t1187 * t1410 + 0.292e3 / 0.2025e4 * t520 * t3060 + 0.292e3 / 0.2025e4 * t820 * t1716 + 0.73e2 / 0.3888e6 * t8604 * t831 + 0.584e3 / 0.2025e4 * t309 * t3730;
  t8620 = t258 * t253 * t3774 * t666;
  t8624 = t741 * t3670;
  t8629 = t258 * t745 * t1733 * t666 / 0.12e2;
  t8635 = -0.3e1 / 0.8e1 * t1237 * t3783 * t873 - 0.3e1 / 0.8e1 * t6066 * t1745 - 0.3e1 / 0.4e1 * t2568 * t3812 - 0.3e1 / 0.4e1 * t1237 * t3102 * t3823 - 0.3e1 / 0.4e1 * t1237 * t1441 * t7574 - 0.3e1 / 0.8e1 * t1237 * t1441 * t552 * t872 * t130 - 0.3e1 / 0.4e1 * t2568 * t3824 - 0.3e1 / 0.8e1 * t1237 * t1441 * t552 * t877 * t130 - t8403 / 0.4e1 - 0.3e1 / 0.8e1 * t258 * t27 * (t8434 + t8462 + t8567 + t8609) * t666 - 0.3e1 / 0.8e1 * t1983 * t1735 - t8620 / 0.4e1 - 0.3e1 / 0.4e1 * t741 * t3776 - t8624 / 0.4e1 + t8629 + t7079 * t7080 * t2133 * t852 * t29 / 0.36e2;
  t8638 = my_piecewise3(t2, 0, t8287 + t8329 + t8377 + t8635);
  tv4rho2sigmatau0 = t7 * t8638 + 0.2e1 * t3828;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 0] += tv4rho2sigmatau0;

  tv4rho2sigmatau1 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 1] += tv4rho2sigmatau1;

  tv4rho2sigmatau2 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 2] += tv4rho2sigmatau2;

  tv4rho2sigmatau3 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 3] += tv4rho2sigmatau3;

  tv4rho2sigmatau4 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 4] += tv4rho2sigmatau4;

  t8643 = t955 * t3833;
  t8648 = t393 * t745 * t1796 * t711 / 0.12e2;
  t8655 = t6 * t901 * t709 * t1805;
  t8660 = t6 * t905 * t709 * t1805 / 0.144e3;
  t8663 = t6417 * t1808;
  t8666 = t6420 * t1808 / 0.12e2;
  t8668 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2262 * t1798 - t8643 / 0.4e1 + t8648 + t6 * t897 * t709 * t1805 / 0.32e2 + t8655 / 0.48e2 - t8660 - 0.3e1 / 0.8e1 * t6414 * t1808 - t8663 / 0.4e1 + t8666);
  tv4rho2sigmatau5 = t7 * t8668 + 0.2e1 * t3849;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 5] += tv4rho2sigmatau5;

  t8679 = t6377 * t1745;
  t8693 = t8255 / 0.288e3 + t8257 / 0.96e2 - t8264 / 0.36e2 - t930 * t3779 * t1438 / 0.12e2 - t3156 * t3816 / 0.12e2 - t8295 / 0.36e2 - t8679 / 0.8e1 - 0.3e1 / 0.8e1 * t2765 * t3812 - 0.3e1 / 0.8e1 * t2765 * t3819 - 0.3e1 / 0.8e1 * t2765 * t3784 - 0.3e1 / 0.8e1 * t6372 * t1745 - t8315 / 0.8e1 + t8318 - t8319 / 0.8e1 - t8341 - t8342 / 0.36e2 + t8346 / 0.96e2;
  t8704 = t6 * t926 * t664 * t1742;
  t8718 = t930 * t3670;
  t8726 = t6 * t922 * t664 * t1742 / 0.32e2 + t6 * t378 * t1429 * t1742 / 0.32e2 + t8704 / 0.96e2 - t3854 * t3805 / 0.12e2 + t8358 / 0.96e2 - t8366 / 0.8e1 - t8368 / 0.8e1 - 0.3e1 / 0.8e1 * t2765 * t3824 - t8403 / 0.8e1 - 0.3e1 / 0.8e1 * t930 * t3776 - 0.3e1 / 0.8e1 * t2212 * t1735 - t8718 / 0.8e1 - t8620 / 0.8e1 - t8624 / 0.8e1 + t8629 + t7111 * t3799 / 0.96e2 + t3156 * t3802 / 0.32e2;
  t8728 = my_piecewise3(t2, 0, t8693 + t8726);
  tv4rho2sigmatau6 = t7 * t8728 + t3828 + t3860;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 6] += tv4rho2sigmatau6;

  tv4rho2sigmatau7 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 7] += tv4rho2sigmatau7;

  tv4rho2sigmatau8 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 8] += tv4rho2sigmatau8;

  tv4rho2sigmatau9 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 9] += tv4rho2sigmatau9;

  tv4rho2sigmatau10 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 10] += tv4rho2sigmatau10;

  t8730 = t3183 * t4001;
  t8734 = t2787 * t4004;
  t8742 = t2787 * t3975;
  t8744 = t6454 * t1808;
  t8746 = t2787 * t3997;
  t8759 = t3841 * t3992;
  t8763 = t6 * t950 * t709 * t1805;
  t8767 = t6 * t365 * t1521 * t1805;
  t8769 = -t8730 / 0.36e2 - t3179 * t4001 / 0.12e2 - t8734 / 0.8e1 - 0.3e1 / 0.8e1 * t2784 * t3975 - 0.3e1 / 0.8e1 * t6451 * t1808 - 0.3e1 / 0.8e1 * t2784 * t3997 - t8742 / 0.8e1 - t8744 / 0.8e1 - t8746 / 0.8e1 - 0.3e1 / 0.8e1 * t2784 * t4004 - t8663 / 0.8e1 + t8666 + t6 * t946 * t709 * t1805 / 0.32e2 + t6 * t361 * t1521 * t1805 / 0.32e2 - t8759 / 0.36e2 + t8763 / 0.96e2 + t8767 / 0.96e2;
  t8773 = t2787 * t4009;
  t8777 = t3183 * t3989;
  t8781 = t393 * t3832 * t476 * t1530;
  t8783 = t7231 * t3986;
  t8796 = t393 * t253 * t3965 * t711;
  t8800 = t999 * t3833;
  t8803 = t8655 / 0.96e2 - t8660 - t3837 * t3992 / 0.12e2 - t8773 / 0.8e1 - 0.3e1 / 0.8e1 * t2784 * t4009 + t8777 / 0.96e2 - t8781 / 0.36e2 + t8783 / 0.288e3 + t3179 * t3989 / 0.32e2 + t7239 * t3986 / 0.96e2 - t955 * t3970 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t955 * t3967 - t8796 / 0.8e1 - 0.3e1 / 0.8e1 * t2327 * t1798 - t8800 / 0.8e1 - t8643 / 0.8e1 + t8648;
  t8805 = my_piecewise3(t138, 0, t8769 + t8803);
  tv4rho2sigmatau11 = t7 * t8805 + t3849 + t4013;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 11] += tv4rho2sigmatau11;

  t8820 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2296 * t1735 - t8718 / 0.4e1 + t8629 + t6 * t977 * t664 * t1742 / 0.32e2 + t8704 / 0.48e2 - t8341 - 0.3e1 / 0.8e1 * t6432 * t1745 - t8679 / 0.4e1 + t8318);
  tv4rho2sigmatau12 = t7 * t8820 + 0.2e1 * t3860;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 12] += tv4rho2sigmatau12;

  tv4rho2sigmatau13 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 13] += tv4rho2sigmatau13;

  tv4rho2sigmatau14 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 14] += tv4rho2sigmatau14;

  tv4rho2sigmatau15 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 15] += tv4rho2sigmatau15;

  tv4rho2sigmatau16 = 0.e0;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 16] += tv4rho2sigmatau16;

  t8838 = t1354 * t107;
  t8842 = t621 * params->e;
  t8859 = t3965 * t229;
  t8866 = -t393 * t710 * t476 * t620 * t3340 / 0.6e1 + 0.11e2 / 0.36e2 * t1527 * t4000 * t1067 - t3971 * t3340 / 0.6e1 - t8730 / 0.18e2 - t3219 * t4001 / 0.6e1 - t3223 * t4001 / 0.6e1 - t1527 * t8838 * t441 / 0.6e1 - t3213 * t8842 * t1090 / 0.36e2 + t3213 * t7346 * t1325 / 0.48e2 - 0.3e1 / 0.8e1 * t1358 * t3974 * t1126 - 0.3e1 / 0.4e1 * t2806 * t4004 - 0.3e1 / 0.4e1 * t2806 * t3975 - 0.3e1 / 0.8e1 * t1358 * t1533 * t2962 - 0.3e1 / 0.4e1 * t1358 * t8859 * t482 - 0.3e1 / 0.8e1 * t1358 * t3974 * t1121;
  t8895 = -0.3e1 / 0.8e1 * t6764 * t1808 - 0.3e1 / 0.4e1 * t2806 * t3997 - 0.3e1 / 0.8e1 * t1358 * t7539 * t621 - 0.3e1 / 0.4e1 * t1358 * t3203 * t1354 - t8734 / 0.4e1 - t8742 / 0.4e1 - t8744 / 0.4e1 - t8746 / 0.4e1 + t8666 + t6 * t147 * t3331 * t1805 / 0.32e2 + 0.11e2 / 0.36e2 * t1802 * t1804 * t2856 - t3983 * t3992 / 0.6e1 - t3979 * t3992 / 0.6e1 - t8759 / 0.18e2 + t8763 / 0.48e2 + t8767 / 0.48e2;
  t8907 = t6571 * t148;
  t8921 = t2498 * sigma[2];
  t8924 = t6578 * t148;
  t8935 = 0.73e2 / 0.15e3 * t3956 * t3320 + 0.73e2 / 0.8e3 * t8907 * t3317 + 0.73e2 / 0.3e3 * t3938 * t3320 + 0.73e2 / 0.3e3 * t3311 * t3948 - 0.73e2 / 0.12e4 * t7376 * t1788 - 0.73e2 / 0.6e3 * t3311 * t3951 - 0.73e2 / 0.2e3 * t1512 * t3234 * t599 + 0.73e2 / 0.4e3 * t8921 * t3317 - 0.73e2 / 0.6e3 * t8924 * t1513 - 0.73e2 / 0.12e4 * t3938 * t3323 + 0.73e2 / 0.3e3 * t1512 * t1464 * t1327 - 0.73e2 / 0.12e4 * t1512 * t673 * t2924;
  t8936 = t2490 * sigma[2];
  t8962 = -0.73e2 / 0.3e3 * t8936 * t1513 - 0.73e2 / 0.6e3 * t3956 * t3323 + 0.292e3 / 0.2025e4 * t1069 * t1779 + 0.292e3 / 0.2025e4 * t588 * t3296 + 0.584e3 / 0.2025e4 * t1308 * t1502 + 0.292e3 / 0.2025e4 * t2858 * t699 - 0.2e1 / 0.9e1 * t3875 * t417 + 0.11e2 / 0.27e2 * t1759 * t1030 - 0.73e2 / 0.15e3 * t2909 * t1516 + 0.73e2 / 0.1e3 * t1313 * t3326 - 0.73e2 / 0.75e2 * t1074 * t3959 + 0.73e2 / 0.5e2 * t449 * t2918 * t672;
  t8978 = t1779 * t1078;
  t9007 = -0.73e2 / 0.32e3 * t7353 * t673 * t2887 - 0.73e2 / 0.2e3 * t3316 * t1464 * t1318 + 0.73e2 / 0.4e3 * t3316 * t673 * t2901 + 0.73e2 / 0.8e3 * t3316 * t673 * t2904 + 0.73e2 / 0.4e3 * t7363 * t3945 + 0.73e2 / 0.3888e6 * t8978 * t1080 + 0.73e2 / 0.6e3 * t6581 * t704 + 0.73e2 / 0.3e3 * t2487 * t1791 + (-0.3e1 / 0.8e1 * t558 * t3235 + 0.37e2 / 0.256e3 * t561 * t3239 - 0.21e2 / 0.2048e4 * t1265 * t3243 + 0.63e2 / 0.262144e6 * t2873 * t3249 - 0.15e2 / 0.8388608e7 * t6660 * t5804 * t4912 * t5829) * t46 * t171 / 0.24e2 + 0.73e2 / 0.1944e6 * t7498 * t1318 + 0.73e2 / 0.1944e6 * t3304 * t2901 + 0.73e2 / 0.3888e6 * t3304 * t2904;
  t9026 = t3921 * t448;
  t9046 = t7413 * t583;
  t9049 = t3272 * t1303;
  t9063 = 0.65e2 / 0.6e1 * t3577 - 0.15e2 / 0.8e1 * t3552 + 0.45e2 / 0.256e3 * t586 * t7430 - 0.75e2 / 0.16e2 * t8000 * t4752 * t438 + 0.9e1 / 0.8e1 * t3891 * t6529 + 0.9e1 / 0.16e2 * t3891 * t6515 - 0.45e2 / 0.32e2 * t3891 * t6550 - 0.9e1 / 0.128e3 * t586 * t7417 + 0.9e1 / 0.16e2 * t6525 * t3902 + 0.9e1 / 0.8e1 * t2826 * t9046 + 0.9e1 / 0.8e1 * t2826 * t9049 + 0.3e1 / 0.8e1 * t1306 * t3273 - 0.9e1 / 0.64e2 * t586 * t7414 + 0.11e2 / 0.24e2 * t2815 * t1489 - 0.81e2 / 0.32e2 * t2462 * t1770 * t1064 + 0.25e2 / 0.16e2 * t8029 * t3914;
  t9083 = t7429 * t1292;
  t9101 = -0.3e1 / 0.8e1 * t687 * t6506 - t1284 * t3276 / 0.4e1 + 0.3e1 / 0.64e2 * t574 * t7393 - 0.81e2 / 0.16e2 * t2462 * t3908 * t438 - 0.81e2 / 0.16e2 * t2462 * t3911 * t438 + 0.567e3 / 0.64e2 * t5872 * t1770 * t1051 + 0.195e3 / 0.32e2 * t3574 + 0.225e3 / 0.128e3 * t8041 * t1775 * t8042 - 0.45e2 / 0.16e2 * t2826 * t9083 - 0.45e2 / 0.64e2 * t3570 * t1775 * t8034 + 0.81e2 / 0.8e2 * t1050 * t3293 * t583 + 0.81e2 / 0.4e2 * t1050 * t1499 * t1303 + 0.81e2 / 0.8e2 * t1050 * t696 * t2853 - 0.325e3 / 0.24e2 * t3568 - 0.5e1 / 0.3e1 * t3550 + 0.5e1 / 0.4e1 * t3554;
  t9102 = t9063 + t9101;
  t9109 = -t606 * t3234 / 0.3e2 + t3253 * t571 / 0.24e2 + 0.11e2 / 0.27e2 * t684 * t2884 - 0.2e1 / 0.9e1 * t1479 * t1279 - 0.73e2 / 0.2592e6 * t7501 * t2887 - 0.73e2 / 0.972e5 * t3301 * t1327 - 0.73e2 / 0.1944e6 * t1507 * t2924 - 0.73e2 / 0.1944e6 * t7495 * t599 - 0.73e2 / 0.1944e6 * t3926 * t1092 - 0.73e2 / 0.972e5 * t9026 * t459 - 0.73e2 / 0.972e5 * t9102 * t207 + 0.584e3 / 0.2025e4 * t443 * t3921 + 0.292e3 / 0.2025e4 * t195 * t9102;
  t9148 = t6 * t994 * t709 * t1805 / 0.32e2 + t6 * t389 * t1521 * t1805 / 0.16e2 - t8660 - 0.3e1 / 0.8e1 * t393 * t27 * (t8935 + t8962 + t9007 + t9109) * t711 - 0.3e1 / 0.4e1 * t999 * t3967 - 0.3e1 / 0.8e1 * t2554 * t1798 - 0.3e1 / 0.8e1 * t1358 * t1533 * t620 * t1120 * t232 - 0.3e1 / 0.8e1 * t1358 * t1533 * t620 * t1125 * t232 - 0.3e1 / 0.4e1 * t2806 * t4009 - 0.3e1 / 0.4e1 * t1358 * t3203 * t4008 - 0.3e1 / 0.4e1 * t1358 * t1533 * t8226 - t8773 / 0.4e1 + t3219 * t3989 / 0.16e2 - t999 * t3970 * t1530 / 0.6e1 - t393 * t3966 * t476 * t1530 / 0.6e1;
  t9157 = t393 * t1797 * t1113;
  t9183 = t1527 * t7342 * t586 / 0.32e2 + t7321 * t3986 / 0.48e2 + t3223 * t3989 / 0.16e2 - t9157 * t3216 / 0.36e2 + t7317 * t3986 / 0.48e2 - t1527 * t3339 * t1306 / 0.6e1 + t1527 * t7334 * t586 / 0.32e2 - 0.3e1 / 0.32e2 * t3213 * t3215 * t2890 + 0.11e2 / 0.36e2 * t3971 * t3336 + t8777 / 0.48e2 - t8781 / 0.18e2 + t8783 / 0.144e3 - t8796 / 0.4e1 - t8800 / 0.4e1 + t8648 + t7558 * t7559 * t2133 * t1101 * t148 / 0.36e2;
  t9186 = my_piecewise3(t138, 0, t8866 + t8895 + t9148 + t9183);
  tv4rho2sigmatau17 = t7 * t9186 + 0.2e1 * t4013;

  if(out->v4rho2sigmatau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2sigmatau[ip*p->dim.v4rho2sigmatau + 17] += tv4rho2sigmatau17;

  tv4rho2lapl20 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 0] += tv4rho2lapl20;

  tv4rho2lapl21 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 1] += tv4rho2lapl21;

  tv4rho2lapl22 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 2] += tv4rho2lapl22;

  tv4rho2lapl23 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 3] += tv4rho2lapl23;

  tv4rho2lapl24 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 4] += tv4rho2lapl24;

  tv4rho2lapl25 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 5] += tv4rho2lapl25;

  tv4rho2lapl26 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 6] += tv4rho2lapl26;

  tv4rho2lapl27 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 7] += tv4rho2lapl27;

  tv4rho2lapl28 = 0.e0;

  if(out->v4rho2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapl2[ip*p->dim.v4rho2lapl2 + 8] += tv4rho2lapl28;

  tv4rho2lapltau0 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 0] += tv4rho2lapltau0;

  tv4rho2lapltau1 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 1] += tv4rho2lapltau1;

  tv4rho2lapltau2 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 2] += tv4rho2lapltau2;

  tv4rho2lapltau3 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 3] += tv4rho2lapltau3;

  tv4rho2lapltau4 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 4] += tv4rho2lapltau4;

  tv4rho2lapltau5 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 5] += tv4rho2lapltau5;

  tv4rho2lapltau6 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 6] += tv4rho2lapltau6;

  tv4rho2lapltau7 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 7] += tv4rho2lapltau7;

  tv4rho2lapltau8 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 8] += tv4rho2lapltau8;

  tv4rho2lapltau9 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 9] += tv4rho2lapltau9;

  tv4rho2lapltau10 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 10] += tv4rho2lapltau10;

  tv4rho2lapltau11 = 0.e0;

  if(out->v4rho2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2lapltau[ip*p->dim.v4rho2lapltau + 11] += tv4rho2lapltau11;

  t9189 = t2130 * t101;
  t9191 = t258 * t4127 * t9189;
  t9195 = t258 * t665 * t9189;
  t9203 = t741 * t4128;
  t9208 = t258 * t253 * t1864 * t2130;
  t9209 = t9208 * t4131;
  t9212 = t258 * t4127 * t4889;
  t9213 = t1866 * params->e;
  t9220 = t2577 * t4115;
  t9222 = t4105 * t127;
  t9236 = t6070 * t1867;
  t9239 = t6059 * t1867 / 0.12e2;
  t9240 = t1429 * t1429;
  t9247 = t258 * t253 * t4105 * t666;
  t9249 = t9191 * t3121 / 0.3e1 + 0.2e1 / 0.3e1 * t9195 * t130 * t1429 * t107 * t307 - t4111 * t3121 / 0.6e1 + t9203 * t4131 / 0.3e1 + t9209 / 0.9e1 + 0.5e1 / 0.54e2 * t9212 * t9213 * t841 - 0.11e2 / 0.18e2 * t4129 * t4130 * t818 - t9220 / 0.4e1 - 0.3e1 / 0.4e1 * t1237 * t9222 * t349 - 0.3e1 / 0.8e1 * t1237 * t4114 * t873 + 0.3e1 / 0.8e1 * t6066 * t1867 - 0.3e1 / 0.4e1 * t2568 * t4115 - 0.3e1 / 0.8e1 * t1237 * t4114 * t878 + t9236 / 0.4e1 - t9239 + 0.3e1 / 0.4e1 * t1237 * t9240 * t864 * t1866 - t9247 / 0.4e1;
  t9252 = t5120 * t266;
  t9273 = t6993 * t29;
  t9276 = t1410 * t1410;
  t9280 = t5112 * t266;
  t9283 = t6996 * t29;
  t9288 = t1844 * t829;
  t9297 = 0.73e2 / 0.15e3 * t4080 * t3084 + 0.5913e4 / 0.8e2 * t9252 * t1817 * t831 + 0.5913e4 / 0.25e2 * t4087 * t4025 * t325 - 0.219e3 / 0.8e3 * t3080 * t1813 * t831 - 0.73e2 / 0.1e3 * t1420 * t4021 * t325 - 0.5913e4 / 0.2e3 * t4087 * t1817 * t843 + 0.73e2 / 0.2e3 * t3075 * t4097 + 0.73e2 / 0.4e3 * t1420 * t1813 * t843 + 0.73e2 / 0.4e3 * t9273 * t3081 + 0.584e3 / 0.2025e4 * t9276 - 0.73e2 / 0.6e3 * t4080 * t3087 - 0.5913e4 / 0.1e3 * t9280 * t4088 - 0.73e2 / 0.3e3 * t9283 * t1421 + t108 * t495 / 0.2e2 + 0.73e2 / 0.3888e6 * t9288 * t831 + 0.11e2 / 0.27e2 * t1828 * t781 + 0.1971e4 / 0.5e1 * t830 * t266 * t758 * t766;
  t9314 = t1407 * t1407;
  t9336 = t2053 * t1835;
  t9337 = t9336 * t304;
  t9340 = -0.81e2 / 0.32e2 * t2054 * t1835 * t815 + 0.81e2 / 0.4e2 * t801 * t9314 + 0.81e2 / 0.4e2 * t801 * t651 * t3057 - 0.3e1 / 0.4e1 * t642 * t6904 + 0.9e1 / 0.16e2 * t791 * t4054 + 0.567e3 / 0.64e2 * t5039 * t1835 * t802 - 0.81e2 / 0.8e1 * t2054 * t1400 * t1407 - 0.25e2 / 0.2e1 * t7753 * t4063 + 0.9e1 / 0.4e1 * t3700 * t6919 + 0.9e1 / 0.8e1 * t3700 * t6922 - 0.45e2 / 0.16e2 * t2617 * t9337;
  t9341 = t3036 * t1407;
  t9361 = 0.9e1 / 0.4e1 * t2617 * t9341 + 0.75e2 / 0.2e1 * t7779 * t4849 * t304 - 0.225e3 / 0.16e2 * t7788 * t1840 * t7789 - 0.45e2 / 0.16e2 * t3700 * t6930 + 0.45e2 / 0.8e1 * t3400 * t1840 * t7799 + 0.5e1 / 0.2e1 * t3709 + 0.25e3 / 0.3e1 * t3724 - 0.1e2 / 0.3e1 * t3705 - 0.15e2 / 0.4e1 * t3707 - 0.75e2 / 0.2e1 * t3727 - 0.325e3 / 0.6e1 * t1565;
  t9362 = t9340 + t9361;
  t9386 = t852 * t4034;
  t9391 = 0.1e1 / t1821 / t269;
  t9402 = t4070 * t314;
  t9407 = 0.73e2 / 0.5e2 * t825 * t4100 - 0.219e3 / 0.1e3 * t315 * t834 * t270 - 0.2e1 / 0.9e1 * t4040 * t283 + 0.73e2 / 0.5e2 * t1415 * t3090 - 0.3942e4 / 0.25e2 * t2082 * t4092 - 0.73e2 / 0.75e2 * t3065 * t1424 - 0.73e2 / 0.972e5 * t9362 * t98 + 0.292e3 / 0.2025e4 * t82 * t9362 + 0.584e3 / 0.2025e4 * t309 * t4070 + 0.292e3 / 0.2025e4 * t820 * t1844 + 0.584e3 / 0.2025e4 * t654 * t3060 + 0.73e2 / 0.3e3 * t6999 * t659 - 0.73e2 / 0.2e3 * t2079 * t1855 + (0.9e1 / 0.16e2 * t30 * t495 * t41 - 0.91e2 / 0.512e3 * t267 * t1546 * t273 + 0.375e3 / 0.32768e5 * t764 * t4289 * t769 - 0.33e2 / 0.131072e6 * t2010 * t9386 * t2015 + 0.15e2 / 0.8388608e7 * t5143 * t5001 * t9391 * t5148) * t46 * t57 / 0.24e2 + 0.1971e4 / 0.1e3 * t5109 * t1852 - 0.73e2 / 0.972e5 * t9402 * t325 - 0.73e2 / 0.1944e6 * t4075 * t843;
  t9417 = t741 * t4018;
  t9422 = t258 * t745 * t1860 * t666 / 0.12e2;
  t9430 = t2577 * t4124;
  t9432 = t2577 * t4136;
  t9448 = t258 * t1861 * t864;
  t9456 = t258 * t4017 * t342 * t1438;
  t9462 = t864 * t101;
  t9467 = -0.3e1 / 0.8e1 * t258 * t27 * (t9297 + t9407) * t666 - 0.3e1 / 0.8e1 * t1983 * t1862 - 0.3e1 / 0.4e1 * t741 * t4107 - t9417 / 0.4e1 + t9422 + 0.3e1 / 0.8e1 * t1237 * t1865 * t101 * t877 * t130 + 0.3e1 / 0.4e1 * t2568 * t4136 + t9430 / 0.2e1 + t9432 / 0.4e1 + 0.3e1 / 0.4e1 * t1237 * t4122 * t1866 * t3095 + 0.3e1 / 0.8e1 * t1237 * t1865 * t101 * t872 * t130 + 0.3e1 / 0.2e1 * t2568 * t4124 + 0.11e2 / 0.36e2 * t4111 * t3117 - t9448 * t2984 / 0.36e2 - t741 * t4110 * t1438 / 0.6e1 - t9456 / 0.18e2 - t258 * t4106 * t342 * t1438 / 0.6e1 + 0.3e1 / 0.2e1 * t1739 * t9462 * t349 * t1429;
  t9469 = my_piecewise3(t2, 0, t9249 + t9467);
  tv4rho2tau20 = t7 * t9469 + 0.2e1 * t4140;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 0] += tv4rho2tau20;

  tv4rho2tau21 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 1] += tv4rho2tau21;

  t9474 = t955 * t4145;
  t9479 = t393 * t745 * t1919 * t711 / 0.12e2;
  t9482 = t6417 * t1926;
  t9485 = t6420 * t1926 / 0.12e2;
  t9487 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t2262 * t1921 - t9474 / 0.4e1 + t9479 + 0.3e1 / 0.8e1 * t6414 * t1926 + t9482 / 0.4e1 - t9485);
  tv4rho2tau22 = t7 * t9487 + 0.2e1 * t4153;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 2] += tv4rho2tau22;

  t9491 = t930 * t4018;
  t9506 = t6377 * t1867;
  t9510 = t930 * t4128;
  t9519 = -0.3e1 / 0.8e1 * t2212 * t1862 - t9491 / 0.8e1 - 0.3e1 / 0.8e1 * t930 * t4107 - t930 * t4110 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t2765 * t4115 - t9417 / 0.8e1 + t9422 - t9247 / 0.8e1 - t9456 / 0.36e2 - t9220 / 0.8e1 + 0.3e1 / 0.8e1 * t6372 * t1867 + t9506 / 0.8e1 + 0.3e1 / 0.4e1 * t2765 * t4124 + t9510 * t4131 / 0.6e1 + 0.3e1 / 0.8e1 * t2765 * t4136 + t9236 / 0.8e1 - t9239 + t9430 / 0.4e1 + t9209 / 0.18e2 + t9432 / 0.8e1;
  t9520 = my_piecewise3(t2, 0, t9519);
  tv4rho2tau23 = t7 * t9520 + t4140 + t4160;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 3] += tv4rho2tau23;

  tv4rho2tau24 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 4] += tv4rho2tau24;

  t9524 = t999 * t4145;
  t9531 = t393 * t253 * t4248 * t711;
  t9538 = t393 * t4144 * t476 * t1530;
  t9542 = t2787 * t4258;
  t9546 = t6454 * t1926;
  t9551 = t2787 * t4265;
  t9553 = t955 * t4269;
  t9558 = t393 * t253 * t1923 * t2538;
  t9559 = t9558 * t4272;
  t9563 = t2787 * t4277;
  t9565 = -0.3e1 / 0.8e1 * t2327 * t1921 - t9524 / 0.8e1 - t9474 / 0.8e1 + t9479 - 0.3e1 / 0.8e1 * t955 * t4250 - t9531 / 0.8e1 - t955 * t4253 * t1530 / 0.12e2 - t9538 / 0.36e2 - 0.3e1 / 0.8e1 * t2784 * t4258 - t9542 / 0.8e1 + 0.3e1 / 0.8e1 * t6451 * t1926 + t9546 / 0.8e1 + t9482 / 0.8e1 - t9485 + 0.3e1 / 0.4e1 * t2784 * t4265 + t9551 / 0.4e1 + t9553 * t4272 / 0.6e1 + t9559 / 0.18e2 + 0.3e1 / 0.8e1 * t2784 * t4277 + t9563 / 0.8e1;
  t9566 = my_piecewise3(t138, 0, t9565);
  tv4rho2tau25 = t7 * t9566 + t4153 + t4281;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 5] += tv4rho2tau25;

  t9576 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t2296 * t1862 - t9491 / 0.4e1 + t9422 + 0.3e1 / 0.8e1 * t6432 * t1867 + t9506 / 0.4e1 - t9239);
  tv4rho2tau26 = t7 * t9576 + 0.2e1 * t4160;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 6] += tv4rho2tau26;

  tv4rho2tau27 = 0.e0;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 7] += tv4rho2tau27;

  t9579 = t2538 * t101;
  t9581 = t393 * t4268 * t9579;
  t9585 = t393 * t710 * t9579;
  t9593 = t393 * t4268 * t4971;
  t9594 = t1925 * params->e;
  t9600 = t999 * t4269;
  t9608 = t1521 * t1521;
  t9616 = t4248 * t229;
  t9627 = t1502 * t1502;
  t9635 = t1903 * t1078;
  t9655 = t1101 * t4177;
  t9660 = 0.1e1 / t1880 / t403;
  t9669 = t4213 * t448;
  t9686 = 0.584e3 / 0.2025e4 * t9627 + 0.73e2 / 0.5e2 * t1074 * t4243 - 0.2e1 / 0.9e1 * t4183 * t417 + 0.11e2 / 0.27e2 * t1887 * t1030 + 0.73e2 / 0.3888e6 * t9635 * t1080 + t214 * t563 / 0.2e2 - 0.73e2 / 0.2e3 * t2487 * t1914 + 0.73e2 / 0.3e3 * t7495 * t704 + 0.1971e4 / 0.1e3 * t5771 * t1911 + (0.9e1 / 0.16e2 * t149 * t563 * t160 - 0.91e2 / 0.512e3 * t401 * t1620 * t407 + 0.375e3 / 0.32768e5 * t1013 * t4366 * t1018 - 0.33e2 / 0.131072e6 * t2418 * t9655 * t2423 + 0.15e2 / 0.8388608e7 * t5824 * t5804 * t9660 * t5829) * t46 * t171 / 0.24e2 - 0.73e2 / 0.972e5 * t9669 * t459 - 0.73e2 / 0.1944e6 * t4218 * t1092 - 0.3942e4 / 0.25e2 * t2490 * t4235 + 0.1971e4 / 0.5e1 * t1079 * t400 * t1007 * t1015 - 0.73e2 / 0.75e2 * t3301 * t1516 + 0.73e2 / 0.5e2 * t1507 * t3326 + 0.584e3 / 0.2025e4 * t699 * t3296;
  t9690 = t7501 * t148;
  t9695 = t5782 * t400;
  t9718 = t5774 * t400;
  t9721 = t7498 * t148;
  t9739 = t2461 * t1894;
  t9740 = t9739 * t438;
  t9743 = t3272 * t1499;
  t9753 = -0.3e1 / 0.4e1 * t687 * t7393 + 0.9e1 / 0.16e2 * t1040 * t4197 + 0.567e3 / 0.64e2 * t5872 * t1894 * t1051 - 0.81e2 / 0.8e1 * t2462 * t1492 * t1499 - 0.25e2 / 0.2e1 * t8029 * t4206 - 0.225e3 / 0.16e2 * t8041 * t1899 * t8042 - 0.45e2 / 0.16e2 * t2826 * t9740 + 0.9e1 / 0.4e1 * t2826 * t9743 + 0.75e2 / 0.2e1 * t8000 * t4931 * t438 + 0.9e1 / 0.4e1 * t3891 * t7414 + 0.9e1 / 0.8e1 * t3891 * t7417;
  t9757 = t1499 * t1499;
  t9774 = -0.81e2 / 0.32e2 * t2462 * t1894 * t1064 + 0.81e2 / 0.4e2 * t1050 * t9757 + 0.81e2 / 0.4e2 * t1050 * t696 * t3293 + 0.45e2 / 0.8e1 * t3570 * t1899 * t8034 - 0.45e2 / 0.16e2 * t3891 * t7430 + 0.5e1 / 0.2e1 * t3900 + 0.25e3 / 0.3e1 * t3915 - 0.1e2 / 0.3e1 * t3896 - 0.15e2 / 0.4e1 * t3898 - 0.75e2 / 0.2e1 * t3918 - 0.325e3 / 0.6e1 * t1639;
  t9775 = t9753 + t9774;
  t9784 = -0.219e3 / 0.1e3 * t449 * t1083 * t404 + 0.73e2 / 0.4e3 * t9690 * t3317 + 0.73e2 / 0.15e3 * t4223 * t3320 + 0.5913e4 / 0.8e2 * t9695 * t1876 * t1080 + 0.5913e4 / 0.25e2 * t4230 * t4168 * t459 - 0.219e3 / 0.8e3 * t3316 * t1872 * t1080 - 0.73e2 / 0.1e3 * t1512 * t4164 * t459 - 0.5913e4 / 0.2e3 * t4230 * t1876 * t1092 + 0.73e2 / 0.2e3 * t3311 * t4240 + 0.73e2 / 0.4e3 * t1512 * t1872 * t1092 - 0.73e2 / 0.6e3 * t4223 * t3323 - 0.5913e4 / 0.1e3 * t9718 * t4231 - 0.73e2 / 0.3e3 * t9721 * t1513 - 0.73e2 / 0.972e5 * t9775 * t207 + 0.292e3 / 0.2025e4 * t1069 * t1903 + 0.584e3 / 0.2025e4 * t443 * t4213 + 0.292e3 / 0.2025e4 * t195 * t9775;
  t9790 = t9581 * t3340 / 0.3e1 + 0.2e1 / 0.3e1 * t9585 * t232 * t1521 * t107 * t441 + t9559 / 0.9e1 + 0.5e1 / 0.54e2 * t9593 * t9594 * t1090 - t4254 * t3340 / 0.6e1 + t9600 * t4272 / 0.3e1 - 0.11e2 / 0.18e2 * t4270 * t4271 * t1067 - 0.3e1 / 0.4e1 * t2806 * t4258 + 0.3e1 / 0.4e1 * t1358 * t9608 * t1113 * t1925 - 0.3e1 / 0.8e1 * t1358 * t4257 * t1126 - 0.3e1 / 0.4e1 * t1358 * t9616 * t482 - 0.3e1 / 0.8e1 * t1358 * t4257 * t1121 + 0.3e1 / 0.8e1 * t6764 * t1926 - t9542 / 0.4e1 + t9546 / 0.4e1 - t9485 - 0.3e1 / 0.8e1 * t393 * t27 * (t9686 + t9784) * t711;
  t9827 = t393 * t1920 * t1113;
  t9831 = t1113 * t101;
  t9836 = -0.3e1 / 0.4e1 * t999 * t4250 - 0.3e1 / 0.8e1 * t2554 * t1921 - t9531 / 0.4e1 - t9524 / 0.4e1 + t9479 + 0.3e1 / 0.2e1 * t2806 * t4265 + 0.3e1 / 0.4e1 * t2806 * t4277 + 0.3e1 / 0.4e1 * t1358 * t4263 * t1925 * t3331 + 0.3e1 / 0.8e1 * t1358 * t1924 * t101 * t1120 * t232 + t9551 / 0.2e1 + t9563 / 0.4e1 + 0.3e1 / 0.8e1 * t1358 * t1924 * t101 * t1125 * t232 + 0.11e2 / 0.36e2 * t4254 * t3336 - t999 * t4253 * t1530 / 0.6e1 - t393 * t4249 * t476 * t1530 / 0.6e1 - t9827 * t3216 / 0.36e2 - t9538 / 0.18e2 + 0.3e1 / 0.2e1 * t1802 * t9831 * t482 * t1521;
  t9838 = my_piecewise3(t138, 0, t9790 + t9836);
  tv4rho2tau28 = t7 * t9838 + 0.2e1 * t4281;

  if(out->v4rho2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rho2tau2[ip*p->dim.v4rho2tau2 + 8] += tv4rho2tau28;

  t9844 = t258 * t750 * t4346 / 0.8e1;
  t9851 = t334 * t113;
  t9855 = t800 * params->b * t304;
  t9858 = t5025 * t4306;
  t9867 = t515 * params->b;
  t9878 = params->b * t321 * t89;
  t9881 = 0.9e1 / 0.16e2 * t1163 * t3386 + 0.135e3 / 0.256e3 * t518 * t7773 - 0.27e2 / 0.64e2 * t518 * t7776 - 0.75e2 / 0.128e3 * t9851 * t3396 - 0.225e3 / 0.2048e4 * t4303 * t9855 - 0.45e2 / 0.32e2 * t291 * t9858 + 0.567e3 / 0.64e2 * t5039 * t4306 * t304 - 0.243e3 / 0.32e2 * t2054 * t1560 * t1182 + 0.225e3 / 0.256e3 * t7779 * t9867 * t93 - 0.675e3 / 0.1024e4 * t2054 * t9867 * t3403 + 0.135e3 / 0.512e3 * t801 * t1182 * t4311 - 0.45e2 / 0.32e2 * t4309 * t9878;
  t9926 = -0.73e2 / 0.972e5 * t9881 * t98 + 0.292e3 / 0.2025e4 * t82 * t9881 + 0.292e3 / 0.2025e4 * t309 * t4314 + 0.292e3 / 0.675e3 * t520 * t3409 + 0.292e3 / 0.675e3 * t1187 * t1567 - t4294 * t283 / 0.9e1 + 0.73e2 / 0.1296e6 * t830 * t1206 * t1579 + 0.73e2 / 0.1296e6 * t830 * t531 * t3439 - t111 * t9851 / 0.48e2 + 0.73e2 / 0.10368e6 * t5120 * t4325 * t325 - 0.73e2 / 0.864e5 * t2090 * t1574 * t1206 + 0.73e2 / 0.1296e6 * t2082 * t4328 + (0.3e1 / 0.64e2 * t3355 * t4284 - 0.99e2 / 0.16384e5 * params->c * t1145 * t7652 * t114 + 0.51e2 / 0.262144e6 * t1144 * t3363 - 0.15e2 / 0.8388608e7 * t2671 * t2012 * t4034 * t5148) * t46 * t57 / 0.24e2;
  t9952 = t4314 * t314;
  t9957 = -0.73e2 / 0.864e5 * t2090 * t4328 * t325 + 0.73e2 / 0.648e5 * t2687 * t3429 + 0.73e2 / 0.1296e6 * t2687 * t3434 + 0.73e2 / 0.1296e6 * t7738 * t1197 - 0.73e2 / 0.864e5 * t6237 * t3426 + t3367 * t503 / 0.8e1 - 0.73e2 / 0.2592e6 * t5112 * t4325 - 0.73e2 / 0.648e5 * t1192 * t3439 - 0.73e2 / 0.648e5 * t2580 * t1579 + 0.73e2 / 0.1296e6 * t6240 * t1574 - 0.73e2 / 0.648e5 * t3414 * t1206 - 0.73e2 / 0.648e5 * t7709 * t531 - 0.73e2 / 0.1944e6 * t9952 * t325 - t1551 * t1158 / 0.3e1;
  t9961 = t4333 * t342;
  t9991 = -(t9926 + t9957) * t127 * t101 - 0.2e1 / 0.9e1 * t9961 * t344 * t307 + t7817 * t101 * t549 / 0.4e1 + t7822 * t1204 / 0.12e2 - 0.2e1 / 0.3e1 * t4336 * t1229 - t6291 * t101 * t1600 / 0.32e2 - t6270 * t3470 / 0.12e2 + t4339 * t3473 / 0.6e1 + t5171 * t4342 / 0.96e2 + 0.5e1 / 0.864e3 * t5181 * t113 / t54 / t2011 * t71 * sigma[0] - t2132 * t2134 * t334 / 0.12e2;
  t9996 = params->kappa * t4345;
  t10003 = 0.3e1 / 0.8e1 * t2577 * t4350;
  t10017 = t258 * t750 * t4354 / 0.8e1;
  t10025 = 0.3e1 / 0.8e1 * t741 * t4347 + t9844 + 0.3e1 / 0.8e1 * t258 * t259 * t9991 * t130 + 0.3e1 / 0.8e1 * t1237 * t9996 * t349 + 0.9e1 / 0.8e1 * t2568 * t4350 + t10003 + 0.9e1 / 0.8e1 * t1237 * t7584 * t553 + 0.9e1 / 0.8e1 * t1237 * t3481 * t1233 + 0.9e1 / 0.8e1 * t1237 * t3481 * t3823 + 0.3e1 / 0.8e1 * t741 * t4355 + t10017 + 0.9e1 / 0.8e1 * t1237 * t3493 * t1233 + 0.3e1 / 0.8e1 * t1237 * params->kappa * t4353 * t349;
  t10026 = my_piecewise3(t2, 0, t10025);
  tv4rhosigma30 = t7 * t10026 + t4359;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 0] += tv4rhosigma30;

  tv4rhosigma31 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 1] += tv4rhosigma31;

  tv4rhosigma32 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 2] += tv4rhosigma32;

  tv4rhosigma33 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 3] += tv4rhosigma33;

  tv4rhosigma34 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 4] += tv4rhosigma34;

  tv4rhosigma35 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 5] += tv4rhosigma35;

  tv4rhosigma36 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 6] += tv4rhosigma36;

  tv4rhosigma37 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 7] += tv4rhosigma37;

  tv4rhosigma38 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 8] += tv4rhosigma38;

  t10032 = t393 * t750 * t4423 / 0.8e1;
  t10036 = 0.3e1 / 0.8e1 * t2787 * t4427;
  t10041 = t393 * t750 * t4431 / 0.8e1;
  t10043 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t955 * t4424 + t10032 + 0.9e1 / 0.8e1 * t2784 * t4427 + t10036 + 0.3e1 / 0.8e1 * t955 * t4432 + t10041);
  tv4rhosigma39 = t7 * t10043 + t4436;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 9] += tv4rhosigma39;

  t10052 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t930 * t4347 + t9844 + 0.9e1 / 0.8e1 * t2765 * t4350 + t10003 + 0.3e1 / 0.8e1 * t930 * t4355 + t10017);
  tv4rhosigma310 = t7 * t10052 + t4359;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 10] += tv4rhosigma310;

  tv4rhosigma311 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 11] += tv4rhosigma311;

  tv4rhosigma312 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 12] += tv4rhosigma312;

  tv4rhosigma313 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 13] += tv4rhosigma313;

  tv4rhosigma314 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 14] += tv4rhosigma314;

  tv4rhosigma315 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 15] += tv4rhosigma315;

  tv4rhosigma316 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 16] += tv4rhosigma316;

  tv4rhosigma317 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 17] += tv4rhosigma317;

  tv4rhosigma318 = 0.e0;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 18] += tv4rhosigma318;

  t10060 = t4391 * t448;
  t10098 = t468 * t113;
  t10102 = t1049 * params->b * t438;
  t10105 = t5858 * t4383;
  t10114 = t583 * params->b;
  t10125 = params->b * t455 * t89;
  t10128 = 0.9e1 / 0.16e2 * t1284 * t3556 + 0.135e3 / 0.256e3 * t586 * t7994 - 0.27e2 / 0.64e2 * t586 * t7997 - 0.75e2 / 0.128e3 * t10098 * t3566 - 0.225e3 / 0.2048e4 * t4380 * t10102 - 0.45e2 / 0.32e2 * t425 * t10105 + 0.567e3 / 0.64e2 * t5872 * t4383 * t438 - 0.243e3 / 0.32e2 * t2462 * t1634 * t1303 + 0.225e3 / 0.256e3 * t8000 * t10114 * t202 - 0.675e3 / 0.1024e4 * t2462 * t10114 * t3573 + 0.135e3 / 0.512e3 * t1050 * t1303 * t4388 - 0.45e2 / 0.32e2 * t4386 * t10125;
  t10135 = -0.73e2 / 0.648e5 * t3584 * t1327 - 0.73e2 / 0.648e5 * t8134 * t599 - 0.73e2 / 0.1944e6 * t10060 * t459 - 0.73e2 / 0.2592e6 * t5774 * t4402 - 0.73e2 / 0.648e5 * t1313 * t3609 - 0.73e2 / 0.648e5 * t2909 * t1653 + 0.73e2 / 0.1296e6 * t6578 * t1648 + (0.3e1 / 0.64e2 * t3525 * t4361 - 0.99e2 / 0.16384e5 * params->c * t1266 * t8063 * t217 + 0.51e2 / 0.262144e6 * t1265 * t3533 - 0.15e2 / 0.8388608e7 * t2873 * t2420 * t4177 * t5829) * t46 * t171 / 0.24e2 - 0.73e2 / 0.864e5 * t2498 * t4405 * t459 - t4371 * t417 / 0.9e1 - 0.73e2 / 0.972e5 * t10128 * t207 + 0.292e3 / 0.2025e4 * t195 * t10128 + 0.292e3 / 0.2025e4 * t443 * t4391;
  t10168 = 0.292e3 / 0.675e3 * t588 * t3579 + 0.73e2 / 0.1296e6 * t8140 * t1318 - 0.73e2 / 0.864e5 * t6571 * t3596 + 0.73e2 / 0.648e5 * t2896 * t3599 + 0.73e2 / 0.1296e6 * t2896 * t3604 + 0.73e2 / 0.10368e6 * t5782 * t4402 * t459 - 0.73e2 / 0.864e5 * t2498 * t1648 * t1327 + 0.73e2 / 0.1296e6 * t2490 * t4405 + 0.73e2 / 0.1296e6 * t1079 * t1327 * t1653 + 0.73e2 / 0.1296e6 * t1079 * t599 * t3609 - t111 * t10098 / 0.48e2 + t3537 * t571 / 0.8e1 - t1625 * t1279 / 0.3e1 + 0.292e3 / 0.675e3 * t1308 * t1641;
  t10172 = t4410 * t476;
  t10202 = -(t10135 + t10168) * t229 * t101 - 0.2e1 / 0.9e1 * t10172 * t344 * t441 + t8169 * t101 * t617 / 0.4e1 + t8174 * t1325 / 0.12e2 - 0.2e1 / 0.3e1 * t4413 * t1350 - t6707 * t101 * t1673 / 0.32e2 - t6682 * t3640 / 0.12e2 + t4416 * t3643 / 0.6e1 + t5947 * t4419 / 0.96e2 + 0.5e1 / 0.864e3 * t5955 * t113 / t168 / t2419 * t71 * sigma[2] - t2540 * t2134 * t468 / 0.12e2;
  t10207 = params->kappa * t4422;
  t10231 = 0.3e1 / 0.8e1 * t999 * t4424 + t10032 + 0.3e1 / 0.8e1 * t393 * t259 * t10202 * t232 + 0.3e1 / 0.8e1 * t1358 * t10207 * t482 + 0.9e1 / 0.8e1 * t2806 * t4427 + t10036 + 0.9e1 / 0.8e1 * t1358 * t7970 * t621 + 0.9e1 / 0.8e1 * t1358 * t3651 * t1354 + 0.9e1 / 0.8e1 * t1358 * t3651 * t4008 + 0.3e1 / 0.8e1 * t999 * t4432 + t10041 + 0.9e1 / 0.8e1 * t1358 * t3660 * t1354 + 0.3e1 / 0.8e1 * t1358 * params->kappa * t4430 * t482;
  t10232 = my_piecewise3(t138, 0, t10231);
  tv4rhosigma319 = t7 * t10232 + t4436;

  if(out->v4rhosigma3 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma3[ip*p->dim.v4rhosigma3 + 19] += tv4rhosigma319;

  tv4rhosigma2lapl0 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 0] += tv4rhosigma2lapl0;

  tv4rhosigma2lapl1 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 1] += tv4rhosigma2lapl1;

  tv4rhosigma2lapl2 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 2] += tv4rhosigma2lapl2;

  tv4rhosigma2lapl3 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 3] += tv4rhosigma2lapl3;

  tv4rhosigma2lapl4 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 4] += tv4rhosigma2lapl4;

  tv4rhosigma2lapl5 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 5] += tv4rhosigma2lapl5;

  tv4rhosigma2lapl6 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 6] += tv4rhosigma2lapl6;

  tv4rhosigma2lapl7 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 7] += tv4rhosigma2lapl7;

  tv4rhosigma2lapl8 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 8] += tv4rhosigma2lapl8;

  tv4rhosigma2lapl9 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 9] += tv4rhosigma2lapl9;

  tv4rhosigma2lapl10 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 10] += tv4rhosigma2lapl10;

  tv4rhosigma2lapl11 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 11] += tv4rhosigma2lapl11;

  tv4rhosigma2lapl12 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 12] += tv4rhosigma2lapl12;

  tv4rhosigma2lapl13 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 13] += tv4rhosigma2lapl13;

  tv4rhosigma2lapl14 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 14] += tv4rhosigma2lapl14;

  tv4rhosigma2lapl15 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 15] += tv4rhosigma2lapl15;

  tv4rhosigma2lapl16 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 16] += tv4rhosigma2lapl16;

  tv4rhosigma2lapl17 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 17] += tv4rhosigma2lapl17;

  tv4rhosigma2lapl18 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 18] += tv4rhosigma2lapl18;

  tv4rhosigma2lapl19 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 19] += tv4rhosigma2lapl19;

  tv4rhosigma2lapl20 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 20] += tv4rhosigma2lapl20;

  tv4rhosigma2lapl21 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 21] += tv4rhosigma2lapl21;

  tv4rhosigma2lapl22 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 22] += tv4rhosigma2lapl22;

  tv4rhosigma2lapl23 = 0.e0;

  if(out->v4rhosigma2lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2lapl[ip*p->dim.v4rhosigma2lapl + 23] += tv4rhosigma2lapl23;

  t10237 = t258 * t253 * t4504 * t666 / 0.8e1;
  t10239 = t2577 * t4513 / 0.4e1;
  t10241 = t2577 * t4524 / 0.8e1;
  t10243 = t2577 * t4527 / 0.8e1;
  t10261 = t4504 * t127;
  t10278 = t1604 * t107;
  t10282 = t1608 * t107;
  t10313 = 0.73e2 / 0.4e3 * t8405 * t3754 - 0.73e2 / 0.32e3 * t6867 * t628 * t3426 + 0.73e2 / 0.4e3 * t3080 * t628 * t3429 + 0.73e2 / 0.2e3 * t8415 * t3754 + 0.73e2 / 0.8e3 * t3080 * t628 * t3434 + 0.73e2 / 0.3e3 * t3747 * t3757 - 0.73e2 / 0.4e3 * t3080 * t1372 * t1574 + 0.73e2 / 0.15e3 * t3765 * t3757 + 0.73e2 / 0.6e3 * t1420 * t1372 * t1579 - 0.73e2 / 0.3e3 * t3765 * t3760 - 0.73e2 / 0.12e4 * t3075 * t4497;
  t10321 = t2687 * sigma[0];
  t10328 = t7738 * t29;
  t10341 = -0.73e2 / 0.12e4 * t1420 * t628 * t3439 - 0.73e2 / 0.6e3 * t8438 * t1725 - 0.73e2 / 0.6e3 * t3747 * t3760 - 0.73e2 / 0.3e3 * t10321 * t1421 + 0.73e2 / 0.8e3 * t6862 * t4492 - 0.73e2 / 0.3e3 * t8420 * t1725 - 0.73e2 / 0.12e4 * t10328 * t1421 + 0.73e2 / 0.1944e6 * t3068 * t3429 + 0.73e2 / 0.3888e6 * t3068 * t3434 + 0.73e2 / 0.3e3 * t825 * t628 + t3684 * t503 / 0.12e2 + 0.73e2 / 0.1944e6 * t8604 * t1197;
  t10357 = t633 * t273;
  t10395 = t6929 * t1560;
  t10412 = t89 * t1171;
  t10416 = t88 * t1182;
  t10420 = t651 * params->b;
  t10424 = t2054 * t10420;
  t10427 = t801 * t1407;
  t10432 = 0.567e3 / 0.64e2 * t5039 * t4465 * t304 - 0.81e2 / 0.32e2 * t2054 * t1407 * t1560 - 0.81e2 / 0.16e2 * t2054 * t1707 * t1182 - 0.75e2 / 0.16e2 * t7779 * t4657 * t515 + 0.225e3 / 0.64e2 * t2054 * t4657 * t10412 + 0.195e3 / 0.32e2 * t4312 - 0.45e2 / 0.32e2 * t3400 * t1712 * t10416 + 0.75e2 / 0.256e3 * t7779 * t10420 * t93 - 0.225e3 / 0.1024e4 * t10424 * t3403 + 0.45e2 / 0.512e3 * t10427 * t4311 - 0.15e2 / 0.32e2 * t4472 * t9878;
  t10433 = -0.15e2 / 0.16e2 * t4301 - 0.45e2 / 0.32e2 * t3700 * t7773 + 0.9e1 / 0.8e1 * t3700 * t7776 + 0.525e3 / 0.128e3 * t4304 + 0.225e3 / 0.256e3 * t4460 * t9855 + 0.3e1 / 0.8e1 * t1185 * t3711 + 0.45e2 / 0.128e3 * t518 * t8560 - 0.9e1 / 0.64e2 * t518 * t8497 - 0.9e1 / 0.64e2 * t518 * t8500 - 0.45e2 / 0.32e2 * t2617 * t10395 + t10432;
  t10438 = -0.73e2 / 0.2592e6 * t6993 * t3426 - 0.73e2 / 0.15e3 * t315 * t1372 - 0.2e1 / 0.9e1 * t1696 * t1158 + 0.73e2 / 0.15e3 * t2580 * t1728 - 0.73e2 / 0.6e3 * t830 * t1421 + 0.73e2 / 0.6e3 * t7709 * t659 + (t3352 * t4437 / 0.8e1 - 0.23e2 / 0.256e3 * t3355 * t10357 * t29 + 0.33e2 / 0.4096e4 * t267 * t1383 - 0.57e2 / 0.262144e6 * t764 * t3680 + 0.15e2 / 0.8388608e7 * t2010 * t2012 * t4830 * t5148) * t46 * t57 / 0.24e2 - t4449 * t283 / 0.9e1 - 0.73e2 / 0.75e2 * t1192 * t3768 - 0.73e2 / 0.3e3 * t3414 * t1424 - 0.73e2 / 0.972e5 * t10433 * t98 + 0.292e3 / 0.2025e4 * t82 * t10433;
  t10449 = t4475 * t314;
  t10464 = 0.292e3 / 0.2025e4 * t309 * t4475 + 0.584e3 / 0.2025e4 * t520 * t3730 + 0.584e3 / 0.2025e4 * t1187 * t1716 + 0.292e3 / 0.2025e4 * t1567 * t1410 + 0.292e3 / 0.2025e4 * t3409 * t654 - 0.73e2 / 0.1944e6 * t10449 * t325 - 0.73e2 / 0.972e5 * t8459 * t531 - 0.73e2 / 0.972e5 * t3735 * t1206 + 0.73e2 / 0.3888e6 * t6996 * t1574 - 0.73e2 / 0.1944e6 * t3065 * t1579 - 0.73e2 / 0.1944e6 * t1415 * t3439 + t3445 * t627 / 0.9e2;
  t10478 = -0.3e1 / 0.8e1 * t1237 * t10261 * t349 - 0.3e1 / 0.4e1 * t2568 * t4513 - 0.3e1 / 0.4e1 * t1237 * t8373 * t553 - t3780 * t3816 / 0.6e1 + t2981 * t8305 * t1204 / 0.48e2 + t1435 * t3823 * t549 / 0.16e2 - t1435 * t10278 * t307 / 0.12e2 - t1435 * t10282 * t307 / 0.12e2 - 0.3e1 / 0.8e1 * t258 * t27 * (t10313 + t10341 + t10438 + t10464) * t666 - 0.3e1 / 0.8e1 * t741 * t4506 - 0.3e1 / 0.8e1 * t1237 * t1441 * t1603 * t348 * t130;
  t10517 = t3128 * t4521 / 0.48e2;
  t10536 = t6 * t254 * t1733 * t1742 / 0.48e2;
  t10540 = t3792 * t4518 / 0.768e3;
  t10544 = t3780 * t3802 / 0.16e2 + t10517 - t1435 * t3815 * t1185 / 0.6e1 + t6 * t248 * t1733 * t1742 / 0.16e2 + t6 * t28 * t3774 * t1742 / 0.16e2 - t3788 * t4518 / 0.256e3 - t3796 * t4518 / 0.256e3 + t10536 - t4510 * t3805 / 0.6e1 - t10540 + t1739 * t4517 * t3406 / 0.48e2;
  t10547 = my_piecewise3(t2, 0, -t10237 - t10239 - t10241 - t10243 - 0.3e1 / 0.8e1 * t1237 * t1441 * t3477 - 0.3e1 / 0.8e1 * t2568 * t4527 - 0.3e1 / 0.8e1 * t1237 * t3102 * t1608 - 0.3e1 / 0.4e1 * t1237 * t3783 * t1233 - 0.3e1 / 0.8e1 * t2568 * t4524 - 0.3e1 / 0.8e1 * t1237 * t3102 * t1604 + t10478 - 0.3e1 / 0.4e1 * t1237 * t1441 * t553 * t1232 - 0.3e1 / 0.8e1 * t1237 * t1441 * t1607 * t348 * t130 - 0.3e1 / 0.4e1 * t1237 * t3783 * t3823 - t7079 * t7080 * t2133 * t334 * sigma[0] / 0.96e2 - t2981 * t6838 * t1564 / 0.256e3 + t3124 * t4521 / 0.16e2 + t3132 * t4521 / 0.16e2 + t1435 * t8301 * t518 / 0.16e2 - t258 * t4505 * t342 * t1438 / 0.12e2 + t8271 * t3799 / 0.48e2 + t10544);
  tv4rhosigma2tau0 = t7 * t10547 + t4531;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 0] += tv4rhosigma2tau0;

  tv4rhosigma2tau1 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 1] += tv4rhosigma2tau1;

  tv4rhosigma2tau2 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 2] += tv4rhosigma2tau2;

  tv4rhosigma2tau3 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 3] += tv4rhosigma2tau3;

  tv4rhosigma2tau4 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 4] += tv4rhosigma2tau4;

  tv4rhosigma2tau5 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 5] += tv4rhosigma2tau5;

  tv4rhosigma2tau6 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 6] += tv4rhosigma2tau6;

  tv4rhosigma2tau7 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 7] += tv4rhosigma2tau7;

  tv4rhosigma2tau8 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 8] += tv4rhosigma2tau8;

  tv4rhosigma2tau9 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 9] += tv4rhosigma2tau9;

  tv4rhosigma2tau10 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 10] += tv4rhosigma2tau10;

  t10554 = t393 * t253 * t4599 * t711 / 0.8e1;
  t10562 = t6 * t365 * t1796 * t1805 / 0.48e2;
  t10566 = t2787 * t4608 / 0.4e1;
  t10570 = t3841 * t4613 / 0.768e3;
  t10574 = t3183 * t4616 / 0.48e2;
  t10578 = t2787 * t4619 / 0.8e1;
  t10582 = t2787 * t4622 / 0.8e1;
  t10583 = -0.3e1 / 0.8e1 * t955 * t4601 - t10554 + t6 * t361 * t1796 * t1805 / 0.16e2 + t10562 - 0.3e1 / 0.4e1 * t2784 * t4608 - t10566 - t3837 * t4613 / 0.256e3 - t10570 + t3179 * t4616 / 0.16e2 + t10574 - 0.3e1 / 0.8e1 * t2784 * t4619 - t10578 - 0.3e1 / 0.8e1 * t2784 * t4622 - t10582;
  t10584 = my_piecewise3(t138, 0, t10583);
  tv4rhosigma2tau11 = t7 * t10584 + t4626;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 11] += tv4rhosigma2tau11;

  t10602 = -0.3e1 / 0.8e1 * t930 * t4506 - t10237 + t6 * t378 * t1733 * t1742 / 0.16e2 + t10536 - 0.3e1 / 0.4e1 * t2765 * t4513 - t10239 - t3854 * t4518 / 0.256e3 - t10540 + t3156 * t4521 / 0.16e2 + t10517 - 0.3e1 / 0.8e1 * t2765 * t4524 - t10241 - 0.3e1 / 0.8e1 * t2765 * t4527 - t10243;
  t10603 = my_piecewise3(t2, 0, t10602);
  tv4rhosigma2tau12 = t7 * t10603 + t4531;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 12] += tv4rhosigma2tau12;

  tv4rhosigma2tau13 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 13] += tv4rhosigma2tau13;

  tv4rhosigma2tau14 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 14] += tv4rhosigma2tau14;

  tv4rhosigma2tau15 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 15] += tv4rhosigma2tau15;

  tv4rhosigma2tau16 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 16] += tv4rhosigma2tau16;

  tv4rhosigma2tau17 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 17] += tv4rhosigma2tau17;

  tv4rhosigma2tau18 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 18] += tv4rhosigma2tau18;

  tv4rhosigma2tau19 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 19] += tv4rhosigma2tau19;

  tv4rhosigma2tau20 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 20] += tv4rhosigma2tau20;

  tv4rhosigma2tau21 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 21] += tv4rhosigma2tau21;

  tv4rhosigma2tau22 = 0.e0;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 22] += tv4rhosigma2tau22;

  t10624 = t4599 * t229;
  t10639 = t1677 * t107;
  t10643 = t1681 * t107;
  t10659 = -t10582 - t10566 - t10578 - t3971 * t4001 / 0.6e1 + t3213 * t8842 * t1325 / 0.48e2 + t1527 * t4008 * t617 / 0.16e2 - t1527 * t10639 * t441 / 0.12e2 - t1527 * t10643 * t441 / 0.12e2 - 0.3e1 / 0.4e1 * t1358 * t3974 * t4008 - 0.3e1 / 0.8e1 * t1358 * t1533 * t1676 * t481 * t232 - 0.3e1 / 0.4e1 * t1358 * t1533 * t621 * t1353;
  t10734 = t7429 * t1634;
  t10751 = t89 * t1292;
  t10755 = t88 * t1303;
  t10759 = t696 * params->b;
  t10763 = t2462 * t10759;
  t10766 = t1050 * t1499;
  t10771 = 0.567e3 / 0.64e2 * t5872 * t4560 * t438 - 0.81e2 / 0.32e2 * t2462 * t1499 * t1634 - 0.81e2 / 0.16e2 * t2462 * t1770 * t1303 - 0.75e2 / 0.16e2 * t8000 * t4752 * t583 + 0.225e3 / 0.64e2 * t2462 * t4752 * t10751 + 0.195e3 / 0.32e2 * t4389 - 0.45e2 / 0.32e2 * t3570 * t1775 * t10755 + 0.75e2 / 0.256e3 * t8000 * t10759 * t202 - 0.225e3 / 0.1024e4 * t10763 * t3573 + 0.45e2 / 0.512e3 * t10766 * t4388 - 0.15e2 / 0.32e2 * t4567 * t10125;
  t10772 = -0.15e2 / 0.16e2 * t4378 - 0.45e2 / 0.32e2 * t3891 * t7994 + 0.9e1 / 0.8e1 * t3891 * t7997 + 0.525e3 / 0.128e3 * t4381 + 0.225e3 / 0.256e3 * t4555 * t10102 + 0.3e1 / 0.8e1 * t1306 * t3902 + 0.45e2 / 0.128e3 * t586 * t9083 - 0.9e1 / 0.64e2 * t586 * t9046 - 0.9e1 / 0.64e2 * t586 * t9049 - 0.45e2 / 0.32e2 * t2826 * t10734 + t10771;
  t10787 = -0.2e1 / 0.9e1 * t1759 * t1279 - 0.73e2 / 0.75e2 * t1313 * t3959 - 0.73e2 / 0.3e3 * t3584 * t1516 - t4544 * t417 / 0.9e1 + 0.292e3 / 0.2025e4 * t195 * t10772 + 0.292e3 / 0.2025e4 * t443 * t4570 + 0.584e3 / 0.2025e4 * t588 * t3921 + 0.73e2 / 0.3e3 * t1074 * t673 + 0.73e2 / 0.1944e6 * t8978 * t1318 - 0.73e2 / 0.2592e6 * t7501 * t3596 + 0.73e2 / 0.1944e6 * t3304 * t3599;
  t10814 = 0.73e2 / 0.3888e6 * t3304 * t3604 + 0.73e2 / 0.3e3 * t3938 * t3948 - 0.73e2 / 0.4e3 * t3316 * t1464 * t1648 + 0.73e2 / 0.15e3 * t3956 * t3948 + 0.73e2 / 0.6e3 * t1512 * t1464 * t1653 + 0.584e3 / 0.2025e4 * t1308 * t1779 + t3875 * t571 / 0.12e2 + 0.292e3 / 0.2025e4 * t1641 * t1502 + 0.292e3 / 0.2025e4 * t3579 * t699 - 0.73e2 / 0.1944e6 * t1507 * t3609 + t3615 * t672 / 0.9e2 + 0.73e2 / 0.3888e6 * t7498 * t1648;
  t10822 = t4570 * t448;
  t10827 = t2896 * sigma[2];
  t10830 = t8140 * t148;
  t10843 = -0.73e2 / 0.1944e6 * t3301 * t1653 - 0.73e2 / 0.972e5 * t3926 * t1327 - 0.73e2 / 0.972e5 * t9026 * t599 - 0.73e2 / 0.1944e6 * t10822 * t459 - 0.73e2 / 0.6e3 * t3938 * t3951 - 0.73e2 / 0.3e3 * t10827 * t1513 - 0.73e2 / 0.12e4 * t10830 * t1513 - 0.73e2 / 0.6e3 * t8924 * t1788 + 0.73e2 / 0.8e3 * t7363 * t4587 - 0.73e2 / 0.3e3 * t8936 * t1788 - 0.73e2 / 0.3e3 * t3956 * t3951 - 0.73e2 / 0.12e4 * t3311 * t4592;
  t10855 = t678 * t407;
  t10888 = -0.73e2 / 0.12e4 * t1512 * t673 * t3609 + 0.73e2 / 0.15e3 * t2909 * t1791 - 0.73e2 / 0.6e3 * t1079 * t1513 + 0.73e2 / 0.6e3 * t8134 * t704 + (t3522 * t4532 / 0.8e1 - 0.23e2 / 0.256e3 * t3525 * t10855 * t148 + 0.33e2 / 0.4096e4 * t401 * t1475 - 0.57e2 / 0.262144e6 * t1013 * t3871 + 0.15e2 / 0.8388608e7 * t2418 * t2420 * t4912 * t5829) * t46 * t171 / 0.24e2 - 0.73e2 / 0.15e3 * t449 * t1464 - 0.73e2 / 0.972e5 * t10772 * t207 + 0.73e2 / 0.4e3 * t8907 * t3945 - 0.73e2 / 0.32e3 * t7353 * t673 * t3596 + 0.73e2 / 0.4e3 * t3316 * t673 * t3599 + 0.73e2 / 0.2e3 * t8921 * t3945 + 0.73e2 / 0.8e3 * t3316 * t673 * t3604;
  t10897 = t10574 - t3979 * t4613 / 0.256e3 - t3983 * t4613 / 0.256e3 + t1802 * t4612 * t3576 / 0.48e2 - t4605 * t3992 / 0.6e1 + t6 * t389 * t1796 * t1805 / 0.16e2 + t6 * t147 * t3965 * t1805 / 0.16e2 + t10562 - t10570 - 0.3e1 / 0.8e1 * t393 * t27 * (t10787 + t10814 + t10843 + t10888) * t711 - 0.3e1 / 0.8e1 * t999 * t4601;
  t10900 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t1358 * t1533 * t3647 - 0.3e1 / 0.8e1 * t2806 * t4622 - 0.3e1 / 0.8e1 * t1358 * t3203 * t1681 - 0.3e1 / 0.4e1 * t1358 * t8859 * t621 - 0.3e1 / 0.4e1 * t1358 * t3974 * t1354 - 0.3e1 / 0.8e1 * t2806 * t4619 - 0.3e1 / 0.8e1 * t1358 * t3203 * t1677 - 0.3e1 / 0.8e1 * t1358 * t10624 * t482 - 0.3e1 / 0.4e1 * t2806 * t4608 - t10554 + t10659 - 0.3e1 / 0.8e1 * t1358 * t1533 * t1680 * t481 * t232 - t7558 * t7559 * t2133 * t468 * sigma[2] / 0.96e2 - t3213 * t7346 * t1638 / 0.256e3 + t3219 * t4616 / 0.16e2 + t3223 * t4616 / 0.16e2 + t1527 * t8838 * t586 / 0.16e2 - t393 * t4600 * t476 * t1530 / 0.12e2 + t9157 * t3986 / 0.48e2 + t3971 * t3989 / 0.16e2 - t1527 * t4000 * t1306 / 0.6e1 + t10897);
  tv4rhosigma2tau23 = t7 * t10900 + t4626;

  if(out->v4rhosigma2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigma2tau[ip*p->dim.v4rhosigma2tau + 23] += tv4rhosigma2tau23;

  tv4rhosigmalapl20 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 0] += tv4rhosigmalapl20;

  tv4rhosigmalapl21 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 1] += tv4rhosigmalapl21;

  tv4rhosigmalapl22 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 2] += tv4rhosigmalapl22;

  tv4rhosigmalapl23 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 3] += tv4rhosigmalapl23;

  tv4rhosigmalapl24 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 4] += tv4rhosigmalapl24;

  tv4rhosigmalapl25 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 5] += tv4rhosigmalapl25;

  tv4rhosigmalapl26 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 6] += tv4rhosigmalapl26;

  tv4rhosigmalapl27 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 7] += tv4rhosigmalapl27;

  tv4rhosigmalapl28 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 8] += tv4rhosigmalapl28;

  tv4rhosigmalapl29 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 9] += tv4rhosigmalapl29;

  tv4rhosigmalapl210 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 10] += tv4rhosigmalapl210;

  tv4rhosigmalapl211 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 11] += tv4rhosigmalapl211;

  tv4rhosigmalapl212 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 12] += tv4rhosigmalapl212;

  tv4rhosigmalapl213 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 13] += tv4rhosigmalapl213;

  tv4rhosigmalapl214 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 14] += tv4rhosigmalapl214;

  tv4rhosigmalapl215 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 15] += tv4rhosigmalapl215;

  tv4rhosigmalapl216 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 16] += tv4rhosigmalapl216;

  tv4rhosigmalapl217 = 0.e0;

  if(out->v4rhosigmalapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapl2[ip*p->dim.v4rhosigmalapl2 + 17] += tv4rhosigmalapl217;

  tv4rhosigmalapltau0 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 0] += tv4rhosigmalapltau0;

  tv4rhosigmalapltau1 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 1] += tv4rhosigmalapltau1;

  tv4rhosigmalapltau2 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 2] += tv4rhosigmalapltau2;

  tv4rhosigmalapltau3 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 3] += tv4rhosigmalapltau3;

  tv4rhosigmalapltau4 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 4] += tv4rhosigmalapltau4;

  tv4rhosigmalapltau5 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 5] += tv4rhosigmalapltau5;

  tv4rhosigmalapltau6 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 6] += tv4rhosigmalapltau6;

  tv4rhosigmalapltau7 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 7] += tv4rhosigmalapltau7;

  tv4rhosigmalapltau8 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 8] += tv4rhosigmalapltau8;

  tv4rhosigmalapltau9 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 9] += tv4rhosigmalapltau9;

  tv4rhosigmalapltau10 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 10] += tv4rhosigmalapltau10;

  tv4rhosigmalapltau11 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 11] += tv4rhosigmalapltau11;

  tv4rhosigmalapltau12 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 12] += tv4rhosigmalapltau12;

  tv4rhosigmalapltau13 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 13] += tv4rhosigmalapltau13;

  tv4rhosigmalapltau14 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 14] += tv4rhosigmalapltau14;

  tv4rhosigmalapltau15 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 15] += tv4rhosigmalapltau15;

  tv4rhosigmalapltau16 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 16] += tv4rhosigmalapltau16;

  tv4rhosigmalapltau17 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 17] += tv4rhosigmalapltau17;

  tv4rhosigmalapltau18 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 18] += tv4rhosigmalapltau18;

  tv4rhosigmalapltau19 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 19] += tv4rhosigmalapltau19;

  tv4rhosigmalapltau20 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 20] += tv4rhosigmalapltau20;

  tv4rhosigmalapltau21 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 21] += tv4rhosigmalapltau21;

  tv4rhosigmalapltau22 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 22] += tv4rhosigmalapltau22;

  tv4rhosigmalapltau23 = 0.e0;

  if(out->v4rhosigmalapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmalapltau[ip*p->dim.v4rhosigmalapltau + 23] += tv4rhosigmalapltau23;

  t10902 = t4696 * t127;
  t10919 = t258 * t665 * t2130;
  t10948 = t2577 * t4717 / 0.8e1;
  t10950 = t2577 * t4709 / 0.4e1;
  t10957 = -0.3e1 / 0.8e1 * t1237 * t10902 * t349 - 0.3e1 / 0.8e1 * t2568 * t4705 - 0.3e1 / 0.8e1 * t1237 * t9222 * t553 + t9191 * t3816 / 0.6e1 + t9195 * t130 * t1733 * t107 * t307 / 0.3e1 - t10919 * t4130 * t71 * t56 * t1429 / 0.8e1 - 0.5e1 / 0.144e3 * t9212 * t9213 * t1204 - t4129 * t4135 * t549 / 0.16e2 - t4111 * t3816 / 0.12e2 + 0.3e1 / 0.8e1 * t1237 * t1865 * t101 * t1232 * t130 - 0.3e1 / 0.8e1 * t1237 * t4114 * t3823 + 0.3e1 / 0.4e1 * t2568 * t4709 + 0.3e1 / 0.4e1 * t1237 * t1429 * t864 * t4708 + t10948 + t10950 + 0.3e1 / 0.4e1 * t1237 * t4122 * t1866 * t3774 + 0.3e1 / 0.8e1 * t2568 * t4717;
  t10982 = t9208 * t4712 / 0.48e2;
  t11002 = t9336 * t515;
  t11033 = 0.567e3 / 0.64e2 * t5039 * t4654 * t304 - 0.81e2 / 0.16e2 * t2054 * t1707 * t1407 - 0.81e2 / 0.32e2 * t2054 * t1835 * t1182 - 0.75e2 / 0.16e2 * t7779 * t10420 * t1711 + 0.225e3 / 0.64e2 * t10424 * t3726 - 0.45e2 / 0.32e2 * t10427 * t4658 + 0.195e3 / 0.32e2 * t4473 + 0.75e2 / 0.4e1 * t7779 * t4849 * t515 - 0.225e3 / 0.16e2 * t2054 * t4849 * t10412 - 0.75e2 / 0.4e1 * t4470 + 0.45e2 / 0.8e1 * t3400 * t1840 * t10416;
  t11034 = -0.15e2 / 0.8e1 * t4463 - 0.45e2 / 0.16e2 * t3700 * t8560 + 0.9e1 / 0.8e1 * t3700 * t8497 + 0.9e1 / 0.8e1 * t3700 * t8500 - 0.225e3 / 0.8e1 * t4461 - 0.225e3 / 0.32e2 * t4649 * t9855 + 0.3e1 / 0.16e2 * t1163 * t4054 + 0.45e2 / 0.256e3 * t518 * t9337 - 0.9e1 / 0.64e2 * t518 * t9341 - 0.45e2 / 0.32e2 * t2617 * t11002 + t11033;
  t11074 = -0.73e2 / 0.972e5 * t11034 * t98 + (-0.3e1 / 0.8e1 * t490 * t4022 + 0.37e2 / 0.256e3 * t493 * t4026 - 0.21e2 / 0.2048e4 * t1144 * t4030 + 0.63e2 / 0.262144e6 * t2671 * t4036 - 0.15e2 / 0.8388608e7 * t6187 * t2012 * t9391 * t5148) * t46 * t57 / 0.24e2 - 0.73e2 / 0.15e3 * t3735 * t1424 + 0.292e3 / 0.2025e4 * t82 * t11034 + 0.73e2 / 0.1e3 * t1192 * t4100 + 0.73e2 / 0.5e2 * t315 * t1200 * t270 - t4638 * t283 / 0.9e1 - 0.1971e4 / 0.25e2 * t2687 * t4092 - 0.7884e4 / 0.25e2 * t830 * t114 * t268 * t766 + 0.73e2 / 0.3e3 * t8459 * t659 + 0.73e2 / 0.15e3 * t3065 * t1728;
  t11081 = t3068 * sigma[0];
  t11088 = t8604 * t29;
  t11101 = -0.73e2 / 0.75e2 * t1415 * t3768 + 0.292e3 / 0.2025e4 * t309 * t4664 + 0.292e3 / 0.2025e4 * t520 * t4070 - 0.73e2 / 0.3e3 * t11081 * t1421 - 0.73e2 / 0.6e3 * t9283 * t1725 - 0.73e2 / 0.6e3 * t4080 * t3760 - 0.73e2 / 0.6e3 * t11088 * t1421 + 0.292e3 / 0.2025e4 * t1187 * t1844 + 0.584e3 / 0.2025e4 * t654 * t3730 + 0.1971e4 / 0.1e3 * t6240 * t1852 + 0.1971e4 / 0.25e2 * t2082 * t4683 - 0.73e2 / 0.2e3 * t2580 * t1855;
  t11114 = t6237 * t266;
  t11122 = t2090 * t114;
  t11129 = -0.73e2 / 0.1e3 * t825 * t4691 + 0.73e2 / 0.4e3 * t3747 * t4097 + 0.73e2 / 0.4e3 * t3075 * t4688 + 0.73e2 / 0.4e3 * t1420 * t1813 * t1206 + 0.73e2 / 0.2e3 * t3765 * t4097 - 0.5913e4 / 0.2e3 * t11114 * t4088 - 0.5913e4 / 0.2e3 * t9280 * t4679 - 0.5913e4 / 0.2e3 * t4087 * t1817 * t1206 - 0.5913e4 / 0.5e2 * t11122 * t4088 + 0.584e3 / 0.2025e4 * t1410 * t1716 - 0.73e2 / 0.1944e6 * t9402 * t531;
  t11132 = t4664 * t314;
  t11159 = -0.73e2 / 0.1944e6 * t4075 * t1206 - 0.73e2 / 0.1944e6 * t11132 * t325 - t1828 * t1158 / 0.9e1 + 0.73e2 / 0.3888e6 * t9288 * t1197 - 0.73e2 / 0.2e3 * t1420 * t4021 * t531 + 0.73e2 / 0.3e3 * t4080 * t3757 + 0.5913e4 / 0.5e2 * t4087 * t4025 * t531 - t538 * t4021 / 0.3e2 + t4040 * t503 / 0.24e2 - 0.219e3 / 0.8e3 * t3080 * t1813 * t1197 + 0.73e2 / 0.4e3 * t9273 * t3754 + 0.5913e4 / 0.8e2 * t9252 * t1817 * t1197;
  t11173 = t6 * t254 * t1860 * t1742 / 0.96e2;
  t11185 = t258 * t253 * t4696 * t666 / 0.8e1;
  t11190 = t2577 * t4705 / 0.8e1;
  t11191 = 0.3e1 / 0.4e1 * t1739 * t9462 * t553 * t1429 + 0.3e1 / 0.8e1 * t6 * t28 * t1864 * t9462 * t3823 + 0.3e1 / 0.4e1 * t1739 * t9462 * t349 * t1733 - t9203 * t4712 / 0.16e2 - t258 * t4697 * t342 * t1438 / 0.12e2 + t9448 * t3799 / 0.96e2 + t4111 * t3802 / 0.32e2 - t10982 + t4129 * t4130 * t1185 / 0.6e1 - 0.3e1 / 0.8e1 * t258 * t27 * (t11074 + t11101 + t11129 + t11159) * t666 + t6 * t28 * t4105 * t1742 / 0.32e2 + t11173 - t4702 * t3805 / 0.12e2 + t6 * t248 * t1860 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t741 * t4698 - t11185 - 0.3e1 / 0.8e1 * t1237 * t4114 * t1233 - t11190;
  t11193 = my_piecewise3(t2, 0, t10957 + t11191);
  tv4rhosigmatau20 = t7 * t11193 + t4721;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 0] += tv4rhosigmatau20;

  tv4rhosigmatau21 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 1] += tv4rhosigmatau21;

  tv4rhosigmatau22 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 2] += tv4rhosigmatau22;

  tv4rhosigmatau23 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 3] += tv4rhosigmatau23;

  tv4rhosigmatau24 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 4] += tv4rhosigmatau24;

  tv4rhosigmatau25 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 5] += tv4rhosigmatau25;

  tv4rhosigmatau26 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 6] += tv4rhosigmatau26;

  tv4rhosigmatau27 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 7] += tv4rhosigmatau27;

  t11200 = t393 * t253 * t4791 * t711 / 0.8e1;
  t11208 = t6 * t365 * t1919 * t1805 / 0.96e2;
  t11212 = t2787 * t4800 / 0.8e1;
  t11216 = t2787 * t4804 / 0.4e1;
  t11220 = t9558 * t4807 / 0.48e2;
  t11224 = t2787 * t4812 / 0.8e1;
  t11225 = -0.3e1 / 0.8e1 * t955 * t4793 - t11200 + t6 * t361 * t1919 * t1805 / 0.32e2 + t11208 - 0.3e1 / 0.8e1 * t2784 * t4800 - t11212 + 0.3e1 / 0.4e1 * t2784 * t4804 + t11216 - t9553 * t4807 / 0.16e2 - t11220 + 0.3e1 / 0.8e1 * t2784 * t4812 + t11224;
  t11226 = my_piecewise3(t138, 0, t11225);
  tv4rhosigmatau28 = t7 * t11226 + t4816;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 8] += tv4rhosigmatau28;

  t11242 = -0.3e1 / 0.8e1 * t930 * t4698 - t11185 + t6 * t378 * t1860 * t1742 / 0.32e2 + t11173 - 0.3e1 / 0.8e1 * t2765 * t4705 - t11190 + 0.3e1 / 0.4e1 * t2765 * t4709 + t10950 - t9510 * t4712 / 0.16e2 - t10982 + 0.3e1 / 0.8e1 * t2765 * t4717 + t10948;
  t11243 = my_piecewise3(t2, 0, t11242);
  tv4rhosigmatau29 = t7 * t11243 + t4721;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 9] += tv4rhosigmatau29;

  tv4rhosigmatau210 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 10] += tv4rhosigmatau210;

  tv4rhosigmatau211 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 11] += tv4rhosigmatau211;

  tv4rhosigmatau212 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 12] += tv4rhosigmatau212;

  tv4rhosigmatau213 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 13] += tv4rhosigmatau213;

  tv4rhosigmatau214 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 14] += tv4rhosigmatau214;

  tv4rhosigmatau215 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 15] += tv4rhosigmatau215;

  tv4rhosigmatau216 = 0.e0;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 16] += tv4rhosigmatau216;

  t11261 = t393 * t710 * t2538;
  t11300 = t9585 * t232 * t1796 * t107 * t441 / 0.3e1 + t9581 * t4001 / 0.6e1 - 0.5e1 / 0.144e3 * t9593 * t9594 * t1325 - t4270 * t4276 * t617 / 0.16e2 - t4254 * t4001 / 0.12e2 - t11261 * t4271 * t71 * t170 * t1521 / 0.8e1 + 0.3e1 / 0.4e1 * t1358 * t1521 * t1113 * t4803 + 0.3e1 / 0.4e1 * t1358 * t4263 * t1925 * t3965 + 0.3e1 / 0.8e1 * t2806 * t4812 + 0.3e1 / 0.8e1 * t1358 * t1924 * t101 * t1353 * t232 - 0.3e1 / 0.8e1 * t1358 * t4257 * t4008 + 0.3e1 / 0.4e1 * t2806 * t4804 + t11216 + t11224 + 0.3e1 / 0.4e1 * t1802 * t9831 * t621 * t1521 + 0.3e1 / 0.8e1 * t6 * t147 * t1923 * t9831 * t4008 + 0.3e1 / 0.4e1 * t1802 * t9831 * t482 * t1796;
  t11303 = t3304 * sigma[2];
  t11314 = t8978 * t148;
  t11326 = t6571 * t400;
  t11329 = -0.73e2 / 0.6e3 * t4223 * t3951 - 0.73e2 / 0.3e3 * t11303 * t1513 - 0.1971e4 / 0.25e2 * t2896 * t4235 - 0.7884e4 / 0.25e2 * t1079 * t217 * t402 * t1015 - 0.73e2 / 0.6e3 * t9721 * t1788 - 0.73e2 / 0.6e3 * t11314 * t1513 + 0.73e2 / 0.4e3 * t3938 * t4240 + 0.73e2 / 0.4e3 * t3311 * t4783 + 0.73e2 / 0.4e3 * t1512 * t1872 * t1327 + 0.73e2 / 0.2e3 * t3956 * t4240 - 0.5913e4 / 0.2e3 * t11326 * t4231;
  t11335 = t2498 * t217;
  t11359 = -0.5913e4 / 0.2e3 * t9718 * t4774 - 0.5913e4 / 0.2e3 * t4230 * t1876 * t1327 - 0.5913e4 / 0.5e2 * t11335 * t4231 + 0.73e2 / 0.3e3 * t4223 * t3948 + 0.5913e4 / 0.5e2 * t4230 * t4168 * t599 - 0.73e2 / 0.2e3 * t1512 * t4164 * t599 + 0.73e2 / 0.3888e6 * t9635 * t1318 - t606 * t4164 / 0.3e2 + t4183 * t571 / 0.24e2 + 0.73e2 / 0.5e2 * t449 * t1321 * t404 - t4733 * t417 / 0.9e1 + 0.73e2 / 0.1e3 * t1313 * t4243;
  t11399 = -0.73e2 / 0.15e3 * t3926 * t1516 + 0.73e2 / 0.4e3 * t9690 * t3945 + 0.5913e4 / 0.8e2 * t9695 * t1876 * t1318 - 0.219e3 / 0.8e3 * t3316 * t1872 * t1318 + (-0.3e1 / 0.8e1 * t558 * t4165 + 0.37e2 / 0.256e3 * t561 * t4169 - 0.21e2 / 0.2048e4 * t1265 * t4173 + 0.63e2 / 0.262144e6 * t2873 * t4179 - 0.15e2 / 0.8388608e7 * t6660 * t2420 * t9660 * t5829) * t46 * t171 / 0.24e2 + 0.1971e4 / 0.1e3 * t6578 * t1911 + 0.1971e4 / 0.25e2 * t2490 * t4778 - 0.73e2 / 0.2e3 * t2909 * t1914 - 0.73e2 / 0.1e3 * t1074 * t4786 + 0.73e2 / 0.15e3 * t3301 * t1791 + 0.73e2 / 0.3e3 * t9026 * t704;
  t11416 = t9739 * t583;
  t11447 = 0.567e3 / 0.64e2 * t5872 * t4749 * t438 - 0.81e2 / 0.16e2 * t2462 * t1770 * t1499 - 0.81e2 / 0.32e2 * t2462 * t1894 * t1303 - 0.75e2 / 0.16e2 * t8000 * t10759 * t1774 + 0.225e3 / 0.64e2 * t10763 * t3917 - 0.45e2 / 0.32e2 * t10766 * t4753 + 0.195e3 / 0.32e2 * t4568 + 0.75e2 / 0.4e1 * t8000 * t4931 * t583 - 0.225e3 / 0.16e2 * t2462 * t4931 * t10751 - 0.75e2 / 0.4e1 * t4565 + 0.45e2 / 0.8e1 * t3570 * t1899 * t10755;
  t11448 = -0.15e2 / 0.8e1 * t4558 - 0.45e2 / 0.16e2 * t3891 * t9083 + 0.9e1 / 0.8e1 * t3891 * t9046 + 0.9e1 / 0.8e1 * t3891 * t9049 - 0.225e3 / 0.8e1 * t4556 - 0.225e3 / 0.32e2 * t4744 * t10102 + 0.3e1 / 0.16e2 * t1284 * t4197 + 0.45e2 / 0.256e3 * t586 * t9740 - 0.9e1 / 0.64e2 * t586 * t9743 - 0.45e2 / 0.32e2 * t2826 * t11416 + t11447;
  t11465 = t4759 * t448;
  t11474 = -0.73e2 / 0.972e5 * t11448 * t207 + 0.292e3 / 0.2025e4 * t195 * t11448 + 0.292e3 / 0.2025e4 * t443 * t4759 + 0.292e3 / 0.2025e4 * t588 * t4213 + 0.292e3 / 0.2025e4 * t1308 * t1903 + 0.584e3 / 0.2025e4 * t699 * t3921 + 0.584e3 / 0.2025e4 * t1502 * t1779 - t1887 * t1279 / 0.9e1 - 0.73e2 / 0.1944e6 * t11465 * t459 - 0.73e2 / 0.1944e6 * t9669 * t599 - 0.73e2 / 0.1944e6 * t4218 * t1327 - 0.73e2 / 0.75e2 * t1507 * t3959;
  t11514 = t4791 * t229;
  t11518 = -0.3e1 / 0.8e1 * t393 * t27 * (t11329 + t11359 + t11399 + t11474) * t711 - t393 * t4792 * t476 * t1530 / 0.12e2 + t9827 * t3986 / 0.96e2 + t4254 * t3989 / 0.32e2 - t9600 * t4807 / 0.16e2 + t4270 * t4271 * t1306 / 0.6e1 - t11220 - 0.3e1 / 0.8e1 * t999 * t4793 - t11200 + t11208 + t6 * t389 * t1919 * t1805 / 0.32e2 + t6 * t147 * t4248 * t1805 / 0.32e2 - t4797 * t3992 / 0.12e2 - t11212 - 0.3e1 / 0.8e1 * t2806 * t4800 - 0.3e1 / 0.8e1 * t1358 * t9616 * t621 - 0.3e1 / 0.8e1 * t1358 * t4257 * t1354 - 0.3e1 / 0.8e1 * t1358 * t11514 * t482;
  t11520 = my_piecewise3(t138, 0, t11300 + t11518);
  tv4rhosigmatau217 = t7 * t11520 + t4816;

  if(out->v4rhosigmatau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhosigmatau2[ip*p->dim.v4rhosigmatau2 + 17] += tv4rhosigmatau217;

  tv4rholapl30 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 0] += tv4rholapl30;

  tv4rholapl31 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 1] += tv4rholapl31;

  tv4rholapl32 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 2] += tv4rholapl32;

  tv4rholapl33 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 3] += tv4rholapl33;

  tv4rholapl34 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 4] += tv4rholapl34;

  tv4rholapl35 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 5] += tv4rholapl35;

  tv4rholapl36 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 6] += tv4rholapl36;

  tv4rholapl37 = 0.e0;

  if(out->v4rholapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl3[ip*p->dim.v4rholapl3 + 7] += tv4rholapl37;

  tv4rholapl2tau0 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 0] += tv4rholapl2tau0;

  tv4rholapl2tau1 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 1] += tv4rholapl2tau1;

  tv4rholapl2tau2 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 2] += tv4rholapl2tau2;

  tv4rholapl2tau3 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 3] += tv4rholapl2tau3;

  tv4rholapl2tau4 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 4] += tv4rholapl2tau4;

  tv4rholapl2tau5 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 5] += tv4rholapl2tau5;

  tv4rholapl2tau6 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 6] += tv4rholapl2tau6;

  tv4rholapl2tau7 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 7] += tv4rholapl2tau7;

  tv4rholapl2tau8 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 8] += tv4rholapl2tau8;

  tv4rholapl2tau9 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 9] += tv4rholapl2tau9;

  tv4rholapl2tau10 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 10] += tv4rholapl2tau10;

  tv4rholapl2tau11 = 0.e0;

  if(out->v4rholapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapl2tau[ip*p->dim.v4rholapl2tau + 11] += tv4rholapl2tau11;

  tv4rholapltau20 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 0] += tv4rholapltau20;

  tv4rholapltau21 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 1] += tv4rholapltau21;

  tv4rholapltau22 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 2] += tv4rholapltau22;

  tv4rholapltau23 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 3] += tv4rholapltau23;

  tv4rholapltau24 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 4] += tv4rholapltau24;

  tv4rholapltau25 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 5] += tv4rholapltau25;

  tv4rholapltau26 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 6] += tv4rholapltau26;

  tv4rholapltau27 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 7] += tv4rholapltau27;

  tv4rholapltau28 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 8] += tv4rholapltau28;

  tv4rholapltau29 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 9] += tv4rholapltau29;

  tv4rholapltau210 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 10] += tv4rholapltau210;

  tv4rholapltau211 = 0.e0;

  if(out->v4rholapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rholapltau2[ip*p->dim.v4rholapltau2 + 11] += tv4rholapltau211;

  t11527 = t258 * t253 * t4876 * t666 / 0.8e1;
  t11536 = t5025 * t4846;
  t11553 = -0.45e2 / 0.16e2 * t4652 - 0.135e3 / 0.32e2 * t3700 * t9337 + 0.27e2 / 0.8e1 * t3700 * t9341 + 0.375e3 / 0.2e1 * t4650 + 0.225e3 / 0.4e1 * t4843 * t9855 - 0.45e2 / 0.32e2 * t291 * t11536 + 0.567e3 / 0.64e2 * t5039 * t4846 * t304 - 0.243e3 / 0.32e2 * t2054 * t1835 * t1407 + 0.225e3 / 0.4e1 * t7779 * t10420 * t1839 - 0.675e3 / 0.16e2 * t10424 * t4066 + 0.135e3 / 0.8e1 * t10427 * t4850 - 0.225e3 / 0.4e1 * t4659;
  t11584 = -0.73e2 / 0.972e5 * t11553 * t98 - 0.5913e4 / 0.25e2 * t3068 * t4092 + 0.219e3 / 0.1e3 * t1415 * t4100 - 0.1436859e7 / 0.25e2 * t2090 * t763 * t1145 * t3011 + 0.292e3 / 0.2025e4 * t82 * t11553 + 0.292e3 / 0.2025e4 * t309 * t4853 + 0.292e3 / 0.675e3 * t654 * t4070 + 0.292e3 / 0.675e3 * t1410 * t1844 - 0.73e2 / 0.1e3 * t4075 * t1424 - 0.219e3 / 0.2e3 * t3065 * t1855 + 0.17739e5 / 0.25e2 * t830 * t4091 * t1381 - 0.73e2 / 0.25e2 * t315 * t316 * t633 - t4836 * t283 / 0.9e1;
  t11593 = t261 * t633;
  t11610 = 0.1e1 / t1821 / t632;
  t11625 = t5120 * t763;
  t11632 = t9288 * t29;
  t11635 = t6993 * t266;
  t11641 = t4853 * t314;
  t11644 = 0.5913e4 / 0.1e3 * t6996 * t1852 + 0.73e2 / 0.2e3 * t9402 * t659 - 0.17739e5 / 0.1e3 * t2082 * t4868 + 0.73e2 / 0.5e2 * t825 * t4871 + (0.3e1 / 0.4e1 * t30 * t11593 * t41 - 0.27e2 / 0.128e3 * t267 * t268 * t1381 * t273 + 0.207e3 / 0.16384e5 * t764 * t1145 * t3011 * t769 - 0.69e2 / 0.262144e6 * t2010 * t334 * t4830 * t2015 + 0.15e2 / 0.8388608e7 * t5143 * t2012 * t11610 * t5148) * t46 * t57 / 0.24e2 + 0.478953e6 / 0.5e2 * t5112 * t4865 + t108 * t11593 / 0.15e2 + 0.219e3 / 0.4e3 * t4080 * t4097 - 0.478953e6 / 0.2e2 * t11625 * t4825 * t325 + 0.53217e5 / 0.2e3 * t4087 * t4821 * t325 - 0.73e2 / 0.4e3 * t11632 * t1421 - 0.17739e5 / 0.2e3 * t11635 * t4088 - 0.73e2 / 0.1e3 * t1420 * t4817 * t325 - 0.73e2 / 0.1944e6 * t11641 * t325;
  t11654 = t4876 * t127;
  t11661 = 0.3e1 / 0.8e1 * t2577 * t4884;
  t11666 = t2130 * t664;
  t11680 = t2577 * t4894 / 0.8e1;
  t11681 = t1864 * t4889;
  t11690 = t258 * t27 * t4887 / t863 / t341;
  t11691 = t4893 * t107;
  t11700 = -0.3e1 / 0.8e1 * t741 * t4878 - t11527 - 0.3e1 / 0.8e1 * t258 * t27 * (t11584 + t11644) * t666 - t258 * t4877 * t342 * t1438 / 0.12e2 - 0.3e1 / 0.8e1 * t1237 * t11654 * t349 + 0.9e1 / 0.8e1 * t2568 * t4884 + t11661 + 0.9e1 / 0.8e1 * t1237 * t4105 * t864 * t4883 + t258 * t1861 * t11666 * t4131 / 0.2e1 + 0.9e1 / 0.8e1 * t1237 * t4881 * t4123 + 0.9e1 / 0.8e1 * t4702 * t4122 * t4135 - 0.3e1 / 0.8e1 * t2568 * t4894 - t11680 - 0.9e1 / 0.8e1 * t1237 * t11681 * t4893 * t1429 - t11690 * t11691 * t307 / 0.4e1 - 0.3e1 / 0.8e1 * t1237 * t4890 * t4892 * t348 * t130;
  t11701 = my_piecewise3(t2, 0, t11700);
  tv4rhotau30 = t7 * t11701 + t4898;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 0] += tv4rhotau30;

  tv4rhotau31 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 1] += tv4rhotau31;

  tv4rhotau32 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 2] += tv4rhotau32;

  t11708 = t393 * t253 * t4958 * t711 / 0.8e1;
  t11712 = 0.3e1 / 0.8e1 * t2787 * t4966;
  t11716 = t2787 * t4974 / 0.8e1;
  t11718 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t955 * t4960 - t11708 + 0.9e1 / 0.8e1 * t2784 * t4966 + t11712 - 0.3e1 / 0.8e1 * t2784 * t4974 - t11716);
  tv4rhotau33 = t7 * t11718 + t4978;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 3] += tv4rhotau33;

  t11727 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t930 * t4878 - t11527 + 0.9e1 / 0.8e1 * t2765 * t4884 + t11661 - 0.3e1 / 0.8e1 * t2765 * t4894 - t11680);
  tv4rhotau34 = t7 * t11727 + t4898;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 4] += tv4rhotau34;

  tv4rhotau35 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 5] += tv4rhotau35;

  tv4rhotau36 = 0.e0;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 6] += tv4rhotau36;

  t11739 = t5858 * t4928;
  t11756 = -0.45e2 / 0.16e2 * t4747 - 0.135e3 / 0.32e2 * t3891 * t9740 + 0.27e2 / 0.8e1 * t3891 * t9743 + 0.375e3 / 0.2e1 * t4745 + 0.225e3 / 0.4e1 * t4925 * t10102 - 0.45e2 / 0.32e2 * t425 * t11739 + 0.567e3 / 0.64e2 * t5872 * t4928 * t438 - 0.243e3 / 0.32e2 * t2462 * t1894 * t1499 + 0.225e3 / 0.4e1 * t8000 * t10759 * t1898 - 0.675e3 / 0.16e2 * t10763 * t4209 + 0.135e3 / 0.8e1 * t10766 * t4932 - 0.225e3 / 0.4e1 * t4754;
  t11786 = -0.73e2 / 0.972e5 * t11756 * t207 + 0.292e3 / 0.2025e4 * t195 * t11756 + 0.292e3 / 0.2025e4 * t443 * t4935 + 0.292e3 / 0.675e3 * t699 * t4213 - 0.5913e4 / 0.25e2 * t3304 * t4235 + 0.219e3 / 0.1e3 * t1507 * t4243 - 0.1436859e7 / 0.25e2 * t2498 * t1012 * t1266 * t3247 + 0.17739e5 / 0.25e2 * t1079 * t4234 * t1473 + 0.292e3 / 0.675e3 * t1502 * t1903 - 0.73e2 / 0.1e3 * t4218 * t1516 + 0.478953e6 / 0.5e2 * t5774 * t4947 - 0.17739e5 / 0.1e3 * t2490 * t4950 + 0.73e2 / 0.5e2 * t1074 * t4953;
  t11798 = t395 * t678;
  t11815 = 0.1e1 / t1880 / t677;
  t11824 = t4935 * t448;
  t11833 = t7501 * t400;
  t11838 = t5782 * t1012;
  t11842 = t9635 * t148;
  t11847 = -0.73e2 / 0.25e2 * t449 * t450 * t678 - t4918 * t417 / 0.9e1 + 0.5913e4 / 0.1e3 * t7498 * t1911 - 0.219e3 / 0.2e3 * t3301 * t1914 + 0.73e2 / 0.2e3 * t9669 * t704 + (0.3e1 / 0.4e1 * t149 * t11798 * t160 - 0.27e2 / 0.128e3 * t401 * t402 * t1473 * t407 + 0.207e3 / 0.16384e5 * t1013 * t1266 * t3247 * t1018 - 0.69e2 / 0.262144e6 * t2418 * t468 * t4912 * t2423 + 0.15e2 / 0.8388608e7 * t5824 * t2420 * t11815 * t5829) * t46 * t171 / 0.24e2 - 0.73e2 / 0.1944e6 * t11824 * t459 + 0.53217e5 / 0.2e3 * t4230 * t4903 * t459 - 0.73e2 / 0.1e3 * t1512 * t4899 * t459 - 0.17739e5 / 0.2e3 * t11833 * t4231 + 0.219e3 / 0.4e3 * t4223 * t4240 - 0.478953e6 / 0.2e2 * t11838 * t4907 * t459 - 0.73e2 / 0.4e3 * t11842 * t1513 + t214 * t11798 / 0.15e2;
  t11857 = t4958 * t229;
  t11867 = t2538 * t709;
  t11880 = t1923 * t4971;
  t11889 = t393 * t27 * t4969 / t1112 / t475;
  t11890 = t4973 * t107;
  t11899 = -0.3e1 / 0.8e1 * t999 * t4960 - t11708 - 0.3e1 / 0.8e1 * t393 * t27 * (t11786 + t11847) * t711 - t393 * t4959 * t476 * t1530 / 0.12e2 - 0.3e1 / 0.8e1 * t1358 * t11857 * t482 + 0.9e1 / 0.8e1 * t2806 * t4966 + t11712 + 0.9e1 / 0.8e1 * t1358 * t4248 * t1113 * t4965 + t393 * t1920 * t11867 * t4272 / 0.2e1 + 0.9e1 / 0.8e1 * t1358 * t4963 * t4264 + 0.9e1 / 0.8e1 * t4797 * t4263 * t4276 - 0.3e1 / 0.8e1 * t2806 * t4974 - t11716 - 0.9e1 / 0.8e1 * t1358 * t11880 * t4973 * t1521 - t11889 * t11890 * t441 / 0.4e1 - 0.3e1 / 0.8e1 * t1358 * t4972 * t4892 * t481 * t232;
  t11900 = my_piecewise3(t138, 0, t11899);
  tv4rhotau37 = t7 * t11900 + t4978;

  if(out->v4rhotau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4rhotau3[ip*p->dim.v4rhotau3 + 7] += tv4rhotau37;

  t11918 = t1567 * t1567;
  t11924 = t2618 * params->b;
  t11927 = t1560 * t1560;
  t11933 = params->b * params->b;
  t11934 = t801 * t11933;
  t11936 = 0.1e1 / t54 / t851;
  t11939 = 0.1e1 / t50 / t112;
  t11943 = 0.45e2 / 0.64e2 * t506 * t9858 - 0.225e3 / 0.512e3 * t4303 * t11924 + 0.567e3 / 0.64e2 * t5039 * t11927 - 0.675e3 / 0.512e3 * t2054 * t1560 * t4311 + 0.1125e4 / 0.8192e4 * t11934 * t11936 * t46 * t11939;
  t11958 = t1574 * t1574;
  t11964 = t1579 * t1579;
  t11967 = (0.117e3 / 0.32768e5 * t7648 * t7652 * t29 - 0.3e1 / 0.256e3 * t4283 * t3356 - 0.21e2 / 0.131072e6 * t267 * t4290 + 0.15e2 / 0.8388608e7 * t764 * t9386 * t5148) * t46 * t57 / 0.24e2 + t4294 * t503 / 0.6e1 + 0.292e3 / 0.675e3 * t11918 + 0.1168e4 / 0.2025e4 * t520 * t4314 + 0.292e3 / 0.2025e4 * t82 * t11943 - 0.73e2 / 0.972e5 * t11943 * t98 - 0.73e2 / 0.486e5 * t9952 * t531 + 0.73e2 / 0.648e5 * t7738 * t1574 - 0.73e2 / 0.324e5 * t3414 * t1579 - 0.73e2 / 0.648e5 * t6237 * t4325 + 0.73e2 / 0.324e5 * t2687 * t4328 + 0.73e2 / 0.10368e6 * t5120 * t11958 - 0.73e2 / 0.432e5 * t2090 * t1574 * t1579 + 0.73e2 / 0.1296e6 * t830 * t11964;
  t11990 = t1603 * t1603;
  t11998 = t1607 * t1607;
  t12004 = my_piecewise3(t2, 0, 0.3e1 / 0.8e1 * t258 * t259 * (-t11967 * t127 * t101 + t9961 * t101 * t549 / 0.3e1 - t7821 * t101 * t1600 / 0.16e2 + t6270 * t4342 / 0.24e2 - 0.5e1 / 0.2304e4 * t5181 * t113 * t11936 * t71) * t130 + 0.3e1 / 0.2e1 * t1237 * t9996 * t553 + 0.9e1 / 0.8e1 * t258 * t259 * t11990 * t130 + 0.9e1 / 0.4e1 * t1237 * t3481 * t1608 + 0.3e1 / 0.8e1 * t258 * t259 * t11998 * t130);
  tv4sigma40 = t7 * t12004;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 0] += tv4sigma40;

  tv4sigma41 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 1] += tv4sigma41;

  tv4sigma42 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 2] += tv4sigma42;

  tv4sigma43 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 3] += tv4sigma43;

  tv4sigma44 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 4] += tv4sigma44;

  tv4sigma45 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 5] += tv4sigma45;

  tv4sigma46 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 6] += tv4sigma46;

  tv4sigma47 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 7] += tv4sigma47;

  tv4sigma48 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 8] += tv4sigma48;

  tv4sigma49 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 9] += tv4sigma49;

  tv4sigma410 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 10] += tv4sigma410;

  tv4sigma411 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 11] += tv4sigma411;

  tv4sigma412 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 12] += tv4sigma412;

  tv4sigma413 = 0.e0;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 13] += tv4sigma413;

  t12021 = t1641 * t1641;
  t12027 = t2827 * params->b;
  t12030 = t1634 * t1634;
  t12036 = t1050 * t11933;
  t12038 = 0.1e1 / t168 / t1100;
  t12043 = 0.45e2 / 0.64e2 * t574 * t10105 - 0.225e3 / 0.512e3 * t4380 * t12027 + 0.567e3 / 0.64e2 * t5872 * t12030 - 0.675e3 / 0.512e3 * t2462 * t1634 * t4388 + 0.1125e4 / 0.8192e4 * t12036 * t12038 * t46 * t11939;
  t12058 = t1648 * t1648;
  t12064 = t1653 * t1653;
  t12067 = (0.117e3 / 0.32768e5 * t8059 * t8063 * t148 - 0.3e1 / 0.256e3 * t4360 * t3526 - 0.21e2 / 0.131072e6 * t401 * t4367 + 0.15e2 / 0.8388608e7 * t1013 * t9655 * t5829) * t46 * t171 / 0.24e2 + t4371 * t571 / 0.6e1 + 0.292e3 / 0.675e3 * t12021 + 0.1168e4 / 0.2025e4 * t588 * t4391 + 0.292e3 / 0.2025e4 * t195 * t12043 - 0.73e2 / 0.972e5 * t12043 * t207 - 0.73e2 / 0.486e5 * t10060 * t599 + 0.73e2 / 0.648e5 * t8140 * t1648 - 0.73e2 / 0.324e5 * t3584 * t1653 - 0.73e2 / 0.648e5 * t6571 * t4402 + 0.73e2 / 0.324e5 * t2896 * t4405 + 0.73e2 / 0.10368e6 * t5782 * t12058 - 0.73e2 / 0.432e5 * t2498 * t1648 * t1653 + 0.73e2 / 0.1296e6 * t1079 * t12064;
  t12090 = t1676 * t1676;
  t12098 = t1680 * t1680;
  t12104 = my_piecewise3(t138, 0, 0.3e1 / 0.8e1 * t393 * t259 * (-t12067 * t229 * t101 + t10172 * t101 * t617 / 0.3e1 - t8173 * t101 * t1673 / 0.16e2 + t6682 * t4419 / 0.24e2 - 0.5e1 / 0.2304e4 * t5955 * t113 * t12038 * t71) * t232 + 0.3e1 / 0.2e1 * t1358 * t10207 * t621 + 0.9e1 / 0.8e1 * t393 * t259 * t12090 * t232 + 0.9e1 / 0.4e1 * t1358 * t3651 * t1681 + 0.3e1 / 0.8e1 * t393 * t259 * t12098 * t232);
  tv4sigma414 = t7 * t12104;

  if(out->v4sigma4 != NULL && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma4[ip*p->dim.v4sigma4 + 14] += tv4sigma414;

  tv4sigma3lapl0 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 0] += tv4sigma3lapl0;

  tv4sigma3lapl1 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 1] += tv4sigma3lapl1;

  tv4sigma3lapl2 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 2] += tv4sigma3lapl2;

  tv4sigma3lapl3 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 3] += tv4sigma3lapl3;

  tv4sigma3lapl4 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 4] += tv4sigma3lapl4;

  tv4sigma3lapl5 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 5] += tv4sigma3lapl5;

  tv4sigma3lapl6 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 6] += tv4sigma3lapl6;

  tv4sigma3lapl7 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 7] += tv4sigma3lapl7;

  tv4sigma3lapl8 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 8] += tv4sigma3lapl8;

  tv4sigma3lapl9 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 9] += tv4sigma3lapl9;

  tv4sigma3lapl10 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 10] += tv4sigma3lapl10;

  tv4sigma3lapl11 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 11] += tv4sigma3lapl11;

  tv4sigma3lapl12 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 12] += tv4sigma3lapl12;

  tv4sigma3lapl13 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 13] += tv4sigma3lapl13;

  tv4sigma3lapl14 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 14] += tv4sigma3lapl14;

  tv4sigma3lapl15 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 15] += tv4sigma3lapl15;

  tv4sigma3lapl16 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 16] += tv4sigma3lapl16;

  tv4sigma3lapl17 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 17] += tv4sigma3lapl17;

  tv4sigma3lapl18 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 18] += tv4sigma3lapl18;

  tv4sigma3lapl19 = 0.e0;

  if(out->v4sigma3lapl != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3lapl[ip*p->dim.v4sigma3lapl + 19] += tv4sigma3lapl19;

  t12176 = 0.73e2 / 0.6e3 * t9952 * t659 + 0.73e2 / 0.1e3 * t1192 * t628 + (0.3e1 / 0.64e2 * t4283 * t10357 * sigma[0] - 0.99e2 / 0.16384e5 * t493 * t1692 + 0.51e2 / 0.262144e6 * t1144 * t4445 - 0.15e2 / 0.8388608e7 * t2671 * t852 * t4830 * t5148) * t46 * t57 / 0.24e2 + t4449 * t503 / 0.8e1 - 0.73e2 / 0.648e5 * t10449 * t531 - 0.73e2 / 0.648e5 * t3735 * t1579 - 0.73e2 / 0.4e3 * t10328 * t1725 + 0.73e2 / 0.1e3 * t3414 * t1728 - 0.73e2 / 0.4e3 * t3747 * t4497 - 0.73e2 / 0.2e3 * t830 * t1725 - 0.73e2 / 0.2e3 * t3765 * t4497 + 0.73e2 / 0.1296e6 * t8604 * t1574;
  t12187 = t3036 * params->b;
  t12193 = t88 * t1560;
  t12197 = t2054 * t1707;
  t12206 = -0.45e2 / 0.32e2 * t642 * t9858 + 0.675e3 / 0.256e3 * t4460 * t11924 + 0.135e3 / 0.256e3 * t518 * t10395 - 0.225e3 / 0.2048e4 * t4303 * t12187 + 0.567e3 / 0.64e2 * t5039 * t651 * t4306 + 0.675e3 / 0.128e3 * t7788 * t1712 * t12193 - 0.675e3 / 0.1024e4 * t12197 * t4311 - 0.1125e4 / 0.1024e4 * t11934 / t54 / t333 * t46 * t11939;
  t12229 = -0.73e2 / 0.2592e6 * t6993 * t4325 + 0.73e2 / 0.1296e6 * t3068 * t4328 + 0.292e3 / 0.2025e4 * t82 * t12206 - 0.73e2 / 0.972e5 * t12206 * t98 + 0.292e3 / 0.2025e4 * t4314 * t654 + 0.292e3 / 0.675e3 * t1567 * t1716 + 0.292e3 / 0.675e3 * t520 * t4475 + 0.219e3 / 0.8e3 * t8405 * t4492 - 0.73e2 / 0.1e3 * t10321 * t1725 - 0.73e2 / 0.32e3 * t6867 * t628 * t4325 + 0.219e3 / 0.4e3 * t8415 * t4492 + 0.219e3 / 0.8e3 * t3080 * t628 * t4328;
  t12244 = 0.3e1 / 0.32e2 * t6 * t28 * t4504 * t1742 - 0.3e1 / 0.256e3 * t4510 * t4518 - 0.3e1 / 0.256e3 * t2981 * t8305 * t1564 + 0.3e1 / 0.32e2 * t1435 * t10278 * t518 + 0.3e1 / 0.16e2 * t3780 * t4521 + 0.3e1 / 0.32e2 * t1435 * t10282 * t518 - 0.3e1 / 0.8e1 * t1237 * t1441 * t4354 - 0.9e1 / 0.8e1 * t1237 * t3783 * t1608 + t7078 * t28 * t11666 * t130 * t2133 * t117 / 0.256e3 - 0.9e1 / 0.8e1 * t1237 * t1441 * t1603 * t552 * t130 - 0.3e1 / 0.8e1 * t258 * t27 * (t12176 + t12229) * t666 - 0.9e1 / 0.8e1 * t1237 * t10261 * t553 - 0.9e1 / 0.8e1 * t1237 * t3783 * t1604 - 0.3e1 / 0.8e1 * t1237 * t1441 * t4346;
  t12245 = my_piecewise3(t2, 0, t12244);
  tv4sigma3tau0 = t7 * t12245;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 0] += tv4sigma3tau0;

  tv4sigma3tau1 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 1] += tv4sigma3tau1;

  tv4sigma3tau2 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 2] += tv4sigma3tau2;

  tv4sigma3tau3 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 3] += tv4sigma3tau3;

  tv4sigma3tau4 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 4] += tv4sigma3tau4;

  tv4sigma3tau5 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 5] += tv4sigma3tau5;

  tv4sigma3tau6 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 6] += tv4sigma3tau6;

  tv4sigma3tau7 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 7] += tv4sigma3tau7;

  tv4sigma3tau8 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 8] += tv4sigma3tau8;

  tv4sigma3tau9 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 9] += tv4sigma3tau9;

  tv4sigma3tau10 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 10] += tv4sigma3tau10;

  tv4sigma3tau11 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 11] += tv4sigma3tau11;

  tv4sigma3tau12 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 12] += tv4sigma3tau12;

  tv4sigma3tau13 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 13] += tv4sigma3tau13;

  tv4sigma3tau14 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 14] += tv4sigma3tau14;

  tv4sigma3tau15 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 15] += tv4sigma3tau15;

  tv4sigma3tau16 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 16] += tv4sigma3tau16;

  tv4sigma3tau17 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 17] += tv4sigma3tau17;

  tv4sigma3tau18 = 0.e0;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 18] += tv4sigma3tau18;

  t12304 = -0.73e2 / 0.648e5 * t10822 * t599 - 0.73e2 / 0.648e5 * t3926 * t1653 - 0.73e2 / 0.2e3 * t1079 * t1788 - 0.73e2 / 0.2e3 * t3956 * t4592 - 0.73e2 / 0.4e3 * t10830 * t1788 + 0.73e2 / 0.1e3 * t3584 * t1791 - 0.73e2 / 0.4e3 * t3938 * t4592 + t4544 * t571 / 0.8e1 + 0.73e2 / 0.6e3 * t10060 * t704 + 0.73e2 / 0.1e3 * t1313 * t673 + 0.73e2 / 0.1296e6 * t8978 * t1648 - 0.73e2 / 0.2592e6 * t7501 * t4402;
  t12319 = t3272 * params->b;
  t12325 = t88 * t1634;
  t12329 = t2462 * t1770;
  t12338 = -0.45e2 / 0.32e2 * t687 * t10105 + 0.675e3 / 0.256e3 * t4555 * t12027 + 0.135e3 / 0.256e3 * t586 * t10734 - 0.225e3 / 0.2048e4 * t4380 * t12319 + 0.567e3 / 0.64e2 * t5872 * t696 * t4383 + 0.675e3 / 0.128e3 * t8041 * t1775 * t12325 - 0.675e3 / 0.1024e4 * t12329 * t4388 - 0.1125e4 / 0.1024e4 * t12036 / t168 / t467 * t46 * t11939;
  t12370 = 0.73e2 / 0.1296e6 * t3304 * t4405 + 0.292e3 / 0.2025e4 * t4391 * t699 + 0.292e3 / 0.675e3 * t1641 * t1779 + 0.292e3 / 0.675e3 * t588 * t4570 + 0.292e3 / 0.2025e4 * t195 * t12338 - 0.73e2 / 0.972e5 * t12338 * t207 + (0.3e1 / 0.64e2 * t4360 * t10855 * sigma[2] - 0.99e2 / 0.16384e5 * t561 * t1755 + 0.51e2 / 0.262144e6 * t1265 * t4540 - 0.15e2 / 0.8388608e7 * t2873 * t1101 * t4912 * t5829) * t46 * t171 / 0.24e2 + 0.219e3 / 0.8e3 * t8907 * t4587 - 0.73e2 / 0.1e3 * t10827 * t1788 - 0.73e2 / 0.32e3 * t7353 * t673 * t4402 + 0.219e3 / 0.4e3 * t8921 * t4587 + 0.219e3 / 0.8e3 * t3316 * t673 * t4405;
  t12385 = -0.3e1 / 0.256e3 * t4605 * t4613 + 0.3e1 / 0.32e2 * t6 * t147 * t4599 * t1805 + 0.3e1 / 0.16e2 * t3971 * t4616 - 0.3e1 / 0.256e3 * t3213 * t8842 * t1638 + 0.3e1 / 0.32e2 * t1527 * t10639 * t586 + 0.3e1 / 0.32e2 * t1527 * t10643 * t586 - 0.3e1 / 0.8e1 * t1358 * t1533 * t4431 - 0.9e1 / 0.8e1 * t1358 * t3974 * t1681 + t7078 * t147 * t11867 * t232 * t2133 * t220 / 0.256e3 - 0.9e1 / 0.8e1 * t1358 * t1533 * t1676 * t620 * t232 - 0.3e1 / 0.8e1 * t393 * t27 * (t12304 + t12370) * t711 - 0.9e1 / 0.8e1 * t1358 * t10624 * t621 - 0.9e1 / 0.8e1 * t1358 * t3974 * t1677 - 0.3e1 / 0.8e1 * t1358 * t1533 * t4423;
  t12386 = my_piecewise3(t138, 0, t12385);
  tv4sigma3tau19 = t7 * t12386;

  if(out->v4sigma3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma3tau[ip*p->dim.v4sigma3tau + 19] += tv4sigma3tau19;

  tv4sigma2lapl20 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 0] += tv4sigma2lapl20;

  tv4sigma2lapl21 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 1] += tv4sigma2lapl21;

  tv4sigma2lapl22 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 2] += tv4sigma2lapl22;

  tv4sigma2lapl23 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 3] += tv4sigma2lapl23;

  tv4sigma2lapl24 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 4] += tv4sigma2lapl24;

  tv4sigma2lapl25 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 5] += tv4sigma2lapl25;

  tv4sigma2lapl26 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 6] += tv4sigma2lapl26;

  tv4sigma2lapl27 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 7] += tv4sigma2lapl27;

  tv4sigma2lapl28 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 8] += tv4sigma2lapl28;

  tv4sigma2lapl29 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 9] += tv4sigma2lapl29;

  tv4sigma2lapl210 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 10] += tv4sigma2lapl210;

  tv4sigma2lapl211 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 11] += tv4sigma2lapl211;

  tv4sigma2lapl212 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 12] += tv4sigma2lapl212;

  tv4sigma2lapl213 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 13] += tv4sigma2lapl213;

  tv4sigma2lapl214 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 14] += tv4sigma2lapl214;

  tv4sigma2lapl215 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 15] += tv4sigma2lapl215;

  tv4sigma2lapl216 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 16] += tv4sigma2lapl216;

  tv4sigma2lapl217 = 0.e0;

  if(out->v4sigma2lapl2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapl2[ip*p->dim.v4sigma2lapl2 + 17] += tv4sigma2lapl217;

  tv4sigma2lapltau0 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 0] += tv4sigma2lapltau0;

  tv4sigma2lapltau1 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 1] += tv4sigma2lapltau1;

  tv4sigma2lapltau2 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 2] += tv4sigma2lapltau2;

  tv4sigma2lapltau3 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 3] += tv4sigma2lapltau3;

  tv4sigma2lapltau4 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 4] += tv4sigma2lapltau4;

  tv4sigma2lapltau5 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 5] += tv4sigma2lapltau5;

  tv4sigma2lapltau6 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 6] += tv4sigma2lapltau6;

  tv4sigma2lapltau7 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 7] += tv4sigma2lapltau7;

  tv4sigma2lapltau8 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 8] += tv4sigma2lapltau8;

  tv4sigma2lapltau9 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 9] += tv4sigma2lapltau9;

  tv4sigma2lapltau10 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 10] += tv4sigma2lapltau10;

  tv4sigma2lapltau11 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 11] += tv4sigma2lapltau11;

  tv4sigma2lapltau12 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 12] += tv4sigma2lapltau12;

  tv4sigma2lapltau13 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 13] += tv4sigma2lapltau13;

  tv4sigma2lapltau14 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 14] += tv4sigma2lapltau14;

  tv4sigma2lapltau15 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 15] += tv4sigma2lapltau15;

  tv4sigma2lapltau16 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 16] += tv4sigma2lapltau16;

  tv4sigma2lapltau17 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 17] += tv4sigma2lapltau17;

  tv4sigma2lapltau18 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 18] += tv4sigma2lapltau18;

  tv4sigma2lapltau19 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 19] += tv4sigma2lapltau19;

  tv4sigma2lapltau20 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 20] += tv4sigma2lapltau20;

  tv4sigma2lapltau21 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 21] += tv4sigma2lapltau21;

  tv4sigma2lapltau22 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 22] += tv4sigma2lapltau22;

  tv4sigma2lapltau23 = 0.e0;

  if(out->v4sigma2lapltau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2lapltau[ip*p->dim.v4sigma2lapltau + 23] += tv4sigma2lapltau23;

  t12423 = -0.73e2 / 0.972e5 * t11132 * t531 - 0.219e3 / 0.8e3 * t3080 * t1813 * t1574 + 0.73e2 / 0.1e3 * t3765 * t4688 + 0.73e2 / 0.4e3 * t9273 * t4492 - 0.73e2 / 0.15e3 * t11081 * t1725 + 0.5913e4 / 0.8e2 * t9252 * t1817 * t1574 - 0.5913e4 / 0.25e2 * t11122 * t4679 - 0.73e2 / 0.3e3 * t11088 * t1725 - 0.5913e4 / 0.1e3 * t11114 * t4679 - 0.5913e4 / 0.2e3 * t4087 * t1817 * t1579 + 0.73e2 / 0.2e3 * t3747 * t4688 + 0.73e2 / 0.4e3 * t1420 * t1813 * t1579 - 0.73e2 / 0.6e3 * t4080 * t4497 + 0.73e2 / 0.3888e6 * t9288 * t1574 + t1585 * t270 / 0.6e2 - 0.73e2 / 0.1944e6 * t4075 * t1579;
  t12424 = t1716 * t1716;
  t12448 = t2054 * t1835;
  t12460 = -0.45e2 / 0.16e2 * t3700 * t10395 - 0.225e3 / 0.16e2 * t4649 * t11924 + 0.225e3 / 0.128e3 * t4460 * t12187 + 0.45e2 / 0.128e3 * t518 * t11002 + 0.567e3 / 0.64e2 * t5039 * t1835 * t1560 + 0.225e3 / 0.32e2 * t12197 * t4658 - 0.225e3 / 0.1024e4 * t12448 * t4311 + 0.1125e4 / 0.128e3 * t11934 / t54 / t116 * t46 * t11939 - 0.225e3 / 0.16e2 * t7788 * t1840 * t12193;
  t12500 = 0.584e3 / 0.2025e4 * t12424 + 0.73e2 / 0.75e2 * t3735 * t1728 + 0.3942e4 / 0.25e2 * t2687 * t4683 + 0.5913e4 / 0.25e2 * t830 * t834 * t766 - 0.73e2 / 0.5e2 * t1192 * t4691 - 0.73e2 / 0.972e5 * t12460 * t98 + 0.292e3 / 0.2025e4 * t82 * t12460 + 0.584e3 / 0.2025e4 * t520 * t4664 + 0.292e3 / 0.2025e4 * t1567 * t1844 + 0.584e3 / 0.2025e4 * t654 * t4475 + 0.73e2 / 0.3e3 * t10449 * t659 - 0.73e2 / 0.2e3 * t3414 * t1855 + (0.3e1 / 0.16e2 * t1540 * t270 * t41 - 0.57e2 / 0.512e3 * t30 * t1818 + 0.297e3 / 0.32768e5 * t267 * t1824 - 0.15e2 / 0.65536e5 * t764 * t4634 + 0.15e2 / 0.8388608e7 * t2010 * t852 * t9391 * t5148) * t46 * t57 / 0.24e2 + 0.1971e4 / 0.1e3 * t7738 * t1852 - 0.73e2 / 0.1e3 * t315 * t1813 + t4638 * t503 / 0.12e2 + 0.73e2 / 0.15e3 * t1415 * t628;
  t12523 = t1733 * t1733;
  t12555 = -0.3e1 / 0.8e1 * t258 * t27 * (t12423 + t12500) * t666 + t6 * t28 * t4696 * t1742 / 0.16e2 - 0.3e1 / 0.4e1 * t1237 * t10902 * t553 - t4702 * t4518 / 0.256e3 + t4111 * t4521 / 0.16e2 - 0.3e1 / 0.8e1 * t1237 * t4114 * t1604 - 0.3e1 / 0.8e1 * t1237 * t4114 * t1608 + 0.3e1 / 0.4e1 * t1237 * t12523 * t864 * t1866 - t10919 * t4708 * t549 / 0.4e1 + 0.3e1 / 0.2e1 * t1739 * t9462 * t553 * t1733 + 0.3e1 / 0.4e1 * t1237 * t4122 * t1866 * t4504 + 0.5e1 / 0.384e3 * t9212 * t9213 * t1564 - t4129 * t4716 * t549 / 0.8e1 + 0.3e1 / 0.8e1 * t1237 * t1865 * t101 * t1603 * t130 + 0.3e1 / 0.8e1 * t1237 * t1865 * t101 * t1607 * t130;
  t12556 = my_piecewise3(t2, 0, t12555);
  tv4sigma2tau20 = t7 * t12556;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 0] += tv4sigma2tau20;

  tv4sigma2tau21 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 1] += tv4sigma2tau21;

  tv4sigma2tau22 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 2] += tv4sigma2tau22;

  tv4sigma2tau23 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 3] += tv4sigma2tau23;

  tv4sigma2tau24 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 4] += tv4sigma2tau24;

  tv4sigma2tau25 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 5] += tv4sigma2tau25;

  tv4sigma2tau26 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 6] += tv4sigma2tau26;

  tv4sigma2tau27 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 7] += tv4sigma2tau27;

  tv4sigma2tau28 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 8] += tv4sigma2tau28;

  tv4sigma2tau29 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 9] += tv4sigma2tau29;

  tv4sigma2tau210 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 10] += tv4sigma2tau210;

  tv4sigma2tau211 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 11] += tv4sigma2tau211;

  tv4sigma2tau212 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 12] += tv4sigma2tau212;

  tv4sigma2tau213 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 13] += tv4sigma2tau213;

  tv4sigma2tau214 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 14] += tv4sigma2tau214;

  tv4sigma2tau215 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 15] += tv4sigma2tau215;

  tv4sigma2tau216 = 0.e0;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 16] += tv4sigma2tau216;

  t12557 = t1779 * t1779;
  t12572 = t2462 * t1894;
  t12584 = -0.45e2 / 0.16e2 * t3891 * t10734 - 0.225e3 / 0.16e2 * t4744 * t12027 + 0.225e3 / 0.128e3 * t4555 * t12319 + 0.45e2 / 0.128e3 * t586 * t11416 + 0.567e3 / 0.64e2 * t5872 * t1894 * t1634 + 0.225e3 / 0.32e2 * t12329 * t4753 - 0.225e3 / 0.1024e4 * t12572 * t4388 + 0.1125e4 / 0.128e3 * t12036 / t168 / t219 * t46 * t11939 - 0.225e3 / 0.16e2 * t8041 * t1899 * t12325;
  t12631 = 0.584e3 / 0.2025e4 * t12557 + 0.292e3 / 0.2025e4 * t195 * t12584 - 0.73e2 / 0.972e5 * t12584 * t207 + 0.584e3 / 0.2025e4 * t588 * t4759 + 0.292e3 / 0.2025e4 * t1641 * t1903 + 0.584e3 / 0.2025e4 * t699 * t4570 + 0.73e2 / 0.75e2 * t3926 * t1791 + 0.5913e4 / 0.25e2 * t1079 * t1083 * t1015 - 0.73e2 / 0.5e2 * t1313 * t4786 + 0.3942e4 / 0.25e2 * t2896 * t4778 - 0.73e2 / 0.1e3 * t449 * t1872 + t4733 * t571 / 0.12e2 + 0.1971e4 / 0.1e3 * t8140 * t1911 - 0.73e2 / 0.2e3 * t3584 * t1914 + (0.3e1 / 0.16e2 * t1614 * t404 * t160 - 0.57e2 / 0.512e3 * t149 * t1877 + 0.297e3 / 0.32768e5 * t401 * t1883 - 0.15e2 / 0.65536e5 * t1013 * t4729 + 0.15e2 / 0.8388608e7 * t2418 * t1101 * t9660 * t5829) * t46 * t171 / 0.24e2 + 0.73e2 / 0.3e3 * t10822 * t704;
  t12670 = 0.73e2 / 0.15e3 * t1507 * t673 + 0.5913e4 / 0.8e2 * t9695 * t1876 * t1648 - 0.5913e4 / 0.25e2 * t11335 * t4774 - 0.219e3 / 0.8e3 * t3316 * t1872 * t1648 + 0.73e2 / 0.1e3 * t3956 * t4783 + 0.73e2 / 0.4e3 * t9690 * t4587 - 0.73e2 / 0.15e3 * t11303 * t1788 + 0.73e2 / 0.4e3 * t1512 * t1872 * t1653 - 0.73e2 / 0.3e3 * t11314 * t1788 - 0.73e2 / 0.6e3 * t4223 * t4592 - 0.5913e4 / 0.1e3 * t11326 * t4774 - 0.5913e4 / 0.2e3 * t4230 * t1876 * t1653 + 0.73e2 / 0.2e3 * t3938 * t4783 - 0.73e2 / 0.972e5 * t11465 * t599 - 0.73e2 / 0.1944e6 * t4218 * t1653 + 0.73e2 / 0.3888e6 * t9635 * t1648 + t1659 * t404 / 0.6e2;
  t12693 = t1796 * t1796;
  t12725 = -0.3e1 / 0.8e1 * t393 * t27 * (t12631 + t12670) * t711 + t6 * t147 * t4791 * t1805 / 0.16e2 - 0.3e1 / 0.4e1 * t1358 * t11514 * t621 - t4797 * t4613 / 0.256e3 + t4254 * t4616 / 0.16e2 - 0.3e1 / 0.8e1 * t1358 * t4257 * t1677 - 0.3e1 / 0.8e1 * t1358 * t4257 * t1681 + 0.3e1 / 0.4e1 * t1358 * t12693 * t1113 * t1925 - t11261 * t4803 * t617 / 0.4e1 + 0.3e1 / 0.2e1 * t1802 * t9831 * t621 * t1796 + 0.3e1 / 0.4e1 * t1358 * t4263 * t1925 * t4599 + 0.5e1 / 0.384e3 * t9593 * t9594 * t1638 - t4270 * t4811 * t617 / 0.8e1 + 0.3e1 / 0.8e1 * t1358 * t1924 * t101 * t1676 * t232 + 0.3e1 / 0.8e1 * t1358 * t1924 * t101 * t1680 * t232;
  t12726 = my_piecewise3(t138, 0, t12725);
  tv4sigma2tau217 = t7 * t12726;

  if(out->v4sigma2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigma2tau2[ip*p->dim.v4sigma2tau2 + 17] += tv4sigma2tau217;

  tv4sigmalapl30 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 0] += tv4sigmalapl30;

  tv4sigmalapl31 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 1] += tv4sigmalapl31;

  tv4sigmalapl32 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 2] += tv4sigmalapl32;

  tv4sigmalapl33 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 3] += tv4sigmalapl33;

  tv4sigmalapl34 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 4] += tv4sigmalapl34;

  tv4sigmalapl35 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 5] += tv4sigmalapl35;

  tv4sigmalapl36 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 6] += tv4sigmalapl36;

  tv4sigmalapl37 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 7] += tv4sigmalapl37;

  tv4sigmalapl38 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 8] += tv4sigmalapl38;

  tv4sigmalapl39 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 9] += tv4sigmalapl39;

  tv4sigmalapl310 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 10] += tv4sigmalapl310;

  tv4sigmalapl311 = 0.e0;

  if(out->v4sigmalapl3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl3[ip*p->dim.v4sigmalapl3 + 11] += tv4sigmalapl311;

  tv4sigmalapl2tau0 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 0] += tv4sigmalapl2tau0;

  tv4sigmalapl2tau1 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 1] += tv4sigmalapl2tau1;

  tv4sigmalapl2tau2 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 2] += tv4sigmalapl2tau2;

  tv4sigmalapl2tau3 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 3] += tv4sigmalapl2tau3;

  tv4sigmalapl2tau4 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 4] += tv4sigmalapl2tau4;

  tv4sigmalapl2tau5 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 5] += tv4sigmalapl2tau5;

  tv4sigmalapl2tau6 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 6] += tv4sigmalapl2tau6;

  tv4sigmalapl2tau7 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 7] += tv4sigmalapl2tau7;

  tv4sigmalapl2tau8 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 8] += tv4sigmalapl2tau8;

  tv4sigmalapl2tau9 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 9] += tv4sigmalapl2tau9;

  tv4sigmalapl2tau10 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 10] += tv4sigmalapl2tau10;

  tv4sigmalapl2tau11 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 11] += tv4sigmalapl2tau11;

  tv4sigmalapl2tau12 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 12] += tv4sigmalapl2tau12;

  tv4sigmalapl2tau13 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 13] += tv4sigmalapl2tau13;

  tv4sigmalapl2tau14 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 14] += tv4sigmalapl2tau14;

  tv4sigmalapl2tau15 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 15] += tv4sigmalapl2tau15;

  tv4sigmalapl2tau16 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 16] += tv4sigmalapl2tau16;

  tv4sigmalapl2tau17 = 0.e0;

  if(out->v4sigmalapl2tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapl2tau[ip*p->dim.v4sigmalapl2tau + 17] += tv4sigmalapl2tau17;

  tv4sigmalapltau20 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 0] += tv4sigmalapltau20;

  tv4sigmalapltau21 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 1] += tv4sigmalapltau21;

  tv4sigmalapltau22 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 2] += tv4sigmalapltau22;

  tv4sigmalapltau23 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 3] += tv4sigmalapltau23;

  tv4sigmalapltau24 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 4] += tv4sigmalapltau24;

  tv4sigmalapltau25 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 5] += tv4sigmalapltau25;

  tv4sigmalapltau26 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 6] += tv4sigmalapltau26;

  tv4sigmalapltau27 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 7] += tv4sigmalapltau27;

  tv4sigmalapltau28 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 8] += tv4sigmalapltau28;

  tv4sigmalapltau29 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 9] += tv4sigmalapltau29;

  tv4sigmalapltau210 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 10] += tv4sigmalapltau210;

  tv4sigmalapltau211 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 11] += tv4sigmalapltau211;

  tv4sigmalapltau212 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 12] += tv4sigmalapltau212;

  tv4sigmalapltau213 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 13] += tv4sigmalapltau213;

  tv4sigmalapltau214 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 14] += tv4sigmalapltau214;

  tv4sigmalapltau215 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 15] += tv4sigmalapltau215;

  tv4sigmalapltau216 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 16] += tv4sigmalapltau216;

  tv4sigmalapltau217 = 0.e0;

  if(out->v4sigmalapltau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmalapltau2[ip*p->dim.v4sigmalapltau2 + 17] += tv4sigmalapltau217;

  t12748 = -0.135e3 / 0.32e2 * t3700 * t11002 - 0.675e3 / 0.32e2 * t4649 * t12187 + 0.225e3 / 0.4e1 * t4843 * t11924 + 0.45e2 / 0.256e3 * t506 * t11536 + 0.567e3 / 0.64e2 * t5039 * t4846 * t515 + 0.675e3 / 0.128e3 * t12448 * t4658 - 0.675e3 / 0.16e2 * t10424 * t4661 - 0.1125e4 / 0.16e2 * t11934 / t54 / t837 * t46 * t11939;
  t12775 = -0.73e2 / 0.972e5 * t12748 * t98 + 0.292e3 / 0.2025e4 * t82 * t12748 + 0.292e3 / 0.2025e4 * t520 * t4853 + 0.292e3 / 0.675e3 * t654 * t4664 + 0.292e3 / 0.675e3 * t1716 * t1844 - 0.17739e5 / 0.1e3 * t2687 * t4868 + 0.73e2 / 0.5e2 * t1192 * t4871 + t4836 * t503 / 0.24e2 - t538 * t4817 / 0.15e2 + 0.5913e4 / 0.1e3 * t8604 * t1852 - 0.219e3 / 0.2e3 * t3735 * t1855 + 0.478953e6 / 0.5e2 * t6237 * t4865 + 0.73e2 / 0.2e3 * t11132 * t659;
  t12825 = 0.73e2 / 0.25e2 * t315 * t525 * t633 + (-0.3e1 / 0.4e1 * t490 * t4818 + 0.27e2 / 0.128e3 * t493 * t4822 - 0.207e3 / 0.16384e5 * t1144 * t4826 + 0.69e2 / 0.262144e6 * t2671 * t4832 - 0.15e2 / 0.8388608e7 * t6187 * t852 * t11610 * t5148) * t46 * t57 / 0.24e2 - 0.219e3 / 0.1e3 * t1415 * t4691 + 0.1436859e7 / 0.25e2 * t2090 * t1143 * t758 * t3011 - 0.17739e5 / 0.25e2 * t830 * t4682 * t1381 + 0.73e2 / 0.1e3 * t4075 * t1728 + 0.5913e4 / 0.25e2 * t3068 * t4683 - 0.17739e5 / 0.2e3 * t11635 * t4679 + 0.219e3 / 0.4e3 * t4080 * t4688 - 0.478953e6 / 0.2e2 * t11625 * t4825 * t531 + 0.53217e5 / 0.2e3 * t4087 * t4821 * t531 - 0.73e2 / 0.1e3 * t1420 * t4817 * t531 - 0.73e2 / 0.4e3 * t11632 * t1725 - 0.73e2 / 0.1944e6 * t11641 * t531;
  t12866 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t27 * (t12775 + t12825) * t666 + t6 * t28 * t4876 * t1742 / 0.32e2 - 0.3e1 / 0.8e1 * t1237 * t11654 * t553 + 0.9e1 / 0.8e1 * t1237 * t4696 * t864 * t4883 - 0.3e1 / 0.16e2 * t258 * t1861 * t2130 * t4883 * t549 + 0.9e1 / 0.8e1 * t1237 * t4881 * t4708 + 0.9e1 / 0.8e1 * t4702 * t4122 * t4716 - 0.9e1 / 0.8e1 * t1237 * t11681 * t4893 * t1733 + 0.3e1 / 0.32e2 * t11690 * t11691 * t518 - 0.3e1 / 0.8e1 * t1237 * t4890 * t4892 * t552 * t130);
  tv4sigmatau30 = t7 * t12866;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 0] += tv4sigmatau30;

  tv4sigmatau31 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 1] += tv4sigmatau31;

  tv4sigmatau32 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 2] += tv4sigmatau32;

  tv4sigmatau33 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 3] += tv4sigmatau33;

  tv4sigmatau34 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 4] += tv4sigmatau34;

  tv4sigmatau35 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 5] += tv4sigmatau35;

  tv4sigmatau36 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 6] += tv4sigmatau36;

  tv4sigmatau37 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 7] += tv4sigmatau37;

  tv4sigmatau38 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 8] += tv4sigmatau38;

  tv4sigmatau39 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 9] += tv4sigmatau39;

  tv4sigmatau310 = 0.e0;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 10] += tv4sigmatau310;

  t12900 = -t606 * t4899 / 0.15e2 - 0.219e3 / 0.1e3 * t1507 * t4786 + 0.1436859e7 / 0.25e2 * t2498 * t1264 * t1007 * t3247 + 0.73e2 / 0.1e3 * t4218 * t1791 + 0.5913e4 / 0.25e2 * t3304 * t4778 - 0.17739e5 / 0.25e2 * t1079 * t4777 * t1473 + 0.73e2 / 0.25e2 * t449 * t593 * t678 - 0.478953e6 / 0.2e2 * t11838 * t4907 * t599 - 0.17739e5 / 0.2e3 * t11833 * t4774 + 0.219e3 / 0.4e3 * t4223 * t4783 + 0.53217e5 / 0.2e3 * t4230 * t4903 * t599 - 0.73e2 / 0.1e3 * t1512 * t4899 * t599 - 0.73e2 / 0.4e3 * t11842 * t1788;
  t12934 = -0.135e3 / 0.32e2 * t3891 * t11416 - 0.675e3 / 0.32e2 * t4744 * t12319 + 0.225e3 / 0.4e1 * t4925 * t12027 + 0.45e2 / 0.256e3 * t574 * t11739 + 0.567e3 / 0.64e2 * t5872 * t4928 * t583 + 0.675e3 / 0.128e3 * t12572 * t4753 - 0.675e3 / 0.16e2 * t10763 * t4756 - 0.1125e4 / 0.16e2 * t12036 / t168 / t1086 * t46 * t11939;
  t12965 = -0.73e2 / 0.1944e6 * t11824 * t599 - 0.17739e5 / 0.1e3 * t2896 * t4950 + 0.73e2 / 0.5e2 * t1313 * t4953 - 0.219e3 / 0.2e3 * t3926 * t1914 + 0.478953e6 / 0.5e2 * t6571 * t4947 + t4918 * t571 / 0.24e2 - 0.73e2 / 0.972e5 * t12934 * t207 + (-0.3e1 / 0.4e1 * t558 * t4900 + 0.27e2 / 0.128e3 * t561 * t4904 - 0.207e3 / 0.16384e5 * t1265 * t4908 + 0.69e2 / 0.262144e6 * t2873 * t4914 - 0.15e2 / 0.8388608e7 * t6660 * t1101 * t11815 * t5829) * t46 * t171 / 0.24e2 + 0.73e2 / 0.2e3 * t11465 * t704 + 0.5913e4 / 0.1e3 * t8978 * t1911 + 0.292e3 / 0.675e3 * t1779 * t1903 + 0.292e3 / 0.675e3 * t699 * t4759 + 0.292e3 / 0.2025e4 * t588 * t4935 + 0.292e3 / 0.2025e4 * t195 * t12934;
  t13006 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t27 * (t12900 + t12965) * t711 + t6 * t147 * t4958 * t1805 / 0.32e2 - 0.3e1 / 0.8e1 * t1358 * t11857 * t621 + 0.9e1 / 0.8e1 * t1358 * t4791 * t1113 * t4965 - 0.3e1 / 0.16e2 * t393 * t1920 * t2538 * t4965 * t617 + 0.9e1 / 0.8e1 * t1358 * t4963 * t4803 + 0.9e1 / 0.8e1 * t4797 * t4263 * t4811 - 0.9e1 / 0.8e1 * t1358 * t11880 * t4973 * t1796 + 0.3e1 / 0.32e2 * t11889 * t11890 * t586 - 0.3e1 / 0.8e1 * t1358 * t4972 * t4892 * t620 * t232);
  tv4sigmatau311 = t7 * t13006;

  if(out->v4sigmatau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4sigmatau3[ip*p->dim.v4sigmatau3 + 11] += tv4sigmatau311;

  tv4lapl40 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 0] += tv4lapl40;

  tv4lapl41 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 1] += tv4lapl41;

  tv4lapl42 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 2] += tv4lapl42;

  tv4lapl43 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 3] += tv4lapl43;

  tv4lapl44 = 0.e0;

  if(out->v4lapl4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl4[ip*p->dim.v4lapl4 + 4] += tv4lapl44;

  tv4lapl3tau0 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 0] += tv4lapl3tau0;

  tv4lapl3tau1 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 1] += tv4lapl3tau1;

  tv4lapl3tau2 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 2] += tv4lapl3tau2;

  tv4lapl3tau3 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 3] += tv4lapl3tau3;

  tv4lapl3tau4 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 4] += tv4lapl3tau4;

  tv4lapl3tau5 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 5] += tv4lapl3tau5;

  tv4lapl3tau6 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 6] += tv4lapl3tau6;

  tv4lapl3tau7 = 0.e0;

  if(out->v4lapl3tau != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl3tau[ip*p->dim.v4lapl3tau + 7] += tv4lapl3tau7;

  tv4lapl2tau20 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 0] += tv4lapl2tau20;

  tv4lapl2tau21 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 1] += tv4lapl2tau21;

  tv4lapl2tau22 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 2] += tv4lapl2tau22;

  tv4lapl2tau23 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 3] += tv4lapl2tau23;

  tv4lapl2tau24 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 4] += tv4lapl2tau24;

  tv4lapl2tau25 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 5] += tv4lapl2tau25;

  tv4lapl2tau26 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 6] += tv4lapl2tau26;

  tv4lapl2tau27 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 7] += tv4lapl2tau27;

  tv4lapl2tau28 = 0.e0;

  if(out->v4lapl2tau2 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapl2tau2[ip*p->dim.v4lapl2tau2 + 8] += tv4lapl2tau28;

  tv4lapltau30 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 0] += tv4lapltau30;

  tv4lapltau31 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 1] += tv4lapltau31;

  tv4lapltau32 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 2] += tv4lapltau32;

  tv4lapltau33 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 3] += tv4lapltau33;

  tv4lapltau34 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 4] += tv4lapltau34;

  tv4lapltau35 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 5] += tv4lapltau35;

  tv4lapltau36 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 6] += tv4lapltau36;

  tv4lapltau37 = 0.e0;

  if(out->v4lapltau3 != NULL && (p->info->flags & XC_FLAGS_NEEDS_LAPLACIAN) && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4lapltau3[ip*p->dim.v4lapltau3 + 7] += tv4lapltau37;

  t13007 = t32 * t766;
  t13045 = t1844 * t1844;
  t13053 = t1835 * t1835;
  t13062 = -0.45e2 / 0.8e1 * t642 * t11536 + 0.225e3 * t4843 * t12187 + 0.567e3 / 0.64e2 * t5039 * t13053 - 0.675e3 / 0.8e1 * t12448 * t4850 + 0.1125e4 / 0.2e1 * t11934 * t5012 * t46 * t11939;
  t13082 = t108 * t13007 / 0.6e1 + 0.957906e6 / 0.25e2 * t6993 * t4865 + 0.38795193e8 / 0.5e1 * t5120 * t2009 * t117 * t9391 + (0.15e2 / 0.8e1 * t30 * t13007 * t41 - 0.45e2 / 0.128e3 * t267 * t494 * t1822 * t273 + 0.549e3 / 0.32768e5 * t764 * t758 * t4034 * t769 - 0.39e2 / 0.131072e6 * t2010 * t117 * t9391 * t2015 + 0.15e2 / 0.8388608e7 * t5143 * t852 / t1821 / t765 * t5148) * t46 * t57 / 0.24e2 + 0.73e2 / 0.15e3 * t11641 * t659 + 0.5913e4 / 0.5e2 * t9288 * t1852 + 0.292e3 / 0.675e3 * t13045 + 0.1168e4 / 0.2025e4 * t654 * t4853 + 0.292e3 / 0.2025e4 * t82 * t13062 - 0.73e2 / 0.972e5 * t13062 * t98 + 0.146e3 / 0.25e2 * t1415 * t4871 - 0.4310577e7 / 0.25e2 * t2090 * t4864 * t4034 + 0.5913e4 / 0.4e1 * t830 * t1851 * t1822 - 0.73e2 / 0.1e2 * t315 * t36 * t766 - 0.219e3 / 0.1e3 * t4075 * t1855 - 0.17739e5 / 0.25e2 * t3068 * t4868;
  t13091 = t1860 * t1860;
  t13102 = t1864 * t1864;
  t13103 = t863 * t863;
  t13107 = 0.1e1 / t4891 / params->kappa;
  t13113 = my_piecewise3(t2, 0, -0.3e1 / 0.8e1 * t258 * t27 * t13082 * t666 + 0.3e1 / 0.2e1 * t1237 * t4876 * t864 * t4883 + 0.9e1 / 0.8e1 * t1237 * t13091 * t864 * t1866 - 0.9e1 / 0.4e1 * t1237 * t1860 * t4889 * t1864 * t4892 * t130 + 0.3e1 / 0.8e1 * t1237 * t13102 / t13103 * t13107 * t130);
  tv4tau40 = t7 * t13113;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 0] += tv4tau40;

  tv4tau41 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 1] += tv4tau41;

  tv4tau42 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 2] += tv4tau42;

  tv4tau43 = 0.e0;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 3] += tv4tau43;

  t13114 = t151 * t1015;
  t13152 = t1903 * t1903;
  t13160 = t1894 * t1894;
  t13169 = -0.45e2 / 0.8e1 * t687 * t11739 + 0.225e3 * t4925 * t12319 + 0.567e3 / 0.64e2 * t5872 * t13160 - 0.675e3 / 0.8e1 * t12572 * t4932 + 0.1125e4 / 0.2e1 * t12036 * t5845 * t46 * t11939;
  t13189 = t214 * t13114 / 0.6e1 + 0.73e2 / 0.15e3 * t11824 * t704 + 0.5913e4 / 0.5e2 * t9635 * t1911 + 0.957906e6 / 0.25e2 * t7501 * t4947 + 0.38795193e8 / 0.5e1 * t5782 * t2417 * t220 * t9660 + (0.15e2 / 0.8e1 * t149 * t13114 * t160 - 0.45e2 / 0.128e3 * t401 * t562 * t1881 * t407 + 0.549e3 / 0.32768e5 * t1013 * t1007 * t4177 * t1018 - 0.39e2 / 0.131072e6 * t2418 * t220 * t9660 * t2423 + 0.15e2 / 0.8388608e7 * t5824 * t1101 / t1880 / t1014 * t5829) * t46 * t171 / 0.24e2 + 0.292e3 / 0.675e3 * t13152 + 0.1168e4 / 0.2025e4 * t699 * t4935 + 0.292e3 / 0.2025e4 * t195 * t13169 - 0.73e2 / 0.972e5 * t13169 * t207 - 0.219e3 / 0.1e3 * t4218 * t1914 - 0.17739e5 / 0.25e2 * t3304 * t4950 + 0.146e3 / 0.25e2 * t1507 * t4953 - 0.4310577e7 / 0.25e2 * t2498 * t4946 * t4177 + 0.5913e4 / 0.4e1 * t1079 * t1910 * t1881 - 0.73e2 / 0.1e2 * t449 * t155 * t1015;
  t13198 = t1919 * t1919;
  t13209 = t1923 * t1923;
  t13210 = t1112 * t1112;
  t13218 = my_piecewise3(t138, 0, -0.3e1 / 0.8e1 * t393 * t27 * t13189 * t711 + 0.3e1 / 0.2e1 * t1358 * t4958 * t1113 * t4965 + 0.9e1 / 0.8e1 * t1358 * t13198 * t1113 * t1925 - 0.9e1 / 0.4e1 * t1358 * t1919 * t4971 * t1923 * t4892 * t232 + 0.3e1 / 0.8e1 * t1358 * t13209 / t13210 * t13107 * t232);
  tv4tau44 = t7 * t13218;

  if(out->v4tau4 != NULL && (p->info->flags & XC_FLAGS_NEEDS_TAU) && (p->info->flags & XC_FLAGS_HAVE_LXC))
    out->v4tau4[ip*p->dim.v4tau4 + 4] += tv4tau44;

}

#endif

