"""Initial schema

Revision ID: cef02a8b1451
Revises:
Create Date: 2025-08-28 12:48:16.890606

"""

from collections.abc import Sequence

import sqlalchemy as sa
from alembic import op

import slidge

# revision identifiers, used by Alembic.
revision: str = "cef02a8b1451"
down_revision: str | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "avatar",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("hash", sa.String(), nullable=False),
        sa.Column("height", sa.Integer(), nullable=False),
        sa.Column("width", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=True),
        sa.Column("etag", sa.String(), nullable=True),
        sa.Column("last_modified", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_avatar")),
        sa.UniqueConstraint("hash", name=op.f("uq_avatar_hash")),
        sa.UniqueConstraint("legacy_id", name=op.f("uq_avatar_legacy_id")),
    )
    op.create_table(
        "bob",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("file_name", sa.String(), nullable=False),
        sa.Column("sha_1", sa.String(), nullable=False),
        sa.Column("sha_256", sa.String(), nullable=False),
        sa.Column("sha_512", sa.String(), nullable=False),
        sa.Column("content_type", sa.String(), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_bob")),
        sa.UniqueConstraint("sha_1", name=op.f("uq_bob_sha_1")),
        sa.UniqueConstraint("sha_256", name=op.f("uq_bob_sha_256")),
        sa.UniqueConstraint("sha_512", name=op.f("uq_bob_sha_512")),
    )
    op.create_table(
        "user_account",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("jid", slidge.db.meta.JIDType(), nullable=False),
        sa.Column(
            "registration_date",
            sa.DateTime(),
            server_default=sa.text("(CURRENT_TIMESTAMP)"),
            nullable=False,
        ),
        sa.Column(
            "legacy_module_data", slidge.db.meta.JSONEncodedDict(), nullable=False
        ),
        sa.Column("preferences", slidge.db.meta.JSONEncodedDict(), nullable=False),
        sa.Column("avatar_hash", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_user_account")),
        sa.UniqueConstraint("jid", name=op.f("uq_user_account_jid")),
    )
    op.create_table(
        "attachment",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_account_id", sa.Integer(), nullable=False),
        sa.Column("legacy_file_id", sa.String(), nullable=True),
        sa.Column("url", sa.String(), nullable=False),
        sa.Column("sims", sa.String(), nullable=True),
        sa.Column("sfs", sa.String(), nullable=True),
        sa.ForeignKeyConstraint(
            ["user_account_id"],
            ["user_account.id"],
            name=op.f("fk_attachment_user_account_id_user_account"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_attachment")),
        sa.UniqueConstraint(
            "user_account_id",
            "legacy_file_id",
            name="uq_attachment_user_account_id_legacy_file_id",
        ),
    )
    with op.batch_alter_table("attachment", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_attachment_legacy_file_id"), ["legacy_file_id"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_attachment_url"), ["url"], unique=False)

    op.create_table(
        "contact",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_account_id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("jid", slidge.db.meta.JIDType(), nullable=False),
        sa.Column("avatar_id", sa.Integer(), nullable=True),
        sa.Column("nick", sa.String(), nullable=True),
        sa.Column("cached_presence", sa.Boolean(), nullable=False),
        sa.Column("last_seen", sa.DateTime(), nullable=True),
        sa.Column("ptype", sa.String(), nullable=True),
        sa.Column("pstatus", sa.String(), nullable=True),
        sa.Column("pshow", sa.String(), nullable=True),
        sa.Column("caps_ver", sa.String(), nullable=True),
        sa.Column("is_friend", sa.Boolean(), nullable=False),
        sa.Column("added_to_roster", sa.Boolean(), nullable=False),
        sa.Column("extra_attributes", slidge.db.meta.JSONEncodedDict(), nullable=True),
        sa.Column("updated", sa.Boolean(), nullable=False),
        sa.Column("vcard", sa.String(), nullable=True),
        sa.Column("vcard_fetched", sa.Boolean(), nullable=False),
        sa.Column(
            "client_type",
            sa.Enum(
                "bot",
                "console",
                "game",
                "handheld",
                "pc",
                "phone",
                "sms",
                "tablet",
                "web",
                native_enum=False,
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["avatar_id"], ["avatar.id"], name=op.f("fk_contact_avatar_id_avatar")
        ),
        sa.ForeignKeyConstraint(
            ["user_account_id"],
            ["user_account.id"],
            name=op.f("fk_contact_user_account_id_user_account"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_contact")),
        sa.UniqueConstraint(
            "user_account_id", "jid", name="uq_contact_user_account_id_jid"
        ),
        sa.UniqueConstraint(
            "user_account_id", "legacy_id", name="uq_contact_user_account_id_legacy_id"
        ),
    )
    op.create_table(
        "room",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("user_account_id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("jid", slidge.db.meta.JIDType(), nullable=False),
        sa.Column("avatar_id", sa.Integer(), nullable=True),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("subject", sa.String(), nullable=True),
        sa.Column("subject_date", sa.DateTime(), nullable=True),
        sa.Column("subject_setter", sa.String(), nullable=True),
        sa.Column("n_participants", sa.Integer(), nullable=True),
        sa.Column(
            "muc_type",
            sa.Enum("GROUP", "CHANNEL", "CHANNEL_NON_ANONYMOUS", name="muctype"),
            nullable=False,
        ),
        sa.Column("user_nick", sa.String(), nullable=True),
        sa.Column("user_resources", sa.String(), nullable=True),
        sa.Column("participants_filled", sa.Boolean(), nullable=False),
        sa.Column("history_filled", sa.Boolean(), nullable=False),
        sa.Column("extra_attributes", slidge.db.meta.JSONEncodedDict(), nullable=True),
        sa.Column("updated", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(
            ["avatar_id"], ["avatar.id"], name=op.f("fk_room_avatar_id_avatar")
        ),
        sa.ForeignKeyConstraint(
            ["user_account_id"],
            ["user_account.id"],
            name=op.f("fk_room_user_account_id_user_account"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_room")),
        sa.UniqueConstraint(
            "user_account_id", "jid", name="uq_room_user_account_id_jid"
        ),
        sa.UniqueConstraint(
            "user_account_id", "legacy_id", name="uq_room_user_account_id_legacy_id"
        ),
    )
    op.create_table(
        "contact_sent",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=False),
        sa.Column("msg_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
            name=op.f("fk_contact_sent_contact_id_contact"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_contact_sent")),
        sa.UniqueConstraint(
            "contact_id", "msg_id", name="uq_contact_sent_contact_id_msg_id"
        ),
    )
    op.create_table(
        "direct_msg",
        sa.Column("foreign_key", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("xmpp_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["foreign_key"],
            ["contact.id"],
            name=op.f("fk_direct_msg_foreign_key_contact"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_direct_msg")),
    )
    with op.batch_alter_table("direct_msg", schema=None) as batch_op:
        batch_op.create_index(
            "ix_direct_msg_legacy_id", ["legacy_id", "foreign_key"], unique=False
        )

    op.create_table(
        "direct_thread",
        sa.Column("foreign_key", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("xmpp_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["foreign_key"],
            ["contact.id"],
            name=op.f("fk_direct_thread_foreign_key_contact"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_direct_thread")),
    )
    with op.batch_alter_table("direct_thread", schema=None) as batch_op:
        batch_op.create_index(
            "ix_direct_direct_thread_id", ["legacy_id", "foreign_key"], unique=False
        )

    op.create_table(
        "group_msg",
        sa.Column("foreign_key", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("xmpp_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["foreign_key"], ["room.id"], name=op.f("fk_group_msg_foreign_key_room")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_group_msg")),
    )
    with op.batch_alter_table("group_msg", schema=None) as batch_op:
        batch_op.create_index(
            "ix_group_msg_legacy_id", ["legacy_id", "foreign_key"], unique=False
        )

    op.create_table(
        "group_thread",
        sa.Column("foreign_key", sa.Integer(), nullable=False),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("legacy_id", sa.String(), nullable=False),
        sa.Column("xmpp_id", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["foreign_key"], ["room.id"], name=op.f("fk_group_thread_foreign_key_room")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_group_thread")),
    )
    with op.batch_alter_table("group_thread", schema=None) as batch_op:
        batch_op.create_index(
            "ix_direct_group_thread_id", ["legacy_id", "foreign_key"], unique=False
        )

    op.create_table(
        "mam",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("room_id", sa.Integer(), nullable=False),
        sa.Column("stanza_id", sa.String(), nullable=False),
        sa.Column("timestamp", sa.DateTime(), nullable=False),
        sa.Column("author_jid", slidge.db.meta.JIDType(), nullable=False),
        sa.Column(
            "source",
            sa.Enum("LIVE", "BACKFILL", name="archivedmessagesource"),
            nullable=False,
        ),
        sa.Column("legacy_id", sa.String(), nullable=True),
        sa.Column("stanza", sa.String(), nullable=False),
        sa.ForeignKeyConstraint(
            ["room_id"], ["room.id"], name=op.f("fk_mam_room_id_room")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_mam")),
        sa.UniqueConstraint("room_id", "stanza_id", name="uq_mam_room_id_stanza_id"),
    )
    op.create_table(
        "participant",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("room_id", sa.Integer(), nullable=False),
        sa.Column("contact_id", sa.Integer(), nullable=True),
        sa.Column("is_user", sa.Boolean(), nullable=False),
        sa.Column(
            "affiliation",
            sa.Enum("outcast", "member", "admin", "owner", "none", native_enum=False),
            nullable=False,
        ),
        sa.Column(
            "role",
            sa.Enum("moderator", "participant", "visitor", "none", native_enum=False),
            nullable=False,
        ),
        sa.Column("presence_sent", sa.Boolean(), nullable=False),
        sa.Column("resource", sa.String(), nullable=False),
        sa.Column("nickname", sa.String(), nullable=False),
        sa.Column("nickname_no_illegal", sa.String(), nullable=False),
        sa.Column("hats", sa.JSON(), nullable=False),
        sa.Column("extra_attributes", slidge.db.meta.JSONEncodedDict(), nullable=True),
        sa.ForeignKeyConstraint(
            ["contact_id"],
            ["contact.id"],
            name=op.f("fk_participant_contact_id_contact"),
        ),
        sa.ForeignKeyConstraint(
            ["room_id"], ["room.id"], name=op.f("fk_participant_room_id_room")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_participant")),
        sa.UniqueConstraint(
            "room_id", "contact_id", name="uq_participant_room_id_contact_id"
        ),
        sa.UniqueConstraint(
            "room_id", "resource", name="uq_participant_room_id_resource"
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("participant")
    op.drop_table("mam")
    with op.batch_alter_table("group_thread", schema=None) as batch_op:
        batch_op.drop_index("ix_direct_group_thread_id")

    op.drop_table("group_thread")
    with op.batch_alter_table("group_msg", schema=None) as batch_op:
        batch_op.drop_index("ix_group_msg_legacy_id")

    op.drop_table("group_msg")
    with op.batch_alter_table("direct_thread", schema=None) as batch_op:
        batch_op.drop_index("ix_direct_direct_thread_id")

    op.drop_table("direct_thread")
    with op.batch_alter_table("direct_msg", schema=None) as batch_op:
        batch_op.drop_index("ix_direct_msg_legacy_id")

    op.drop_table("direct_msg")
    op.drop_table("contact_sent")
    op.drop_table("room")
    op.drop_table("contact")
    with op.batch_alter_table("attachment", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_attachment_url"))
        batch_op.drop_index(batch_op.f("ix_attachment_legacy_file_id"))

    op.drop_table("attachment")
    op.drop_table("user_account")
    op.drop_table("bob")
    op.drop_table("avatar")
    # ### end Alembic commands ###
