/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (tcpprep_opts.h)
 *
 *  It has been AutoGen-ed
 *  From the definitions    ../../src/tcpprep_opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:1:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the tcpprep author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The tcpprep program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2025 Aaron Turner and Fred Klassen, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  tcpprep is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  tcpprep is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the tcpprep program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_TCPPREP_OPTS_H_GUARD
#define AUTOOPTS_TCPPREP_OPTS_H_GUARD 1
#include "config.h"
#include <autoopts/options.h>
#include <stdarg.h>
#include <stdnoreturn.h>

/**
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 172033
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

#if GCC_VERSION > 40400
#define NOT_REACHED __builtin_unreachable();
#else
#define NOT_REACHED
#endif

/**
 *  Enumeration of each option type for tcpprep
 */
typedef enum {
    INDEX_OPT_DBUG               =  0,
    INDEX_OPT_AUTO               =  1,
    INDEX_OPT_CIDR               =  2,
    INDEX_OPT_REGEX              =  3,
    INDEX_OPT_PORT               =  4,
    INDEX_OPT_MAC                =  5,
    INDEX_OPT_REVERSE            =  6,
    INDEX_OPT_COMMENT            =  7,
    INDEX_OPT_NO_ARG_COMMENT     =  8,
    INDEX_OPT_INCLUDE            =  9,
    INDEX_OPT_EXCLUDE            = 10,
    INDEX_OPT_CACHEFILE          = 11,
    INDEX_OPT_PCAP               = 12,
    INDEX_OPT_PRINT_COMMENT      = 13,
    INDEX_OPT_PRINT_INFO         = 14,
    INDEX_OPT_PRINT_STATS        = 15,
    INDEX_OPT_SERVICES           = 16,
    INDEX_OPT_NONIP              = 17,
    INDEX_OPT_RATIO              = 18,
    INDEX_OPT_MINMASK            = 19,
    INDEX_OPT_MAXMASK            = 20,
    INDEX_OPT_VERBOSE            = 21,
    INDEX_OPT_DECODE             = 22,
    INDEX_OPT_VERSION            = 23,
    INDEX_OPT_LESS_HELP          = 24,
    INDEX_OPT_SUPPRESS_WARNINGS  = 25,
    INDEX_OPT_HELP               = 26,
    INDEX_OPT_MORE_HELP          = 27,
    INDEX_OPT_SAVE_OPTS          = 28,
    INDEX_OPT_LOAD_OPTS          = 29
} teOptIndex;
/** count of all options for tcpprep */
#define OPTION_CT    30

/**
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(DBUG)
 */
#define         DESC(n) (tcpprepOptions.pOptDesc[INDEX_OPT_## n])
/** 'true' if an option has been specified in any way */
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
/** The string argument to an option. The argument type must be \"string\". */
#define      OPT_ARG(n) (DESC(n).optArg.argString)
/** Mask the option state revealing how an option was specified.
 *  It will be one and only one of \a OPTST_SET, \a OPTST_PRESET,
 * \a OPTST_DEFINED, \a OPTST_RESET or zero.
 */
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
/** Count of option's occurrances *on the command line*. */
#define    COUNT_OPT(n) (DESC(n).optOccCt)
/** mask of \a OPTST_SET and \a OPTST_DEFINED. */
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
/** 'true' if \a HAVE_OPT would yield 'false'. */
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
/** 'true' if OPTST_DISABLED bit not set. */
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
/** number of stacked option arguments.
 *  Valid only for stacked option arguments. */
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
/** stacked argument vector.
 *  Valid only for stacked option arguments. */
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
/** Reset an option. */
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Enumeration of tcpprep exit codes
 */
typedef enum {
    TCPPREP_EXIT_SUCCESS         = 0,
    TCPPREP_EXIT_FAILURE         = 1,
    TCPPREP_EXIT_USAGE_ERROR     = 64,
    TCPPREP_EXIT_NO_CONFIG_INPUT = 66,
    TCPPREP_EXIT_LIBOPTS_FAILURE = 70
}   tcpprep_exit_code_t;
/**
 *  Interface defines for specific options.
 * @{
 */
#define VALUE_OPT_DBUG           'd'
#ifdef DEBUG
#define OPT_VALUE_DBUG           (DESC(DBUG).optArg.argInt)
#endif /* DEBUG */
#define VALUE_OPT_AUTO           'a'
#define VALUE_OPT_CIDR           'c'
#define VALUE_OPT_REGEX          'r'
#define VALUE_OPT_PORT           'p'
#define VALUE_OPT_MAC            'e'
#define VALUE_OPT_REVERSE        0x1001
#define VALUE_OPT_COMMENT        'C'
#define VALUE_OPT_NO_ARG_COMMENT 0x1002
#define VALUE_OPT_INCLUDE        'x'
#define VALUE_OPT_EXCLUDE        'X'
#define VALUE_OPT_CACHEFILE      'o'
#define VALUE_OPT_PCAP           'i'
#define VALUE_OPT_PRINT_COMMENT  'P'
#define VALUE_OPT_PRINT_INFO     'I'
#define VALUE_OPT_PRINT_STATS    'S'
#define VALUE_OPT_SERVICES       's'
#define VALUE_OPT_NONIP          'N'
#define VALUE_OPT_RATIO          'R'
#define VALUE_OPT_MINMASK        'm'

#define OPT_VALUE_MINMASK        (DESC(MINMASK).optArg.argInt)
#define VALUE_OPT_MAXMASK        'M'

#define OPT_VALUE_MAXMASK        (DESC(MAXMASK).optArg.argInt)
#define VALUE_OPT_VERBOSE        'v'
#ifdef ENABLE_VERBOSE
#define SET_OPT_VERBOSE   STMTS( \
        DESC(VERBOSE).optActualIndex = 21; \
        DESC(VERBOSE).optActualValue = VALUE_OPT_VERBOSE; \
        DESC(VERBOSE).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(VERBOSE).fOptState |= OPTST_SET )
#endif /* ENABLE_VERBOSE */
#define VALUE_OPT_DECODE         'A'
#define VALUE_OPT_VERSION        'V'
#define VALUE_OPT_LESS_HELP      'h'
#define VALUE_OPT_SUPPRESS_WARNINGS 'w'

#define SET_OPT_SUPPRESS_WARNINGS   STMTS( \
        DESC(SUPPRESS_WARNINGS).optActualIndex = 25; \
        DESC(SUPPRESS_WARNINGS).optActualValue = VALUE_OPT_SUPPRESS_WARNINGS; \
        DESC(SUPPRESS_WARNINGS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SUPPRESS_WARNINGS).fOptState |= OPTST_SET )
/** option flag (value) for help-value option */
#define VALUE_OPT_HELP          'H'
/** option flag (value) for more-help-value option */
#define VALUE_OPT_MORE_HELP     '!'
/** option flag (value) for save-opts-value option */
#define VALUE_OPT_SAVE_OPTS     0x1003
/** option flag (value) for load-opts-value option */
#define VALUE_OPT_LOAD_OPTS     0x1004
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a))
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(tcpprepOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(tcpprepOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                tcpprepOptions.curOptIdx = (n); \
                tcpprepOptions.pzCurOpt  = NULL )
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*tcpprepOptions.pUsageProc)(&tcpprepOptions, c)

#ifdef  __cplusplus
extern "C" {
#endif


/* * * * * *
 *
 *  Declare the tcpprep option descriptor.
 */
extern tOptions tcpprepOptions;

#if defined(ENABLE_NLS)
# ifndef _
#   include <stdio.h>
#   ifndef HAVE_GETTEXT
      extern char * gettext(char const *);
#   else
#     include <libintl.h>
#   endif

# ifndef ATTRIBUTE_FORMAT_ARG
#   define ATTRIBUTE_FORMAT_ARG(_a)
# endif

static inline char* aoGetsText(char const* pz) ATTRIBUTE_FORMAT_ARG(1);
static inline char* aoGetsText(char const* pz) {
    if (pz == NULL) return NULL;
    return (char*)gettext(pz);
}
#   define _(s)  aoGetsText(s)
# endif /* _() */

# define OPT_NO_XLAT_CFG_NAMES  STMTS(tcpprepOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT_CFG;)
# define OPT_NO_XLAT_OPT_NAMES  STMTS(tcpprepOptions.fOptSet |= \
                                    OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG;)

# define OPT_XLAT_CFG_NAMES     STMTS(tcpprepOptions.fOptSet &= \
                                  ~(OPTPROC_NXLAT_OPT|OPTPROC_NXLAT_OPT_CFG);)
# define OPT_XLAT_OPT_NAMES     STMTS(tcpprepOptions.fOptSet &= \
                                  ~OPTPROC_NXLAT_OPT;)

#else   /* ENABLE_NLS */
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif
#endif  /* ENABLE_NLS */


#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_TCPPREP_OPTS_H_GUARD */

/* tcpprep_opts.h ends here */
