## TFSA-2021-001: Heap buffer overflow in `RaggedBinCount`

### CVE Number
CVE-2021-29512

### Impact
If the `splits` argument of `RaggedBincount` does not specify a valid
[`SparseTensor`](https://www.tensorflow.org/api_docs/python/tf/sparse/SparseTensor),
then an attacker can trigger a heap buffer overflow:

```python
import tensorflow as tf
tf.raw_ops.RaggedBincount(splits=[0], values=[1,1,1,1,1], size=5, weights=[1,2,3,4], binary_output=False)
```

This will cause a read from outside the bounds of the `splits` tensor buffer in
the [implementation of the `RaggedBincount`
op](https://github.com/tensorflow/tensorflow/blob/8b677d79167799f71c42fd3fa074476e0295413a/tensorflow/core/kernels/bincount_op.cc#L430-L433):

```cc
    for (int idx = 0; idx < num_values; ++idx) {
      while (idx >= splits(batch_idx)) {
        batch_idx++;
      }
      ...
    }
```

Before the `for` loop, `batch_idx` is set to 0. The user controls the `splits`
array, making it contain only one element, 0. Thus, the code in the `while` loop
would increment `batch_idx` and then try to read `splits(1)`, which is outside
of bounds.

### Patches
We have patched the issue in GitHub commit
[eebb96c2830d48597d055d247c0e9aebaea94cd5](https://github.com/tensorflow/tensorflow/commit/eebb96c2830d48597d055d247c0e9aebaea94cd5).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2 and TensorFlow 2.3.3, as these are also affected.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
