/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:30:46 GMT 2018
 */

package uk.ac.sanger.artemis.components.variant;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.util.regex.Pattern;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.variant.VCFRecord;
import uk.ac.sanger.artemis.components.variant.VariantBase;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class VariantBase_ESTest extends VariantBase_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "D");
      int int0 = variantBase0.getNumberOfIndels(false);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      doReturn("^[AGCTNMRWSYSBDHVagctnmrws,kbdhv]+,[ACTNMRWYKBDHVactnmwNykbdhv,]+$").when(vCFRecord0).getFormatValueForSample(anyString() , anyInt());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "^[AGCTNMRWSYSBDHVagctnmrws,kbdhv]+,[ACTNMRWYKBDHVactnmwNykbdhv,]+$");
      boolean boolean0 = variantBase0.isMultiAllele(66);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef(" can't have ");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "PL");
      boolean boolean0 = variantBase0.isInsertion(true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("5-.N,l");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "Ei+}-MdA.kfJ&l");
      boolean boolean0 = variantBase0.isDeletion(true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "0");
      int int0 = variantBase0.getNumberOfIndels(false);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, (String) null);
      String string0 = variantBase0.toString();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "");
      String string0 = variantBase0.toString();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "\t");
      int int0 = variantBase0.length();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, ">");
      vCFRecord0.setRef("PL");
      int int0 = variantBase0.getNumberOfIndels(true);
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, (String) null);
      // Undeclared exception!
      try { 
        variantBase0.length();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      VariantBase variantBase0 = new VariantBase((VCFRecord) null, "Ile");
      // Undeclared exception!
      try { 
        variantBase0.isMultiAllele((-643));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      String[][] stringArray0 = new String[0][0];
      vCFRecord0.setGenoTypeData(stringArray0);
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "PL");
      vCFRecord0.setFormat("PL");
      // Undeclared exception!
      try { 
        variantBase0.isMultiAllele(0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, (String) null);
      // Undeclared exception!
      try { 
        variantBase0.getNumAlleles();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VCFRecord", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef(".");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, ".");
      boolean boolean0 = variantBase0.isNonVariant();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("GIA[i_/");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, ".");
      boolean boolean0 = variantBase0.isNonVariant();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      VariantBase variantBase0 = new VariantBase((VCFRecord) null, "X");
      // Undeclared exception!
      try { 
        variantBase0.isNonVariant();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "I^ %sBc-YX^xvbY");
      boolean boolean0 = variantBase0.isNonVariant();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "^[AGCTNMRWSYSBDHVagctnmrwsykbdhv+,[CTNMRWYKBDHVactrmwNykbdhv,]+$");
      int int0 = variantBase0.getNumberOfIndels(false);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, ".");
      // Undeclared exception!
      try { 
        variantBase0.getNumberOfIndels(true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      doReturn("YgGQ4-o>Mw").when(vCFRecord0).getFormatValueForSample(anyString() , anyInt());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "^[AGCTNMRWSYKBDHVagctnmrwsykbdhv]+,[AGCTNMRWSYKBDHVgctnmrsykbdhv,]+$");
      boolean boolean0 = variantBase0.isMultiAllele(574);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      doReturn("^[AGCTNMRWSYSBDHVagctnmrwsykbdhv+,[CTNMRWYKBDHVactrmwNykbdhv,]+$").when(vCFRecord0).getFormatValueForSample(anyString() , anyInt());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "^[AGCTNMRWSYSBDHVagctnmrwsykbdhv+,[CTNMRWYKBDHVactrmwNykbdhv,]+$");
      boolean boolean0 = variantBase0.isMultiAllele(0);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "I^ %sBc-YX^xvbY");
      boolean boolean0 = variantBase0.isMultiAllele((-1121));
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      Pattern pattern0 = Pattern.compile("", 0);
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "");
      VCFRecord.MULTI_ALLELE_PATTERN = pattern0;
      boolean boolean0 = variantBase0.isMultiAllele(0);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "I^ %sBc-YX^xvbY");
      boolean boolean0 = variantBase0.isInsertion(false);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "Ei+}-MdA.kfJ&l");
      boolean boolean0 = variantBase0.isInsertion(true);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("5-.N,l");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "Yt,Y/;40@x}nQ4wQ");
      boolean boolean0 = variantBase0.isInsertion(true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      vCFRecord0.setRef("]mhl*0Jk2\"");
      boolean boolean0 = variantBase0.isInsertion(true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      // Undeclared exception!
      try { 
        variantBase0.isInsertion(true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      boolean boolean0 = variantBase0.isInsertion(false);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      VariantBase variantBase0 = new VariantBase((VCFRecord) null, "D");
      boolean boolean0 = variantBase0.isDeletion(false);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      vCFRecord0.setRef("GIA[i_/");
      VariantBase variantBase0 = new VariantBase(vCFRecord0, ".");
      boolean boolean0 = variantBase0.isDeletion(true);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      vCFRecord0.setRef("]mhl*0Jk2\"");
      boolean boolean0 = variantBase0.isDeletion(true);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      // Undeclared exception!
      try { 
        variantBase0.isDeletion(true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.components.variant.VariantBase", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      boolean boolean0 = variantBase0.isDeletion(false);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "]mhl*0Jk2\"");
      int int0 = variantBase0.getNumAlleles();
      assertEquals(2, int0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      VCFRecord vCFRecord0 = mock(VCFRecord.class, new ViolatedAssumptionAnswer());
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "^[AGCTNMRWSYKBDHVagctnmrwsykbdhv]+,[AGCTNMRWSYKBDHVgctnmrsykbdhv,]+$");
      String string0 = variantBase0.toString();
      assertEquals("^[AGCTNMRWSYKBDHVagctnmrwsykbdhv]+,[AGCTNMRWSYKBDHVgctnmrsykbdhv,]+$", string0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      VCFRecord vCFRecord0 = new VCFRecord();
      VariantBase variantBase0 = new VariantBase(vCFRecord0, "");
      int int0 = variantBase0.length();
      assertEquals(0, int0);
  }
}
