/*
* This file is part of buteo-sync-plugins package
*
* Copyright (C) 2013 Jolla Ltd.
*
* Author: Sateesh Kavuri <sateesh.kavuri@gmail.com>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License
* version 2.1 as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA
*/
#include "PluginCbImpl.h"
#include "SyncPluginBase.h"
#include "StoragePlugin.h"
#include "SyncCommonDefs.h"
#include "Profile.h"
#include "LogMacros.h"

using namespace Buteo;

PluginCbImpl::PluginCbImpl()
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    imsyncIface = new SyncDaemonProxy("com.meego.msyncd",
                                      "/synchronizer",
                                      QDBusConnection::sessionBus());
}

PluginCbImpl::~PluginCbImpl()
{
    FUNCTION_CALL_TRACE(lcButeoTrace);
    delete imsyncIface;
    imsyncIface = 0;
}

bool PluginCbImpl::requestStorage(const QString &aStorageName,
                                  const SyncPluginBase */*aCaller*/)
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    bool requestResult = false;

    if (imsyncIface) {
        QStringList storages;
        storages << aStorageName;
        QDBusReply<bool> gotStorages = imsyncIface->requestStorages(storages);

        if (!gotStorages.isValid())
            qCWarning(lcButeoPlugin) << "Request for storage " << aStorageName << " failed";
        else
            requestResult = gotStorages.value();
    } else {
        qCWarning(lcButeoPlugin) << "msyncd dbus interface is NULL";
    }

    return requestResult;
}

void PluginCbImpl::releaseStorage(const QString &aStorageName,
                                  const SyncPluginBase */*aCaller*/)
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    if (imsyncIface) {
        QStringList storages;
        storages << aStorageName;
        imsyncIface->releaseStorages(storages);
    } else {
        qCWarning(lcButeoPlugin) << "msyncd dbus interface is NULL";
    }
}

StoragePlugin *PluginCbImpl::createStorage(const QString &aPluginName)
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    StoragePlugin *plugin = nullptr;
    if (!aPluginName.isEmpty()) {
        plugin = iPluginManager.createStorage(aPluginName);
    }

    return plugin;
}

void PluginCbImpl::destroyStorage(StoragePlugin *aStorage)
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    iPluginManager.destroyStorage(aStorage);
}

bool PluginCbImpl::isConnectivityAvailable(Sync::ConnectivityType aType)
{
    FUNCTION_CALL_TRACE(lcButeoTrace);

    return iTransportTracker.isConnectivityAvailable(aType);
}

Profile *PluginCbImpl::getSyncProfileByRemoteAddress(const QString &aAddress)
{
    Q_UNUSED(aAddress);
    return nullptr;
}

QString PluginCbImpl::getValue(const QString &aAddress, const QString &aKey)
{
    Q_UNUSED(aAddress);
    Q_UNUSED(aKey);

    return "";
}
