;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:          pubmed.asd
;;;; Purpose:       ASDF definition file for Pubmed
;;;; Programmer:    Kevin M. Rosenberg
;;;; Date Started:  Sep 2002
;;;;
;;;; $Id: pubmed.asd 7061 2003-09-07 06:34:45Z kevin $
;;;;
;;;; This file, part of cl-pubmed, is Copyright (c) 2002 by Kevin M. Rosenberg
;;;;
;;;; cl-pubmed users are granted the rights to distribute and use this software
;;;; as governed by the terms of the GNU Lesser General Public License 
;;;; (http://www.gnu.org/licenses/lgpl.html)
;;;; *************************************************************************

(in-package #:cl-user)
(defpackage #:pubmed-system (:use #:asdf #:cl))
(in-package #:pubmed-system)


#+(and allegro common-lisp-controller) (c-l-c::clc-require :aserve)
#+(and allegro (not common-lisp-controller)) (require :aserve)

;; only define system on implementations that aserve is available
(defsystem pubmed
  :name "cl-pubmed"
  :author "Kevin M. Rosenberg <kevin@rosenberg.net>"
  :version "2.1"
  :maintainer "Kevin M. Rosenberg <kmr@debian.org>"
  :licence "GNU Lesser General Public License"
  :description "Library for querying the PubMed medical literature database"
  :long-description "This library has functions for querying the PubMed medical literature database and parsing the XML results into Common Lisp objects."
  
  :components ((:file "package")
	       (:file "pubmed-src" :depends-on ("package")))
  
  :depends-on (:kmrcl #-allegro :aserve))



