#! /bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_PRINT='src/lib/perl5/COD/Formulae/Print.pm'
#END DEPEND--------------------------------------------------------------------

perl <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2020-08-14 12:48:49 +0300 (Fri, 14 Aug 2020) $ 
#$Revision: 8327 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.1.0/tests/shtests/print_formula_002.sh $
#------------------------------------------------------------------------------
#*
#  Unit test for the COD::Formulae::Print::print_formula() subroutine.
#  Tests the way elements with the atom count of '0' are represented
#  in the formula.
#**

use strict;
use warnings;

use COD::Formulae::Print qw( print_formula );

print_formula( { C  => 0.0 }, '%g' );
print_formula( { C  => 0 }, '%g' );
print_formula( { H  => 0 }, '%g' );
print_formula( { Cl => 0 }, '%g' );

END_SCRIPT
