/*
  DB Mixer
  ========
  Description: 
    a DJ Mixer style GUI interface to the DBMix system.

	Copyright (c) 1999, 2000 Robert Michael S Dean

	Author: Robert Michael S Dean
	Version: 1.0


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <sys/shm.h>
#include <xmms/plugin.h>
#include <dbchannel.h>
#include <dbaudiolib.h>
#include <dbdebug.h>
#include <dbsoundcard.h>

#include "dbmixer.h"


static const char * red_data[] = {
	"16 16 3 1",
	"       c None",
	".      c #000000000000",
	"X      c #FFFF00000000",
	"................",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	"................"};

static const char * green_data[] = {
	"16 16 3 1",
	"       c None",
	".      c #000000000000",
	"X      c #0000FFFF0000",
	"................",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	".XXXXXXXXXXXXXX.",
	"................"};

#define CLIPPING_LIGHT_WIDTH    16
#define CLIPPING_LIGHT_HEIGHT   16
#define CLIPPING_CLEANUP_COUNT  1000 / CLIPPING_INTERVAL


static GtkWidget * clipping_drawing_area;
static GdkPixmap * red_light = NULL;
static GdkPixmap * green_light = NULL;
static GdkPixmap * clipping_light = NULL;
GdkBitmap * mask;

extern dbfsd_data *sysdata;

int clip_count = 0;

int clipping_light_callback(gpointer * data)
{
	if (sysdata->clipping >= sysdata->clipping_threshold)
	{
		Clipping_Light_Toggle(1);
		sysdata->clipping = 0;
	}
	else
	{
		Clipping_Light_Toggle(0);
	}

	return TRUE;
}


/* Create a new backing pixmap of the appropriate size */
static gint clipping_configure_event(GtkWidget         *widget,
									 GdkEventConfigure *event)
{
	GtkStyle* style;

	if (red_light)
		gdk_pixmap_unref(red_light);

	if (green_light)
		gdk_pixmap_unref(green_light);

	style = gtk_widget_get_style(widget);

	red_light = gdk_pixmap_create_from_xpm_d(widget->window,  &mask,
											 &style->bg[GTK_STATE_NORMAL],
											 (gchar **)red_data);

	green_light = gdk_pixmap_create_from_xpm_d(widget->window,  &mask,
											   &style->bg[GTK_STATE_NORMAL],
											   (gchar **)green_data);
  
	clipping_light = green_light;

	return TRUE;
}

/* Redraw the screen from the backing pixmap */
static gint clipping_expose_event(GtkWidget      *widget,
								  GdkEventExpose *event)
{
	gdk_draw_pixmap(widget->window,
					widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
					clipping_light,
					event->area.x, event->area.y,
					event->area.x, event->area.y,
					event->area.width, event->area.height);

	return FALSE;
}

void Clipping_Light_Toggle(gint draw_red)
{
	GdkRectangle update_rect;

	GDK_THREADS_ENTER();

	if (draw_red) 
	{
		clipping_light = red_light;
	}
	else 
	{
		clipping_light = green_light;
	}

	update_rect.x = 0;
	update_rect.y = 0;
	update_rect.width = CLIPPING_LIGHT_WIDTH;
	update_rect.height = CLIPPING_LIGHT_HEIGHT;

	/* 	gdk_draw_pixmap(clipping_drawing_area->window, */
	/* 					clipping_drawing_area->style->fg_gc[GTK_WIDGET_STATE (clipping_drawing_area)], */
	/* 					clipping_light, */
	/* 					0, 0, */
	/* 					0, 0, */
	/* 					CLIPPING_LIGHT_WIDTH, CLIPPING_LIGHT_HEIGHT); */

	gtk_widget_draw(clipping_drawing_area,&update_rect);

	while (gtk_events_pending()) gtk_main_iteration();	

	/* 	gdk_flush(); */
	GDK_THREADS_LEAVE();

}


GtkWidget * Create_Clipping_Light(GtkWidget * w)
{
	GtkWidget * label;
	GtkWidget * box;

    box = gtk_hbox_new(FALSE,0);
	gtk_widget_show(box);

	/* create clipping label */
	label = (GtkWidget *)gtk_label_new("Clipping:");
	gtk_widget_show(GTK_WIDGET(label));

	gtk_box_pack_start(GTK_BOX(box),label,
					   FALSE,FALSE,0);

	/* create clipping drawing aread */
	clipping_drawing_area = gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(clipping_drawing_area),16,16);
	gtk_box_pack_start(GTK_BOX(box),clipping_drawing_area,FALSE,FALSE,5);
	gtk_widget_show(clipping_drawing_area);

	/* setup drawing area signals */
	gtk_signal_connect (GTK_OBJECT (clipping_drawing_area), "expose_event",
						(GtkSignalFunc) clipping_expose_event, NULL);
	gtk_signal_connect (GTK_OBJECT(clipping_drawing_area),"configure_event",
						(GtkSignalFunc) clipping_configure_event, NULL);
	gtk_widget_set_events (clipping_drawing_area, GDK_EXPOSURE_MASK);

	return box;
}
