// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networkdb.proto

package networkdb

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_hashicorp_serf_serf "github.com/hashicorp/serf/serf"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// MessageType enum defines all the core message types that networkdb
// uses to communicate to peers.
type MessageType int32

const (
	MessageTypeInvalid MessageType = 0
	// NetworkEvent message type is used to communicate network
	// attachments on the node.
	MessageTypeNetworkEvent MessageType = 1
	// TableEvent message type is used to communicate any table
	// CRUD event that happened on the node.
	MessageTypeTableEvent MessageType = 2
	// PushPull message type is used to syncup all network
	// attachments on a peer node either during startup of this
	// node or with a random peer node periodically thereafter.
	MessageTypePushPull MessageType = 3
	// BulkSync message is used to bulksync the whole networkdb
	// state with a peer node during startup of this node or with
	// a random peer node periodically thereafter.
	MessageTypeBulkSync MessageType = 4
	// Compound message type is used to form a compound message
	// which is a pack of many message of above types, packed into
	// a single compound message.
	MessageTypeCompound MessageType = 5
	// NodeEvent message type is used to communicate node
	// join/leave events in the cluster
	MessageTypeNodeEvent MessageType = 6
)

var MessageType_name = map[int32]string{
	0: "INVALID",
	1: "NETWORK_EVENT",
	2: "TABLE_EVENT",
	3: "PUSH_PULL",
	4: "BULK_SYNC",
	5: "COMPOUND",
	6: "NODE_EVENT",
}

var MessageType_value = map[string]int32{
	"INVALID":       0,
	"NETWORK_EVENT": 1,
	"TABLE_EVENT":   2,
	"PUSH_PULL":     3,
	"BULK_SYNC":     4,
	"COMPOUND":      5,
	"NODE_EVENT":    6,
}

func (x MessageType) String() string {
	return proto.EnumName(MessageType_name, int32(x))
}

func (MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{0}
}

type NodeEvent_Type int32

const (
	NodeEventTypeInvalid NodeEvent_Type = 0
	// Join event is generated when this node joins the cluster.
	NodeEventTypeJoin NodeEvent_Type = 1
	// Leave event is generated when this node leaves the cluster.
	NodeEventTypeLeave NodeEvent_Type = 2
)

var NodeEvent_Type_name = map[int32]string{
	0: "INVALID",
	1: "JOIN",
	2: "LEAVE",
}

var NodeEvent_Type_value = map[string]int32{
	"INVALID": 0,
	"JOIN":    1,
	"LEAVE":   2,
}

func (x NodeEvent_Type) String() string {
	return proto.EnumName(NodeEvent_Type_name, int32(x))
}

func (NodeEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{1, 0}
}

type NetworkEvent_Type int32

const (
	NetworkEventTypeInvalid NetworkEvent_Type = 0
	// Join event is generated when this node joins a network.
	NetworkEventTypeJoin NetworkEvent_Type = 1
	// Leave event is generated when this node leaves a network.
	NetworkEventTypeLeave NetworkEvent_Type = 2
)

var NetworkEvent_Type_name = map[int32]string{
	0: "INVALID",
	1: "JOIN",
	2: "LEAVE",
}

var NetworkEvent_Type_value = map[string]int32{
	"INVALID": 0,
	"JOIN":    1,
	"LEAVE":   2,
}

func (x NetworkEvent_Type) String() string {
	return proto.EnumName(NetworkEvent_Type_name, int32(x))
}

func (NetworkEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{2, 0}
}

type TableEvent_Type int32

const (
	TableEventTypeInvalid TableEvent_Type = 0
	// Create signifies that this table entry was just
	// created.
	TableEventTypeCreate TableEvent_Type = 1
	// Update signifies that this table entry was just
	// updated.
	TableEventTypeUpdate TableEvent_Type = 2
	// Delete signifies that this table entry was just
	// updated.
	TableEventTypeDelete TableEvent_Type = 3
)

var TableEvent_Type_name = map[int32]string{
	0: "INVALID",
	1: "CREATE",
	2: "UPDATE",
	3: "DELETE",
}

var TableEvent_Type_value = map[string]int32{
	"INVALID": 0,
	"CREATE":  1,
	"UPDATE":  2,
	"DELETE":  3,
}

func (x TableEvent_Type) String() string {
	return proto.EnumName(TableEvent_Type_name, int32(x))
}

func (TableEvent_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{5, 0}
}

// GossipMessage is a basic message header used by all messages types.
type GossipMessage struct {
	Type MessageType `protobuf:"varint,1,opt,name=type,proto3,enum=networkdb.MessageType" json:"type,omitempty"`
	Data []byte      `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *GossipMessage) Reset()      { *m = GossipMessage{} }
func (*GossipMessage) ProtoMessage() {}
func (*GossipMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{0}
}
func (m *GossipMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GossipMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GossipMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GossipMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GossipMessage.Merge(m, src)
}
func (m *GossipMessage) XXX_Size() int {
	return m.Size()
}
func (m *GossipMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_GossipMessage.DiscardUnknown(m)
}

var xxx_messageInfo_GossipMessage proto.InternalMessageInfo

func (m *GossipMessage) GetType() MessageType {
	if m != nil {
		return m.Type
	}
	return MessageTypeInvalid
}

func (m *GossipMessage) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// NodeEvent message payload definition.
type NodeEvent struct {
	Type NodeEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=networkdb.NodeEvent_Type" json:"type,omitempty"`
	// Lamport time using a network lamport clock indicating the
	// time this event was generated on the node where it was
	// generated.
	LTime github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,2,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	// Source node name.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
}

func (m *NodeEvent) Reset()      { *m = NodeEvent{} }
func (*NodeEvent) ProtoMessage() {}
func (*NodeEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{1}
}
func (m *NodeEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NodeEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NodeEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeEvent.Merge(m, src)
}
func (m *NodeEvent) XXX_Size() int {
	return m.Size()
}
func (m *NodeEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeEvent.DiscardUnknown(m)
}

var xxx_messageInfo_NodeEvent proto.InternalMessageInfo

func (m *NodeEvent) GetType() NodeEvent_Type {
	if m != nil {
		return m.Type
	}
	return NodeEventTypeInvalid
}

func (m *NodeEvent) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

// NetworkEvent message payload definition.
type NetworkEvent struct {
	Type NetworkEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=networkdb.NetworkEvent_Type" json:"type,omitempty"`
	// Lamport time using a network lamport clock indicating the
	// time this event was generated on the node where it was
	// generated.
	LTime github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,2,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	// Source node name.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// ID of the network for which the event is generated.
	NetworkID string `protobuf:"bytes,4,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
}

func (m *NetworkEvent) Reset()      { *m = NetworkEvent{} }
func (*NetworkEvent) ProtoMessage() {}
func (*NetworkEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{2}
}
func (m *NetworkEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEvent.Merge(m, src)
}
func (m *NetworkEvent) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEvent.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEvent proto.InternalMessageInfo

func (m *NetworkEvent) GetType() NetworkEvent_Type {
	if m != nil {
		return m.Type
	}
	return NetworkEventTypeInvalid
}

func (m *NetworkEvent) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *NetworkEvent) GetNetworkID() string {
	if m != nil {
		return m.NetworkID
	}
	return ""
}

// NetworkEntry for push pull of networks.
type NetworkEntry struct {
	// ID of the network
	NetworkID string `protobuf:"bytes,1,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Latest lamport time of the network attachment when this
	// network event was recorded.
	LTime github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,2,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	// Source node name where this network attachment happened.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// Indicates if a leave from this network is in progress.
	Leaving bool `protobuf:"varint,4,opt,name=leaving,proto3" json:"leaving,omitempty"`
}

func (m *NetworkEntry) Reset()      { *m = NetworkEntry{} }
func (*NetworkEntry) ProtoMessage() {}
func (*NetworkEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{3}
}
func (m *NetworkEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkEntry.Merge(m, src)
}
func (m *NetworkEntry) XXX_Size() int {
	return m.Size()
}
func (m *NetworkEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkEntry.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkEntry proto.InternalMessageInfo

func (m *NetworkEntry) GetNetworkID() string {
	if m != nil {
		return m.NetworkID
	}
	return ""
}

func (m *NetworkEntry) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *NetworkEntry) GetLeaving() bool {
	if m != nil {
		return m.Leaving
	}
	return false
}

// NetworkPushpull message payload definition.
type NetworkPushPull struct {
	// Lamport time when this push pull was initiated.
	LTime    github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,1,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	Networks []*NetworkEntry                            `protobuf:"bytes,2,rep,name=networks,proto3" json:"networks,omitempty"`
	// Name of the node sending this push pull payload.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
}

func (m *NetworkPushPull) Reset()      { *m = NetworkPushPull{} }
func (*NetworkPushPull) ProtoMessage() {}
func (*NetworkPushPull) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{4}
}
func (m *NetworkPushPull) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkPushPull) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkPushPull.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkPushPull) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkPushPull.Merge(m, src)
}
func (m *NetworkPushPull) XXX_Size() int {
	return m.Size()
}
func (m *NetworkPushPull) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkPushPull.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkPushPull proto.InternalMessageInfo

func (m *NetworkPushPull) GetNetworks() []*NetworkEntry {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *NetworkPushPull) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

// TableEvent message payload definition.
type TableEvent struct {
	Type TableEvent_Type `protobuf:"varint,1,opt,name=type,proto3,enum=networkdb.TableEvent_Type" json:"type,omitempty"`
	// Lamport time when this event was generated.
	LTime github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,2,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	// Node name where this event originated.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// ID of the network to which this table entry belongs.
	NetworkID string `protobuf:"bytes,4,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Name of the table to which this table entry belongs.
	TableName string `protobuf:"bytes,5,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Entry key.
	Key string `protobuf:"bytes,6,opt,name=key,proto3" json:"key,omitempty"`
	// Entry value.
	Value []byte `protobuf:"bytes,7,opt,name=value,proto3" json:"value,omitempty"`
	// Residual reap time for the entry before getting deleted in seconds
	ResidualReapTime int32 `protobuf:"varint,8,opt,name=residual_reap_time,json=residualReapTime,proto3" json:"residual_reap_time,omitempty"`
}

func (m *TableEvent) Reset()      { *m = TableEvent{} }
func (*TableEvent) ProtoMessage() {}
func (*TableEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{5}
}
func (m *TableEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TableEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TableEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TableEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TableEvent.Merge(m, src)
}
func (m *TableEvent) XXX_Size() int {
	return m.Size()
}
func (m *TableEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_TableEvent.DiscardUnknown(m)
}

var xxx_messageInfo_TableEvent proto.InternalMessageInfo

func (m *TableEvent) GetType() TableEvent_Type {
	if m != nil {
		return m.Type
	}
	return TableEventTypeInvalid
}

func (m *TableEvent) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *TableEvent) GetNetworkID() string {
	if m != nil {
		return m.NetworkID
	}
	return ""
}

func (m *TableEvent) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *TableEvent) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *TableEvent) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *TableEvent) GetResidualReapTime() int32 {
	if m != nil {
		return m.ResidualReapTime
	}
	return 0
}

// BulkSync message payload definition.
type BulkSyncMessage struct {
	// Lamport time when this bulk sync was initiated.
	LTime github_com_hashicorp_serf_serf.LamportTime `protobuf:"varint,1,opt,name=l_time,json=lTime,proto3,customtype=github.com/hashicorp/serf/serf.LamportTime" json:"l_time"`
	// Indicates if this bulksync is a response to a bulk sync
	// request from a peer node.
	Unsolicited bool `protobuf:"varint,2,opt,name=unsolicited,proto3" json:"unsolicited,omitempty"`
	// Name of the node which is producing this bulk sync message.
	NodeName string `protobuf:"bytes,3,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	// List of network names whose table entries are getting
	// bulksynced as part of the bulksync.
	Networks []string `protobuf:"bytes,4,rep,name=networks,proto3" json:"networks,omitempty"`
	// Bulksync payload
	Payload []byte `protobuf:"bytes,5,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (m *BulkSyncMessage) Reset()      { *m = BulkSyncMessage{} }
func (*BulkSyncMessage) ProtoMessage() {}
func (*BulkSyncMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{6}
}
func (m *BulkSyncMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BulkSyncMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BulkSyncMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BulkSyncMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BulkSyncMessage.Merge(m, src)
}
func (m *BulkSyncMessage) XXX_Size() int {
	return m.Size()
}
func (m *BulkSyncMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_BulkSyncMessage.DiscardUnknown(m)
}

var xxx_messageInfo_BulkSyncMessage proto.InternalMessageInfo

func (m *BulkSyncMessage) GetUnsolicited() bool {
	if m != nil {
		return m.Unsolicited
	}
	return false
}

func (m *BulkSyncMessage) GetNodeName() string {
	if m != nil {
		return m.NodeName
	}
	return ""
}

func (m *BulkSyncMessage) GetNetworks() []string {
	if m != nil {
		return m.Networks
	}
	return nil
}

func (m *BulkSyncMessage) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Compound message payload definition.
type CompoundMessage struct {
	// A list of simple messages.
	Messages []*CompoundMessage_SimpleMessage `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
}

func (m *CompoundMessage) Reset()      { *m = CompoundMessage{} }
func (*CompoundMessage) ProtoMessage() {}
func (*CompoundMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{7}
}
func (m *CompoundMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompoundMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompoundMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompoundMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompoundMessage.Merge(m, src)
}
func (m *CompoundMessage) XXX_Size() int {
	return m.Size()
}
func (m *CompoundMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_CompoundMessage.DiscardUnknown(m)
}

var xxx_messageInfo_CompoundMessage proto.InternalMessageInfo

func (m *CompoundMessage) GetMessages() []*CompoundMessage_SimpleMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

type CompoundMessage_SimpleMessage struct {
	// Bytestring payload of a message constructed using
	// other message type definitions.
	Payload []byte `protobuf:"bytes,1,opt,name=Payload,proto3" json:"Payload,omitempty"`
}

func (m *CompoundMessage_SimpleMessage) Reset()      { *m = CompoundMessage_SimpleMessage{} }
func (*CompoundMessage_SimpleMessage) ProtoMessage() {}
func (*CompoundMessage_SimpleMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_51036566ca8c9782, []int{7, 0}
}
func (m *CompoundMessage_SimpleMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CompoundMessage_SimpleMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CompoundMessage_SimpleMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CompoundMessage_SimpleMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompoundMessage_SimpleMessage.Merge(m, src)
}
func (m *CompoundMessage_SimpleMessage) XXX_Size() int {
	return m.Size()
}
func (m *CompoundMessage_SimpleMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_CompoundMessage_SimpleMessage.DiscardUnknown(m)
}

var xxx_messageInfo_CompoundMessage_SimpleMessage proto.InternalMessageInfo

func (m *CompoundMessage_SimpleMessage) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func init() {
	proto.RegisterEnum("networkdb.MessageType", MessageType_name, MessageType_value)
	proto.RegisterEnum("networkdb.NodeEvent_Type", NodeEvent_Type_name, NodeEvent_Type_value)
	proto.RegisterEnum("networkdb.NetworkEvent_Type", NetworkEvent_Type_name, NetworkEvent_Type_value)
	proto.RegisterEnum("networkdb.TableEvent_Type", TableEvent_Type_name, TableEvent_Type_value)
	proto.RegisterType((*GossipMessage)(nil), "networkdb.GossipMessage")
	proto.RegisterType((*NodeEvent)(nil), "networkdb.NodeEvent")
	proto.RegisterType((*NetworkEvent)(nil), "networkdb.NetworkEvent")
	proto.RegisterType((*NetworkEntry)(nil), "networkdb.NetworkEntry")
	proto.RegisterType((*NetworkPushPull)(nil), "networkdb.NetworkPushPull")
	proto.RegisterType((*TableEvent)(nil), "networkdb.TableEvent")
	proto.RegisterType((*BulkSyncMessage)(nil), "networkdb.BulkSyncMessage")
	proto.RegisterType((*CompoundMessage)(nil), "networkdb.CompoundMessage")
	proto.RegisterType((*CompoundMessage_SimpleMessage)(nil), "networkdb.CompoundMessage.SimpleMessage")
}

func init() { proto.RegisterFile("networkdb.proto", fileDescriptor_51036566ca8c9782) }

var fileDescriptor_51036566ca8c9782 = []byte{
	// 975 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0xcd, 0x6e, 0xdb, 0x46,
	0x10, 0xd6, 0xea, 0xcf, 0xd2, 0x58, 0xae, 0x59, 0xc6, 0x89, 0x19, 0xa6, 0xa5, 0x58, 0xd6, 0x31,
	0x14, 0xa3, 0x91, 0x0b, 0xe7, 0x09, 0x2c, 0x89, 0x68, 0x95, 0x28, 0x94, 0x40, 0x4b, 0x2e, 0x7a,
	0x12, 0x28, 0x73, 0x23, 0x13, 0xa6, 0x48, 0x82, 0xa4, 0x54, 0xe8, 0xd4, 0xa2, 0xa7, 0x40, 0x87,
	0xa2, 0x2f, 0xa0, 0x53, 0x7a, 0xee, 0x03, 0x14, 0x3d, 0xf6, 0x90, 0x43, 0x0f, 0xe9, 0x2d, 0xe8,
	0x41, 0xa8, 0xe5, 0x17, 0xe8, 0x23, 0x14, 0x5c, 0x92, 0xd2, 0x4a, 0x36, 0x02, 0x14, 0x35, 0xd0,
	0x5c, 0xa4, 0x9d, 0x99, 0x8f, 0xb3, 0x33, 0x1f, 0xbf, 0xd9, 0x25, 0x6c, 0x5b, 0xd8, 0xff, 0xc6,
	0x76, 0x2f, 0xf4, 0x5e, 0xd9, 0x71, 0x6d, 0xdf, 0x66, 0xf3, 0x0b, 0x07, 0xff, 0xb8, 0x6f, 0xf8,
	0xe7, 0xc3, 0x5e, 0xf9, 0xcc, 0x1e, 0x1c, 0xf6, 0xed, 0xbe, 0x7d, 0x48, 0x10, 0xbd, 0xe1, 0x0b,
	0x62, 0x11, 0x83, 0xac, 0xc2, 0x27, 0xa5, 0x26, 0x6c, 0x7d, 0x61, 0x7b, 0x9e, 0xe1, 0x3c, 0xc7,
	0x9e, 0xa7, 0xf5, 0x31, 0x7b, 0x00, 0x69, 0x7f, 0xec, 0x60, 0x0e, 0x89, 0xa8, 0xf4, 0xc1, 0xd1,
	0xbd, 0xf2, 0x72, 0xab, 0x08, 0xd1, 0x1e, 0x3b, 0x58, 0x25, 0x18, 0x96, 0x85, 0xb4, 0xae, 0xf9,
	0x1a, 0x97, 0x14, 0x51, 0xa9, 0xa0, 0x92, 0xb5, 0xf4, 0x2a, 0x09, 0x79, 0xc5, 0xd6, 0xb1, 0x3c,
	0xc2, 0x96, 0xcf, 0x3e, 0x5e, 0xc9, 0x76, 0x9f, 0xca, 0xb6, 0xc0, 0x94, 0xa9, 0x84, 0x75, 0xc8,
	0x9a, 0x5d, 0xdf, 0x18, 0x60, 0x92, 0x32, 0x5d, 0x39, 0x7a, 0x3d, 0x2b, 0x26, 0xfe, 0x9c, 0x15,
	0x0f, 0xa8, 0xa6, 0xce, 0x35, 0xef, 0xdc, 0x38, 0xb3, 0x5d, 0xe7, 0xd0, 0xc3, 0xee, 0x0b, 0xf2,
	0x53, 0x6e, 0x68, 0x03, 0xc7, 0x76, 0xfd, 0xb6, 0x31, 0xc0, 0x6a, 0xc6, 0x0c, 0xfe, 0xd8, 0x07,
	0x90, 0xb7, 0x6c, 0x1d, 0x77, 0x2d, 0x6d, 0x80, 0xb9, 0x94, 0x88, 0x4a, 0x79, 0x35, 0x17, 0x38,
	0x14, 0x6d, 0x80, 0xa5, 0x6f, 0x21, 0x1d, 0xec, 0xca, 0x3e, 0x84, 0x8d, 0xba, 0x72, 0x7a, 0xdc,
	0xa8, 0xd7, 0x98, 0x04, 0xcf, 0x4d, 0xa6, 0xe2, 0xce, 0xa2, 0xac, 0x20, 0x5e, 0xb7, 0x46, 0x9a,
	0x69, 0xe8, 0x6c, 0x11, 0xd2, 0x4f, 0x9b, 0x75, 0x85, 0x41, 0xfc, 0xdd, 0xc9, 0x54, 0xfc, 0x70,
	0x05, 0xf3, 0xd4, 0x36, 0x2c, 0xf6, 0x13, 0xc8, 0x34, 0xe4, 0xe3, 0x53, 0x99, 0x49, 0xf2, 0xf7,
	0x26, 0x53, 0x91, 0x5d, 0x41, 0x34, 0xb0, 0x36, 0xc2, 0x7c, 0xe1, 0xe5, 0x2b, 0x21, 0xf1, 0xcb,
	0x4f, 0x02, 0xd9, 0x58, 0xba, 0x4c, 0x42, 0x41, 0x09, 0xb9, 0x08, 0x89, 0xfa, 0x7c, 0x85, 0xa8,
	0x8f, 0x68, 0xa2, 0x28, 0xd8, 0xff, 0xc0, 0x15, 0xfb, 0x19, 0x40, 0x54, 0x4c, 0xd7, 0xd0, 0xb9,
	0x74, 0x10, 0xad, 0x6c, 0xcd, 0x67, 0xc5, 0x7c, 0x54, 0x58, 0xbd, 0xa6, 0xc6, 0xf2, 0xab, 0xeb,
	0xd2, 0x4b, 0x14, 0x51, 0x5b, 0xa2, 0xa9, 0x7d, 0x30, 0x99, 0x8a, 0xbb, 0x74, 0x23, 0x34, 0xbb,
	0xd2, 0x82, 0xdd, 0xf0, 0x0d, 0xac, 0xc1, 0x08, 0xc1, 0x7b, 0x4b, 0x82, 0xef, 0x4f, 0xa6, 0xe2,
	0xdd, 0x75, 0xd0, 0x4d, 0x1c, 0xff, 0x8e, 0x96, 0x1c, 0x5b, 0xbe, 0x3b, 0x5e, 0xeb, 0x04, 0xbd,
	0xbb, 0x93, 0xdb, 0xe4, 0xf7, 0xd1, 0x35, 0x7e, 0x2b, 0x85, 0xf9, 0xac, 0x98, 0x53, 0x22, 0x8e,
	0x29, 0xb6, 0x39, 0xd8, 0x30, 0xb1, 0x36, 0x32, 0xac, 0x3e, 0xa1, 0x3a, 0xa7, 0xc6, 0xa6, 0xf4,
	0x2b, 0x82, 0xed, 0xa8, 0xd0, 0xd6, 0xd0, 0x3b, 0x6f, 0x0d, 0x4d, 0x93, 0xaa, 0x11, 0xfd, 0xd7,
	0x1a, 0x9f, 0x40, 0x2e, 0xea, 0xdd, 0xe3, 0x92, 0x62, 0xaa, 0xb4, 0x79, 0xb4, 0x7b, 0x83, 0x08,
	0x03, 0x1e, 0xd5, 0x05, 0xf0, 0x5f, 0x34, 0x26, 0xfd, 0x90, 0x06, 0x68, 0x6b, 0x3d, 0x33, 0x3a,
	0x18, 0xca, 0x2b, 0x7a, 0xe7, 0xa9, 0xad, 0x96, 0xa0, 0xf7, 0x5e, 0xed, 0xec, 0xc7, 0x00, 0x7e,
	0x50, 0x6e, 0x98, 0x2b, 0x43, 0x72, 0xe5, 0x89, 0x87, 0x24, 0x63, 0x20, 0x75, 0x81, 0xc7, 0x5c,
	0x96, 0xf8, 0x83, 0x25, 0xbb, 0x03, 0x99, 0x91, 0x66, 0x0e, 0x31, 0xb7, 0x41, 0x8e, 0xcc, 0xd0,
	0x60, 0x2b, 0xc0, 0xba, 0xd8, 0x33, 0xf4, 0xa1, 0x66, 0x76, 0x5d, 0xac, 0x39, 0x61, 0xa3, 0x39,
	0x11, 0x95, 0x32, 0x95, 0x9d, 0xf9, 0xac, 0xc8, 0xa8, 0x51, 0x54, 0xc5, 0x9a, 0x43, 0x5a, 0x61,
	0xdc, 0x35, 0x8f, 0xf4, 0x73, 0x3c, 0x78, 0xfb, 0xf4, 0xe0, 0x91, 0x61, 0x59, 0x32, 0x4a, 0x8f,
	0xdd, 0x1e, 0x64, 0xab, 0xaa, 0x7c, 0xdc, 0x96, 0xe3, 0xc1, 0x5b, 0x85, 0x55, 0x5d, 0xac, 0xf9,
	0x38, 0x40, 0x75, 0x5a, 0xb5, 0x00, 0x95, 0xbc, 0x09, 0xd5, 0x71, 0xf4, 0x08, 0x55, 0x93, 0x1b,
	0x72, 0x5b, 0x66, 0x52, 0x37, 0xa1, 0x6a, 0xd8, 0xc4, 0xfe, 0xfa, 0x78, 0xfe, 0x81, 0x60, 0xbb,
	0x32, 0x34, 0x2f, 0x4e, 0xc6, 0xd6, 0x59, 0x7c, 0xf9, 0xdc, 0xa2, 0x9e, 0x45, 0xd8, 0x1c, 0x5a,
	0x9e, 0x6d, 0x1a, 0x67, 0x86, 0x8f, 0x75, 0xa2, 0x9a, 0x9c, 0x4a, 0xbb, 0xde, 0xad, 0x03, 0x9e,
	0x1a, 0x87, 0xb4, 0x98, 0x22, 0xb1, 0x58, 0xf5, 0x1c, 0x6c, 0x38, 0xda, 0xd8, 0xb4, 0x35, 0x9d,
	0xbc, 0xf2, 0x82, 0x1a, 0x9b, 0xd2, 0xf7, 0x08, 0xb6, 0xab, 0xf6, 0xc0, 0xb1, 0x87, 0x96, 0x1e,
	0xf7, 0x54, 0x83, 0xdc, 0x20, 0x5c, 0x7a, 0x1c, 0x22, 0x83, 0x55, 0xa2, 0xd4, 0xbe, 0x86, 0x2e,
	0x9f, 0x18, 0x03, 0xc7, 0xc4, 0x91, 0xa5, 0x2e, 0x9e, 0xe4, 0x1f, 0xc1, 0xd6, 0x4a, 0x28, 0x28,
	0xa2, 0x15, 0x15, 0x81, 0xc2, 0x22, 0x22, 0xf3, 0xe0, 0xb7, 0x24, 0x6c, 0x52, 0x77, 0x35, 0xfb,
	0x29, 0x2d, 0x08, 0x72, 0x3d, 0x51, 0xd1, 0x58, 0x0d, 0x65, 0xd8, 0x52, 0xe4, 0xf6, 0x57, 0x4d,
	0xf5, 0x59, 0x57, 0x3e, 0x95, 0x95, 0x36, 0x83, 0xc2, 0x43, 0x9b, 0x82, 0xae, 0xdc, 0x57, 0x07,
	0xb0, 0xd9, 0x3e, 0xae, 0x34, 0xe4, 0x08, 0x1d, 0x1d, 0xcb, 0x14, 0x9a, 0x9a, 0xf5, 0x7d, 0xc8,
	0xb7, 0x3a, 0x27, 0x5f, 0x76, 0x5b, 0x9d, 0x46, 0x83, 0x49, 0xf1, 0xbb, 0x93, 0xa9, 0x78, 0x87,
	0x42, 0x2e, 0x4e, 0xb3, 0x7d, 0xc8, 0x57, 0x3a, 0x8d, 0x67, 0xdd, 0x93, 0xaf, 0x95, 0x2a, 0x93,
	0xbe, 0x86, 0x8b, 0xc5, 0xc2, 0x3e, 0x84, 0x5c, 0xb5, 0xf9, 0xbc, 0xd5, 0xec, 0x28, 0x35, 0x26,
	0x73, 0x0d, 0x16, 0x33, 0xca, 0x96, 0x00, 0x94, 0x66, 0x2d, 0xae, 0x30, 0x1b, 0x0a, 0x93, 0xee,
	0x27, 0xbe, 0xa4, 0xf9, 0x3b, 0x91, 0x30, 0x69, 0xda, 0x2a, 0x7b, 0x6f, 0x2f, 0x85, 0xc4, 0xdf,
	0x97, 0x02, 0xfa, 0x6e, 0x2e, 0xa0, 0xd7, 0x73, 0x01, 0xbd, 0x99, 0x0b, 0xe8, 0xaf, 0xb9, 0x80,
	0x7e, 0xbc, 0x12, 0x12, 0x6f, 0xae, 0x84, 0xc4, 0xdb, 0x2b, 0x21, 0xd1, 0xcb, 0x92, 0xcf, 0xa8,
	0x27, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0x82, 0xf0, 0x4d, 0x63, 0x93, 0x09, 0x00, 0x00,
}

func (this *GossipMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&networkdb.GossipMessage{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Data: "+fmt.Sprintf("%#v", this.Data)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeEvent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&networkdb.NodeEvent{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkEvent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&networkdb.NetworkEvent{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "NetworkID: "+fmt.Sprintf("%#v", this.NetworkID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkEntry) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&networkdb.NetworkEntry{")
	s = append(s, "NetworkID: "+fmt.Sprintf("%#v", this.NetworkID)+",\n")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "Leaving: "+fmt.Sprintf("%#v", this.Leaving)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NetworkPushPull) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&networkdb.NetworkPushPull{")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	if this.Networks != nil {
		s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	}
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TableEvent) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&networkdb.TableEvent{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "NetworkID: "+fmt.Sprintf("%#v", this.NetworkID)+",\n")
	s = append(s, "TableName: "+fmt.Sprintf("%#v", this.TableName)+",\n")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "ResidualReapTime: "+fmt.Sprintf("%#v", this.ResidualReapTime)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *BulkSyncMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 9)
	s = append(s, "&networkdb.BulkSyncMessage{")
	s = append(s, "LTime: "+fmt.Sprintf("%#v", this.LTime)+",\n")
	s = append(s, "Unsolicited: "+fmt.Sprintf("%#v", this.Unsolicited)+",\n")
	s = append(s, "NodeName: "+fmt.Sprintf("%#v", this.NodeName)+",\n")
	s = append(s, "Networks: "+fmt.Sprintf("%#v", this.Networks)+",\n")
	s = append(s, "Payload: "+fmt.Sprintf("%#v", this.Payload)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CompoundMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&networkdb.CompoundMessage{")
	if this.Messages != nil {
		s = append(s, "Messages: "+fmt.Sprintf("%#v", this.Messages)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CompoundMessage_SimpleMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&networkdb.CompoundMessage_SimpleMessage{")
	s = append(s, "Payload: "+fmt.Sprintf("%#v", this.Payload)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringNetworkdb(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *GossipMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GossipMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GossipMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NodeEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NodeEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NetworkID) > 0 {
		i -= len(m.NetworkID)
		copy(dAtA[i:], m.NetworkID)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NetworkID)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *NetworkEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Leaving {
		i--
		if m.Leaving {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x10
	}
	if len(m.NetworkID) > 0 {
		i -= len(m.NetworkID)
		copy(dAtA[i:], m.NetworkID)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NetworkID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *NetworkPushPull) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkPushPull) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkPushPull) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Networks) > 0 {
		for iNdEx := len(m.Networks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Networks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkdb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *TableEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TableEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ResidualReapTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.ResidualReapTime))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.TableName) > 0 {
		i -= len(m.TableName)
		copy(dAtA[i:], m.TableName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.TableName)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.NetworkID) > 0 {
		i -= len(m.NetworkID)
		copy(dAtA[i:], m.NetworkID)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NetworkID)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BulkSyncMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BulkSyncMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BulkSyncMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Networks) > 0 {
		for iNdEx := len(m.Networks) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Networks[iNdEx])
			copy(dAtA[i:], m.Networks[iNdEx])
			i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Networks[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.NodeName) > 0 {
		i -= len(m.NodeName)
		copy(dAtA[i:], m.NodeName)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.NodeName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Unsolicited {
		i--
		if m.Unsolicited {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.LTime != 0 {
		i = encodeVarintNetworkdb(dAtA, i, uint64(m.LTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CompoundMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompoundMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompoundMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Messages) > 0 {
		for iNdEx := len(m.Messages) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Messages[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintNetworkdb(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CompoundMessage_SimpleMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompoundMessage_SimpleMessage) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CompoundMessage_SimpleMessage) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Payload) > 0 {
		i -= len(m.Payload)
		copy(dAtA[i:], m.Payload)
		i = encodeVarintNetworkdb(dAtA, i, uint64(len(m.Payload)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintNetworkdb(dAtA []byte, offset int, v uint64) int {
	offset -= sovNetworkdb(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GossipMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovNetworkdb(uint64(m.Type))
	}
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func (m *NodeEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovNetworkdb(uint64(m.Type))
	}
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func (m *NetworkEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovNetworkdb(uint64(m.Type))
	}
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	l = len(m.NetworkID)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func (m *NetworkEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NetworkID)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	if m.Leaving {
		n += 2
	}
	return n
}

func (m *NetworkPushPull) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	if len(m.Networks) > 0 {
		for _, e := range m.Networks {
			l = e.Size()
			n += 1 + l + sovNetworkdb(uint64(l))
		}
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func (m *TableEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovNetworkdb(uint64(m.Type))
	}
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	l = len(m.NetworkID)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	l = len(m.TableName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	if m.ResidualReapTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.ResidualReapTime))
	}
	return n
}

func (m *BulkSyncMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.LTime != 0 {
		n += 1 + sovNetworkdb(uint64(m.LTime))
	}
	if m.Unsolicited {
		n += 2
	}
	l = len(m.NodeName)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	if len(m.Networks) > 0 {
		for _, s := range m.Networks {
			l = len(s)
			n += 1 + l + sovNetworkdb(uint64(l))
		}
	}
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func (m *CompoundMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Messages) > 0 {
		for _, e := range m.Messages {
			l = e.Size()
			n += 1 + l + sovNetworkdb(uint64(l))
		}
	}
	return n
}

func (m *CompoundMessage_SimpleMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Payload)
	if l > 0 {
		n += 1 + l + sovNetworkdb(uint64(l))
	}
	return n
}

func sovNetworkdb(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozNetworkdb(x uint64) (n int) {
	return sovNetworkdb(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *GossipMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GossipMessage{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeEvent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeEvent{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkEvent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkEvent{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkEntry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NetworkEntry{`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`Leaving:` + fmt.Sprintf("%v", this.Leaving) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NetworkPushPull) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForNetworks := "[]*NetworkEntry{"
	for _, f := range this.Networks {
		repeatedStringForNetworks += strings.Replace(f.String(), "NetworkEntry", "NetworkEntry", 1) + ","
	}
	repeatedStringForNetworks += "}"
	s := strings.Join([]string{`&NetworkPushPull{`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`Networks:` + repeatedStringForNetworks + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TableEvent) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TableEvent{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`NetworkID:` + fmt.Sprintf("%v", this.NetworkID) + `,`,
		`TableName:` + fmt.Sprintf("%v", this.TableName) + `,`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`ResidualReapTime:` + fmt.Sprintf("%v", this.ResidualReapTime) + `,`,
		`}`,
	}, "")
	return s
}
func (this *BulkSyncMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&BulkSyncMessage{`,
		`LTime:` + fmt.Sprintf("%v", this.LTime) + `,`,
		`Unsolicited:` + fmt.Sprintf("%v", this.Unsolicited) + `,`,
		`NodeName:` + fmt.Sprintf("%v", this.NodeName) + `,`,
		`Networks:` + fmt.Sprintf("%v", this.Networks) + `,`,
		`Payload:` + fmt.Sprintf("%v", this.Payload) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CompoundMessage) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForMessages := "[]*CompoundMessage_SimpleMessage{"
	for _, f := range this.Messages {
		repeatedStringForMessages += strings.Replace(fmt.Sprintf("%v", f), "CompoundMessage_SimpleMessage", "CompoundMessage_SimpleMessage", 1) + ","
	}
	repeatedStringForMessages += "}"
	s := strings.Join([]string{`&CompoundMessage{`,
		`Messages:` + repeatedStringForMessages + `,`,
		`}`,
	}, "")
	return s
}
func (this *CompoundMessage_SimpleMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CompoundMessage_SimpleMessage{`,
		`Payload:` + fmt.Sprintf("%v", this.Payload) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringNetworkdb(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *GossipMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GossipMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GossipMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= MessageType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= NodeEvent_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= NetworkEvent_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Leaving", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Leaving = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkPushPull) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkPushPull: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkPushPull: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, &NetworkEntry{})
			if err := m.Networks[len(m.Networks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= TableEvent_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = append(m.Value[:0], dAtA[iNdEx:postIndex]...)
			if m.Value == nil {
				m.Value = []byte{}
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResidualReapTime", wireType)
			}
			m.ResidualReapTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResidualReapTime |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BulkSyncMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BulkSyncMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BulkSyncMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LTime", wireType)
			}
			m.LTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LTime |= github_com_hashicorp_serf_serf.LamportTime(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unsolicited", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unsolicited = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Networks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Networks = append(m.Networks, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompoundMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompoundMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompoundMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Messages", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Messages = append(m.Messages, &CompoundMessage_SimpleMessage{})
			if err := m.Messages[len(m.Messages)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompoundMessage_SimpleMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimpleMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimpleMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthNetworkdb
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipNetworkdb(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthNetworkdb
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipNetworkdb(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowNetworkdb
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowNetworkdb
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthNetworkdb
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupNetworkdb
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthNetworkdb
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthNetworkdb        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowNetworkdb          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupNetworkdb = fmt.Errorf("proto: unexpected end of group")
)
