
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDate>
#include <QCalendar>
#include <QDateTime>
#include <QTimeZone>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDate

//  Constructor QDate::QDate()


static void _init_ctor_QDate_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDate> ();
}

static void _call_ctor_QDate_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate *> (new QDate ());
}


//  Constructor QDate::QDate(int y, int m, int d)


static void _init_ctor_QDate_2085 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return_new<QDate> ();
}

static void _call_ctor_QDate_2085 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDate *> (new QDate (arg1, arg2, arg3));
}


//  Constructor QDate::QDate(int y, int m, int d, QCalendar cal)


static void _init_ctor_QDate_3288 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("cal");
  decl->add_arg<QCalendar > (argspec_3);
  decl->set_return_new<QDate> ();
}

static void _call_ctor_QDate_3288 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  QCalendar arg4 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<QDate *> (new QDate (arg1, arg2, arg3, arg4));
}


// QDate QDate::addDays(qint64 days)


static void _init_f_addDays_c986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("days");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addDays_c986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<QDate > ((QDate)((QDate *)cls)->addDays (arg1));
}


// QDate QDate::addMonths(int months)


static void _init_f_addMonths_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("months");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addMonths_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDate > ((QDate)((QDate *)cls)->addMonths (arg1));
}


// QDate QDate::addMonths(int months, QCalendar cal)


static void _init_f_addMonths_c1970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("months");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cal");
  decl->add_arg<QCalendar > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_addMonths_c1970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QCalendar arg2 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<QDate > ((QDate)((QDate *)cls)->addMonths (arg1, arg2));
}


// QDate QDate::addYears(int years)


static void _init_f_addYears_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("years");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_addYears_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDate > ((QDate)((QDate *)cls)->addYears (arg1));
}


// QDate QDate::addYears(int years, QCalendar cal)


static void _init_f_addYears_c1970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("years");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cal");
  decl->add_arg<QCalendar > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_addYears_c1970 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QCalendar arg2 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<QDate > ((QDate)((QDate *)cls)->addYears (arg1, arg2));
}


// int QDate::day()


static void _init_f_day_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_day_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->day ());
}


// int QDate::day(QCalendar cal)


static void _init_f_day_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_day_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->day (arg1));
}


// int QDate::dayOfWeek()


static void _init_f_dayOfWeek_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dayOfWeek_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->dayOfWeek ());
}


// int QDate::dayOfWeek(QCalendar cal)


static void _init_f_dayOfWeek_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_dayOfWeek_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->dayOfWeek (arg1));
}


// int QDate::dayOfYear()


static void _init_f_dayOfYear_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dayOfYear_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->dayOfYear ());
}


// int QDate::dayOfYear(QCalendar cal)


static void _init_f_dayOfYear_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_dayOfYear_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->dayOfYear (arg1));
}


// int QDate::daysInMonth()


static void _init_f_daysInMonth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_daysInMonth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->daysInMonth ());
}


// int QDate::daysInMonth(QCalendar cal)


static void _init_f_daysInMonth_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_daysInMonth_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->daysInMonth (arg1));
}


// int QDate::daysInYear()


static void _init_f_daysInYear_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_daysInYear_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->daysInYear ());
}


// int QDate::daysInYear(QCalendar cal)


static void _init_f_daysInYear_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_daysInYear_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->daysInYear (arg1));
}


// qint64 QDate::daysTo(QDate d)


static void _init_f_daysTo_c899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("d");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_daysTo_c899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  ret.write<qint64 > ((qint64)((QDate *)cls)->daysTo (arg1));
}


// QDateTime QDate::endOfDay(Qt::TimeSpec spec, int offsetSeconds)


static void _init_f_endOfDay_c2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spec", true, "Qt::LocalTime");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offsetSeconds", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_endOfDay_c2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimeSpec>(heap, Qt::LocalTime), heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QDateTime > ((QDateTime)((QDate *)cls)->endOfDay (qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg1).cref(), arg2));
}


// QDateTime QDate::endOfDay(const QTimeZone &zone)


static void _init_f_endOfDay_c2205 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zone");
  decl->add_arg<const QTimeZone & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_endOfDay_c2205 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTimeZone &arg1 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDate *)cls)->endOfDay (arg1));
}


// void QDate::getDate(int *year, int *month, int *day)


static void _init_f_getDate_c2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getDate_c2643 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = gsi::arg_reader<int * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  int *arg3 = gsi::arg_reader<int * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDate *)cls)->getDate (arg1, arg2, arg3);
}


// bool QDate::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDate *)cls)->isNull ());
}


// bool QDate::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDate *)cls)->isValid ());
}


// int QDate::month()


static void _init_f_month_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_month_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->month ());
}


// int QDate::month(QCalendar cal)


static void _init_f_month_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_month_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->month (arg1));
}


// bool QDate::setDate(int year, int month, int day)


static void _init_f_setDate_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setDate_2085 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QDate *)cls)->setDate (arg1, arg2, arg3));
}


// bool QDate::setDate(int year, int month, int day, QCalendar cal)


static void _init_f_setDate_3288 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("day");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("cal");
  decl->add_arg<QCalendar > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_setDate_3288 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  QCalendar arg4 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<bool > ((bool)((QDate *)cls)->setDate (arg1, arg2, arg3, arg4));
}


// QDateTime QDate::startOfDay(Qt::TimeSpec spec, int offsetSeconds)


static void _init_f_startOfDay_c2202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spec", true, "Qt::LocalTime");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offsetSeconds", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_startOfDay_c2202 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimeSpec>(heap, Qt::LocalTime), heap);
  int arg2 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QDateTime > ((QDateTime)((QDate *)cls)->startOfDay (qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg1).cref(), arg2));
}


// QDateTime QDate::startOfDay(const QTimeZone &zone)


static void _init_f_startOfDay_c2205 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("zone");
  decl->add_arg<const QTimeZone & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_startOfDay_c2205 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTimeZone &arg1 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDate *)cls)->startOfDay (arg1));
}


// qint64 QDate::toJulianDay()


static void _init_f_toJulianDay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_toJulianDay_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QDate *)cls)->toJulianDay ());
}


// QString QDate::toString(Qt::DateFormat format)


static void _init_f_toString_c1748 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1748 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate), heap);
  ret.write<QString > ((QString)((QDate *)cls)->toString (qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg1).cref()));
}


// QString QDate::toString(const QString &format, QCalendar cal)


static void _init_f_toString_c3228 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3228 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QCalendar arg2 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QString > ((QString)((QDate *)cls)->toString (arg1, arg2));
}


// QString QDate::toString(QStringView format, QCalendar cal)


static void _init_f_toString_c2762 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<QStringView > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2762 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStringView arg1 = gsi::arg_reader<QStringView >() (args, heap);
  QCalendar arg2 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QString > ((QString)((QDate *)cls)->toString (arg1, arg2));
}


// int QDate::weekNumber(int *yearNum)


static void _init_f_weekNumber_c953 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("yearNum", true, "nullptr");
  decl->add_arg<int * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_weekNumber_c953 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int *arg1 = args ? gsi::arg_reader<int * >() (args, heap) : gsi::arg_maker<int * >() (nullptr, heap);
  ret.write<int > ((int)((QDate *)cls)->weekNumber (arg1));
}


// int QDate::year()


static void _init_f_year_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_year_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDate *)cls)->year ());
}


// int QDate::year(QCalendar cal)


static void _init_f_year_c1311 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cal");
  decl->add_arg<QCalendar > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_year_c1311 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCalendar arg1 = gsi::arg_reader<QCalendar >() (args, heap);
  ret.write<int > ((int)((QDate *)cls)->year (arg1));
}


// static QDate QDate::currentDate()


static void _init_f_currentDate_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_currentDate_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate > ((QDate)QDate::currentDate ());
}


// static QDate QDate::fromJulianDay(qint64 jd_)


static void _init_f_fromJulianDay_986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("jd_");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QDate > ();
}

static void _call_f_fromJulianDay_986 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<QDate > ((QDate)QDate::fromJulianDay (arg1));
}


// static QDate QDate::fromString(QStringView string, Qt::DateFormat format)


static void _init_f_fromString_3199 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QStringView > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_3199 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStringView arg1 = gsi::arg_reader<QStringView >() (args, heap);
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate), heap);
  ret.write<QDate > ((QDate)QDate::fromString (arg1, qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg2).cref()));
}


// static QDate QDate::fromString(QStringView string, QStringView format, QCalendar cal)


static void _init_f_fromString_4213 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QStringView > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<QStringView > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_2);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_4213 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStringView arg1 = gsi::arg_reader<QStringView >() (args, heap);
  QStringView arg2 = gsi::arg_reader<QStringView >() (args, heap);
  QCalendar arg3 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QDate > ((QDate)QDate::fromString (arg1, arg2, arg3));
}


// static QDate QDate::fromString(const QString &string, QStringView format, QCalendar cal)


static void _init_f_fromString_4679 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<QStringView > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_2);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_4679 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QStringView arg2 = gsi::arg_reader<QStringView >() (args, heap);
  QCalendar arg3 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QDate > ((QDate)QDate::fromString (arg1, arg2, arg3));
}


// static QDate QDate::fromString(const QString &string, Qt::DateFormat format)


static void _init_f_fromString_3665 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_3665 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate), heap);
  ret.write<QDate > ((QDate)QDate::fromString (arg1, qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg2).cref()));
}


// static QDate QDate::fromString(const QString &string, const QString &format, QCalendar cal)


static void _init_f_fromString_5145 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_2);
  decl->set_return<QDate > ();
}

static void _call_f_fromString_5145 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QCalendar arg3 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QDate > ((QDate)QDate::fromString (arg1, arg2, arg3));
}


// static bool QDate::isLeapYear(int year)


static void _init_f_isLeapYear_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isLeapYear_767 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QDate::isLeapYear (arg1));
}


// static bool QDate::isValid(int y, int m, int d)


static void _init_f_isValid_2085 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("m");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("d");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_isValid_2085 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)QDate::isValid (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QDate () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDate::QDate()\nThis method creates an object of class QDate.", &_init_ctor_QDate_0, &_call_ctor_QDate_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDate::QDate(int y, int m, int d)\nThis method creates an object of class QDate.", &_init_ctor_QDate_2085, &_call_ctor_QDate_2085);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDate::QDate(int y, int m, int d, QCalendar cal)\nThis method creates an object of class QDate.", &_init_ctor_QDate_3288, &_call_ctor_QDate_3288);
  methods += new qt_gsi::GenericMethod ("addDays", "@brief Method QDate QDate::addDays(qint64 days)\n", true, &_init_f_addDays_c986, &_call_f_addDays_c986);
  methods += new qt_gsi::GenericMethod ("addMonths", "@brief Method QDate QDate::addMonths(int months)\n", true, &_init_f_addMonths_c767, &_call_f_addMonths_c767);
  methods += new qt_gsi::GenericMethod ("addMonths", "@brief Method QDate QDate::addMonths(int months, QCalendar cal)\n", true, &_init_f_addMonths_c1970, &_call_f_addMonths_c1970);
  methods += new qt_gsi::GenericMethod ("addYears", "@brief Method QDate QDate::addYears(int years)\n", true, &_init_f_addYears_c767, &_call_f_addYears_c767);
  methods += new qt_gsi::GenericMethod ("addYears", "@brief Method QDate QDate::addYears(int years, QCalendar cal)\n", true, &_init_f_addYears_c1970, &_call_f_addYears_c1970);
  methods += new qt_gsi::GenericMethod ("day", "@brief Method int QDate::day()\n", true, &_init_f_day_c0, &_call_f_day_c0);
  methods += new qt_gsi::GenericMethod ("day", "@brief Method int QDate::day(QCalendar cal)\n", true, &_init_f_day_c1311, &_call_f_day_c1311);
  methods += new qt_gsi::GenericMethod ("dayOfWeek", "@brief Method int QDate::dayOfWeek()\n", true, &_init_f_dayOfWeek_c0, &_call_f_dayOfWeek_c0);
  methods += new qt_gsi::GenericMethod ("dayOfWeek", "@brief Method int QDate::dayOfWeek(QCalendar cal)\n", true, &_init_f_dayOfWeek_c1311, &_call_f_dayOfWeek_c1311);
  methods += new qt_gsi::GenericMethod ("dayOfYear", "@brief Method int QDate::dayOfYear()\n", true, &_init_f_dayOfYear_c0, &_call_f_dayOfYear_c0);
  methods += new qt_gsi::GenericMethod ("dayOfYear", "@brief Method int QDate::dayOfYear(QCalendar cal)\n", true, &_init_f_dayOfYear_c1311, &_call_f_dayOfYear_c1311);
  methods += new qt_gsi::GenericMethod ("daysInMonth", "@brief Method int QDate::daysInMonth()\n", true, &_init_f_daysInMonth_c0, &_call_f_daysInMonth_c0);
  methods += new qt_gsi::GenericMethod ("daysInMonth", "@brief Method int QDate::daysInMonth(QCalendar cal)\n", true, &_init_f_daysInMonth_c1311, &_call_f_daysInMonth_c1311);
  methods += new qt_gsi::GenericMethod ("daysInYear", "@brief Method int QDate::daysInYear()\n", true, &_init_f_daysInYear_c0, &_call_f_daysInYear_c0);
  methods += new qt_gsi::GenericMethod ("daysInYear", "@brief Method int QDate::daysInYear(QCalendar cal)\n", true, &_init_f_daysInYear_c1311, &_call_f_daysInYear_c1311);
  methods += new qt_gsi::GenericMethod ("daysTo", "@brief Method qint64 QDate::daysTo(QDate d)\n", true, &_init_f_daysTo_c899, &_call_f_daysTo_c899);
  methods += new qt_gsi::GenericMethod ("endOfDay", "@brief Method QDateTime QDate::endOfDay(Qt::TimeSpec spec, int offsetSeconds)\n", true, &_init_f_endOfDay_c2202, &_call_f_endOfDay_c2202);
  methods += new qt_gsi::GenericMethod ("endOfDay", "@brief Method QDateTime QDate::endOfDay(const QTimeZone &zone)\n", true, &_init_f_endOfDay_c2205, &_call_f_endOfDay_c2205);
  methods += new qt_gsi::GenericMethod ("getDate", "@brief Method void QDate::getDate(int *year, int *month, int *day)\n", true, &_init_f_getDate_c2643, &_call_f_getDate_c2643);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QDate::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QDate::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("month", "@brief Method int QDate::month()\n", true, &_init_f_month_c0, &_call_f_month_c0);
  methods += new qt_gsi::GenericMethod ("month", "@brief Method int QDate::month(QCalendar cal)\n", true, &_init_f_month_c1311, &_call_f_month_c1311);
  methods += new qt_gsi::GenericMethod ("setDate", "@brief Method bool QDate::setDate(int year, int month, int day)\n", false, &_init_f_setDate_2085, &_call_f_setDate_2085);
  methods += new qt_gsi::GenericMethod ("setDate", "@brief Method bool QDate::setDate(int year, int month, int day, QCalendar cal)\n", false, &_init_f_setDate_3288, &_call_f_setDate_3288);
  methods += new qt_gsi::GenericMethod ("startOfDay", "@brief Method QDateTime QDate::startOfDay(Qt::TimeSpec spec, int offsetSeconds)\n", true, &_init_f_startOfDay_c2202, &_call_f_startOfDay_c2202);
  methods += new qt_gsi::GenericMethod ("startOfDay", "@brief Method QDateTime QDate::startOfDay(const QTimeZone &zone)\n", true, &_init_f_startOfDay_c2205, &_call_f_startOfDay_c2205);
  methods += new qt_gsi::GenericMethod ("toJulianDay", "@brief Method qint64 QDate::toJulianDay()\n", true, &_init_f_toJulianDay_c0, &_call_f_toJulianDay_c0);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QDate::toString(Qt::DateFormat format)\n", true, &_init_f_toString_c1748, &_call_f_toString_c1748);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QDate::toString(const QString &format, QCalendar cal)\n", true, &_init_f_toString_c3228, &_call_f_toString_c3228);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QDate::toString(QStringView format, QCalendar cal)\n", true, &_init_f_toString_c2762, &_call_f_toString_c2762);
  methods += new qt_gsi::GenericMethod ("weekNumber", "@brief Method int QDate::weekNumber(int *yearNum)\n", true, &_init_f_weekNumber_c953, &_call_f_weekNumber_c953);
  methods += new qt_gsi::GenericMethod ("year", "@brief Method int QDate::year()\n", true, &_init_f_year_c0, &_call_f_year_c0);
  methods += new qt_gsi::GenericMethod ("year", "@brief Method int QDate::year(QCalendar cal)\n", true, &_init_f_year_c1311, &_call_f_year_c1311);
  methods += new qt_gsi::GenericStaticMethod ("currentDate", "@brief Static method QDate QDate::currentDate()\nThis method is static and can be called without an instance.", &_init_f_currentDate_0, &_call_f_currentDate_0);
  methods += new qt_gsi::GenericStaticMethod ("fromJulianDay", "@brief Static method QDate QDate::fromJulianDay(qint64 jd_)\nThis method is static and can be called without an instance.", &_init_f_fromJulianDay_986, &_call_f_fromJulianDay_986);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(QStringView string, Qt::DateFormat format)\nThis method is static and can be called without an instance.", &_init_f_fromString_3199, &_call_f_fromString_3199);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(QStringView string, QStringView format, QCalendar cal)\nThis method is static and can be called without an instance.", &_init_f_fromString_4213, &_call_f_fromString_4213);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(const QString &string, QStringView format, QCalendar cal)\nThis method is static and can be called without an instance.", &_init_f_fromString_4679, &_call_f_fromString_4679);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(const QString &string, Qt::DateFormat format)\nThis method is static and can be called without an instance.", &_init_f_fromString_3665, &_call_f_fromString_3665);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDate QDate::fromString(const QString &string, const QString &format, QCalendar cal)\nThis method is static and can be called without an instance.", &_init_f_fromString_5145, &_call_f_fromString_5145);
  methods += new qt_gsi::GenericStaticMethod ("isLeapYear?", "@brief Static method bool QDate::isLeapYear(int year)\nThis method is static and can be called without an instance.", &_init_f_isLeapYear_767, &_call_f_isLeapYear_767);
  methods += new qt_gsi::GenericStaticMethod ("isValid?", "@brief Static method bool QDate::isValid(int y, int m, int d)\nThis method is static and can be called without an instance.", &_init_f_isValid_2085, &_call_f_isValid_2085);
  return methods;
}

gsi::Class<QDate> decl_QDate ("QtCore", "QDate",
  methods_QDate (),
  "@qt\n@brief Binding of QDate");


GSI_QTCORE_PUBLIC gsi::Class<QDate> &qtdecl_QDate () { return decl_QDate; }

}

