/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#ifndef SLIDERBAR_H
#define SLIDERBAR_H

#include <QWidget>

#define DEFAULT_LR_MARGIN   8
#define MIN_HEIGHT          20

QT_FORWARD_DECLARE_CLASS(ProgressBar)
QT_FORWARD_DECLARE_CLASS(Slider)

class SliderBar : public QWidget
{
    Q_OBJECT
public:
    explicit SliderBar(QWidget *parent = nullptr);
    ~SliderBar();

    void addMark(int value, QString desc);
    void deleteMark(int value);
    void clearMark();
    void setTimeTip(QString tip);

    void setBlackTheme();
    void setLightTheme();


public slots:
    void setValue(int val);
    void setRange(int min, int max);

signals:
    void valueChange(int);
    void sliderMoved(int);
    void mousePosChange(int);
    void mouseLeave();

private:
    void initUI();

private:
    ProgressBar *m_progressBar;
    Slider *m_slider;
    int m_value;
    bool m_canSetValue;

protected:
    void resizeEvent(QResizeEvent *e) override;
};

#endif // SLIDERBAR_H
