// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple riscv64 -target-feature +experimental-zbe -emit-llvm %s -o - \
// RUN:     | FileCheck %s  -check-prefix=RV64ZBE

// RV64ZBE-LABEL: @bcompressw(
// RV64ZBE-NEXT:  entry:
// RV64ZBE-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV64ZBE-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV64ZBE-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV64ZBE-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.bcompress.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV64ZBE-NEXT:    ret i32 [[TMP2]]
//
int bcompressw(int rs1, int rs2) {
  return __builtin_riscv_bcompress_32(rs1, rs2);
}

// RV64ZBE-LABEL: @bdecompressw(
// RV64ZBE-NEXT:  entry:
// RV64ZBE-NEXT:    [[RS1_ADDR:%.*]] = alloca i32, align 4
// RV64ZBE-NEXT:    [[RS2_ADDR:%.*]] = alloca i32, align 4
// RV64ZBE-NEXT:    store i32 [[RS1:%.*]], i32* [[RS1_ADDR]], align 4
// RV64ZBE-NEXT:    store i32 [[RS2:%.*]], i32* [[RS2_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP0:%.*]] = load i32, i32* [[RS1_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP1:%.*]] = load i32, i32* [[RS2_ADDR]], align 4
// RV64ZBE-NEXT:    [[TMP2:%.*]] = call i32 @llvm.riscv.bdecompress.i32(i32 [[TMP0]], i32 [[TMP1]])
// RV64ZBE-NEXT:    ret i32 [[TMP2]]
//
int bdecompressw(int rs1, int rs2) {
  return __builtin_riscv_bdecompress_32(rs1, rs2);
}

// RV64ZBE-LABEL: @bcompress(
// RV64ZBE-NEXT:  entry:
// RV64ZBE-NEXT:    [[RS1_ADDR:%.*]] = alloca i64, align 8
// RV64ZBE-NEXT:    [[RS2_ADDR:%.*]] = alloca i64, align 8
// RV64ZBE-NEXT:    store i64 [[RS1:%.*]], i64* [[RS1_ADDR]], align 8
// RV64ZBE-NEXT:    store i64 [[RS2:%.*]], i64* [[RS2_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP0:%.*]] = load i64, i64* [[RS1_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP1:%.*]] = load i64, i64* [[RS2_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP2:%.*]] = call i64 @llvm.riscv.bcompress.i64(i64 [[TMP0]], i64 [[TMP1]])
// RV64ZBE-NEXT:    ret i64 [[TMP2]]
//
long bcompress(long rs1, long rs2) {
  return __builtin_riscv_bcompress_64(rs1, rs2);
}

// RV64ZBE-LABEL: @bdecompress(
// RV64ZBE-NEXT:  entry:
// RV64ZBE-NEXT:    [[RS1_ADDR:%.*]] = alloca i64, align 8
// RV64ZBE-NEXT:    [[RS2_ADDR:%.*]] = alloca i64, align 8
// RV64ZBE-NEXT:    store i64 [[RS1:%.*]], i64* [[RS1_ADDR]], align 8
// RV64ZBE-NEXT:    store i64 [[RS2:%.*]], i64* [[RS2_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP0:%.*]] = load i64, i64* [[RS1_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP1:%.*]] = load i64, i64* [[RS2_ADDR]], align 8
// RV64ZBE-NEXT:    [[TMP2:%.*]] = call i64 @llvm.riscv.bdecompress.i64(i64 [[TMP0]], i64 [[TMP1]])
// RV64ZBE-NEXT:    ret i64 [[TMP2]]
//
long bdecompress(long rs1, long rs2) {
  return __builtin_riscv_bdecompress_64(rs1, rs2);
}
