; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instsimplify < %s | FileCheck %s

declare double @llvm.log10.f64(double)
declare double @llvm.pow.f64(double, double)

define double @log10_pow10(double %x) {
; CHECK-LABEL: @log10_pow10(
; CHECK-NEXT:    [[TMP1:%.*]] = call double @llvm.pow.f64(double 1.000000e+01, double [[X:%.*]])
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.log10.f64(double [[TMP1]])
; CHECK-NEXT:    ret double [[TMP2]]
;
  %tmp = call double @llvm.pow.f64(double 1.000000e+01, double %x)
  %tmp1 = call double @llvm.log10.f64(double %tmp)
  ret double %tmp1
}

define double @log10_strict_pow10_reassoc(double %x) {
; CHECK-LABEL: @log10_strict_pow10_reassoc(
; CHECK-NEXT:    [[TMP1:%.*]] = call reassoc double @llvm.pow.f64(double 1.000000e+01, double [[X:%.*]])
; CHECK-NEXT:    [[TMP2:%.*]] = call double @llvm.log10.f64(double [[TMP1]])
; CHECK-NEXT:    ret double [[TMP2]]
;
  %tmp = call reassoc double @llvm.pow.f64(double 1.000000e+01, double %x)
  %tmp1 = call double @llvm.log10.f64(double %tmp)
  ret double %tmp1
}

define double @log10_reassoc_pow10_strict(double %x) {
; CHECK-LABEL: @log10_reassoc_pow10_strict(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %tmp = call double @llvm.pow.f64(double 1.000000e+01, double %x)
  %tmp1 = call reassoc double @llvm.log10.f64(double %tmp)
  ret double %tmp1
}

define double @log10_pow10_reassoc(double %x) {
; CHECK-LABEL: @log10_pow10_reassoc(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %tmp = call reassoc double @llvm.pow.f64(double 1.000000e+01, double %x)
  %tmp1 = call reassoc double @llvm.log10.f64(double %tmp)
  ret double %tmp1
}
