undocumented {
    (symbol /, EngineRing, Ideal),
}

document {
     Key => {(symbol /, Ring, Ideal),
	  (symbol /, Ring, Module),
	  (symbol /, Ring, RingElement),
	  (symbol /, Ring, List),
	  (symbol /, Ring, Sequence),
	  (symbol /, Ring, ZZ)
	  },
     Headline => "make a quotient ring",
     Usage => "S = R/I",
     Inputs => {
	  "R",
	  "I" => Nothing => {
	       { ofClass Ideal, " or element of ", TT "R",
		    "or ", ofClass List, " or ", ofClass Sequence, " of elements of ", TT "R"}}
	  },
     Outputs => {
	  "S" => {"the quotient ring ", TT "R/I"}
	  },
     "If ", TT "I", " is a ring element of ", TT "R", " or ", TT "ZZ",
     ", or a list or sequence of such elements, then ",
     TT "I", " is understood to be the
     ideal generated by these elements.  If ",
     TT "I", " is a module, then it must be a submodule
     of a free module of rank 1.",
     EXAMPLE lines ///
     	  ZZ[x]/367236427846278621
	  ///,
     EXAMPLE lines ///
     	  A = QQ[u,v];
	  I = ideal random(A^1, A^{-2,-2,-2})
	  B = A/I;
	  use A;
	  C = A/(u^2-v^2,u*v);
	  ///,
     EXAMPLE lines ///
	  D = GF(9,Variable=>a)[x,y]/(y^2 - x*(x-1)*(x-a))
	  ambient D
     	  ///,
     "The names of the variables are assigned values in the new quotient ring
     (by automatically running ", TT "use R", ") when the new ring is assigned
     to a global variable.",
     PARA{},
     "Warning: quotient rings are bulky objects, because they contain
     a Gröbner basis for their ideals, so only quotients of ", TO "ZZ", "
     are remembered forever.  Typically the ring created by ", TT "R/I", "
     will be a brand new ring, and its elements will be incompatible with
     the elements of previously created quotient rings for the same ideal.",
     EXAMPLE {
	  "ZZ/2 === ZZ/(4,6)",
      	  "R = ZZ/101[t]",
      	  "R/t === R/t",
	  }
     }

document {
     Key => {(symbol /, Module, Module),
	  (symbol /, Module, Ideal),
	  (symbol /, Module, List),
	  (symbol /, Module, Sequence),
	  (symbol /, Module, Vector),
	  (symbol /, Module, RingElement)},
     Headline => "quotient module",
     Usage => "M/N",
     Inputs => {
	  "M",
	  "N" => Nothing => {
	       ofClass Module, ", ",
	       ofClass Ideal, ", ",
	       ofClass List, ", ",
	       ofClass Sequence, ", ",
	       ofClass RingElement, ", or ",
	       ofClass Vector}
	  },
     Outputs => {
	  Module => "The quotient module M/N of M"
	  },
     "If N is an ideal, ring element, or list or sequence of
     ring elements (in the ring of M),
     then the quotient is
     by the submodule N*M of M.",
     PARA{},
     "If N is a submodule of M, or a list or sequence of submodules, or a vector, then the quotient
     is by these elements or submodules.",
     EXAMPLE lines ///
     	  R = ZZ/173[a..d]
	  M = ker matrix{{a^3-a*c*d,a*b*c-b^3,a*b*d-b*c^2}}
	  M/a == M/(a*M)
	  M/M_0
	  M/(R*M_0 + b*M)
	  M/(M_0,a*M_1+M_2)
     	  presentation oo
	  ///,
      SeeAlso => {"subquotient modules", presentation}
     }

document {
     Key => (symbol /, Ideal, Ideal),
     Headline => "quotient module",
     Usage => "I/J",
     Inputs => { "I", "J" => {"in the same ring as ", TT "I"}},
     Outputs => {
	  Module => {"The quotient module ", TT "(I+J)/J"}
	  },
     EXAMPLE lines ///
     	  R = QQ[a,b,c]
	  I = ideal vars R
	  M = I / I^2
	  ///,
     "There is a difference between typing I/J and (I+J)/J
     in Macaulay2, although conceptually they are the same module.
     The former has as its generating set the generators of I,
     while the latter has as its (redundant) generators
     the generators of I and J.  Generally, the former method is preferable.",
     EXAMPLE lines ///
	  gens M
	  N = (I + I^2)/I^2
	  gens N
     ///,
     SeeAlso => {"subquotient modules", generators}
     }
