/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2019 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * abs Multi - Multiple parameters for abs functions

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "TransfAbsAddMulti4dIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfAbsAddMulti4dIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL4 tempA = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
	REAL4 tempB = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};

	if (fractal->transformCommon.functionEnabledAx)
		tempA.x = fabs(z.x + fractal->transformCommon.additionConstant0000.x);

	if (fractal->transformCommon.functionEnabledx)
		tempB.x = fabs(z.x - fractal->transformCommon.offset0000.x);

	z.x = tempA.x - tempB.x - (z.x * fractal->transformCommon.scale1111.x);

	if (fractal->transformCommon.functionEnabledAy)
		tempA.y = fabs(z.y + fractal->transformCommon.additionConstant0000.y);

	if (fractal->transformCommon.functionEnabledy)
		tempB.y = fabs(z.y - fractal->transformCommon.offset0000.y);

	z.y = tempA.y - tempB.y - (z.y * fractal->transformCommon.scale1111.y);

	if (fractal->transformCommon.functionEnabledAz)
		tempA.z = fabs(z.z + fractal->transformCommon.additionConstant0000.z);

	if (fractal->transformCommon.functionEnabledz)
		tempB.z = fabs(z.z - fractal->transformCommon.offset0000.z);

	z.z = tempA.z - tempB.z - (z.z * fractal->transformCommon.scale1111.z);

	if (fractal->transformCommon.functionEnabledAw)
		tempA.w = fabs(z.w + fractal->transformCommon.additionConstant0000.w);

	if (fractal->transformCommon.functionEnabledz)
		tempB.w = fabs(z.w - fractal->transformCommon.offset0000.w);

	z.w = tempA.w - tempB.w - (z.w * fractal->transformCommon.scale1111.w);

	// post-offset
	z += fractal->transformCommon.offsetA0000;

	if (fractal->analyticDE.enabledFalse)
		aux->DE = mad(aux->DE, fractal->analyticDE.scale1, fractal->analyticDE.offset0);
	return z;
}