# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.implicit_plane_representation import ImplicitPlaneRepresentation


class ImplicitImageRepresentation(ImplicitPlaneRepresentation):
    r"""
    ImplicitImageRepresentation - a representation for a
    ImplicitPlaneWidget2 which reslices a volume
    
    Superclass: ImplicitPlaneRepresentation
    
    This class is a specialization of the ImplicitPlaneRepresentation.
    It is specialized to resample volumes across a plane. It is similar
    to ImagePlaneWidget, except the combination of
    ImplicitPlaneWidget2 and ImplicitImageRepresentation is a
    second generation widget design, with a much simpler and intuitive
    plane manipulation.
    
    See the documentation for ImplicitPlaneWidget2 and
    ImplicitPlaneRepresentation for usage information. One notable
    difference is that the methods place_image() are preferred to the
    superclasses' place_widget() method.
    
    @sa
    ImplicitPlaneWidget2 ImagePlaneWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkImplicitImageRepresentation, obj, update, **traits)
    
    texture_interpolate = tvtk_base.true_bool_trait(desc=\
        r"""
        Specify whether to interpolate the texture or not. When off, the
        reslice interpolation is nearest neighbour regardless of how the
        interpolation is set through the API. Set before setting the
        ImageData input. Default is On.
        """
    )

    def _texture_interpolate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureInterpolate,
                        self.texture_interpolate_)

    user_controlled_lookup_table = tvtk_base.false_bool_trait(desc=\
        r"""
        Let the user control the lookup table. NOTE: apply this method
        BEFORE applying the set_lookup_table method. The default is Off.
        """
    )

    def _user_controlled_lookup_table_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUserControlledLookupTable,
                        self.user_controlled_lookup_table_)

    reslice_interpolate = tvtk_base.RevPrefixMap({'linear': 1, 'cubic': 2, 'nearest_neighbour': 0}, default_value='linear', desc=\
        r"""
        Set the interpolation to use when texturing the plane.
        """
    )

    def _reslice_interpolate_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResliceInterpolate,
                        self.reslice_interpolate_)

    def _get_color_map(self):
        return wrap_vtk(self._vtk_obj.GetColorMap())
    def _set_color_map(self, arg):
        old_val = self._get_color_map()
        self._wrap_call(self._vtk_obj.SetColorMap,
                        deref_vtk(arg))
        self.trait_property_changed('color_map', old_val, arg)
    color_map = traits.Property(_get_color_map, _set_color_map, desc=\
        r"""
        
        """
    )

    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    def _set_lookup_table(self, arg):
        old_val = self._get_lookup_table()
        self._wrap_call(self._vtk_obj.SetLookupTable,
                        deref_vtk(arg))
        self.trait_property_changed('lookup_table', old_val, arg)
    lookup_table = traits.Property(_get_lookup_table, _set_lookup_table, desc=\
        r"""
        
        """
    )

    def _get_reslice(self):
        return wrap_vtk(self._vtk_obj.GetReslice())
    reslice = traits.Property(_get_reslice, desc=\
        r"""
        Convenience method to get the ImageReslice filter used by this
        widget.
        """
    )

    def place_image(self, *args):
        """
        place_image(self, img:ImageData) -> None
        C++: void place_image(ImageData *img)
        place_image(self, aout:AlgorithmOutput) -> None
        C++: void place_image(AlgorithmOutput *aout)
        Various ways to specify the ImageData* input for the
        ImageReslice; and perform place_widget().
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PlaceImage, *my_args)
        return ret

    _updateable_traits_ = \
    (('texture_interpolate', 'GetTextureInterpolate'),
    ('user_controlled_lookup_table', 'GetUserControlledLookupTable'),
    ('constrain_to_widget_bounds', 'GetConstrainToWidgetBounds'),
    ('crop_plane_to_bounding_box', 'GetCropPlaneToBoundingBox'),
    ('draw_outline', 'GetDrawOutline'), ('draw_plane', 'GetDrawPlane'),
    ('lock_normal_to_camera', 'GetLockNormalToCamera'),
    ('normal_to_x_axis', 'GetNormalToXAxis'), ('normal_to_y_axis',
    'GetNormalToYAxis'), ('normal_to_z_axis', 'GetNormalToZAxis'),
    ('outline_translation', 'GetOutlineTranslation'), ('outside_bounds',
    'GetOutsideBounds'), ('scale_enabled', 'GetScaleEnabled'), ('tubing',
    'GetTubing'), ('need_to_render', 'GetNeedToRender'),
    ('picking_managed', 'GetPickingManaged'), ('dragable', 'GetDragable'),
    ('pickable', 'GetPickable'), ('use_bounds', 'GetUseBounds'),
    ('visibility', 'GetVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reslice_interpolate', 'GetResliceInterpolate'), ('normal',
    'GetNormal'), ('always_snap_to_nearest_axis',
    'GetAlwaysSnapToNearestAxis'), ('bump_distance', 'GetBumpDistance'),
    ('interaction_state', 'GetInteractionState'), ('origin', 'GetOrigin'),
    ('representation_state', 'GetRepresentationState'), ('snap_to_axes',
    'GetSnapToAxes'), ('widget_bounds', 'GetWidgetBounds'),
    ('handle_size', 'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['constrain_to_widget_bounds', 'crop_plane_to_bounding_box', 'debug',
    'dragable', 'draw_outline', 'draw_plane', 'global_warning_display',
    'lock_normal_to_camera', 'need_to_render', 'normal_to_x_axis',
    'normal_to_y_axis', 'normal_to_z_axis', 'outline_translation',
    'outside_bounds', 'pickable', 'picking_managed', 'scale_enabled',
    'texture_interpolate', 'tubing', 'use_bounds',
    'user_controlled_lookup_table', 'visibility', 'normal',
    'reslice_interpolate', 'always_snap_to_nearest_axis', 'bump_distance',
    'estimated_render_time', 'handle_size', 'interaction_state', 'origin',
    'place_factor', 'render_time_multiplier', 'representation_state',
    'snap_to_axes', 'widget_bounds'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ImplicitImageRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ImplicitImageRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['constrain_to_widget_bounds', 'crop_plane_to_bounding_box',
            'draw_outline', 'draw_plane', 'lock_normal_to_camera',
            'need_to_render', 'normal_to_x_axis', 'normal_to_y_axis',
            'normal_to_z_axis', 'outline_translation', 'outside_bounds',
            'picking_managed', 'scale_enabled', 'texture_interpolate', 'tubing',
            'use_bounds', 'user_controlled_lookup_table', 'visibility'],
            ['normal', 'reslice_interpolate'], ['always_snap_to_nearest_axis',
            'bump_distance', 'estimated_render_time', 'handle_size',
            'interaction_state', 'origin', 'place_factor',
            'render_time_multiplier', 'representation_state', 'snap_to_axes',
            'widget_bounds']),
            title='Edit ImplicitImageRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ImplicitImageRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

