# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_base import UnstructuredGridBase


class UnstructuredGrid(UnstructuredGridBase):
    r"""
    UnstructuredGrid - dataset represents arbitrary combinations of
    all possible cell types
    
    Superclass: UnstructuredGridBase
    
    UnstructuredGrid is a data object that is a concrete
    implementation of DataSet. UnstructuredGrid represents any
    combinations of any cell types. This includes 0D (e.g., points), 1D
    (e.g., lines, polylines), 2D (e.g., triangles, polygons), and 3D
    (e.g., hexahedron, tetrahedron, polyhedron, etc.).
    UnstructuredGrid provides random access to cells, as well as
    topological information (such as lists of cells using each point).
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkUnstructuredGrid, obj, update, **traits)
    
    def get_cells(self):
        """
        get_cells(self) -> CellArray
        C++: CellArray *get_cells()
        Return the unstructured grid connectivity array.
        """
        ret = wrap_vtk(self._vtk_obj.GetCells())
        return ret
        

    def set_cells(self, *args):
        """
        set_cells(self, type:int, cells:CellArray) -> None
        C++: void set_cells(int type, CellArray *cells)
        set_cells(self, types:[int, ...], cells:CellArray) -> None
        C++: void set_cells(int *types, CellArray *cells)
        set_cells(self, cellTypes:UnsignedCharArray, cells:CellArray)
             -> None
        C++: void set_cells(UnsignedCharArray *cellTypes,
            CellArray *cells)
        set_cells(self, cellTypes:UnsignedCharArray, cells:CellArray,
             faceLocations:IdTypeArray, faces:IdTypeArray) -> None
        C++: void set_cells(UnsignedCharArray *cellTypes,
            CellArray *cells, IdTypeArray *faceLocations,
            IdTypeArray *faces)
        set_cells(self, cellTypes:UnsignedCharArray,
            cellLocations:IdTypeArray, cells:CellArray) -> None
        C++: void set_cells(UnsignedCharArray *cellTypes,
            IdTypeArray *cellLocations, CellArray *cells)
        set_cells(self, cellTypes:UnsignedCharArray,
            cellLocations:IdTypeArray, cells:CellArray,
            faceLocations:IdTypeArray, faces:IdTypeArray) -> None
        C++: void set_cells(UnsignedCharArray *cellTypes,
            IdTypeArray *cellLocations, CellArray *cells,
            IdTypeArray *faceLocations, IdTypeArray *faces)
        Provide cell information to define the dataset.
        
        Cells like Polyhedron require points plus a list of faces. To
        handle Polyhedron, set_cells() support a special input
        cellConnectivities format (numcell_faces, numface0_pts, id1, id2,
        id3, numface1_pts,id1, id2, id3, ...) The functions use
        Polyhedron::DecomposeAPolyhedronCell() to convert polyhedron
        cells into standard format.
        """
        my_args = deref_array(args, [('int', 'vtkCellArray'), (['int', Ellipsis], 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkCellArray', 'vtkIdTypeArray', 'vtkIdTypeArray'), ('vtkUnsignedCharArray', 'vtkIdTypeArray', 'vtkCellArray'), ('vtkUnsignedCharArray', 'vtkIdTypeArray', 'vtkCellArray', 'vtkIdTypeArray', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.SetCells, *my_args)
        return ret

    def _get_cell_links(self):
        return wrap_vtk(self._vtk_obj.GetCellLinks())
    cell_links = traits.Property(_get_cell_links, desc=\
        r"""
        Get the cell links. The cell links will be one of nullptr=0;
        CellLinks=1; StaticCellLinksTemplate<VTK_UNSIGNED_SHORT>=2;
        StaticCellLinksTemplate<VTK_UNSIGNED_INT>=3;
        StaticCellLinksTemplate<VTK_ID_TYPE>=4.  (See enum types
        defined in AbstractCellLinks.)
        """
    )

    def _get_cell_locations_array(self):
        return wrap_vtk(self._vtk_obj.GetCellLocationsArray())
    cell_locations_array = traits.Property(_get_cell_locations_array, desc=\
        r"""
        Get the array of all the starting indices of cell definitions in
        the cell array.
        
        @warning CellArray supports random access now. This array is
            no
        longer used.
        """
    )

    def _get_cell_types_array(self):
        return wrap_vtk(self._vtk_obj.GetCellTypesArray())
    cell_types_array = traits.Property(_get_cell_types_array, desc=\
        r"""
        Get the array of all cell types in the grid. Each
        single-component tuple in the array at an index that corresponds
        to the type of the cell with the same index. To get an array of
        only the distinct cell types in the dataset, use get_cell_types().
        """
    )

    def _get_face_locations(self):
        return wrap_vtk(self._vtk_obj.GetFaceLocations())
    face_locations = traits.Property(_get_face_locations, desc=\
        r"""
        
        """
    )

    def get_face_stream(self, *args):
        """
        get_face_stream(self, cellId:int, ptIds:IdList) -> None
        C++: void get_face_stream(IdType cellId, IdList *ptIds)
        get_face_stream(self, cellId:int, nfaces:int, ptIds:(int, ...))
            -> None
        C++: void get_face_stream(IdType cellId, IdType &nfaces,
            IdType const *&ptIds)
        Get the face stream of a polyhedron cell in the following format:
        (numcell_faces, numface0_pts, id1, id2, id3, numface1_pts,id1, id2,
        id3, ...). If the requested cell is not a polyhedron, then the
        standard get_cell_points is called to return a list of unique point
        ids (id1, id2, id3, ...).
        """
        my_args = deref_array(args, [('int', 'vtkIdList'), ('int', 'int', ('int', Ellipsis))])
        ret = self._wrap_call(self._vtk_obj.GetFaceStream, *my_args)
        return ret

    def _get_faces(self):
        return wrap_vtk(self._vtk_obj.GetFaces())
    faces = traits.Property(_get_faces, desc=\
        r"""
        Special support for polyhedron. Return nullptr for all other cell
        types.
        """
    )

    def get_faces(self, *args):
        """
        get_faces(self, cellId:int) -> Pointer
        C++: IdType *get_faces(IdType cellId)
        get_faces(self) -> IdTypeArray
        C++: IdTypeArray *get_faces()
        Special support for polyhedron. Return nullptr for all other cell
        types.
        """
        ret = self._wrap_call(self._vtk_obj.GetFaces, *args)
        return wrap_vtk(ret)

    def _get_ghost_level(self):
        return self._vtk_obj.GetGhostLevel()
    ghost_level = traits.Property(_get_ghost_level, desc=\
        r"""
        Get the ghost level.
        """
    )

    def _get_mesh_m_time(self):
        return self._vtk_obj.GetMeshMTime()
    mesh_m_time = traits.Property(_get_mesh_m_time, desc=\
        r"""
        Return the mesh (geometry/topology) modification time. This time
        is different from the usual MTime which also takes into account
        the modification of data arrays. This function can be used to
        track the changes on the mesh separately from the data arrays
        (eg. static mesh over time with transient data).
        """
    )

    def _get_number_of_pieces(self):
        return self._vtk_obj.GetNumberOfPieces()
    number_of_pieces = traits.Property(_get_number_of_pieces, desc=\
        r"""
        
        """
    )

    def _get_piece(self):
        return self._vtk_obj.GetPiece()
    piece = traits.Property(_get_piece, desc=\
        r"""
        Set / Get the piece and the number of pieces. Similar to extent
        in 3D.
        """
    )

    def add_reference_to_cell(self, *args):
        """
        add_reference_to_cell(self, ptId:int, cellId:int) -> None
        C++: void add_reference_to_cell(IdType ptId, IdType cellId)"""
        ret = self._wrap_call(self._vtk_obj.AddReferenceToCell, *args)
        return ret

    def allocate_estimate(self, *args):
        """
        allocate_estimate(self, numCells:int, maxCellSize:int) -> bool
        C++: bool allocate_estimate(IdType numCells,
            IdType maxCellSize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param numCells The number of expected cells in the dataset.
        @param maxcell_size The number of points per cell to allocate
            memory for.
        @return True if allocation succeeds.
        @sa Squeeze();
        """
        ret = self._wrap_call(self._vtk_obj.AllocateEstimate, *args)
        return ret

    def allocate_exact(self, *args):
        """
        allocate_exact(self, numCells:int, connectivitySize:int) -> bool
        C++: bool allocate_exact(IdType numCells,
            IdType connectivitySize)
        Pre-allocate memory in internal data structures. Does not change
        the number of cells, only the array capacities. Existing data is
        NOT preserved.
        @param numCells The number of expected cells in the dataset.
        @param connectivitySize The total number of pointIds stored for
            all cells.
        @return True if allocation succeeds.
        @sa Squeeze();
        """
        ret = self._wrap_call(self._vtk_obj.AllocateExact, *args)
        return ret

    def build_links(self):
        """
        build_links(self) -> None
        C++: void build_links()
        Build topological links from points to lists of cells that use
        each point. See AbstractCellLinks for more information.
        """
        ret = self._vtk_obj.BuildLinks()
        return ret
        

    def convert_face_stream_point_ids(self, *args):
        """
        convert_face_stream_point_ids(faceStream:IdList, idMap:[int, ...])
            -> None
        C++: static void convert_face_stream_point_ids(IdList *faceStream,
            IdType *idMap)
        convert_face_stream_point_ids(nfaces:int, faceStream:[int, ...],
            idMap:[int, ...]) -> None
        C++: static void convert_face_stream_point_ids(IdType nfaces,
            IdType *faceStream, IdType *idMap)
        Convert pid in a face stream into idMap[pid]. The face stream is
        of format [ncell_faces, nface0_pts, i, j, k, nface1_pts, i, j, k,
        ...]. The user is responsible to make sure all the Ids in
        faceStream do not exceed the range of idMap.
        """
        my_args = deref_array(args, [('vtkIdList', ['int', Ellipsis]), ('int', ['int', Ellipsis], ['int', Ellipsis])])
        ret = self._wrap_call(self._vtk_obj.ConvertFaceStreamPointIds, *my_args)
        return ret

    def decompose_a_polyhedron_cell(self, *args):
        """
        decompose_a_polyhedron_cell(polyhedronCellArray:CellArray,
            nCellpts:int, nCellfaces:int, cellArray:CellArray,
            faces:IdTypeArray) -> None
        C++: static void decompose_a_polyhedron_cell(
            CellArray *polyhedronCellArray, IdType &nCellpts,
            IdType &nCellfaces, CellArray *cellArray,
            IdTypeArray *faces)
        decompose_a_polyhedron_cell(polyhedronCellStream:(int, ...),
            nCellpts:int, nCellfaces:int, cellArray:CellArray,
            faces:IdTypeArray) -> None
        C++: static void decompose_a_polyhedron_cell(
            const IdType *polyhedronCellStream, IdType &nCellpts,
            IdType &nCellfaces, CellArray *cellArray,
            IdTypeArray *faces)
        decompose_a_polyhedron_cell(nCellFaces:int, inFaceStream:(int, ...),
            nCellpts:int, cellArray:CellArray, faces:IdTypeArray)
            -> None
        C++: static void decompose_a_polyhedron_cell(IdType nCellFaces,
            const IdType *inFaceStream, IdType &nCellpts,
            CellArray *cellArray, IdTypeArray *faces)
        A static method for converting a polyhedron CellArray of
        format [ncell_faces, nface0_pts, i, j, k, nface1_pts, i, j, k, ...]
        into three components: (1) an integer indicating the number of
        faces (2) a standard CellArray storing point ids [ncell0_pts,
        i, j, k] and (3) an IdTypeArray storing face connectivity in
        format [nface0_pts, i, j, k, nface1_pts, i, j, k, ...] Note: input
        is assumed to contain only one polyhedron cell. Outputs (2) and
        (3) will be stacked at the end of the input cellArray and faces.
        The original data in the input will not be touched.
        """
        my_args = deref_array(args, [('vtkCellArray', 'int', 'int', 'vtkCellArray', 'vtkIdTypeArray'), (('int', Ellipsis), 'int', 'int', 'vtkCellArray', 'vtkIdTypeArray'), ('int', ('int', Ellipsis), 'int', 'vtkCellArray', 'vtkIdTypeArray')])
        ret = self._wrap_call(self._vtk_obj.DecomposeAPolyhedronCell, *my_args)
        return ret

    def initialize_faces_representation(self, *args):
        """
        initialize_faces_representation(self, numPrevCells:int) -> int
        C++: int initialize_faces_representation(IdType numPrevCells)
        Special function used by UnstructuredGridReader. By default
        UnstructuredGrid does not contain face information, which is
        only used by polyhedron cells. If so far no polyhedron cells have
        been added, Faces and face_locations pointers will be nullptr. In
        this case, need to initialize the arrays and assign values to the
        previous non-polyhedron cells.
        """
        ret = self._wrap_call(self._vtk_obj.InitializeFacesRepresentation, *args)
        return ret

    def insert_next_linked_cell(self, *args):
        """
        insert_next_linked_cell(self, type:int, npts:int, pts:(int, ...))
            -> int
        C++: IdType insert_next_linked_cell(int type, int npts,
            const IdType pts[])
        Use these methods only if the dataset has been specified as
        Editable. See PointSet for more information.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextLinkedCell, *args)
        return ret

    def is_cell_boundary(self, *args):
        """
        is_cell_boundary(self, cellId:int, npts:int, ptIds:(int, ...))
            -> bool
        C++: bool is_cell_boundary(IdType cellId, IdType npts,
            const IdType *ptIds)
        A topological inquiry to determine whether a topological entity
        (e.g., point, edge, or face) defined by the point ids (ptIds of
        length npts) is a boundary entity of a specified cell (indicated
        by cellId). A boundary entity is a topological feature used by
        exactly one cell. This method is related to get_cell_neighbors()
        except that it simply indicates whether a topological feature is
        boundary - hence the method is faster.  THIS METHOD IS THREAD
        SAFE IF FIRST CALLED FROM A SINGLE THREAD AND THE DATASET IS NOT
        MODIFIED.
        """
        ret = self._wrap_call(self._vtk_obj.IsCellBoundary, *args)
        return ret

    def remove_ghost_cells(self):
        """
        remove_ghost_cells(self) -> None
        C++: void remove_ghost_cells()
        This method will remove any cell that is marked as ghost (has the
        DataSetAttributes::DUPLICATECELL or the
        DataSetAttributes::HIDDENCELL bit set).
        """
        ret = self._vtk_obj.RemoveGhostCells()
        return ret
        

    def remove_reference_to_cell(self, *args):
        """
        remove_reference_to_cell(self, ptId:int, cellId:int) -> None
        C++: void remove_reference_to_cell(IdType ptId, IdType cellId)"""
        ret = self._wrap_call(self._vtk_obj.RemoveReferenceToCell, *args)
        return ret

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Standard DataSet methods; see DataSet.h for documentation.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def resize_cell_list(self, *args):
        """
        resize_cell_list(self, ptId:int, size:int) -> None
        C++: void resize_cell_list(IdType ptId, int size)"""
        ret = self._wrap_call(self._vtk_obj.ResizeCellList, *args)
        return ret

    _updateable_traits_ = \
    (('editable', 'GetEditable'), ('global_release_data_flag',
    'GetGlobalReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'editable', 'global_release_data_flag',
    'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(UnstructuredGrid, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['editable', 'global_release_data_flag'], [], []),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit UnstructuredGrid properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

