# implementation.bash
# This is mirrorrib, by Thaddeus H. Black <thb@debian.org>
# mirrorrib: MIRROR Release Including Backports, ...
#   ... to assemble a Debian repository for local use
#
# This Bash shell script implements mirrorrib(1).
#
# One can invoke this Bash shell script directly. However, the script is
# intended as an implementational script, invoked not directly but via a
# launcher. The launcher scrubs the process environment and suppresses
# local Bash configuration before launching the implementation.

# Set shell options.
set -efu # the caller will probably have set these, but this ensures it
shopt -s extglob

# Let these parameters carry through to, and be available to, the
# entire program.
readonly COMPRESS_EXT='xz|bz2|gz'
readonly LIB_DIR=$(realpath -e --\
 "$(dirname -- "$(realpath -e -- "$0")")/..")
readonly SCRIPT_DIR="$LIB_DIR/scripts"
readonly LIST_DIR="$LIB_DIR/lists"
readonly RC_DIR="$LIB_DIR/../../../etc"
readonly CALLERS_DIR=$PWD

# Execute the program, script by script, in sequence.
. "$SCRIPT_DIR/01configuration.bash"
. "$SCRIPT_DIR/03pre-initialization.bash"
. "$SCRIPT_DIR/05option-processing.bash"
. "$SCRIPT_DIR/07initialization.bash"
. "$SCRIPT_DIR/10function-definitions.bash"
. "$SCRIPT_DIR/11filter-definitions.bash"
. "$SCRIPT_DIR/12stamp-definitions.bash"
. "$SCRIPT_DIR/14net-definitions.bash"
. "$SCRIPT_DIR/15recursive-fetcher.bash"
. "$SCRIPT_DIR/20phase-a.bash"  # check that mirrors are functioning
. "$SCRIPT_DIR/30phase-b.bash"  # determine the snapshot date to use
# -------------------------------------------------------------------------
# The next two scripts are the program's heart.
# -------------------------------------------------------------------------
. "$SCRIPT_DIR/40phase-cd.bash" # fetch (c) dist-root and (d) per-area
. "$SCRIPT_DIR/60phase-e.bash"  # fetch pool files
# -------------------------------------------------------------------------
. "$SCRIPT_DIR/70phase-f.bash"  # fetch iso cd boot files
. "$SCRIPT_DIR/80phase-g.bash"  # install the regular repository, et al.
. "$SCRIPT_DIR/90conclusion.bash"
exit 0
# (End of program. Notes follow.)

# ORGANIZATION
#
# Bash affords little in the way of facilities to enforce modularization,
# so each script sourced above begins with a comment that explains the
# script's data productions to the rest of the program.
#
# IMPLEMENTATION NOTES
#
# If the program were much longer, the lack of proper modularization might
# begin to grow uncomfortable. It isn't all Bash's fault: the maintainer
# has not yet done everything he could do to maximize modularization
# within Bash's capabilities.
#
# The several files into which the program has been split have been roughly
# planned with greater future modularization in mind, though. As long as
# one does not unrealistically expect a collection of shell scripts like
# this program's to achieve the level of organization of (say) a C++
# source, each script ought to make a more or less reasonable module -- if
# future development should find further modularization sufficiently
# desirable to justify the effort.
#
# Meanwhile, instances of shell-variable and data-file carry-through from
# one script to another have been commented in the scripts to the extent to
# which the necessity for a comment has come to the maintainer's attention.

