// Copyright 2020 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Anatolian_Hieroglyphs`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v13.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x014400, 0x014646]
  ]
});
testPropertyEscapes(
  /^\p{Script=Anatolian_Hieroglyphs}+$/u,
  matchSymbols,
  "\\p{Script=Anatolian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\p{Script=Hluw}+$/u,
  matchSymbols,
  "\\p{Script=Hluw}"
);
testPropertyEscapes(
  /^\p{sc=Anatolian_Hieroglyphs}+$/u,
  matchSymbols,
  "\\p{sc=Anatolian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\p{sc=Hluw}+$/u,
  matchSymbols,
  "\\p{sc=Hluw}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x0143FF],
    [0x014647, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Anatolian_Hieroglyphs}+$/u,
  nonMatchSymbols,
  "\\P{Script=Anatolian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\P{Script=Hluw}+$/u,
  nonMatchSymbols,
  "\\P{Script=Hluw}"
);
testPropertyEscapes(
  /^\P{sc=Anatolian_Hieroglyphs}+$/u,
  nonMatchSymbols,
  "\\P{sc=Anatolian_Hieroglyphs}"
);
testPropertyEscapes(
  /^\P{sc=Hluw}+$/u,
  nonMatchSymbols,
  "\\P{sc=Hluw}"
);

reportCompare(0, 0);
