/* $Id: Entrez2_id_list.cpp 645580 2022-02-17 19:34:11Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'entrez2.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/entrez2/Entrez2_id_list.hpp>

#include <corelib/ncbi_safe_static.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

const size_t CEntrez2_id_list::sm_UidSize = sizeof(CEntrez2_id_list::TUid); // bytes
CSafeStatic<CEntrez2_id_list::TUids> s_EmptyList;


CEntrez2_id_list::TUidIterator CEntrez2_id_list::GetUidIterator()
{
    x_SetNativeUidSize();
    return TUidIterator(SetUids(), GetUidSizeBits());
}


CEntrez2_id_list::TConstUidIterator
CEntrez2_id_list::GetConstUidIterator() const
{
    if (CanGetUids()) {
        return TConstUidIterator(GetUids(), GetUidSizeBits());
    } else {
        return TConstUidIterator(s_EmptyList.Get(), GetUidSizeBits());
    }
}


// destructor
CEntrez2_id_list::~CEntrez2_id_list(void)
{
}


void CEntrez2_id_list::Resize(size_t size)
{
    x_SetNativeUidSize();
    SetUids().resize(size * sizeof(TUid));
    SetNum(size);
}


void CEntrez2_id_list::AssignUids(const vector<TUid>& uids)
{
    Resize(uids.size());

    TUidIterator it = GetUidIterator();
    ITERATE (vector<TUid>, iter, uids) {
        *it++ = *iter;
    }
}


size_t CEntrez2_id_list::GetUidSizeBits(void) const
{
    return GetUidSizeBytes() * 8;
}


size_t CEntrez2_id_list::GetUidSizeBytes(void) const
{
    // Max size - actual size of TUid
    size_t ret = sizeof(TUid);
    if ( !CanGetUids()  ||  !CanGetNum() ) return ret;
    // Min size - 4 bytes (legacy int TUid)
    while ( ret > 4  &&  ret * GetNum() > GetUids().size() ) ret /= 2;
    return ret;
}


void CEntrez2_id_list::PackUids(void)
{
    if ( !CanGetNum()  ||  !CanGetUids() ) return;
    size_t num = GetNum();
    vector<TUid> uids;
    uids.reserve(num);
    for (TConstUidIterator it = GetConstUidIterator(); !it.AtEnd(); ++it) {
        uids.push_back(*it);
        if (uids.back() > kMax_UI4) return;
    }
    SetUids().resize(num * sizeof(Int4));
    auto it = TUidIterator(SetUids(), sizeof(Int4)*8);
    ITERATE (vector<TUid>, iter, uids) {
        *it++ = *iter;
    }
}


void CEntrez2_id_list::x_SetNativeUidSize(void)
{
    // If using non-native UID size, always switch to the native one on modification.
    if ( GetUidSizeBytes() == sizeof(TUid) ) return;
    vector<TUid> uids;
    uids.reserve(GetNum());
    for (TConstUidIterator it = GetConstUidIterator(); !it.AtEnd(); ++it) {
        uids.push_back(*it);
    }
    AssignUids(uids);
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1906, CRC32: 6647067f */
