if (typeof T === 'undefined') require('../setup');

T('absoluteValue', function () {

  function t(expected, value){
    T.assertEqual(expected, new Decimal(value).abs().valueOf());
  }

  Decimal.config({
    precision: 20,
    rounding: 4,
    toExpNeg: -7,
    toExpPos: 21,
    minE: -9e15,
    maxE: 9e15
  });

  t('0', 0);
  t('0', '0');
  t('0', -0);
  t('0', '-0');
  t('1', 1);
  t('1', -1);
  t('1', '-1');
  t('0.5', '0.5');
  t('0.5', '-0.5');
  t('0.1', 0.1);
  t('0.1', -0.1);
  t('1.1', 1.1);
  t('1.1', -1.1);
  t('1.5', '1.5');
  t('1.5', '-1.5');

  t('0.00001', '-1e-5');
  t('9000000000', '-9e9');
  t('123456.7891011', '123456.7891011');
  t('123456.7891011', -123456.7891011);
  t('99', '99');
  t('99', -99);
  t('999.999', 999.999);
  t('999.999', '-999.999');
  t('1', new Decimal(-1));
  t('1', new Decimal('-1'));
  t('0.001', new Decimal(0.001));
  t('0.001', new Decimal('-0.001'));

  t('Infinity', Infinity);
  t('Infinity', -Infinity);
  t('Infinity', 'Infinity');
  t('Infinity', '-Infinity');
  t('NaN', NaN);
  t('NaN', -NaN);
  t('NaN', 'NaN');
  t('NaN', '-NaN');

  t('11.121', '11.121');
  t('0.023842', '-0.023842');
  t('1.19', '-1.19');
  t('9.622e-11', '-0.00000000009622');
  t('5.09e-10', '-0.000000000509');
  t('3838.2', '3838.2');
  t('127', '127.0');
  t('4.23073', '4.23073');
  t('2.5469', '-2.5469');
  t('29949', '-29949');
  t('277.1', '-277.10');
  t('4.97898e-15', '-0.00000000000000497898');
  t('53.456', '53.456');
  t('100564', '-100564');
  t('12431.9', '-12431.9');
  t('97633.7', '-97633.7');
  t('220', '220');
  t('18.72', '18.720');
  t('2817', '-2817');
  t('44535', '-44535');

  Decimal.toExpNeg = Decimal.toExpPos = 0;

  t('5.2452468128e+1', '-5.2452468128e+1');
  t('1.41525905257189365008396e+16', '1.41525905257189365008396e+16');
  t('2.743068083928e+11', '2.743068083928e+11');
  t('1.52993064722314247378724599e+26', '-1.52993064722314247378724599e+26');
  t('3.7205576746e+10', '3.7205576746e+10');
  t('2.663e-10', '-2.663e-10');
  t('1.26574209965030360615518e+17', '-1.26574209965030360615518e+17');
  t('1.052e+3', '1.052e+3');
  t('4.452945872502e+6', '-4.452945872502e+6');
  t('2.95732460816619226e+13', '2.95732460816619226e+13');
  t('1.1923100194288654481424e+18', '-1.1923100194288654481424e+18');
  t('8.99315449050893705e+6', '8.99315449050893705e+6');
  t('5.200726538434486963e+8', '5.200726538434486963e+8');
  t('1.182618278949368566264898065e+18', '1.182618278949368566264898065e+18');
  t('3.815873266712e-20', '-3.815873266712e-20');
  t('1.316675370382742615e+6', '-1.316675370382742615e+6');
  t('2.1032502e+6', '-2.1032502e+6');
  t('1.8e+1', '1.8e+1');
  t('1.033525906631680944018544811261e-13', '1.033525906631680944018544811261e-13');
  t('1.102361746443461856816e+14', '-1.102361746443461856816e+14');
  t('8.595358491143959e+1', '8.595358491143959e+1');
  t('1.226806049797304683867e-18', '1.226806049797304683867e-18');
  t('5e+0', '-5e+0');
  t('1.091168788407093537887970016e+15', '-1.091168788407093537887970016e+15');
  t('3.87166413612272027e+12', '3.87166413612272027e+12');
  t('1.411514e+5', '1.411514e+5');
  t('1.0053454672509859631996e+22', '1.0053454672509859631996e+22');
  t('6.9265714e+0', '6.9265714e+0');
  t('1.04627709e+4', '1.04627709e+4');
  t('2.285650225267766689304972e+5', '2.285650225267766689304972e+5');
  t('4.5790517211306242e+7', '4.5790517211306242e+7');
  t('3.0033340092338313923473428e+16', '-3.0033340092338313923473428e+16');
  t('2.83879929283797623e+1', '-2.83879929283797623e+1');
  t('4.5266377717178121183759377414e-5', '4.5266377717178121183759377414e-5');
  t('5.3781e+4', '-5.3781e+4');
  t('6.722035208213298413522819127e-18', '-6.722035208213298413522819127e-18');
  t('3.02865707828281230987116e+23', '-3.02865707828281230987116e+23');

  t('1e-9000000000000000', '1e-9000000000000000');
  t('1e-9000000000000000', '-1e-9000000000000000');
  t('0e+0', '-9.9e-9000000000000001');
  t('9.999999e+9000000000000000', '9.999999e+9000000000000000');
  t('9.999999e+9000000000000000', '-9.999999e+9000000000000000');
  t('Infinity', '1E9000000000000001');
  t('Infinity', '-1e+9000000000000001');
  t('5.5879983320336874473209567979e+287894365', '-5.5879983320336874473209567979e+287894365');
});
