#/
# @license Apache-2.0
#
# Copyright (c) 2017 The Stdlib Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#/

# VARIABLES #

# Define the path to the [plato][1] executable.
#
# To install plato:
#
# ```bash
# $ npm install plato
# ```
#
# [1]: https://github.com/es-analysis/plato
PLATO ?= $(BIN_DIR)/plato

# Define the command for determining JavaScript code complexity:
JAVASCRIPT_COMPLEXITY ?= $(PLATO)

# Define the title of the report:
PLATO_REPORT_TITLE ?= 'JavaScript Complexity'

# Define the output file path for the HTML report generated by plato:
PLATO_HTML_REPORT ?= $(JAVASCRIPT_COMPLEXITY_OUT)/index.html

# Define the command-line options to use when invoking the plato executable:
JAVASCRIPT_COMPLEXITY_FLAGS ?= \
	--dir $(JAVASCRIPT_COMPLEXITY_OUT) \
	--title $(PLATO_REPORT_TITLE)


# RULES #

# View a complexity report.
#
# This target opens an HTML complexity report in a local web browser.

view-plato-report:
	$(QUIET) $(OPEN) $(PLATO_HTML_REPORT)

.PHONY: view-plato-report
